/*
 * Decompiled with CFR 0.152.
 */
package com.android.apksig;

import com.android.apksig.kms.KmsType;
import java.security.PrivateKey;
import java.util.function.Function;

public abstract class KeyConfig {
    private KeyConfig() {
    }

    public abstract <T> T match(Function<Jca, T> var1, Function<Kms, T> var2);

    public static class Kms
    extends KeyConfig {
        public final KmsType kmsType;
        public final String keyAlias;

        @Override
        public <T> T match(Function<Jca, T> jca, Function<Kms, T> kms) {
            return kms.apply(this);
        }

        public Kms(KmsType kmsType, String keyAlias) {
            this.kmsType = kmsType;
            this.keyAlias = keyAlias;
        }
    }

    public static class Jca
    extends KeyConfig {
        public final PrivateKey privateKey;

        @Override
        public <T> T match(Function<Jca, T> jca, Function<Kms, T> kms) {
            return jca.apply(this);
        }

        public Jca(PrivateKey privateKey) {
            this.privateKey = privateKey;
        }
    }
}

