/*
 * Decompiled with CFR 0.152.
 */
package org.conscrypt;

public final class HpkeSuite {
    public static final int KEM_DHKEM_X25519_HKDF_SHA256 = 32;
    public static final int KDF_HKDF_SHA256 = 1;
    public static final int AEAD_AES_128_GCM = 1;
    public static final int AEAD_AES_256_GCM = 2;
    public static final int AEAD_CHACHA20POLY1305 = 3;
    private final KEM mKem;
    private final KDF mKdf;
    private final AEAD mAead;

    public HpkeSuite(int kem, int kdf, int aead) {
        this.mKem = KEM.forId(kem);
        this.mKdf = KDF.forId(kdf);
        this.mAead = AEAD.forId(aead);
    }

    public String name() {
        return String.format("%s/%s/%s", this.mKem.name(), this.mKdf.name(), this.mAead.name());
    }

    public KEM getKem() {
        return this.mKem;
    }

    public KDF getKdf() {
        return this.mKdf;
    }

    public AEAD getAead() {
        return this.mAead;
    }

    @Deprecated
    public KEM convertKem(int kem) {
        return KEM.forId(kem);
    }

    @Deprecated
    public KDF convertKdf(int kdf) {
        return KDF.forId(kdf);
    }

    @Deprecated
    public AEAD convertAead(int aead) {
        return AEAD.forId(aead);
    }

    public static enum KEM {
        DHKEM_X25519_HKDF_SHA256(32, 32, 32, 32, 32);

        private final int id;
        private final int nSecret;
        private final int nEnc;
        private final int nPk;
        private final int nSk;

        private KEM(int id, int nSecret, int nEnc, int nPk, int nSk) {
            this.id = id;
            this.nSecret = nSecret;
            this.nEnc = nEnc;
            this.nPk = nPk;
            this.nSk = nSk;
        }

        public int getId() {
            return this.id;
        }

        @Deprecated
        public int getnEnc() {
            return this.getEncapsulatedLength();
        }

        public int getEncapsulatedLength() {
            return this.nEnc;
        }

        public int getSecretLength() {
            return this.nSecret;
        }

        public int getPublicKeyLength() {
            return this.nPk;
        }

        public int getPrivateKeyLength() {
            return this.nSk;
        }

        public static KEM forId(int id) {
            for (KEM kem : KEM.values()) {
                if (kem.getId() != id) continue;
                return kem;
            }
            throw new IllegalArgumentException("Unknown KEM " + id);
        }
    }

    public static enum KDF {
        HKDF_SHA256(1, 32, "HmacSHA256");

        private final int id;
        private final int hLength;
        private final String hName;

        private KDF(int id, int hLength, String hName) {
            this.id = id;
            this.hLength = hLength;
            this.hName = hName;
        }

        public int getId() {
            return this.id;
        }

        public int getMacLength() {
            return this.hLength;
        }

        @Deprecated
        public int getHLength() {
            return this.getMacLength();
        }

        public long maxExportLength() {
            return (long)this.getMacLength() * 255L;
        }

        @Deprecated
        public String getMacAlgorithmName() {
            return this.getMacName();
        }

        public String getMacName() {
            return this.hName;
        }

        public static KDF forId(int id) {
            for (KDF kdf : KDF.values()) {
                if (kdf.getId() != id) continue;
                return kdf;
            }
            throw new IllegalArgumentException("Unknown KDF " + id);
        }
    }

    public static enum AEAD {
        AES_128_GCM(1, 16, 12, 16),
        AES_256_GCM(2, 32, 12, 16),
        CHACHA20POLY1305(3, 32, 12, 16);

        private final int id;
        private final int nk;
        private final int nn;
        private final int nt;

        private AEAD(int id, int nk, int nn, int nt) {
            this.id = id;
            this.nk = nk;
            this.nn = nn;
            this.nt = nt;
        }

        public int getId() {
            return this.id;
        }

        @Deprecated
        public int getNk() {
            return this.getKeyLength();
        }

        public int getKeyLength() {
            return this.nk;
        }

        @Deprecated
        public int getNn() {
            return this.getNonceLength();
        }

        public int getNonceLength() {
            return this.nn;
        }

        @Deprecated
        public int getNt() {
            return this.nt;
        }

        public int getTagLength() {
            return this.nt;
        }

        public static AEAD forId(int id) {
            for (AEAD aead : AEAD.values()) {
                if (aead.getId() != id) continue;
                return aead;
            }
            throw new IllegalArgumentException("Unknown AEAD " + id);
        }
    }
}

