/*
 * Copyright (C) 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package android.federatedcompute.common;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.os.Parcelable;

import com.android.internal.util.Preconditions;
import com.android.ondevicepersonalization.internal.util.AnnotationValidations;
import com.android.ondevicepersonalization.internal.util.DataClass;

/**
 * A container for information regarding an example store access, including the collection name, the
 * selection criteria and the number of examples which has been used.
 *
 * @hide
 */
@DataClass(genBuilder = true, genEqualsHashCode = true)
public class ExampleConsumption implements Parcelable {
    @NonNull private final String mCollectionName;

    @NonNull private final byte[] mSelectionCriteria;

    private final int mExampleCount;

    @Nullable private final byte[] mResumptionToken;

    // Code below generated by codegen v1.0.23.
    //
    // DO NOT MODIFY!
    // CHECKSTYLE:OFF Generated code
    //
    // To regenerate run:
    // $ codegen
    // $ANDROID_BUILD_TOP/packages/modules/OnDevicePersonalization/framework/java/android/federatedcompute/common/ExampleConsumption.java
    //
    // To exclude the generated code from IntelliJ auto-formatting enable (one-time):
    //   Settings > Editor > Code Style > Formatter Control
    // @formatter:off

    @DataClass.Generated.Member
    /* package-private */ ExampleConsumption(
            @NonNull String collectionName,
            @NonNull byte[] selectionCriteria,
            int exampleCount,
            @Nullable byte[] resumptionToken) {
        this.mCollectionName = collectionName;
        AnnotationValidations.validate(NonNull.class, null, mCollectionName);
        this.mSelectionCriteria = selectionCriteria;
        AnnotationValidations.validate(NonNull.class, null, mSelectionCriteria);
        this.mExampleCount = exampleCount;
        this.mResumptionToken = resumptionToken;

        // onConstructed(); // You can define this method to get a callback
    }

    @DataClass.Generated.Member
    public @NonNull String getCollectionName() {
        return mCollectionName;
    }

    @DataClass.Generated.Member
    public @NonNull byte[] getSelectionCriteria() {
        return mSelectionCriteria;
    }

    @DataClass.Generated.Member
    public int getExampleCount() {
        return mExampleCount;
    }

    @DataClass.Generated.Member
    public @Nullable byte[] getResumptionToken() {
        return mResumptionToken;
    }

    @Override
    @DataClass.Generated.Member
    public boolean equals(@Nullable Object o) {
        // You can override field equality logic by defining either of the methods like:
        // boolean fieldNameEquals(ExampleConsumption other) { ... }
        // boolean fieldNameEquals(FieldType otherValue) { ... }

        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        @SuppressWarnings("unchecked")
        ExampleConsumption that = (ExampleConsumption) o;
        //noinspection PointlessBooleanExpression
        return true
                && java.util.Objects.equals(mCollectionName, that.mCollectionName)
                && java.util.Arrays.equals(mSelectionCriteria, that.mSelectionCriteria)
                && mExampleCount == that.mExampleCount
                && java.util.Arrays.equals(mResumptionToken, that.mResumptionToken);
    }

    @Override
    @DataClass.Generated.Member
    public int hashCode() {
        // You can override field hashCode logic by defining methods like:
        // int fieldNameHashCode() { ... }

        int _hash = 1;
        _hash = 31 * _hash + java.util.Objects.hashCode(mCollectionName);
        _hash = 31 * _hash + java.util.Arrays.hashCode(mSelectionCriteria);
        _hash = 31 * _hash + mExampleCount;
        _hash = 31 * _hash + java.util.Arrays.hashCode(mResumptionToken);
        return _hash;
    }

    @Override
    @DataClass.Generated.Member
    public void writeToParcel(@NonNull android.os.Parcel dest, int flags) {
        // You can override field parcelling by defining methods like:
        // void parcelFieldName(Parcel dest, int flags) { ... }

        byte flg = 0;
        if (mResumptionToken != null) flg |= 0x8;
        dest.writeByte(flg);
        dest.writeString(mCollectionName);
        dest.writeByteArray(mSelectionCriteria);
        dest.writeInt(mExampleCount);
        if (mResumptionToken != null) dest.writeByteArray(mResumptionToken);
    }

    @Override
    @DataClass.Generated.Member
    public int describeContents() {
        return 0;
    }

    /** @hide */
    @SuppressWarnings({"unchecked", "RedundantCast"})
    @DataClass.Generated.Member
    protected ExampleConsumption(@NonNull android.os.Parcel in) {
        // You can override field unparcelling by defining methods like:
        // static FieldType unparcelFieldName(Parcel in) { ... }

        byte flg = in.readByte();
        String collectionName = in.readString();
        byte[] selectionCriteria = in.createByteArray();
        int exampleCount = in.readInt();
        byte[] resumptionToken = (flg & 0x8) == 0 ? null : in.createByteArray();

        this.mCollectionName = collectionName;
        AnnotationValidations.validate(NonNull.class, null, mCollectionName);
        this.mSelectionCriteria = selectionCriteria;
        AnnotationValidations.validate(NonNull.class, null, mSelectionCriteria);
        this.mExampleCount = exampleCount;
        this.mResumptionToken = resumptionToken;

        // onConstructed(); // You can define this method to get a callback
    }

    @DataClass.Generated.Member
    public static final @NonNull Parcelable.Creator<ExampleConsumption> CREATOR =
            new Parcelable.Creator<ExampleConsumption>() {
                @Override
                public ExampleConsumption[] newArray(int size) {
                    return new ExampleConsumption[size];
                }

                @Override
                public ExampleConsumption createFromParcel(@NonNull android.os.Parcel in) {
                    return new ExampleConsumption(in);
                }
            };

    /** A builder for {@link ExampleConsumption} */
    @SuppressWarnings("WeakerAccess")
    @DataClass.Generated.Member
    public static class Builder {

        private @NonNull String mCollectionName;
        private @NonNull byte[] mSelectionCriteria;
        private int mExampleCount;
        private @Nullable byte[] mResumptionToken;

        private long mBuilderFieldsSet = 0L;

        public Builder() {}

        @DataClass.Generated.Member
        public @NonNull Builder setCollectionName(@NonNull String value) {
            checkNotUsed();
            Preconditions.checkStringNotEmpty(value);
            mBuilderFieldsSet |= 0x1;
            mCollectionName = value;
            return this;
        }

        @DataClass.Generated.Member
        public @NonNull Builder setSelectionCriteria(@NonNull byte... value) {
            checkNotUsed();
            mBuilderFieldsSet |= 0x2;
            mSelectionCriteria = value;
            return this;
        }

        @DataClass.Generated.Member
        public @NonNull Builder setExampleCount(int value) {
            checkNotUsed();
            mBuilderFieldsSet |= 0x4;
            mExampleCount = value;
            return this;
        }

        @DataClass.Generated.Member
        public @NonNull Builder setResumptionToken(@NonNull byte... value) {
            checkNotUsed();
            mBuilderFieldsSet |= 0x8;
            mResumptionToken = value;
            return this;
        }

        /** Builds the instance. This builder should not be touched after calling this! */
        public @NonNull ExampleConsumption build() {
            checkNotUsed();
            mBuilderFieldsSet |= 0x10; // Mark builder used

            ExampleConsumption o =
                    new ExampleConsumption(
                            mCollectionName, mSelectionCriteria, mExampleCount, mResumptionToken);
            return o;
        }

        private void checkNotUsed() {
            if ((mBuilderFieldsSet & 0x10) != 0) {
                throw new IllegalStateException(
                        "This Builder should not be reused. Use a new Builder instance instead");
            }
        }
    }

    // @formatter:on
    // End of generated code

}
