/*
 * Copyright (C) 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package android.federatedcompute.common;

import android.annotation.NonNull;

import com.android.ondevicepersonalization.internal.util.AnnotationValidations;
import com.android.ondevicepersonalization.internal.util.DataClass;

/**
 * The request to schedule federated computation job.
 *
 * @hide
 */
@DataClass(genBuilder = true, genEqualsHashCode = true)
public class ScheduleFederatedComputeRequest {
    @NonNull private final TrainingOptions mTrainingOptions;

    // Code below generated by codegen v1.0.23.
    //
    // DO NOT MODIFY!
    // CHECKSTYLE:OFF Generated code
    //
    // To regenerate run:
    // $ codegen
    // $ANDROID_BUILD_TOP/packages/modules/OnDevicePersonalization/framework/java/android/ondevicepersonalization/federatedcompute/ScheduleFederatedComputeRequest.java
    //
    // To exclude the generated code from IntelliJ auto-formatting enable (one-time):
    //   Settings > Editor > Code Style > Formatter Control
    // @formatter:off

    @DataClass.Generated.Member
    /* package-private */ ScheduleFederatedComputeRequest(
            @NonNull TrainingOptions trainingOptions) {
        this.mTrainingOptions = trainingOptions;
        AnnotationValidations.validate(NonNull.class, null, mTrainingOptions);

        // onConstructed(); // You can define this method to get a callback
    }

    @DataClass.Generated.Member
    public @NonNull TrainingOptions getTrainingOptions() {
        return mTrainingOptions;
    }

    @Override
    @DataClass.Generated.Member
    public boolean equals(@android.annotation.Nullable Object o) {
        // You can override field equality logic by defining either of the methods like:
        // boolean fieldNameEquals(ScheduleFederatedComputeRequest other) { ... }
        // boolean fieldNameEquals(FieldType otherValue) { ... }

        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        @SuppressWarnings("unchecked")
        ScheduleFederatedComputeRequest that = (ScheduleFederatedComputeRequest) o;
        //noinspection PointlessBooleanExpression
        return true && java.util.Objects.equals(mTrainingOptions, that.mTrainingOptions);
    }

    @Override
    @DataClass.Generated.Member
    public int hashCode() {
        // You can override field hashCode logic by defining methods like:
        // int fieldNameHashCode() { ... }

        int _hash = 1;
        _hash = 31 * _hash + java.util.Objects.hashCode(mTrainingOptions);
        return _hash;
    }

    /** A builder for {@link ScheduleFederatedComputeRequest} */
    @SuppressWarnings("WeakerAccess")
    @DataClass.Generated.Member
    public static class Builder {

        private @NonNull TrainingOptions mTrainingOptions;

        private long mBuilderFieldsSet = 0L;

        public Builder() {}

        @DataClass.Generated.Member
        public @NonNull Builder setTrainingOptions(@NonNull TrainingOptions value) {
            checkNotUsed();
            mBuilderFieldsSet |= 0x1;
            mTrainingOptions = value;
            return this;
        }

        /** Builds the instance. This builder should not be touched after calling this! */
        public @NonNull ScheduleFederatedComputeRequest build() {
            checkNotUsed();
            mBuilderFieldsSet |= 0x2; // Mark builder used

            ScheduleFederatedComputeRequest o =
                    new ScheduleFederatedComputeRequest(mTrainingOptions);
            return o;
        }

        private void checkNotUsed() {
            if ((mBuilderFieldsSet & 0x2) != 0) {
                throw new IllegalStateException(
                        "This Builder should not be reused. Use a new Builder instance instead");
            }
        }
    }

    // @formatter:on
    // End of generated code

}
