/*
 * Copyright (C) 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package android.federatedcompute.common;

import android.annotation.Nullable;
import android.os.Parcelable;

import com.android.internal.util.Preconditions;
import com.android.ondevicepersonalization.internal.util.DataClass;

/**
 * Training interval settings.
 *
 * @hide
 */
@DataClass(genBuilder = true, genEqualsHashCode = true)
public final class TrainingInterval implements Parcelable {
    /**
     * The scheduling modes for a task. Recurrent tasks will be rescheduled after each run. One-off
     * task will not be rescheduled if the task succeeds.
     */
    public static final int SCHEDULING_MODE_RECURRENT = 1;

    public static final int SCHEDULING_MODE_ONE_TIME = 2;

    @SchedulingMode private int mSchedulingMode;

    private long mMinimumIntervalMillis = 0L;

    // Code below generated by codegen v1.0.23.
    //
    // DO NOT MODIFY!
    // CHECKSTYLE:OFF Generated code
    //
    // To regenerate run:
    // $ codegen
    // $ANDROID_BUILD_TOP/packages/modules/OnDevicePersonalization/framework/java/android/ondevicepersonalization/federatedcompute/TrainingInterval.java
    //
    // To exclude the generated code from IntelliJ auto-formatting enable (one-time):
    //   Settings > Editor > Code Style > Formatter Control
    // @formatter:off

    @android.annotation.IntDef(
            prefix = "SCHEDULING_MODE_",
            value = {SCHEDULING_MODE_RECURRENT, SCHEDULING_MODE_ONE_TIME})
    @java.lang.annotation.Retention(java.lang.annotation.RetentionPolicy.SOURCE)
    @DataClass.Generated.Member
    public @interface SchedulingMode {}

    @DataClass.Generated.Member
    public static String schedulingModeToString(@SchedulingMode int value) {
        switch (value) {
            case SCHEDULING_MODE_RECURRENT:
                return "SCHEDULING_MODE_RECURRENT";
            case SCHEDULING_MODE_ONE_TIME:
                return "SCHEDULING_MODE_ONE_TIME";
            default:
                return Integer.toHexString(value);
        }
    }

    @DataClass.Generated.Member
    /* package-private */ TrainingInterval(
            @SchedulingMode int schedulingMode, long minimumIntervalMillis) {
        this.mSchedulingMode = schedulingMode;

        if (!(mSchedulingMode == SCHEDULING_MODE_RECURRENT)
                && !(mSchedulingMode == SCHEDULING_MODE_ONE_TIME)) {
            throw new java.lang.IllegalArgumentException(
                    "schedulingMode was "
                            + mSchedulingMode
                            + " but must be one of: "
                            + "SCHEDULING_MODE_RECURRENT("
                            + SCHEDULING_MODE_RECURRENT
                            + "), "
                            + "SCHEDULING_MODE_ONE_TIME("
                            + SCHEDULING_MODE_ONE_TIME
                            + ")");
        }
        Preconditions.checkArgument(
                schedulingMode != SCHEDULING_MODE_RECURRENT || minimumIntervalMillis > 0,
                "Recurrent jobs cannot have non-positive minimal interval.");

        this.mMinimumIntervalMillis = minimumIntervalMillis;

        // onConstructed(); // You can define this method to get a callback
    }

    @DataClass.Generated.Member
    public @SchedulingMode int getSchedulingMode() {
        return mSchedulingMode;
    }

    @DataClass.Generated.Member
    public long getMinimumIntervalMillis() {
        return mMinimumIntervalMillis;
    }

    @Override
    @DataClass.Generated.Member
    public boolean equals(@Nullable Object o) {
        // You can override field equality logic by defining either of the methods like:
        // boolean fieldNameEquals(TrainingInterval other) { ... }
        // boolean fieldNameEquals(FieldType otherValue) { ... }

        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        @SuppressWarnings("unchecked")
        TrainingInterval that = (TrainingInterval) o;
        //noinspection PointlessBooleanExpression
        return true
                && mSchedulingMode == that.mSchedulingMode
                && mMinimumIntervalMillis == that.mMinimumIntervalMillis;
    }

    @Override
    @DataClass.Generated.Member
    public int hashCode() {
        // You can override field hashCode logic by defining methods like:
        // int fieldNameHashCode() { ... }

        int _hash = 1;
        _hash = 31 * _hash + mSchedulingMode;
        _hash = 31 * _hash + Long.hashCode(mMinimumIntervalMillis);
        return _hash;
    }

    @Override
    @DataClass.Generated.Member
    public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) {
        // You can override field parcelling by defining methods like:
        // void parcelFieldName(Parcel dest, int flags) { ... }

        dest.writeInt(mSchedulingMode);
        dest.writeLong(mMinimumIntervalMillis);
    }

    @Override
    @DataClass.Generated.Member
    public int describeContents() {
        return 0;
    }

    /** @hide */
    @SuppressWarnings({"unchecked", "RedundantCast"})
    @DataClass.Generated.Member
    /* package-private */ TrainingInterval(@android.annotation.NonNull android.os.Parcel in) {
        // You can override field unparcelling by defining methods like:
        // static FieldType unparcelFieldName(Parcel in) { ... }

        int schedulingMode = in.readInt();
        long minimumIntervalMillis = in.readLong();

        this.mSchedulingMode = schedulingMode;

        if (!(mSchedulingMode == SCHEDULING_MODE_RECURRENT)
                && !(mSchedulingMode == SCHEDULING_MODE_ONE_TIME)) {
            throw new java.lang.IllegalArgumentException(
                    "schedulingMode was "
                            + mSchedulingMode
                            + " but must be one of: "
                            + "SCHEDULING_MODE_RECURRENT("
                            + SCHEDULING_MODE_RECURRENT
                            + "), "
                            + "SCHEDULING_MODE_ONE_TIME("
                            + SCHEDULING_MODE_ONE_TIME
                            + ")");
        }

        this.mMinimumIntervalMillis = minimumIntervalMillis;

        // onConstructed(); // You can define this method to get a callback
    }

    @DataClass.Generated.Member
    public static final @android.annotation.NonNull Parcelable.Creator<TrainingInterval> CREATOR =
            new Parcelable.Creator<TrainingInterval>() {
                @Override
                public TrainingInterval[] newArray(int size) {
                    return new TrainingInterval[size];
                }

                @Override
                public TrainingInterval createFromParcel(
                        @android.annotation.NonNull android.os.Parcel in) {
                    return new TrainingInterval(in);
                }
            };

    /** A builder for {@link TrainingInterval} */
    @SuppressWarnings("WeakerAccess")
    @DataClass.Generated.Member
    public static final class Builder {

        private @SchedulingMode int mSchedulingMode;
        private long mMinimumIntervalMillis;

        private long mBuilderFieldsSet = 0L;

        public Builder() {}

        @DataClass.Generated.Member
        public @android.annotation.NonNull Builder setSchedulingMode(@SchedulingMode int value) {
            checkNotUsed();
            mBuilderFieldsSet |= 0x1;
            mSchedulingMode = value;
            return this;
        }

        @DataClass.Generated.Member
        public @android.annotation.NonNull Builder setMinimumIntervalMillis(long value) {
            checkNotUsed();
            mBuilderFieldsSet |= 0x2;
            mMinimumIntervalMillis = value;
            return this;
        }

        /** Builds the instance. This builder should not be touched after calling this! */
        public @android.annotation.NonNull TrainingInterval build() {
            checkNotUsed();
            mBuilderFieldsSet |= 0x4; // Mark builder used

            if ((mBuilderFieldsSet & 0x2) == 0) {
                mMinimumIntervalMillis = 0L;
            }
            TrainingInterval o = new TrainingInterval(mSchedulingMode, mMinimumIntervalMillis);
            return o;
        }

        private void checkNotUsed() {
            if ((mBuilderFieldsSet & 0x4) != 0) {
                throw new IllegalStateException(
                        "This Builder should not be reused. Use a new Builder instance instead");
            }
        }
    }

    // @formatter:on
    // End of generated code

}
