/* GENERATED SOURCE. DO NOT MODIFY. */
/*
 * Copyright (C) 2017 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package android.icu.platform;

import java.util.ArrayList;
import java.util.List;

/**
 * Android-added: Used by {@link android.icu.impl.ICUBinary} to locate ICU data files.
 * The paths to ICU data files are generated dynamically from environment variables because
 * the paths are different in various test environments. Thus, the paths can't be generated into
 * ICUConfig.properties in the compile-time, and generated by this class instead.
 *
 * {@link com.android.i18n.timezone.TimeZoneDataFiles} holds the information related to other
 * timezone data files.
 * @hide Only a subset of ICU is exposed in Android
 */
public class AndroidDataFiles {
    /**
     * The below are public to be used by {@link com.android.i18n.timezone.TimeZoneDataFiles}.
     */
    public static final String ANDROID_ROOT_ENV = "ANDROID_ROOT";
    public static final String ANDROID_I18N_ROOT_ENV = "ANDROID_I18N_ROOT";
    public static final String ANDROID_TZDATA_ROOT_ENV = "ANDROID_TZDATA_ROOT";

    // VisibleForTesting
    public static String getTimeZoneModuleIcuFile(String fileName) {
        return getTimeZoneModuleFile("icu/" + fileName);
    }

    private static String getTimeZoneModuleFile(String fileName) {
        return System.getenv(ANDROID_TZDATA_ROOT_ENV) + "/etc/" + fileName;
    }

    // VisibleForTesting
    public static String getI18nModuleIcuFile(String fileName) {
        return getI18nModuleFile("icu/" + fileName);
    }

    private static String getI18nModuleFile(String fileName) {
        return System.getenv(ANDROID_I18N_ROOT_ENV) + "/etc/" + fileName;
    }

    public static String generateIcuDataPath() {
        List<String> paths = new ArrayList<>(3);

        // Note: This logic below should match the logic in IcuRegistration.cpp in external/icu/
        // to ensure consistent behavior between ICU4C and ICU4J.

        // ICU should look for a mounted time zone module file in /apex. This is used for
        // (optional) time zone data that can be updated with an APEX file.
        String timeZoneModuleIcuDataPath = getTimeZoneModuleIcuFile("");
        paths.add(timeZoneModuleIcuDataPath);

        // ICU should always look in the i18n module path as this is where most of the data
        // can be found.
        String i18nModuleIcuDataPath = getI18nModuleIcuFile("");
        paths.add(i18nModuleIcuDataPath);

        return String.join(":", paths);
    }
}
