/*
 * This file is auto-generated.  DO NOT MODIFY.
 */
package android.media;
/**
 * ITranscodingClient
 * 
 * Interface for a client to communicate with MediaTranscodingService.
 * 
 * {@hide}
 */
public interface ITranscodingClient extends android.os.IInterface
{
  /** Default implementation for ITranscodingClient. */
  public static class Default implements android.media.ITranscodingClient
  {
    /**
     * Submits a transcoding request to MediaTranscodingService.
     * 
     * @param request a TranscodingRequest contains transcoding configuration.
     * @param session(output variable) a TranscodingSession generated by MediaTranscodingService.
     * @return true if success, false otherwise.
     */
    @Override public boolean submitRequest(android.media.TranscodingRequestParcel request, android.media.TranscodingSessionParcel session) throws android.os.RemoteException
    {
      return false;
    }
    /**
     * Cancels a transcoding session.
     * 
     * @param sessionId a TranscodingSession generated by the MediaTranscodingService.
     * @return true if succeeds, false otherwise.
     */
    @Override public boolean cancelSession(int sessionId) throws android.os.RemoteException
    {
      return false;
    }
    /**
     * Queries the session detail associated with a sessionId.
     * 
     * @param sessionId a TranscodingSession generated by the MediaTranscodingService.
     * @param session(output variable) the TranscodingSession associated with the sessionId.
     * @return true if succeeds, false otherwise.
     */
    @Override public boolean getSessionWithId(int sessionId, android.media.TranscodingSessionParcel session) throws android.os.RemoteException
    {
      return false;
    }
    /**
     * Add an additional client uid requesting a session.
     * 
     * @sessionId the session id to which to add the additional client uid.
     * @clientUid the additional client uid to be added.
     * @return false if the session doesn't exist or the client is already requesting the
     * session, true otherwise.
     */
    @Override public boolean addClientUid(int sessionId, int clientUid) throws android.os.RemoteException
    {
      return false;
    }
    /**
     * Retrieves the (unsorted) list of all clients requesting a session.
     * 
     * Note that if a session was submitted with offline priority (
     * TranscodingSessionPriority::kUnspecified), it initially will not be considered requested
     * by any particular client, because the client could go away any time after the submission.
     * However, additional uids could be added via addClientUid() after the submission, which
     * essentially make the request a real-time request instead of an offline request.
     * 
     * @sessionId the session id for which to retrieve the client uid list.
     * @clientUids array to hold the retrieved client uid list.
     * @return false if the session doesn't exist, true otherwise.
     */
    @Override public int[] getClientUids(int sessionId) throws android.os.RemoteException
    {
      return null;
    }
    /**
     * Unregister the client with the MediaTranscodingService.
     * 
     * Client will not be able to perform any more transcoding after unregister.
     */
    @Override public void unregister() throws android.os.RemoteException
    {
    }
    @Override
    public android.os.IBinder asBinder() {
      return null;
    }
  }
  /** Local-side IPC implementation stub class. */
  public static abstract class Stub extends android.os.Binder implements android.media.ITranscodingClient
  {
    /** Construct the stub at attach it to the interface. */
    public Stub()
    {
      this.attachInterface(this, DESCRIPTOR);
    }
    /**
     * Cast an IBinder object into an android.media.ITranscodingClient interface,
     * generating a proxy if needed.
     */
    public static android.media.ITranscodingClient asInterface(android.os.IBinder obj)
    {
      if ((obj==null)) {
        return null;
      }
      android.os.IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
      if (((iin!=null)&&(iin instanceof android.media.ITranscodingClient))) {
        return ((android.media.ITranscodingClient)iin);
      }
      return new android.media.ITranscodingClient.Stub.Proxy(obj);
    }
    @Override public android.os.IBinder asBinder()
    {
      return this;
    }
    @Override public boolean onTransact(int code, android.os.Parcel data, android.os.Parcel reply, int flags) throws android.os.RemoteException
    {
      java.lang.String descriptor = DESCRIPTOR;
      if (code >= android.os.IBinder.FIRST_CALL_TRANSACTION && code <= android.os.IBinder.LAST_CALL_TRANSACTION) {
        data.enforceInterface(descriptor);
      }
      switch (code)
      {
        case INTERFACE_TRANSACTION:
        {
          reply.writeString(descriptor);
          return true;
        }
      }
      switch (code)
      {
        case TRANSACTION_submitRequest:
        {
          android.media.TranscodingRequestParcel _arg0;
          _arg0 = data.readTypedObject(android.media.TranscodingRequestParcel.CREATOR);
          android.media.TranscodingSessionParcel _arg1;
          _arg1 = new android.media.TranscodingSessionParcel();
          boolean _result = this.submitRequest(_arg0, _arg1);
          reply.writeNoException();
          reply.writeBoolean(_result);
          reply.writeTypedObject(_arg1, android.os.Parcelable.PARCELABLE_WRITE_RETURN_VALUE);
          break;
        }
        case TRANSACTION_cancelSession:
        {
          int _arg0;
          _arg0 = data.readInt();
          boolean _result = this.cancelSession(_arg0);
          reply.writeNoException();
          reply.writeBoolean(_result);
          break;
        }
        case TRANSACTION_getSessionWithId:
        {
          int _arg0;
          _arg0 = data.readInt();
          android.media.TranscodingSessionParcel _arg1;
          _arg1 = new android.media.TranscodingSessionParcel();
          boolean _result = this.getSessionWithId(_arg0, _arg1);
          reply.writeNoException();
          reply.writeBoolean(_result);
          reply.writeTypedObject(_arg1, android.os.Parcelable.PARCELABLE_WRITE_RETURN_VALUE);
          break;
        }
        case TRANSACTION_addClientUid:
        {
          int _arg0;
          _arg0 = data.readInt();
          int _arg1;
          _arg1 = data.readInt();
          boolean _result = this.addClientUid(_arg0, _arg1);
          reply.writeNoException();
          reply.writeBoolean(_result);
          break;
        }
        case TRANSACTION_getClientUids:
        {
          int _arg0;
          _arg0 = data.readInt();
          int[] _result = this.getClientUids(_arg0);
          reply.writeNoException();
          reply.writeIntArray(_result);
          break;
        }
        case TRANSACTION_unregister:
        {
          this.unregister();
          reply.writeNoException();
          break;
        }
        default:
        {
          return super.onTransact(code, data, reply, flags);
        }
      }
      return true;
    }
    private static class Proxy implements android.media.ITranscodingClient
    {
      private android.os.IBinder mRemote;
      Proxy(android.os.IBinder remote)
      {
        mRemote = remote;
      }
      @Override public android.os.IBinder asBinder()
      {
        return mRemote;
      }
      public java.lang.String getInterfaceDescriptor()
      {
        return DESCRIPTOR;
      }
      /**
       * Submits a transcoding request to MediaTranscodingService.
       * 
       * @param request a TranscodingRequest contains transcoding configuration.
       * @param session(output variable) a TranscodingSession generated by MediaTranscodingService.
       * @return true if success, false otherwise.
       */
      @Override public boolean submitRequest(android.media.TranscodingRequestParcel request, android.media.TranscodingSessionParcel session) throws android.os.RemoteException
      {
        android.os.Parcel _data = android.os.Parcel.obtain();
        android.os.Parcel _reply = android.os.Parcel.obtain();
        boolean _result;
        try {
          _data.writeInterfaceToken(DESCRIPTOR);
          _data.writeTypedObject(request, 0);
          boolean _status = mRemote.transact(Stub.TRANSACTION_submitRequest, _data, _reply, 0);
          _reply.readException();
          _result = _reply.readBoolean();
          if ((0!=_reply.readInt())) {
            session.readFromParcel(_reply);
          }
        }
        finally {
          _reply.recycle();
          _data.recycle();
        }
        return _result;
      }
      /**
       * Cancels a transcoding session.
       * 
       * @param sessionId a TranscodingSession generated by the MediaTranscodingService.
       * @return true if succeeds, false otherwise.
       */
      @Override public boolean cancelSession(int sessionId) throws android.os.RemoteException
      {
        android.os.Parcel _data = android.os.Parcel.obtain();
        android.os.Parcel _reply = android.os.Parcel.obtain();
        boolean _result;
        try {
          _data.writeInterfaceToken(DESCRIPTOR);
          _data.writeInt(sessionId);
          boolean _status = mRemote.transact(Stub.TRANSACTION_cancelSession, _data, _reply, 0);
          _reply.readException();
          _result = _reply.readBoolean();
        }
        finally {
          _reply.recycle();
          _data.recycle();
        }
        return _result;
      }
      /**
       * Queries the session detail associated with a sessionId.
       * 
       * @param sessionId a TranscodingSession generated by the MediaTranscodingService.
       * @param session(output variable) the TranscodingSession associated with the sessionId.
       * @return true if succeeds, false otherwise.
       */
      @Override public boolean getSessionWithId(int sessionId, android.media.TranscodingSessionParcel session) throws android.os.RemoteException
      {
        android.os.Parcel _data = android.os.Parcel.obtain();
        android.os.Parcel _reply = android.os.Parcel.obtain();
        boolean _result;
        try {
          _data.writeInterfaceToken(DESCRIPTOR);
          _data.writeInt(sessionId);
          boolean _status = mRemote.transact(Stub.TRANSACTION_getSessionWithId, _data, _reply, 0);
          _reply.readException();
          _result = _reply.readBoolean();
          if ((0!=_reply.readInt())) {
            session.readFromParcel(_reply);
          }
        }
        finally {
          _reply.recycle();
          _data.recycle();
        }
        return _result;
      }
      /**
       * Add an additional client uid requesting a session.
       * 
       * @sessionId the session id to which to add the additional client uid.
       * @clientUid the additional client uid to be added.
       * @return false if the session doesn't exist or the client is already requesting the
       * session, true otherwise.
       */
      @Override public boolean addClientUid(int sessionId, int clientUid) throws android.os.RemoteException
      {
        android.os.Parcel _data = android.os.Parcel.obtain();
        android.os.Parcel _reply = android.os.Parcel.obtain();
        boolean _result;
        try {
          _data.writeInterfaceToken(DESCRIPTOR);
          _data.writeInt(sessionId);
          _data.writeInt(clientUid);
          boolean _status = mRemote.transact(Stub.TRANSACTION_addClientUid, _data, _reply, 0);
          _reply.readException();
          _result = _reply.readBoolean();
        }
        finally {
          _reply.recycle();
          _data.recycle();
        }
        return _result;
      }
      /**
       * Retrieves the (unsorted) list of all clients requesting a session.
       * 
       * Note that if a session was submitted with offline priority (
       * TranscodingSessionPriority::kUnspecified), it initially will not be considered requested
       * by any particular client, because the client could go away any time after the submission.
       * However, additional uids could be added via addClientUid() after the submission, which
       * essentially make the request a real-time request instead of an offline request.
       * 
       * @sessionId the session id for which to retrieve the client uid list.
       * @clientUids array to hold the retrieved client uid list.
       * @return false if the session doesn't exist, true otherwise.
       */
      @Override public int[] getClientUids(int sessionId) throws android.os.RemoteException
      {
        android.os.Parcel _data = android.os.Parcel.obtain();
        android.os.Parcel _reply = android.os.Parcel.obtain();
        int[] _result;
        try {
          _data.writeInterfaceToken(DESCRIPTOR);
          _data.writeInt(sessionId);
          boolean _status = mRemote.transact(Stub.TRANSACTION_getClientUids, _data, _reply, 0);
          _reply.readException();
          _result = _reply.createIntArray();
        }
        finally {
          _reply.recycle();
          _data.recycle();
        }
        return _result;
      }
      /**
       * Unregister the client with the MediaTranscodingService.
       * 
       * Client will not be able to perform any more transcoding after unregister.
       */
      @Override public void unregister() throws android.os.RemoteException
      {
        android.os.Parcel _data = android.os.Parcel.obtain();
        android.os.Parcel _reply = android.os.Parcel.obtain();
        try {
          _data.writeInterfaceToken(DESCRIPTOR);
          boolean _status = mRemote.transact(Stub.TRANSACTION_unregister, _data, _reply, 0);
          _reply.readException();
        }
        finally {
          _reply.recycle();
          _data.recycle();
        }
      }
    }
    static final int TRANSACTION_submitRequest = (android.os.IBinder.FIRST_CALL_TRANSACTION + 0);
    static final int TRANSACTION_cancelSession = (android.os.IBinder.FIRST_CALL_TRANSACTION + 1);
    static final int TRANSACTION_getSessionWithId = (android.os.IBinder.FIRST_CALL_TRANSACTION + 2);
    static final int TRANSACTION_addClientUid = (android.os.IBinder.FIRST_CALL_TRANSACTION + 3);
    static final int TRANSACTION_getClientUids = (android.os.IBinder.FIRST_CALL_TRANSACTION + 4);
    static final int TRANSACTION_unregister = (android.os.IBinder.FIRST_CALL_TRANSACTION + 5);
  }
  public static final java.lang.String DESCRIPTOR = "android$media$ITranscodingClient".replace('$', '.');
  /**
   * Submits a transcoding request to MediaTranscodingService.
   * 
   * @param request a TranscodingRequest contains transcoding configuration.
   * @param session(output variable) a TranscodingSession generated by MediaTranscodingService.
   * @return true if success, false otherwise.
   */
  public boolean submitRequest(android.media.TranscodingRequestParcel request, android.media.TranscodingSessionParcel session) throws android.os.RemoteException;
  /**
   * Cancels a transcoding session.
   * 
   * @param sessionId a TranscodingSession generated by the MediaTranscodingService.
   * @return true if succeeds, false otherwise.
   */
  public boolean cancelSession(int sessionId) throws android.os.RemoteException;
  /**
   * Queries the session detail associated with a sessionId.
   * 
   * @param sessionId a TranscodingSession generated by the MediaTranscodingService.
   * @param session(output variable) the TranscodingSession associated with the sessionId.
   * @return true if succeeds, false otherwise.
   */
  public boolean getSessionWithId(int sessionId, android.media.TranscodingSessionParcel session) throws android.os.RemoteException;
  /**
   * Add an additional client uid requesting a session.
   * 
   * @sessionId the session id to which to add the additional client uid.
   * @clientUid the additional client uid to be added.
   * @return false if the session doesn't exist or the client is already requesting the
   * session, true otherwise.
   */
  public boolean addClientUid(int sessionId, int clientUid) throws android.os.RemoteException;
  /**
   * Retrieves the (unsorted) list of all clients requesting a session.
   * 
   * Note that if a session was submitted with offline priority (
   * TranscodingSessionPriority::kUnspecified), it initially will not be considered requested
   * by any particular client, because the client could go away any time after the submission.
   * However, additional uids could be added via addClientUid() after the submission, which
   * essentially make the request a real-time request instead of an offline request.
   * 
   * @sessionId the session id for which to retrieve the client uid list.
   * @clientUids array to hold the retrieved client uid list.
   * @return false if the session doesn't exist, true otherwise.
   */
  public int[] getClientUids(int sessionId) throws android.os.RemoteException;
  /**
   * Unregister the client with the MediaTranscodingService.
   * 
   * Client will not be able to perform any more transcoding after unregister.
   */
  public void unregister() throws android.os.RemoteException;
}
