/*
 * This file is auto-generated.  DO NOT MODIFY.
 */
package android.media.soundtrigger_middleware;
/**
 * An injection interface for {@link android.media.soundtrigger_middleware.FakeSoundTriggerHal}.
 * To avoid deadlocks, all calls to this interface and the sub-interface it creates are oneway.
 * Calls are identified as stale via "Session" parameters.
 * The client implements this interface and registers it with
 * {@link ISoundTriggerMiddlewareService#attachMockHalInjection(ISoundTriggerInjection)}.
 * Then, the client will receive callbacks which observe mock HAL events.
 * There are two types of calls.
 * 1) Those that provide a new injection sub-interface (contains param .*Injection).
 * 2) Those that are sessioned via an injection sub-interface (contains param .*Session).
 * The new injection sub-interfaces generated by (1) can be used to trigger HAL events.
 * Some calls within (2) will invalidate the session object which they are associated with
 * (e.g. {@link soundModelUnloaded}), and will be noted as such.
 * Some calls within the injection interface (e.g. {@link IInjectModelEvent#triggerUnloadModel()})
 * will invalidate the session object they are called upon, and will be noted as such.
 * @hide
 */
public interface ISoundTriggerInjection extends android.os.IInterface
{
  /** Default implementation for ISoundTriggerInjection. */
  public static class Default implements android.media.soundtrigger_middleware.ISoundTriggerInjection
  {
    /**
     * Called following attachment via
     * {@link ISoundTriggerMiddlewareService#attachMockHalInjection(ISoundTriggerInjection)}.
     * Provides the client an injection interface for events which are always (globally) valid.
     * @param globalInjection - Interface used to inject global events to the fake HAL.
     * Used as a session object for further callbacks associated with the HAL globally.
     */
    @Override public void registerGlobalEventInjection(android.media.soundtrigger_middleware.IInjectGlobalEvent globalInjection) throws android.os.RemoteException
    {
    }
    /**
     * Called when the HAL has been restarted by the framework. Not called after a
     * {@link IInjectGlobalEvent#triggerRestart()}.
     * @param globalSession - The interface previously provided by a
     * {@link registerGlobalEventInjection} call which this restart is associated with.
     * Used to disambiguate stale restart events from a subsequent global session.
     */
    @Override public void onRestarted(android.media.soundtrigger_middleware.IInjectGlobalEvent globalSession) throws android.os.RemoteException
    {
    }
    /**
     * Called when the HAL has been detached by the framework.
     * @param globalSession - The interface previously provided by a
     * {@link registerGlobalEventInjection} call which this detach is associated with.
     * Used to disambiguate stale detach events from a subsequent global session.
     */
    @Override public void onFrameworkDetached(android.media.soundtrigger_middleware.IInjectGlobalEvent globalSession) throws android.os.RemoteException
    {
    }
    /**
     * Called when a client is attached to the framework. This event is not actually
     * delivered to the HAL, but is useful to understand the framework state.
     * @param token - An opaque token representing the framework client session.
     * Associated with a subsequent call to {@link onClientDetached(IBinder)}.
     * @param globalSession - The global STHAL session this attach is associated with.
     */
    @Override public void onClientAttached(android.os.IBinder token, android.media.soundtrigger_middleware.IInjectGlobalEvent globalSession) throws android.os.RemoteException
    {
    }
    /**
     * Called when a client detaches from the framework. This event is not actually
     * delivered to the HAL, but is useful to understand the framework state.
     * @param token - The opaque token returned by a previous
     * {@link onClientAttached(IBinder, IInjectGlobalEvent} call.
     */
    @Override public void onClientDetached(android.os.IBinder token) throws android.os.RemoteException
    {
    }
    /**
     * Called when a sound model is loaded into the fake STHAL by the framework.
     * @param model - The model data for the newly loaded model.
     * @param phrases - The phrase data for the newly loaded model, if it is a keyphrase model.
     *                  Null otherwise.
     * @param modelInjection - Interface used to inject events associated with the newly loaded
     * model into the fake STHAL.
     * Used as a session object for further callbacks associated with this newly loaded model.
     * @param globalSession - The session object representing the global STHAL instance this load
     * is associated with.
     */
    @Override public void onSoundModelLoaded(android.media.soundtrigger.SoundModel model, android.media.soundtrigger.Phrase[] phrases, android.media.soundtrigger_middleware.IInjectModelEvent modelInjection, android.media.soundtrigger_middleware.IInjectGlobalEvent globalSession) throws android.os.RemoteException
    {
    }
    /**
     * Called when the fake STHAL receives a set parameter call from the framework on a previously
     * loaded model.
     * @param modelParam - Code of the parameter being set, see
     * {@link android.media.soundtrigger.ModelParameter}
     * @param value - Value to set the modelParam to
     * @param modelSession - Session object of the loaded model the set param call is associated
     * with.
     */
    @Override public void onParamSet(int modelParam, int value, android.media.soundtrigger_middleware.IInjectModelEvent modelSession) throws android.os.RemoteException
    {
    }
    /**
     * Called when a previously loaded model in the fake STHAL has recognition started by the
     * framework.
     * @param audioSessionToken - The audio session token passed by the framework which will be
     * contained within a received recognition event.
     * @param config - The recognition config passed by the framework for this recognition.
     * @param recognitionInjection - A new injection interface which allows the client to
     * trigger events associated with this newly started recognition.
     * @param modelSession - The session object representing the loaded model that this
     * recognition is associated with.
     */
    @Override public void onRecognitionStarted(int audioSessionToken, android.media.soundtrigger.RecognitionConfig config, android.media.soundtrigger_middleware.IInjectRecognitionEvent recognitionInjection, android.media.soundtrigger_middleware.IInjectModelEvent modelSession) throws android.os.RemoteException
    {
    }
    /**
     * Called when a previously started recognition in the fake STHAL is stopped by the framework.
     * Not called following any calls on {@link IInjectRecognitionEvent}.
     * @param recognitionSession - The session object received via a previous call to
     * {@link recognitionStarted(int, RecognitionConfig, IInjectModelEvent,
     * IInjectRecognitionEvent} which has been unloaded.
     * This session is invalidated subsequent to this call, and no triggers will be respected.
     */
    @Override public void onRecognitionStopped(android.media.soundtrigger_middleware.IInjectRecognitionEvent recognitionSession) throws android.os.RemoteException
    {
    }
    /**
     * Called when a previously loaded model in the fake STHAL is unloaded by the framework.
     * Not called following {@link IInjectModelEvent#triggerUnloadModel()}.
     * @param modelSession - The session object received via a previous call to
     * {@link soundModelLoaded(SoundModel, Phrase[], IInjectModelEvent} which has been unloaded.
     * This session is invalidated subsequent to this call, and no triggers will be respected.
     */
    @Override public void onSoundModelUnloaded(android.media.soundtrigger_middleware.IInjectModelEvent modelSession) throws android.os.RemoteException
    {
    }
    /**
     * Called when this injection interface has been preempted by a subsequent call to
     * {@link ISoundTriggerMiddleware#attachFakeHal(ISoundTriggerInjection)}.
     * No more events will be delivered, and any further injection will be ignored.
     */
    @Override public void onPreempted() throws android.os.RemoteException
    {
    }
    @Override
    public android.os.IBinder asBinder() {
      return null;
    }
  }
  /** Local-side IPC implementation stub class. */
  public static abstract class Stub extends android.os.Binder implements android.media.soundtrigger_middleware.ISoundTriggerInjection
  {
    /** Construct the stub at attach it to the interface. */
    public Stub()
    {
      this.attachInterface(this, DESCRIPTOR);
    }
    /**
     * Cast an IBinder object into an android.media.soundtrigger_middleware.ISoundTriggerInjection interface,
     * generating a proxy if needed.
     */
    public static android.media.soundtrigger_middleware.ISoundTriggerInjection asInterface(android.os.IBinder obj)
    {
      if ((obj==null)) {
        return null;
      }
      android.os.IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
      if (((iin!=null)&&(iin instanceof android.media.soundtrigger_middleware.ISoundTriggerInjection))) {
        return ((android.media.soundtrigger_middleware.ISoundTriggerInjection)iin);
      }
      return new android.media.soundtrigger_middleware.ISoundTriggerInjection.Stub.Proxy(obj);
    }
    @Override public android.os.IBinder asBinder()
    {
      return this;
    }
    @Override public boolean onTransact(int code, android.os.Parcel data, android.os.Parcel reply, int flags) throws android.os.RemoteException
    {
      java.lang.String descriptor = DESCRIPTOR;
      if (code >= android.os.IBinder.FIRST_CALL_TRANSACTION && code <= android.os.IBinder.LAST_CALL_TRANSACTION) {
        data.enforceInterface(descriptor);
      }
      switch (code)
      {
        case INTERFACE_TRANSACTION:
        {
          reply.writeString(descriptor);
          return true;
        }
      }
      switch (code)
      {
        case TRANSACTION_registerGlobalEventInjection:
        {
          android.media.soundtrigger_middleware.IInjectGlobalEvent _arg0;
          _arg0 = android.media.soundtrigger_middleware.IInjectGlobalEvent.Stub.asInterface(data.readStrongBinder());
          data.enforceNoDataAvail();
          this.registerGlobalEventInjection(_arg0);
          break;
        }
        case TRANSACTION_onRestarted:
        {
          android.media.soundtrigger_middleware.IInjectGlobalEvent _arg0;
          _arg0 = android.media.soundtrigger_middleware.IInjectGlobalEvent.Stub.asInterface(data.readStrongBinder());
          data.enforceNoDataAvail();
          this.onRestarted(_arg0);
          break;
        }
        case TRANSACTION_onFrameworkDetached:
        {
          android.media.soundtrigger_middleware.IInjectGlobalEvent _arg0;
          _arg0 = android.media.soundtrigger_middleware.IInjectGlobalEvent.Stub.asInterface(data.readStrongBinder());
          data.enforceNoDataAvail();
          this.onFrameworkDetached(_arg0);
          break;
        }
        case TRANSACTION_onClientAttached:
        {
          android.os.IBinder _arg0;
          _arg0 = data.readStrongBinder();
          android.media.soundtrigger_middleware.IInjectGlobalEvent _arg1;
          _arg1 = android.media.soundtrigger_middleware.IInjectGlobalEvent.Stub.asInterface(data.readStrongBinder());
          data.enforceNoDataAvail();
          this.onClientAttached(_arg0, _arg1);
          break;
        }
        case TRANSACTION_onClientDetached:
        {
          android.os.IBinder _arg0;
          _arg0 = data.readStrongBinder();
          data.enforceNoDataAvail();
          this.onClientDetached(_arg0);
          break;
        }
        case TRANSACTION_onSoundModelLoaded:
        {
          android.media.soundtrigger.SoundModel _arg0;
          _arg0 = data.readTypedObject(android.media.soundtrigger.SoundModel.CREATOR);
          android.media.soundtrigger.Phrase[] _arg1;
          _arg1 = data.createTypedArray(android.media.soundtrigger.Phrase.CREATOR);
          android.media.soundtrigger_middleware.IInjectModelEvent _arg2;
          _arg2 = android.media.soundtrigger_middleware.IInjectModelEvent.Stub.asInterface(data.readStrongBinder());
          android.media.soundtrigger_middleware.IInjectGlobalEvent _arg3;
          _arg3 = android.media.soundtrigger_middleware.IInjectGlobalEvent.Stub.asInterface(data.readStrongBinder());
          data.enforceNoDataAvail();
          this.onSoundModelLoaded(_arg0, _arg1, _arg2, _arg3);
          break;
        }
        case TRANSACTION_onParamSet:
        {
          int _arg0;
          _arg0 = data.readInt();
          int _arg1;
          _arg1 = data.readInt();
          android.media.soundtrigger_middleware.IInjectModelEvent _arg2;
          _arg2 = android.media.soundtrigger_middleware.IInjectModelEvent.Stub.asInterface(data.readStrongBinder());
          data.enforceNoDataAvail();
          this.onParamSet(_arg0, _arg1, _arg2);
          break;
        }
        case TRANSACTION_onRecognitionStarted:
        {
          int _arg0;
          _arg0 = data.readInt();
          android.media.soundtrigger.RecognitionConfig _arg1;
          _arg1 = data.readTypedObject(android.media.soundtrigger.RecognitionConfig.CREATOR);
          android.media.soundtrigger_middleware.IInjectRecognitionEvent _arg2;
          _arg2 = android.media.soundtrigger_middleware.IInjectRecognitionEvent.Stub.asInterface(data.readStrongBinder());
          android.media.soundtrigger_middleware.IInjectModelEvent _arg3;
          _arg3 = android.media.soundtrigger_middleware.IInjectModelEvent.Stub.asInterface(data.readStrongBinder());
          data.enforceNoDataAvail();
          this.onRecognitionStarted(_arg0, _arg1, _arg2, _arg3);
          break;
        }
        case TRANSACTION_onRecognitionStopped:
        {
          android.media.soundtrigger_middleware.IInjectRecognitionEvent _arg0;
          _arg0 = android.media.soundtrigger_middleware.IInjectRecognitionEvent.Stub.asInterface(data.readStrongBinder());
          data.enforceNoDataAvail();
          this.onRecognitionStopped(_arg0);
          break;
        }
        case TRANSACTION_onSoundModelUnloaded:
        {
          android.media.soundtrigger_middleware.IInjectModelEvent _arg0;
          _arg0 = android.media.soundtrigger_middleware.IInjectModelEvent.Stub.asInterface(data.readStrongBinder());
          data.enforceNoDataAvail();
          this.onSoundModelUnloaded(_arg0);
          break;
        }
        case TRANSACTION_onPreempted:
        {
          this.onPreempted();
          break;
        }
        default:
        {
          return super.onTransact(code, data, reply, flags);
        }
      }
      return true;
    }
    private static class Proxy implements android.media.soundtrigger_middleware.ISoundTriggerInjection
    {
      private android.os.IBinder mRemote;
      Proxy(android.os.IBinder remote)
      {
        mRemote = remote;
      }
      @Override public android.os.IBinder asBinder()
      {
        return mRemote;
      }
      public java.lang.String getInterfaceDescriptor()
      {
        return DESCRIPTOR;
      }
      /**
       * Called following attachment via
       * {@link ISoundTriggerMiddlewareService#attachMockHalInjection(ISoundTriggerInjection)}.
       * Provides the client an injection interface for events which are always (globally) valid.
       * @param globalInjection - Interface used to inject global events to the fake HAL.
       * Used as a session object for further callbacks associated with the HAL globally.
       */
      @Override public void registerGlobalEventInjection(android.media.soundtrigger_middleware.IInjectGlobalEvent globalInjection) throws android.os.RemoteException
      {
        android.os.Parcel _data = android.os.Parcel.obtain(asBinder());
        try {
          _data.writeInterfaceToken(DESCRIPTOR);
          _data.writeStrongInterface(globalInjection);
          boolean _status = mRemote.transact(Stub.TRANSACTION_registerGlobalEventInjection, _data, null, android.os.IBinder.FLAG_ONEWAY);
        }
        finally {
          _data.recycle();
        }
      }
      /**
       * Called when the HAL has been restarted by the framework. Not called after a
       * {@link IInjectGlobalEvent#triggerRestart()}.
       * @param globalSession - The interface previously provided by a
       * {@link registerGlobalEventInjection} call which this restart is associated with.
       * Used to disambiguate stale restart events from a subsequent global session.
       */
      @Override public void onRestarted(android.media.soundtrigger_middleware.IInjectGlobalEvent globalSession) throws android.os.RemoteException
      {
        android.os.Parcel _data = android.os.Parcel.obtain(asBinder());
        try {
          _data.writeInterfaceToken(DESCRIPTOR);
          _data.writeStrongInterface(globalSession);
          boolean _status = mRemote.transact(Stub.TRANSACTION_onRestarted, _data, null, android.os.IBinder.FLAG_ONEWAY);
        }
        finally {
          _data.recycle();
        }
      }
      /**
       * Called when the HAL has been detached by the framework.
       * @param globalSession - The interface previously provided by a
       * {@link registerGlobalEventInjection} call which this detach is associated with.
       * Used to disambiguate stale detach events from a subsequent global session.
       */
      @Override public void onFrameworkDetached(android.media.soundtrigger_middleware.IInjectGlobalEvent globalSession) throws android.os.RemoteException
      {
        android.os.Parcel _data = android.os.Parcel.obtain(asBinder());
        try {
          _data.writeInterfaceToken(DESCRIPTOR);
          _data.writeStrongInterface(globalSession);
          boolean _status = mRemote.transact(Stub.TRANSACTION_onFrameworkDetached, _data, null, android.os.IBinder.FLAG_ONEWAY);
        }
        finally {
          _data.recycle();
        }
      }
      /**
       * Called when a client is attached to the framework. This event is not actually
       * delivered to the HAL, but is useful to understand the framework state.
       * @param token - An opaque token representing the framework client session.
       * Associated with a subsequent call to {@link onClientDetached(IBinder)}.
       * @param globalSession - The global STHAL session this attach is associated with.
       */
      @Override public void onClientAttached(android.os.IBinder token, android.media.soundtrigger_middleware.IInjectGlobalEvent globalSession) throws android.os.RemoteException
      {
        android.os.Parcel _data = android.os.Parcel.obtain(asBinder());
        try {
          _data.writeInterfaceToken(DESCRIPTOR);
          _data.writeStrongBinder(token);
          _data.writeStrongInterface(globalSession);
          boolean _status = mRemote.transact(Stub.TRANSACTION_onClientAttached, _data, null, android.os.IBinder.FLAG_ONEWAY);
        }
        finally {
          _data.recycle();
        }
      }
      /**
       * Called when a client detaches from the framework. This event is not actually
       * delivered to the HAL, but is useful to understand the framework state.
       * @param token - The opaque token returned by a previous
       * {@link onClientAttached(IBinder, IInjectGlobalEvent} call.
       */
      @Override public void onClientDetached(android.os.IBinder token) throws android.os.RemoteException
      {
        android.os.Parcel _data = android.os.Parcel.obtain(asBinder());
        try {
          _data.writeInterfaceToken(DESCRIPTOR);
          _data.writeStrongBinder(token);
          boolean _status = mRemote.transact(Stub.TRANSACTION_onClientDetached, _data, null, android.os.IBinder.FLAG_ONEWAY);
        }
        finally {
          _data.recycle();
        }
      }
      /**
       * Called when a sound model is loaded into the fake STHAL by the framework.
       * @param model - The model data for the newly loaded model.
       * @param phrases - The phrase data for the newly loaded model, if it is a keyphrase model.
       *                  Null otherwise.
       * @param modelInjection - Interface used to inject events associated with the newly loaded
       * model into the fake STHAL.
       * Used as a session object for further callbacks associated with this newly loaded model.
       * @param globalSession - The session object representing the global STHAL instance this load
       * is associated with.
       */
      @Override public void onSoundModelLoaded(android.media.soundtrigger.SoundModel model, android.media.soundtrigger.Phrase[] phrases, android.media.soundtrigger_middleware.IInjectModelEvent modelInjection, android.media.soundtrigger_middleware.IInjectGlobalEvent globalSession) throws android.os.RemoteException
      {
        android.os.Parcel _data = android.os.Parcel.obtain(asBinder());
        try {
          _data.writeInterfaceToken(DESCRIPTOR);
          _data.writeTypedObject(model, 0);
          _data.writeTypedArray(phrases, 0);
          _data.writeStrongInterface(modelInjection);
          _data.writeStrongInterface(globalSession);
          boolean _status = mRemote.transact(Stub.TRANSACTION_onSoundModelLoaded, _data, null, android.os.IBinder.FLAG_ONEWAY);
        }
        finally {
          _data.recycle();
        }
      }
      /**
       * Called when the fake STHAL receives a set parameter call from the framework on a previously
       * loaded model.
       * @param modelParam - Code of the parameter being set, see
       * {@link android.media.soundtrigger.ModelParameter}
       * @param value - Value to set the modelParam to
       * @param modelSession - Session object of the loaded model the set param call is associated
       * with.
       */
      @Override public void onParamSet(int modelParam, int value, android.media.soundtrigger_middleware.IInjectModelEvent modelSession) throws android.os.RemoteException
      {
        android.os.Parcel _data = android.os.Parcel.obtain(asBinder());
        try {
          _data.writeInterfaceToken(DESCRIPTOR);
          _data.writeInt(modelParam);
          _data.writeInt(value);
          _data.writeStrongInterface(modelSession);
          boolean _status = mRemote.transact(Stub.TRANSACTION_onParamSet, _data, null, android.os.IBinder.FLAG_ONEWAY);
        }
        finally {
          _data.recycle();
        }
      }
      /**
       * Called when a previously loaded model in the fake STHAL has recognition started by the
       * framework.
       * @param audioSessionToken - The audio session token passed by the framework which will be
       * contained within a received recognition event.
       * @param config - The recognition config passed by the framework for this recognition.
       * @param recognitionInjection - A new injection interface which allows the client to
       * trigger events associated with this newly started recognition.
       * @param modelSession - The session object representing the loaded model that this
       * recognition is associated with.
       */
      @Override public void onRecognitionStarted(int audioSessionToken, android.media.soundtrigger.RecognitionConfig config, android.media.soundtrigger_middleware.IInjectRecognitionEvent recognitionInjection, android.media.soundtrigger_middleware.IInjectModelEvent modelSession) throws android.os.RemoteException
      {
        android.os.Parcel _data = android.os.Parcel.obtain(asBinder());
        try {
          _data.writeInterfaceToken(DESCRIPTOR);
          _data.writeInt(audioSessionToken);
          _data.writeTypedObject(config, 0);
          _data.writeStrongInterface(recognitionInjection);
          _data.writeStrongInterface(modelSession);
          boolean _status = mRemote.transact(Stub.TRANSACTION_onRecognitionStarted, _data, null, android.os.IBinder.FLAG_ONEWAY);
        }
        finally {
          _data.recycle();
        }
      }
      /**
       * Called when a previously started recognition in the fake STHAL is stopped by the framework.
       * Not called following any calls on {@link IInjectRecognitionEvent}.
       * @param recognitionSession - The session object received via a previous call to
       * {@link recognitionStarted(int, RecognitionConfig, IInjectModelEvent,
       * IInjectRecognitionEvent} which has been unloaded.
       * This session is invalidated subsequent to this call, and no triggers will be respected.
       */
      @Override public void onRecognitionStopped(android.media.soundtrigger_middleware.IInjectRecognitionEvent recognitionSession) throws android.os.RemoteException
      {
        android.os.Parcel _data = android.os.Parcel.obtain(asBinder());
        try {
          _data.writeInterfaceToken(DESCRIPTOR);
          _data.writeStrongInterface(recognitionSession);
          boolean _status = mRemote.transact(Stub.TRANSACTION_onRecognitionStopped, _data, null, android.os.IBinder.FLAG_ONEWAY);
        }
        finally {
          _data.recycle();
        }
      }
      /**
       * Called when a previously loaded model in the fake STHAL is unloaded by the framework.
       * Not called following {@link IInjectModelEvent#triggerUnloadModel()}.
       * @param modelSession - The session object received via a previous call to
       * {@link soundModelLoaded(SoundModel, Phrase[], IInjectModelEvent} which has been unloaded.
       * This session is invalidated subsequent to this call, and no triggers will be respected.
       */
      @Override public void onSoundModelUnloaded(android.media.soundtrigger_middleware.IInjectModelEvent modelSession) throws android.os.RemoteException
      {
        android.os.Parcel _data = android.os.Parcel.obtain(asBinder());
        try {
          _data.writeInterfaceToken(DESCRIPTOR);
          _data.writeStrongInterface(modelSession);
          boolean _status = mRemote.transact(Stub.TRANSACTION_onSoundModelUnloaded, _data, null, android.os.IBinder.FLAG_ONEWAY);
        }
        finally {
          _data.recycle();
        }
      }
      /**
       * Called when this injection interface has been preempted by a subsequent call to
       * {@link ISoundTriggerMiddleware#attachFakeHal(ISoundTriggerInjection)}.
       * No more events will be delivered, and any further injection will be ignored.
       */
      @Override public void onPreempted() throws android.os.RemoteException
      {
        android.os.Parcel _data = android.os.Parcel.obtain(asBinder());
        try {
          _data.writeInterfaceToken(DESCRIPTOR);
          boolean _status = mRemote.transact(Stub.TRANSACTION_onPreempted, _data, null, android.os.IBinder.FLAG_ONEWAY);
        }
        finally {
          _data.recycle();
        }
      }
    }
    static final int TRANSACTION_registerGlobalEventInjection = (android.os.IBinder.FIRST_CALL_TRANSACTION + 0);
    static final int TRANSACTION_onRestarted = (android.os.IBinder.FIRST_CALL_TRANSACTION + 1);
    static final int TRANSACTION_onFrameworkDetached = (android.os.IBinder.FIRST_CALL_TRANSACTION + 2);
    static final int TRANSACTION_onClientAttached = (android.os.IBinder.FIRST_CALL_TRANSACTION + 3);
    static final int TRANSACTION_onClientDetached = (android.os.IBinder.FIRST_CALL_TRANSACTION + 4);
    static final int TRANSACTION_onSoundModelLoaded = (android.os.IBinder.FIRST_CALL_TRANSACTION + 5);
    static final int TRANSACTION_onParamSet = (android.os.IBinder.FIRST_CALL_TRANSACTION + 6);
    static final int TRANSACTION_onRecognitionStarted = (android.os.IBinder.FIRST_CALL_TRANSACTION + 7);
    static final int TRANSACTION_onRecognitionStopped = (android.os.IBinder.FIRST_CALL_TRANSACTION + 8);
    static final int TRANSACTION_onSoundModelUnloaded = (android.os.IBinder.FIRST_CALL_TRANSACTION + 9);
    static final int TRANSACTION_onPreempted = (android.os.IBinder.FIRST_CALL_TRANSACTION + 10);
  }
  public static final java.lang.String DESCRIPTOR = "android$media$soundtrigger_middleware$ISoundTriggerInjection".replace('$', '.');
  /**
   * Value of {@link android.media.soundtrigger.Properties#supportedModelArch} that
   * identifies the HAL as a fake HAL.
   */
  public static final String FAKE_HAL_ARCH = "injection";
  /**
   * Called following attachment via
   * {@link ISoundTriggerMiddlewareService#attachMockHalInjection(ISoundTriggerInjection)}.
   * Provides the client an injection interface for events which are always (globally) valid.
   * @param globalInjection - Interface used to inject global events to the fake HAL.
   * Used as a session object for further callbacks associated with the HAL globally.
   */
  public void registerGlobalEventInjection(android.media.soundtrigger_middleware.IInjectGlobalEvent globalInjection) throws android.os.RemoteException;
  /**
   * Called when the HAL has been restarted by the framework. Not called after a
   * {@link IInjectGlobalEvent#triggerRestart()}.
   * @param globalSession - The interface previously provided by a
   * {@link registerGlobalEventInjection} call which this restart is associated with.
   * Used to disambiguate stale restart events from a subsequent global session.
   */
  public void onRestarted(android.media.soundtrigger_middleware.IInjectGlobalEvent globalSession) throws android.os.RemoteException;
  /**
   * Called when the HAL has been detached by the framework.
   * @param globalSession - The interface previously provided by a
   * {@link registerGlobalEventInjection} call which this detach is associated with.
   * Used to disambiguate stale detach events from a subsequent global session.
   */
  public void onFrameworkDetached(android.media.soundtrigger_middleware.IInjectGlobalEvent globalSession) throws android.os.RemoteException;
  /**
   * Called when a client is attached to the framework. This event is not actually
   * delivered to the HAL, but is useful to understand the framework state.
   * @param token - An opaque token representing the framework client session.
   * Associated with a subsequent call to {@link onClientDetached(IBinder)}.
   * @param globalSession - The global STHAL session this attach is associated with.
   */
  public void onClientAttached(android.os.IBinder token, android.media.soundtrigger_middleware.IInjectGlobalEvent globalSession) throws android.os.RemoteException;
  /**
   * Called when a client detaches from the framework. This event is not actually
   * delivered to the HAL, but is useful to understand the framework state.
   * @param token - The opaque token returned by a previous
   * {@link onClientAttached(IBinder, IInjectGlobalEvent} call.
   */
  public void onClientDetached(android.os.IBinder token) throws android.os.RemoteException;
  /**
   * Called when a sound model is loaded into the fake STHAL by the framework.
   * @param model - The model data for the newly loaded model.
   * @param phrases - The phrase data for the newly loaded model, if it is a keyphrase model.
   *                  Null otherwise.
   * @param modelInjection - Interface used to inject events associated with the newly loaded
   * model into the fake STHAL.
   * Used as a session object for further callbacks associated with this newly loaded model.
   * @param globalSession - The session object representing the global STHAL instance this load
   * is associated with.
   */
  public void onSoundModelLoaded(android.media.soundtrigger.SoundModel model, android.media.soundtrigger.Phrase[] phrases, android.media.soundtrigger_middleware.IInjectModelEvent modelInjection, android.media.soundtrigger_middleware.IInjectGlobalEvent globalSession) throws android.os.RemoteException;
  /**
   * Called when the fake STHAL receives a set parameter call from the framework on a previously
   * loaded model.
   * @param modelParam - Code of the parameter being set, see
   * {@link android.media.soundtrigger.ModelParameter}
   * @param value - Value to set the modelParam to
   * @param modelSession - Session object of the loaded model the set param call is associated
   * with.
   */
  public void onParamSet(int modelParam, int value, android.media.soundtrigger_middleware.IInjectModelEvent modelSession) throws android.os.RemoteException;
  /**
   * Called when a previously loaded model in the fake STHAL has recognition started by the
   * framework.
   * @param audioSessionToken - The audio session token passed by the framework which will be
   * contained within a received recognition event.
   * @param config - The recognition config passed by the framework for this recognition.
   * @param recognitionInjection - A new injection interface which allows the client to
   * trigger events associated with this newly started recognition.
   * @param modelSession - The session object representing the loaded model that this
   * recognition is associated with.
   */
  public void onRecognitionStarted(int audioSessionToken, android.media.soundtrigger.RecognitionConfig config, android.media.soundtrigger_middleware.IInjectRecognitionEvent recognitionInjection, android.media.soundtrigger_middleware.IInjectModelEvent modelSession) throws android.os.RemoteException;
  /**
   * Called when a previously started recognition in the fake STHAL is stopped by the framework.
   * Not called following any calls on {@link IInjectRecognitionEvent}.
   * @param recognitionSession - The session object received via a previous call to
   * {@link recognitionStarted(int, RecognitionConfig, IInjectModelEvent,
   * IInjectRecognitionEvent} which has been unloaded.
   * This session is invalidated subsequent to this call, and no triggers will be respected.
   */
  public void onRecognitionStopped(android.media.soundtrigger_middleware.IInjectRecognitionEvent recognitionSession) throws android.os.RemoteException;
  /**
   * Called when a previously loaded model in the fake STHAL is unloaded by the framework.
   * Not called following {@link IInjectModelEvent#triggerUnloadModel()}.
   * @param modelSession - The session object received via a previous call to
   * {@link soundModelLoaded(SoundModel, Phrase[], IInjectModelEvent} which has been unloaded.
   * This session is invalidated subsequent to this call, and no triggers will be respected.
   */
  public void onSoundModelUnloaded(android.media.soundtrigger_middleware.IInjectModelEvent modelSession) throws android.os.RemoteException;
  /**
   * Called when this injection interface has been preempted by a subsequent call to
   * {@link ISoundTriggerMiddleware#attachFakeHal(ISoundTriggerInjection)}.
   * No more events will be delivered, and any further injection will be ignored.
   */
  public void onPreempted() throws android.os.RemoteException;
}
