/*
 * Copyright (C) 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package android.ondevicepersonalization;

import android.annotation.NonNull;
import android.os.Parcelable;

import com.android.ondevicepersonalization.internal.util.AnnotationValidations;
import com.android.ondevicepersonalization.internal.util.DataClass;

/**
 * App usage status for app usage histogram.
 *
 * @hide
 */
@DataClass(genBuilder = true, genEqualsHashCode = true)
public final class AppUsageStatus implements Parcelable {
    /** Package name. */
    @NonNull String mPackageName;

    /** Total time spent on the app in the past 30 days in milliseconds. */
    @NonNull long mTotalTimeUsedInMillis;



    // Code below generated by codegen v1.0.23.
    //
    // DO NOT MODIFY!
    // CHECKSTYLE:OFF Generated code
    //
    // To regenerate run:
    // $ codegen $ANDROID_BUILD_TOP/packages/modules/OnDevicePersonalization/framework/java/android/ondevicepersonalization/AppUsageStatus.java
    //
    // To exclude the generated code from IntelliJ auto-formatting enable (one-time):
    //   Settings > Editor > Code Style > Formatter Control
    //@formatter:off


    @DataClass.Generated.Member
    /* package-private */ AppUsageStatus(
            @NonNull String packageName,
            @NonNull long totalTimeUsedInMillis) {
        this.mPackageName = packageName;
        AnnotationValidations.validate(
                NonNull.class, null, mPackageName);
        this.mTotalTimeUsedInMillis = totalTimeUsedInMillis;
        AnnotationValidations.validate(
                NonNull.class, null, mTotalTimeUsedInMillis);

        // onConstructed(); // You can define this method to get a callback
    }

    /**
     * Package name.
     */
    @DataClass.Generated.Member
    public @NonNull String getPackageName() {
        return mPackageName;
    }

    /**
     * Total time spent on the app in the past 30 days in milliseconds.
     */
    @DataClass.Generated.Member
    public @NonNull long getTotalTimeUsedInMillis() {
        return mTotalTimeUsedInMillis;
    }

    @Override
    @DataClass.Generated.Member
    public boolean equals(@android.annotation.Nullable Object o) {
        // You can override field equality logic by defining either of the methods like:
        // boolean fieldNameEquals(AppUsageStatus other) { ... }
        // boolean fieldNameEquals(FieldType otherValue) { ... }

        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        @SuppressWarnings("unchecked")
        AppUsageStatus that = (AppUsageStatus) o;
        //noinspection PointlessBooleanExpression
        return true
                && java.util.Objects.equals(mPackageName, that.mPackageName)
                && mTotalTimeUsedInMillis == that.mTotalTimeUsedInMillis;
    }

    @Override
    @DataClass.Generated.Member
    public int hashCode() {
        // You can override field hashCode logic by defining methods like:
        // int fieldNameHashCode() { ... }

        int _hash = 1;
        _hash = 31 * _hash + java.util.Objects.hashCode(mPackageName);
        _hash = 31 * _hash + Long.hashCode(mTotalTimeUsedInMillis);
        return _hash;
    }

    @Override
    @DataClass.Generated.Member
    public void writeToParcel(@NonNull android.os.Parcel dest, int flags) {
        // You can override field parcelling by defining methods like:
        // void parcelFieldName(Parcel dest, int flags) { ... }

        dest.writeString(mPackageName);
        dest.writeLong(mTotalTimeUsedInMillis);
    }

    @Override
    @DataClass.Generated.Member
    public int describeContents() { return 0; }

    /** @hide */
    @SuppressWarnings({"unchecked", "RedundantCast"})
    @DataClass.Generated.Member
    /* package-private */ AppUsageStatus(@NonNull android.os.Parcel in) {
        // You can override field unparcelling by defining methods like:
        // static FieldType unparcelFieldName(Parcel in) { ... }

        String packageName = in.readString();
        long totalTimeUsedInMillis = in.readLong();

        this.mPackageName = packageName;
        AnnotationValidations.validate(
                NonNull.class, null, mPackageName);
        this.mTotalTimeUsedInMillis = totalTimeUsedInMillis;
        AnnotationValidations.validate(
                NonNull.class, null, mTotalTimeUsedInMillis);

        // onConstructed(); // You can define this method to get a callback
    }

    @DataClass.Generated.Member
    public static final @NonNull Parcelable.Creator<AppUsageStatus> CREATOR
            = new Parcelable.Creator<AppUsageStatus>() {
        @Override
        public AppUsageStatus[] newArray(int size) {
            return new AppUsageStatus[size];
        }

        @Override
        public AppUsageStatus createFromParcel(@NonNull android.os.Parcel in) {
            return new AppUsageStatus(in);
        }
    };

    /**
     * A builder for {@link AppUsageStatus}
     */
    @SuppressWarnings("WeakerAccess")
    @DataClass.Generated.Member
    public static final class Builder {

        private @NonNull String mPackageName;
        private @NonNull long mTotalTimeUsedInMillis;

        private long mBuilderFieldsSet = 0L;

        /**
         * Creates a new Builder.
         *
         * @param packageName
         *   Package name.
         * @param totalTimeUsedInMillis
         *   Total time spent on the app in the past 30 days in milliseconds.
         */
        public Builder(
                @NonNull String packageName,
                @NonNull long totalTimeUsedInMillis) {
            mPackageName = packageName;
            AnnotationValidations.validate(
                    NonNull.class, null, mPackageName);
            mTotalTimeUsedInMillis = totalTimeUsedInMillis;
            AnnotationValidations.validate(
                    NonNull.class, null, mTotalTimeUsedInMillis);
        }

        public Builder() {
        }

        /**
         * Package name.
         */
        @DataClass.Generated.Member
        public @NonNull Builder setPackageName(@NonNull String value) {
            checkNotUsed();
            mBuilderFieldsSet |= 0x1;
            mPackageName = value;
            return this;
        }

        /**
         * Total time spent on the app in the past 30 days in milliseconds.
         */
        @DataClass.Generated.Member
        public @NonNull Builder setTotalTimeUsedInMillis(@NonNull long value) {
            checkNotUsed();
            mBuilderFieldsSet |= 0x2;
            mTotalTimeUsedInMillis = value;
            return this;
        }

        /** Builds the instance. This builder should not be touched after calling this! */
        public @NonNull AppUsageStatus build() {
            checkNotUsed();
            mBuilderFieldsSet |= 0x4; // Mark builder used

            AppUsageStatus o = new AppUsageStatus(
                    mPackageName,
                    mTotalTimeUsedInMillis);
            return o;
        }

        private void checkNotUsed() {
            if ((mBuilderFieldsSet & 0x4) != 0) {
                throw new IllegalStateException(
                        "This Builder should not be reused. Use a new Builder instance instead");
            }
        }
    }

    @DataClass.Generated(
            time = 1676499898093L,
            codegenVersion = "1.0.23",
            sourceFile = "packages/modules/OnDevicePersonalization/framework/java/android/ondevicepersonalization/AppUsageStatus.java",
            inputSignatures = " @android.annotation.NonNull java.lang.String mPackageName\n @android.annotation.NonNull long mTotalTimeUsedInMillis\nclass AppUsageStatus extends java.lang.Object implements [android.os.Parcelable]\n@com.android.ondevicepersonalization.internal.util.DataClass(genBuilder=true, genEqualsHashCode=true)")
    @Deprecated
    private void __metadata() {}


    //@formatter:on
    // End of generated code

}
