/*
 * Copyright (C) 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package android.ondevicepersonalization;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.os.Parcelable;

import com.android.ondevicepersonalization.internal.util.AnnotationValidations;
import com.android.ondevicepersonalization.internal.util.DataClass;

/**
 * A candidate to be rendered in response to a request from a calling app.
 *
 * @hide
 */
@DataClass(genBuilder = true, genEqualsHashCode = true)
public final class Bid implements Parcelable {
    /**
     * A key in the REMOTE_DATA table that identifies this bid. This will be used
     * to fetch the bid data for rendering if this is a winning bid.
     */
    @NonNull private String mKey = "";

    /**
     * The query level metrics to be logged.
     */
    @Nullable private Metrics mMetrics = null;



    // Code below generated by codegen v1.0.23.
    //
    // DO NOT MODIFY!
    // CHECKSTYLE:OFF Generated code
    //
    // To regenerate run:
    // $ codegen $ANDROID_BUILD_TOP/packages/modules/OnDevicePersonalization/framework/java/android/ondevicepersonalization/Bid.java
    //
    // To exclude the generated code from IntelliJ auto-formatting enable (one-time):
    //   Settings > Editor > Code Style > Formatter Control
    //@formatter:off


    @DataClass.Generated.Member
    /* package-private */ Bid(
            @NonNull String key,
            @Nullable Metrics metrics) {
        this.mKey = key;
        AnnotationValidations.validate(
                NonNull.class, null, mKey);
        this.mMetrics = metrics;

        // onConstructed(); // You can define this method to get a callback
    }

    /**
     * A key in the REMOTE_DATA table that identifies this bid. This will be used
     * to fetch the bid data for rendering if this is a winning bid.
     */
    @DataClass.Generated.Member
    public @NonNull String getKey() {
        return mKey;
    }

    /**
     * The query level metrics to be logged.
     */
    @DataClass.Generated.Member
    public @Nullable Metrics getMetrics() {
        return mMetrics;
    }

    @Override
    @DataClass.Generated.Member
    public boolean equals(@Nullable Object o) {
        // You can override field equality logic by defining either of the methods like:
        // boolean fieldNameEquals(Bid other) { ... }
        // boolean fieldNameEquals(FieldType otherValue) { ... }

        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        @SuppressWarnings("unchecked")
        Bid that = (Bid) o;
        //noinspection PointlessBooleanExpression
        return true
                && java.util.Objects.equals(mKey, that.mKey)
                && java.util.Objects.equals(mMetrics, that.mMetrics);
    }

    @Override
    @DataClass.Generated.Member
    public int hashCode() {
        // You can override field hashCode logic by defining methods like:
        // int fieldNameHashCode() { ... }

        int _hash = 1;
        _hash = 31 * _hash + java.util.Objects.hashCode(mKey);
        _hash = 31 * _hash + java.util.Objects.hashCode(mMetrics);
        return _hash;
    }

    @Override
    @DataClass.Generated.Member
    public void writeToParcel(@NonNull android.os.Parcel dest, int flags) {
        // You can override field parcelling by defining methods like:
        // void parcelFieldName(Parcel dest, int flags) { ... }

        byte flg = 0;
        if (mMetrics != null) flg |= 0x2;
        dest.writeByte(flg);
        dest.writeString(mKey);
        if (mMetrics != null) dest.writeTypedObject(mMetrics, flags);
    }

    @Override
    @DataClass.Generated.Member
    public int describeContents() { return 0; }

    /** @hide */
    @SuppressWarnings({"unchecked", "RedundantCast"})
    @DataClass.Generated.Member
    /* package-private */ Bid(@NonNull android.os.Parcel in) {
        // You can override field unparcelling by defining methods like:
        // static FieldType unparcelFieldName(Parcel in) { ... }

        byte flg = in.readByte();
        String key = in.readString();
        Metrics metrics = (flg & 0x2) == 0 ? null : (Metrics) in.readTypedObject(Metrics.CREATOR);

        this.mKey = key;
        AnnotationValidations.validate(
                NonNull.class, null, mKey);
        this.mMetrics = metrics;

        // onConstructed(); // You can define this method to get a callback
    }

    @DataClass.Generated.Member
    public static final @NonNull Parcelable.Creator<Bid> CREATOR
            = new Parcelable.Creator<Bid>() {
        @Override
        public Bid[] newArray(int size) {
            return new Bid[size];
        }

        @Override
        public Bid createFromParcel(@NonNull android.os.Parcel in) {
            return new Bid(in);
        }
    };

    /**
     * A builder for {@link Bid}
     */
    @SuppressWarnings("WeakerAccess")
    @DataClass.Generated.Member
    public static final class Builder {

        private @NonNull String mKey;
        private @Nullable Metrics mMetrics;

        private long mBuilderFieldsSet = 0L;

        public Builder() {
        }

        /**
         * A key in the REMOTE_DATA table that identifies this bid. This will be used
         * to fetch the bid data for rendering if this is a winning bid.
         */
        @DataClass.Generated.Member
        public @NonNull Builder setKey(@NonNull String value) {
            checkNotUsed();
            mBuilderFieldsSet |= 0x1;
            mKey = value;
            return this;
        }

        /**
         * The query level metrics to be logged.
         */
        @DataClass.Generated.Member
        public @NonNull Builder setMetrics(@NonNull Metrics value) {
            checkNotUsed();
            mBuilderFieldsSet |= 0x2;
            mMetrics = value;
            return this;
        }

        /** Builds the instance. This builder should not be touched after calling this! */
        public @NonNull Bid build() {
            checkNotUsed();
            mBuilderFieldsSet |= 0x4; // Mark builder used

            if ((mBuilderFieldsSet & 0x1) == 0) {
                mKey = "";
            }
            if ((mBuilderFieldsSet & 0x2) == 0) {
                mMetrics = null;
            }
            Bid o = new Bid(
                    mKey,
                    mMetrics);
            return o;
        }

        private void checkNotUsed() {
            if ((mBuilderFieldsSet & 0x4) != 0) {
                throw new IllegalStateException(
                        "This Builder should not be reused. Use a new Builder instance instead");
            }
        }
    }

    @DataClass.Generated(
            time = 1681847767382L,
            codegenVersion = "1.0.23",
            sourceFile = "packages/modules/OnDevicePersonalization/framework/java/android/ondevicepersonalization/Bid.java",
            inputSignatures = "private @android.annotation.NonNull java.lang.String mKey\nprivate @android.annotation.Nullable android.ondevicepersonalization.Metrics mMetrics\nclass Bid extends java.lang.Object implements [android.os.Parcelable]\n@com.android.ondevicepersonalization.internal.util.DataClass(genBuilder=true, genEqualsHashCode=true)")
    @Deprecated
    private void __metadata() {}


    //@formatter:on
    // End of generated code

}
