/*
 * Copyright (C) 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package android.ondevicepersonalization;

import android.annotation.NonNull;
import android.os.Parcelable;

import com.android.ondevicepersonalization.internal.util.AnnotationValidations;
import com.android.ondevicepersonalization.internal.util.DataClass;

/**
 * Device metrics class for static values per device.
 *
 * @hide
 */
@DataClass(genBuilder = true, genEqualsHashCode = true)
public final class DeviceMetrics implements Parcelable {
    /** Device manufacturer. See full list {@link Make}. */
    @NonNull int mMake;

    /** Device model. See full list {@link Model}. */
    @NonNull int mModel;

    /** Screen height of the device in dp units. */
    @NonNull int mScreenHeights;

    /** Screen width of the device in dp units. */
    @NonNull int mScreenWidth;

    /** Device x dpi. */
    @NonNull float mXdpi;

    /** Device y dpi. */
    @NonNull float mYdpi;

    /** Device pixel ratio. */
    @NonNull float mPxRatio;



    // Code below generated by codegen v1.0.23.
    //
    // DO NOT MODIFY!
    // CHECKSTYLE:OFF Generated code
    //
    // To regenerate run:
    // $ codegen $ANDROID_BUILD_TOP/packages/modules/OnDevicePersonalization/framework/java/android/ondevicepersonalization/DeviceMetrics.java
    //
    // To exclude the generated code from IntelliJ auto-formatting enable (one-time):
    //   Settings > Editor > Code Style > Formatter Control
    //@formatter:off


    @DataClass.Generated.Member
    /* package-private */ DeviceMetrics(
            @NonNull int make,
            @NonNull int model,
            @NonNull int screenHeights,
            @NonNull int screenWidth,
            @NonNull float xdpi,
            @NonNull float ydpi,
            @NonNull float pxRatio) {
        this.mMake = make;
        AnnotationValidations.validate(
                NonNull.class, null, mMake);
        this.mModel = model;
        AnnotationValidations.validate(
                NonNull.class, null, mModel);
        this.mScreenHeights = screenHeights;
        AnnotationValidations.validate(
                NonNull.class, null, mScreenHeights);
        this.mScreenWidth = screenWidth;
        AnnotationValidations.validate(
                NonNull.class, null, mScreenWidth);
        this.mXdpi = xdpi;
        AnnotationValidations.validate(
                NonNull.class, null, mXdpi);
        this.mYdpi = ydpi;
        AnnotationValidations.validate(
                NonNull.class, null, mYdpi);
        this.mPxRatio = pxRatio;
        AnnotationValidations.validate(
                NonNull.class, null, mPxRatio);

        // onConstructed(); // You can define this method to get a callback
    }

    /**
     * Device manufacturer. See full list {@link Make}.
     */
    @DataClass.Generated.Member
    public @NonNull int getMake() {
        return mMake;
    }

    /**
     * Device model. See full list {@link Model}.
     */
    @DataClass.Generated.Member
    public @NonNull int getModel() {
        return mModel;
    }

    /**
     * Screen height of the device in dp units.
     */
    @DataClass.Generated.Member
    public @NonNull int getScreenHeights() {
        return mScreenHeights;
    }

    /**
     * Screen width of the device in dp units.
     */
    @DataClass.Generated.Member
    public @NonNull int getScreenWidth() {
        return mScreenWidth;
    }

    /**
     * Device x dpi.
     */
    @DataClass.Generated.Member
    public @NonNull float getXdpi() {
        return mXdpi;
    }

    /**
     * Device y dpi.
     */
    @DataClass.Generated.Member
    public @NonNull float getYdpi() {
        return mYdpi;
    }

    /**
     * Device pixel ratio.
     */
    @DataClass.Generated.Member
    public @NonNull float getPxRatio() {
        return mPxRatio;
    }

    @Override
    @DataClass.Generated.Member
    public boolean equals(@android.annotation.Nullable Object o) {
        // You can override field equality logic by defining either of the methods like:
        // boolean fieldNameEquals(DeviceMetrics other) { ... }
        // boolean fieldNameEquals(FieldType otherValue) { ... }

        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        @SuppressWarnings("unchecked")
        DeviceMetrics that = (DeviceMetrics) o;
        //noinspection PointlessBooleanExpression
        return true
                && mMake == that.mMake
                && mModel == that.mModel
                && mScreenHeights == that.mScreenHeights
                && mScreenWidth == that.mScreenWidth
                && mXdpi == that.mXdpi
                && mYdpi == that.mYdpi
                && mPxRatio == that.mPxRatio;
    }

    @Override
    @DataClass.Generated.Member
    public int hashCode() {
        // You can override field hashCode logic by defining methods like:
        // int fieldNameHashCode() { ... }

        int _hash = 1;
        _hash = 31 * _hash + mMake;
        _hash = 31 * _hash + mModel;
        _hash = 31 * _hash + mScreenHeights;
        _hash = 31 * _hash + mScreenWidth;
        _hash = 31 * _hash + Float.hashCode(mXdpi);
        _hash = 31 * _hash + Float.hashCode(mYdpi);
        _hash = 31 * _hash + Float.hashCode(mPxRatio);
        return _hash;
    }

    @Override
    @DataClass.Generated.Member
    public void writeToParcel(@NonNull android.os.Parcel dest, int flags) {
        // You can override field parcelling by defining methods like:
        // void parcelFieldName(Parcel dest, int flags) { ... }

        dest.writeInt(mMake);
        dest.writeInt(mModel);
        dest.writeInt(mScreenHeights);
        dest.writeInt(mScreenWidth);
        dest.writeFloat(mXdpi);
        dest.writeFloat(mYdpi);
        dest.writeFloat(mPxRatio);
    }

    @Override
    @DataClass.Generated.Member
    public int describeContents() { return 0; }

    /** @hide */
    @SuppressWarnings({"unchecked", "RedundantCast"})
    @DataClass.Generated.Member
    /* package-private */ DeviceMetrics(@NonNull android.os.Parcel in) {
        // You can override field unparcelling by defining methods like:
        // static FieldType unparcelFieldName(Parcel in) { ... }

        int make = in.readInt();
        int model = in.readInt();
        int screenHeights = in.readInt();
        int screenWidth = in.readInt();
        float xdpi = in.readFloat();
        float ydpi = in.readFloat();
        float pxRatio = in.readFloat();

        this.mMake = make;
        AnnotationValidations.validate(
                NonNull.class, null, mMake);
        this.mModel = model;
        AnnotationValidations.validate(
                NonNull.class, null, mModel);
        this.mScreenHeights = screenHeights;
        AnnotationValidations.validate(
                NonNull.class, null, mScreenHeights);
        this.mScreenWidth = screenWidth;
        AnnotationValidations.validate(
                NonNull.class, null, mScreenWidth);
        this.mXdpi = xdpi;
        AnnotationValidations.validate(
                NonNull.class, null, mXdpi);
        this.mYdpi = ydpi;
        AnnotationValidations.validate(
                NonNull.class, null, mYdpi);
        this.mPxRatio = pxRatio;
        AnnotationValidations.validate(
                NonNull.class, null, mPxRatio);

        // onConstructed(); // You can define this method to get a callback
    }

    @DataClass.Generated.Member
    public static final @NonNull Parcelable.Creator<DeviceMetrics> CREATOR
            = new Parcelable.Creator<DeviceMetrics>() {
        @Override
        public DeviceMetrics[] newArray(int size) {
            return new DeviceMetrics[size];
        }

        @Override
        public DeviceMetrics createFromParcel(@NonNull android.os.Parcel in) {
            return new DeviceMetrics(in);
        }
    };

    /**
     * A builder for {@link DeviceMetrics}
     */
    @SuppressWarnings("WeakerAccess")
    @DataClass.Generated.Member
    public static final class Builder {

        private @NonNull int mMake;
        private @NonNull int mModel;
        private @NonNull int mScreenHeights;
        private @NonNull int mScreenWidth;
        private @NonNull float mXdpi;
        private @NonNull float mYdpi;
        private @NonNull float mPxRatio;

        private long mBuilderFieldsSet = 0L;

        /**
         * Creates a new Builder.
         *
         * @param make
         *   Device manufacturer. See full list {@link Make}.
         * @param model
         *   Device model. See full list {@link Model}.
         * @param screenHeights
         *   Screen height of the device in dp units.
         * @param screenWidth
         *   Screen width of the device in dp units.
         * @param xdpi
         *   Device x dpi.
         * @param ydpi
         *   Device y dpi.
         * @param pxRatio
         *   Device pixel ratio.
         */
        public Builder(
                @NonNull int make,
                @NonNull int model,
                @NonNull int screenHeights,
                @NonNull int screenWidth,
                @NonNull float xdpi,
                @NonNull float ydpi,
                @NonNull float pxRatio) {
            mMake = make;
            AnnotationValidations.validate(
                    NonNull.class, null, mMake);
            mModel = model;
            AnnotationValidations.validate(
                    NonNull.class, null, mModel);
            mScreenHeights = screenHeights;
            AnnotationValidations.validate(
                    NonNull.class, null, mScreenHeights);
            mScreenWidth = screenWidth;
            AnnotationValidations.validate(
                    NonNull.class, null, mScreenWidth);
            mXdpi = xdpi;
            AnnotationValidations.validate(
                    NonNull.class, null, mXdpi);
            mYdpi = ydpi;
            AnnotationValidations.validate(
                    NonNull.class, null, mYdpi);
            mPxRatio = pxRatio;
            AnnotationValidations.validate(
                    NonNull.class, null, mPxRatio);
        }

        public Builder() {
        }

        /**
         * Device manufacturer. See full list {@link Make}.
         */
        @DataClass.Generated.Member
        public @NonNull Builder setMake(@NonNull int value) {
            checkNotUsed();
            mBuilderFieldsSet |= 0x1;
            mMake = value;
            return this;
        }

        /**
         * Device model. See full list {@link Model}.
         */
        @DataClass.Generated.Member
        public @NonNull Builder setModel(@NonNull int value) {
            checkNotUsed();
            mBuilderFieldsSet |= 0x2;
            mModel = value;
            return this;
        }

        /**
         * Screen height of the device in dp units.
         */
        @DataClass.Generated.Member
        public @NonNull Builder setScreenHeights(@NonNull int value) {
            checkNotUsed();
            mBuilderFieldsSet |= 0x4;
            mScreenHeights = value;
            return this;
        }

        /**
         * Screen width of the device in dp units.
         */
        @DataClass.Generated.Member
        public @NonNull Builder setScreenWidth(@NonNull int value) {
            checkNotUsed();
            mBuilderFieldsSet |= 0x8;
            mScreenWidth = value;
            return this;
        }

        /**
         * Device x dpi.
         */
        @DataClass.Generated.Member
        public @NonNull Builder setXdpi(@NonNull float value) {
            checkNotUsed();
            mBuilderFieldsSet |= 0x10;
            mXdpi = value;
            return this;
        }

        /**
         * Device y dpi.
         */
        @DataClass.Generated.Member
        public @NonNull Builder setYdpi(@NonNull float value) {
            checkNotUsed();
            mBuilderFieldsSet |= 0x20;
            mYdpi = value;
            return this;
        }

        /**
         * Device pixel ratio.
         */
        @DataClass.Generated.Member
        public @NonNull Builder setPxRatio(@NonNull float value) {
            checkNotUsed();
            mBuilderFieldsSet |= 0x40;
            mPxRatio = value;
            return this;
        }

        /** Builds the instance. This builder should not be touched after calling this! */
        public @NonNull DeviceMetrics build() {
            checkNotUsed();
            mBuilderFieldsSet |= 0x80; // Mark builder used

            DeviceMetrics o = new DeviceMetrics(
                    mMake,
                    mModel,
                    mScreenHeights,
                    mScreenWidth,
                    mXdpi,
                    mYdpi,
                    mPxRatio);
            return o;
        }

        private void checkNotUsed() {
            if ((mBuilderFieldsSet & 0x80) != 0) {
                throw new IllegalStateException(
                        "This Builder should not be reused. Use a new Builder instance instead");
            }
        }
    }

    @DataClass.Generated(
            time = 1676499956776L,
            codegenVersion = "1.0.23",
            sourceFile = "packages/modules/OnDevicePersonalization/framework/java/android/ondevicepersonalization/DeviceMetrics.java",
            inputSignatures = " @android.annotation.NonNull int mMake\n @android.annotation.NonNull int mModel\n @android.annotation.NonNull int mScreenHeights\n @android.annotation.NonNull int mScreenWidth\n @android.annotation.NonNull float mXdpi\n @android.annotation.NonNull float mYdpi\n @android.annotation.NonNull float mPxRatio\nclass DeviceMetrics extends java.lang.Object implements [android.os.Parcelable]\n@com.android.ondevicepersonalization.internal.util.DataClass(genBuilder=true, genEqualsHashCode=true)")
    @Deprecated
    private void __metadata() {}


    //@formatter:on
    // End of generated code

}
