/*
 * Copyright (C) 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package android.ondevicepersonalization;

import android.annotation.Nullable;
import android.os.Parcelable;

import com.android.ondevicepersonalization.internal.util.DataClass;

import java.util.List;

/**
 * The result of the download post-processing task.
 *
 * @hide
 */
@DataClass(genBuilder = true, genEqualsHashCode = true)
public final class DownloadOutput implements Parcelable {
    /** The keys to be retained in the REMOTE_DATA table. */
    @Nullable private List<String> mKeysToRetain = null;



    // Code below generated by codegen v1.0.23.
    //
    // DO NOT MODIFY!
    // CHECKSTYLE:OFF Generated code
    //
    // To regenerate run:
    // $ codegen $ANDROID_BUILD_TOP/packages/modules/OnDevicePersonalization/framework/java/android/ondevicepersonalization/DownloadOutput.java
    //
    // To exclude the generated code from IntelliJ auto-formatting enable (one-time):
    //   Settings > Editor > Code Style > Formatter Control
    //@formatter:off


    @DataClass.Generated.Member
    /* package-private */ DownloadOutput(
            @Nullable List<String> keysToRetain) {
        this.mKeysToRetain = keysToRetain;

        // onConstructed(); // You can define this method to get a callback
    }

    /**
     * The keys to be retained in the REMOTE_DATA table.
     */
    @DataClass.Generated.Member
    public @Nullable List<String> getKeysToRetain() {
        return mKeysToRetain;
    }

    @Override
    @DataClass.Generated.Member
    public boolean equals(@Nullable Object o) {
        // You can override field equality logic by defining either of the methods like:
        // boolean fieldNameEquals(DownloadOutput other) { ... }
        // boolean fieldNameEquals(FieldType otherValue) { ... }

        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        @SuppressWarnings("unchecked")
        DownloadOutput that = (DownloadOutput) o;
        //noinspection PointlessBooleanExpression
        return true
                && java.util.Objects.equals(mKeysToRetain, that.mKeysToRetain);
    }

    @Override
    @DataClass.Generated.Member
    public int hashCode() {
        // You can override field hashCode logic by defining methods like:
        // int fieldNameHashCode() { ... }

        int _hash = 1;
        _hash = 31 * _hash + java.util.Objects.hashCode(mKeysToRetain);
        return _hash;
    }

    @Override
    @DataClass.Generated.Member
    public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) {
        // You can override field parcelling by defining methods like:
        // void parcelFieldName(Parcel dest, int flags) { ... }

        byte flg = 0;
        if (mKeysToRetain != null) flg |= 0x1;
        dest.writeByte(flg);
        if (mKeysToRetain != null) dest.writeStringList(mKeysToRetain);
    }

    @Override
    @DataClass.Generated.Member
    public int describeContents() { return 0; }

    /** @hide */
    @SuppressWarnings({"unchecked", "RedundantCast"})
    @DataClass.Generated.Member
    /* package-private */ DownloadOutput(@android.annotation.NonNull android.os.Parcel in) {
        // You can override field unparcelling by defining methods like:
        // static FieldType unparcelFieldName(Parcel in) { ... }

        byte flg = in.readByte();
        List<String> keysToRetain = null;
        if ((flg & 0x1) != 0) {
            keysToRetain = new java.util.ArrayList<>();
            in.readStringList(keysToRetain);
        }

        this.mKeysToRetain = keysToRetain;

        // onConstructed(); // You can define this method to get a callback
    }

    @DataClass.Generated.Member
    public static final @android.annotation.NonNull Parcelable.Creator<DownloadOutput> CREATOR
            = new Parcelable.Creator<DownloadOutput>() {
        @Override
        public DownloadOutput[] newArray(int size) {
            return new DownloadOutput[size];
        }

        @Override
        public DownloadOutput createFromParcel(@android.annotation.NonNull android.os.Parcel in) {
            return new DownloadOutput(in);
        }
    };

    /**
     * A builder for {@link DownloadOutput}
     */
    @SuppressWarnings("WeakerAccess")
    @DataClass.Generated.Member
    public static final class Builder {

        private @Nullable List<String> mKeysToRetain;

        private long mBuilderFieldsSet = 0L;

        public Builder() {
        }

        /**
         * The keys to be retained in the REMOTE_DATA table.
         */
        @DataClass.Generated.Member
        public @android.annotation.NonNull Builder setKeysToRetain(@android.annotation.NonNull List<String> value) {
            checkNotUsed();
            mBuilderFieldsSet |= 0x1;
            mKeysToRetain = value;
            return this;
        }

        /** @see #setKeysToRetain */
        @DataClass.Generated.Member
        public @android.annotation.NonNull Builder addKeysToRetain(@android.annotation.NonNull String value) {
            // You can refine this method's name by providing item's singular name, e.g.:
            // @DataClass.PluralOf("item")) mItems = ...

            if (mKeysToRetain == null) setKeysToRetain(new java.util.ArrayList<>());
            mKeysToRetain.add(value);
            return this;
        }

        /** Builds the instance. This builder should not be touched after calling this! */
        public @android.annotation.NonNull DownloadOutput build() {
            checkNotUsed();
            mBuilderFieldsSet |= 0x2; // Mark builder used

            if ((mBuilderFieldsSet & 0x1) == 0) {
                mKeysToRetain = null;
            }
            DownloadOutput o = new DownloadOutput(
                    mKeysToRetain);
            return o;
        }

        private void checkNotUsed() {
            if ((mBuilderFieldsSet & 0x2) != 0) {
                throw new IllegalStateException(
                        "This Builder should not be reused. Use a new Builder instance instead");
            }
        }
    }

    @DataClass.Generated(
            time = 1680551322132L,
            codegenVersion = "1.0.23",
            sourceFile = "packages/modules/OnDevicePersonalization/framework/java/android/ondevicepersonalization/DownloadOutput.java",
            inputSignatures = "private @android.annotation.Nullable java.util.List<java.lang.String> mKeysToRetain\nclass DownloadOutput extends java.lang.Object implements [android.os.Parcelable]\n@com.android.ondevicepersonalization.internal.util.DataClass(genBuilder=true, genEqualsHashCode=true)")
    @Deprecated
    private void __metadata() {}


    //@formatter:on
    // End of generated code

}
