/*
 * Copyright (C) 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package android.ondevicepersonalization;

import android.annotation.Nullable;
import android.os.Parcelable;

import com.android.ondevicepersonalization.internal.util.DataClass;

/**
 * The inputs required for computing event-level metrics to be logged.
 *
 * @hide
 */
@DataClass(genBuilder = true, genEqualsHashCode = true)
public final class EventInput implements Parcelable {
    /** The type of the event. */
    private int mEventType = 0;

    /** The {@link Bid} that this event is for. */
    @Nullable private Bid mBid = null;



    // Code below generated by codegen v1.0.23.
    //
    // DO NOT MODIFY!
    // CHECKSTYLE:OFF Generated code
    //
    // To regenerate run:
    // $ codegen $ANDROID_BUILD_TOP/packages/modules/OnDevicePersonalization/framework/java/android/ondevicepersonalization/EventInput.java
    //
    // To exclude the generated code from IntelliJ auto-formatting enable (one-time):
    //   Settings > Editor > Code Style > Formatter Control
    //@formatter:off


    @DataClass.Generated.Member
    /* package-private */ EventInput(
            int eventType,
            @Nullable Bid bid) {
        this.mEventType = eventType;
        this.mBid = bid;

        // onConstructed(); // You can define this method to get a callback
    }

    /**
     * The type of the event.
     */
    @DataClass.Generated.Member
    public int getEventType() {
        return mEventType;
    }

    /**
     * The {@link Bid} that this event is for.
     */
    @DataClass.Generated.Member
    public @Nullable Bid getBid() {
        return mBid;
    }

    @Override
    @DataClass.Generated.Member
    public boolean equals(@Nullable Object o) {
        // You can override field equality logic by defining either of the methods like:
        // boolean fieldNameEquals(EventInput other) { ... }
        // boolean fieldNameEquals(FieldType otherValue) { ... }

        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        @SuppressWarnings("unchecked")
        EventInput that = (EventInput) o;
        //noinspection PointlessBooleanExpression
        return true
                && mEventType == that.mEventType
                && java.util.Objects.equals(mBid, that.mBid);
    }

    @Override
    @DataClass.Generated.Member
    public int hashCode() {
        // You can override field hashCode logic by defining methods like:
        // int fieldNameHashCode() { ... }

        int _hash = 1;
        _hash = 31 * _hash + mEventType;
        _hash = 31 * _hash + java.util.Objects.hashCode(mBid);
        return _hash;
    }

    @Override
    @DataClass.Generated.Member
    public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) {
        // You can override field parcelling by defining methods like:
        // void parcelFieldName(Parcel dest, int flags) { ... }

        byte flg = 0;
        if (mBid != null) flg |= 0x2;
        dest.writeByte(flg);
        dest.writeInt(mEventType);
        if (mBid != null) dest.writeTypedObject(mBid, flags);
    }

    @Override
    @DataClass.Generated.Member
    public int describeContents() { return 0; }

    /** @hide */
    @SuppressWarnings({"unchecked", "RedundantCast"})
    @DataClass.Generated.Member
    /* package-private */ EventInput(@android.annotation.NonNull android.os.Parcel in) {
        // You can override field unparcelling by defining methods like:
        // static FieldType unparcelFieldName(Parcel in) { ... }

        byte flg = in.readByte();
        int eventType = in.readInt();
        Bid bid = (flg & 0x2) == 0 ? null : (Bid) in.readTypedObject(Bid.CREATOR);

        this.mEventType = eventType;
        this.mBid = bid;

        // onConstructed(); // You can define this method to get a callback
    }

    @DataClass.Generated.Member
    public static final @android.annotation.NonNull Parcelable.Creator<EventInput> CREATOR
            = new Parcelable.Creator<EventInput>() {
        @Override
        public EventInput[] newArray(int size) {
            return new EventInput[size];
        }

        @Override
        public EventInput createFromParcel(@android.annotation.NonNull android.os.Parcel in) {
            return new EventInput(in);
        }
    };

    /**
     * A builder for {@link EventInput}
     */
    @SuppressWarnings("WeakerAccess")
    @DataClass.Generated.Member
    public static final class Builder {

        private int mEventType;
        private @Nullable Bid mBid;

        private long mBuilderFieldsSet = 0L;

        public Builder() {
        }

        /**
         * The type of the event.
         */
        @DataClass.Generated.Member
        public @android.annotation.NonNull Builder setEventType(int value) {
            checkNotUsed();
            mBuilderFieldsSet |= 0x1;
            mEventType = value;
            return this;
        }

        /**
         * The {@link Bid} that this event is for.
         */
        @DataClass.Generated.Member
        public @android.annotation.NonNull Builder setBid(@android.annotation.NonNull Bid value) {
            checkNotUsed();
            mBuilderFieldsSet |= 0x2;
            mBid = value;
            return this;
        }

        /** Builds the instance. This builder should not be touched after calling this! */
        public @android.annotation.NonNull EventInput build() {
            checkNotUsed();
            mBuilderFieldsSet |= 0x4; // Mark builder used

            if ((mBuilderFieldsSet & 0x1) == 0) {
                mEventType = 0;
            }
            if ((mBuilderFieldsSet & 0x2) == 0) {
                mBid = null;
            }
            EventInput o = new EventInput(
                    mEventType,
                    mBid);
            return o;
        }

        private void checkNotUsed() {
            if ((mBuilderFieldsSet & 0x4) != 0) {
                throw new IllegalStateException(
                        "This Builder should not be reused. Use a new Builder instance instead");
            }
        }
    }

    @DataClass.Generated(
            time = 1681339263640L,
            codegenVersion = "1.0.23",
            sourceFile = "packages/modules/OnDevicePersonalization/framework/java/android/ondevicepersonalization/EventInput.java",
            inputSignatures = "private  int mEventType\nprivate @android.annotation.Nullable android.ondevicepersonalization.Bid mBid\nclass EventInput extends java.lang.Object implements [android.os.Parcelable]\n@com.android.ondevicepersonalization.internal.util.DataClass(genBuilder=true, genEqualsHashCode=true)")
    @Deprecated
    private void __metadata() {}


    //@formatter:on
    // End of generated code

}
