/*
 * Copyright (C) 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package android.ondevicepersonalization;

import android.annotation.Nullable;
import android.os.Parcelable;

import com.android.ondevicepersonalization.internal.util.DataClass;

/**
 * A list of per-event metrics to be logged in the Events table.
 *
 * @hide
 */
@DataClass(genBuilder = true, genEqualsHashCode = true)
public final class EventOutput implements Parcelable {
    /** The metrics to be logged with this event. */
    @Nullable Metrics mMetrics = null;



    // Code below generated by codegen v1.0.23.
    //
    // DO NOT MODIFY!
    // CHECKSTYLE:OFF Generated code
    //
    // To regenerate run:
    // $ codegen $ANDROID_BUILD_TOP/packages/modules/OnDevicePersonalization/framework/java/android/ondevicepersonalization/EventOutput.java
    //
    // To exclude the generated code from IntelliJ auto-formatting enable (one-time):
    //   Settings > Editor > Code Style > Formatter Control
    //@formatter:off


    @DataClass.Generated.Member
    /* package-private */ EventOutput(
            @Nullable Metrics metrics) {
        this.mMetrics = metrics;

        // onConstructed(); // You can define this method to get a callback
    }

    /**
     * The metrics to be logged with this event.
     */
    @DataClass.Generated.Member
    public @Nullable Metrics getMetrics() {
        return mMetrics;
    }

    @Override
    @DataClass.Generated.Member
    public boolean equals(@Nullable Object o) {
        // You can override field equality logic by defining either of the methods like:
        // boolean fieldNameEquals(EventOutput other) { ... }
        // boolean fieldNameEquals(FieldType otherValue) { ... }

        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        @SuppressWarnings("unchecked")
        EventOutput that = (EventOutput) o;
        //noinspection PointlessBooleanExpression
        return true
                && java.util.Objects.equals(mMetrics, that.mMetrics);
    }

    @Override
    @DataClass.Generated.Member
    public int hashCode() {
        // You can override field hashCode logic by defining methods like:
        // int fieldNameHashCode() { ... }

        int _hash = 1;
        _hash = 31 * _hash + java.util.Objects.hashCode(mMetrics);
        return _hash;
    }

    @Override
    @DataClass.Generated.Member
    public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) {
        // You can override field parcelling by defining methods like:
        // void parcelFieldName(Parcel dest, int flags) { ... }

        byte flg = 0;
        if (mMetrics != null) flg |= 0x1;
        dest.writeByte(flg);
        if (mMetrics != null) dest.writeTypedObject(mMetrics, flags);
    }

    @Override
    @DataClass.Generated.Member
    public int describeContents() { return 0; }

    /** @hide */
    @SuppressWarnings({"unchecked", "RedundantCast"})
    @DataClass.Generated.Member
    /* package-private */ EventOutput(@android.annotation.NonNull android.os.Parcel in) {
        // You can override field unparcelling by defining methods like:
        // static FieldType unparcelFieldName(Parcel in) { ... }

        byte flg = in.readByte();
        Metrics metrics = (flg & 0x1) == 0 ? null : (Metrics) in.readTypedObject(Metrics.CREATOR);

        this.mMetrics = metrics;

        // onConstructed(); // You can define this method to get a callback
    }

    @DataClass.Generated.Member
    public static final @android.annotation.NonNull Parcelable.Creator<EventOutput> CREATOR
            = new Parcelable.Creator<EventOutput>() {
        @Override
        public EventOutput[] newArray(int size) {
            return new EventOutput[size];
        }

        @Override
        public EventOutput createFromParcel(@android.annotation.NonNull android.os.Parcel in) {
            return new EventOutput(in);
        }
    };

    /**
     * A builder for {@link EventOutput}
     */
    @SuppressWarnings("WeakerAccess")
    @DataClass.Generated.Member
    public static final class Builder {

        private @Nullable Metrics mMetrics;

        private long mBuilderFieldsSet = 0L;

        public Builder() {
        }

        /**
         * The metrics to be logged with this event.
         */
        @DataClass.Generated.Member
        public @android.annotation.NonNull Builder setMetrics(@android.annotation.NonNull Metrics value) {
            checkNotUsed();
            mBuilderFieldsSet |= 0x1;
            mMetrics = value;
            return this;
        }

        /** Builds the instance. This builder should not be touched after calling this! */
        public @android.annotation.NonNull EventOutput build() {
            checkNotUsed();
            mBuilderFieldsSet |= 0x2; // Mark builder used

            if ((mBuilderFieldsSet & 0x1) == 0) {
                mMetrics = null;
            }
            EventOutput o = new EventOutput(
                    mMetrics);
            return o;
        }

        private void checkNotUsed() {
            if ((mBuilderFieldsSet & 0x2) != 0) {
                throw new IllegalStateException(
                        "This Builder should not be reused. Use a new Builder instance instead");
            }
        }
    }

    @DataClass.Generated(
            time = 1680551346461L,
            codegenVersion = "1.0.23",
            sourceFile = "packages/modules/OnDevicePersonalization/framework/java/android/ondevicepersonalization/EventOutput.java",
            inputSignatures = " @android.annotation.Nullable android.ondevicepersonalization.Metrics mMetrics\nclass EventOutput extends java.lang.Object implements [android.os.Parcelable]\n@com.android.ondevicepersonalization.internal.util.DataClass(genBuilder=true, genEqualsHashCode=true)")
    @Deprecated
    private void __metadata() {}


    //@formatter:on
    // End of generated code

}
