/*
 * Copyright (C) 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package android.ondevicepersonalization;

import android.annotation.Nullable;

import com.android.ondevicepersonalization.internal.util.DataClass;

/** @hide */
@DataClass(genBuilder = true, genEqualsHashCode = true)
public class EventUrlOptions {
    /** Return a 1x1 blank GIF image. */
    public static final int RESPONSE_TYPE_1X1_IMAGE = 1;

    /** Redirect to the provided destination URL. */
    public static final int RESPONSE_TYPE_REDIRECT = 2;

    /** Return a 204 No Content HTTP response. */
    public static final int RESPONSE_TYPE_NO_CONTENT = 3;

    /** The expected type of response for this URL. */
    @ResponseType
    private final int mResponseType;

    /** The destination URL to redirect to, if the response type is RESPONSE_TYPE_REDIRECT. */
    @Nullable private final String mDestinationUrl;



    // Code below generated by codegen v1.0.23.
    //
    // DO NOT MODIFY!
    // CHECKSTYLE:OFF Generated code
    //
    // To regenerate run:
    // $ codegen $ANDROID_BUILD_TOP/packages/modules/OnDevicePersonalization/framework/java/android/ondevicepersonalization/EventUrlOptions.java
    //
    // To exclude the generated code from IntelliJ auto-formatting enable (one-time):
    //   Settings > Editor > Code Style > Formatter Control
    //@formatter:off


    @android.annotation.IntDef(prefix = "RESPONSE_TYPE_", value = {
        RESPONSE_TYPE_1X1_IMAGE,
        RESPONSE_TYPE_REDIRECT,
        RESPONSE_TYPE_NO_CONTENT
    })
    @java.lang.annotation.Retention(java.lang.annotation.RetentionPolicy.SOURCE)
    @DataClass.Generated.Member
    public @interface ResponseType {}

    @DataClass.Generated.Member
    public static String responseTypeToString(@ResponseType int value) {
        switch (value) {
            case RESPONSE_TYPE_1X1_IMAGE:
                    return "RESPONSE_TYPE_1X1_IMAGE";
            case RESPONSE_TYPE_REDIRECT:
                    return "RESPONSE_TYPE_REDIRECT";
            case RESPONSE_TYPE_NO_CONTENT:
                    return "RESPONSE_TYPE_NO_CONTENT";
            default: return Integer.toHexString(value);
        }
    }

    @DataClass.Generated.Member
    /* package-private */ EventUrlOptions(
            @ResponseType int responseType,
            @Nullable String destinationUrl) {
        this.mResponseType = responseType;

        if (!(mResponseType == RESPONSE_TYPE_1X1_IMAGE)
                && !(mResponseType == RESPONSE_TYPE_REDIRECT)
                && !(mResponseType == RESPONSE_TYPE_NO_CONTENT)) {
            throw new java.lang.IllegalArgumentException(
                    "responseType was " + mResponseType + " but must be one of: "
                            + "RESPONSE_TYPE_1X1_IMAGE(" + RESPONSE_TYPE_1X1_IMAGE + "), "
                            + "RESPONSE_TYPE_REDIRECT(" + RESPONSE_TYPE_REDIRECT + "), "
                            + "RESPONSE_TYPE_NO_CONTENT(" + RESPONSE_TYPE_NO_CONTENT + ")");
        }

        this.mDestinationUrl = destinationUrl;

        // onConstructed(); // You can define this method to get a callback
    }

    /**
     * The expected type of response for this URL.
     */
    @DataClass.Generated.Member
    public @ResponseType int getResponseType() {
        return mResponseType;
    }

    /**
     * The destination URL to redirect to, if the response type is RESPONSE_TYPE_REDIRECT.
     */
    @DataClass.Generated.Member
    public @Nullable String getDestinationUrl() {
        return mDestinationUrl;
    }

    @Override
    @DataClass.Generated.Member
    public boolean equals(@Nullable Object o) {
        // You can override field equality logic by defining either of the methods like:
        // boolean fieldNameEquals(EventUrlOptions other) { ... }
        // boolean fieldNameEquals(FieldType otherValue) { ... }

        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        @SuppressWarnings("unchecked")
        EventUrlOptions that = (EventUrlOptions) o;
        //noinspection PointlessBooleanExpression
        return true
                && mResponseType == that.mResponseType
                && java.util.Objects.equals(mDestinationUrl, that.mDestinationUrl);
    }

    @Override
    @DataClass.Generated.Member
    public int hashCode() {
        // You can override field hashCode logic by defining methods like:
        // int fieldNameHashCode() { ... }

        int _hash = 1;
        _hash = 31 * _hash + mResponseType;
        _hash = 31 * _hash + java.util.Objects.hashCode(mDestinationUrl);
        return _hash;
    }

    /**
     * A builder for {@link EventUrlOptions}
     */
    @SuppressWarnings("WeakerAccess")
    @DataClass.Generated.Member
    public static class Builder {

        private @ResponseType int mResponseType;
        private @Nullable String mDestinationUrl;

        private long mBuilderFieldsSet = 0L;

        /**
         * Creates a new Builder.
         */
        public Builder() {}

        /**
         * The expected type of response for this URL.
         */
        @DataClass.Generated.Member
        public @android.annotation.NonNull Builder setResponseType(@ResponseType int value) {
            checkNotUsed();
            mBuilderFieldsSet |= 0x1;
            mResponseType = value;
            return this;
        }

        /**
         * The destination URL to redirect to, if the response type is RESPONSE_TYPE_REDIRECT.
         */
        @DataClass.Generated.Member
        public @android.annotation.NonNull Builder setDestinationUrl(@android.annotation.NonNull String value) {
            checkNotUsed();
            mBuilderFieldsSet |= 0x2;
            mDestinationUrl = value;
            return this;
        }

        /** Builds the instance. This builder should not be touched after calling this! */
        public @android.annotation.NonNull EventUrlOptions build() {
            checkNotUsed();
            mBuilderFieldsSet |= 0x4; // Mark builder used

            EventUrlOptions o = new EventUrlOptions(
                    mResponseType,
                    mDestinationUrl);
            return o;
        }

        private void checkNotUsed() {
            if ((mBuilderFieldsSet & 0x4) != 0) {
                throw new IllegalStateException(
                        "This Builder should not be reused. Use a new Builder instance instead");
            }
        }
    }

    @DataClass.Generated(
            time = 1674079433654L,
            codegenVersion = "1.0.23",
            sourceFile = "packages/modules/OnDevicePersonalization/framework/java/android/ondevicepersonalization/EventUrlOptions.java",
            inputSignatures = "public static final  int RESPONSE_TYPE_1X1_IMAGE\npublic static final  int RESPONSE_TYPE_REDIRECT\npublic static final  int RESPONSE_TYPE_NO_CONTENT\nprivate final @android.ondevicepersonalization.EventUrlOptions.ResponseType int mResponseType\nprivate final @android.annotation.Nullable java.lang.String mDestinationUrl\nclass EventUrlOptions extends java.lang.Object implements []\n@com.android.ondevicepersonalization.internal.util.DataClass(genBuilder=true, genEqualsHashCode=true)")
    @Deprecated
    private void __metadata() {}


    //@formatter:on
    // End of generated code

}
