/*
 * Copyright (C) 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package android.ondevicepersonalization;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.os.Parcelable;
import android.os.PersistableBundle;

import com.android.ondevicepersonalization.internal.util.AnnotationValidations;
import com.android.ondevicepersonalization.internal.util.DataClass;

/**
 * The input data for an {@link IsolatedComputationHandler}.
 *
 * @hide
 */
@DataClass(genBuilder = true, genEqualsHashCode = true)
public final class ExecuteInput implements Parcelable {
    /** The package name of the calling app. */
    @NonNull String mAppPackageName;

    /** Parameters provided by the app to the {@link IsolatedComputationService}. */
    @Nullable PersistableBundle mAppParams;



    // Code below generated by codegen v1.0.23.
    //
    // DO NOT MODIFY!
    // CHECKSTYLE:OFF Generated code
    //
    // To regenerate run:
    // $ codegen $ANDROID_BUILD_TOP/packages/modules/OnDevicePersonalization/framework/java/android/ondevicepersonalization/ExecuteInput.java
    //
    // To exclude the generated code from IntelliJ auto-formatting enable (one-time):
    //   Settings > Editor > Code Style > Formatter Control
    //@formatter:off


    @DataClass.Generated.Member
    /* package-private */ ExecuteInput(
            @NonNull String appPackageName,
            @Nullable PersistableBundle appParams) {
        this.mAppPackageName = appPackageName;
        AnnotationValidations.validate(
                NonNull.class, null, mAppPackageName);
        this.mAppParams = appParams;

        // onConstructed(); // You can define this method to get a callback
    }

    /**
     * The package name of the calling app.
     */
    @DataClass.Generated.Member
    public @NonNull String getAppPackageName() {
        return mAppPackageName;
    }

    /**
     * Parameters provided by the app to the {@link IsolatedComputationService}.
     */
    @DataClass.Generated.Member
    public @Nullable PersistableBundle getAppParams() {
        return mAppParams;
    }

    @Override
    @DataClass.Generated.Member
    public boolean equals(@Nullable Object o) {
        // You can override field equality logic by defining either of the methods like:
        // boolean fieldNameEquals(ExecuteInput other) { ... }
        // boolean fieldNameEquals(FieldType otherValue) { ... }

        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        @SuppressWarnings("unchecked")
        ExecuteInput that = (ExecuteInput) o;
        //noinspection PointlessBooleanExpression
        return true
                && java.util.Objects.equals(mAppPackageName, that.mAppPackageName)
                && java.util.Objects.equals(mAppParams, that.mAppParams);
    }

    @Override
    @DataClass.Generated.Member
    public int hashCode() {
        // You can override field hashCode logic by defining methods like:
        // int fieldNameHashCode() { ... }

        int _hash = 1;
        _hash = 31 * _hash + java.util.Objects.hashCode(mAppPackageName);
        _hash = 31 * _hash + java.util.Objects.hashCode(mAppParams);
        return _hash;
    }

    @Override
    @DataClass.Generated.Member
    public void writeToParcel(@NonNull android.os.Parcel dest, int flags) {
        // You can override field parcelling by defining methods like:
        // void parcelFieldName(Parcel dest, int flags) { ... }

        byte flg = 0;
        if (mAppParams != null) flg |= 0x2;
        dest.writeByte(flg);
        dest.writeString(mAppPackageName);
        if (mAppParams != null) dest.writeTypedObject(mAppParams, flags);
    }

    @Override
    @DataClass.Generated.Member
    public int describeContents() { return 0; }

    /** @hide */
    @SuppressWarnings({"unchecked", "RedundantCast"})
    @DataClass.Generated.Member
    /* package-private */ ExecuteInput(@NonNull android.os.Parcel in) {
        // You can override field unparcelling by defining methods like:
        // static FieldType unparcelFieldName(Parcel in) { ... }

        byte flg = in.readByte();
        String appPackageName = in.readString();
        PersistableBundle appParams = (flg & 0x2) == 0 ? null : (PersistableBundle) in.readTypedObject(PersistableBundle.CREATOR);

        this.mAppPackageName = appPackageName;
        AnnotationValidations.validate(
                NonNull.class, null, mAppPackageName);
        this.mAppParams = appParams;

        // onConstructed(); // You can define this method to get a callback
    }

    @DataClass.Generated.Member
    public static final @NonNull Parcelable.Creator<ExecuteInput> CREATOR
            = new Parcelable.Creator<ExecuteInput>() {
        @Override
        public ExecuteInput[] newArray(int size) {
            return new ExecuteInput[size];
        }

        @Override
        public ExecuteInput createFromParcel(@NonNull android.os.Parcel in) {
            return new ExecuteInput(in);
        }
    };

    /**
     * A builder for {@link ExecuteInput}
     */
    @SuppressWarnings("WeakerAccess")
    @DataClass.Generated.Member
    public static final class Builder {

        private @NonNull String mAppPackageName;
        private @Nullable PersistableBundle mAppParams;

        private long mBuilderFieldsSet = 0L;

        /**
         * Creates a new Builder.
         */
        public Builder() {
        }

        /**
         * Creates a new Builder.
         *
         * @param appPackageName
         *   The package name of the calling app.
         * @param appParams
         *   Parameters provided by the app to the {@link IsolatedComputationService}.
         */
        public Builder(
                @NonNull String appPackageName,
                @Nullable PersistableBundle appParams) {
            mAppPackageName = appPackageName;
            AnnotationValidations.validate(
                    NonNull.class, null, mAppPackageName);
            mAppParams = appParams;
        }

        /**
         * The package name of the calling app.
         */
        @DataClass.Generated.Member
        public @NonNull Builder setAppPackageName(@NonNull String value) {
            checkNotUsed();
            mBuilderFieldsSet |= 0x1;
            mAppPackageName = value;
            return this;
        }

        /**
         * Parameters provided by the app to the {@link IsolatedComputationService}.
         */
        @DataClass.Generated.Member
        public @NonNull Builder setAppParams(@NonNull PersistableBundle value) {
            checkNotUsed();
            mBuilderFieldsSet |= 0x2;
            mAppParams = value;
            return this;
        }

        /** Builds the instance. This builder should not be touched after calling this! */
        public @NonNull ExecuteInput build() {
            checkNotUsed();
            mBuilderFieldsSet |= 0x4; // Mark builder used

            ExecuteInput o = new ExecuteInput(
                    mAppPackageName,
                    mAppParams);
            return o;
        }

        private void checkNotUsed() {
            if ((mBuilderFieldsSet & 0x4) != 0) {
                throw new IllegalStateException(
                        "This Builder should not be reused. Use a new Builder instance instead");
            }
        }
    }

    @DataClass.Generated(
            time = 1680551305542L,
            codegenVersion = "1.0.23",
            sourceFile = "packages/modules/OnDevicePersonalization/framework/java/android/ondevicepersonalization/ExecuteInput.java",
            inputSignatures = " @android.annotation.NonNull java.lang.String mAppPackageName\n @android.annotation.Nullable android.os.PersistableBundle mAppParams\nclass ExecuteInput extends java.lang.Object implements [android.os.Parcelable]\n@com.android.ondevicepersonalization.internal.util.DataClass(genBuilder=true, genEqualsHashCode=true)")
    @Deprecated
    private void __metadata() {}


    //@formatter:on
    // End of generated code

}
