/*
 * Copyright (C) 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package android.ondevicepersonalization;

import android.annotation.NonNull;
import android.os.Parcelable;

import com.android.ondevicepersonalization.internal.util.AnnotationValidations;
import com.android.ondevicepersonalization.internal.util.DataClass;

/**
 * Most recently known location info.
 *
 * @hide
 */
@DataClass(genBuilder = true, genEqualsHashCode = true)
public final class Location implements Parcelable {
    /** Timestamp of when this location is collected. */
    @NonNull long mTimeSec;

    /** Location latitude with E4 precision. */
    @NonNull double mLatitude;

    /** Location longitude with E4 precision. */
    @NonNull double mLongitude;

    /** Location provider. See full list {@link LocationInfo.LocationProvider}. */
    @NonNull int mLocationProvider;

    /** Whether the location source is precise. */
    @NonNull boolean mPreciseLocation;



    // Code below generated by codegen v1.0.23.
    //
    // DO NOT MODIFY!
    // CHECKSTYLE:OFF Generated code
    //
    // To regenerate run:
    // $ codegen $ANDROID_BUILD_TOP/packages/modules/OnDevicePersonalization/framework/java/android/ondevicepersonalization/Location.java
    //
    // To exclude the generated code from IntelliJ auto-formatting enable (one-time):
    //   Settings > Editor > Code Style > Formatter Control
    //@formatter:off


    @DataClass.Generated.Member
    /* package-private */ Location(
            @NonNull long timeSec,
            @NonNull double latitude,
            @NonNull double longitude,
            @NonNull int locationProvider,
            @NonNull boolean preciseLocation) {
        this.mTimeSec = timeSec;
        AnnotationValidations.validate(
                NonNull.class, null, mTimeSec);
        this.mLatitude = latitude;
        AnnotationValidations.validate(
                NonNull.class, null, mLatitude);
        this.mLongitude = longitude;
        AnnotationValidations.validate(
                NonNull.class, null, mLongitude);
        this.mLocationProvider = locationProvider;
        AnnotationValidations.validate(
                NonNull.class, null, mLocationProvider);
        this.mPreciseLocation = preciseLocation;
        AnnotationValidations.validate(
                NonNull.class, null, mPreciseLocation);

        // onConstructed(); // You can define this method to get a callback
    }

    /**
     * Timestamp of when this location is collected.
     */
    @DataClass.Generated.Member
    public @NonNull long getTimeSec() {
        return mTimeSec;
    }

    /**
     * Location latitude with E4 precision.
     */
    @DataClass.Generated.Member
    public @NonNull double getLatitude() {
        return mLatitude;
    }

    /**
     * Location longitude with E4 precision.
     */
    @DataClass.Generated.Member
    public @NonNull double getLongitude() {
        return mLongitude;
    }

    /**
     * Location provider. See full list {@link LocationInfo.LocationProvider}.
     */
    @DataClass.Generated.Member
    public @NonNull int getLocationProvider() {
        return mLocationProvider;
    }

    /**
     * Whether the location source is precise.
     */
    @DataClass.Generated.Member
    public @NonNull boolean isPreciseLocation() {
        return mPreciseLocation;
    }

    @Override
    @DataClass.Generated.Member
    public boolean equals(@android.annotation.Nullable Object o) {
        // You can override field equality logic by defining either of the methods like:
        // boolean fieldNameEquals(Location other) { ... }
        // boolean fieldNameEquals(FieldType otherValue) { ... }

        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        @SuppressWarnings("unchecked")
        Location that = (Location) o;
        //noinspection PointlessBooleanExpression
        return true
                && mTimeSec == that.mTimeSec
                && mLatitude == that.mLatitude
                && mLongitude == that.mLongitude
                && mLocationProvider == that.mLocationProvider
                && mPreciseLocation == that.mPreciseLocation;
    }

    @Override
    @DataClass.Generated.Member
    public int hashCode() {
        // You can override field hashCode logic by defining methods like:
        // int fieldNameHashCode() { ... }

        int _hash = 1;
        _hash = 31 * _hash + Long.hashCode(mTimeSec);
        _hash = 31 * _hash + Double.hashCode(mLatitude);
        _hash = 31 * _hash + Double.hashCode(mLongitude);
        _hash = 31 * _hash + mLocationProvider;
        _hash = 31 * _hash + Boolean.hashCode(mPreciseLocation);
        return _hash;
    }

    @Override
    @DataClass.Generated.Member
    public void writeToParcel(@NonNull android.os.Parcel dest, int flags) {
        // You can override field parcelling by defining methods like:
        // void parcelFieldName(Parcel dest, int flags) { ... }

        byte flg = 0;
        if (mPreciseLocation) flg |= 0x10;
        dest.writeByte(flg);
        dest.writeLong(mTimeSec);
        dest.writeDouble(mLatitude);
        dest.writeDouble(mLongitude);
        dest.writeInt(mLocationProvider);
    }

    @Override
    @DataClass.Generated.Member
    public int describeContents() { return 0; }

    /** @hide */
    @SuppressWarnings({"unchecked", "RedundantCast"})
    @DataClass.Generated.Member
    /* package-private */ Location(@NonNull android.os.Parcel in) {
        // You can override field unparcelling by defining methods like:
        // static FieldType unparcelFieldName(Parcel in) { ... }

        byte flg = in.readByte();
        boolean preciseLocation = (flg & 0x10) != 0;
        long timeSec = in.readLong();
        double latitude = in.readDouble();
        double longitude = in.readDouble();
        int locationProvider = in.readInt();

        this.mTimeSec = timeSec;
        AnnotationValidations.validate(
                NonNull.class, null, mTimeSec);
        this.mLatitude = latitude;
        AnnotationValidations.validate(
                NonNull.class, null, mLatitude);
        this.mLongitude = longitude;
        AnnotationValidations.validate(
                NonNull.class, null, mLongitude);
        this.mLocationProvider = locationProvider;
        AnnotationValidations.validate(
                NonNull.class, null, mLocationProvider);
        this.mPreciseLocation = preciseLocation;
        AnnotationValidations.validate(
                NonNull.class, null, mPreciseLocation);

        // onConstructed(); // You can define this method to get a callback
    }

    @DataClass.Generated.Member
    public static final @NonNull Parcelable.Creator<Location> CREATOR
            = new Parcelable.Creator<Location>() {
        @Override
        public Location[] newArray(int size) {
            return new Location[size];
        }

        @Override
        public Location createFromParcel(@NonNull android.os.Parcel in) {
            return new Location(in);
        }
    };

    /**
     * A builder for {@link Location}
     */
    @SuppressWarnings("WeakerAccess")
    @DataClass.Generated.Member
    public static final class Builder {

        private @NonNull long mTimeSec;
        private @NonNull double mLatitude;
        private @NonNull double mLongitude;
        private @NonNull int mLocationProvider;
        private @NonNull boolean mPreciseLocation;

        private long mBuilderFieldsSet = 0L;

        /**
         * Creates a new Builder.
         *
         * @param timeSec
         *   Timestamp of when this location is collected.
         * @param latitude
         *   Location latitude with E4 precision.
         * @param longitude
         *   Location longitude with E4 precision.
         * @param locationProvider
         *   Location provider. See full list {@link LocationInfo.LocationProvider}.
         * @param preciseLocation
         *   Whether the location source is precise.
         */
        public Builder(
                @NonNull long timeSec,
                @NonNull double latitude,
                @NonNull double longitude,
                @NonNull int locationProvider,
                @NonNull boolean preciseLocation) {
            mTimeSec = timeSec;
            AnnotationValidations.validate(
                    NonNull.class, null, mTimeSec);
            mLatitude = latitude;
            AnnotationValidations.validate(
                    NonNull.class, null, mLatitude);
            mLongitude = longitude;
            AnnotationValidations.validate(
                    NonNull.class, null, mLongitude);
            mLocationProvider = locationProvider;
            AnnotationValidations.validate(
                    NonNull.class, null, mLocationProvider);
            mPreciseLocation = preciseLocation;
            AnnotationValidations.validate(
                    NonNull.class, null, mPreciseLocation);
        }

        public Builder() {
        }

        /**
         * Timestamp of when this location is collected.
         */
        @DataClass.Generated.Member
        public @NonNull Builder setTimeSec(@NonNull long value) {
            checkNotUsed();
            mBuilderFieldsSet |= 0x1;
            mTimeSec = value;
            return this;
        }

        /**
         * Location latitude with E4 precision.
         */
        @DataClass.Generated.Member
        public @NonNull Builder setLatitude(@NonNull double value) {
            checkNotUsed();
            mBuilderFieldsSet |= 0x2;
            mLatitude = value;
            return this;
        }

        /**
         * Location longitude with E4 precision.
         */
        @DataClass.Generated.Member
        public @NonNull Builder setLongitude(@NonNull double value) {
            checkNotUsed();
            mBuilderFieldsSet |= 0x4;
            mLongitude = value;
            return this;
        }

        /**
         * Location provider. See full list {@link LocationInfo.LocationProvider}.
         */
        @DataClass.Generated.Member
        public @NonNull Builder setLocationProvider(@NonNull int value) {
            checkNotUsed();
            mBuilderFieldsSet |= 0x8;
            mLocationProvider = value;
            return this;
        }

        /**
         * Whether the location source is precise.
         */
        @DataClass.Generated.Member
        public @NonNull Builder setPreciseLocation(@NonNull boolean value) {
            checkNotUsed();
            mBuilderFieldsSet |= 0x10;
            mPreciseLocation = value;
            return this;
        }

        /** Builds the instance. This builder should not be touched after calling this! */
        public @NonNull Location build() {
            checkNotUsed();
            mBuilderFieldsSet |= 0x20; // Mark builder used

            Location o = new Location(
                    mTimeSec,
                    mLatitude,
                    mLongitude,
                    mLocationProvider,
                    mPreciseLocation);
            return o;
        }

        private void checkNotUsed() {
            if ((mBuilderFieldsSet & 0x20) != 0) {
                throw new IllegalStateException(
                        "This Builder should not be reused. Use a new Builder instance instead");
            }
        }
    }

    @DataClass.Generated(
            time = 1676500006486L,
            codegenVersion = "1.0.23",
            sourceFile = "packages/modules/OnDevicePersonalization/framework/java/android/ondevicepersonalization/Location.java",
            inputSignatures = " @android.annotation.NonNull long mTimeSec\n @android.annotation.NonNull double mLatitude\n @android.annotation.NonNull double mLongitude\n @android.annotation.NonNull int mLocationProvider\n @android.annotation.NonNull boolean mPreciseLocation\nclass Location extends java.lang.Object implements [android.os.Parcelable]\n@com.android.ondevicepersonalization.internal.util.DataClass(genBuilder=true, genEqualsHashCode=true)")
    @Deprecated
    private void __metadata() {}


    //@formatter:on
    // End of generated code

}
