/*
 * Copyright (C) 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package android.ondevicepersonalization;

import android.annotation.Nullable;
import android.os.Parcelable;

import com.android.ondevicepersonalization.internal.util.DataClass;

import java.util.List;

/**
 * The rendering input data for an {@link IsolatedComputationHandler}.
 *
 * @hide
 */
@DataClass(genBuilder = true, genEqualsHashCode = true)
public final class RenderInput implements Parcelable {
    /** Properties of the slot to be rendered in. */
    @Nullable SlotInfo mSlotInfo = null;

    /** A List of Bid Keys to be rendered. Keys must be present in REMOTE_DATA. */
    @Nullable List<String> mBidKeys = null;



    // Code below generated by codegen v1.0.23.
    //
    // DO NOT MODIFY!
    // CHECKSTYLE:OFF Generated code
    //
    // To regenerate run:
    // $ codegen $ANDROID_BUILD_TOP/packages/modules/OnDevicePersonalization/framework/java/android/ondevicepersonalization/RenderInput.java
    //
    // To exclude the generated code from IntelliJ auto-formatting enable (one-time):
    //   Settings > Editor > Code Style > Formatter Control
    //@formatter:off


    @DataClass.Generated.Member
    /* package-private */ RenderInput(
            @Nullable SlotInfo slotInfo,
            @Nullable List<String> bidKeys) {
        this.mSlotInfo = slotInfo;
        this.mBidKeys = bidKeys;

        // onConstructed(); // You can define this method to get a callback
    }

    /**
     * Properties of the slot to be rendered in.
     */
    @DataClass.Generated.Member
    public @Nullable SlotInfo getSlotInfo() {
        return mSlotInfo;
    }

    /**
     * A List of Bid Keys to be rendered. Keys must be present in REMOTE_DATA.
     */
    @DataClass.Generated.Member
    public @Nullable List<String> getBidKeys() {
        return mBidKeys;
    }

    @Override
    @DataClass.Generated.Member
    public boolean equals(@Nullable Object o) {
        // You can override field equality logic by defining either of the methods like:
        // boolean fieldNameEquals(RenderInput other) { ... }
        // boolean fieldNameEquals(FieldType otherValue) { ... }

        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        @SuppressWarnings("unchecked")
        RenderInput that = (RenderInput) o;
        //noinspection PointlessBooleanExpression
        return true
                && java.util.Objects.equals(mSlotInfo, that.mSlotInfo)
                && java.util.Objects.equals(mBidKeys, that.mBidKeys);
    }

    @Override
    @DataClass.Generated.Member
    public int hashCode() {
        // You can override field hashCode logic by defining methods like:
        // int fieldNameHashCode() { ... }

        int _hash = 1;
        _hash = 31 * _hash + java.util.Objects.hashCode(mSlotInfo);
        _hash = 31 * _hash + java.util.Objects.hashCode(mBidKeys);
        return _hash;
    }

    @Override
    @DataClass.Generated.Member
    public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) {
        // You can override field parcelling by defining methods like:
        // void parcelFieldName(Parcel dest, int flags) { ... }

        byte flg = 0;
        if (mSlotInfo != null) flg |= 0x1;
        if (mBidKeys != null) flg |= 0x2;
        dest.writeByte(flg);
        if (mSlotInfo != null) dest.writeTypedObject(mSlotInfo, flags);
        if (mBidKeys != null) dest.writeStringList(mBidKeys);
    }

    @Override
    @DataClass.Generated.Member
    public int describeContents() { return 0; }

    /** @hide */
    @SuppressWarnings({"unchecked", "RedundantCast"})
    @DataClass.Generated.Member
    /* package-private */ RenderInput(@android.annotation.NonNull android.os.Parcel in) {
        // You can override field unparcelling by defining methods like:
        // static FieldType unparcelFieldName(Parcel in) { ... }

        byte flg = in.readByte();
        SlotInfo slotInfo = (flg & 0x1) == 0 ? null : (SlotInfo) in.readTypedObject(SlotInfo.CREATOR);
        List<String> bidKeys = null;
        if ((flg & 0x2) != 0) {
            bidKeys = new java.util.ArrayList<>();
            in.readStringList(bidKeys);
        }

        this.mSlotInfo = slotInfo;
        this.mBidKeys = bidKeys;

        // onConstructed(); // You can define this method to get a callback
    }

    @DataClass.Generated.Member
    public static final @android.annotation.NonNull Parcelable.Creator<RenderInput> CREATOR
            = new Parcelable.Creator<RenderInput>() {
        @Override
        public RenderInput[] newArray(int size) {
            return new RenderInput[size];
        }

        @Override
        public RenderInput createFromParcel(@android.annotation.NonNull android.os.Parcel in) {
            return new RenderInput(in);
        }
    };

    /**
     * A builder for {@link RenderInput}
     */
    @SuppressWarnings("WeakerAccess")
    @DataClass.Generated.Member
    public static final class Builder {

        private @Nullable SlotInfo mSlotInfo;
        private @Nullable List<String> mBidKeys;

        private long mBuilderFieldsSet = 0L;

        public Builder() {
        }

        /**
         * Properties of the slot to be rendered in.
         */
        @DataClass.Generated.Member
        public @android.annotation.NonNull Builder setSlotInfo(@android.annotation.NonNull SlotInfo value) {
            checkNotUsed();
            mBuilderFieldsSet |= 0x1;
            mSlotInfo = value;
            return this;
        }

        /**
         * A List of Bid Keys to be rendered. Keys must be present in REMOTE_DATA.
         */
        @DataClass.Generated.Member
        public @android.annotation.NonNull Builder setBidKeys(@android.annotation.NonNull List<String> value) {
            checkNotUsed();
            mBuilderFieldsSet |= 0x2;
            mBidKeys = value;
            return this;
        }

        /** @see #setBidKeys */
        @DataClass.Generated.Member
        public @android.annotation.NonNull Builder addBidKeys(@android.annotation.NonNull String value) {
            // You can refine this method's name by providing item's singular name, e.g.:
            // @DataClass.PluralOf("item")) mItems = ...

            if (mBidKeys == null) setBidKeys(new java.util.ArrayList<>());
            mBidKeys.add(value);
            return this;
        }

        /** Builds the instance. This builder should not be touched after calling this! */
        public @android.annotation.NonNull RenderInput build() {
            checkNotUsed();
            mBuilderFieldsSet |= 0x4; // Mark builder used

            if ((mBuilderFieldsSet & 0x1) == 0) {
                mSlotInfo = null;
            }
            if ((mBuilderFieldsSet & 0x2) == 0) {
                mBidKeys = null;
            }
            RenderInput o = new RenderInput(
                    mSlotInfo,
                    mBidKeys);
            return o;
        }

        private void checkNotUsed() {
            if ((mBuilderFieldsSet & 0x4) != 0) {
                throw new IllegalStateException(
                        "This Builder should not be reused. Use a new Builder instance instead");
            }
        }
    }

    @DataClass.Generated(
            time = 1681848000397L,
            codegenVersion = "1.0.23",
            sourceFile = "packages/modules/OnDevicePersonalization/framework/java/android/ondevicepersonalization/RenderInput.java",
            inputSignatures = " @android.annotation.Nullable android.ondevicepersonalization.SlotInfo mSlotInfo\n @android.annotation.Nullable java.util.List<java.lang.String> mBidKeys\nclass RenderInput extends java.lang.Object implements [android.os.Parcelable]\n@com.android.ondevicepersonalization.internal.util.DataClass(genBuilder=true, genEqualsHashCode=true)")
    @Deprecated
    private void __metadata() {}


    //@formatter:on
    // End of generated code

}
