// This file is autogenerated

package com.android.cellbroadcastservice;


import android.os.Build;
import android.util.StatsEvent;
import android.util.StatsLog;


/**
 * Utility class for logging statistics events.
 */
public final class CellBroadcastStatsLog {
    // Constants for atom codes.

    /**
     * CellBroadcastMessageReported cb_message_reported<br>
     * Usage: StatsLog.write(StatsLog.CB_MESSAGE_REPORTED, int type, int source, int serial_number, int message_id);<br>
     */
    public static final int CB_MESSAGE_REPORTED = 249;

    /**
     * CellBroadcastMessageError cb_message_error<br>
     * Usage: StatsLog.write(StatsLog.CB_MESSAGE_ERROR, int type, java.lang.String exception_message);<br>
     */
    public static final int CB_MESSAGE_ERROR = 250;

    /**
     * CellBroadcastMessageFiltered cb_message_filtered<br>
     * Usage: StatsLog.write(StatsLog.CB_MESSAGE_FILTERED, int type, int filter, int serial_number, int message_id);<br>
     */
    public static final int CB_MESSAGE_FILTERED = 278;

    /**
     * CellBroadcastConfigUpdated cb_config_updated<br>
     * Usage: StatsLog.write(StatsLog.CB_CONFIG_UPDATED, java.lang.String roaming_mcc_mnc, byte[] channel_ranges);<br>
     */
    public static final int CB_CONFIG_UPDATED = 479;

    /**
     * CellBroadcastModuleErrorReported cb_module_error_reported<br>
     * Usage: StatsLog.write(StatsLog.CB_MODULE_ERROR_REPORTED, int source, int type);<br>
     */
    public static final int CB_MODULE_ERROR_REPORTED = 480;

    /**
     * CellBroadcastServiceFeatureChanged cb_service_feature_changed<br>
     * Usage: StatsLog.write(StatsLog.CB_SERVICE_FEATURE_CHANGED, boolean overlay_additional_cbr_packages, boolean overlay_area_info_packages, boolean reset_area_info);<br>
     */
    public static final int CB_SERVICE_FEATURE_CHANGED = 481;

    /**
     * CellBroadcastReceiverFeatureChanged cb_receiver_feature_changed<br>
     * Usage: StatsLog.write(StatsLog.CB_RECEIVER_FEATURE_CHANGED, boolean alert_during_call, byte[] override_dnd, boolean roaming_support, boolean store_sms, boolean testing_mode, boolean tts_mode, boolean testing_mode_on_user_build);<br>
     */
    public static final int CB_RECEIVER_FEATURE_CHANGED = 482;

    // Constants for enum values.

    // Values for CellBroadcastMessageReported.type
    public static final int CELL_BROADCAST_MESSAGE_REPORTED__TYPE__UNKNOWN_TYPE = 0;
    public static final int CELL_BROADCAST_MESSAGE_REPORTED__TYPE__GSM = 1;
    public static final int CELL_BROADCAST_MESSAGE_REPORTED__TYPE__CDMA = 2;
    public static final int CELL_BROADCAST_MESSAGE_REPORTED__TYPE__CDMA_SPC = 3;

    // Values for CellBroadcastMessageReported.source
    public static final int CELL_BROADCAST_MESSAGE_REPORTED__SOURCE__UNKNOWN_SOURCE = 0;
    public static final int CELL_BROADCAST_MESSAGE_REPORTED__SOURCE__FRAMEWORK = 1;
    public static final int CELL_BROADCAST_MESSAGE_REPORTED__SOURCE__CB_SERVICE = 2;
    public static final int CELL_BROADCAST_MESSAGE_REPORTED__SOURCE__CB_RECEIVER_APP = 3;

    // Values for CellBroadcastMessageError.type
    public static final int CELL_BROADCAST_MESSAGE_ERROR__TYPE__UNKNOWN_TYPE = 0;
    public static final int CELL_BROADCAST_MESSAGE_ERROR__TYPE__CDMA_DECODING_ERROR = 1;
    public static final int CELL_BROADCAST_MESSAGE_ERROR__TYPE__CDMA_SCP_EMPTY = 2;
    public static final int CELL_BROADCAST_MESSAGE_ERROR__TYPE__CDMA_SCP_HANDLING_ERROR = 3;
    public static final int CELL_BROADCAST_MESSAGE_ERROR__TYPE__GSM_INVALID_HEADER_LENGTH = 4;
    public static final int CELL_BROADCAST_MESSAGE_ERROR__TYPE__GSM_UNSUPPORTED_HEADER_MESSAGE_TYPE = 5;
    public static final int CELL_BROADCAST_MESSAGE_ERROR__TYPE__GSM_UNSUPPORTED_HEADER_DATA_CODING_SCHEME = 6;
    public static final int CELL_BROADCAST_MESSAGE_ERROR__TYPE__GSM_INVALID_PDU = 7;
    public static final int CELL_BROADCAST_MESSAGE_ERROR__TYPE__GSM_INVALID_GEO_FENCING_DATA = 8;
    public static final int CELL_BROADCAST_MESSAGE_ERROR__TYPE__GSM_UMTS_INVALID_WAC = 9;
    public static final int CELL_BROADCAST_MESSAGE_ERROR__TYPE__FAILED_TO_INSERT_TO_DB = 10;
    public static final int CELL_BROADCAST_MESSAGE_ERROR__TYPE__UNEXPECTED_GEOMETRY_FROM_FWK = 11;
    public static final int CELL_BROADCAST_MESSAGE_ERROR__TYPE__UNEXPECTED_GSM_MESSAGE_TYPE_FROM_FWK = 12;
    public static final int CELL_BROADCAST_MESSAGE_ERROR__TYPE__UNEXPECTED_CDMA_MESSAGE_TYPE_FROM_FWK = 13;
    public static final int CELL_BROADCAST_MESSAGE_ERROR__TYPE__UNEXPECTED_CDMA_SCP_MESSAGE_TYPE_FROM_FWK = 14;
    public static final int CELL_BROADCAST_MESSAGE_ERROR__TYPE__NO_CONNECTION_TO_CB_SERVICE = 15;

    // Values for CellBroadcastMessageFiltered.type
    public static final int CELL_BROADCAST_MESSAGE_FILTERED__TYPE__UNKNOWN_TYPE = 0;
    public static final int CELL_BROADCAST_MESSAGE_FILTERED__TYPE__GSM = 1;
    public static final int CELL_BROADCAST_MESSAGE_FILTERED__TYPE__CDMA = 2;
    public static final int CELL_BROADCAST_MESSAGE_FILTERED__TYPE__CDMA_SPC = 3;

    // Values for CellBroadcastMessageFiltered.filter
    public static final int CELL_BROADCAST_MESSAGE_FILTERED__FILTER__NOT_FILTERED = 0;
    public static final int CELL_BROADCAST_MESSAGE_FILTERED__FILTER__DUPLICATE_MESSAGE = 1;
    public static final int CELL_BROADCAST_MESSAGE_FILTERED__FILTER__GEOFENCED_MESSAGE = 2;
    public static final int CELL_BROADCAST_MESSAGE_FILTERED__FILTER__AREA_INFO_MESSAGE = 3;
    public static final int CELL_BROADCAST_MESSAGE_FILTERED__FILTER__DISABLED_BY_OEM = 4;
    public static final int CELL_BROADCAST_MESSAGE_FILTERED__FILTER__NOTSHOW_ECBM = 5;
    public static final int CELL_BROADCAST_MESSAGE_FILTERED__FILTER__NOTSHOW_USER_PREF = 6;
    public static final int CELL_BROADCAST_MESSAGE_FILTERED__FILTER__NOTSHOW_EMPTY_BODY = 7;
    public static final int CELL_BROADCAST_MESSAGE_FILTERED__FILTER__NOTSHOW_MISMATCH_PREF_SECOND_LANG = 8;
    public static final int CELL_BROADCAST_MESSAGE_FILTERED__FILTER__NOTSHOW_PREF_SECONDLANG_OFF = 9;
    public static final int CELL_BROADCAST_MESSAGE_FILTERED__FILTER__NOTSHOW_MISMATCH_DEVICE_LANG_SETTING = 10;
    public static final int CELL_BROADCAST_MESSAGE_FILTERED__FILTER__NOTSHOW_MESSAGE_FOR_TESTMODE = 11;
    public static final int CELL_BROADCAST_MESSAGE_FILTERED__FILTER__NOTSHOW_FILTER_STRING = 12;

    // Values for CellBroadcastModuleErrorReported.source
    public static final int CELL_BROADCAST_MODULE_ERROR_REPORTED__SOURCE__UNKNOWN_SOURCE = 0;
    public static final int CELL_BROADCAST_MODULE_ERROR_REPORTED__SOURCE__FRAMEWORK = 1;
    public static final int CELL_BROADCAST_MODULE_ERROR_REPORTED__SOURCE__CB_SERVICE = 2;
    public static final int CELL_BROADCAST_MODULE_ERROR_REPORTED__SOURCE__CB_RECEIVER_APP = 3;

    // Values for CellBroadcastModuleErrorReported.type
    public static final int CELL_BROADCAST_MODULE_ERROR_REPORTED__TYPE__ERROR_UNKNOWN = 0;
    public static final int CELL_BROADCAST_MODULE_ERROR_REPORTED__TYPE__ERROR_BAD_CONFIG = 1;
    public static final int CELL_BROADCAST_MODULE_ERROR_REPORTED__TYPE__ERROR_DB_MIGRATION = 2;
    public static final int CELL_BROADCAST_MODULE_ERROR_REPORTED__TYPE__ERROR_DEFAULT_RES = 3;
    public static final int CELL_BROADCAST_MODULE_ERROR_REPORTED__TYPE__ERROR_ENABLE_CHANNEL = 4;
    public static final int CELL_BROADCAST_MODULE_ERROR_REPORTED__TYPE__ERROR_GET_LOCATION = 5;
    public static final int CELL_BROADCAST_MODULE_ERROR_REPORTED__TYPE__ERROR_MISSING_RES = 6;
    public static final int CELL_BROADCAST_MODULE_ERROR_REPORTED__TYPE__ERROR_PLAY_FLASH = 7;
    public static final int CELL_BROADCAST_MODULE_ERROR_REPORTED__TYPE__ERROR_PLAY_SOUND = 8;
    public static final int CELL_BROADCAST_MODULE_ERROR_REPORTED__TYPE__ERROR_PLAY_TTS = 9;
    public static final int CELL_BROADCAST_MODULE_ERROR_REPORTED__TYPE__ERROR_PREF_MIGRATION = 10;
    public static final int CELL_BROADCAST_MODULE_ERROR_REPORTED__TYPE__ERROR_PROVIDER_INIT = 11;
    public static final int CELL_BROADCAST_MODULE_ERROR_REPORTED__TYPE__ERROR_RESET_CHANNEL_R = 12;
    public static final int CELL_BROADCAST_MODULE_ERROR_REPORTED__TYPE__ERROR_STATUS_BAR = 13;
    public static final int CELL_BROADCAST_MODULE_ERROR_REPORTED__TYPE__ERROR_REMINDER_INTERVAL = 14;
    public static final int CELL_BROADCAST_MODULE_ERROR_REPORTED__TYPE__ERROR_ICON_RESOURCE = 15;
    public static final int CELL_BROADCAST_MODULE_ERROR_REPORTED__TYPE__ERROR_CHANNEL_RANGE_PARSE = 16;
    public static final int CELL_BROADCAST_MODULE_ERROR_REPORTED__TYPE__ERROR_DB_INIT = 17;
    public static final int CELL_BROADCAST_MODULE_ERROR_REPORTED__TYPE__ERROR_NOT_FOUND_DEFAULT_CBR_PKGS = 18;
    public static final int CELL_BROADCAST_MODULE_ERROR_REPORTED__TYPE__ERROR_FOUND_MULTIPLE_CBR_PKGS = 19;

    // Annotation constants.
    public static final byte ANNOTATION_ID_IS_UID =
            Build.VERSION.SDK_INT <= Build.VERSION_CODES.R ?
            1 : StatsLog.ANNOTATION_ID_IS_UID;

    public static final byte ANNOTATION_ID_TRUNCATE_TIMESTAMP =
            Build.VERSION.SDK_INT <= Build.VERSION_CODES.R ?
            2 : StatsLog.ANNOTATION_ID_TRUNCATE_TIMESTAMP;

    public static final byte ANNOTATION_ID_PRIMARY_FIELD =
            Build.VERSION.SDK_INT <= Build.VERSION_CODES.R ?
            3 : StatsLog.ANNOTATION_ID_PRIMARY_FIELD;

    public static final byte ANNOTATION_ID_EXCLUSIVE_STATE =
            Build.VERSION.SDK_INT <= Build.VERSION_CODES.R ?
            4 : StatsLog.ANNOTATION_ID_EXCLUSIVE_STATE;

    public static final byte ANNOTATION_ID_PRIMARY_FIELD_FIRST_UID =
            Build.VERSION.SDK_INT <= Build.VERSION_CODES.R ?
            5 : StatsLog.ANNOTATION_ID_PRIMARY_FIELD_FIRST_UID;

    public static final byte ANNOTATION_ID_DEFAULT_STATE =
            Build.VERSION.SDK_INT <= Build.VERSION_CODES.R ?
            6 : StatsLog.ANNOTATION_ID_DEFAULT_STATE;

    public static final byte ANNOTATION_ID_TRIGGER_STATE_RESET =
            Build.VERSION.SDK_INT <= Build.VERSION_CODES.R ?
            7 : StatsLog.ANNOTATION_ID_TRIGGER_STATE_RESET;

    public static final byte ANNOTATION_ID_STATE_NESTED =
            Build.VERSION.SDK_INT <= Build.VERSION_CODES.R ?
            8 : StatsLog.ANNOTATION_ID_STATE_NESTED;


    // Write methods
    public static void write(int code, boolean arg1, byte[] arg2, boolean arg3, boolean arg4, boolean arg5, boolean arg6, boolean arg7) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeBoolean(arg1);
        builder.writeByteArray(null == arg2 ? new byte[0] : arg2);
        builder.writeBoolean(arg3);
        builder.writeBoolean(arg4);
        builder.writeBoolean(arg5);
        builder.writeBoolean(arg6);
        builder.writeBoolean(arg7);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, boolean arg1, boolean arg2, boolean arg3) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeBoolean(arg1);
        builder.writeBoolean(arg2);
        builder.writeBoolean(arg3);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, int arg2) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeInt(arg2);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, int arg2, int arg3, int arg4) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeInt(arg2);
        builder.writeInt(arg3);
        builder.writeInt(arg4);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, java.lang.String arg2) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeString(arg2);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, java.lang.String arg1, byte[] arg2) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeString(arg1);
        builder.writeByteArray(null == arg2 ? new byte[0] : arg2);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

}
