/* GENERATED SOURCE. DO NOT MODIFY. */
/*
 * Copyright (C) 2022 The Libphonenumber Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.android.i18n.phonenumbers.metadata.source;

import java.util.regex.Pattern;

/**
 * {@link PhoneMetadataFileNameProvider} implementation which appends key as a suffix to the
 * predefined metadata file name base.
 * @hide This class is not part of the Android public SDK API
 */
public final class MultiFileModeFileNameProvider implements PhoneMetadataFileNameProvider {

  private final String phoneMetadataFileNamePrefix;
  private static final Pattern ALPHANUMERIC = Pattern.compile("^[\\p{L}\\p{N}]+$");

  public MultiFileModeFileNameProvider(String phoneMetadataFileNameBase) {
    this.phoneMetadataFileNamePrefix = phoneMetadataFileNameBase + "_";
  }

  @Override
  public String getFor(Object key) {
    String keyAsString = key.toString();
    if (!ALPHANUMERIC.matcher(keyAsString).matches()) {
      throw new IllegalArgumentException("Invalid key: " + keyAsString);
    }
    return phoneMetadataFileNamePrefix + key;
  }
}
