// This file is autogenerated

package com.android.internal.telephony;


import android.os.Build;
import android.util.StatsEvent;
import android.util.StatsLog;


/**
 * Utility class for logging statistics events.
 */
public final class TelephonyStatsLog {
    // Constants for atom codes.

    /**
     * MobileConnectionStateChanged mobile_connection_state_changed<br>
     * Usage: StatsLog.write(StatsLog.MOBILE_CONNECTION_STATE_CHANGED, int state, int sim_slot_index, int data_connection_id, long capabilities, boolean has_internet);<br>
     */
    public static final int MOBILE_CONNECTION_STATE_CHANGED = 75;

    /**
     * MobileRadioTechnologyChanged mobile_radio_technology_changed<br>
     * Usage: StatsLog.write(StatsLog.MOBILE_RADIO_TECHNOLOGY_CHANGED, int state, int sim_slot_index);<br>
     */
    public static final int MOBILE_RADIO_TECHNOLOGY_CHANGED = 76;

    /**
     * AirplaneMode airplane_mode<br>
     * Usage: StatsLog.write(StatsLog.AIRPLANE_MODE, boolean is_enabled, boolean short_toggle, int carrier_id);<br>
     */
    public static final int AIRPLANE_MODE = 311;

    /**
     * ModemRestart modem_restart<br>
     * Usage: StatsLog.write(StatsLog.MODEM_RESTART, java.lang.String baseband_version, java.lang.String reason, int carrier_id);<br>
     */
    public static final int MODEM_RESTART = 312;

    /**
     * CarrierIdMismatchReported carrier_id_mismatch_reported<br>
     * Usage: StatsLog.write(StatsLog.CARRIER_ID_MISMATCH_REPORTED, int carrier_id, java.lang.String mcc_mnc, java.lang.String gid1, java.lang.String spn, java.lang.String pnn);<br>
     */
    public static final int CARRIER_ID_MISMATCH_REPORTED = 313;

    /**
     * CarrierIdTableUpdated carrier_id_table_updated<br>
     * Usage: StatsLog.write(StatsLog.CARRIER_ID_TABLE_UPDATED, int table_version);<br>
     */
    public static final int CARRIER_ID_TABLE_UPDATED = 314;

    /**
     * DataStallRecoveryReported data_stall_recovery_reported<br>
     * Usage: StatsLog.write(StatsLog.DATA_STALL_RECOVERY_REPORTED, int carrier_id, int rat, int signal_strength, int action, boolean is_opportunistic, boolean is_multi_sim, int band, boolean recovered, int duration_millis, int reason, int other_phone_signal_strength, int other_phone_reg_state, int phone_reg_state, boolean is_first_validation_after_recovery, int phone_id, int duration_millis_of_current_action);<br>
     */
    public static final int DATA_STALL_RECOVERY_REPORTED = 315;

    /**
     * SimSpecificSettingsRestored sim_specific_settings_restored<br>
     * Usage: StatsLog.write(StatsLog.SIM_SPECIFIC_SETTINGS_RESTORED, int result, int restored_from_suw, int matching_criteria);<br>
     */
    public static final int SIM_SPECIFIC_SETTINGS_RESTORED = 334;

    /**
     * PinStorageEvent pin_storage_event<br>
     * Usage: StatsLog.write(StatsLog.PIN_STORAGE_EVENT, int event, int number_of_pins, java.lang.String package_name);<br>
     */
    public static final int PIN_STORAGE_EVENT = 336;

    /**
     * MmsSmsProviderGetThreadIdFailed mms_sms_provider_get_thread_id_failed<br>
     * Usage: StatsLog.write(StatsLog.MMS_SMS_PROVIDER_GET_THREAD_ID_FAILED, int failure_code);<br>
     */
    public static final int MMS_SMS_PROVIDER_GET_THREAD_ID_FAILED = 442;

    /**
     * MmsSmsDatabaseHelperOnUpgradeFailed mms_sms_database_helper_on_upgrade_failed<br>
     * Usage: StatsLog.write(StatsLog.MMS_SMS_DATABASE_HELPER_ON_UPGRADE_FAILED, int old_version, int current_version, int upgrade_failed_to_version, int failure_code);<br>
     */
    public static final int MMS_SMS_DATABASE_HELPER_ON_UPGRADE_FAILED = 443;

    /**
     * TelephonyAnomalyDetected telephony_anomaly_detected<br>
     * Usage: StatsLog.write(StatsLog.TELEPHONY_ANOMALY_DETECTED, int carrier_id, long event_id_lsb, long event_id_msb);<br>
     */
    public static final int TELEPHONY_ANOMALY_DETECTED = 461;

    /**
     * VoiceCallSession voice_call_session<br>
     * Usage: StatsLog.write(StatsLog.VOICE_CALL_SESSION, int bearer_at_start, int bearer_at_end, int direction, int setup_duration, boolean setup_failed, int disconnect_reason_code, int disconnect_extra_code, java.lang.String disconnect_extra_message, int rat_at_start, int rat_at_end, long rat_switch_count, long codec_bitmask, int concurrent_call_count_at_start, int concurrent_call_count_at_end, int sim_slot_index, boolean is_multi_sim, boolean is_esim, int carrier_id, boolean srvcc_completed, long srvcc_failure_count, long srvcc_cancellation_count, boolean rtt_enabled, boolean is_emergency, boolean is_roaming, int dimension, int signal_strength_at_end, int band_at_end, int setup_duration_millis, int main_codec_quality, boolean video_enabled, int rat_at_connected, boolean is_multiparty, int call_duration, int last_known_rat, int fold_state);<br>
     */
    public static final int VOICE_CALL_SESSION = 10076;

    /**
     * VoiceCallRatUsage voice_call_rat_usage<br>
     * Usage: StatsLog.write(StatsLog.VOICE_CALL_RAT_USAGE, int carrier_id, int rat, long total_duration_seconds, long call_count);<br>
     */
    public static final int VOICE_CALL_RAT_USAGE = 10077;

    /**
     * SimSlotState sim_slot_state<br>
     * Usage: StatsLog.write(StatsLog.SIM_SLOT_STATE, int active_slot_count, int sim_count, int esim_count);<br>
     */
    public static final int SIM_SLOT_STATE = 10078;

    /**
     * SupportedRadioAccessFamily supported_radio_access_family<br>
     * Usage: StatsLog.write(StatsLog.SUPPORTED_RADIO_ACCESS_FAMILY, long network_type_bitmask);<br>
     */
    public static final int SUPPORTED_RADIO_ACCESS_FAMILY = 10079;

    /**
     * IncomingSms incoming_sms<br>
     * Usage: StatsLog.write(StatsLog.INCOMING_SMS, int sms_format, int sms_tech, int rat, int sms_type, int total_parts, int received_parts, boolean blocked, int error, boolean is_roaming, int sim_slot_index, boolean is_multi_sim, boolean is_esim, int carrier_id, long message_id, int count, boolean is_managed_profile);<br>
     */
    public static final int INCOMING_SMS = 10086;

    /**
     * OutgoingSms outgoing_sms<br>
     * Usage: StatsLog.write(StatsLog.OUTGOING_SMS, int sms_format, int sms_tech, int rat, int send_result, int error_code, boolean is_roaming, boolean is_from_default_app, int sim_slot_index, boolean is_multi_sim, boolean is_esim, int carrier_id, long message_id, int retry_id, long interval_millis, int count, int send_error_code, int network_error_code, boolean is_managed_profile);<br>
     */
    public static final int OUTGOING_SMS = 10087;

    /**
     * CarrierIdTableVersion carrier_id_table_version<br>
     * Usage: StatsLog.write(StatsLog.CARRIER_ID_TABLE_VERSION, int table_version);<br>
     */
    public static final int CARRIER_ID_TABLE_VERSION = 10088;

    /**
     * DataCallSession data_call_session<br>
     * Usage: StatsLog.write(StatsLog.DATA_CALL_SESSION, int dimension, boolean is_multi_sim, boolean is_esim, int profile, int apn_type_bitmask, int carrier_id, boolean is_roaming, int rat_at_end, boolean oos_at_end, long rat_switch_count, boolean is_opportunistic, int ip_type, boolean setup_failed, int failure_cause, int suggested_retry_millis, int deactivate_reason, long duration_minutes, boolean ongoing, int band_at_end, int[] handover_failure_causes, int[] handover_failure_rat, boolean is_non_dds);<br>
     */
    public static final int DATA_CALL_SESSION = 10089;

    /**
     * CellularServiceState cellular_service_state<br>
     * Usage: StatsLog.write(StatsLog.CELLULAR_SERVICE_STATE, int voice_rat, int data_rat, int voice_roaming_type, int data_roaming_type, boolean is_endc, int sim_slot_index, boolean is_multi_sim, int carrier_id, int total_time_seconds, boolean is_emergency_only, boolean is_internet_pdn_up, int fold_state);<br>
     */
    public static final int CELLULAR_SERVICE_STATE = 10090;

    /**
     * CellularDataServiceSwitch cellular_data_service_switch<br>
     * Usage: StatsLog.write(StatsLog.CELLULAR_DATA_SERVICE_SWITCH, int rat_from, int rat_to, int sim_slot_index, boolean is_multi_sim, int carrier_id, int switch_count);<br>
     */
    public static final int CELLULAR_DATA_SERVICE_SWITCH = 10091;

    /**
     * ImsRegistrationTermination ims_registration_termination<br>
     * Usage: StatsLog.write(StatsLog.IMS_REGISTRATION_TERMINATION, int carrier_id, boolean is_multi_sim, int rat_at_end, boolean setup_failed, int reason_code, int extra_code, java.lang.String extra_message, int count);<br>
     */
    public static final int IMS_REGISTRATION_TERMINATION = 10093;

    /**
     * ImsRegistrationStats ims_registration_stats<br>
     * Usage: StatsLog.write(StatsLog.IMS_REGISTRATION_STATS, int carrier_id, int sim_slot_index, int rat, int registered_seconds, int voice_capable_seconds, int voice_available_seconds, int sms_capable_seconds, int sms_available_seconds, int video_capable_seconds, int video_available_seconds, int ut_capable_seconds, int ut_available_seconds);<br>
     */
    public static final int IMS_REGISTRATION_STATS = 10094;

    /**
     * TelephonyNetworkRequests telephony_network_requests<br>
     * Usage: StatsLog.write(StatsLog.TELEPHONY_NETWORK_REQUESTS, int carrier_id, int enterprise_request_count, int enterprise_release_count);<br>
     */
    public static final int TELEPHONY_NETWORK_REQUESTS = 10115;

    /**
     * ImsRegistrationFeatureTagStats ims_registration_feature_tag_stats<br>
     * Usage: StatsLog.write(StatsLog.IMS_REGISTRATION_FEATURE_TAG_STATS, int carrier_id, int slot_id, int feature_tag_name, int registration_tech, int registered_seconds);<br>
     */
    public static final int IMS_REGISTRATION_FEATURE_TAG_STATS = 10133;

    /**
     * RcsClientProvisioningStats rcs_client_provisioning_stats<br>
     * Usage: StatsLog.write(StatsLog.RCS_CLIENT_PROVISIONING_STATS, int carrier_id, int slot_id, int event, int count);<br>
     */
    public static final int RCS_CLIENT_PROVISIONING_STATS = 10134;

    /**
     * RcsAcsProvisioningStats rcs_acs_provisioning_stats<br>
     * Usage: StatsLog.write(StatsLog.RCS_ACS_PROVISIONING_STATS, int carrier_id, int slot_id, int response_code, int response_type, boolean is_single_registration_enabled, int count, int state_timer_sec);<br>
     */
    public static final int RCS_ACS_PROVISIONING_STATS = 10135;

    /**
     * SipDelegateStats sip_delegate_stats<br>
     * Usage: StatsLog.write(StatsLog.SIP_DELEGATE_STATS, int dimension, int carrier_id, int slot_id, int uptime_seconds, int destroy_reason);<br>
     */
    public static final int SIP_DELEGATE_STATS = 10136;

    /**
     * SipTransportFeatureTagStats sip_transport_feature_tag_stats<br>
     * Usage: StatsLog.write(StatsLog.SIP_TRANSPORT_FEATURE_TAG_STATS, int carrier_id, int slot_id, int feature_tag_name, int sip_transport_denied_reason, int sip_transport_deregistered_reason, int associated_seconds);<br>
     */
    public static final int SIP_TRANSPORT_FEATURE_TAG_STATS = 10137;

    /**
     * SipMessageResponse sip_message_response<br>
     * Usage: StatsLog.write(StatsLog.SIP_MESSAGE_RESPONSE, int carrier_id, int slot_id, int sip_message_method, int sip_message_response, int sip_message_direction, int message_error, int count);<br>
     */
    public static final int SIP_MESSAGE_RESPONSE = 10138;

    /**
     * SipTransportSession sip_transport_session<br>
     * Usage: StatsLog.write(StatsLog.SIP_TRANSPORT_SESSION, int carrier_id, int slot_id, int session_method, int sip_message_direction, int sip_response, int session_count, int ended_gracefully_count);<br>
     */
    public static final int SIP_TRANSPORT_SESSION = 10139;

    /**
     * ImsDedicatedBearerListenerEvent ims_dedicated_bearer_listener_event<br>
     * Usage: StatsLog.write(StatsLog.IMS_DEDICATED_BEARER_LISTENER_EVENT, int carrier_id, int slot_id, int rat_at_end, int qci, boolean dedicated_bearer_established, int event_count);<br>
     */
    public static final int IMS_DEDICATED_BEARER_LISTENER_EVENT = 10140;

    /**
     * ImsDedicatedBearerEvent ims_dedicated_bearer_event<br>
     * Usage: StatsLog.write(StatsLog.IMS_DEDICATED_BEARER_EVENT, int carrier_id, int slot_id, int rat_at_end, int qci, int bearer_state, boolean local_connection_info_received, boolean remote_connection_info_received, boolean has_listeners, int count);<br>
     */
    public static final int IMS_DEDICATED_BEARER_EVENT = 10141;

    /**
     * ImsRegistrationServiceDescStats ims_registration_service_desc_stats<br>
     * Usage: StatsLog.write(StatsLog.IMS_REGISTRATION_SERVICE_DESC_STATS, int carrier_id, int slot_id, int service_id_name, float service_id_version, int registration_tech, int published_seconds);<br>
     */
    public static final int IMS_REGISTRATION_SERVICE_DESC_STATS = 10142;

    /**
     * UceEventStats uce_event_stats<br>
     * Usage: StatsLog.write(StatsLog.UCE_EVENT_STATS, int carrier_id, int slot_id, int type, boolean successful, int command_code, int network_response, int count);<br>
     */
    public static final int UCE_EVENT_STATS = 10143;

    /**
     * PresenceNotifyEvent presence_notify_event<br>
     * Usage: StatsLog.write(StatsLog.PRESENCE_NOTIFY_EVENT, int carrier_id, int slot_id, int reason, boolean content_body_received, int rcs_caps_count, int mmtel_caps_count, int no_caps_count, int count);<br>
     */
    public static final int PRESENCE_NOTIFY_EVENT = 10144;

    /**
     * GbaEvent gba_event<br>
     * Usage: StatsLog.write(StatsLog.GBA_EVENT, int carrier_id, int slot_id, boolean successful, int failed_reason, int count);<br>
     */
    public static final int GBA_EVENT = 10145;

    /**
     * PerSimStatus per_sim_status<br>
     * Usage: StatsLog.write(StatsLog.PER_SIM_STATUS, int sim_slot_index, int carrier_id, int phone_number_source_uicc, int phone_number_source_carrier, int phone_number_source_ims, boolean volte_enabled, boolean wfc_enabled, int wfc_mode, int wfc_roaming_mode, boolean video_calling_enabled, boolean data_roaming_enabled, long allowed_networks_by_user, boolean is_2g_disabled, boolean is_pin1_enabled, int sim_voltage_class, int user_modified_apn_type_bitmask, long unmetered_networks, boolean vonr_enabled);<br>
     */
    public static final int PER_SIM_STATUS = 10146;

    /**
     * TelephonyNetworkRequestsV2 telephony_network_requests_v2<br>
     * Usage: StatsLog.write(StatsLog.TELEPHONY_NETWORK_REQUESTS_V2, int carrier_id, int capability, int request_count);<br>
     */
    public static final int TELEPHONY_NETWORK_REQUESTS_V2 = 10153;

    /**
     * DeviceTelephonyProperties device_telephony_properties<br>
     * Usage: StatsLog.write(StatsLog.DEVICE_TELEPHONY_PROPERTIES, boolean using_t_data_stack, boolean auto_data_switch_enabled, int auto_data_switch_toggle_count, boolean has_managed_profile_dedicated_sub);<br>
     */
    public static final int DEVICE_TELEPHONY_PROPERTIES = 10154;

    /**
     * OutgoingShortCodeSms outgoing_short_code_sms<br>
     * Usage: StatsLog.write(StatsLog.OUTGOING_SHORT_CODE_SMS, int category, int xml_version, int short_code_sms_count);<br>
     */
    public static final int OUTGOING_SHORT_CODE_SMS = 10162;

    /**
     * EmergencyNumbersInfo emergency_numbers_info<br>
     * Usage: StatsLog.write(StatsLog.EMERGENCY_NUMBERS_INFO, boolean is_db_version_ignored, int asset_version, int ota_version, java.lang.String number, java.lang.String country_iso, java.lang.String mnc, int route, java.lang.String[] urns, int[] service_categories, int[] sources);<br>
     */
    public static final int EMERGENCY_NUMBERS_INFO = 10180;

    /**
     * SatelliteController satellite_controller<br>
     * Usage: StatsLog.write(StatsLog.SATELLITE_CONTROLLER, int count_of_satellite_service_enablements_success, int count_of_satellite_service_enablements_fail, int count_of_outgoing_datagram_success, int count_of_outgoing_datagram_fail, int count_of_incoming_datagram_success, int count_of_incoming_datagram_fail, int count_of_datagram_type_sos_sms_success, int count_of_datagram_type_sos_sms_fail, int count_of_datagram_type_location_sharing_success, int count_of_datagram_type_location_sharing_fail, int count_of_provision_success, int count_of_provision_fail, int count_of_deprovision_success, int count_of_deprovision_fail, int total_service_uptime_sec, int total_battery_consumption_percent, int total_battery_charged_time_sec);<br>
     */
    public static final int SATELLITE_CONTROLLER = 10182;

    /**
     * SatelliteSession satellite_session<br>
     * Usage: StatsLog.write(StatsLog.SATELLITE_SESSION, int satellite_service_initialization_result, int satellite_technology, int count);<br>
     */
    public static final int SATELLITE_SESSION = 10183;

    /**
     * SatelliteIncomingDatagram satellite_incoming_datagram<br>
     * Usage: StatsLog.write(StatsLog.SATELLITE_INCOMING_DATAGRAM, int result_code, int datagram_size_bytes, long datagram_transfer_time_millis);<br>
     */
    public static final int SATELLITE_INCOMING_DATAGRAM = 10184;

    /**
     * SatelliteOutgoingDatagram satellite_outgoing_datagram<br>
     * Usage: StatsLog.write(StatsLog.SATELLITE_OUTGOING_DATAGRAM, int satellite_datagram_type, int result_code, int datagram_size_bytes, long datagram_transfer_time_millis);<br>
     */
    public static final int SATELLITE_OUTGOING_DATAGRAM = 10185;

    /**
     * SatelliteProvision satellite_provision<br>
     * Usage: StatsLog.write(StatsLog.SATELLITE_PROVISION, int result_code, int processing_time_sec, boolean is_provision_request, boolean is_canceled);<br>
     */
    public static final int SATELLITE_PROVISION = 10186;

    /**
     * SatelliteSosMessageRecommender satellite_sos_message_recommender<br>
     * Usage: StatsLog.write(StatsLog.SATELLITE_SOS_MESSAGE_RECOMMENDER, boolean is_display_sos_message_sent, int count_of_timer_started, boolean is_ims_registered, int cellular_service_state, int count);<br>
     */
    public static final int SATELLITE_SOS_MESSAGE_RECOMMENDER = 10187;

    // Constants for enum values.

    // Values for MobileConnectionStateChanged.state
    public static final int MOBILE_CONNECTION_STATE_CHANGED__STATE__UNKNOWN = 0;
    public static final int MOBILE_CONNECTION_STATE_CHANGED__STATE__INACTIVE = 1;
    public static final int MOBILE_CONNECTION_STATE_CHANGED__STATE__ACTIVATING = 2;
    public static final int MOBILE_CONNECTION_STATE_CHANGED__STATE__ACTIVE = 3;
    public static final int MOBILE_CONNECTION_STATE_CHANGED__STATE__DISCONNECTING = 4;
    public static final int MOBILE_CONNECTION_STATE_CHANGED__STATE__DISCONNECTION_ERROR_CREATING_CONNECTION = 5;

    // Values for MobileRadioTechnologyChanged.state
    public static final int MOBILE_RADIO_TECHNOLOGY_CHANGED__STATE__NETWORK_TYPE_UNKNOWN = 0;
    public static final int MOBILE_RADIO_TECHNOLOGY_CHANGED__STATE__NETWORK_TYPE_GPRS = 1;
    public static final int MOBILE_RADIO_TECHNOLOGY_CHANGED__STATE__NETWORK_TYPE_EDGE = 2;
    public static final int MOBILE_RADIO_TECHNOLOGY_CHANGED__STATE__NETWORK_TYPE_UMTS = 3;
    public static final int MOBILE_RADIO_TECHNOLOGY_CHANGED__STATE__NETWORK_TYPE_CDMA = 4;
    public static final int MOBILE_RADIO_TECHNOLOGY_CHANGED__STATE__NETWORK_TYPE_EVDO_0 = 5;
    public static final int MOBILE_RADIO_TECHNOLOGY_CHANGED__STATE__NETWORK_TYPE_EVDO_A = 6;
    public static final int MOBILE_RADIO_TECHNOLOGY_CHANGED__STATE__NETWORK_TYPE_1XRTT = 7;
    public static final int MOBILE_RADIO_TECHNOLOGY_CHANGED__STATE__NETWORK_TYPE_HSDPA = 8;
    public static final int MOBILE_RADIO_TECHNOLOGY_CHANGED__STATE__NETWORK_TYPE_HSUPA = 9;
    public static final int MOBILE_RADIO_TECHNOLOGY_CHANGED__STATE__NETWORK_TYPE_HSPA = 10;
    public static final int MOBILE_RADIO_TECHNOLOGY_CHANGED__STATE__NETWORK_TYPE_IDEN = 11;
    public static final int MOBILE_RADIO_TECHNOLOGY_CHANGED__STATE__NETWORK_TYPE_EVDO_B = 12;
    public static final int MOBILE_RADIO_TECHNOLOGY_CHANGED__STATE__NETWORK_TYPE_LTE = 13;
    public static final int MOBILE_RADIO_TECHNOLOGY_CHANGED__STATE__NETWORK_TYPE_EHRPD = 14;
    public static final int MOBILE_RADIO_TECHNOLOGY_CHANGED__STATE__NETWORK_TYPE_HSPAP = 15;
    public static final int MOBILE_RADIO_TECHNOLOGY_CHANGED__STATE__NETWORK_TYPE_GSM = 16;
    public static final int MOBILE_RADIO_TECHNOLOGY_CHANGED__STATE__NETWORK_TYPE_TD_SCDMA = 17;
    public static final int MOBILE_RADIO_TECHNOLOGY_CHANGED__STATE__NETWORK_TYPE_IWLAN = 18;
    public static final int MOBILE_RADIO_TECHNOLOGY_CHANGED__STATE__NETWORK_TYPE_LTE_CA = 19;
    public static final int MOBILE_RADIO_TECHNOLOGY_CHANGED__STATE__NETWORK_TYPE_NR = 20;

    // Values for DataStallRecoveryReported.rat
    public static final int DATA_STALL_RECOVERY_REPORTED__RAT__NETWORK_TYPE_UNKNOWN = 0;
    public static final int DATA_STALL_RECOVERY_REPORTED__RAT__NETWORK_TYPE_GPRS = 1;
    public static final int DATA_STALL_RECOVERY_REPORTED__RAT__NETWORK_TYPE_EDGE = 2;
    public static final int DATA_STALL_RECOVERY_REPORTED__RAT__NETWORK_TYPE_UMTS = 3;
    public static final int DATA_STALL_RECOVERY_REPORTED__RAT__NETWORK_TYPE_CDMA = 4;
    public static final int DATA_STALL_RECOVERY_REPORTED__RAT__NETWORK_TYPE_EVDO_0 = 5;
    public static final int DATA_STALL_RECOVERY_REPORTED__RAT__NETWORK_TYPE_EVDO_A = 6;
    public static final int DATA_STALL_RECOVERY_REPORTED__RAT__NETWORK_TYPE_1XRTT = 7;
    public static final int DATA_STALL_RECOVERY_REPORTED__RAT__NETWORK_TYPE_HSDPA = 8;
    public static final int DATA_STALL_RECOVERY_REPORTED__RAT__NETWORK_TYPE_HSUPA = 9;
    public static final int DATA_STALL_RECOVERY_REPORTED__RAT__NETWORK_TYPE_HSPA = 10;
    public static final int DATA_STALL_RECOVERY_REPORTED__RAT__NETWORK_TYPE_IDEN = 11;
    public static final int DATA_STALL_RECOVERY_REPORTED__RAT__NETWORK_TYPE_EVDO_B = 12;
    public static final int DATA_STALL_RECOVERY_REPORTED__RAT__NETWORK_TYPE_LTE = 13;
    public static final int DATA_STALL_RECOVERY_REPORTED__RAT__NETWORK_TYPE_EHRPD = 14;
    public static final int DATA_STALL_RECOVERY_REPORTED__RAT__NETWORK_TYPE_HSPAP = 15;
    public static final int DATA_STALL_RECOVERY_REPORTED__RAT__NETWORK_TYPE_GSM = 16;
    public static final int DATA_STALL_RECOVERY_REPORTED__RAT__NETWORK_TYPE_TD_SCDMA = 17;
    public static final int DATA_STALL_RECOVERY_REPORTED__RAT__NETWORK_TYPE_IWLAN = 18;
    public static final int DATA_STALL_RECOVERY_REPORTED__RAT__NETWORK_TYPE_LTE_CA = 19;
    public static final int DATA_STALL_RECOVERY_REPORTED__RAT__NETWORK_TYPE_NR = 20;

    // Values for DataStallRecoveryReported.signal_strength
    public static final int DATA_STALL_RECOVERY_REPORTED__SIGNAL_STRENGTH__SIGNAL_STRENGTH_NONE_OR_UNKNOWN = 0;
    public static final int DATA_STALL_RECOVERY_REPORTED__SIGNAL_STRENGTH__SIGNAL_STRENGTH_POOR = 1;
    public static final int DATA_STALL_RECOVERY_REPORTED__SIGNAL_STRENGTH__SIGNAL_STRENGTH_MODERATE = 2;
    public static final int DATA_STALL_RECOVERY_REPORTED__SIGNAL_STRENGTH__SIGNAL_STRENGTH_GOOD = 3;
    public static final int DATA_STALL_RECOVERY_REPORTED__SIGNAL_STRENGTH__SIGNAL_STRENGTH_GREAT = 4;

    // Values for DataStallRecoveryReported.action
    public static final int DATA_STALL_RECOVERY_REPORTED__ACTION__RECOVERY_ACTION_GET_DATA_CALL_LIST = 0;
    public static final int DATA_STALL_RECOVERY_REPORTED__ACTION__RECOVERY_ACTION_CLEANUP = 1;
    public static final int DATA_STALL_RECOVERY_REPORTED__ACTION__RECOVERY_ACTION_REREGISTER = 2;
    public static final int DATA_STALL_RECOVERY_REPORTED__ACTION__RECOVERY_ACTION_RADIO_RESTART = 3;
    public static final int DATA_STALL_RECOVERY_REPORTED__ACTION__RECOVERY_ACTION_RESET_MODEM = 4;

    // Values for DataStallRecoveryReported.reason
    public static final int DATA_STALL_RECOVERY_REPORTED__REASON__RECOVERED_REASON_NONE = 0;
    public static final int DATA_STALL_RECOVERY_REPORTED__REASON__RECOVERED_REASON_DSRM = 1;
    public static final int DATA_STALL_RECOVERY_REPORTED__REASON__RECOVERED_REASON_MODEM = 2;
    public static final int DATA_STALL_RECOVERY_REPORTED__REASON__RECOVERED_REASON_USER = 3;

    // Values for DataStallRecoveryReported.other_phone_signal_strength
    public static final int DATA_STALL_RECOVERY_REPORTED__OTHER_PHONE_SIGNAL_STRENGTH__SIGNAL_STRENGTH_NONE_OR_UNKNOWN = 0;
    public static final int DATA_STALL_RECOVERY_REPORTED__OTHER_PHONE_SIGNAL_STRENGTH__SIGNAL_STRENGTH_POOR = 1;
    public static final int DATA_STALL_RECOVERY_REPORTED__OTHER_PHONE_SIGNAL_STRENGTH__SIGNAL_STRENGTH_MODERATE = 2;
    public static final int DATA_STALL_RECOVERY_REPORTED__OTHER_PHONE_SIGNAL_STRENGTH__SIGNAL_STRENGTH_GOOD = 3;
    public static final int DATA_STALL_RECOVERY_REPORTED__OTHER_PHONE_SIGNAL_STRENGTH__SIGNAL_STRENGTH_GREAT = 4;

    // Values for DataStallRecoveryReported.other_phone_reg_state
    public static final int DATA_STALL_RECOVERY_REPORTED__OTHER_PHONE_REG_STATE__REGISTRATION_STATE_NOT_REGISTERED_OR_SEARCHING = 0;
    public static final int DATA_STALL_RECOVERY_REPORTED__OTHER_PHONE_REG_STATE__REGISTRATION_STATE_HOME = 1;
    public static final int DATA_STALL_RECOVERY_REPORTED__OTHER_PHONE_REG_STATE__REGISTRATION_STATE_NOT_REGISTERED_SEARCHING = 2;
    public static final int DATA_STALL_RECOVERY_REPORTED__OTHER_PHONE_REG_STATE__REGISTRATION_STATE_DENIED = 3;
    public static final int DATA_STALL_RECOVERY_REPORTED__OTHER_PHONE_REG_STATE__REGISTRATION_STATE_UNKNOWN = 4;
    public static final int DATA_STALL_RECOVERY_REPORTED__OTHER_PHONE_REG_STATE__REGISTRATION_STATE_ROAMING = 5;

    // Values for DataStallRecoveryReported.phone_reg_state
    public static final int DATA_STALL_RECOVERY_REPORTED__PHONE_REG_STATE__REGISTRATION_STATE_NOT_REGISTERED_OR_SEARCHING = 0;
    public static final int DATA_STALL_RECOVERY_REPORTED__PHONE_REG_STATE__REGISTRATION_STATE_HOME = 1;
    public static final int DATA_STALL_RECOVERY_REPORTED__PHONE_REG_STATE__REGISTRATION_STATE_NOT_REGISTERED_SEARCHING = 2;
    public static final int DATA_STALL_RECOVERY_REPORTED__PHONE_REG_STATE__REGISTRATION_STATE_DENIED = 3;
    public static final int DATA_STALL_RECOVERY_REPORTED__PHONE_REG_STATE__REGISTRATION_STATE_UNKNOWN = 4;
    public static final int DATA_STALL_RECOVERY_REPORTED__PHONE_REG_STATE__REGISTRATION_STATE_ROAMING = 5;

    // Values for SimSpecificSettingsRestored.result
    public static final int SIM_SPECIFIC_SETTINGS_RESTORED__RESULT__SIM_RESTORE_RESULT_UNKNOWN = 0;
    public static final int SIM_SPECIFIC_SETTINGS_RESTORED__RESULT__SIM_RESTORE_RESULT_SUCCESS = 1;
    public static final int SIM_SPECIFIC_SETTINGS_RESTORED__RESULT__SIM_RESTORE_RESULT_NONE_MATCH = 2;
    public static final int SIM_SPECIFIC_SETTINGS_RESTORED__RESULT__SIM_RESTORE_RESULT_ZERO_SIM_IN_BACKUP = 3;

    // Values for SimSpecificSettingsRestored.restored_from_suw
    public static final int SIM_SPECIFIC_SETTINGS_RESTORED__RESTORED_FROM_SUW__SIM_RESTORE_CASE_UNDEFINED_USE_CASE = 0;
    public static final int SIM_SPECIFIC_SETTINGS_RESTORED__RESTORED_FROM_SUW__SIM_RESTORE_CASE_SUW = 1;
    public static final int SIM_SPECIFIC_SETTINGS_RESTORED__RESTORED_FROM_SUW__SIM_RESTORE_CASE_SIM_INSERTED = 2;

    // Values for SimSpecificSettingsRestored.matching_criteria
    public static final int SIM_SPECIFIC_SETTINGS_RESTORED__MATCHING_CRITERIA__SIM_RESTORE_MATCHING_CRITERIA_UNSET = 0;
    public static final int SIM_SPECIFIC_SETTINGS_RESTORED__MATCHING_CRITERIA__SIM_RESTORE_MATCHING_CRITERIA_NONE = 1;
    public static final int SIM_SPECIFIC_SETTINGS_RESTORED__MATCHING_CRITERIA__SIM_RESTORE_MATCHING_CRITERIA_ICCID = 2;
    public static final int SIM_SPECIFIC_SETTINGS_RESTORED__MATCHING_CRITERIA__SIM_RESTORE_MATCHING_CRITERIA_CARRIER_ID_AND_PHONE_NUMBER = 3;
    public static final int SIM_SPECIFIC_SETTINGS_RESTORED__MATCHING_CRITERIA__SIM_RESTORE_MATCHING_CRITERIA_CARRIER_ID_ONLY = 4;

    // Values for PinStorageEvent.event
    public static final int PIN_STORAGE_EVENT__EVENT__UNKNOWN = 0;
    public static final int PIN_STORAGE_EVENT__EVENT__PIN_VERIFICATION_SUCCESS = 1;
    public static final int PIN_STORAGE_EVENT__EVENT__PIN_VERIFICATION_FAILURE = 2;
    public static final int PIN_STORAGE_EVENT__EVENT__CACHED_PIN_DISCARDED = 3;
    public static final int PIN_STORAGE_EVENT__EVENT__PIN_STORED_FOR_VERIFICATION = 4;
    public static final int PIN_STORAGE_EVENT__EVENT__PIN_REQUIRED_AFTER_REBOOT = 5;
    public static final int PIN_STORAGE_EVENT__EVENT__PIN_VERIFICATION_SKIPPED_SIM_CARD_MISMATCH = 6;
    public static final int PIN_STORAGE_EVENT__EVENT__PIN_COUNT_NOT_MATCHING_AFTER_REBOOT = 7;
    public static final int PIN_STORAGE_EVENT__EVENT__PIN_DECRYPTION_ERROR = 8;
    public static final int PIN_STORAGE_EVENT__EVENT__PIN_ENCRYPTION_ERROR = 9;
    public static final int PIN_STORAGE_EVENT__EVENT__PIN_ENCRYPTION_KEY_MISSING = 10;

    // Values for MmsSmsProviderGetThreadIdFailed.failure_code
    public static final int MMS_SMS_PROVIDER_GET_THREAD_ID_FAILED__FAILURE_CODE__FAILURE_UNKNOWN = 0;
    public static final int MMS_SMS_PROVIDER_GET_THREAD_ID_FAILED__FAILURE_CODE__FAILURE_NO_RECIPIENTS = 1;
    public static final int MMS_SMS_PROVIDER_GET_THREAD_ID_FAILED__FAILURE_CODE__FAILURE_FIND_OR_CREATE_THREAD_ID_SQL = 2;
    public static final int MMS_SMS_PROVIDER_GET_THREAD_ID_FAILED__FAILURE_CODE__FAILURE_MULTIPLE_THREAD_IDS_FOUND = 3;

    // Values for MmsSmsDatabaseHelperOnUpgradeFailed.failure_code
    public static final int MMS_SMS_DATABASE_HELPER_ON_UPGRADE_FAILED__FAILURE_CODE__FAILURE_UNKNOWN = 0;
    public static final int MMS_SMS_DATABASE_HELPER_ON_UPGRADE_FAILED__FAILURE_CODE__FAILURE_IO_EXCEPTION = 1;
    public static final int MMS_SMS_DATABASE_HELPER_ON_UPGRADE_FAILED__FAILURE_CODE__FAILURE_SECURITY_EXCEPTION = 2;
    public static final int MMS_SMS_DATABASE_HELPER_ON_UPGRADE_FAILED__FAILURE_CODE__FAILURE_SQL_EXCEPTION = 3;

    // Values for VoiceCallSession.bearer_at_start
    public static final int VOICE_CALL_SESSION__BEARER_AT_START__CALL_BEARER_UNKNOWN = 0;
    public static final int VOICE_CALL_SESSION__BEARER_AT_START__CALL_BEARER_CS = 1;
    public static final int VOICE_CALL_SESSION__BEARER_AT_START__CALL_BEARER_IMS = 2;

    // Values for VoiceCallSession.bearer_at_end
    public static final int VOICE_CALL_SESSION__BEARER_AT_END__CALL_BEARER_UNKNOWN = 0;
    public static final int VOICE_CALL_SESSION__BEARER_AT_END__CALL_BEARER_CS = 1;
    public static final int VOICE_CALL_SESSION__BEARER_AT_END__CALL_BEARER_IMS = 2;

    // Values for VoiceCallSession.direction
    public static final int VOICE_CALL_SESSION__DIRECTION__CALL_DIRECTION_UNKNOWN = 0;
    public static final int VOICE_CALL_SESSION__DIRECTION__CALL_DIRECTION_MO = 1;
    public static final int VOICE_CALL_SESSION__DIRECTION__CALL_DIRECTION_MT = 2;

    // Values for VoiceCallSession.setup_duration
    public static final int VOICE_CALL_SESSION__SETUP_DURATION__CALL_SETUP_DURATION_UNKNOWN = 0;
    public static final int VOICE_CALL_SESSION__SETUP_DURATION__CALL_SETUP_DURATION_EXTREMELY_FAST = 1;
    public static final int VOICE_CALL_SESSION__SETUP_DURATION__CALL_SETUP_DURATION_ULTRA_FAST = 2;
    public static final int VOICE_CALL_SESSION__SETUP_DURATION__CALL_SETUP_DURATION_VERY_FAST = 3;
    public static final int VOICE_CALL_SESSION__SETUP_DURATION__CALL_SETUP_DURATION_FAST = 4;
    public static final int VOICE_CALL_SESSION__SETUP_DURATION__CALL_SETUP_DURATION_NORMAL = 5;
    public static final int VOICE_CALL_SESSION__SETUP_DURATION__CALL_SETUP_DURATION_SLOW = 6;
    public static final int VOICE_CALL_SESSION__SETUP_DURATION__CALL_SETUP_DURATION_VERY_SLOW = 7;
    public static final int VOICE_CALL_SESSION__SETUP_DURATION__CALL_SETUP_DURATION_ULTRA_SLOW = 8;
    public static final int VOICE_CALL_SESSION__SETUP_DURATION__CALL_SETUP_DURATION_EXTREMELY_SLOW = 9;

    // Values for VoiceCallSession.rat_at_start
    public static final int VOICE_CALL_SESSION__RAT_AT_START__NETWORK_TYPE_UNKNOWN = 0;
    public static final int VOICE_CALL_SESSION__RAT_AT_START__NETWORK_TYPE_GPRS = 1;
    public static final int VOICE_CALL_SESSION__RAT_AT_START__NETWORK_TYPE_EDGE = 2;
    public static final int VOICE_CALL_SESSION__RAT_AT_START__NETWORK_TYPE_UMTS = 3;
    public static final int VOICE_CALL_SESSION__RAT_AT_START__NETWORK_TYPE_CDMA = 4;
    public static final int VOICE_CALL_SESSION__RAT_AT_START__NETWORK_TYPE_EVDO_0 = 5;
    public static final int VOICE_CALL_SESSION__RAT_AT_START__NETWORK_TYPE_EVDO_A = 6;
    public static final int VOICE_CALL_SESSION__RAT_AT_START__NETWORK_TYPE_1XRTT = 7;
    public static final int VOICE_CALL_SESSION__RAT_AT_START__NETWORK_TYPE_HSDPA = 8;
    public static final int VOICE_CALL_SESSION__RAT_AT_START__NETWORK_TYPE_HSUPA = 9;
    public static final int VOICE_CALL_SESSION__RAT_AT_START__NETWORK_TYPE_HSPA = 10;
    public static final int VOICE_CALL_SESSION__RAT_AT_START__NETWORK_TYPE_IDEN = 11;
    public static final int VOICE_CALL_SESSION__RAT_AT_START__NETWORK_TYPE_EVDO_B = 12;
    public static final int VOICE_CALL_SESSION__RAT_AT_START__NETWORK_TYPE_LTE = 13;
    public static final int VOICE_CALL_SESSION__RAT_AT_START__NETWORK_TYPE_EHRPD = 14;
    public static final int VOICE_CALL_SESSION__RAT_AT_START__NETWORK_TYPE_HSPAP = 15;
    public static final int VOICE_CALL_SESSION__RAT_AT_START__NETWORK_TYPE_GSM = 16;
    public static final int VOICE_CALL_SESSION__RAT_AT_START__NETWORK_TYPE_TD_SCDMA = 17;
    public static final int VOICE_CALL_SESSION__RAT_AT_START__NETWORK_TYPE_IWLAN = 18;
    public static final int VOICE_CALL_SESSION__RAT_AT_START__NETWORK_TYPE_LTE_CA = 19;
    public static final int VOICE_CALL_SESSION__RAT_AT_START__NETWORK_TYPE_NR = 20;

    // Values for VoiceCallSession.rat_at_end
    public static final int VOICE_CALL_SESSION__RAT_AT_END__NETWORK_TYPE_UNKNOWN = 0;
    public static final int VOICE_CALL_SESSION__RAT_AT_END__NETWORK_TYPE_GPRS = 1;
    public static final int VOICE_CALL_SESSION__RAT_AT_END__NETWORK_TYPE_EDGE = 2;
    public static final int VOICE_CALL_SESSION__RAT_AT_END__NETWORK_TYPE_UMTS = 3;
    public static final int VOICE_CALL_SESSION__RAT_AT_END__NETWORK_TYPE_CDMA = 4;
    public static final int VOICE_CALL_SESSION__RAT_AT_END__NETWORK_TYPE_EVDO_0 = 5;
    public static final int VOICE_CALL_SESSION__RAT_AT_END__NETWORK_TYPE_EVDO_A = 6;
    public static final int VOICE_CALL_SESSION__RAT_AT_END__NETWORK_TYPE_1XRTT = 7;
    public static final int VOICE_CALL_SESSION__RAT_AT_END__NETWORK_TYPE_HSDPA = 8;
    public static final int VOICE_CALL_SESSION__RAT_AT_END__NETWORK_TYPE_HSUPA = 9;
    public static final int VOICE_CALL_SESSION__RAT_AT_END__NETWORK_TYPE_HSPA = 10;
    public static final int VOICE_CALL_SESSION__RAT_AT_END__NETWORK_TYPE_IDEN = 11;
    public static final int VOICE_CALL_SESSION__RAT_AT_END__NETWORK_TYPE_EVDO_B = 12;
    public static final int VOICE_CALL_SESSION__RAT_AT_END__NETWORK_TYPE_LTE = 13;
    public static final int VOICE_CALL_SESSION__RAT_AT_END__NETWORK_TYPE_EHRPD = 14;
    public static final int VOICE_CALL_SESSION__RAT_AT_END__NETWORK_TYPE_HSPAP = 15;
    public static final int VOICE_CALL_SESSION__RAT_AT_END__NETWORK_TYPE_GSM = 16;
    public static final int VOICE_CALL_SESSION__RAT_AT_END__NETWORK_TYPE_TD_SCDMA = 17;
    public static final int VOICE_CALL_SESSION__RAT_AT_END__NETWORK_TYPE_IWLAN = 18;
    public static final int VOICE_CALL_SESSION__RAT_AT_END__NETWORK_TYPE_LTE_CA = 19;
    public static final int VOICE_CALL_SESSION__RAT_AT_END__NETWORK_TYPE_NR = 20;

    // Values for VoiceCallSession.signal_strength_at_end
    public static final int VOICE_CALL_SESSION__SIGNAL_STRENGTH_AT_END__SIGNAL_STRENGTH_NONE_OR_UNKNOWN = 0;
    public static final int VOICE_CALL_SESSION__SIGNAL_STRENGTH_AT_END__SIGNAL_STRENGTH_POOR = 1;
    public static final int VOICE_CALL_SESSION__SIGNAL_STRENGTH_AT_END__SIGNAL_STRENGTH_MODERATE = 2;
    public static final int VOICE_CALL_SESSION__SIGNAL_STRENGTH_AT_END__SIGNAL_STRENGTH_GOOD = 3;
    public static final int VOICE_CALL_SESSION__SIGNAL_STRENGTH_AT_END__SIGNAL_STRENGTH_GREAT = 4;

    // Values for VoiceCallSession.main_codec_quality
    public static final int VOICE_CALL_SESSION__MAIN_CODEC_QUALITY__CODEC_QUALITY_UNKNOWN = 0;
    public static final int VOICE_CALL_SESSION__MAIN_CODEC_QUALITY__CODEC_QUALITY_NARROWBAND = 1;
    public static final int VOICE_CALL_SESSION__MAIN_CODEC_QUALITY__CODEC_QUALITY_WIDEBAND = 2;
    public static final int VOICE_CALL_SESSION__MAIN_CODEC_QUALITY__CODEC_QUALITY_SUPER_WIDEBAND = 3;
    public static final int VOICE_CALL_SESSION__MAIN_CODEC_QUALITY__CODEC_QUALITY_FULLBAND = 4;

    // Values for VoiceCallSession.rat_at_connected
    public static final int VOICE_CALL_SESSION__RAT_AT_CONNECTED__NETWORK_TYPE_UNKNOWN = 0;
    public static final int VOICE_CALL_SESSION__RAT_AT_CONNECTED__NETWORK_TYPE_GPRS = 1;
    public static final int VOICE_CALL_SESSION__RAT_AT_CONNECTED__NETWORK_TYPE_EDGE = 2;
    public static final int VOICE_CALL_SESSION__RAT_AT_CONNECTED__NETWORK_TYPE_UMTS = 3;
    public static final int VOICE_CALL_SESSION__RAT_AT_CONNECTED__NETWORK_TYPE_CDMA = 4;
    public static final int VOICE_CALL_SESSION__RAT_AT_CONNECTED__NETWORK_TYPE_EVDO_0 = 5;
    public static final int VOICE_CALL_SESSION__RAT_AT_CONNECTED__NETWORK_TYPE_EVDO_A = 6;
    public static final int VOICE_CALL_SESSION__RAT_AT_CONNECTED__NETWORK_TYPE_1XRTT = 7;
    public static final int VOICE_CALL_SESSION__RAT_AT_CONNECTED__NETWORK_TYPE_HSDPA = 8;
    public static final int VOICE_CALL_SESSION__RAT_AT_CONNECTED__NETWORK_TYPE_HSUPA = 9;
    public static final int VOICE_CALL_SESSION__RAT_AT_CONNECTED__NETWORK_TYPE_HSPA = 10;
    public static final int VOICE_CALL_SESSION__RAT_AT_CONNECTED__NETWORK_TYPE_IDEN = 11;
    public static final int VOICE_CALL_SESSION__RAT_AT_CONNECTED__NETWORK_TYPE_EVDO_B = 12;
    public static final int VOICE_CALL_SESSION__RAT_AT_CONNECTED__NETWORK_TYPE_LTE = 13;
    public static final int VOICE_CALL_SESSION__RAT_AT_CONNECTED__NETWORK_TYPE_EHRPD = 14;
    public static final int VOICE_CALL_SESSION__RAT_AT_CONNECTED__NETWORK_TYPE_HSPAP = 15;
    public static final int VOICE_CALL_SESSION__RAT_AT_CONNECTED__NETWORK_TYPE_GSM = 16;
    public static final int VOICE_CALL_SESSION__RAT_AT_CONNECTED__NETWORK_TYPE_TD_SCDMA = 17;
    public static final int VOICE_CALL_SESSION__RAT_AT_CONNECTED__NETWORK_TYPE_IWLAN = 18;
    public static final int VOICE_CALL_SESSION__RAT_AT_CONNECTED__NETWORK_TYPE_LTE_CA = 19;
    public static final int VOICE_CALL_SESSION__RAT_AT_CONNECTED__NETWORK_TYPE_NR = 20;

    // Values for VoiceCallSession.call_duration
    public static final int VOICE_CALL_SESSION__CALL_DURATION__CALL_DURATION_UNKNOWN = 0;
    public static final int VOICE_CALL_SESSION__CALL_DURATION__CALL_DURATION_LESS_THAN_ONE_MINUTE = 1;
    public static final int VOICE_CALL_SESSION__CALL_DURATION__CALL_DURATION_LESS_THAN_FIVE_MINUTES = 2;
    public static final int VOICE_CALL_SESSION__CALL_DURATION__CALL_DURATION_LESS_THAN_TEN_MINUTES = 3;
    public static final int VOICE_CALL_SESSION__CALL_DURATION__CALL_DURATION_LESS_THAN_THIRTY_MINUTES = 4;
    public static final int VOICE_CALL_SESSION__CALL_DURATION__CALL_DURATION_LESS_THAN_ONE_HOUR = 5;
    public static final int VOICE_CALL_SESSION__CALL_DURATION__CALL_DURATION_MORE_THAN_ONE_HOUR = 6;

    // Values for VoiceCallSession.last_known_rat
    public static final int VOICE_CALL_SESSION__LAST_KNOWN_RAT__NETWORK_TYPE_UNKNOWN = 0;
    public static final int VOICE_CALL_SESSION__LAST_KNOWN_RAT__NETWORK_TYPE_GPRS = 1;
    public static final int VOICE_CALL_SESSION__LAST_KNOWN_RAT__NETWORK_TYPE_EDGE = 2;
    public static final int VOICE_CALL_SESSION__LAST_KNOWN_RAT__NETWORK_TYPE_UMTS = 3;
    public static final int VOICE_CALL_SESSION__LAST_KNOWN_RAT__NETWORK_TYPE_CDMA = 4;
    public static final int VOICE_CALL_SESSION__LAST_KNOWN_RAT__NETWORK_TYPE_EVDO_0 = 5;
    public static final int VOICE_CALL_SESSION__LAST_KNOWN_RAT__NETWORK_TYPE_EVDO_A = 6;
    public static final int VOICE_CALL_SESSION__LAST_KNOWN_RAT__NETWORK_TYPE_1XRTT = 7;
    public static final int VOICE_CALL_SESSION__LAST_KNOWN_RAT__NETWORK_TYPE_HSDPA = 8;
    public static final int VOICE_CALL_SESSION__LAST_KNOWN_RAT__NETWORK_TYPE_HSUPA = 9;
    public static final int VOICE_CALL_SESSION__LAST_KNOWN_RAT__NETWORK_TYPE_HSPA = 10;
    public static final int VOICE_CALL_SESSION__LAST_KNOWN_RAT__NETWORK_TYPE_IDEN = 11;
    public static final int VOICE_CALL_SESSION__LAST_KNOWN_RAT__NETWORK_TYPE_EVDO_B = 12;
    public static final int VOICE_CALL_SESSION__LAST_KNOWN_RAT__NETWORK_TYPE_LTE = 13;
    public static final int VOICE_CALL_SESSION__LAST_KNOWN_RAT__NETWORK_TYPE_EHRPD = 14;
    public static final int VOICE_CALL_SESSION__LAST_KNOWN_RAT__NETWORK_TYPE_HSPAP = 15;
    public static final int VOICE_CALL_SESSION__LAST_KNOWN_RAT__NETWORK_TYPE_GSM = 16;
    public static final int VOICE_CALL_SESSION__LAST_KNOWN_RAT__NETWORK_TYPE_TD_SCDMA = 17;
    public static final int VOICE_CALL_SESSION__LAST_KNOWN_RAT__NETWORK_TYPE_IWLAN = 18;
    public static final int VOICE_CALL_SESSION__LAST_KNOWN_RAT__NETWORK_TYPE_LTE_CA = 19;
    public static final int VOICE_CALL_SESSION__LAST_KNOWN_RAT__NETWORK_TYPE_NR = 20;

    // Values for VoiceCallSession.fold_state
    public static final int VOICE_CALL_SESSION__FOLD_STATE__STATE_UNKNOWN = 0;
    public static final int VOICE_CALL_SESSION__FOLD_STATE__STATE_CLOSED = 1;
    public static final int VOICE_CALL_SESSION__FOLD_STATE__STATE_HALF_OPENED = 2;
    public static final int VOICE_CALL_SESSION__FOLD_STATE__STATE_OPENED = 3;
    public static final int VOICE_CALL_SESSION__FOLD_STATE__STATE_FLIPPED = 4;

    // Values for VoiceCallRatUsage.rat
    public static final int VOICE_CALL_RAT_USAGE__RAT__NETWORK_TYPE_UNKNOWN = 0;
    public static final int VOICE_CALL_RAT_USAGE__RAT__NETWORK_TYPE_GPRS = 1;
    public static final int VOICE_CALL_RAT_USAGE__RAT__NETWORK_TYPE_EDGE = 2;
    public static final int VOICE_CALL_RAT_USAGE__RAT__NETWORK_TYPE_UMTS = 3;
    public static final int VOICE_CALL_RAT_USAGE__RAT__NETWORK_TYPE_CDMA = 4;
    public static final int VOICE_CALL_RAT_USAGE__RAT__NETWORK_TYPE_EVDO_0 = 5;
    public static final int VOICE_CALL_RAT_USAGE__RAT__NETWORK_TYPE_EVDO_A = 6;
    public static final int VOICE_CALL_RAT_USAGE__RAT__NETWORK_TYPE_1XRTT = 7;
    public static final int VOICE_CALL_RAT_USAGE__RAT__NETWORK_TYPE_HSDPA = 8;
    public static final int VOICE_CALL_RAT_USAGE__RAT__NETWORK_TYPE_HSUPA = 9;
    public static final int VOICE_CALL_RAT_USAGE__RAT__NETWORK_TYPE_HSPA = 10;
    public static final int VOICE_CALL_RAT_USAGE__RAT__NETWORK_TYPE_IDEN = 11;
    public static final int VOICE_CALL_RAT_USAGE__RAT__NETWORK_TYPE_EVDO_B = 12;
    public static final int VOICE_CALL_RAT_USAGE__RAT__NETWORK_TYPE_LTE = 13;
    public static final int VOICE_CALL_RAT_USAGE__RAT__NETWORK_TYPE_EHRPD = 14;
    public static final int VOICE_CALL_RAT_USAGE__RAT__NETWORK_TYPE_HSPAP = 15;
    public static final int VOICE_CALL_RAT_USAGE__RAT__NETWORK_TYPE_GSM = 16;
    public static final int VOICE_CALL_RAT_USAGE__RAT__NETWORK_TYPE_TD_SCDMA = 17;
    public static final int VOICE_CALL_RAT_USAGE__RAT__NETWORK_TYPE_IWLAN = 18;
    public static final int VOICE_CALL_RAT_USAGE__RAT__NETWORK_TYPE_LTE_CA = 19;
    public static final int VOICE_CALL_RAT_USAGE__RAT__NETWORK_TYPE_NR = 20;

    // Values for IncomingSms.sms_format
    public static final int INCOMING_SMS__SMS_FORMAT__SMS_FORMAT_UNKNOWN = 0;
    public static final int INCOMING_SMS__SMS_FORMAT__SMS_FORMAT_3GPP = 1;
    public static final int INCOMING_SMS__SMS_FORMAT__SMS_FORMAT_3GPP2 = 2;

    // Values for IncomingSms.sms_tech
    public static final int INCOMING_SMS__SMS_TECH__SMS_TECH_UNKNOWN = 0;
    public static final int INCOMING_SMS__SMS_TECH__SMS_TECH_CS_3GPP = 1;
    public static final int INCOMING_SMS__SMS_TECH__SMS_TECH_CS_3GPP2 = 2;
    public static final int INCOMING_SMS__SMS_TECH__SMS_TECH_IMS = 3;

    // Values for IncomingSms.rat
    public static final int INCOMING_SMS__RAT__NETWORK_TYPE_UNKNOWN = 0;
    public static final int INCOMING_SMS__RAT__NETWORK_TYPE_GPRS = 1;
    public static final int INCOMING_SMS__RAT__NETWORK_TYPE_EDGE = 2;
    public static final int INCOMING_SMS__RAT__NETWORK_TYPE_UMTS = 3;
    public static final int INCOMING_SMS__RAT__NETWORK_TYPE_CDMA = 4;
    public static final int INCOMING_SMS__RAT__NETWORK_TYPE_EVDO_0 = 5;
    public static final int INCOMING_SMS__RAT__NETWORK_TYPE_EVDO_A = 6;
    public static final int INCOMING_SMS__RAT__NETWORK_TYPE_1XRTT = 7;
    public static final int INCOMING_SMS__RAT__NETWORK_TYPE_HSDPA = 8;
    public static final int INCOMING_SMS__RAT__NETWORK_TYPE_HSUPA = 9;
    public static final int INCOMING_SMS__RAT__NETWORK_TYPE_HSPA = 10;
    public static final int INCOMING_SMS__RAT__NETWORK_TYPE_IDEN = 11;
    public static final int INCOMING_SMS__RAT__NETWORK_TYPE_EVDO_B = 12;
    public static final int INCOMING_SMS__RAT__NETWORK_TYPE_LTE = 13;
    public static final int INCOMING_SMS__RAT__NETWORK_TYPE_EHRPD = 14;
    public static final int INCOMING_SMS__RAT__NETWORK_TYPE_HSPAP = 15;
    public static final int INCOMING_SMS__RAT__NETWORK_TYPE_GSM = 16;
    public static final int INCOMING_SMS__RAT__NETWORK_TYPE_TD_SCDMA = 17;
    public static final int INCOMING_SMS__RAT__NETWORK_TYPE_IWLAN = 18;
    public static final int INCOMING_SMS__RAT__NETWORK_TYPE_LTE_CA = 19;
    public static final int INCOMING_SMS__RAT__NETWORK_TYPE_NR = 20;

    // Values for IncomingSms.sms_type
    public static final int INCOMING_SMS__SMS_TYPE__SMS_TYPE_NORMAL = 0;
    public static final int INCOMING_SMS__SMS_TYPE__SMS_TYPE_SMS_PP = 1;
    public static final int INCOMING_SMS__SMS_TYPE__SMS_TYPE_VOICEMAIL_INDICATION = 2;
    public static final int INCOMING_SMS__SMS_TYPE__SMS_TYPE_ZERO = 3;
    public static final int INCOMING_SMS__SMS_TYPE__SMS_TYPE_WAP_PUSH = 4;

    // Values for IncomingSms.error
    public static final int INCOMING_SMS__ERROR__SMS_SUCCESS = 0;
    public static final int INCOMING_SMS__ERROR__SMS_ERROR_GENERIC = 1;
    public static final int INCOMING_SMS__ERROR__SMS_ERROR_NO_MEMORY = 2;
    public static final int INCOMING_SMS__ERROR__SMS_ERROR_NOT_SUPPORTED = 3;

    // Values for OutgoingSms.sms_format
    public static final int OUTGOING_SMS__SMS_FORMAT__SMS_FORMAT_UNKNOWN = 0;
    public static final int OUTGOING_SMS__SMS_FORMAT__SMS_FORMAT_3GPP = 1;
    public static final int OUTGOING_SMS__SMS_FORMAT__SMS_FORMAT_3GPP2 = 2;

    // Values for OutgoingSms.sms_tech
    public static final int OUTGOING_SMS__SMS_TECH__SMS_TECH_UNKNOWN = 0;
    public static final int OUTGOING_SMS__SMS_TECH__SMS_TECH_CS_3GPP = 1;
    public static final int OUTGOING_SMS__SMS_TECH__SMS_TECH_CS_3GPP2 = 2;
    public static final int OUTGOING_SMS__SMS_TECH__SMS_TECH_IMS = 3;

    // Values for OutgoingSms.rat
    public static final int OUTGOING_SMS__RAT__NETWORK_TYPE_UNKNOWN = 0;
    public static final int OUTGOING_SMS__RAT__NETWORK_TYPE_GPRS = 1;
    public static final int OUTGOING_SMS__RAT__NETWORK_TYPE_EDGE = 2;
    public static final int OUTGOING_SMS__RAT__NETWORK_TYPE_UMTS = 3;
    public static final int OUTGOING_SMS__RAT__NETWORK_TYPE_CDMA = 4;
    public static final int OUTGOING_SMS__RAT__NETWORK_TYPE_EVDO_0 = 5;
    public static final int OUTGOING_SMS__RAT__NETWORK_TYPE_EVDO_A = 6;
    public static final int OUTGOING_SMS__RAT__NETWORK_TYPE_1XRTT = 7;
    public static final int OUTGOING_SMS__RAT__NETWORK_TYPE_HSDPA = 8;
    public static final int OUTGOING_SMS__RAT__NETWORK_TYPE_HSUPA = 9;
    public static final int OUTGOING_SMS__RAT__NETWORK_TYPE_HSPA = 10;
    public static final int OUTGOING_SMS__RAT__NETWORK_TYPE_IDEN = 11;
    public static final int OUTGOING_SMS__RAT__NETWORK_TYPE_EVDO_B = 12;
    public static final int OUTGOING_SMS__RAT__NETWORK_TYPE_LTE = 13;
    public static final int OUTGOING_SMS__RAT__NETWORK_TYPE_EHRPD = 14;
    public static final int OUTGOING_SMS__RAT__NETWORK_TYPE_HSPAP = 15;
    public static final int OUTGOING_SMS__RAT__NETWORK_TYPE_GSM = 16;
    public static final int OUTGOING_SMS__RAT__NETWORK_TYPE_TD_SCDMA = 17;
    public static final int OUTGOING_SMS__RAT__NETWORK_TYPE_IWLAN = 18;
    public static final int OUTGOING_SMS__RAT__NETWORK_TYPE_LTE_CA = 19;
    public static final int OUTGOING_SMS__RAT__NETWORK_TYPE_NR = 20;

    // Values for OutgoingSms.send_result
    public static final int OUTGOING_SMS__SEND_RESULT__SMS_SEND_RESULT_UNKNOWN = 0;
    public static final int OUTGOING_SMS__SEND_RESULT__SMS_SEND_RESULT_SUCCESS = 1;
    public static final int OUTGOING_SMS__SEND_RESULT__SMS_SEND_RESULT_ERROR = 2;
    public static final int OUTGOING_SMS__SEND_RESULT__SMS_SEND_RESULT_ERROR_RETRY = 3;
    public static final int OUTGOING_SMS__SEND_RESULT__SMS_SEND_RESULT_ERROR_FALLBACK = 4;

    // Values for OutgoingSms.send_error_code
    public static final int OUTGOING_SMS__SEND_ERROR_CODE__SMS_SEND_ERROR_NONE = 0;
    public static final int OUTGOING_SMS__SEND_ERROR_CODE__SMS_SEND_ERROR_GENERIC_FAILURE = 1;
    public static final int OUTGOING_SMS__SEND_ERROR_CODE__SMS_SEND_ERROR_RADIO_OFF = 2;
    public static final int OUTGOING_SMS__SEND_ERROR_CODE__SMS_SEND_ERROR_NULL_PDU = 3;
    public static final int OUTGOING_SMS__SEND_ERROR_CODE__SMS_SEND_ERROR_NO_SERVICE = 4;
    public static final int OUTGOING_SMS__SEND_ERROR_CODE__SMS_SEND_ERROR_LIMIT_EXCEEDED = 5;
    public static final int OUTGOING_SMS__SEND_ERROR_CODE__SMS_SEND_ERROR_FDN_CHECK_FAILURE = 6;
    public static final int OUTGOING_SMS__SEND_ERROR_CODE__SMS_SEND_ERROR_SHORT_CODE_NOT_ALLOWED = 7;
    public static final int OUTGOING_SMS__SEND_ERROR_CODE__SMS_SEND_ERROR_SHORT_CODE_NEVER_ALLOWED = 8;
    public static final int OUTGOING_SMS__SEND_ERROR_CODE__SMS_SEND_ERROR_RADIO_NOT_AVAILABLE = 9;
    public static final int OUTGOING_SMS__SEND_ERROR_CODE__SMS_SEND_ERROR_NETWORK_REJECT = 10;
    public static final int OUTGOING_SMS__SEND_ERROR_CODE__SMS_SEND_ERROR_INVALID_ARGUMENTS = 11;
    public static final int OUTGOING_SMS__SEND_ERROR_CODE__SMS_SEND_ERROR_INVALID_STATE = 12;
    public static final int OUTGOING_SMS__SEND_ERROR_CODE__SMS_SEND_ERROR_NO_MEMORY = 13;
    public static final int OUTGOING_SMS__SEND_ERROR_CODE__SMS_SEND_ERROR_INVALID_SMS_FORMAT = 14;
    public static final int OUTGOING_SMS__SEND_ERROR_CODE__SMS_SEND_ERROR_SYSTEM_ERROR = 15;
    public static final int OUTGOING_SMS__SEND_ERROR_CODE__SMS_SEND_ERROR_MODEM_ERROR = 16;
    public static final int OUTGOING_SMS__SEND_ERROR_CODE__SMS_SEND_ERROR_NETWORK_ERROR = 17;
    public static final int OUTGOING_SMS__SEND_ERROR_CODE__SMS_SEND_ERROR_INVALID_SMSC_ADDRESS = 19;
    public static final int OUTGOING_SMS__SEND_ERROR_CODE__SMS_SEND_ERROR_OPERATION_NOT_ALLOWED = 20;
    public static final int OUTGOING_SMS__SEND_ERROR_CODE__SMS_SEND_ERROR_INTERNAL_ERROR = 21;
    public static final int OUTGOING_SMS__SEND_ERROR_CODE__SMS_SEND_ERROR_NO_RESOURCES = 22;
    public static final int OUTGOING_SMS__SEND_ERROR_CODE__SMS_SEND_ERROR_CANCELLED = 23;
    public static final int OUTGOING_SMS__SEND_ERROR_CODE__SMS_SEND_ERROR_REQUEST_NOT_SUPPORTED = 24;
    public static final int OUTGOING_SMS__SEND_ERROR_CODE__SMS_SEND_ERROR_NO_BLUETOOTH_SERVICE = 25;
    public static final int OUTGOING_SMS__SEND_ERROR_CODE__SMS_SEND_ERROR_INVALID_BLUETOOTH_ADDRESS = 26;
    public static final int OUTGOING_SMS__SEND_ERROR_CODE__SMS_SEND_ERROR_BLUETOOTH_DISCONNECTED = 27;
    public static final int OUTGOING_SMS__SEND_ERROR_CODE__SMS_SEND_ERROR_UNEXPECTED_EVENT_STOP_SENDING = 28;
    public static final int OUTGOING_SMS__SEND_ERROR_CODE__SMS_SEND_ERROR_SMS_BLOCKED_DURING_EMERGENCY = 29;
    public static final int OUTGOING_SMS__SEND_ERROR_CODE__SMS_SEND_ERROR_SMS_SEND_RETRY_FAILED = 30;
    public static final int OUTGOING_SMS__SEND_ERROR_CODE__SMS_SEND_ERROR_REMOTE_EXCEPTION = 31;
    public static final int OUTGOING_SMS__SEND_ERROR_CODE__SMS_SEND_ERROR_NO_DEFAULT_SMS_APP = 32;
    public static final int OUTGOING_SMS__SEND_ERROR_CODE__SMS_SEND_ERROR_USER_NOT_ALLOWED = 33;
    public static final int OUTGOING_SMS__SEND_ERROR_CODE__SMS_SEND_ERROR_RIL_RADIO_NOT_AVAILABLE = 100;
    public static final int OUTGOING_SMS__SEND_ERROR_CODE__SMS_SEND_ERROR_RIL_SMS_SEND_FAIL_RETRY = 101;
    public static final int OUTGOING_SMS__SEND_ERROR_CODE__SMS_SEND_ERROR_RIL_NETWORK_REJECT = 102;
    public static final int OUTGOING_SMS__SEND_ERROR_CODE__SMS_SEND_ERROR_RIL_INVALID_STATE = 103;
    public static final int OUTGOING_SMS__SEND_ERROR_CODE__SMS_SEND_ERROR_RIL_INVALID_ARGUMENTS = 104;
    public static final int OUTGOING_SMS__SEND_ERROR_CODE__SMS_SEND_ERROR_RIL_NO_MEMORY = 105;
    public static final int OUTGOING_SMS__SEND_ERROR_CODE__SMS_SEND_ERROR_RIL_REQUEST_RATE_LIMITED = 106;
    public static final int OUTGOING_SMS__SEND_ERROR_CODE__SMS_SEND_ERROR_RIL_INVALID_SMS_FORMAT = 107;
    public static final int OUTGOING_SMS__SEND_ERROR_CODE__SMS_SEND_ERROR_RIL_SYSTEM_ERR = 108;
    public static final int OUTGOING_SMS__SEND_ERROR_CODE__SMS_SEND_ERROR_RIL_ENCODING_ERR = 109;
    public static final int OUTGOING_SMS__SEND_ERROR_CODE__SMS_SEND_ERROR_RIL_INVALID_SMSC_ADDRESS = 110;
    public static final int OUTGOING_SMS__SEND_ERROR_CODE__SMS_SEND_ERROR_RIL_MODEM_ERR = 111;
    public static final int OUTGOING_SMS__SEND_ERROR_CODE__SMS_SEND_ERROR_RIL_NETWORK_ERR = 112;
    public static final int OUTGOING_SMS__SEND_ERROR_CODE__SMS_SEND_ERROR_RIL_INTERNAL_ERR = 113;
    public static final int OUTGOING_SMS__SEND_ERROR_CODE__SMS_SEND_ERROR_RIL_REQUEST_NOT_SUPPORTED = 114;
    public static final int OUTGOING_SMS__SEND_ERROR_CODE__SMS_SEND_ERROR_RIL_INVALID_MODEM_STATE = 115;
    public static final int OUTGOING_SMS__SEND_ERROR_CODE__SMS_SEND_ERROR_RIL_NETWORK_NOT_READY = 116;
    public static final int OUTGOING_SMS__SEND_ERROR_CODE__SMS_SEND_ERROR_RIL_OPERATION_NOT_ALLOWED = 117;
    public static final int OUTGOING_SMS__SEND_ERROR_CODE__SMS_SEND_ERROR_RIL_NO_RESOURCES = 118;
    public static final int OUTGOING_SMS__SEND_ERROR_CODE__SMS_SEND_ERROR_RIL_CANCELLED = 119;
    public static final int OUTGOING_SMS__SEND_ERROR_CODE__SMS_SEND_ERROR_RIL_SIM_ABSENT = 120;
    public static final int OUTGOING_SMS__SEND_ERROR_CODE__SMS_SEND_ERROR_RIL_SIMULTANEOUS_SMS_AND_CALL_NOT_ALLOWED = 121;
    public static final int OUTGOING_SMS__SEND_ERROR_CODE__SMS_SEND_ERROR_RIL_ACCESS_BARRED = 122;
    public static final int OUTGOING_SMS__SEND_ERROR_CODE__SMS_SEND_ERROR_RIL_BLOCKED_DUE_TO_CALL = 123;
    public static final int OUTGOING_SMS__SEND_ERROR_CODE__SMS_SEND_ERROR_RIL_GENERIC_ERROR = 124;
    public static final int OUTGOING_SMS__SEND_ERROR_CODE__SMS_SEND_ERROR_RIL_INVALID_RESPONSE = 125;
    public static final int OUTGOING_SMS__SEND_ERROR_CODE__SMS_SEND_ERROR_RIL_SIM_PIN2 = 126;
    public static final int OUTGOING_SMS__SEND_ERROR_CODE__SMS_SEND_ERROR_RIL_SIM_PUK2 = 127;
    public static final int OUTGOING_SMS__SEND_ERROR_CODE__SMS_SEND_ERROR_RIL_SUBSCRIPTION_NOT_AVAILABLE = 128;
    public static final int OUTGOING_SMS__SEND_ERROR_CODE__SMS_SEND_ERROR_RIL_SIM_ERR = 129;
    public static final int OUTGOING_SMS__SEND_ERROR_CODE__SMS_SEND_ERROR_RIL_INVALID_SIM_STATE = 130;
    public static final int OUTGOING_SMS__SEND_ERROR_CODE__SMS_SEND_ERROR_RIL_NO_SMS_TO_ACK = 131;
    public static final int OUTGOING_SMS__SEND_ERROR_CODE__SMS_SEND_ERROR_RIL_SIM_BUSY = 132;
    public static final int OUTGOING_SMS__SEND_ERROR_CODE__SMS_SEND_ERROR_RIL_SIM_FULL = 133;
    public static final int OUTGOING_SMS__SEND_ERROR_CODE__SMS_SEND_ERROR_RIL_NO_SUBSCRIPTION = 134;
    public static final int OUTGOING_SMS__SEND_ERROR_CODE__SMS_SEND_ERROR_RIL_NO_NETWORK_FOUND = 135;
    public static final int OUTGOING_SMS__SEND_ERROR_CODE__SMS_SEND_ERROR_RIL_DEVICE_IN_USE = 136;
    public static final int OUTGOING_SMS__SEND_ERROR_CODE__SMS_SEND_ERROR_RIL_ABORTED = 137;

    // Values for DataCallSession.profile
    public static final int DATA_CALL_SESSION__PROFILE__DATA_PROFILE_INVALID = -1;
    public static final int DATA_CALL_SESSION__PROFILE__DATA_PROFILE_DEFAULT = 0;
    public static final int DATA_CALL_SESSION__PROFILE__DATA_PROFILE_TETHERED = 1;
    public static final int DATA_CALL_SESSION__PROFILE__DATA_PROFILE_IMS = 2;
    public static final int DATA_CALL_SESSION__PROFILE__DATA_PROFILE_FOTA = 3;
    public static final int DATA_CALL_SESSION__PROFILE__DATA_PROFILE_CBS = 4;
    public static final int DATA_CALL_SESSION__PROFILE__DATA_PROFILE_OEM_BASE = 1000;

    // Values for DataCallSession.rat_at_end
    public static final int DATA_CALL_SESSION__RAT_AT_END__NETWORK_TYPE_UNKNOWN = 0;
    public static final int DATA_CALL_SESSION__RAT_AT_END__NETWORK_TYPE_GPRS = 1;
    public static final int DATA_CALL_SESSION__RAT_AT_END__NETWORK_TYPE_EDGE = 2;
    public static final int DATA_CALL_SESSION__RAT_AT_END__NETWORK_TYPE_UMTS = 3;
    public static final int DATA_CALL_SESSION__RAT_AT_END__NETWORK_TYPE_CDMA = 4;
    public static final int DATA_CALL_SESSION__RAT_AT_END__NETWORK_TYPE_EVDO_0 = 5;
    public static final int DATA_CALL_SESSION__RAT_AT_END__NETWORK_TYPE_EVDO_A = 6;
    public static final int DATA_CALL_SESSION__RAT_AT_END__NETWORK_TYPE_1XRTT = 7;
    public static final int DATA_CALL_SESSION__RAT_AT_END__NETWORK_TYPE_HSDPA = 8;
    public static final int DATA_CALL_SESSION__RAT_AT_END__NETWORK_TYPE_HSUPA = 9;
    public static final int DATA_CALL_SESSION__RAT_AT_END__NETWORK_TYPE_HSPA = 10;
    public static final int DATA_CALL_SESSION__RAT_AT_END__NETWORK_TYPE_IDEN = 11;
    public static final int DATA_CALL_SESSION__RAT_AT_END__NETWORK_TYPE_EVDO_B = 12;
    public static final int DATA_CALL_SESSION__RAT_AT_END__NETWORK_TYPE_LTE = 13;
    public static final int DATA_CALL_SESSION__RAT_AT_END__NETWORK_TYPE_EHRPD = 14;
    public static final int DATA_CALL_SESSION__RAT_AT_END__NETWORK_TYPE_HSPAP = 15;
    public static final int DATA_CALL_SESSION__RAT_AT_END__NETWORK_TYPE_GSM = 16;
    public static final int DATA_CALL_SESSION__RAT_AT_END__NETWORK_TYPE_TD_SCDMA = 17;
    public static final int DATA_CALL_SESSION__RAT_AT_END__NETWORK_TYPE_IWLAN = 18;
    public static final int DATA_CALL_SESSION__RAT_AT_END__NETWORK_TYPE_LTE_CA = 19;
    public static final int DATA_CALL_SESSION__RAT_AT_END__NETWORK_TYPE_NR = 20;

    // Values for DataCallSession.ip_type
    public static final int DATA_CALL_SESSION__IP_TYPE__APN_PROTOCOL_IPV4 = 0;
    public static final int DATA_CALL_SESSION__IP_TYPE__APN_PROTOCOL_IPV6 = 1;
    public static final int DATA_CALL_SESSION__IP_TYPE__APN_PROTOCOL_IPV4V6 = 2;
    public static final int DATA_CALL_SESSION__IP_TYPE__APN_PROTOCOL_PPP = 3;

    // Values for DataCallSession.deactivate_reason
    public static final int DATA_CALL_SESSION__DEACTIVATE_REASON__DEACTIVATE_REASON_UNKNOWN = 0;
    public static final int DATA_CALL_SESSION__DEACTIVATE_REASON__DEACTIVATE_REASON_NORMAL = 1;
    public static final int DATA_CALL_SESSION__DEACTIVATE_REASON__DEACTIVATE_REASON_RADIO_OFF = 2;
    public static final int DATA_CALL_SESSION__DEACTIVATE_REASON__DEACTIVATE_REASON_HANDOVER = 3;
    public static final int DATA_CALL_SESSION__DEACTIVATE_REASON__DEACTIVATE_REASON_NONE = 4;
    public static final int DATA_CALL_SESSION__DEACTIVATE_REASON__DEACTIVATE_REASON_CONNECTIVITY_SERVICE_UNWANTED = 5;
    public static final int DATA_CALL_SESSION__DEACTIVATE_REASON__DEACTIVATE_REASON_SIM_REMOVAL = 6;
    public static final int DATA_CALL_SESSION__DEACTIVATE_REASON__DEACTIVATE_REASON_AIRPLANE_MODE_ON = 7;
    public static final int DATA_CALL_SESSION__DEACTIVATE_REASON__DEACTIVATE_REASON_DATA_DISABLED = 8;
    public static final int DATA_CALL_SESSION__DEACTIVATE_REASON__DEACTIVATE_REASON_NO_LIVE_REQUEST = 9;
    public static final int DATA_CALL_SESSION__DEACTIVATE_REASON__DEACTIVATE_REASON_RAT_NOT_ALLOWED = 10;
    public static final int DATA_CALL_SESSION__DEACTIVATE_REASON__DEACTIVATE_REASON_ROAMING_DISABLED = 11;
    public static final int DATA_CALL_SESSION__DEACTIVATE_REASON__DEACTIVATE_REASON_CONCURRENT_VOICE_DATA_NOT_ALLOWED = 12;
    public static final int DATA_CALL_SESSION__DEACTIVATE_REASON__DEACTIVATE_REASON_DATA_SERVICE_NOT_READY = 14;
    public static final int DATA_CALL_SESSION__DEACTIVATE_REASON__DEACTIVATE_REASON_POWER_OFF_BY_CARRIER = 15;
    public static final int DATA_CALL_SESSION__DEACTIVATE_REASON__DEACTIVATE_REASON_DATA_STALL = 16;
    public static final int DATA_CALL_SESSION__DEACTIVATE_REASON__DEACTIVATE_REASON_HANDOVER_FAILED = 17;
    public static final int DATA_CALL_SESSION__DEACTIVATE_REASON__DEACTIVATE_REASON_HANDOVER_NOT_ALLOWED = 18;
    public static final int DATA_CALL_SESSION__DEACTIVATE_REASON__DEACTIVATE_REASON_VCN_REQUESTED = 19;
    public static final int DATA_CALL_SESSION__DEACTIVATE_REASON__DEACTIVATE_REASON_VOPS_NOT_SUPPORTED = 20;
    public static final int DATA_CALL_SESSION__DEACTIVATE_REASON__DEACTIVATE_REASON_DEFAULT_DATA_UNSELECTED = 21;
    public static final int DATA_CALL_SESSION__DEACTIVATE_REASON__DEACTIVATE_REASON_NOT_IN_SERVICE = 22;
    public static final int DATA_CALL_SESSION__DEACTIVATE_REASON__DEACTIVATE_REASON_DATA_CONFIG_NOT_READY = 23;
    public static final int DATA_CALL_SESSION__DEACTIVATE_REASON__DEACTIVATE_REASON_PENDING_TEAR_DOWN_ALL = 24;
    public static final int DATA_CALL_SESSION__DEACTIVATE_REASON__DEACTIVATE_REASON_NO_SUITABLE_DATA_PROFILE = 25;
    public static final int DATA_CALL_SESSION__DEACTIVATE_REASON__DEACTIVATE_REASON_CDMA_EMERGENCY_CALLBACK_MODE = 26;
    public static final int DATA_CALL_SESSION__DEACTIVATE_REASON__DEACTIVATE_REASON_RETRY_SCHEDULED = 27;
    public static final int DATA_CALL_SESSION__DEACTIVATE_REASON__DEACTIVATE_REASON_DATA_THROTTLED = 28;
    public static final int DATA_CALL_SESSION__DEACTIVATE_REASON__DEACTIVATE_REASON_DATA_PROFILE_INVALID = 29;
    public static final int DATA_CALL_SESSION__DEACTIVATE_REASON__DEACTIVATE_REASON_DATA_PROFILE_NOT_PREFERRED = 30;
    public static final int DATA_CALL_SESSION__DEACTIVATE_REASON__DEACTIVATE_REASON_NOT_ALLOWED_BY_POLICY = 31;
    public static final int DATA_CALL_SESSION__DEACTIVATE_REASON__DEACTIVATE_REASON_ILLEGAL_STATE = 32;
    public static final int DATA_CALL_SESSION__DEACTIVATE_REASON__DEACTIVATE_REASON_ONLY_ALLOWED_SINGLE_NETWORK = 33;
    public static final int DATA_CALL_SESSION__DEACTIVATE_REASON__DEACTIVATE_REASON_PREFERRED_DATA_SWITCHED = 34;

    // Values for CellularServiceState.voice_rat
    public static final int CELLULAR_SERVICE_STATE__VOICE_RAT__NETWORK_TYPE_UNKNOWN = 0;
    public static final int CELLULAR_SERVICE_STATE__VOICE_RAT__NETWORK_TYPE_GPRS = 1;
    public static final int CELLULAR_SERVICE_STATE__VOICE_RAT__NETWORK_TYPE_EDGE = 2;
    public static final int CELLULAR_SERVICE_STATE__VOICE_RAT__NETWORK_TYPE_UMTS = 3;
    public static final int CELLULAR_SERVICE_STATE__VOICE_RAT__NETWORK_TYPE_CDMA = 4;
    public static final int CELLULAR_SERVICE_STATE__VOICE_RAT__NETWORK_TYPE_EVDO_0 = 5;
    public static final int CELLULAR_SERVICE_STATE__VOICE_RAT__NETWORK_TYPE_EVDO_A = 6;
    public static final int CELLULAR_SERVICE_STATE__VOICE_RAT__NETWORK_TYPE_1XRTT = 7;
    public static final int CELLULAR_SERVICE_STATE__VOICE_RAT__NETWORK_TYPE_HSDPA = 8;
    public static final int CELLULAR_SERVICE_STATE__VOICE_RAT__NETWORK_TYPE_HSUPA = 9;
    public static final int CELLULAR_SERVICE_STATE__VOICE_RAT__NETWORK_TYPE_HSPA = 10;
    public static final int CELLULAR_SERVICE_STATE__VOICE_RAT__NETWORK_TYPE_IDEN = 11;
    public static final int CELLULAR_SERVICE_STATE__VOICE_RAT__NETWORK_TYPE_EVDO_B = 12;
    public static final int CELLULAR_SERVICE_STATE__VOICE_RAT__NETWORK_TYPE_LTE = 13;
    public static final int CELLULAR_SERVICE_STATE__VOICE_RAT__NETWORK_TYPE_EHRPD = 14;
    public static final int CELLULAR_SERVICE_STATE__VOICE_RAT__NETWORK_TYPE_HSPAP = 15;
    public static final int CELLULAR_SERVICE_STATE__VOICE_RAT__NETWORK_TYPE_GSM = 16;
    public static final int CELLULAR_SERVICE_STATE__VOICE_RAT__NETWORK_TYPE_TD_SCDMA = 17;
    public static final int CELLULAR_SERVICE_STATE__VOICE_RAT__NETWORK_TYPE_IWLAN = 18;
    public static final int CELLULAR_SERVICE_STATE__VOICE_RAT__NETWORK_TYPE_LTE_CA = 19;
    public static final int CELLULAR_SERVICE_STATE__VOICE_RAT__NETWORK_TYPE_NR = 20;

    // Values for CellularServiceState.data_rat
    public static final int CELLULAR_SERVICE_STATE__DATA_RAT__NETWORK_TYPE_UNKNOWN = 0;
    public static final int CELLULAR_SERVICE_STATE__DATA_RAT__NETWORK_TYPE_GPRS = 1;
    public static final int CELLULAR_SERVICE_STATE__DATA_RAT__NETWORK_TYPE_EDGE = 2;
    public static final int CELLULAR_SERVICE_STATE__DATA_RAT__NETWORK_TYPE_UMTS = 3;
    public static final int CELLULAR_SERVICE_STATE__DATA_RAT__NETWORK_TYPE_CDMA = 4;
    public static final int CELLULAR_SERVICE_STATE__DATA_RAT__NETWORK_TYPE_EVDO_0 = 5;
    public static final int CELLULAR_SERVICE_STATE__DATA_RAT__NETWORK_TYPE_EVDO_A = 6;
    public static final int CELLULAR_SERVICE_STATE__DATA_RAT__NETWORK_TYPE_1XRTT = 7;
    public static final int CELLULAR_SERVICE_STATE__DATA_RAT__NETWORK_TYPE_HSDPA = 8;
    public static final int CELLULAR_SERVICE_STATE__DATA_RAT__NETWORK_TYPE_HSUPA = 9;
    public static final int CELLULAR_SERVICE_STATE__DATA_RAT__NETWORK_TYPE_HSPA = 10;
    public static final int CELLULAR_SERVICE_STATE__DATA_RAT__NETWORK_TYPE_IDEN = 11;
    public static final int CELLULAR_SERVICE_STATE__DATA_RAT__NETWORK_TYPE_EVDO_B = 12;
    public static final int CELLULAR_SERVICE_STATE__DATA_RAT__NETWORK_TYPE_LTE = 13;
    public static final int CELLULAR_SERVICE_STATE__DATA_RAT__NETWORK_TYPE_EHRPD = 14;
    public static final int CELLULAR_SERVICE_STATE__DATA_RAT__NETWORK_TYPE_HSPAP = 15;
    public static final int CELLULAR_SERVICE_STATE__DATA_RAT__NETWORK_TYPE_GSM = 16;
    public static final int CELLULAR_SERVICE_STATE__DATA_RAT__NETWORK_TYPE_TD_SCDMA = 17;
    public static final int CELLULAR_SERVICE_STATE__DATA_RAT__NETWORK_TYPE_IWLAN = 18;
    public static final int CELLULAR_SERVICE_STATE__DATA_RAT__NETWORK_TYPE_LTE_CA = 19;
    public static final int CELLULAR_SERVICE_STATE__DATA_RAT__NETWORK_TYPE_NR = 20;

    // Values for CellularServiceState.voice_roaming_type
    public static final int CELLULAR_SERVICE_STATE__VOICE_ROAMING_TYPE__ROAMING_TYPE_NOT_ROAMING = 0;
    public static final int CELLULAR_SERVICE_STATE__VOICE_ROAMING_TYPE__ROAMING_TYPE_ROAMING = 1;
    public static final int CELLULAR_SERVICE_STATE__VOICE_ROAMING_TYPE__ROAMING_TYPE_ROAMING_DOMESTIC = 2;
    public static final int CELLULAR_SERVICE_STATE__VOICE_ROAMING_TYPE__ROAMING_TYPE_ROAMING_INTERNATIONAL = 3;

    // Values for CellularServiceState.data_roaming_type
    public static final int CELLULAR_SERVICE_STATE__DATA_ROAMING_TYPE__ROAMING_TYPE_NOT_ROAMING = 0;
    public static final int CELLULAR_SERVICE_STATE__DATA_ROAMING_TYPE__ROAMING_TYPE_ROAMING = 1;
    public static final int CELLULAR_SERVICE_STATE__DATA_ROAMING_TYPE__ROAMING_TYPE_ROAMING_DOMESTIC = 2;
    public static final int CELLULAR_SERVICE_STATE__DATA_ROAMING_TYPE__ROAMING_TYPE_ROAMING_INTERNATIONAL = 3;

    // Values for CellularServiceState.fold_state
    public static final int CELLULAR_SERVICE_STATE__FOLD_STATE__STATE_UNKNOWN = 0;
    public static final int CELLULAR_SERVICE_STATE__FOLD_STATE__STATE_CLOSED = 1;
    public static final int CELLULAR_SERVICE_STATE__FOLD_STATE__STATE_HALF_OPENED = 2;
    public static final int CELLULAR_SERVICE_STATE__FOLD_STATE__STATE_OPENED = 3;
    public static final int CELLULAR_SERVICE_STATE__FOLD_STATE__STATE_FLIPPED = 4;

    // Values for CellularDataServiceSwitch.rat_from
    public static final int CELLULAR_DATA_SERVICE_SWITCH__RAT_FROM__NETWORK_TYPE_UNKNOWN = 0;
    public static final int CELLULAR_DATA_SERVICE_SWITCH__RAT_FROM__NETWORK_TYPE_GPRS = 1;
    public static final int CELLULAR_DATA_SERVICE_SWITCH__RAT_FROM__NETWORK_TYPE_EDGE = 2;
    public static final int CELLULAR_DATA_SERVICE_SWITCH__RAT_FROM__NETWORK_TYPE_UMTS = 3;
    public static final int CELLULAR_DATA_SERVICE_SWITCH__RAT_FROM__NETWORK_TYPE_CDMA = 4;
    public static final int CELLULAR_DATA_SERVICE_SWITCH__RAT_FROM__NETWORK_TYPE_EVDO_0 = 5;
    public static final int CELLULAR_DATA_SERVICE_SWITCH__RAT_FROM__NETWORK_TYPE_EVDO_A = 6;
    public static final int CELLULAR_DATA_SERVICE_SWITCH__RAT_FROM__NETWORK_TYPE_1XRTT = 7;
    public static final int CELLULAR_DATA_SERVICE_SWITCH__RAT_FROM__NETWORK_TYPE_HSDPA = 8;
    public static final int CELLULAR_DATA_SERVICE_SWITCH__RAT_FROM__NETWORK_TYPE_HSUPA = 9;
    public static final int CELLULAR_DATA_SERVICE_SWITCH__RAT_FROM__NETWORK_TYPE_HSPA = 10;
    public static final int CELLULAR_DATA_SERVICE_SWITCH__RAT_FROM__NETWORK_TYPE_IDEN = 11;
    public static final int CELLULAR_DATA_SERVICE_SWITCH__RAT_FROM__NETWORK_TYPE_EVDO_B = 12;
    public static final int CELLULAR_DATA_SERVICE_SWITCH__RAT_FROM__NETWORK_TYPE_LTE = 13;
    public static final int CELLULAR_DATA_SERVICE_SWITCH__RAT_FROM__NETWORK_TYPE_EHRPD = 14;
    public static final int CELLULAR_DATA_SERVICE_SWITCH__RAT_FROM__NETWORK_TYPE_HSPAP = 15;
    public static final int CELLULAR_DATA_SERVICE_SWITCH__RAT_FROM__NETWORK_TYPE_GSM = 16;
    public static final int CELLULAR_DATA_SERVICE_SWITCH__RAT_FROM__NETWORK_TYPE_TD_SCDMA = 17;
    public static final int CELLULAR_DATA_SERVICE_SWITCH__RAT_FROM__NETWORK_TYPE_IWLAN = 18;
    public static final int CELLULAR_DATA_SERVICE_SWITCH__RAT_FROM__NETWORK_TYPE_LTE_CA = 19;
    public static final int CELLULAR_DATA_SERVICE_SWITCH__RAT_FROM__NETWORK_TYPE_NR = 20;

    // Values for CellularDataServiceSwitch.rat_to
    public static final int CELLULAR_DATA_SERVICE_SWITCH__RAT_TO__NETWORK_TYPE_UNKNOWN = 0;
    public static final int CELLULAR_DATA_SERVICE_SWITCH__RAT_TO__NETWORK_TYPE_GPRS = 1;
    public static final int CELLULAR_DATA_SERVICE_SWITCH__RAT_TO__NETWORK_TYPE_EDGE = 2;
    public static final int CELLULAR_DATA_SERVICE_SWITCH__RAT_TO__NETWORK_TYPE_UMTS = 3;
    public static final int CELLULAR_DATA_SERVICE_SWITCH__RAT_TO__NETWORK_TYPE_CDMA = 4;
    public static final int CELLULAR_DATA_SERVICE_SWITCH__RAT_TO__NETWORK_TYPE_EVDO_0 = 5;
    public static final int CELLULAR_DATA_SERVICE_SWITCH__RAT_TO__NETWORK_TYPE_EVDO_A = 6;
    public static final int CELLULAR_DATA_SERVICE_SWITCH__RAT_TO__NETWORK_TYPE_1XRTT = 7;
    public static final int CELLULAR_DATA_SERVICE_SWITCH__RAT_TO__NETWORK_TYPE_HSDPA = 8;
    public static final int CELLULAR_DATA_SERVICE_SWITCH__RAT_TO__NETWORK_TYPE_HSUPA = 9;
    public static final int CELLULAR_DATA_SERVICE_SWITCH__RAT_TO__NETWORK_TYPE_HSPA = 10;
    public static final int CELLULAR_DATA_SERVICE_SWITCH__RAT_TO__NETWORK_TYPE_IDEN = 11;
    public static final int CELLULAR_DATA_SERVICE_SWITCH__RAT_TO__NETWORK_TYPE_EVDO_B = 12;
    public static final int CELLULAR_DATA_SERVICE_SWITCH__RAT_TO__NETWORK_TYPE_LTE = 13;
    public static final int CELLULAR_DATA_SERVICE_SWITCH__RAT_TO__NETWORK_TYPE_EHRPD = 14;
    public static final int CELLULAR_DATA_SERVICE_SWITCH__RAT_TO__NETWORK_TYPE_HSPAP = 15;
    public static final int CELLULAR_DATA_SERVICE_SWITCH__RAT_TO__NETWORK_TYPE_GSM = 16;
    public static final int CELLULAR_DATA_SERVICE_SWITCH__RAT_TO__NETWORK_TYPE_TD_SCDMA = 17;
    public static final int CELLULAR_DATA_SERVICE_SWITCH__RAT_TO__NETWORK_TYPE_IWLAN = 18;
    public static final int CELLULAR_DATA_SERVICE_SWITCH__RAT_TO__NETWORK_TYPE_LTE_CA = 19;
    public static final int CELLULAR_DATA_SERVICE_SWITCH__RAT_TO__NETWORK_TYPE_NR = 20;

    // Values for ImsRegistrationTermination.rat_at_end
    public static final int IMS_REGISTRATION_TERMINATION__RAT_AT_END__NETWORK_TYPE_UNKNOWN = 0;
    public static final int IMS_REGISTRATION_TERMINATION__RAT_AT_END__NETWORK_TYPE_GPRS = 1;
    public static final int IMS_REGISTRATION_TERMINATION__RAT_AT_END__NETWORK_TYPE_EDGE = 2;
    public static final int IMS_REGISTRATION_TERMINATION__RAT_AT_END__NETWORK_TYPE_UMTS = 3;
    public static final int IMS_REGISTRATION_TERMINATION__RAT_AT_END__NETWORK_TYPE_CDMA = 4;
    public static final int IMS_REGISTRATION_TERMINATION__RAT_AT_END__NETWORK_TYPE_EVDO_0 = 5;
    public static final int IMS_REGISTRATION_TERMINATION__RAT_AT_END__NETWORK_TYPE_EVDO_A = 6;
    public static final int IMS_REGISTRATION_TERMINATION__RAT_AT_END__NETWORK_TYPE_1XRTT = 7;
    public static final int IMS_REGISTRATION_TERMINATION__RAT_AT_END__NETWORK_TYPE_HSDPA = 8;
    public static final int IMS_REGISTRATION_TERMINATION__RAT_AT_END__NETWORK_TYPE_HSUPA = 9;
    public static final int IMS_REGISTRATION_TERMINATION__RAT_AT_END__NETWORK_TYPE_HSPA = 10;
    public static final int IMS_REGISTRATION_TERMINATION__RAT_AT_END__NETWORK_TYPE_IDEN = 11;
    public static final int IMS_REGISTRATION_TERMINATION__RAT_AT_END__NETWORK_TYPE_EVDO_B = 12;
    public static final int IMS_REGISTRATION_TERMINATION__RAT_AT_END__NETWORK_TYPE_LTE = 13;
    public static final int IMS_REGISTRATION_TERMINATION__RAT_AT_END__NETWORK_TYPE_EHRPD = 14;
    public static final int IMS_REGISTRATION_TERMINATION__RAT_AT_END__NETWORK_TYPE_HSPAP = 15;
    public static final int IMS_REGISTRATION_TERMINATION__RAT_AT_END__NETWORK_TYPE_GSM = 16;
    public static final int IMS_REGISTRATION_TERMINATION__RAT_AT_END__NETWORK_TYPE_TD_SCDMA = 17;
    public static final int IMS_REGISTRATION_TERMINATION__RAT_AT_END__NETWORK_TYPE_IWLAN = 18;
    public static final int IMS_REGISTRATION_TERMINATION__RAT_AT_END__NETWORK_TYPE_LTE_CA = 19;
    public static final int IMS_REGISTRATION_TERMINATION__RAT_AT_END__NETWORK_TYPE_NR = 20;

    // Values for ImsRegistrationStats.rat
    public static final int IMS_REGISTRATION_STATS__RAT__NETWORK_TYPE_UNKNOWN = 0;
    public static final int IMS_REGISTRATION_STATS__RAT__NETWORK_TYPE_GPRS = 1;
    public static final int IMS_REGISTRATION_STATS__RAT__NETWORK_TYPE_EDGE = 2;
    public static final int IMS_REGISTRATION_STATS__RAT__NETWORK_TYPE_UMTS = 3;
    public static final int IMS_REGISTRATION_STATS__RAT__NETWORK_TYPE_CDMA = 4;
    public static final int IMS_REGISTRATION_STATS__RAT__NETWORK_TYPE_EVDO_0 = 5;
    public static final int IMS_REGISTRATION_STATS__RAT__NETWORK_TYPE_EVDO_A = 6;
    public static final int IMS_REGISTRATION_STATS__RAT__NETWORK_TYPE_1XRTT = 7;
    public static final int IMS_REGISTRATION_STATS__RAT__NETWORK_TYPE_HSDPA = 8;
    public static final int IMS_REGISTRATION_STATS__RAT__NETWORK_TYPE_HSUPA = 9;
    public static final int IMS_REGISTRATION_STATS__RAT__NETWORK_TYPE_HSPA = 10;
    public static final int IMS_REGISTRATION_STATS__RAT__NETWORK_TYPE_IDEN = 11;
    public static final int IMS_REGISTRATION_STATS__RAT__NETWORK_TYPE_EVDO_B = 12;
    public static final int IMS_REGISTRATION_STATS__RAT__NETWORK_TYPE_LTE = 13;
    public static final int IMS_REGISTRATION_STATS__RAT__NETWORK_TYPE_EHRPD = 14;
    public static final int IMS_REGISTRATION_STATS__RAT__NETWORK_TYPE_HSPAP = 15;
    public static final int IMS_REGISTRATION_STATS__RAT__NETWORK_TYPE_GSM = 16;
    public static final int IMS_REGISTRATION_STATS__RAT__NETWORK_TYPE_TD_SCDMA = 17;
    public static final int IMS_REGISTRATION_STATS__RAT__NETWORK_TYPE_IWLAN = 18;
    public static final int IMS_REGISTRATION_STATS__RAT__NETWORK_TYPE_LTE_CA = 19;
    public static final int IMS_REGISTRATION_STATS__RAT__NETWORK_TYPE_NR = 20;

    // Values for ImsRegistrationFeatureTagStats.feature_tag_name
    public static final int IMS_REGISTRATION_FEATURE_TAG_STATS__FEATURE_TAG_NAME__IMS_FEATURE_TAG_UNSPECIFIED = 0;
    public static final int IMS_REGISTRATION_FEATURE_TAG_STATS__FEATURE_TAG_NAME__IMS_FEATURE_TAG_CUSTOM = 1;
    public static final int IMS_REGISTRATION_FEATURE_TAG_STATS__FEATURE_TAG_NAME__IMS_FEATURE_TAG_STANDALONE_MSG = 2;
    public static final int IMS_REGISTRATION_FEATURE_TAG_STATS__FEATURE_TAG_NAME__IMS_FEATURE_TAG_CHAT_IM = 3;
    public static final int IMS_REGISTRATION_FEATURE_TAG_STATS__FEATURE_TAG_NAME__IMS_FEATURE_TAG_CHAT_SESSION = 4;
    public static final int IMS_REGISTRATION_FEATURE_TAG_STATS__FEATURE_TAG_NAME__IMS_FEATURE_TAG_FILE_TRANSFER = 5;
    public static final int IMS_REGISTRATION_FEATURE_TAG_STATS__FEATURE_TAG_NAME__IMS_FEATURE_TAG_FILE_TRANSFER_VIA_SMS = 6;
    public static final int IMS_REGISTRATION_FEATURE_TAG_STATS__FEATURE_TAG_NAME__IMS_FEATURE_TAG_CALL_COMPOSER_ENRICHED_CALLING = 7;
    public static final int IMS_REGISTRATION_FEATURE_TAG_STATS__FEATURE_TAG_NAME__IMS_FEATURE_TAG_CALL_COMPOSER_VIA_TELEPHONY = 8;
    public static final int IMS_REGISTRATION_FEATURE_TAG_STATS__FEATURE_TAG_NAME__IMS_FEATURE_TAG_POST_CALL = 9;
    public static final int IMS_REGISTRATION_FEATURE_TAG_STATS__FEATURE_TAG_NAME__IMS_FEATURE_TAG_SHARED_MAP = 10;
    public static final int IMS_REGISTRATION_FEATURE_TAG_STATS__FEATURE_TAG_NAME__IMS_FEATURE_TAG_SHARED_SKETCH = 11;
    public static final int IMS_REGISTRATION_FEATURE_TAG_STATS__FEATURE_TAG_NAME__IMS_FEATURE_TAG_GEO_PUSH = 12;
    public static final int IMS_REGISTRATION_FEATURE_TAG_STATS__FEATURE_TAG_NAME__IMS_FEATURE_TAG_GEO_PUSH_VIA_SMS = 13;
    public static final int IMS_REGISTRATION_FEATURE_TAG_STATS__FEATURE_TAG_NAME__IMS_FEATURE_TAG_CHATBOT_COMMUNICATION_USING_SESSION = 14;
    public static final int IMS_REGISTRATION_FEATURE_TAG_STATS__FEATURE_TAG_NAME__IMS_FEATURE_TAG_CHATBOT_COMMUNICATION_USING_STANDALONE_MSG = 15;
    public static final int IMS_REGISTRATION_FEATURE_TAG_STATS__FEATURE_TAG_NAME__IMS_FEATURE_TAG_CHATBOT_VERSION_SUPPORTED = 16;
    public static final int IMS_REGISTRATION_FEATURE_TAG_STATS__FEATURE_TAG_NAME__IMS_FEATURE_TAG_CHATBOT_ROLE = 17;
    public static final int IMS_REGISTRATION_FEATURE_TAG_STATS__FEATURE_TAG_NAME__IMS_FEATURE_TAG_MMTEL = 18;
    public static final int IMS_REGISTRATION_FEATURE_TAG_STATS__FEATURE_TAG_NAME__IMS_FEATURE_TAG_VIDEO = 19;
    public static final int IMS_REGISTRATION_FEATURE_TAG_STATS__FEATURE_TAG_NAME__IMS_FEATURE_TAG_PRESENCE = 20;

    // Values for RcsClientProvisioningStats.event
    public static final int RCS_CLIENT_PROVISIONING_STATS__EVENT__EVENT_TYPE_UNSPECIFIED = 0;
    public static final int RCS_CLIENT_PROVISIONING_STATS__EVENT__CLIENT_PARAMS_SENT = 1;
    public static final int RCS_CLIENT_PROVISIONING_STATS__EVENT__TRIGGER_RCS_RECONFIGURATION = 2;
    public static final int RCS_CLIENT_PROVISIONING_STATS__EVENT__DMA_CHANGED = 3;

    // Values for RcsAcsProvisioningStats.response_type
    public static final int RCS_ACS_PROVISIONING_STATS__RESPONSE_TYPE__RESPONSE_TYPE_UNSPECIFIED = 0;
    public static final int RCS_ACS_PROVISIONING_STATS__RESPONSE_TYPE__ERROR = 1;
    public static final int RCS_ACS_PROVISIONING_STATS__RESPONSE_TYPE__PROVISIONING_XML = 2;
    public static final int RCS_ACS_PROVISIONING_STATS__RESPONSE_TYPE__PRE_PROVISIONING_XML = 3;

    // Values for SipTransportFeatureTagStats.feature_tag_name
    public static final int SIP_TRANSPORT_FEATURE_TAG_STATS__FEATURE_TAG_NAME__IMS_FEATURE_TAG_UNSPECIFIED = 0;
    public static final int SIP_TRANSPORT_FEATURE_TAG_STATS__FEATURE_TAG_NAME__IMS_FEATURE_TAG_CUSTOM = 1;
    public static final int SIP_TRANSPORT_FEATURE_TAG_STATS__FEATURE_TAG_NAME__IMS_FEATURE_TAG_STANDALONE_MSG = 2;
    public static final int SIP_TRANSPORT_FEATURE_TAG_STATS__FEATURE_TAG_NAME__IMS_FEATURE_TAG_CHAT_IM = 3;
    public static final int SIP_TRANSPORT_FEATURE_TAG_STATS__FEATURE_TAG_NAME__IMS_FEATURE_TAG_CHAT_SESSION = 4;
    public static final int SIP_TRANSPORT_FEATURE_TAG_STATS__FEATURE_TAG_NAME__IMS_FEATURE_TAG_FILE_TRANSFER = 5;
    public static final int SIP_TRANSPORT_FEATURE_TAG_STATS__FEATURE_TAG_NAME__IMS_FEATURE_TAG_FILE_TRANSFER_VIA_SMS = 6;
    public static final int SIP_TRANSPORT_FEATURE_TAG_STATS__FEATURE_TAG_NAME__IMS_FEATURE_TAG_CALL_COMPOSER_ENRICHED_CALLING = 7;
    public static final int SIP_TRANSPORT_FEATURE_TAG_STATS__FEATURE_TAG_NAME__IMS_FEATURE_TAG_CALL_COMPOSER_VIA_TELEPHONY = 8;
    public static final int SIP_TRANSPORT_FEATURE_TAG_STATS__FEATURE_TAG_NAME__IMS_FEATURE_TAG_POST_CALL = 9;
    public static final int SIP_TRANSPORT_FEATURE_TAG_STATS__FEATURE_TAG_NAME__IMS_FEATURE_TAG_SHARED_MAP = 10;
    public static final int SIP_TRANSPORT_FEATURE_TAG_STATS__FEATURE_TAG_NAME__IMS_FEATURE_TAG_SHARED_SKETCH = 11;
    public static final int SIP_TRANSPORT_FEATURE_TAG_STATS__FEATURE_TAG_NAME__IMS_FEATURE_TAG_GEO_PUSH = 12;
    public static final int SIP_TRANSPORT_FEATURE_TAG_STATS__FEATURE_TAG_NAME__IMS_FEATURE_TAG_GEO_PUSH_VIA_SMS = 13;
    public static final int SIP_TRANSPORT_FEATURE_TAG_STATS__FEATURE_TAG_NAME__IMS_FEATURE_TAG_CHATBOT_COMMUNICATION_USING_SESSION = 14;
    public static final int SIP_TRANSPORT_FEATURE_TAG_STATS__FEATURE_TAG_NAME__IMS_FEATURE_TAG_CHATBOT_COMMUNICATION_USING_STANDALONE_MSG = 15;
    public static final int SIP_TRANSPORT_FEATURE_TAG_STATS__FEATURE_TAG_NAME__IMS_FEATURE_TAG_CHATBOT_VERSION_SUPPORTED = 16;
    public static final int SIP_TRANSPORT_FEATURE_TAG_STATS__FEATURE_TAG_NAME__IMS_FEATURE_TAG_CHATBOT_ROLE = 17;
    public static final int SIP_TRANSPORT_FEATURE_TAG_STATS__FEATURE_TAG_NAME__IMS_FEATURE_TAG_MMTEL = 18;
    public static final int SIP_TRANSPORT_FEATURE_TAG_STATS__FEATURE_TAG_NAME__IMS_FEATURE_TAG_VIDEO = 19;
    public static final int SIP_TRANSPORT_FEATURE_TAG_STATS__FEATURE_TAG_NAME__IMS_FEATURE_TAG_PRESENCE = 20;

    // Values for SipMessageResponse.sip_message_method
    public static final int SIP_MESSAGE_RESPONSE__SIP_MESSAGE_METHOD__SIP_REQUEST_UNSPECIFIED = 0;
    public static final int SIP_MESSAGE_RESPONSE__SIP_MESSAGE_METHOD__SIP_REQUEST_CUSTOM = 1;
    public static final int SIP_MESSAGE_RESPONSE__SIP_MESSAGE_METHOD__SIP_REQUEST_INVITE = 2;
    public static final int SIP_MESSAGE_RESPONSE__SIP_MESSAGE_METHOD__SIP_REQUEST_ACK = 3;
    public static final int SIP_MESSAGE_RESPONSE__SIP_MESSAGE_METHOD__SIP_REQUEST_OPTIONS = 4;
    public static final int SIP_MESSAGE_RESPONSE__SIP_MESSAGE_METHOD__SIP_REQUEST_BYE = 5;
    public static final int SIP_MESSAGE_RESPONSE__SIP_MESSAGE_METHOD__SIP_REQUEST_CANCEL = 6;
    public static final int SIP_MESSAGE_RESPONSE__SIP_MESSAGE_METHOD__SIP_REQUEST_REGISTER = 7;
    public static final int SIP_MESSAGE_RESPONSE__SIP_MESSAGE_METHOD__SIP_REQUEST_PRACK = 8;
    public static final int SIP_MESSAGE_RESPONSE__SIP_MESSAGE_METHOD__SIP_REQUEST_SUBSCRIBE = 9;
    public static final int SIP_MESSAGE_RESPONSE__SIP_MESSAGE_METHOD__SIP_REQUEST_NOTIFY = 10;
    public static final int SIP_MESSAGE_RESPONSE__SIP_MESSAGE_METHOD__SIP_REQUEST_PUBLISH = 11;
    public static final int SIP_MESSAGE_RESPONSE__SIP_MESSAGE_METHOD__SIP_REQUEST_INFO = 12;
    public static final int SIP_MESSAGE_RESPONSE__SIP_MESSAGE_METHOD__SIP_REQUEST_REFER = 13;
    public static final int SIP_MESSAGE_RESPONSE__SIP_MESSAGE_METHOD__SIP_REQUEST_MESSAGE = 14;
    public static final int SIP_MESSAGE_RESPONSE__SIP_MESSAGE_METHOD__SIP_REQUEST_UPDATE = 15;

    // Values for SipMessageResponse.sip_message_direction
    public static final int SIP_MESSAGE_RESPONSE__SIP_MESSAGE_DIRECTION__UNKNOWN = 0;
    public static final int SIP_MESSAGE_RESPONSE__SIP_MESSAGE_DIRECTION__INCOMING = 1;
    public static final int SIP_MESSAGE_RESPONSE__SIP_MESSAGE_DIRECTION__OUTGOING = 2;

    // Values for SipTransportSession.session_method
    public static final int SIP_TRANSPORT_SESSION__SESSION_METHOD__SIP_REQUEST_UNSPECIFIED = 0;
    public static final int SIP_TRANSPORT_SESSION__SESSION_METHOD__SIP_REQUEST_CUSTOM = 1;
    public static final int SIP_TRANSPORT_SESSION__SESSION_METHOD__SIP_REQUEST_INVITE = 2;
    public static final int SIP_TRANSPORT_SESSION__SESSION_METHOD__SIP_REQUEST_ACK = 3;
    public static final int SIP_TRANSPORT_SESSION__SESSION_METHOD__SIP_REQUEST_OPTIONS = 4;
    public static final int SIP_TRANSPORT_SESSION__SESSION_METHOD__SIP_REQUEST_BYE = 5;
    public static final int SIP_TRANSPORT_SESSION__SESSION_METHOD__SIP_REQUEST_CANCEL = 6;
    public static final int SIP_TRANSPORT_SESSION__SESSION_METHOD__SIP_REQUEST_REGISTER = 7;
    public static final int SIP_TRANSPORT_SESSION__SESSION_METHOD__SIP_REQUEST_PRACK = 8;
    public static final int SIP_TRANSPORT_SESSION__SESSION_METHOD__SIP_REQUEST_SUBSCRIBE = 9;
    public static final int SIP_TRANSPORT_SESSION__SESSION_METHOD__SIP_REQUEST_NOTIFY = 10;
    public static final int SIP_TRANSPORT_SESSION__SESSION_METHOD__SIP_REQUEST_PUBLISH = 11;
    public static final int SIP_TRANSPORT_SESSION__SESSION_METHOD__SIP_REQUEST_INFO = 12;
    public static final int SIP_TRANSPORT_SESSION__SESSION_METHOD__SIP_REQUEST_REFER = 13;
    public static final int SIP_TRANSPORT_SESSION__SESSION_METHOD__SIP_REQUEST_MESSAGE = 14;
    public static final int SIP_TRANSPORT_SESSION__SESSION_METHOD__SIP_REQUEST_UPDATE = 15;

    // Values for SipTransportSession.sip_message_direction
    public static final int SIP_TRANSPORT_SESSION__SIP_MESSAGE_DIRECTION__UNKNOWN = 0;
    public static final int SIP_TRANSPORT_SESSION__SIP_MESSAGE_DIRECTION__INCOMING = 1;
    public static final int SIP_TRANSPORT_SESSION__SIP_MESSAGE_DIRECTION__OUTGOING = 2;

    // Values for ImsDedicatedBearerListenerEvent.rat_at_end
    public static final int IMS_DEDICATED_BEARER_LISTENER_EVENT__RAT_AT_END__NETWORK_TYPE_UNKNOWN = 0;
    public static final int IMS_DEDICATED_BEARER_LISTENER_EVENT__RAT_AT_END__NETWORK_TYPE_GPRS = 1;
    public static final int IMS_DEDICATED_BEARER_LISTENER_EVENT__RAT_AT_END__NETWORK_TYPE_EDGE = 2;
    public static final int IMS_DEDICATED_BEARER_LISTENER_EVENT__RAT_AT_END__NETWORK_TYPE_UMTS = 3;
    public static final int IMS_DEDICATED_BEARER_LISTENER_EVENT__RAT_AT_END__NETWORK_TYPE_CDMA = 4;
    public static final int IMS_DEDICATED_BEARER_LISTENER_EVENT__RAT_AT_END__NETWORK_TYPE_EVDO_0 = 5;
    public static final int IMS_DEDICATED_BEARER_LISTENER_EVENT__RAT_AT_END__NETWORK_TYPE_EVDO_A = 6;
    public static final int IMS_DEDICATED_BEARER_LISTENER_EVENT__RAT_AT_END__NETWORK_TYPE_1XRTT = 7;
    public static final int IMS_DEDICATED_BEARER_LISTENER_EVENT__RAT_AT_END__NETWORK_TYPE_HSDPA = 8;
    public static final int IMS_DEDICATED_BEARER_LISTENER_EVENT__RAT_AT_END__NETWORK_TYPE_HSUPA = 9;
    public static final int IMS_DEDICATED_BEARER_LISTENER_EVENT__RAT_AT_END__NETWORK_TYPE_HSPA = 10;
    public static final int IMS_DEDICATED_BEARER_LISTENER_EVENT__RAT_AT_END__NETWORK_TYPE_IDEN = 11;
    public static final int IMS_DEDICATED_BEARER_LISTENER_EVENT__RAT_AT_END__NETWORK_TYPE_EVDO_B = 12;
    public static final int IMS_DEDICATED_BEARER_LISTENER_EVENT__RAT_AT_END__NETWORK_TYPE_LTE = 13;
    public static final int IMS_DEDICATED_BEARER_LISTENER_EVENT__RAT_AT_END__NETWORK_TYPE_EHRPD = 14;
    public static final int IMS_DEDICATED_BEARER_LISTENER_EVENT__RAT_AT_END__NETWORK_TYPE_HSPAP = 15;
    public static final int IMS_DEDICATED_BEARER_LISTENER_EVENT__RAT_AT_END__NETWORK_TYPE_GSM = 16;
    public static final int IMS_DEDICATED_BEARER_LISTENER_EVENT__RAT_AT_END__NETWORK_TYPE_TD_SCDMA = 17;
    public static final int IMS_DEDICATED_BEARER_LISTENER_EVENT__RAT_AT_END__NETWORK_TYPE_IWLAN = 18;
    public static final int IMS_DEDICATED_BEARER_LISTENER_EVENT__RAT_AT_END__NETWORK_TYPE_LTE_CA = 19;
    public static final int IMS_DEDICATED_BEARER_LISTENER_EVENT__RAT_AT_END__NETWORK_TYPE_NR = 20;

    // Values for ImsDedicatedBearerEvent.rat_at_end
    public static final int IMS_DEDICATED_BEARER_EVENT__RAT_AT_END__NETWORK_TYPE_UNKNOWN = 0;
    public static final int IMS_DEDICATED_BEARER_EVENT__RAT_AT_END__NETWORK_TYPE_GPRS = 1;
    public static final int IMS_DEDICATED_BEARER_EVENT__RAT_AT_END__NETWORK_TYPE_EDGE = 2;
    public static final int IMS_DEDICATED_BEARER_EVENT__RAT_AT_END__NETWORK_TYPE_UMTS = 3;
    public static final int IMS_DEDICATED_BEARER_EVENT__RAT_AT_END__NETWORK_TYPE_CDMA = 4;
    public static final int IMS_DEDICATED_BEARER_EVENT__RAT_AT_END__NETWORK_TYPE_EVDO_0 = 5;
    public static final int IMS_DEDICATED_BEARER_EVENT__RAT_AT_END__NETWORK_TYPE_EVDO_A = 6;
    public static final int IMS_DEDICATED_BEARER_EVENT__RAT_AT_END__NETWORK_TYPE_1XRTT = 7;
    public static final int IMS_DEDICATED_BEARER_EVENT__RAT_AT_END__NETWORK_TYPE_HSDPA = 8;
    public static final int IMS_DEDICATED_BEARER_EVENT__RAT_AT_END__NETWORK_TYPE_HSUPA = 9;
    public static final int IMS_DEDICATED_BEARER_EVENT__RAT_AT_END__NETWORK_TYPE_HSPA = 10;
    public static final int IMS_DEDICATED_BEARER_EVENT__RAT_AT_END__NETWORK_TYPE_IDEN = 11;
    public static final int IMS_DEDICATED_BEARER_EVENT__RAT_AT_END__NETWORK_TYPE_EVDO_B = 12;
    public static final int IMS_DEDICATED_BEARER_EVENT__RAT_AT_END__NETWORK_TYPE_LTE = 13;
    public static final int IMS_DEDICATED_BEARER_EVENT__RAT_AT_END__NETWORK_TYPE_EHRPD = 14;
    public static final int IMS_DEDICATED_BEARER_EVENT__RAT_AT_END__NETWORK_TYPE_HSPAP = 15;
    public static final int IMS_DEDICATED_BEARER_EVENT__RAT_AT_END__NETWORK_TYPE_GSM = 16;
    public static final int IMS_DEDICATED_BEARER_EVENT__RAT_AT_END__NETWORK_TYPE_TD_SCDMA = 17;
    public static final int IMS_DEDICATED_BEARER_EVENT__RAT_AT_END__NETWORK_TYPE_IWLAN = 18;
    public static final int IMS_DEDICATED_BEARER_EVENT__RAT_AT_END__NETWORK_TYPE_LTE_CA = 19;
    public static final int IMS_DEDICATED_BEARER_EVENT__RAT_AT_END__NETWORK_TYPE_NR = 20;

    // Values for ImsDedicatedBearerEvent.bearer_state
    public static final int IMS_DEDICATED_BEARER_EVENT__BEARER_STATE__STATE_UNSPECIFIED = 0;
    public static final int IMS_DEDICATED_BEARER_EVENT__BEARER_STATE__STATE_ADDED = 1;
    public static final int IMS_DEDICATED_BEARER_EVENT__BEARER_STATE__STATE_MODIFIED = 2;
    public static final int IMS_DEDICATED_BEARER_EVENT__BEARER_STATE__STATE_DELETED = 3;

    // Values for ImsRegistrationServiceDescStats.service_id_name
    public static final int IMS_REGISTRATION_SERVICE_DESC_STATS__SERVICE_ID_NAME__SERVICE_ID_UNSPECIFIED = 0;
    public static final int IMS_REGISTRATION_SERVICE_DESC_STATS__SERVICE_ID_NAME__SERVICE_ID_CUSTOM = 1;
    public static final int IMS_REGISTRATION_SERVICE_DESC_STATS__SERVICE_ID_NAME__SERVICE_ID_MMTEL = 2;
    public static final int IMS_REGISTRATION_SERVICE_DESC_STATS__SERVICE_ID_NAME__SERVICE_ID_CHAT_V1 = 3;
    public static final int IMS_REGISTRATION_SERVICE_DESC_STATS__SERVICE_ID_NAME__SERVICE_ID_CHAT_V2 = 4;
    public static final int IMS_REGISTRATION_SERVICE_DESC_STATS__SERVICE_ID_NAME__SERVICE_ID_FT = 5;
    public static final int IMS_REGISTRATION_SERVICE_DESC_STATS__SERVICE_ID_NAME__SERVICE_ID_FT_OVER_SMS = 6;
    public static final int IMS_REGISTRATION_SERVICE_DESC_STATS__SERVICE_ID_NAME__SERVICE_ID_GEO_PUSH = 7;
    public static final int IMS_REGISTRATION_SERVICE_DESC_STATS__SERVICE_ID_NAME__SERVICE_ID_GEO_PUSH_VIA_SMS = 8;
    public static final int IMS_REGISTRATION_SERVICE_DESC_STATS__SERVICE_ID_NAME__SERVICE_ID_CALL_COMPOSER = 9;
    public static final int IMS_REGISTRATION_SERVICE_DESC_STATS__SERVICE_ID_NAME__SERVICE_ID_POST_CALL = 10;
    public static final int IMS_REGISTRATION_SERVICE_DESC_STATS__SERVICE_ID_NAME__SERVICE_ID_SHARED_MAP = 11;
    public static final int IMS_REGISTRATION_SERVICE_DESC_STATS__SERVICE_ID_NAME__SERVICE_ID_SHARED_SKETCH = 12;
    public static final int IMS_REGISTRATION_SERVICE_DESC_STATS__SERVICE_ID_NAME__SERVICE_ID_CHATBOT = 13;
    public static final int IMS_REGISTRATION_SERVICE_DESC_STATS__SERVICE_ID_NAME__SERVICE_ID_CHATBOT_STANDALONE = 14;
    public static final int IMS_REGISTRATION_SERVICE_DESC_STATS__SERVICE_ID_NAME__SERVICE_ID_CHATBOT_ROLE = 15;

    // Values for UceEventStats.type
    public static final int UCE_EVENT_STATS__TYPE__MESSAGE_TYPE_UNSPECIFIED = 0;
    public static final int UCE_EVENT_STATS__TYPE__PUBLISH = 1;
    public static final int UCE_EVENT_STATS__TYPE__SUBSCRIBE = 2;
    public static final int UCE_EVENT_STATS__TYPE__INCOMING_OPTION = 3;
    public static final int UCE_EVENT_STATS__TYPE__OUTGOING_OPTION = 4;

    // Values for UceEventStats.command_code
    public static final int UCE_EVENT_STATS__COMMAND_CODE__SERVICE_UNKNOWN = 0;
    public static final int UCE_EVENT_STATS__COMMAND_CODE__GENERIC_FAILURE = 1;
    public static final int UCE_EVENT_STATS__COMMAND_CODE__INVALID_PARAM = 2;
    public static final int UCE_EVENT_STATS__COMMAND_CODE__FETCH_ERROR = 3;
    public static final int UCE_EVENT_STATS__COMMAND_CODE__REQUEST_TIMEOUT = 4;
    public static final int UCE_EVENT_STATS__COMMAND_CODE__INSUFFICIENT_MEMORY = 5;
    public static final int UCE_EVENT_STATS__COMMAND_CODE__LOST_NETWORK_CONNECTION = 6;
    public static final int UCE_EVENT_STATS__COMMAND_CODE__NOT_SUPPORTED = 7;
    public static final int UCE_EVENT_STATS__COMMAND_CODE__NOT_FOUND = 8;
    public static final int UCE_EVENT_STATS__COMMAND_CODE__SERVICE_UNAVAILABLE = 9;
    public static final int UCE_EVENT_STATS__COMMAND_CODE__NO_CHANGE = 10;

    // Values for PresenceNotifyEvent.reason
    public static final int PRESENCE_NOTIFY_EVENT__REASON__REASON_UNSPECIFIED = 0;
    public static final int PRESENCE_NOTIFY_EVENT__REASON__REASON_CUSTOM = 1;
    public static final int PRESENCE_NOTIFY_EVENT__REASON__REASON_DEACTIVATED = 2;
    public static final int PRESENCE_NOTIFY_EVENT__REASON__REASON_PROBATION = 3;
    public static final int PRESENCE_NOTIFY_EVENT__REASON__REASON_REJECTED = 4;
    public static final int PRESENCE_NOTIFY_EVENT__REASON__REASON_TIMEOUT = 5;
    public static final int PRESENCE_NOTIFY_EVENT__REASON__REASON_GIVEUP = 6;
    public static final int PRESENCE_NOTIFY_EVENT__REASON__REASON_NORESOURCE = 7;

    // Values for GbaEvent.failed_reason
    public static final int GBA_EVENT__FAILED_REASON__UNKNOWN = 0;
    public static final int GBA_EVENT__FAILED_REASON__FEATURE_NOT_SUPPORTED = 1;
    public static final int GBA_EVENT__FAILED_REASON__FEATURE_NOT_READY = 2;
    public static final int GBA_EVENT__FAILED_REASON__NETWORK_FAILURE = 3;
    public static final int GBA_EVENT__FAILED_REASON__INCORRECT_NAF_ID = 4;
    public static final int GBA_EVENT__FAILED_REASON__SECURITY_PROTOCOL_NOT_SUPPORTED = 5;

    // Values for PerSimStatus.wfc_mode
    public static final int PER_SIM_STATUS__WFC_MODE__UNKNOWN = 0;
    public static final int PER_SIM_STATUS__WFC_MODE__WIFI_ONLY = 1;
    public static final int PER_SIM_STATUS__WFC_MODE__CELLULAR_PREFERRED = 2;
    public static final int PER_SIM_STATUS__WFC_MODE__WIFI_PREFERRED = 3;

    // Values for PerSimStatus.wfc_roaming_mode
    public static final int PER_SIM_STATUS__WFC_ROAMING_MODE__UNKNOWN = 0;
    public static final int PER_SIM_STATUS__WFC_ROAMING_MODE__WIFI_ONLY = 1;
    public static final int PER_SIM_STATUS__WFC_ROAMING_MODE__CELLULAR_PREFERRED = 2;
    public static final int PER_SIM_STATUS__WFC_ROAMING_MODE__WIFI_PREFERRED = 3;

    // Values for PerSimStatus.sim_voltage_class
    public static final int PER_SIM_STATUS__SIM_VOLTAGE_CLASS__VOLTAGE_CLASS_UNKNOWN = 0;
    public static final int PER_SIM_STATUS__SIM_VOLTAGE_CLASS__VOLTAGE_CLASS_A = 1;
    public static final int PER_SIM_STATUS__SIM_VOLTAGE_CLASS__VOLTAGE_CLASS_B = 2;
    public static final int PER_SIM_STATUS__SIM_VOLTAGE_CLASS__VOLTAGE_CLASS_C = 3;

    // Values for TelephonyNetworkRequestsV2.capability
    public static final int TELEPHONY_NETWORK_REQUESTS_V2__CAPABILITY__UNKNOWN = 0;
    public static final int TELEPHONY_NETWORK_REQUESTS_V2__CAPABILITY__PRIORITIZE_LATENCY = 1;
    public static final int TELEPHONY_NETWORK_REQUESTS_V2__CAPABILITY__PRIORITIZE_BANDWIDTH = 2;
    public static final int TELEPHONY_NETWORK_REQUESTS_V2__CAPABILITY__CBS = 3;
    public static final int TELEPHONY_NETWORK_REQUESTS_V2__CAPABILITY__ENTERPRISE = 4;

    // Values for OutgoingShortCodeSms.category
    public static final int OUTGOING_SHORT_CODE_SMS__CATEGORY__SMS_CATEGORY_NOT_SHORT_CODE = 0;
    public static final int OUTGOING_SHORT_CODE_SMS__CATEGORY__SMS_CATEGORY_FREE_SHORT_CODE = 1;
    public static final int OUTGOING_SHORT_CODE_SMS__CATEGORY__SMS_CATEGORY_STANDARD_SHORT_CODE = 2;
    public static final int OUTGOING_SHORT_CODE_SMS__CATEGORY__SMS_CATEGORY_POSSIBLE_PREMIUM_SHORT_CODE = 3;
    public static final int OUTGOING_SHORT_CODE_SMS__CATEGORY__SMS_CATEGORY_PREMIUM_SHORT_CODE = 4;

    // Values for EmergencyNumbersInfo.route
    public static final int EMERGENCY_NUMBERS_INFO__ROUTE__EMERGENCY_CALL_ROUTE_UNKNOWN = 0;
    public static final int EMERGENCY_NUMBERS_INFO__ROUTE__EMERGENCY_CALL_ROUTE_EMERGENCY = 1;
    public static final int EMERGENCY_NUMBERS_INFO__ROUTE__EMERGENCY_CALL_ROUTE_NORMAL = 2;

    // Values for EmergencyNumbersInfo.service_categories
    public static final int EMERGENCY_NUMBERS_INFO__SERVICE_CATEGORIES__EMERGENCY_SERVICE_CATEGORY_UNSPECIFIED = 0;
    public static final int EMERGENCY_NUMBERS_INFO__SERVICE_CATEGORIES__EMERGENCY_SERVICE_CATEGORY_POLICE = 1;
    public static final int EMERGENCY_NUMBERS_INFO__SERVICE_CATEGORIES__EMERGENCY_SERVICE_CATEGORY_AMBULANCE = 2;
    public static final int EMERGENCY_NUMBERS_INFO__SERVICE_CATEGORIES__EMERGENCY_SERVICE_CATEGORY_FIRE_BRIGADE = 3;
    public static final int EMERGENCY_NUMBERS_INFO__SERVICE_CATEGORIES__EMERGENCY_SERVICE_CATEGORY_MARINE_GUARD = 4;
    public static final int EMERGENCY_NUMBERS_INFO__SERVICE_CATEGORIES__EMERGENCY_SERVICE_CATEGORY_MOUNTAIN_RESCUE = 5;
    public static final int EMERGENCY_NUMBERS_INFO__SERVICE_CATEGORIES__EMERGENCY_SERVICE_CATEGORY_MIEC = 6;
    public static final int EMERGENCY_NUMBERS_INFO__SERVICE_CATEGORIES__EMERGENCY_SERVICE_CATEGORY_AIEC = 7;

    // Values for EmergencyNumbersInfo.sources
    public static final int EMERGENCY_NUMBERS_INFO__SOURCES__EMERGENCY_NUMBER_SOURCE_NETWORK_SIGNALING = 0;
    public static final int EMERGENCY_NUMBERS_INFO__SOURCES__EMERGENCY_NUMBER_SOURCE_SIM = 1;
    public static final int EMERGENCY_NUMBERS_INFO__SOURCES__EMERGENCY_NUMBER_SOURCE_DATABASE = 2;
    public static final int EMERGENCY_NUMBERS_INFO__SOURCES__EMERGENCY_NUMBER_SOURCE_MODEM_CONFIG = 3;
    public static final int EMERGENCY_NUMBERS_INFO__SOURCES__EMERGENCY_NUMBER_SOURCE_DEFAULT = 4;

    // Values for SatelliteSession.satellite_service_initialization_result
    public static final int SATELLITE_SESSION__SATELLITE_SERVICE_INITIALIZATION_RESULT__SATELLITE_ERROR_NONE = 0;
    public static final int SATELLITE_SESSION__SATELLITE_SERVICE_INITIALIZATION_RESULT__SATELLITE_ERROR = 1;
    public static final int SATELLITE_SESSION__SATELLITE_SERVICE_INITIALIZATION_RESULT__SATELLITE_SERVER_ERROR = 2;
    public static final int SATELLITE_SESSION__SATELLITE_SERVICE_INITIALIZATION_RESULT__SATELLITE_SERVICE_ERROR = 3;
    public static final int SATELLITE_SESSION__SATELLITE_SERVICE_INITIALIZATION_RESULT__SATELLITE_MODEM_ERROR = 4;
    public static final int SATELLITE_SESSION__SATELLITE_SERVICE_INITIALIZATION_RESULT__SATELLITE_NETWORK_ERROR = 5;
    public static final int SATELLITE_SESSION__SATELLITE_SERVICE_INITIALIZATION_RESULT__SATELLITE_INVALID_TELEPHONY_STATE = 6;
    public static final int SATELLITE_SESSION__SATELLITE_SERVICE_INITIALIZATION_RESULT__SATELLITE_INVALID_MODEM_STATE = 7;
    public static final int SATELLITE_SESSION__SATELLITE_SERVICE_INITIALIZATION_RESULT__SATELLITE_INVALID_ARGUMENTS = 8;
    public static final int SATELLITE_SESSION__SATELLITE_SERVICE_INITIALIZATION_RESULT__SATELLITE_REQUEST_FAILED = 9;
    public static final int SATELLITE_SESSION__SATELLITE_SERVICE_INITIALIZATION_RESULT__SATELLITE_RADIO_NOT_AVAILABLE = 10;
    public static final int SATELLITE_SESSION__SATELLITE_SERVICE_INITIALIZATION_RESULT__SATELLITE_REQUEST_NOT_SUPPORTED = 11;
    public static final int SATELLITE_SESSION__SATELLITE_SERVICE_INITIALIZATION_RESULT__SATELLITE_NO_RESOURCES = 12;
    public static final int SATELLITE_SESSION__SATELLITE_SERVICE_INITIALIZATION_RESULT__SATELLITE_SERVICE_NOT_PROVISIONED = 13;
    public static final int SATELLITE_SESSION__SATELLITE_SERVICE_INITIALIZATION_RESULT__SATELLITE_SERVICE_PROVISION_IN_PROGRESS = 14;
    public static final int SATELLITE_SESSION__SATELLITE_SERVICE_INITIALIZATION_RESULT__SATELLITE_REQUEST_ABORTED = 15;
    public static final int SATELLITE_SESSION__SATELLITE_SERVICE_INITIALIZATION_RESULT__SATELLITE_ACCESS_BARRED = 16;
    public static final int SATELLITE_SESSION__SATELLITE_SERVICE_INITIALIZATION_RESULT__SATELLITE_NETWORK_TIMEOUT = 17;
    public static final int SATELLITE_SESSION__SATELLITE_SERVICE_INITIALIZATION_RESULT__SATELLITE_NOT_REACHABLE = 18;
    public static final int SATELLITE_SESSION__SATELLITE_SERVICE_INITIALIZATION_RESULT__SATELLITE_NOT_AUTHORIZED = 19;
    public static final int SATELLITE_SESSION__SATELLITE_SERVICE_INITIALIZATION_RESULT__SATELLITE_NOT_SUPPORTED = 20;

    // Values for SatelliteSession.satellite_technology
    public static final int SATELLITE_SESSION__SATELLITE_TECHNOLOGY__NT_RADIO_TECHNOLOGY_UNKNOWN = 0;
    public static final int SATELLITE_SESSION__SATELLITE_TECHNOLOGY__NT_RADIO_TECHNOLOGY_NB_IOT_NTN = 1;
    public static final int SATELLITE_SESSION__SATELLITE_TECHNOLOGY__NT_RADIO_TECHNOLOGY_NR_NTN = 2;
    public static final int SATELLITE_SESSION__SATELLITE_TECHNOLOGY__NT_RADIO_TECHNOLOGY_EMTC_NTN = 3;
    public static final int SATELLITE_SESSION__SATELLITE_TECHNOLOGY__NT_RADIO_TECHNOLOGY_PROPRIETARY = 4;

    // Values for SatelliteIncomingDatagram.result_code
    public static final int SATELLITE_INCOMING_DATAGRAM__RESULT_CODE__SATELLITE_ERROR_NONE = 0;
    public static final int SATELLITE_INCOMING_DATAGRAM__RESULT_CODE__SATELLITE_ERROR = 1;
    public static final int SATELLITE_INCOMING_DATAGRAM__RESULT_CODE__SATELLITE_SERVER_ERROR = 2;
    public static final int SATELLITE_INCOMING_DATAGRAM__RESULT_CODE__SATELLITE_SERVICE_ERROR = 3;
    public static final int SATELLITE_INCOMING_DATAGRAM__RESULT_CODE__SATELLITE_MODEM_ERROR = 4;
    public static final int SATELLITE_INCOMING_DATAGRAM__RESULT_CODE__SATELLITE_NETWORK_ERROR = 5;
    public static final int SATELLITE_INCOMING_DATAGRAM__RESULT_CODE__SATELLITE_INVALID_TELEPHONY_STATE = 6;
    public static final int SATELLITE_INCOMING_DATAGRAM__RESULT_CODE__SATELLITE_INVALID_MODEM_STATE = 7;
    public static final int SATELLITE_INCOMING_DATAGRAM__RESULT_CODE__SATELLITE_INVALID_ARGUMENTS = 8;
    public static final int SATELLITE_INCOMING_DATAGRAM__RESULT_CODE__SATELLITE_REQUEST_FAILED = 9;
    public static final int SATELLITE_INCOMING_DATAGRAM__RESULT_CODE__SATELLITE_RADIO_NOT_AVAILABLE = 10;
    public static final int SATELLITE_INCOMING_DATAGRAM__RESULT_CODE__SATELLITE_REQUEST_NOT_SUPPORTED = 11;
    public static final int SATELLITE_INCOMING_DATAGRAM__RESULT_CODE__SATELLITE_NO_RESOURCES = 12;
    public static final int SATELLITE_INCOMING_DATAGRAM__RESULT_CODE__SATELLITE_SERVICE_NOT_PROVISIONED = 13;
    public static final int SATELLITE_INCOMING_DATAGRAM__RESULT_CODE__SATELLITE_SERVICE_PROVISION_IN_PROGRESS = 14;
    public static final int SATELLITE_INCOMING_DATAGRAM__RESULT_CODE__SATELLITE_REQUEST_ABORTED = 15;
    public static final int SATELLITE_INCOMING_DATAGRAM__RESULT_CODE__SATELLITE_ACCESS_BARRED = 16;
    public static final int SATELLITE_INCOMING_DATAGRAM__RESULT_CODE__SATELLITE_NETWORK_TIMEOUT = 17;
    public static final int SATELLITE_INCOMING_DATAGRAM__RESULT_CODE__SATELLITE_NOT_REACHABLE = 18;
    public static final int SATELLITE_INCOMING_DATAGRAM__RESULT_CODE__SATELLITE_NOT_AUTHORIZED = 19;
    public static final int SATELLITE_INCOMING_DATAGRAM__RESULT_CODE__SATELLITE_NOT_SUPPORTED = 20;

    // Values for SatelliteOutgoingDatagram.satellite_datagram_type
    public static final int SATELLITE_OUTGOING_DATAGRAM__SATELLITE_DATAGRAM_TYPE__DATAGRAM_TYPE_UNKNOWN = 0;
    public static final int SATELLITE_OUTGOING_DATAGRAM__SATELLITE_DATAGRAM_TYPE__DATAGRAM_TYPE_SOS_MESSAGE = 1;
    public static final int SATELLITE_OUTGOING_DATAGRAM__SATELLITE_DATAGRAM_TYPE__DATAGRAM_TYPE_LOCATION_SHARING = 2;

    // Values for SatelliteOutgoingDatagram.result_code
    public static final int SATELLITE_OUTGOING_DATAGRAM__RESULT_CODE__SATELLITE_ERROR_NONE = 0;
    public static final int SATELLITE_OUTGOING_DATAGRAM__RESULT_CODE__SATELLITE_ERROR = 1;
    public static final int SATELLITE_OUTGOING_DATAGRAM__RESULT_CODE__SATELLITE_SERVER_ERROR = 2;
    public static final int SATELLITE_OUTGOING_DATAGRAM__RESULT_CODE__SATELLITE_SERVICE_ERROR = 3;
    public static final int SATELLITE_OUTGOING_DATAGRAM__RESULT_CODE__SATELLITE_MODEM_ERROR = 4;
    public static final int SATELLITE_OUTGOING_DATAGRAM__RESULT_CODE__SATELLITE_NETWORK_ERROR = 5;
    public static final int SATELLITE_OUTGOING_DATAGRAM__RESULT_CODE__SATELLITE_INVALID_TELEPHONY_STATE = 6;
    public static final int SATELLITE_OUTGOING_DATAGRAM__RESULT_CODE__SATELLITE_INVALID_MODEM_STATE = 7;
    public static final int SATELLITE_OUTGOING_DATAGRAM__RESULT_CODE__SATELLITE_INVALID_ARGUMENTS = 8;
    public static final int SATELLITE_OUTGOING_DATAGRAM__RESULT_CODE__SATELLITE_REQUEST_FAILED = 9;
    public static final int SATELLITE_OUTGOING_DATAGRAM__RESULT_CODE__SATELLITE_RADIO_NOT_AVAILABLE = 10;
    public static final int SATELLITE_OUTGOING_DATAGRAM__RESULT_CODE__SATELLITE_REQUEST_NOT_SUPPORTED = 11;
    public static final int SATELLITE_OUTGOING_DATAGRAM__RESULT_CODE__SATELLITE_NO_RESOURCES = 12;
    public static final int SATELLITE_OUTGOING_DATAGRAM__RESULT_CODE__SATELLITE_SERVICE_NOT_PROVISIONED = 13;
    public static final int SATELLITE_OUTGOING_DATAGRAM__RESULT_CODE__SATELLITE_SERVICE_PROVISION_IN_PROGRESS = 14;
    public static final int SATELLITE_OUTGOING_DATAGRAM__RESULT_CODE__SATELLITE_REQUEST_ABORTED = 15;
    public static final int SATELLITE_OUTGOING_DATAGRAM__RESULT_CODE__SATELLITE_ACCESS_BARRED = 16;
    public static final int SATELLITE_OUTGOING_DATAGRAM__RESULT_CODE__SATELLITE_NETWORK_TIMEOUT = 17;
    public static final int SATELLITE_OUTGOING_DATAGRAM__RESULT_CODE__SATELLITE_NOT_REACHABLE = 18;
    public static final int SATELLITE_OUTGOING_DATAGRAM__RESULT_CODE__SATELLITE_NOT_AUTHORIZED = 19;
    public static final int SATELLITE_OUTGOING_DATAGRAM__RESULT_CODE__SATELLITE_NOT_SUPPORTED = 20;

    // Values for SatelliteProvision.result_code
    public static final int SATELLITE_PROVISION__RESULT_CODE__SATELLITE_ERROR_NONE = 0;
    public static final int SATELLITE_PROVISION__RESULT_CODE__SATELLITE_ERROR = 1;
    public static final int SATELLITE_PROVISION__RESULT_CODE__SATELLITE_SERVER_ERROR = 2;
    public static final int SATELLITE_PROVISION__RESULT_CODE__SATELLITE_SERVICE_ERROR = 3;
    public static final int SATELLITE_PROVISION__RESULT_CODE__SATELLITE_MODEM_ERROR = 4;
    public static final int SATELLITE_PROVISION__RESULT_CODE__SATELLITE_NETWORK_ERROR = 5;
    public static final int SATELLITE_PROVISION__RESULT_CODE__SATELLITE_INVALID_TELEPHONY_STATE = 6;
    public static final int SATELLITE_PROVISION__RESULT_CODE__SATELLITE_INVALID_MODEM_STATE = 7;
    public static final int SATELLITE_PROVISION__RESULT_CODE__SATELLITE_INVALID_ARGUMENTS = 8;
    public static final int SATELLITE_PROVISION__RESULT_CODE__SATELLITE_REQUEST_FAILED = 9;
    public static final int SATELLITE_PROVISION__RESULT_CODE__SATELLITE_RADIO_NOT_AVAILABLE = 10;
    public static final int SATELLITE_PROVISION__RESULT_CODE__SATELLITE_REQUEST_NOT_SUPPORTED = 11;
    public static final int SATELLITE_PROVISION__RESULT_CODE__SATELLITE_NO_RESOURCES = 12;
    public static final int SATELLITE_PROVISION__RESULT_CODE__SATELLITE_SERVICE_NOT_PROVISIONED = 13;
    public static final int SATELLITE_PROVISION__RESULT_CODE__SATELLITE_SERVICE_PROVISION_IN_PROGRESS = 14;
    public static final int SATELLITE_PROVISION__RESULT_CODE__SATELLITE_REQUEST_ABORTED = 15;
    public static final int SATELLITE_PROVISION__RESULT_CODE__SATELLITE_ACCESS_BARRED = 16;
    public static final int SATELLITE_PROVISION__RESULT_CODE__SATELLITE_NETWORK_TIMEOUT = 17;
    public static final int SATELLITE_PROVISION__RESULT_CODE__SATELLITE_NOT_REACHABLE = 18;
    public static final int SATELLITE_PROVISION__RESULT_CODE__SATELLITE_NOT_AUTHORIZED = 19;
    public static final int SATELLITE_PROVISION__RESULT_CODE__SATELLITE_NOT_SUPPORTED = 20;

    // Values for SatelliteSosMessageRecommender.cellular_service_state
    public static final int SATELLITE_SOS_MESSAGE_RECOMMENDER__CELLULAR_SERVICE_STATE__SERVICE_STATE_IN_SERVICE = 0;
    public static final int SATELLITE_SOS_MESSAGE_RECOMMENDER__CELLULAR_SERVICE_STATE__SERVICE_STATE_OUT_OF_SERVICE = 1;
    public static final int SATELLITE_SOS_MESSAGE_RECOMMENDER__CELLULAR_SERVICE_STATE__SERVICE_STATE_EMERGENCY_ONLY = 2;
    public static final int SATELLITE_SOS_MESSAGE_RECOMMENDER__CELLULAR_SERVICE_STATE__SERVICE_STATE_POWER_OFF = 3;

    // Annotation constants.
    public static final byte ANNOTATION_ID_IS_UID = StatsLog.ANNOTATION_ID_IS_UID;
    public static final byte ANNOTATION_ID_TRUNCATE_TIMESTAMP = StatsLog.ANNOTATION_ID_TRUNCATE_TIMESTAMP;
    public static final byte ANNOTATION_ID_PRIMARY_FIELD = StatsLog.ANNOTATION_ID_PRIMARY_FIELD;
    public static final byte ANNOTATION_ID_EXCLUSIVE_STATE = StatsLog.ANNOTATION_ID_EXCLUSIVE_STATE;
    public static final byte ANNOTATION_ID_PRIMARY_FIELD_FIRST_UID = StatsLog.ANNOTATION_ID_PRIMARY_FIELD_FIRST_UID;
    public static final byte ANNOTATION_ID_DEFAULT_STATE = StatsLog.ANNOTATION_ID_DEFAULT_STATE;
    public static final byte ANNOTATION_ID_TRIGGER_STATE_RESET = StatsLog.ANNOTATION_ID_TRIGGER_STATE_RESET;
    public static final byte ANNOTATION_ID_STATE_NESTED = StatsLog.ANNOTATION_ID_STATE_NESTED;

    // Write methods
    public static void write(int code, boolean arg1, boolean arg2, int arg3) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeBoolean(arg1);
        builder.writeBoolean(arg2);
        builder.writeInt(arg3);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, int arg2) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeInt(arg2);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, int arg2, int arg3) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeInt(arg2);
        builder.writeInt(arg3);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, int arg2, int arg3, int arg4) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeInt(arg2);
        builder.writeInt(arg3);
        builder.writeInt(arg4);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, int arg2, int arg3, int arg4, boolean arg5, boolean arg6, int arg7, boolean arg8, int arg9, int arg10, int arg11, int arg12, int arg13, boolean arg14, int arg15, int arg16) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeInt(arg2);
        builder.writeInt(arg3);
        builder.writeInt(arg4);
        builder.writeBoolean(arg5);
        builder.writeBoolean(arg6);
        builder.writeInt(arg7);
        builder.writeBoolean(arg8);
        builder.writeInt(arg9);
        builder.writeInt(arg10);
        builder.writeInt(arg11);
        builder.writeInt(arg12);
        builder.writeInt(arg13);
        builder.writeBoolean(arg14);
        builder.writeInt(arg15);
        builder.writeInt(arg16);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, int arg2, int arg3, long arg4, boolean arg5) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeInt(arg2);
        builder.writeInt(arg3);
        builder.writeLong(arg4);
        builder.writeBoolean(arg5);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, int arg2, java.lang.String arg3) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeInt(arg2);
        builder.writeString(arg3);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, long arg2, long arg3) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeLong(arg2);
        builder.writeLong(arg3);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, java.lang.String arg2, java.lang.String arg3, java.lang.String arg4, java.lang.String arg5) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeString(arg2);
        builder.writeString(arg3);
        builder.writeString(arg4);
        builder.writeString(arg5);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, java.lang.String arg1, java.lang.String arg2, int arg3) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeString(arg1);
        builder.writeString(arg2);
        builder.writeInt(arg3);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static StatsEvent buildStatsEvent(int code, boolean arg1, boolean arg2, int arg3, boolean arg4) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeBoolean(arg1);
        builder.writeBoolean(arg2);
        builder.writeInt(arg3);
        builder.writeBoolean(arg4);

        return builder.build();
    }

    public static StatsEvent buildStatsEvent(int code, boolean arg1, int arg2, boolean arg3, int arg4, int arg5) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeBoolean(arg1);
        builder.writeInt(arg2);
        builder.writeBoolean(arg3);
        builder.writeInt(arg4);
        builder.writeInt(arg5);

        return builder.build();
    }

    public static StatsEvent buildStatsEvent(int code, boolean arg1, int arg2, int arg3, java.lang.String arg4, java.lang.String arg5, java.lang.String arg6, int arg7, java.lang.String[] arg8, int[] arg9, int[] arg10) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeBoolean(arg1);
        builder.writeInt(arg2);
        builder.writeInt(arg3);
        builder.writeString(arg4);
        builder.writeString(arg5);
        builder.writeString(arg6);
        builder.writeInt(arg7);
        builder.writeStringArray(null == arg8 ? new String[0] : arg8);
        builder.writeIntArray(null == arg9 ? new int[0] : arg9);
        builder.writeIntArray(null == arg10 ? new int[0] : arg10);

        return builder.build();
    }

    public static StatsEvent buildStatsEvent(int code, int arg1) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);

        return builder.build();
    }

    public static StatsEvent buildStatsEvent(int code, int arg1, boolean arg2, boolean arg3, int arg4, int arg5, int arg6, boolean arg7, int arg8, boolean arg9, long arg10, boolean arg11, int arg12, boolean arg13, int arg14, int arg15, int arg16, long arg17, boolean arg18, int arg19, int[] arg20, int[] arg21, boolean arg22) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeBoolean(arg2);
        builder.writeBoolean(arg3);
        builder.writeInt(arg4);
        builder.writeInt(arg5);
        builder.writeInt(arg6);
        builder.writeBoolean(arg7);
        builder.writeInt(arg8);
        builder.writeBoolean(arg9);
        builder.writeLong(arg10);
        builder.writeBoolean(arg11);
        builder.writeInt(arg12);
        builder.writeBoolean(arg13);
        builder.writeInt(arg14);
        builder.writeInt(arg15);
        builder.writeInt(arg16);
        builder.writeLong(arg17);
        builder.writeBoolean(arg18);
        builder.writeInt(arg19);
        builder.writeIntArray(null == arg20 ? new int[0] : arg20);
        builder.writeIntArray(null == arg21 ? new int[0] : arg21);
        builder.writeBoolean(arg22);

        return builder.build();
    }

    public static StatsEvent buildStatsEvent(int code, int arg1, boolean arg2, int arg3, boolean arg4, int arg5, int arg6, java.lang.String arg7, int arg8) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeBoolean(arg2);
        builder.writeInt(arg3);
        builder.writeBoolean(arg4);
        builder.writeInt(arg5);
        builder.writeInt(arg6);
        builder.writeString(arg7);
        builder.writeInt(arg8);

        return builder.build();
    }

    public static StatsEvent buildStatsEvent(int code, int arg1, int arg2, boolean arg3, boolean arg4) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeInt(arg2);
        builder.writeBoolean(arg3);
        builder.writeBoolean(arg4);

        return builder.build();
    }

    public static StatsEvent buildStatsEvent(int code, int arg1, int arg2, boolean arg3, int arg4, int arg5) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeInt(arg2);
        builder.writeBoolean(arg3);
        builder.writeInt(arg4);
        builder.writeInt(arg5);

        return builder.build();
    }

    public static StatsEvent buildStatsEvent(int code, int arg1, int arg2, int arg3) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeInt(arg2);
        builder.writeInt(arg3);

        return builder.build();
    }

    public static StatsEvent buildStatsEvent(int code, int arg1, int arg2, int arg3, boolean arg4, int arg5, int arg6) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeInt(arg2);
        builder.writeInt(arg3);
        builder.writeBoolean(arg4);
        builder.writeInt(arg5);
        builder.writeInt(arg6);

        return builder.build();
    }

    public static StatsEvent buildStatsEvent(int code, int arg1, int arg2, int arg3, boolean arg4, int arg5, int arg6, int arg7) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeInt(arg2);
        builder.writeInt(arg3);
        builder.writeBoolean(arg4);
        builder.writeInt(arg5);
        builder.writeInt(arg6);
        builder.writeInt(arg7);

        return builder.build();
    }

    public static StatsEvent buildStatsEvent(int code, int arg1, int arg2, int arg3, boolean arg4, int arg5, int arg6, int arg7, int arg8) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeInt(arg2);
        builder.writeInt(arg3);
        builder.writeBoolean(arg4);
        builder.writeInt(arg5);
        builder.writeInt(arg6);
        builder.writeInt(arg7);
        builder.writeInt(arg8);

        return builder.build();
    }

    public static StatsEvent buildStatsEvent(int code, int arg1, int arg2, int arg3, int arg4) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeInt(arg2);
        builder.writeInt(arg3);
        builder.writeInt(arg4);

        return builder.build();
    }

    public static StatsEvent buildStatsEvent(int code, int arg1, int arg2, int arg3, int arg4, boolean arg5, int arg6) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeInt(arg2);
        builder.writeInt(arg3);
        builder.writeInt(arg4);
        builder.writeBoolean(arg5);
        builder.writeInt(arg6);

        return builder.build();
    }

    public static StatsEvent buildStatsEvent(int code, int arg1, int arg2, int arg3, int arg4, boolean arg5, int arg6, boolean arg7, int arg8, int arg9, boolean arg10, boolean arg11, int arg12) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeInt(arg2);
        builder.writeInt(arg3);
        builder.writeInt(arg4);
        builder.writeBoolean(arg5);
        builder.writeInt(arg6);
        builder.writeBoolean(arg7);
        builder.writeInt(arg8);
        builder.writeInt(arg9);
        builder.writeBoolean(arg10);
        builder.writeBoolean(arg11);
        builder.writeInt(arg12);

        return builder.build();
    }

    public static StatsEvent buildStatsEvent(int code, int arg1, int arg2, int arg3, int arg4, boolean arg5, int arg6, int arg7) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeInt(arg2);
        builder.writeInt(arg3);
        builder.writeInt(arg4);
        builder.writeBoolean(arg5);
        builder.writeInt(arg6);
        builder.writeInt(arg7);

        return builder.build();
    }

    public static StatsEvent buildStatsEvent(int code, int arg1, int arg2, int arg3, int arg4, boolean arg5, int arg6, int arg7, java.lang.String arg8, int arg9, int arg10, long arg11, long arg12, int arg13, int arg14, int arg15, boolean arg16, boolean arg17, int arg18, boolean arg19, long arg20, long arg21, boolean arg22, boolean arg23, boolean arg24, int arg25, int arg26, int arg27, int arg28, int arg29, boolean arg30, int arg31, boolean arg32, int arg33, int arg34, int arg35) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeInt(arg2);
        builder.writeInt(arg3);
        builder.writeInt(arg4);
        builder.writeBoolean(arg5);
        builder.writeInt(arg6);
        builder.writeInt(arg7);
        builder.writeString(arg8);
        builder.writeInt(arg9);
        builder.writeInt(arg10);
        builder.writeLong(arg11);
        builder.writeLong(arg12);
        builder.writeInt(arg13);
        builder.writeInt(arg14);
        builder.writeInt(arg15);
        builder.writeBoolean(arg16);
        builder.writeBoolean(arg17);
        builder.writeInt(arg18);
        builder.writeBoolean(arg19);
        builder.writeLong(arg20);
        builder.writeLong(arg21);
        builder.writeBoolean(arg22);
        builder.writeBoolean(arg23);
        builder.writeBoolean(arg24);
        builder.writeInt(arg25);
        builder.writeInt(arg26);
        builder.writeInt(arg27);
        builder.writeInt(arg28);
        builder.writeInt(arg29);
        builder.writeBoolean(arg30);
        builder.writeInt(arg31);
        builder.writeBoolean(arg32);
        builder.writeInt(arg33);
        builder.writeInt(arg34);
        builder.writeInt(arg35);

        return builder.build();
    }

    public static StatsEvent buildStatsEvent(int code, int arg1, int arg2, int arg3, int arg4, int arg5) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeInt(arg2);
        builder.writeInt(arg3);
        builder.writeInt(arg4);
        builder.writeInt(arg5);

        return builder.build();
    }

    public static StatsEvent buildStatsEvent(int code, int arg1, int arg2, int arg3, int arg4, int arg5, boolean arg6, boolean arg7, boolean arg8, int arg9) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeInt(arg2);
        builder.writeInt(arg3);
        builder.writeInt(arg4);
        builder.writeInt(arg5);
        builder.writeBoolean(arg6);
        builder.writeBoolean(arg7);
        builder.writeBoolean(arg8);
        builder.writeInt(arg9);

        return builder.build();
    }

    public static StatsEvent buildStatsEvent(int code, int arg1, int arg2, int arg3, int arg4, int arg5, boolean arg6, boolean arg7, int arg8, boolean arg9, boolean arg10, int arg11, long arg12, int arg13, long arg14, int arg15, int arg16, int arg17, boolean arg18) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeInt(arg2);
        builder.writeInt(arg3);
        builder.writeInt(arg4);
        builder.writeInt(arg5);
        builder.writeBoolean(arg6);
        builder.writeBoolean(arg7);
        builder.writeInt(arg8);
        builder.writeBoolean(arg9);
        builder.writeBoolean(arg10);
        builder.writeInt(arg11);
        builder.writeLong(arg12);
        builder.writeInt(arg13);
        builder.writeLong(arg14);
        builder.writeInt(arg15);
        builder.writeInt(arg16);
        builder.writeInt(arg17);
        builder.writeBoolean(arg18);

        return builder.build();
    }

    public static StatsEvent buildStatsEvent(int code, int arg1, int arg2, int arg3, int arg4, int arg5, boolean arg6, boolean arg7, int arg8, int arg9, boolean arg10, boolean arg11, long arg12, boolean arg13, boolean arg14, int arg15, int arg16, long arg17, boolean arg18) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeInt(arg2);
        builder.writeInt(arg3);
        builder.writeInt(arg4);
        builder.writeInt(arg5);
        builder.writeBoolean(arg6);
        builder.writeBoolean(arg7);
        builder.writeInt(arg8);
        builder.writeInt(arg9);
        builder.writeBoolean(arg10);
        builder.writeBoolean(arg11);
        builder.writeLong(arg12);
        builder.writeBoolean(arg13);
        builder.writeBoolean(arg14);
        builder.writeInt(arg15);
        builder.writeInt(arg16);
        builder.writeLong(arg17);
        builder.writeBoolean(arg18);

        return builder.build();
    }

    public static StatsEvent buildStatsEvent(int code, int arg1, int arg2, int arg3, int arg4, int arg5, int arg6) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeInt(arg2);
        builder.writeInt(arg3);
        builder.writeInt(arg4);
        builder.writeInt(arg5);
        builder.writeInt(arg6);

        return builder.build();
    }

    public static StatsEvent buildStatsEvent(int code, int arg1, int arg2, int arg3, int arg4, int arg5, int arg6, boolean arg7, int arg8, boolean arg9, int arg10, boolean arg11, boolean arg12, int arg13, long arg14, int arg15, boolean arg16) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeInt(arg2);
        builder.writeInt(arg3);
        builder.writeInt(arg4);
        builder.writeInt(arg5);
        builder.writeInt(arg6);
        builder.writeBoolean(arg7);
        builder.writeInt(arg8);
        builder.writeBoolean(arg9);
        builder.writeInt(arg10);
        builder.writeBoolean(arg11);
        builder.writeBoolean(arg12);
        builder.writeInt(arg13);
        builder.writeLong(arg14);
        builder.writeInt(arg15);
        builder.writeBoolean(arg16);

        return builder.build();
    }

    public static StatsEvent buildStatsEvent(int code, int arg1, int arg2, int arg3, int arg4, int arg5, int arg6, int arg7) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeInt(arg2);
        builder.writeInt(arg3);
        builder.writeInt(arg4);
        builder.writeInt(arg5);
        builder.writeInt(arg6);
        builder.writeInt(arg7);

        return builder.build();
    }

    public static StatsEvent buildStatsEvent(int code, int arg1, int arg2, int arg3, int arg4, int arg5, int arg6, int arg7, int arg8, int arg9, int arg10, int arg11, int arg12) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeInt(arg2);
        builder.writeInt(arg3);
        builder.writeInt(arg4);
        builder.writeInt(arg5);
        builder.writeInt(arg6);
        builder.writeInt(arg7);
        builder.writeInt(arg8);
        builder.writeInt(arg9);
        builder.writeInt(arg10);
        builder.writeInt(arg11);
        builder.writeInt(arg12);

        return builder.build();
    }

    public static StatsEvent buildStatsEvent(int code, int arg1, int arg2, int arg3, int arg4, int arg5, int arg6, int arg7, int arg8, int arg9, int arg10, int arg11, int arg12, int arg13, int arg14, int arg15, int arg16, int arg17) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeInt(arg2);
        builder.writeInt(arg3);
        builder.writeInt(arg4);
        builder.writeInt(arg5);
        builder.writeInt(arg6);
        builder.writeInt(arg7);
        builder.writeInt(arg8);
        builder.writeInt(arg9);
        builder.writeInt(arg10);
        builder.writeInt(arg11);
        builder.writeInt(arg12);
        builder.writeInt(arg13);
        builder.writeInt(arg14);
        builder.writeInt(arg15);
        builder.writeInt(arg16);
        builder.writeInt(arg17);

        return builder.build();
    }

    public static StatsEvent buildStatsEvent(int code, int arg1, int arg2, int arg3, long arg4) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeInt(arg2);
        builder.writeInt(arg3);
        builder.writeLong(arg4);

        return builder.build();
    }

    public static StatsEvent buildStatsEvent(int code, int arg1, int arg2, int arg3, float arg4, int arg5, int arg6) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeInt(arg2);
        builder.writeInt(arg3);
        builder.writeFloat(arg4);
        builder.writeInt(arg5);
        builder.writeInt(arg6);

        return builder.build();
    }

    public static StatsEvent buildStatsEvent(int code, int arg1, int arg2, long arg3) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeInt(arg2);
        builder.writeLong(arg3);

        return builder.build();
    }

    public static StatsEvent buildStatsEvent(int code, int arg1, int arg2, long arg3, long arg4) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeInt(arg2);
        builder.writeLong(arg3);
        builder.writeLong(arg4);

        return builder.build();
    }

    public static StatsEvent buildStatsEvent(int code, long arg1) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeLong(arg1);

        return builder.build();
    }

}
