// This file is autogenerated

package com.android.internal.util;


import android.os.Build;
import android.util.StatsEvent;
import android.util.StatsLog;


/**
 * Utility class for logging statistics events.
 */
public final class FrameworkStatsLog {
    // Constants for atom codes.

    /**
     * ProcessStateChanged process_state_changed<br>
     * Usage: StatsLog.write(StatsLog.PROCESS_STATE_CHANGED, int uid, java.lang.String process_name, java.lang.String package_name, int state, long version);<br>
     */
    public static final int PROCESS_STATE_CHANGED = 3;

    /**
     * SensorStateChanged sensor_state_changed<br>
     * Usage: StatsLog.write(StatsLog.SENSOR_STATE_CHANGED, android.os.WorkSource workSource, int sensor_id, int state);<br>
     * Usage: StatsLog.write_non_chained(StatsLog.SENSOR_STATE_CHANGED, int uid, java.lang.String tag, int sensor_id, int state);<br>
     */
    public static final int SENSOR_STATE_CHANGED = 5;

    /**
     * GpsScanStateChanged gps_scan_state_changed<br>
     * Usage: StatsLog.write(StatsLog.GPS_SCAN_STATE_CHANGED, android.os.WorkSource workSource, int state);<br>
     * Usage: StatsLog.write_non_chained(StatsLog.GPS_SCAN_STATE_CHANGED, int uid, java.lang.String tag, int state);<br>
     */
    public static final int GPS_SCAN_STATE_CHANGED = 6;

    /**
     * SyncStateChanged sync_state_changed<br>
     * Usage: StatsLog.write(StatsLog.SYNC_STATE_CHANGED, android.os.WorkSource workSource, java.lang.String sync_name, int state);<br>
     * Usage: StatsLog.write_non_chained(StatsLog.SYNC_STATE_CHANGED, int uid, java.lang.String tag, java.lang.String sync_name, int state);<br>
     */
    public static final int SYNC_STATE_CHANGED = 7;

    /**
     * ScheduledJobStateChanged scheduled_job_state_changed<br>
     * Usage: StatsLog.write(StatsLog.SCHEDULED_JOB_STATE_CHANGED, android.os.WorkSource workSource, java.lang.String job_name, int state, int internal_stop_reason, int standby_bucket, int job_id, boolean has_charging_constraint, boolean has_battery_not_low_constraint, boolean has_storage_not_low_constraint, boolean has_timing_delay_constraint, boolean has_deadline_constraint, boolean has_idle_constraint, boolean has_connectivity_constraint, boolean has_content_trigger_constraint, boolean is_requested_expedited_job, boolean is_running_as_expedited_job, int public_stop_reason, boolean is_prefetch, int requested_priority, int effective_priority, int num_previous_attempts, long deadline_ms, boolean is_deadline_constraint_satisfied, boolean is_charging_constraint_satisfied, boolean is_battery_not_low_constraint_satisfied, boolean is_storage_not_low_constraint_satisfied, boolean is_timing_delay_constraint_satisfied, boolean is_idle_constraint_satisfied, boolean is_connectivity_constraint_satisfied, boolean is_content_trigger_constraint_satisfied, long job_start_latency_ms, boolean is_requested_as_user_initiated_job, boolean is_running_as_user_initiated_job, boolean is_periodic, long delay_ms, long estimated_download_bytes, long estimated_upload_bytes, int num_uncompleted_work_items, int proc_state);<br>
     * Usage: StatsLog.write_non_chained(StatsLog.SCHEDULED_JOB_STATE_CHANGED, int uid, java.lang.String tag, java.lang.String job_name, int state, int internal_stop_reason, int standby_bucket, int job_id, boolean has_charging_constraint, boolean has_battery_not_low_constraint, boolean has_storage_not_low_constraint, boolean has_timing_delay_constraint, boolean has_deadline_constraint, boolean has_idle_constraint, boolean has_connectivity_constraint, boolean has_content_trigger_constraint, boolean is_requested_expedited_job, boolean is_running_as_expedited_job, int public_stop_reason, boolean is_prefetch, int requested_priority, int effective_priority, int num_previous_attempts, long deadline_ms, boolean is_deadline_constraint_satisfied, boolean is_charging_constraint_satisfied, boolean is_battery_not_low_constraint_satisfied, boolean is_storage_not_low_constraint_satisfied, boolean is_timing_delay_constraint_satisfied, boolean is_idle_constraint_satisfied, boolean is_connectivity_constraint_satisfied, boolean is_content_trigger_constraint_satisfied, long job_start_latency_ms, boolean is_requested_as_user_initiated_job, boolean is_running_as_user_initiated_job, boolean is_periodic, long delay_ms, long estimated_download_bytes, long estimated_upload_bytes, int num_uncompleted_work_items, int proc_state);<br>
     */
    public static final int SCHEDULED_JOB_STATE_CHANGED = 8;

    /**
     * ScreenBrightnessChanged screen_brightness_changed<br>
     * Usage: StatsLog.write(StatsLog.SCREEN_BRIGHTNESS_CHANGED, int level);<br>
     */
    public static final int SCREEN_BRIGHTNESS_CHANGED = 9;

    /**
     * WakelockStateChanged wakelock_state_changed<br>
     * Usage: StatsLog.write(StatsLog.WAKELOCK_STATE_CHANGED, android.os.WorkSource workSource, int type, java.lang.String tag, int state, int process_state);<br>
     * Usage: StatsLog.write_non_chained(StatsLog.WAKELOCK_STATE_CHANGED, int uid, java.lang.String tag, int type, java.lang.String tag, int state, int process_state);<br>
     */
    public static final int WAKELOCK_STATE_CHANGED = 10;

    /**
     * LongPartialWakelockStateChanged long_partial_wakelock_state_changed<br>
     * Usage: StatsLog.write(StatsLog.LONG_PARTIAL_WAKELOCK_STATE_CHANGED, android.os.WorkSource workSource, java.lang.String tag, java.lang.String history_tag, int state);<br>
     * Usage: StatsLog.write_non_chained(StatsLog.LONG_PARTIAL_WAKELOCK_STATE_CHANGED, int uid, java.lang.String tag, java.lang.String tag, java.lang.String history_tag, int state);<br>
     */
    public static final int LONG_PARTIAL_WAKELOCK_STATE_CHANGED = 11;

    /**
     * MobileRadioPowerStateChanged mobile_radio_power_state_changed<br>
     * Usage: StatsLog.write(StatsLog.MOBILE_RADIO_POWER_STATE_CHANGED, android.os.WorkSource workSource, int state);<br>
     * Usage: StatsLog.write_non_chained(StatsLog.MOBILE_RADIO_POWER_STATE_CHANGED, int uid, java.lang.String tag, int state);<br>
     */
    public static final int MOBILE_RADIO_POWER_STATE_CHANGED = 12;

    /**
     * WifiRadioPowerStateChanged wifi_radio_power_state_changed<br>
     * Usage: StatsLog.write(StatsLog.WIFI_RADIO_POWER_STATE_CHANGED, android.os.WorkSource workSource, int state);<br>
     * Usage: StatsLog.write_non_chained(StatsLog.WIFI_RADIO_POWER_STATE_CHANGED, int uid, java.lang.String tag, int state);<br>
     */
    public static final int WIFI_RADIO_POWER_STATE_CHANGED = 13;

    /**
     * ActivityManagerSleepStateChanged activity_manager_sleep_state_changed<br>
     * Usage: StatsLog.write(StatsLog.ACTIVITY_MANAGER_SLEEP_STATE_CHANGED, int state);<br>
     */
    public static final int ACTIVITY_MANAGER_SLEEP_STATE_CHANGED = 14;

    /**
     * MemoryFactorStateChanged memory_factor_state_changed<br>
     * Usage: StatsLog.write(StatsLog.MEMORY_FACTOR_STATE_CHANGED, int factor);<br>
     */
    public static final int MEMORY_FACTOR_STATE_CHANGED = 15;

    /**
     * ExcessiveCpuUsageReported excessive_cpu_usage_reported<br>
     * Usage: StatsLog.write(StatsLog.EXCESSIVE_CPU_USAGE_REPORTED, int uid, java.lang.String process_name, java.lang.String package_name, long version);<br>
     */
    public static final int EXCESSIVE_CPU_USAGE_REPORTED = 16;

    /**
     * CachedKillReported cached_kill_reported<br>
     * Usage: StatsLog.write(StatsLog.CACHED_KILL_REPORTED, int uid, java.lang.String process_name, java.lang.String package_name, long pss, long version);<br>
     */
    public static final int CACHED_KILL_REPORTED = 17;

    /**
     * ProcessMemoryStatReported process_memory_stat_reported<br>
     * Usage: StatsLog.write(StatsLog.PROCESS_MEMORY_STAT_REPORTED, int uid, java.lang.String process_name, java.lang.String package_name, long pss, long uss, long rss, int type, long duration_millis, long version, int current_hosting_component_types, int historical_hosting_component_types);<br>
     */
    public static final int PROCESS_MEMORY_STAT_REPORTED = 18;

    /**
     * BatterySaverModeStateChanged battery_saver_mode_state_changed<br>
     * Usage: StatsLog.write(StatsLog.BATTERY_SAVER_MODE_STATE_CHANGED, int state);<br>
     */
    public static final int BATTERY_SAVER_MODE_STATE_CHANGED = 20;

    /**
     * DeviceIdleModeStateChanged device_idle_mode_state_changed<br>
     * Usage: StatsLog.write(StatsLog.DEVICE_IDLE_MODE_STATE_CHANGED, int state);<br>
     */
    public static final int DEVICE_IDLE_MODE_STATE_CHANGED = 21;

    /**
     * DeviceIdlingModeStateChanged device_idling_mode_state_changed<br>
     * Usage: StatsLog.write(StatsLog.DEVICE_IDLING_MODE_STATE_CHANGED, int state);<br>
     */
    public static final int DEVICE_IDLING_MODE_STATE_CHANGED = 22;

    /**
     * AudioStateChanged audio_state_changed<br>
     * Usage: StatsLog.write(StatsLog.AUDIO_STATE_CHANGED, android.os.WorkSource workSource, int state);<br>
     * Usage: StatsLog.write_non_chained(StatsLog.AUDIO_STATE_CHANGED, int uid, java.lang.String tag, int state);<br>
     */
    public static final int AUDIO_STATE_CHANGED = 23;

    /**
     * MediaCodecStateChanged media_codec_state_changed<br>
     * Usage: StatsLog.write(StatsLog.MEDIA_CODEC_STATE_CHANGED, android.os.WorkSource workSource, int state);<br>
     * Usage: StatsLog.write_non_chained(StatsLog.MEDIA_CODEC_STATE_CHANGED, int uid, java.lang.String tag, int state);<br>
     */
    public static final int MEDIA_CODEC_STATE_CHANGED = 24;

    /**
     * CameraStateChanged camera_state_changed<br>
     * Usage: StatsLog.write(StatsLog.CAMERA_STATE_CHANGED, android.os.WorkSource workSource, int state);<br>
     * Usage: StatsLog.write_non_chained(StatsLog.CAMERA_STATE_CHANGED, int uid, java.lang.String tag, int state);<br>
     */
    public static final int CAMERA_STATE_CHANGED = 25;

    /**
     * FlashlightStateChanged flashlight_state_changed<br>
     * Usage: StatsLog.write(StatsLog.FLASHLIGHT_STATE_CHANGED, android.os.WorkSource workSource, int state);<br>
     * Usage: StatsLog.write_non_chained(StatsLog.FLASHLIGHT_STATE_CHANGED, int uid, java.lang.String tag, int state);<br>
     */
    public static final int FLASHLIGHT_STATE_CHANGED = 26;

    /**
     * UidProcessStateChanged uid_process_state_changed<br>
     * Usage: StatsLog.write(StatsLog.UID_PROCESS_STATE_CHANGED, int uid, int state);<br>
     */
    public static final int UID_PROCESS_STATE_CHANGED = 27;

    /**
     * ProcessLifeCycleStateChanged process_life_cycle_state_changed<br>
     * Usage: StatsLog.write(StatsLog.PROCESS_LIFE_CYCLE_STATE_CHANGED, int uid, java.lang.String process_name, int state);<br>
     */
    public static final int PROCESS_LIFE_CYCLE_STATE_CHANGED = 28;

    /**
     * ScreenStateChanged screen_state_changed<br>
     * Usage: StatsLog.write(StatsLog.SCREEN_STATE_CHANGED, int state);<br>
     */
    public static final int SCREEN_STATE_CHANGED = 29;

    /**
     * BatteryLevelChanged battery_level_changed<br>
     * Usage: StatsLog.write(StatsLog.BATTERY_LEVEL_CHANGED, int battery_level);<br>
     */
    public static final int BATTERY_LEVEL_CHANGED = 30;

    /**
     * ChargingStateChanged charging_state_changed<br>
     * Usage: StatsLog.write(StatsLog.CHARGING_STATE_CHANGED, int state);<br>
     */
    public static final int CHARGING_STATE_CHANGED = 31;

    /**
     * PluggedStateChanged plugged_state_changed<br>
     * Usage: StatsLog.write(StatsLog.PLUGGED_STATE_CHANGED, int state);<br>
     */
    public static final int PLUGGED_STATE_CHANGED = 32;

    /**
     * InteractiveStateChanged interactive_state_changed<br>
     * Usage: StatsLog.write(StatsLog.INTERACTIVE_STATE_CHANGED, int state);<br>
     */
    public static final int INTERACTIVE_STATE_CHANGED = 33;

    /**
     * WakeupAlarmOccurred wakeup_alarm_occurred<br>
     * Usage: StatsLog.write(StatsLog.WAKEUP_ALARM_OCCURRED, android.os.WorkSource workSource, java.lang.String tag, java.lang.String package_name, int app_standby_bucket);<br>
     * Usage: StatsLog.write_non_chained(StatsLog.WAKEUP_ALARM_OCCURRED, int uid, java.lang.String tag, java.lang.String tag, java.lang.String package_name, int app_standby_bucket);<br>
     */
    public static final int WAKEUP_ALARM_OCCURRED = 35;

    /**
     * KernelWakeupReported kernel_wakeup_reported<br>
     * Usage: StatsLog.write(StatsLog.KERNEL_WAKEUP_REPORTED, java.lang.String wakeup_reason_name, long duration_micros, long elapsed_millis);<br>
     */
    public static final int KERNEL_WAKEUP_REPORTED = 36;

    /**
     * PhoneSignalStrengthChanged phone_signal_strength_changed<br>
     * Usage: StatsLog.write(StatsLog.PHONE_SIGNAL_STRENGTH_CHANGED, int signal_strength);<br>
     */
    public static final int PHONE_SIGNAL_STRENGTH_CHANGED = 40;

    /**
     * SettingChanged setting_changed<br>
     * Usage: StatsLog.write(StatsLog.SETTING_CHANGED, java.lang.String setting, java.lang.String value, java.lang.String new_value, java.lang.String prev_value, java.lang.String tag, boolean is_default, int user, int reason);<br>
     */
    public static final int SETTING_CHANGED = 41;

    /**
     * ActivityForegroundStateChanged activity_foreground_state_changed<br>
     * Usage: StatsLog.write(StatsLog.ACTIVITY_FOREGROUND_STATE_CHANGED, int uid, java.lang.String pkg_name, java.lang.String class_name, int state);<br>
     */
    public static final int ACTIVITY_FOREGROUND_STATE_CHANGED = 42;

    /**
     * IsolatedUidChanged isolated_uid_changed<br>
     * Usage: StatsLog.write(StatsLog.ISOLATED_UID_CHANGED, int parent_uid, int isolated_uid, int event);<br>
     */
    public static final int ISOLATED_UID_CHANGED = 43;

    /**
     * PacketWakeupOccurred packet_wakeup_occurred<br>
     * Usage: StatsLog.write(StatsLog.PACKET_WAKEUP_OCCURRED, int uid, java.lang.String iface, int ethertype, java.lang.String destination_hardware_address, java.lang.String source_ip, java.lang.String destination_ip, int ip_next_header, int source_port, int destination_port);<br>
     */
    public static final int PACKET_WAKEUP_OCCURRED = 44;

    /**
     * WallClockTimeShifted wall_clock_time_shifted<br>
     * Usage: StatsLog.write(StatsLog.WALL_CLOCK_TIME_SHIFTED, long wall_clock_timestamp_millis);<br>
     */
    public static final int WALL_CLOCK_TIME_SHIFTED = 45;

    /**
     * AppStartOccurred app_start_occurred<br>
     * Usage: StatsLog.write(StatsLog.APP_START_OCCURRED, int uid, java.lang.String pkg_name, int type, java.lang.String activity_name, java.lang.String calling_pkg_name, boolean is_instant_app, long activity_start_millis, int reason, int transition_delay_millis, int starting_window_delay_millis, int bind_application_delay_millis, int windows_drawn_delay_millis, java.lang.String launch_token, int package_optimization_compilation_reason, int package_optimization_compilation_filter, int source_type, int source_event_delay_millis, boolean is_hibernating, boolean is_incremental, boolean is_loading, int activity_name_hash, long activity_start_timestamp_millis, int process_state, int process_oom_adj, int package_stopped_state);<br>
     */
    public static final int APP_START_OCCURRED = 48;

    /**
     * AppStartCanceled app_start_canceled<br>
     * Usage: StatsLog.write(StatsLog.APP_START_CANCELED, int uid, java.lang.String pkg_name, int type, java.lang.String activity_name);<br>
     */
    public static final int APP_START_CANCELED = 49;

    /**
     * AppStartFullyDrawn app_start_fully_drawn<br>
     * Usage: StatsLog.write(StatsLog.APP_START_FULLY_DRAWN, int uid, java.lang.String pkg_name, int type, java.lang.String activity_name, boolean transition_process_running, long app_startup_time_millis, int package_optimization_compilation_reason, int package_optimization_compilation_filter, int source_type, int source_event_delay_millis, boolean is_incremental, boolean is_loading, int activity_name_hash, long activity_start_timestamp_millis);<br>
     */
    public static final int APP_START_FULLY_DRAWN = 50;

    /**
     * LmkKillOccurred lmk_kill_occurred<br>
     * Usage: StatsLog.write(StatsLog.LMK_KILL_OCCURRED, int uid, java.lang.String process_name, int oom_adj_score, long page_fault, long page_major_fault, long rss_in_bytes, long cache_in_bytes, long swap_in_bytes, long process_start_time_nanos, int min_oom_score, int free_mem_kb, int free_swap_kb, int reason, int thrashing, int max_thrashing, int total_foreground_services, int procs_with_foreground_services);<br>
     */
    public static final int LMK_KILL_OCCURRED = 51;

    /**
     * PictureInPictureStateChanged picture_in_picture_state_changed<br>
     * Usage: StatsLog.write(StatsLog.PICTURE_IN_PICTURE_STATE_CHANGED, int uid, java.lang.String short_name, int state);<br>
     */
    public static final int PICTURE_IN_PICTURE_STATE_CHANGED = 52;

    /**
     * LmkStateChanged lmk_state_changed<br>
     * Usage: StatsLog.write(StatsLog.LMK_STATE_CHANGED, int state);<br>
     */
    public static final int LMK_STATE_CHANGED = 54;

    /**
     * AppStartMemoryStateCaptured app_start_memory_state_captured<br>
     * Usage: StatsLog.write(StatsLog.APP_START_MEMORY_STATE_CAPTURED, int uid, java.lang.String process_name, java.lang.String activity_name, long page_fault, long page_major_fault, long rss_in_bytes, long cache_in_bytes, long swap_in_bytes);<br>
     */
    public static final int APP_START_MEMORY_STATE_CAPTURED = 55;

    /**
     * ShutdownSequenceReported shutdown_sequence_reported<br>
     * Usage: StatsLog.write(StatsLog.SHUTDOWN_SEQUENCE_REPORTED, boolean reboot, java.lang.String reason, long start_time_millis, long duration_millis);<br>
     */
    public static final int SHUTDOWN_SEQUENCE_REPORTED = 56;

    /**
     * OverlayStateChanged overlay_state_changed<br>
     * Usage: StatsLog.write(StatsLog.OVERLAY_STATE_CHANGED, int uid, java.lang.String package_name, boolean using_alert_window, int state);<br>
     */
    public static final int OVERLAY_STATE_CHANGED = 59;

    /**
     * ForegroundServiceStateChanged foreground_service_state_changed<br>
     * Usage: StatsLog.write(StatsLog.FOREGROUND_SERVICE_STATE_CHANGED, int uid, java.lang.String short_name, int state, boolean allow_while_in_use_permission, int fgs_start_reason_code, int target_sdk_version, int calling_uid, int caller_target_sdk_version, int temp_allow_list_calling_uid, boolean fgs_notification_deferred, boolean fgs_notification_shown, int fgs_duration_ms, int fgs_start_count, int short_name_hash, boolean fgs_has_notification_permission, int fgs_types, int fgs_type_check_code, boolean is_delegate, int delegate_client_uid, int delegation_service, int api_state, int api_type, long api_timestamp, int service_uid_state, int service_uid_capabilities, int calling_uid_state, int calling_uid_capabilities, long api_before_fgs_start_duration, long api_after_fgs_end_duration);<br>
     */
    public static final int FOREGROUND_SERVICE_STATE_CHANGED = 60;

    /**
     * AppDied app_died<br>
     * Usage: StatsLog.write(StatsLog.APP_DIED, long timestamp_millis);<br>
     */
    public static final int APP_DIED = 65;

    /**
     * ResourceConfigurationChanged resource_configuration_changed<br>
     * Usage: StatsLog.write(StatsLog.RESOURCE_CONFIGURATION_CHANGED, int color_mode, int density_dpi, float font_scale, int hard_keyboard_hidden, int keyboard, int keyboard_hidden, int mcc, int mnc, int navigation, int navigation_hidden, int orientation, int screen_height_dp, int screen_layout, int screen_width_dp, int smallest_screen_width_dp, int touchscreen, int ui_mode);<br>
     */
    public static final int RESOURCE_CONFIGURATION_CHANGED = 66;

    /**
     * BluetoothEnabledStateChanged bluetooth_enabled_state_changed<br>
     * Usage: StatsLog.write(StatsLog.BLUETOOTH_ENABLED_STATE_CHANGED, android.os.WorkSource workSource, int state, int reason, java.lang.String pkg_name);<br>
     * Usage: StatsLog.write_non_chained(StatsLog.BLUETOOTH_ENABLED_STATE_CHANGED, int uid, java.lang.String tag, int state, int reason, java.lang.String pkg_name);<br>
     */
    public static final int BLUETOOTH_ENABLED_STATE_CHANGED = 67;

    /**
     * GpsSignalQualityChanged gps_signal_quality_changed<br>
     * Usage: StatsLog.write(StatsLog.GPS_SIGNAL_QUALITY_CHANGED, int level);<br>
     */
    public static final int GPS_SIGNAL_QUALITY_CHANGED = 69;

    /**
     * UsbConnectorStateChanged usb_connector_state_changed<br>
     * Usage: StatsLog.write(StatsLog.USB_CONNECTOR_STATE_CHANGED, int state, java.lang.String id, long last_connect_duration_millis);<br>
     */
    public static final int USB_CONNECTOR_STATE_CHANGED = 70;

    /**
     * UsbDeviceAttached usb_device_attached<br>
     * Usage: StatsLog.write(StatsLog.USB_DEVICE_ATTACHED, int vid, int pid, boolean has_audio, boolean has_hid, boolean has_storage, int state, long last_connect_duration_millis);<br>
     */
    public static final int USB_DEVICE_ATTACHED = 77;

    /**
     * AppCrashOccurred app_crash_occurred<br>
     * Usage: StatsLog.write(StatsLog.APP_CRASH_OCCURRED, int uid, java.lang.String event_type, java.lang.String process_name, int pid, java.lang.String package_name, int is_instant_app, int foreground_state, int error_source, boolean is_incremental, float loading_progress, long millis_since_oldest_pending_read, int storage_health_code, int data_loader_status_code, boolean read_logs_enabled, long millis_since_last_data_loader_bind, long data_loader_bind_delay_millis, int total_delayed_reads, int total_failed_reads, int last_read_error_uid, long last_read_error_millis_since, int last_read_error_code, long total_delayed_reads_duration_millis);<br>
     */
    public static final int APP_CRASH_OCCURRED = 78;

    /**
     * ANROccurred anr_occurred<br>
     * Usage: StatsLog.write(StatsLog.ANR_OCCURRED, int uid, java.lang.String process_name, java.lang.String short_component_name, java.lang.String reason, int is_instant_app, int foreground_state, int error_source, java.lang.String package_name, boolean is_incremental, float loading_progress, long millis_since_oldest_pending_read, int storage_health_code, int data_loader_status_code, boolean read_logs_enabled, long millis_since_last_data_loader_bind, long data_loader_bind_delay_millis, int total_delayed_reads, int total_failed_reads, int last_read_error_uid, long last_read_error_millis_since, int last_read_error_code, long total_delayed_reads_duration_millis);<br>
     */
    public static final int ANR_OCCURRED = 79;

    /**
     * WTFOccurred wtf_occurred<br>
     * Usage: StatsLog.write(StatsLog.WTF_OCCURRED, int uid, java.lang.String tag, java.lang.String process_name, int pid, int error_source);<br>
     */
    public static final int WTF_OCCURRED = 80;

    /**
     * LowMemReported low_mem_reported<br>
     * Usage: StatsLog.write(StatsLog.LOW_MEM_REPORTED);<br>
     */
    public static final int LOW_MEM_REPORTED = 81;

    /**
     * VibratorStateChanged vibrator_state_changed<br>
     * Usage: StatsLog.write(StatsLog.VIBRATOR_STATE_CHANGED, android.os.WorkSource workSource, int state, long duration_millis);<br>
     * Usage: StatsLog.write_non_chained(StatsLog.VIBRATOR_STATE_CHANGED, int uid, java.lang.String tag, int state, long duration_millis);<br>
     */
    public static final int VIBRATOR_STATE_CHANGED = 84;

    /**
     * DeferredJobStatsReported deferred_job_stats_reported<br>
     * Usage: StatsLog.write(StatsLog.DEFERRED_JOB_STATS_REPORTED, android.os.WorkSource workSource, int num_jobs_deferred, long time_since_last_job_millis);<br>
     * Usage: StatsLog.write_non_chained(StatsLog.DEFERRED_JOB_STATS_REPORTED, int uid, java.lang.String tag, int num_jobs_deferred, long time_since_last_job_millis);<br>
     */
    public static final int DEFERRED_JOB_STATS_REPORTED = 85;

    /**
     * BiometricAcquired biometric_acquired<br>
     * Usage: StatsLog.write(StatsLog.BIOMETRIC_ACQUIRED, int modality, int user, boolean is_crypto, int action, int client, int acquire_info, int acquire_info_vendor, boolean debug, int sensor_id, int session_id, int session_type, boolean is_aod, boolean is_display_on, int dock_state, int orientation, int fold_state, int session_order, int wake_reason);<br>
     */
    public static final int BIOMETRIC_ACQUIRED = 87;

    /**
     * BiometricAuthenticated biometric_authenticated<br>
     * Usage: StatsLog.write(StatsLog.BIOMETRIC_AUTHENTICATED, int modality, int user, boolean is_crypto, int client, boolean require_confirmation, int state, long latency_millis, boolean debug, int sensor_id, float ambient_light_lux, int session_id, int session_type, boolean is_aod, boolean is_display_on, int dock_state, int orientation, int fold_state, int session_order, int wake_reason, int[] wake_reason_details);<br>
     */
    public static final int BIOMETRIC_AUTHENTICATED = 88;

    /**
     * BiometricErrorOccurred biometric_error_occurred<br>
     * Usage: StatsLog.write(StatsLog.BIOMETRIC_ERROR_OCCURRED, int modality, int user, boolean is_crypto, int action, int client, int error_info, int error_info_vendor, boolean debug, long latency_millis, int sensor_id, int session_id, int session_type, boolean is_aod, boolean is_display_on, int dock_state, int orientation, int fold_state, int session_order, int wake_reason, int[] wake_reason_details);<br>
     */
    public static final int BIOMETRIC_ERROR_OCCURRED = 89;

    /**
     * UiEventReported ui_event_reported<br>
     * Usage: StatsLog.write(StatsLog.UI_EVENT_REPORTED, int event_id, int uid, java.lang.String package_name, int instance_id);<br>
     */
    public static final int UI_EVENT_REPORTED = 90;

    /**
     * PhoneServiceStateChanged phone_service_state_changed<br>
     * Usage: StatsLog.write(StatsLog.PHONE_SERVICE_STATE_CHANGED, int state, int sim_state, int signal_strength);<br>
     */
    public static final int PHONE_SERVICE_STATE_CHANGED = 94;

    /**
     * PhoneStateChanged phone_state_changed<br>
     * Usage: StatsLog.write(StatsLog.PHONE_STATE_CHANGED, int state);<br>
     */
    public static final int PHONE_STATE_CHANGED = 95;

    /**
     * ConnectivityStateChanged connectivity_state_changed<br>
     * Usage: StatsLog.write(StatsLog.CONNECTIVITY_STATE_CHANGED, int net_id, int state);<br>
     */
    public static final int CONNECTIVITY_STATE_CHANGED = 98;

    /**
     * ServiceStateChanged service_state_changed<br>
     * Usage: StatsLog.write(StatsLog.SERVICE_STATE_CHANGED, int uid, java.lang.String package_name, java.lang.String service_name, int state);<br>
     */
    public static final int SERVICE_STATE_CHANGED = 99;

    /**
     * ServiceLaunchReported service_launch_reported<br>
     * Usage: StatsLog.write(StatsLog.SERVICE_LAUNCH_REPORTED, int uid, java.lang.String package_name, java.lang.String service_name);<br>
     */
    public static final int SERVICE_LAUNCH_REPORTED = 100;

    /**
     * FlagFlipUpdateOccurred flag_flip_update_occurred<br>
     * Usage: StatsLog.write(StatsLog.FLAG_FLIP_UPDATE_OCCURRED, java.lang.String flag_flip_package_name, long order_id);<br>
     */
    public static final int FLAG_FLIP_UPDATE_OCCURRED = 101;

    /**
     * DevicePolicyEvent device_policy_event<br>
     * Usage: StatsLog.write(StatsLog.DEVICE_POLICY_EVENT, int event_id, java.lang.String admin_package_name, int integer_value, boolean boolean_value, long time_period_millis, byte[] string_list_value);<br>
     */
    public static final int DEVICE_POLICY_EVENT = 103;

    /**
     * WifiEnabledStateChanged wifi_enabled_state_changed<br>
     * Usage: StatsLog.write(StatsLog.WIFI_ENABLED_STATE_CHANGED, int state);<br>
     */
    public static final int WIFI_ENABLED_STATE_CHANGED = 113;

    /**
     * WifiRunningStateChanged wifi_running_state_changed<br>
     * Usage: StatsLog.write(StatsLog.WIFI_RUNNING_STATE_CHANGED, android.os.WorkSource workSource, int state);<br>
     * Usage: StatsLog.write_non_chained(StatsLog.WIFI_RUNNING_STATE_CHANGED, int uid, java.lang.String tag, int state);<br>
     */
    public static final int WIFI_RUNNING_STATE_CHANGED = 114;

    /**
     * AppCompacted app_compacted<br>
     * Usage: StatsLog.write(StatsLog.APP_COMPACTED, int pid, java.lang.String process_name, int action, long before_rss_total_kilobytes, long before_rss_file_kilobytes, long before_rss_anon_kilobytes, long before_swap_kilobytes, long after_rss_total_kilobytes, long after_rss_file_kilobytes, long after_rss_anon_kilobytes, long after_swap_kilobytes, long time_to_compact_millis, int last_action, long last_compact_timestamp_ms_since_boot, int oom_score_adj, int process_state, long before_zram_free_kilobytes, long after_zram_free_kilobytes);<br>
     */
    public static final int APP_COMPACTED = 115;

    /**
     * RescuePartyResetReported rescue_party_reset_reported<br>
     * Usage: StatsLog.write(StatsLog.RESCUE_PARTY_RESET_REPORTED, int rescue_level);<br>
     */
    public static final int RESCUE_PARTY_RESET_REPORTED = 122;

    /**
     * SignedConfigReported signed_config_reported<br>
     * Usage: StatsLog.write(StatsLog.SIGNED_CONFIG_REPORTED, int type, int status, int version, java.lang.String from_package, int verified_with);<br>
     */
    public static final int SIGNED_CONFIG_REPORTED = 123;

    /**
     * GnssNiEventReported gnss_ni_event_reported<br>
     * Usage: StatsLog.write(StatsLog.GNSS_NI_EVENT_REPORTED, int event_type, int notification_id, int ni_type, boolean need_notify, boolean need_verify, boolean privacy_override, int timeout, int default_response, java.lang.String requestor_id, java.lang.String text, int requestor_id_encoding, int text_encoding, boolean is_supl_es_enabled, boolean is_location_enabled, int user_response);<br>
     */
    public static final int GNSS_NI_EVENT_REPORTED = 124;

    /**
     * AppDowngraded app_downgraded<br>
     * Usage: StatsLog.write(StatsLog.APP_DOWNGRADED, java.lang.String package_name, long size_in_bytes_before, long size_in_bytes_after, boolean aggressive);<br>
     */
    public static final int APP_DOWNGRADED = 128;

    /**
     * LowStorageStateChanged low_storage_state_changed<br>
     * Usage: StatsLog.write(StatsLog.LOW_STORAGE_STATE_CHANGED, java.lang.String volume_description, int state);<br>
     */
    public static final int LOW_STORAGE_STATE_CHANGED = 130;

    /**
     * GnssNfwNotificationReported gnss_nfw_notification_reported<br>
     * Usage: StatsLog.write(StatsLog.GNSS_NFW_NOTIFICATION_REPORTED, java.lang.String proxy_app_package_name, int protocol_stack, java.lang.String other_protocol_stack_name, int requestor, java.lang.String requestor_id, int response_type, boolean in_emergency_mode, boolean is_cached_location, boolean is_permission_mismatched);<br>
     */
    public static final int GNSS_NFW_NOTIFICATION_REPORTED = 131;

    /**
     * GnssConfigurationReported gnss_configuration_reported<br>
     * Usage: StatsLog.write(StatsLog.GNSS_CONFIGURATION_REPORTED, java.lang.String supl_host, int supl_port, java.lang.String c2k_host, int c2k_port, int supl_ver, int supl_mode, boolean supl_es, int lpp_profile, int a_glonass_pos_protocol_select, boolean use_emergency_pdn_for_emergency_supl, int gps_lock, int es_extension_sec, java.lang.String enabled_proxy_app_package_name_list);<br>
     */
    public static final int GNSS_CONFIGURATION_REPORTED = 132;

    /**
     * BroadcastDispatchLatencyReported broadcast_dispatch_latency_reported<br>
     * Usage: StatsLog.write(StatsLog.BROADCAST_DISPATCH_LATENCY_REPORTED, long dispatch_latency_millis);<br>
     */
    public static final int BROADCAST_DISPATCH_LATENCY_REPORTED = 142;

    /**
     * AttentionManagerServiceResultReported attention_manager_service_result_reported<br>
     * Usage: StatsLog.write(StatsLog.ATTENTION_MANAGER_SERVICE_RESULT_REPORTED, int attention_check_result);<br>
     */
    public static final int ATTENTION_MANAGER_SERVICE_RESULT_REPORTED = 143;

    /**
     * AdbConnectionChanged adb_connection_changed<br>
     * Usage: StatsLog.write(StatsLog.ADB_CONNECTION_CHANGED, long last_connection_time_millis, long auth_window_millis, int state, boolean always_allow);<br>
     */
    public static final int ADB_CONNECTION_CHANGED = 144;

    /**
     * UsbContaminantReported usb_contaminant_reported<br>
     * Usage: StatsLog.write(StatsLog.USB_CONTAMINANT_REPORTED, java.lang.String id, int status);<br>
     */
    public static final int USB_CONTAMINANT_REPORTED = 146;

    /**
     * WatchdogRollbackOccurred watchdog_rollback_occurred<br>
     * Usage: StatsLog.write(StatsLog.WATCHDOG_ROLLBACK_OCCURRED, int rollback_type, java.lang.String package_name, int package_version_code, int rollback_reason, java.lang.String failing_package_name, byte[] experiment_ids);<br>
     */
    public static final int WATCHDOG_ROLLBACK_OCCURRED = 147;

    /**
     * BiometricSystemHealthIssueDetected biometric_system_health_issue_detected<br>
     * Usage: StatsLog.write(StatsLog.BIOMETRIC_SYSTEM_HEALTH_ISSUE_DETECTED, int modality, int issue, boolean debug, int sensor_id);<br>
     */
    public static final int BIOMETRIC_SYSTEM_HEALTH_ISSUE_DETECTED = 148;

    /**
     * BubbleUIChanged bubble_ui_changed<br>
     * Usage: StatsLog.write(StatsLog.BUBBLE_UI_CHANGED, java.lang.String package_name, java.lang.String notification_channel, int notification_id, int position, int total_number, int action, float normalized_x_position, float normalized_y_position, boolean is_unread, boolean is_ongoing, boolean is_foreground);<br>
     */
    public static final int BUBBLE_UI_CHANGED = 149;

    /**
     * ScheduledJobConstraintChanged scheduled_job_constraint_changed<br>
     * Usage: StatsLog.write(StatsLog.SCHEDULED_JOB_CONSTRAINT_CHANGED, android.os.WorkSource workSource, java.lang.String job_name, int constraint, int state);<br>
     * Usage: StatsLog.write_non_chained(StatsLog.SCHEDULED_JOB_CONSTRAINT_CHANGED, int uid, java.lang.String tag, java.lang.String job_name, int constraint, int state);<br>
     */
    public static final int SCHEDULED_JOB_CONSTRAINT_CHANGED = 150;

    /**
     * ScreenTimeoutExtensionReported screen_timeout_extension_reported<br>
     * Usage: StatsLog.write(StatsLog.SCREEN_TIMEOUT_EXTENSION_REPORTED, int consecutive_timeout_extended_count);<br>
     */
    public static final int SCREEN_TIMEOUT_EXTENSION_REPORTED = 168;

    /**
     * ProcessStartTime process_start_time<br>
     * Usage: StatsLog.write(StatsLog.PROCESS_START_TIME, int uid, int pid, java.lang.String process_name, int type, long process_start_time_millis, int bind_application_delay_millis, int process_start_delay_millis, java.lang.String hosting_type, java.lang.String hosting_name, java.lang.String broadcast_action_name, int hosting_type_id, int trigger_type);<br>
     */
    public static final int PROCESS_START_TIME = 169;

    /**
     * BubbleDeveloperErrorReported bubble_developer_error_reported<br>
     * Usage: StatsLog.write(StatsLog.BUBBLE_DEVELOPER_ERROR_REPORTED, java.lang.String package_name, int error);<br>
     */
    public static final int BUBBLE_DEVELOPER_ERROR_REPORTED = 173;

    /**
     * TouchGestureClassified touch_gesture_classified<br>
     * Usage: StatsLog.write(StatsLog.TOUCH_GESTURE_CLASSIFIED, java.lang.String source, int classification, int latency_millis, float displacement_px);<br>
     */
    public static final int TOUCH_GESTURE_CLASSIFIED = 177;

    /**
     * HiddenApiUsed hidden_api_used<br>
     * Usage: StatsLog.write(StatsLog.HIDDEN_API_USED, int uid, java.lang.String signature, int access_method, boolean access_denied);<br>
     */
    public static final int HIDDEN_API_USED = 178;

    /**
     * AppInstallOnExternalStorageReported app_install_on_external_storage_reported<br>
     * Usage: StatsLog.write(StatsLog.APP_INSTALL_ON_EXTERNAL_STORAGE_REPORTED, int storage_type, java.lang.String package_name);<br>
     */
    public static final int APP_INSTALL_ON_EXTERNAL_STORAGE_REPORTED = 181;

    /**
     * AppMovedStorageReported app_moved_storage_reported<br>
     * Usage: StatsLog.write(StatsLog.APP_MOVED_STORAGE_REPORTED, int external_storage_type, int move_type, java.lang.String package_name);<br>
     */
    public static final int APP_MOVED_STORAGE_REPORTED = 183;

    /**
     * BiometricEnrolled biometric_enrolled<br>
     * Usage: StatsLog.write(StatsLog.BIOMETRIC_ENROLLED, int modality, int user, long latency_millis, boolean success, int sensor_id, float ambient_light_lux);<br>
     */
    public static final int BIOMETRIC_ENROLLED = 184;

    /**
     * SystemServerWatchdogOccurred system_server_watchdog_occurred<br>
     * Usage: StatsLog.write(StatsLog.SYSTEM_SERVER_WATCHDOG_OCCURRED, java.lang.String subject);<br>
     */
    public static final int SYSTEM_SERVER_WATCHDOG_OCCURRED = 185;

    /**
     * TombStoneOccurred tomb_stone_occurred<br>
     * Usage: StatsLog.write(StatsLog.TOMB_STONE_OCCURRED);<br>
     */
    public static final int TOMB_STONE_OCCURRED = 186;

    /**
     * ThermalThrottlingSeverityStateChanged thermal_throttling_severity_state_changed<br>
     * Usage: StatsLog.write(StatsLog.THERMAL_THROTTLING_SEVERITY_STATE_CHANGED, int sensor_type, java.lang.String sensor_name, int temperature_deci_celsius, int severity);<br>
     */
    public static final int THERMAL_THROTTLING_SEVERITY_STATE_CHANGED = 189;

    /**
     * ContentCaptureCallerMismatchReported content_capture_caller_mismatch_reported<br>
     * Usage: StatsLog.write(StatsLog.CONTENT_CAPTURE_CALLER_MISMATCH_REPORTED, java.lang.String intended_package, java.lang.String calling_package);<br>
     */
    public static final int CONTENT_CAPTURE_CALLER_MISMATCH_REPORTED = 206;

    /**
     * ContentCaptureServiceEvents content_capture_service_events<br>
     * Usage: StatsLog.write(StatsLog.CONTENT_CAPTURE_SERVICE_EVENTS, int event, java.lang.String service_info, java.lang.String target_info, int set_allowlist_package_count, int set_allowlist_activity_count);<br>
     */
    public static final int CONTENT_CAPTURE_SERVICE_EVENTS = 207;

    /**
     * ContentCaptureSessionEvents content_capture_session_events<br>
     * Usage: StatsLog.write(StatsLog.CONTENT_CAPTURE_SESSION_EVENTS, int session_id, int event, int state_flags, java.lang.String service_info, java.lang.String app_info, boolean is_child_session);<br>
     */
    public static final int CONTENT_CAPTURE_SESSION_EVENTS = 208;

    /**
     * ContentCaptureFlushed content_capture_flushed<br>
     * Usage: StatsLog.write(StatsLog.CONTENT_CAPTURE_FLUSHED, int session_id, java.lang.String service_info, java.lang.String app_info, int child_session_started, int child_session_finished, int view_appeared_count, int view_disappeared_count, int view_text_changed_count, int max_events, int idle_flush_freq, int text_flush_freq, int flush_reason);<br>
     */
    public static final int CONTENT_CAPTURE_FLUSHED = 209;

    /**
     * LocationManagerApiUsageReported location_manager_api_usage_reported<br>
     * Usage: StatsLog.write(StatsLog.LOCATION_MANAGER_API_USAGE_REPORTED, int state, int api_in_use, java.lang.String calling_package_name, int provider, int quality, int bucketized_interval, int bucketized_smallest_displacement, long num_updates, int bucketized_expire_in, int callback_type, int bucketized_radius, int activiy_importance, java.lang.String attribution_tag);<br>
     */
    public static final int LOCATION_MANAGER_API_USAGE_REPORTED = 210;

    /**
     * ExclusionRectStateChanged exclusion_rect_state_changed<br>
     * Usage: StatsLog.write(StatsLog.EXCLUSION_RECT_STATE_CHANGED, java.lang.String component_name, int requested_height, int rejected_height, int x_location, boolean landscape, boolean splitscreen, int duration_millis);<br>
     */
    public static final int EXCLUSION_RECT_STATE_CHANGED = 223;

    /**
     * CameraActionEvent camera_action_event<br>
     * Usage: StatsLog.write(StatsLog.CAMERA_ACTION_EVENT, long duration_millis, int api_level, java.lang.String package_name, int facing, java.lang.String camera_id, int action, boolean is_ndk, int latency_millis, int operating_mode, int internal_reconfig, long request_count, long result_error_count, boolean device_error, int stream_count, byte[] stream_1, byte[] stream_2, byte[] stream_3, byte[] stream_4, byte[] stream_5, java.lang.String user_tag, int video_stabilization_mode, long log_id, int session_idx, int ext_type, boolean ext_is_advanced);<br>
     */
    public static final int CAMERA_ACTION_EVENT = 227;

    /**
     * AppCompatibilityChangeReported app_compatibility_change_reported<br>
     * Usage: StatsLog.write(StatsLog.APP_COMPATIBILITY_CHANGE_REPORTED, int uid, long change_id, int state, int source);<br>
     */
    public static final int APP_COMPATIBILITY_CHANGE_REPORTED = 228;

    /**
     * RebootEscrowRecoveryReported reboot_escrow_recovery_reported<br>
     * Usage: StatsLog.write(StatsLog.REBOOT_ESCROW_RECOVERY_REPORTED, boolean successful, int error_code, int type, int get_escrow_key_retry_count, int duration_escrow_key_storage_to_unlock_seconds, int vbmeta_digest_status, int duration_boot_complete_to_unlock_seconds);<br>
     */
    public static final int REBOOT_ESCROW_RECOVERY_REPORTED = 238;

    /**
     * BootTimeEventDuration boot_time_event_duration_reported<br>
     * Usage: StatsLog.write(StatsLog.BOOT_TIME_EVENT_DURATION_REPORTED, int event, long duration_millis);<br>
     */
    public static final int BOOT_TIME_EVENT_DURATION_REPORTED = 239;

    /**
     * BootTimeEventElapsedTime boot_time_event_elapsed_time_reported<br>
     * Usage: StatsLog.write(StatsLog.BOOT_TIME_EVENT_ELAPSED_TIME_REPORTED, int event, long time_millis);<br>
     */
    public static final int BOOT_TIME_EVENT_ELAPSED_TIME_REPORTED = 240;

    /**
     * BootTimeEventErrorCode boot_time_event_error_code_reported<br>
     * Usage: StatsLog.write(StatsLog.BOOT_TIME_EVENT_ERROR_CODE_REPORTED, int event, int error_code);<br>
     */
    public static final int BOOT_TIME_EVENT_ERROR_CODE_REPORTED = 242;

    /**
     * UserspaceRebootReported userspace_reboot_reported<br>
     * Usage: StatsLog.write(StatsLog.USERSPACE_REBOOT_REPORTED, int outcome, long duration_millis, int user_encryption_state);<br>
     */
    public static final int USERSPACE_REBOOT_REPORTED = 243;

    /**
     * NotificationReported notification_reported<br>
     * Usage: StatsLog.write(StatsLog.NOTIFICATION_REPORTED, int event_id, int uid, java.lang.String package_name, int instance_id, int notification_id_hash, int channel_id_hash, int group_id_hash, int group_instance_id, boolean is_group_summary, java.lang.String category, int style, int num_people, int position, int importance, int alerting, int importance_source, int importance_initial, int importance_initial_source, int importance_asst, int assistant_hash, float assistant_ranking_score, boolean is_ongoing, boolean is_foreground_service, long timeout_millis, boolean is_non_dismissible, long post_duration_millis);<br>
     */
    public static final int NOTIFICATION_REPORTED = 244;

    /**
     * NotificationChannelModified notification_channel_modified<br>
     * Usage: StatsLog.write(StatsLog.NOTIFICATION_CHANNEL_MODIFIED, int event_id, int uid, java.lang.String package_name, int channel_id_hash, int old_importance, int importance, boolean is_conversation, int conversation_id_hash, boolean is_conversation_demoted, boolean is_conversation_priority);<br>
     */
    public static final int NOTIFICATION_CHANNEL_MODIFIED = 246;

    /**
     * IntegrityCheckResultReported integrity_check_result_reported<br>
     * Usage: StatsLog.write(StatsLog.INTEGRITY_CHECK_RESULT_REPORTED, java.lang.String package_name, java.lang.String app_certificate_hash, long version_code, java.lang.String installer_package_name, int response, boolean caused_by_app_cert_rule, boolean caused_by_installer_rule);<br>
     */
    public static final int INTEGRITY_CHECK_RESULT_REPORTED = 247;

    /**
     * IntegrityRulesPushed integrity_rules_pushed<br>
     * Usage: StatsLog.write(StatsLog.INTEGRITY_RULES_PUSHED, boolean success, java.lang.String rule_provider, java.lang.String rule_version);<br>
     */
    public static final int INTEGRITY_RULES_PUSHED = 248;

    /**
     * AppFreezeChanged app_freeze_changed<br>
     * Usage: StatsLog.write(StatsLog.APP_FREEZE_CHANGED, int action, int pid, java.lang.String process_name, long time_unfrozen_millis, int unfreeze_reason, int unfreeze_reason_v2);<br>
     */
    public static final int APP_FREEZE_CHANGED = 254;

    /**
     * ForegroundServiceAppOpSessionEnded foreground_service_app_op_session_ended<br>
     * Usage: StatsLog.write(StatsLog.FOREGROUND_SERVICE_APP_OP_SESSION_ENDED, int uid, int app_op_name, int app_op_mode, int count_ops_accepted, int count_ops_rejected);<br>
     */
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED = 256;

    /**
     * AppStandbyBucketChanged app_standby_bucket_changed<br>
     * Usage: StatsLog.write(StatsLog.APP_STANDBY_BUCKET_CHANGED, java.lang.String package_name, int user_id, int bucket, int main_reason, int sub_reason);<br>
     */
    public static final int APP_STANDBY_BUCKET_CHANGED = 258;

    /**
     * SharesheetStarted sharesheet_started<br>
     * Usage: StatsLog.write(StatsLog.SHARESHEET_STARTED, int event_id, java.lang.String package_name, int instance_id, java.lang.String mime_type, int num_app_provided_direct_targets, int num_app_provided_app_targets, boolean is_workprofile, int preview_type, int intent_type, int num_provided_custom_actions, boolean modify_share_action_provided);<br>
     */
    public static final int SHARESHEET_STARTED = 259;

    /**
     * RankingSelected ranking_selected<br>
     * Usage: StatsLog.write(StatsLog.RANKING_SELECTED, int event_id, java.lang.String package_name, int instance_id, int position_picked, boolean is_pinned);<br>
     */
    public static final int RANKING_SELECTED = 260;

    /**
     * PackageInstallerV2Reported package_installer_v2_reported<br>
     * Usage: StatsLog.write(StatsLog.PACKAGE_INSTALLER_V2_REPORTED, boolean is_incremental, java.lang.String package_name, long duration_millis, int return_code, long apks_size_bytes, int uid);<br>
     */
    public static final int PACKAGE_INSTALLER_V2_REPORTED = 263;

    /**
     * UserLifecycleJourneyReported user_lifecycle_journey_reported<br>
     * Usage: StatsLog.write(StatsLog.USER_LIFECYCLE_JOURNEY_REPORTED, long session_id, int journey, int origin_user, int target_user, int user_type, int user_flags, int error_code, long elapsed_time);<br>
     */
    public static final int USER_LIFECYCLE_JOURNEY_REPORTED = 264;

    /**
     * UserLifecycleEventOccurred user_lifecycle_event_occurred<br>
     * Usage: StatsLog.write(StatsLog.USER_LIFECYCLE_EVENT_OCCURRED, long session_id, int user_id, int event, int state, int error_code);<br>
     */
    public static final int USER_LIFECYCLE_EVENT_OCCURRED = 265;

    /**
     * AccessibilityShortcutReported accessibility_shortcut_reported<br>
     * Usage: StatsLog.write(StatsLog.ACCESSIBILITY_SHORTCUT_REPORTED, java.lang.String package_name, int shortcut_type, int service_status);<br>
     */
    public static final int ACCESSIBILITY_SHORTCUT_REPORTED = 266;

    /**
     * AppUsageEventOccurred app_usage_event_occurred<br>
     * Usage: StatsLog.write(StatsLog.APP_USAGE_EVENT_OCCURRED, int uid, java.lang.String package_name, java.lang.String class_name, int event_type);<br>
     */
    public static final int APP_USAGE_EVENT_OCCURRED = 269;

    /**
     * TvTunerStateChanged tv_tuner_state_changed<br>
     * Usage: StatsLog.write(StatsLog.TV_TUNER_STATE_CHANGED, int uid, int state);<br>
     */
    public static final int TV_TUNER_STATE_CHANGED = 276;

    /**
     * TvTunerDvrStatus tv_tuner_dvr_status<br>
     * Usage: StatsLog.write(StatsLog.TV_TUNER_DVR_STATUS, int uid, int type, int state, int segment_id, int overflow_underflow_count);<br>
     */
    public static final int TV_TUNER_DVR_STATUS = 279;

    /**
     * TvCasSessionOpenStatus tv_cas_session_open_status<br>
     * Usage: StatsLog.write(StatsLog.TV_CAS_SESSION_OPEN_STATUS, int uid, int cas_system_id, int state);<br>
     */
    public static final int TV_CAS_SESSION_OPEN_STATUS = 280;

    /**
     * AssistantInvocationReported assistant_invocation_reported<br>
     * Usage: StatsLog.write(StatsLog.ASSISTANT_INVOCATION_REPORTED, int event_id, int uid, java.lang.String package_name, int instance_id, int device_state, boolean assistant_handles_showing);<br>
     */
    public static final int ASSISTANT_INVOCATION_REPORTED = 281;

    /**
     * DisplayWakeReported display_wake_reported<br>
     * Usage: StatsLog.write(StatsLog.DISPLAY_WAKE_REPORTED, int wake_up_reason, int uid);<br>
     */
    public static final int DISPLAY_WAKE_REPORTED = 282;

    /**
     * BlobCommitted blob_committed<br>
     * Usage: StatsLog.write(StatsLog.BLOB_COMMITTED, int uid, long blob_id, long size, int result);<br>
     */
    public static final int BLOB_COMMITTED = 298;

    /**
     * BlobLeased blob_leased<br>
     * Usage: StatsLog.write(StatsLog.BLOB_LEASED, int uid, long blob_id, long size, int result);<br>
     */
    public static final int BLOB_LEASED = 299;

    /**
     * BlobOpened blob_opened<br>
     * Usage: StatsLog.write(StatsLog.BLOB_OPENED, int uid, long blob_id, long size, int result);<br>
     */
    public static final int BLOB_OPENED = 300;

    /**
     * UIInteractionFrameInfoReported ui_interaction_frame_info_reported<br>
     * Usage: StatsLog.write(StatsLog.UI_INTERACTION_FRAME_INFO_REPORTED, int interaction_type, long total_frames, long missed_frames, long max_frame_time_nanos, long sf_missed_frames, long app_missed_frames, long max_successive_missed_frames, int display_resolution);<br>
     */
    public static final int UI_INTERACTION_FRAME_INFO_REPORTED = 305;

    /**
     * UIActionLatencyReported ui_action_latency_reported<br>
     * Usage: StatsLog.write(StatsLog.UI_ACTION_LATENCY_REPORTED, int action, long latency_millis);<br>
     */
    public static final int UI_ACTION_LATENCY_REPORTED = 306;

    /**
     * HdmiCecActiveSourceChanged hdmi_cec_active_source_changed<br>
     * Usage: StatsLog.write(StatsLog.HDMI_CEC_ACTIVE_SOURCE_CHANGED, int active_source_logical_address, int active_source_physical_address, int local_relationship);<br>
     */
    public static final int HDMI_CEC_ACTIVE_SOURCE_CHANGED = 309;

    /**
     * HdmiCecMessageReported hdmi_cec_message_reported<br>
     * Usage: StatsLog.write(StatsLog.HDMI_CEC_MESSAGE_REPORTED, int uid, int direction, int initiator_logical_address, int destination_logical_address, int opcode, int send_message_result, int user_control_pressed_command, int feature_abort_opcode, int feature_abort_reason);<br>
     */
    public static final int HDMI_CEC_MESSAGE_REPORTED = 310;

    /**
     * TifTuneStateChanged tif_tune_changed<br>
     * Usage: StatsLog.write(StatsLog.TIF_TUNE_CHANGED, android.os.WorkSource workSource, int state, java.lang.String tif_session_id, int type, int input_id, int hdmi_port);<br>
     * Usage: StatsLog.write_non_chained(StatsLog.TIF_TUNE_CHANGED, int uid, java.lang.String tag, int state, java.lang.String tif_session_id, int type, int input_id, int hdmi_port);<br>
     */
    public static final int TIF_TUNE_CHANGED = 327;

    /**
     * AutoRotateReported auto_rotate_reported<br>
     * Usage: StatsLog.write(StatsLog.AUTO_ROTATE_REPORTED, int current_orientation, int proposed_orientation, int recommended_orientation, long recommendation_process_duration_millis);<br>
     */
    public static final int AUTO_ROTATE_REPORTED = 328;

    /**
     * DeviceRotated device_rotated<br>
     * Usage: StatsLog.write(StatsLog.DEVICE_ROTATED, long timestamp_millis, int proposed_orientation, int rotation_event_type);<br>
     */
    public static final int DEVICE_ROTATED = 333;

    /**
     * FaceDownReported face_down_reported<br>
     * Usage: StatsLog.write(StatsLog.FACE_DOWN_REPORTED, int face_down_response, long millis_since_flip, long millis_until_normal_timeout, long millis_until_next_screen_on);<br>
     */
    public static final int FACE_DOWN_REPORTED = 337;

    /**
     * RebootEscrowPreparationReported reboot_escrow_preparation_reported<br>
     * Usage: StatsLog.write(StatsLog.REBOOT_ESCROW_PREPARATION_REPORTED, int requesting_uid, int result, int requested_client_count);<br>
     */
    public static final int REBOOT_ESCROW_PREPARATION_REPORTED = 339;

    /**
     * RebootEscrowLskfCaptureReported reboot_escrow_lskf_capture_reported<br>
     * Usage: StatsLog.write(StatsLog.REBOOT_ESCROW_LSKF_CAPTURE_REPORTED, int uid_to_notify, int requested_client_count, int duration_ror_requested_to_lskf_captured_seconds);<br>
     */
    public static final int REBOOT_ESCROW_LSKF_CAPTURE_REPORTED = 340;

    /**
     * RebootEscrowRebootReported reboot_escrow_reboot_reported<br>
     * Usage: StatsLog.write(StatsLog.REBOOT_ESCROW_REBOOT_REPORTED, int error_code, int request_uid, int prepared_clients_count, int request_count, boolean slot_switch, boolean server_based, int duration_lskf_captured_to_reboot_seconds, int lskf_captured_counts);<br>
     */
    public static final int REBOOT_ESCROW_REBOOT_REPORTED = 341;

    /**
     * BinderLatencyReported binder_latency_reported<br>
     * Usage: StatsLog.write(StatsLog.BINDER_LATENCY_REPORTED, byte[] repeated_api_stats, float sampling_rate, int sharding_modulo, int bucket_count, int first_bucket_size, float scale_factor);<br>
     */
    public static final int BINDER_LATENCY_REPORTED = 342;

    /**
     * MagnificationUsageReported magnification_usage_reported<br>
     * Usage: StatsLog.write(StatsLog.MAGNIFICATION_USAGE_REPORTED, int activated_mode, long duration_millis, long scale_percentage);<br>
     */
    public static final int MAGNIFICATION_USAGE_REPORTED = 345;

    /**
     * MagnificationModeWithImeOnReported magnification_mode_with_ime_on_reported<br>
     * Usage: StatsLog.write(StatsLog.MAGNIFICATION_MODE_WITH_IME_ON_REPORTED, int activated_mode);<br>
     */
    public static final int MAGNIFICATION_MODE_WITH_IME_ON_REPORTED = 346;

    /**
     * DeviceStateChanged device_state_changed<br>
     * Usage: StatsLog.write(StatsLog.DEVICE_STATE_CHANGED, int new_device_state, boolean boot_state);<br>
     */
    public static final int DEVICE_STATE_CHANGED = 350;

    /**
     * InputDeviceRegistered inputdevice_registered<br>
     * Usage: StatsLog.write(StatsLog.INPUTDEVICE_REGISTERED, java.lang.String name, int vendor_id, int product_id, int version_id, int bus_id, java.lang.String obfuscated_id, int device_classes);<br>
     */
    public static final int INPUTDEVICE_REGISTERED = 351;

    /**
     * AuthPromptAuthenticateInvoked auth_prompt_authenticate_invoked<br>
     * Usage: StatsLog.write(StatsLog.AUTH_PROMPT_AUTHENTICATE_INVOKED, boolean is_crypto, boolean is_confirmation_required, boolean is_credential_allowed, boolean is_allowed_authenticators_set, int allowed_authenticators);<br>
     */
    public static final int AUTH_PROMPT_AUTHENTICATE_INVOKED = 353;

    /**
     * AuthManagerCanAuthenticateInvoked auth_manager_can_authenticate_invoked<br>
     * Usage: StatsLog.write(StatsLog.AUTH_MANAGER_CAN_AUTHENTICATE_INVOKED, boolean is_allowed_authenticators_set, int allowed_authenticators, int result_code);<br>
     */
    public static final int AUTH_MANAGER_CAN_AUTHENTICATE_INVOKED = 354;

    /**
     * AuthEnrollActionInvoked auth_enroll_action_invoked<br>
     * Usage: StatsLog.write(StatsLog.AUTH_ENROLL_ACTION_INVOKED, boolean is_strong_biometric_enrolled, boolean is_weak_biometric_enrolled, boolean is_device_credential_enrolled, boolean is_allowed_authenticators_set, int allowed_authenticators);<br>
     */
    public static final int AUTH_ENROLL_ACTION_INVOKED = 355;

    /**
     * AuthDeprecatedAPIUsed auth_deprecated_api_used<br>
     * Usage: StatsLog.write(StatsLog.AUTH_DEPRECATED_API_USED, int deprecated_api, int app_uid, int target_sdk);<br>
     */
    public static final int AUTH_DEPRECATED_API_USED = 356;

    /**
     * LocationTimeZoneProviderStateChanged location_time_zone_provider_state_changed<br>
     * Usage: StatsLog.write(StatsLog.LOCATION_TIME_ZONE_PROVIDER_STATE_CHANGED, int provider_index, int state);<br>
     */
    public static final int LOCATION_TIME_ZONE_PROVIDER_STATE_CHANGED = 359;

    /**
     * FdtrackEventOccurred fdtrack_event_occurred<br>
     * Usage: StatsLog.write(StatsLog.FDTRACK_EVENT_OCCURRED, int event, int fd_count);<br>
     */
    public static final int FDTRACK_EVENT_OCCURRED = 364;

    /**
     * TimeoutAutoExtendedReported timeout_auto_extended_reported<br>
     * Usage: StatsLog.write(StatsLog.TIMEOUT_AUTO_EXTENDED_REPORTED, int outcome, long time_to_outcome_millis, long time_to_first_interaction_millis);<br>
     */
    public static final int TIMEOUT_AUTO_EXTENDED_REPORTED = 365;

    /**
     * AlarmBatchDelivered alarm_batch_delivered<br>
     * Usage: StatsLog.write(StatsLog.ALARM_BATCH_DELIVERED, int num_alarms, int wakeups, int[] uids, int[] num_alarms_per_uid, int[] num_wakeups_per_uid);<br>
     */
    public static final int ALARM_BATCH_DELIVERED = 367;

    /**
     * AlarmScheduled alarm_scheduled<br>
     * Usage: StatsLog.write(StatsLog.ALARM_SCHEDULED, int calling_uid, boolean is_exact, boolean is_wakeup, boolean is_allow_while_idle, boolean is_alarm_clock, boolean is_repeating, int exact_alarm_allowed_reason, boolean is_rtc, int calling_process_state);<br>
     */
    public static final int ALARM_SCHEDULED = 368;

    /**
     * UserLevelHibernationStateChanged user_level_hibernation_state_changed<br>
     * Usage: StatsLog.write(StatsLog.USER_LEVEL_HIBERNATION_STATE_CHANGED, java.lang.String package_name, int user_id, boolean is_hibernating);<br>
     */
    public static final int USER_LEVEL_HIBERNATION_STATE_CHANGED = 370;

    /**
     * AppProcessDied app_process_died<br>
     * Usage: StatsLog.write(StatsLog.APP_PROCESS_DIED, int uid, java.lang.String process_name, int reason, int sub_reason, int importance, int pss, int rss, boolean has_foreground_services);<br>
     */
    public static final int APP_PROCESS_DIED = 373;

    /**
     * ANROccurredProcessingStarted anr_occurred_processing_started<br>
     * Usage: StatsLog.write(StatsLog.ANR_OCCURRED_PROCESSING_STARTED, java.lang.String process_name);<br>
     */
    public static final int ANR_OCCURRED_PROCESSING_STARTED = 376;

    /**
     * MediaCodecReported media_codec_reported<br>
     * Usage: StatsLog.write(StatsLog.MEDIA_CODEC_REPORTED, long timestamp_nanos, java.lang.String package_name, long package_version_code, long media_apex_version, java.lang.String codec, java.lang.String mime, java.lang.String mode, int encoder, int secure, int width, int height, int rotation, int crypto, int profile, int level, int max_width, int max_height, int error_code, java.lang.String error_state, long latency_max, long latency_min, long latency_avg, long latency_count, long latency_unknown, int queue_input_buffer_error, int queue_secure_input_buffer_error, java.lang.String bitrate_mode, int bitrate, long lifetime_millis, long playback_duration_seconds, java.lang.String log_session_id, int channel_count, int sample_rate, long video_encode_bytes, long video_encode_frames, long video_input_bytes, long video_input_frames, long video_encode_duration_us, int color_format, float frame_rate, float capture_rate, float operating_rate, int priority, int video_qp_i_min, int video_qp_i_max, int video_qp_p_min, int video_qp_p_max, int video_qp_b_min, int video_qp_b_max, int original_bitrate, int shaping_enhanced, int original_video_qp_i_min, int original_video_qp_i_max, int original_video_qp_p_min, int original_video_qp_p_max, int original_video_qp_b_min, int original_video_qp_b_max, int config_color_standard, int config_color_range, int config_color_transfer, int parsed_color_standard, int parsed_color_range, int parsed_color_transfer, int hdr_static_info, int hdr10_plus_info, int hdr_format, long codec_id, int array_mode, int operation_mode, int output_surface, int app_max_input_size, int used_max_input_size, int codec_max_input_size, int flush_count, int set_surface_count, int resolution_change_count, int component_color_format);<br>
     */
    public static final int MEDIA_CODEC_REPORTED = 378;

    /**
     * PrivacySensorToggleInteraction privacy_sensor_toggle_interaction<br>
     * Usage: StatsLog.write(StatsLog.PRIVACY_SENSOR_TOGGLE_INTERACTION, int sensor, int action, int source, long time_in_previous_state_in_mins);<br>
     */
    public static final int PRIVACY_SENSOR_TOGGLE_INTERACTION = 381;

    /**
     * PrivacyToggleDialogInteraction privacy_toggle_dialog_interaction<br>
     * Usage: StatsLog.write(StatsLog.PRIVACY_TOGGLE_DIALOG_INTERACTION, int action, java.lang.String package_name);<br>
     */
    public static final int PRIVACY_TOGGLE_DIALOG_INTERACTION = 382;

    /**
     * NonA11yToolServiceWarningReported non_a11y_tool_service_warning_report<br>
     * Usage: StatsLog.write(StatsLog.NON_A11Y_TOOL_SERVICE_WARNING_REPORT, java.lang.String package_name, int status, long duration_millis);<br>
     */
    public static final int NON_A11Y_TOOL_SERVICE_WARNING_REPORT = 384;

    /**
     * AppCompatStateChanged app_compat_state_changed<br>
     * Usage: StatsLog.write(StatsLog.APP_COMPAT_STATE_CHANGED, int uid, int state, int letterbox_position);<br>
     */
    public static final int APP_COMPAT_STATE_CHANGED = 386;

    /**
     * SizeCompatRestartButtonEventReported size_compat_restart_button_event_reported<br>
     * Usage: StatsLog.write(StatsLog.SIZE_COMPAT_RESTART_BUTTON_EVENT_REPORTED, int uid, int event);<br>
     */
    public static final int SIZE_COMPAT_RESTART_BUTTON_EVENT_REPORTED = 387;

    /**
     * SplitscreenUIChanged splitscreen_ui_changed<br>
     * Usage: StatsLog.write(StatsLog.SPLITSCREEN_UI_CHANGED, int action, int enter_reason, int exit_reason, float split_ratio, int main_stage_position, int main_stage_uid, int side_stage_position, int side_stage_uid, int drag_instance_id, int instance_id);<br>
     */
    public static final int SPLITSCREEN_UI_CHANGED = 388;

    /**
     * ClipboardCleared clipboard_cleared<br>
     * Usage: StatsLog.write(StatsLog.CLIPBOARD_CLEARED, int source);<br>
     */
    public static final int CLIPBOARD_CLEARED = 408;

    /**
     * CameraCompatControlEventReported camera_compat_control_event_reported<br>
     * Usage: StatsLog.write(StatsLog.CAMERA_COMPAT_CONTROL_EVENT_REPORTED, int uid, int event);<br>
     */
    public static final int CAMERA_COMPAT_CONTROL_EVENT_REPORTED = 411;

    /**
     * ApplicationLocalesChanged application_locales_changed<br>
     * Usage: StatsLog.write(StatsLog.APPLICATION_LOCALES_CHANGED, int calling_uid, int target_uid, java.lang.String new_locales, java.lang.String prev_locales, int status, int caller);<br>
     */
    public static final int APPLICATION_LOCALES_CHANGED = 412;

    /**
     * FoldStateDurationReported fold_state_duration_reported<br>
     * Usage: StatsLog.write(StatsLog.FOLD_STATE_DURATION_REPORTED, int start_state, int end_state, long duration_millis);<br>
     */
    public static final int FOLD_STATE_DURATION_REPORTED = 414;

    /**
     * LocationTimeZoneProviderControllerStateChanged location_time_zone_provider_controller_state_changed<br>
     * Usage: StatsLog.write(StatsLog.LOCATION_TIME_ZONE_PROVIDER_CONTROLLER_STATE_CHANGED, int state);<br>
     */
    public static final int LOCATION_TIME_ZONE_PROVIDER_CONTROLLER_STATE_CHANGED = 415;

    /**
     * DisplayHbmStateChanged display_hbm_state_changed<br>
     * Usage: StatsLog.write(StatsLog.DISPLAY_HBM_STATE_CHANGED, int display_id, int state, int reason);<br>
     */
    public static final int DISPLAY_HBM_STATE_CHANGED = 416;

    /**
     * DisplayHbmBrightnessChanged display_hbm_brightness_changed<br>
     * Usage: StatsLog.write(StatsLog.DISPLAY_HBM_BRIGHTNESS_CHANGED, int display_id, float brightness);<br>
     */
    public static final int DISPLAY_HBM_BRIGHTNESS_CHANGED = 417;

    /**
     * PersistentUriPermissionsFlushed persistent_uri_permissions_flushed<br>
     * Usage: StatsLog.write(StatsLog.PERSISTENT_URI_PERMISSIONS_FLUSHED, int permissions_flushed_amount);<br>
     */
    public static final int PERSISTENT_URI_PERMISSIONS_FLUSHED = 418;

    /**
     * VBMetaDigestReported vbmeta_digest_reported<br>
     * Usage: StatsLog.write(StatsLog.VBMETA_DIGEST_REPORTED, java.lang.String vbmeta_digest);<br>
     */
    public static final int VBMETA_DIGEST_REPORTED = 420;

    /**
     * ApexInfoGathered apex_info_gathered<br>
     * Usage: StatsLog.write(StatsLog.APEX_INFO_GATHERED, java.lang.String package_name, long version_code, java.lang.String content_digest, int algo_type, java.lang.String[] signer_sha256_digest);<br>
     */
    public static final int APEX_INFO_GATHERED = 421;

    /**
     * PvmInfoGathered pvm_info_gathered<br>
     * Usage: StatsLog.write(StatsLog.PVM_INFO_GATHERED, java.lang.String name, long version, java.lang.String sha256_digest);<br>
     */
    public static final int PVM_INFO_GATHERED = 422;

    /**
     * TracingServiceReportEvent tracing_service_report_event<br>
     * Usage: StatsLog.write(StatsLog.TRACING_SERVICE_REPORT_EVENT, int event, long trace_uuid_lsb, long trace_uuid_msb);<br>
     */
    public static final int TRACING_SERVICE_REPORT_EVENT = 424;

    /**
     * DropboxEntryDropped dropbox_entry_dropped<br>
     * Usage: StatsLog.write(StatsLog.DROPBOX_ENTRY_DROPPED, int drop_reason, java.lang.String tag, long age_millis);<br>
     */
    public static final int DROPBOX_ENTRY_DROPPED = 427;

    /**
     * GameStateChanged game_state_changed<br>
     * Usage: StatsLog.write(StatsLog.GAME_STATE_CHANGED, java.lang.String package_name, int uid, boolean boost_enabled, int state, boolean is_loading, int label, int quality);<br>
     */
    public static final int GAME_STATE_CHANGED = 429;

    /**
     * HotwordDetectorCreateRequested hotword_detector_create_requested<br>
     * Usage: StatsLog.write(StatsLog.HOTWORD_DETECTOR_CREATE_REQUESTED, int detector_type, boolean is_created_done, int uid);<br>
     */
    public static final int HOTWORD_DETECTOR_CREATE_REQUESTED = 430;

    /**
     * HotwordDetectionServiceInitResultReported hotword_detection_service_init_result_reported<br>
     * Usage: StatsLog.write(StatsLog.HOTWORD_DETECTION_SERVICE_INIT_RESULT_REPORTED, int detector_type, int result, int uid);<br>
     */
    public static final int HOTWORD_DETECTION_SERVICE_INIT_RESULT_REPORTED = 431;

    /**
     * HotwordDetectionServiceRestarted hotword_detection_service_restarted<br>
     * Usage: StatsLog.write(StatsLog.HOTWORD_DETECTION_SERVICE_RESTARTED, int detector_type, int reason, int uid);<br>
     */
    public static final int HOTWORD_DETECTION_SERVICE_RESTARTED = 432;

    /**
     * HotwordDetectorKeyphraseTriggered hotword_detector_keyphrase_triggered<br>
     * Usage: StatsLog.write(StatsLog.HOTWORD_DETECTOR_KEYPHRASE_TRIGGERED, int detector_type, int result, int uid);<br>
     */
    public static final int HOTWORD_DETECTOR_KEYPHRASE_TRIGGERED = 433;

    /**
     * HotwordDetectorEvents hotword_detector_events<br>
     * Usage: StatsLog.write(StatsLog.HOTWORD_DETECTOR_EVENTS, int detector_type, int event, int uid);<br>
     */
    public static final int HOTWORD_DETECTOR_EVENTS = 434;

    /**
     * BootCompletedBroadcastCompletionLatencyReported boot_completed_broadcast_completion_latency_reported<br>
     * Usage: StatsLog.write(StatsLog.BOOT_COMPLETED_BROADCAST_COMPLETION_LATENCY_REPORTED, int event, int dispatch_latency_uptime_millis, int complete_latency_uptime_millis, int dispatch_latency_realtime_millis, int complete_latency_realtime_millis, int user_id, int user_type);<br>
     */
    public static final int BOOT_COMPLETED_BROADCAST_COMPLETION_LATENCY_REPORTED = 437;

    /**
     * AppBackgroundRestrictionsInfo app_background_restrictions_info<br>
     * Usage: StatsLog.write(StatsLog.APP_BACKGROUND_RESTRICTIONS_INFO, int uid, int restriction_level, int threshold, int tracker, byte[] fgs_tracker_info, byte[] battery_tracker_info, byte[] broadcast_events_tracker_info, byte[] bind_service_events_tracker_info, int exemption_reason, int opt_level, int target_sdk, boolean low_mem_device, int previous_restriction_level);<br>
     */
    public static final int APP_BACKGROUND_RESTRICTIONS_INFO = 441;

    /**
     * GnssPsdsDownloadReported gnss_psds_download_reported<br>
     * Usage: StatsLog.write(StatsLog.GNSS_PSDS_DOWNLOAD_REPORTED, int psds_type);<br>
     */
    public static final int GNSS_PSDS_DOWNLOAD_REPORTED = 446;

    /**
     * DreamUiEventReported dream_ui_event_reported<br>
     * Usage: StatsLog.write(StatsLog.DREAM_UI_EVENT_REPORTED, int uid, int event_id, int instance_id, java.lang.String dream_component_name);<br>
     */
    public static final int DREAM_UI_EVENT_REPORTED = 449;

    /**
     * CdmAssociationAction cdm_association_action<br>
     * Usage: StatsLog.write(StatsLog.CDM_ASSOCIATION_ACTION, int action, int device_profile);<br>
     */
    public static final int CDM_ASSOCIATION_ACTION = 451;

    /**
     * MagnificationTripleTapAndHoldActivatedSessionReported magnification_triple_tap_and_hold_activated_session_reported<br>
     * Usage: StatsLog.write(StatsLog.MAGNIFICATION_TRIPLE_TAP_AND_HOLD_ACTIVATED_SESSION_REPORTED, long duration_millis);<br>
     */
    public static final int MAGNIFICATION_TRIPLE_TAP_AND_HOLD_ACTIVATED_SESSION_REPORTED = 452;

    /**
     * MagnificationFollowTypingFocusActivatedSessionReported magnification_follow_typing_focus_activated_session_reported<br>
     * Usage: StatsLog.write(StatsLog.MAGNIFICATION_FOLLOW_TYPING_FOCUS_ACTIVATED_SESSION_REPORTED, long duration_millis);<br>
     */
    public static final int MAGNIFICATION_FOLLOW_TYPING_FOCUS_ACTIVATED_SESSION_REPORTED = 453;

    /**
     * SystemServerPreWatchdogOccurred system_server_pre_watchdog_occurred<br>
     * Usage: StatsLog.write(StatsLog.SYSTEM_SERVER_PRE_WATCHDOG_OCCURRED);<br>
     */
    public static final int SYSTEM_SERVER_PRE_WATCHDOG_OCCURRED = 460;

    /**
     * LetterboxPositionChanged letterbox_position_changed<br>
     * Usage: StatsLog.write(StatsLog.LETTERBOX_POSITION_CHANGED, int uid, int position_change);<br>
     */
    public static final int LETTERBOX_POSITION_CHANGED = 462;

    /**
     * SyncExemptionOccurred sync_exemption_occurred<br>
     * Usage: StatsLog.write(StatsLog.SYNC_EXEMPTION_OCCURRED, int uid, int proc_state, boolean is_uid_active, int restriction_level);<br>
     */
    public static final int SYNC_EXEMPTION_OCCURRED = 468;

    /**
     * AutofillPresentationEventReported autofill_presentation_event_reported<br>
     * Usage: StatsLog.write(StatsLog.AUTOFILL_PRESENTATION_EVENT_REPORTED, int request_id, int session_id, int presentation_event_result, int available_count, int count_shown, int count_filtered_user_typing, int count_not_shown_unused_by_ime, int count_not_shown_never_visible, int display_presentation_type, int autofill_service_uid, int inline_suggestion_host_uid, boolean is_request_triggered, int fill_request_sent_timestamp_ms, int fill_response_received_timestamp_ms, int suggestion_sent_timestamp_ms, int suggestion_presented_timestamp_ms, int selected_dataset_id, boolean dialog_dismissed, boolean negative_cta_button_clicked, boolean positive_cta_button_clicked, int authentication_type, int authentication_result, long latency_authentication_ui_display_millis, long latency_dataset_display_millis, int available_pcc_count, int available_pcc_only_count, int selected_dataset_picked_reason, int detection_preference);<br>
     */
    public static final int AUTOFILL_PRESENTATION_EVENT_REPORTED = 469;

    /**
     * DockStateChanged dock_state_changed<br>
     * Usage: StatsLog.write(StatsLog.DOCK_STATE_CHANGED, int state);<br>
     */
    public static final int DOCK_STATE_CHANGED = 470;

    /**
     * SettingsProviderSettingChanged settings_provider_setting_changed<br>
     * Usage: StatsLog.write(StatsLog.SETTINGS_PROVIDER_SETTING_CHANGED, int user_id, java.lang.String name, int type, int change_type);<br>
     */
    public static final int SETTINGS_PROVIDER_SETTING_CHANGED = 474;

    /**
     * BroadcastDeliveryEventReported broadcast_delivery_event_reported<br>
     * Usage: StatsLog.write(StatsLog.BROADCAST_DELIVERY_EVENT_REPORTED, int uid, int sender_uid, java.lang.String action_name, int receiver_type, int proc_start_type, long dispatch_delay, long receive_delay, long finish_delay, int package_stopped_state, java.lang.String package_name, java.lang.String sender_package_name);<br>
     */
    public static final int BROADCAST_DELIVERY_EVENT_REPORTED = 475;

    /**
     * ServiceRequestEventReported service_request_event_reported<br>
     * Usage: StatsLog.write(StatsLog.SERVICE_REQUEST_EVENT_REPORTED, int uid, int requester_uid, java.lang.String action_name, int request_type, boolean fg_required, int proc_start_type, java.lang.String request_process_name, java.lang.String service_component_name, int package_stopped_state, java.lang.String package_name, java.lang.String requester_package_name);<br>
     */
    public static final int SERVICE_REQUEST_EVENT_REPORTED = 476;

    /**
     * ProviderAcquisitionEventReported provider_acquisition_event_reported<br>
     * Usage: StatsLog.write(StatsLog.PROVIDER_ACQUISITION_EVENT_REPORTED, int uid, int client_uid, int proc_start_type, int package_stopped_state, java.lang.String package_name, java.lang.String client_package_name);<br>
     */
    public static final int PROVIDER_ACQUISITION_EVENT_REPORTED = 477;

    /**
     * VibrationReported vibration_reported<br>
     * Usage: StatsLog.write(StatsLog.VIBRATION_REPORTED, android.os.WorkSource workSource, int vibration_type, int vibration_usage, int vibration_status, boolean ended_by_same_uid, int ended_by_usage, int interrupted_usage, int repeat_count, long vibration_duration_millis, long vibrator_on_duration_millis, long start_latency_millis, long end_latency_millis, int hal_compose_count, int hal_compose_pwle_count, int hal_on_count, int hal_off_count, int hal_perform_count, int hal_set_amplitude_count, int hal_set_external_control_count, int[] hal_supported_composition_primitives_used, int[] hal_supported_effects_used, int[] hal_unsupported_composition_primitives_used, int[] hal_unsupported_effects_used, int hal_composition_size, int hal_pwle_size);<br>
     * Usage: StatsLog.write_non_chained(StatsLog.VIBRATION_REPORTED, int uid, java.lang.String tag, int vibration_type, int vibration_usage, int vibration_status, boolean ended_by_same_uid, int ended_by_usage, int interrupted_usage, int repeat_count, long vibration_duration_millis, long vibrator_on_duration_millis, long start_latency_millis, long end_latency_millis, int hal_compose_count, int hal_compose_pwle_count, int hal_on_count, int hal_off_count, int hal_perform_count, int hal_set_amplitude_count, int hal_set_external_control_count, int[] hal_supported_composition_primitives_used, int[] hal_supported_effects_used, int[] hal_unsupported_composition_primitives_used, int[] hal_unsupported_effects_used, int hal_composition_size, int hal_pwle_size);<br>
     */
    public static final int VIBRATION_REPORTED = 487;

    /**
     * AppCompactedV2 app_compacted_v2<br>
     * Usage: StatsLog.write(StatsLog.APP_COMPACTED_V2, int uid, int proc_state, int current_oom_adj, long delta_anon_rss, long zram_consumed, float compact_cpu_time, long original_anon_rss, int oom_change_reason);<br>
     */
    public static final int APP_COMPACTED_V2 = 491;

    /**
     * DisplayBrightnessChanged display_brightness_changed<br>
     * Usage: StatsLog.write(StatsLog.DISPLAY_BRIGHTNESS_CHANGED, float initial_nits, float end_nits, float lux, java.lang.String physical_display_id, boolean short_term_model_active, float power_brightness_factor, int reduce_bright_colors_strength, float hbm_current_max, float thermal_throttling_cap, boolean adaptive_brightness_enabled, int reason, int entire_reason, int bucket_index, boolean brightness_at_max, boolean hbm_mode_sunlight, boolean hbm_mode_hdr, boolean modified_by_low_power_mode, int throttling_reason, boolean modified_by_dimming, boolean rbc_enabled, boolean ambient_lux_invalid, boolean doze_scale_applied, boolean set_by_user, boolean idle_mode_active, boolean low_power_mode_enabled);<br>
     */
    public static final int DISPLAY_BRIGHTNESS_CHANGED = 494;

    /**
     * ActivityActionBlocked activity_action_blocked<br>
     * Usage: StatsLog.write(StatsLog.ACTIVITY_ACTION_BLOCKED, int caller_uid, java.lang.String caller_activity_class_name, int target_task_top_activity_uid, java.lang.String target_task_top_activity_class_name, boolean target_task_is_different, int target_activity_uid, java.lang.String target_activity_class_name, java.lang.String target_intent_action, int target_intent_flags, int action, int version, boolean multi_window, int bal_code);<br>
     */
    public static final int ACTIVITY_ACTION_BLOCKED = 495;

    /**
     * AmbientBrightnessStatsReported ambient_brightness_stats_reported<br>
     * Usage: StatsLog.write(StatsLog.AMBIENT_BRIGHTNESS_STATS_REPORTED, float[] bucket_size_seconds, float[] bucket_boundary_lux);<br>
     */
    public static final int AMBIENT_BRIGHTNESS_STATS_REPORTED = 507;

    /**
     * HearingAidInfoReported hearing_aid_info_reported<br>
     * Usage: StatsLog.write(StatsLog.HEARING_AID_INFO_REPORTED, int device_mode, int device_side, int bond_entry);<br>
     */
    public static final int HEARING_AID_INFO_REPORTED = 513;

    /**
     * DeviceWideJobConstraintChanged device_wide_job_constraint_changed<br>
     * Usage: StatsLog.write(StatsLog.DEVICE_WIDE_JOB_CONSTRAINT_CHANGED, int constraint, int state);<br>
     */
    public static final int DEVICE_WIDE_JOB_CONSTRAINT_CHANGED = 514;

    /**
     * AmbientModeChanged ambient_mode_changed<br>
     * Usage: StatsLog.write(StatsLog.AMBIENT_MODE_CHANGED, int state);<br>
     */
    public static final int AMBIENT_MODE_CHANGED = 515;

    /**
     * ANRLatencyReported anr_latency_reported<br>
     * Usage: StatsLog.write(StatsLog.ANR_LATENCY_REPORTED, long total_duration, long triggering_to_stack_dump_duration, long triggering_to_app_not_responding_duration, long app_not_responding_duration, long anr_record_placed_on_queue_duration, long anr_processing_duration, long dump_stack_traces_duration, long update_cpu_stats_now_total_duration, long current_psi_state_total_duration, long process_cpu_tracker_methods_total_duration, long critical_event_log_duration, long global_lock_total_contention, long pid_lock_total_contention, long ams_lock_total_contention, long proc_lock_total_contention, long anr_record_lock_total_contention, int anr_queue_size_when_pushed, int anr_type, int dumped_processes_count);<br>
     */
    public static final int ANR_LATENCY_REPORTED = 516;

    /**
     * ResourceValueApiStatisticsReported resource_api_info<br>
     * Usage: StatsLog.write(StatsLog.RESOURCE_API_INFO, int api, int event_count, long cumulative_event_time_ns, int p50_ns, int p90_ns, int p95_ns, int p99_ns, int l0_ns, int l1_ns, int l2_ns, int l3_ns, int l4_ns);<br>
     */
    public static final int RESOURCE_API_INFO = 517;

    /**
     * PackageInstallationSessionReported package_installation_session_reported<br>
     * Usage: StatsLog.write(StatsLog.PACKAGE_INSTALLATION_SESSION_REPORTED, int session_id, java.lang.String package_name, int uid, int[] user_ids, int[] user_types, int[] original_user_ids, int[] original_user_types, int public_return_code, int internal_error_code, long apks_size_bytes, long version_code, int[] install_steps, long[] step_duration_millis, long total_duration_millis, int install_flags, int installer_package_uid, int original_installer_package_uid, int data_loader_type, int user_action_required_type, boolean is_instant, boolean is_replace, boolean is_system, boolean is_inherit, boolean is_installing_existing_as_user, boolean is_move_install, boolean is_staged);<br>
     */
    public static final int PACKAGE_INSTALLATION_SESSION_REPORTED = 524;

    /**
     * ExpressEventReported express_event_reported<br>
     * Usage: StatsLog.write(StatsLog.EXPRESS_EVENT_REPORTED, long metric_id, long value);<br>
     */
    public static final int EXPRESS_EVENT_REPORTED = 528;

    /**
     * BrightnessConfigurationUpdated brightness_configuration_updated<br>
     * Usage: StatsLog.write(StatsLog.BRIGHTNESS_CONFIGURATION_UPDATED, float[] lux, float[] nits, java.lang.String physical_display_id);<br>
     */
    public static final int BRIGHTNESS_CONFIGURATION_UPDATED = 534;

    /**
     * PackageManagerSnapshotReported package_manager_snapshot_reported<br>
     * Usage: StatsLog.write(StatsLog.PACKAGE_MANAGER_SNAPSHOT_REPORTED, int[] rebuild_latency_buckets, int[] reuse_count_buckets, long max_rebuild_latency_us, int max_reuse_count, long rebuild_latency_us_avg, int reuse_count_avg, int packages_count);<br>
     */
    public static final int PACKAGE_MANAGER_SNAPSHOT_REPORTED = 544;

    /**
     * PackageManagerAppsFilterCacheBuildReported package_manager_apps_filter_cache_build_reported<br>
     * Usage: StatsLog.write(StatsLog.PACKAGE_MANAGER_APPS_FILTER_CACHE_BUILD_REPORTED, int event_type, long build_cache_latency_us, int user_count, int packages_count, int cache_size_bytes);<br>
     */
    public static final int PACKAGE_MANAGER_APPS_FILTER_CACHE_BUILD_REPORTED = 545;

    /**
     * PackageManagerAppsFilterCacheUpdateReported package_manager_apps_filter_cache_update_reported<br>
     * Usage: StatsLog.write(StatsLog.PACKAGE_MANAGER_APPS_FILTER_CACHE_UPDATE_REPORTED, int event_type, int uid, long update_cache_latency_us, int user_count, int packages_count, int cache_size_bytes);<br>
     */
    public static final int PACKAGE_MANAGER_APPS_FILTER_CACHE_UPDATE_REPORTED = 546;

    /**
     * PackageUninstallationReported package_uninstallation_reported<br>
     * Usage: StatsLog.write(StatsLog.PACKAGE_UNINSTALLATION_REPORTED, int uid, int[] user_ids, int[] user_types, int[] original_user_ids, int[] original_user_types, int uninstall_flags, int return_code, boolean is_system, boolean is_uninstall_for_users);<br>
     */
    public static final int PACKAGE_UNINSTALLATION_REPORTED = 554;

    /**
     * GameModeChanged game_mode_changed<br>
     * Usage: StatsLog.write(StatsLog.GAME_MODE_CHANGED, int game_uid, int caller_uid, int game_mode_from, int game_mode_to);<br>
     */
    public static final int GAME_MODE_CHANGED = 555;

    /**
     * GameModeConfigurationChanged game_mode_configuration_changed<br>
     * Usage: StatsLog.write(StatsLog.GAME_MODE_CONFIGURATION_CHANGED, int game_uid, int caller_uid, int game_mode, float scaling_factor_from, float scaling_factor_to, int fps_override_from, int fps_override_to);<br>
     */
    public static final int GAME_MODE_CONFIGURATION_CHANGED = 556;

    /**
     * BedtimeModeStateChanged bedtime_mode_state_changed<br>
     * Usage: StatsLog.write(StatsLog.BEDTIME_MODE_STATE_CHANGED, int bedtime_mode_state, int current_wifi_state, int current_cellular_state, int current_bluetooth_state, int battery_level);<br>
     */
    public static final int BEDTIME_MODE_STATE_CHANGED = 557;

    /**
     * GetTypeAccessedWithoutPermission get_type_accessed_without_permission<br>
     * Usage: StatsLog.write(StatsLog.GET_TYPE_ACCESSED_WITHOUT_PERMISSION, int location, int calling_uid, java.lang.String provider, java.lang.String type);<br>
     */
    public static final int GET_TYPE_ACCESSED_WITHOUT_PERMISSION = 564;

    /**
     * MobileBundledAppInfoGathered mobile_bundled_app_info_gathered<br>
     * Usage: StatsLog.write(StatsLog.MOBILE_BUNDLED_APP_INFO_GATHERED, java.lang.String package_name, long version_code, java.lang.String content_digest, int algo_type, java.lang.String[] signer_sha256_digest, int mba_status, java.lang.String initiator, java.lang.String[] initiator_signer_sha256_digest, java.lang.String installer, java.lang.String originator, java.lang.String split_name);<br>
     */
    public static final int MOBILE_BUNDLED_APP_INFO_GATHERED = 566;

    /**
     * UnsafeIntentEventReported unsafe_intent_event_reported<br>
     * Usage: StatsLog.write(StatsLog.UNSAFE_INTENT_EVENT_REPORTED, int event_type, int calling_uid, java.lang.String component_name, java.lang.String package_name, java.lang.String action, java.lang.String[] categories, java.lang.String data_type, java.lang.String data_scheme, boolean is_blocked);<br>
     */
    public static final int UNSAFE_INTENT_EVENT_REPORTED = 573;

    /**
     * PerformanceHintSessionReported performance_hint_session_reported<br>
     * Usage: StatsLog.write(StatsLog.PERFORMANCE_HINT_SESSION_REPORTED, int package_uid, long session_id, long target_duration_ns, int tid_count);<br>
     */
    public static final int PERFORMANCE_HINT_SESSION_REPORTED = 574;

    /**
     * HotwordAudioEgressEventReported hotword_audio_egress_event_reported<br>
     * Usage: StatsLog.write(StatsLog.HOTWORD_AUDIO_EGRESS_EVENT_REPORTED, int detector_type, int event, int uid, int egressed_stream_size_bytes, int egressed_metadata_bundle_size_bytes, int stream_count);<br>
     */
    public static final int HOTWORD_AUDIO_EGRESS_EVENT_REPORTED = 578;

    /**
     * LocationEnabledStateChanged location_enabled_state_changed<br>
     * Usage: StatsLog.write(StatsLog.LOCATION_ENABLED_STATE_CHANGED, boolean location_enabled);<br>
     */
    public static final int LOCATION_ENABLED_STATE_CHANGED = 580;

    /**
     * ImeRequestFinished ime_request_finished<br>
     * Usage: StatsLog.write(StatsLog.IME_REQUEST_FINISHED, int requester_uid, long duration_millis, int type, int status, int reason, int origin, int phase);<br>
     */
    public static final int IME_REQUEST_FINISHED = 581;

    /**
     * UsbComplianceWarningsReported usb_compliance_warnings_reported<br>
     * Usage: StatsLog.write(StatsLog.USB_COMPLIANCE_WARNINGS_REPORTED, java.lang.String id, int[] compliance_warnings);<br>
     */
    public static final int USB_COMPLIANCE_WARNINGS_REPORTED = 582;

    /**
     * AppSupportedLocalesChanged app_supported_locales_changed<br>
     * Usage: StatsLog.write(StatsLog.APP_SUPPORTED_LOCALES_CHANGED, int calling_uid, int target_uid, int num_locales, boolean remove_override, boolean same_as_resource_localeconfig, boolean same_as_previous_localeconfig, int status);<br>
     */
    public static final int APP_SUPPORTED_LOCALES_CHANGED = 583;

    /**
     * ApplicationGrammaticalInflectionChanged grammatical_inflection_changed<br>
     * Usage: StatsLog.write(StatsLog.GRAMMATICAL_INFLECTION_CHANGED, int source_id, int target_uid, boolean is_grammatical_gender_specified, boolean was_grammatical_gender_specified);<br>
     */
    public static final int GRAMMATICAL_INFLECTION_CHANGED = 584;

    /**
     * CredentialManagerApiCalled credential_manager_api_called<br>
     * Usage: StatsLog.write(StatsLog.CREDENTIAL_MANAGER_API_CALLED, int api_name, int caller_uid, int api_status, int[] candidate_provider_uid, int[] candidate_provider_round_trip_time_overall_microseconds, int[] candidate_provider_status, int chosen_provider_uid, int chosen_provider_round_trip_time_overall_microseconds, int chosen_provider_round_trip_time_choice_microseconds, int chosen_provider_status);<br>
     */
    public static final int CREDENTIAL_MANAGER_API_CALLED = 585;

    /**
     * BiometricPropertiesCollected biometric_properties_collected<br>
     * Usage: StatsLog.write(StatsLog.BIOMETRIC_PROPERTIES_COLLECTED, int sensor_id, int modality, int sensor_type, int sensor_strength, java.lang.String component_info_component_id, java.lang.String component_info_hardware_version, java.lang.String component_info_firmware_version, java.lang.String component_info_serial_number, java.lang.String component_info_software_version);<br>
     */
    public static final int BIOMETRIC_PROPERTIES_COLLECTED = 587;

    /**
     * KernelWakeupAttributed kernel_wakeup_attributed<br>
     * Usage: StatsLog.write(StatsLog.KERNEL_WAKEUP_ATTRIBUTED, int type, int reason, int[] uids, long elapsed_millis, int[] process_states);<br>
     */
    public static final int KERNEL_WAKEUP_ATTRIBUTED = 588;

    /**
     * ScreenStateChangedV2 screen_state_changed_v2<br>
     * Usage: StatsLog.write(StatsLog.SCREEN_STATE_CHANGED_V2, int state, int display_id);<br>
     */
    public static final int SCREEN_STATE_CHANGED_V2 = 589;

    /**
     * ExpressHistogramSampleReported express_histogram_sample_reported<br>
     * Usage: StatsLog.write(StatsLog.EXPRESS_HISTOGRAM_SAMPLE_REPORTED, long metric_id, long count, int bin_index);<br>
     */
    public static final int EXPRESS_HISTOGRAM_SAMPLE_REPORTED = 593;

    /**
     * WearOobeStateChanged wear_oobe_state_changed<br>
     * Usage: StatsLog.write(StatsLog.WEAR_OOBE_STATE_CHANGED, int oobe_state);<br>
     */
    public static final int WEAR_OOBE_STATE_CHANGED = 595;

    /**
     * MediaCodecReclaimRequestCompleted media_codec_reclaim_request_completed<br>
     * Usage: StatsLog.write(StatsLog.MEDIA_CODEC_RECLAIM_REQUEST_COMPLETED, int requester_uid, int requester_oom_score, java.lang.String codec, int no_of_concurrent_codecs, int reclaim_status, int no_of_codecs_reclaimed, int target_index, int target_uid, int target_oom_score);<br>
     */
    public static final int MEDIA_CODEC_RECLAIM_REQUEST_COMPLETED = 600;

    /**
     * AutofillUiEventReported autofill_ui_event_reported<br>
     * Usage: StatsLog.write(StatsLog.AUTOFILL_UI_EVENT_REPORTED, int event_type, int autofill_service_uid, int app_package_uid);<br>
     */
    public static final int AUTOFILL_UI_EVENT_REPORTED = 603;

    /**
     * AutofillFillRequestReported autofill_fill_request_reported<br>
     * Usage: StatsLog.write(StatsLog.AUTOFILL_FILL_REQUEST_REPORTED, int request_id, int session_id, int autofill_service_uid, int inline_suggestion_host_uid, boolean is_augmented, boolean is_client_suggestion_fallback, boolean is_fill_dialog_eligible, int request_trigger_reason, long flags, int latency_fill_request_sent_millis, int app_package_uid);<br>
     */
    public static final int AUTOFILL_FILL_REQUEST_REPORTED = 604;

    /**
     * AutofillFillResponseReported autofill_fill_response_reported<br>
     * Usage: StatsLog.write(StatsLog.AUTOFILL_FILL_RESPONSE_REPORTED, int request_id, int session_id, int app_package_uid, int display_presentation_type, int available_count, long save_ui_trigger_ids, int latency_fill_response_received_millis, int authentication_type, int authentication_result, long authentication_failure_reason, long latency_authentication_ui_display_millis, long latency_dataset_display_millis, int response_status, long latency_response_processing_millis, int available_pcc_count, int available_pcc_only_count, int total_datasets_provided, int detection_preference);<br>
     */
    public static final int AUTOFILL_FILL_RESPONSE_REPORTED = 605;

    /**
     * AutofillSaveEventReported autofill_save_event_reported<br>
     * Usage: StatsLog.write(StatsLog.AUTOFILL_SAVE_EVENT_REPORTED, int request_id, int session_id, int app_package_uid, long save_ui_trigger_ids, long flag, boolean is_new_field, int save_ui_shown_reason, int save_ui_not_shown_reason, boolean save_button_clicked, boolean cancel_button_clicked, boolean dialog_dismissed, boolean is_saved, long latency_save_ui_display_millis, long latency_save_request_millis, long latency_save_finish_millis, boolean is_framework_created_save_info);<br>
     */
    public static final int AUTOFILL_SAVE_EVENT_REPORTED = 606;

    /**
     * AutofillSessionCommitted autofill_session_committed<br>
     * Usage: StatsLog.write(StatsLog.AUTOFILL_SESSION_COMMITTED, int session_id, int component_package_uid, long request_count, int commit_reason, long session_duration_millis);<br>
     */
    public static final int AUTOFILL_SESSION_COMMITTED = 607;

    /**
     * FullScreenIntentLaunched full_screen_intent_launched<br>
     * Usage: StatsLog.write(StatsLog.FULL_SCREEN_INTENT_LAUNCHED, int creator_uid, java.lang.String activity);<br>
     */
    public static final int FULL_SCREEN_INTENT_LAUNCHED = 631;

    /**
     * BalAllowed bal_allowed<br>
     * Usage: StatsLog.write(StatsLog.BAL_ALLOWED, java.lang.String target_activity, int allowed_reason, int calling_uid, int real_calling_uid);<br>
     */
    public static final int BAL_ALLOWED = 632;

    /**
     * EmergencyStateChanged emergency_state_changed<br>
     * Usage: StatsLog.write(StatsLog.EMERGENCY_STATE_CHANGED, boolean is_in_emergency);<br>
     */
    public static final int EMERGENCY_STATE_CHANGED = 633;

    /**
     * MediaCodecStarted media_codec_started<br>
     * Usage: StatsLog.write(StatsLog.MEDIA_CODEC_STARTED, int requester_uid, long codec_id, java.lang.String codec_name, int codec_type, boolean is_encoder, boolean is_hardware, int width, int height, int system_concurrent_codec_count, int app_concurrent_codec_count, long total_pixel_count, int app_concurrent_hw_video_codec_count, int app_concurrent_sw_video_codec_count, int app_concurrent_video_codec_count, int app_concurrent_audio_codec_count, int app_concurrent_image_codec_count);<br>
     */
    public static final int MEDIA_CODEC_STARTED = 641;

    /**
     * MediaCodecStopped media_codec_stopped<br>
     * Usage: StatsLog.write(StatsLog.MEDIA_CODEC_STOPPED, int requester_uid, long codec_id, java.lang.String codec_name, int codec_type, boolean is_encoder, boolean is_hardware, int width, int height, int system_concurrent_codec_count, int app_concurrent_codec_count, long total_pixel_count, long codec_operation_duration_ms);<br>
     */
    public static final int MEDIA_CODEC_STOPPED = 642;

    /**
     * ExpressUidEventReported express_uid_event_reported<br>
     * Usage: StatsLog.write(StatsLog.EXPRESS_UID_EVENT_REPORTED, long metric_id, long value, int uid);<br>
     */
    public static final int EXPRESS_UID_EVENT_REPORTED = 644;

    /**
     * CredentialManagerInitialPhaseReported credential_manager_init_phase_reported<br>
     * Usage: StatsLog.write(StatsLog.CREDENTIAL_MANAGER_INIT_PHASE_REPORTED, int api_name, int caller_uid, int session_id, int sequence_num, long initial_timestamp_reference_nanoseconds, int count_credential_request_classtypes, java.lang.String[] request_unique_classtypes, int[] per_classtype_counts, boolean origin_specified);<br>
     */
    public static final int CREDENTIAL_MANAGER_INIT_PHASE_REPORTED = 651;

    /**
     * CredentialManagerCandidatePhaseReported credential_manager_candidate_phase_reported<br>
     * Usage: StatsLog.write(StatsLog.CREDENTIAL_MANAGER_CANDIDATE_PHASE_REPORTED, int session_id, int sequence_num, boolean query_returned, int[] candidate_provider_uid, int[] candidate_provider_query_start_timestamp_microseconds, int[] candidate_provider_query_end_timestamp_microseconds, int[] candidate_provider_status, boolean[] candidate_provider_has_exception, int[] candidate_provider_num_entries, int[] candidate_provider_action_entry_count, int[] candidate_provider_credential_entry_count, int[] candidate_provider_credential_entry_type_count, int[] candidate_provider_remote_entry_count, int[] candidate_provider_authentication_entry_count, java.lang.String[] framework_exception_per_provider, boolean origin_specified, java.lang.String[] request_unique_classtypes, int[] per_classtype_counts, int api_name, boolean[] primary_candidates_indicated);<br>
     */
    public static final int CREDENTIAL_MANAGER_CANDIDATE_PHASE_REPORTED = 652;

    /**
     * CredentialManagerFinalPhaseReported credential_manager_final_phase_reported<br>
     * Usage: StatsLog.write(StatsLog.CREDENTIAL_MANAGER_FINAL_PHASE_REPORTED, int session_id, int sequence_num, boolean ui_returned_final_start, int chosen_provider_uid, int chosen_provider_query_start_timestamp_microseconds, int chosen_provider_query_end_timestamp_microseconds, int chosen_provider_ui_invoked_timestamp_microseconds, int chosen_provider_ui_finished_timestamp_microseconds, int chosen_provider_finished_timestamp_microseconds, int chosen_provider_status, boolean chosen_provider_has_exception, int[] chosen_provider_available_entries, int chosen_provider_action_entry_count, int chosen_provider_credential_entry_count, int chosen_provider_credential_entry_type_count, int chosen_provider_remote_entry_count, int chosen_provider_authentication_entry_count, int[] clicked_entries, int[] provider_of_clicked_entry, int api_status, int[] unique_entries, int[] per_entry_counts, java.lang.String[] unique_response_classtypes, int[] per_classtype_counts, java.lang.String framework_exception_unique_classtype, boolean primary_indicated);<br>
     */
    public static final int CREDENTIAL_MANAGER_FINAL_PHASE_REPORTED = 653;

    /**
     * DNDStateChanged dnd_state_changed<br>
     * Usage: StatsLog.write(StatsLog.DND_STATE_CHANGED, int event_id, int new_mode, int previous_mode, int rule_type, int num_rules_active, boolean user_action, int package_uid, byte[] current_policy, boolean are_channels_bypassing);<br>
     */
    public static final int DND_STATE_CHANGED = 657;

    /**
     * ExpressUidHistogramSampleReported express_uid_histogram_sample_reported<br>
     * Usage: StatsLog.write(StatsLog.EXPRESS_UID_HISTOGRAM_SAMPLE_REPORTED, long metric_id, long count, int bin_index, int uid);<br>
     */
    public static final int EXPRESS_UID_HISTOGRAM_SAMPLE_REPORTED = 658;

    /**
     * AutofillFieldClassificationEventReported autofill_field_classification_event_reported<br>
     * Usage: StatsLog.write(StatsLog.AUTOFILL_FIELD_CLASSIFICATION_EVENT_REPORTED, long latency_millis, int count_classifications);<br>
     */
    public static final int AUTOFILL_FIELD_CLASSIFICATION_EVENT_REPORTED = 659;

    /**
     * CredentialManagerTotalCandidateReported credential_manager_total_reported<br>
     * Usage: StatsLog.write(StatsLog.CREDENTIAL_MANAGER_TOTAL_REPORTED, int session_id, int sequence_num, boolean query_returned, int num_query_providers, int min_query_start_timestamp_microseconds, int max_query_end_timestamp_microseconds, java.lang.String[] query_response_unique_classtypes, int[] query_per_classtype_counts, int[] query_unique_entries, int[] query_per_entry_counts, int query_total_candidate_failure, java.lang.String[] query_framework_exception_unique_classtypes, int[] query_per_exception_classtype_counts, java.lang.String[] auth_response_unique_classtypes, int[] auth_per_classtype_counts, int[] auth_unique_entries, int[] auth_per_entry_counts, int auth_total_candidate_failure, java.lang.String[] auth_framework_exception_unique_classtypes, int[] auth_per_exception_classtype_counts, int num_auth_clicks, boolean auth_returned);<br>
     */
    public static final int CREDENTIAL_MANAGER_TOTAL_REPORTED = 667;

    /**
     * CredentialManagerFinalNoUidReported credential_manager_finalnouid_reported<br>
     * Usage: StatsLog.write(StatsLog.CREDENTIAL_MANAGER_FINALNOUID_REPORTED, int session_id, int sequence_num, boolean final_ui_returned, int final_query_start_timestamp_microseconds, int final_query_end_timestamp_microseconds, int final_ui_invoked_timestamp_microseconds, int final_ui_finished_timestamp_microseconds, int final_finished_timestamp_microseconds, int final_status, boolean provider_exception_occurred, int[] unique_entries, int[] per_entry_counts, java.lang.String[] response_unique_classtypes, int[] per_classtype_counts, java.lang.String framework_exception_unique_classtype, int[] clicked_entries, int[] per_entry_provider_uids, int api_status, boolean primary_indicated);<br>
     */
    public static final int CREDENTIAL_MANAGER_FINALNOUID_REPORTED = 668;

    /**
     * CredentialManagerGetProviderReported credential_manager_get_reported<br>
     * Usage: StatsLog.write(StatsLog.CREDENTIAL_MANAGER_GET_REPORTED, int session_id, int sequence_num, int candidate_provider_uid, java.lang.String[] response_unique_classtypes, int[] per_classtype_counts);<br>
     */
    public static final int CREDENTIAL_MANAGER_GET_REPORTED = 669;

    /**
     * CredentialManagerBrowsedAuthenticationClicked credential_manager_auth_click_reported<br>
     * Usage: StatsLog.write(StatsLog.CREDENTIAL_MANAGER_AUTH_CLICK_REPORTED, int session_id, int sequence_num, int candidate_provider_uid, java.lang.String[] response_unique_classtypes, int[] per_classtype_counts, int[] unique_entries, int[] auth_per_entry_counts, java.lang.String framework_exception_unique_classtype, boolean exception_specified, int candidate_provider_status, boolean query_returned);<br>
     */
    public static final int CREDENTIAL_MANAGER_AUTH_CLICK_REPORTED = 670;

    /**
     * CredentialManagerApiV2Called credential_manager_apiv2_called<br>
     * Usage: StatsLog.write(StatsLog.CREDENTIAL_MANAGER_APIV2_CALLED, int api_name, int caller_uid, int api_status);<br>
     */
    public static final int CREDENTIAL_MANAGER_APIV2_CALLED = 671;

    /**
     * MediaCodecRendered media_codec_rendered<br>
     * Usage: StatsLog.write(StatsLog.MEDIA_CODEC_RENDERED, int uid, long codec_id, java.lang.String log_session_id, int is_hardware, int is_secure, int is_tunneled, int codec, int resolution, int bitrate, int content_framerate, int actual_framerate, int hdr_format, long first_render_timestamp_ns, long playback_duration_seconds, long frames_total, long frames_released, long frames_rendered, long frames_dropped, long frames_skipped, float frame_drop_rate, float frame_skip_rate, float frame_skip_drop_rate, long freeze_score, float freeze_rate, int[] freeze_duration_ms_histogram, int[] freeze_duration_ms_histogram_buckets, int[] freeze_distance_ms_histogram, int[] freeze_distance_ms_histogram_buckets, long judder_score, float judder_rate, int[] judder_score_histogram, int[] judder_score_histogram_buckets);<br>
     */
    public static final int MEDIA_CODEC_RENDERED = 684;

    /**
     * InTaskActivityStarted in_task_activity_started<br>
     * Usage: StatsLog.write(StatsLog.IN_TASK_ACTIVITY_STARTED, int uid, int type, boolean is_opaque, int transition_delay_millis, int windows_drawn_delay_millis, long activity_start_timestamp_millis);<br>
     */
    public static final int IN_TASK_ACTIVITY_STARTED = 685;

    /**
     * WifiBytesTransfer wifi_bytes_transfer<br>
     * Usage: StatsLog.write(StatsLog.WIFI_BYTES_TRANSFER, int uid, long rx_bytes, long rx_packets, long tx_bytes, long tx_packets);<br>
     */
    public static final int WIFI_BYTES_TRANSFER = 10000;

    /**
     * WifiBytesTransferByFgBg wifi_bytes_transfer_by_fg_bg<br>
     * Usage: StatsLog.write(StatsLog.WIFI_BYTES_TRANSFER_BY_FG_BG, int uid, boolean is_foreground, long rx_bytes, long rx_packets, long tx_bytes, long tx_packets);<br>
     */
    public static final int WIFI_BYTES_TRANSFER_BY_FG_BG = 10001;

    /**
     * MobileBytesTransfer mobile_bytes_transfer<br>
     * Usage: StatsLog.write(StatsLog.MOBILE_BYTES_TRANSFER, int uid, long rx_bytes, long rx_packets, long tx_bytes, long tx_packets);<br>
     */
    public static final int MOBILE_BYTES_TRANSFER = 10002;

    /**
     * MobileBytesTransferByFgBg mobile_bytes_transfer_by_fg_bg<br>
     * Usage: StatsLog.write(StatsLog.MOBILE_BYTES_TRANSFER_BY_FG_BG, int uid, boolean is_foreground, long rx_bytes, long rx_packets, long tx_bytes, long tx_packets);<br>
     */
    public static final int MOBILE_BYTES_TRANSFER_BY_FG_BG = 10003;

    /**
     * KernelWakelock kernel_wakelock<br>
     * Usage: StatsLog.write(StatsLog.KERNEL_WAKELOCK, java.lang.String name, int count, int version, long time_micros);<br>
     */
    public static final int KERNEL_WAKELOCK = 10004;

    /**
     * SubsystemSleepState subsystem_sleep_state<br>
     * Usage: StatsLog.write(StatsLog.SUBSYSTEM_SLEEP_STATE, java.lang.String subsystem_name, java.lang.String subname, long count, long time_millis);<br>
     */
    public static final int SUBSYSTEM_SLEEP_STATE = 10005;

    /**
     * BluetoothBytesTransfer bluetooth_bytes_transfer<br>
     * Usage: StatsLog.write(StatsLog.BLUETOOTH_BYTES_TRANSFER, int uid, long rx_bytes, long tx_bytes);<br>
     */
    public static final int BLUETOOTH_BYTES_TRANSFER = 10006;

    /**
     * BluetoothActivityInfo bluetooth_activity_info<br>
     * Usage: StatsLog.write(StatsLog.BLUETOOTH_ACTIVITY_INFO, long timestamp_millis, int bluetooth_stack_state, long controller_tx_time_millis, long controller_rx_time_millis, long controller_idle_time_millis, long energy_used);<br>
     */
    public static final int BLUETOOTH_ACTIVITY_INFO = 10007;

    /**
     * CpuTimePerUid cpu_time_per_uid<br>
     * Usage: StatsLog.write(StatsLog.CPU_TIME_PER_UID, int uid, long user_time_micros, long sys_time_micros);<br>
     */
    public static final int CPU_TIME_PER_UID = 10009;

    /**
     * CpuTimePerUidFreq cpu_time_per_uid_freq<br>
     * Usage: StatsLog.write(StatsLog.CPU_TIME_PER_UID_FREQ, int uid, int freq_index, long time_millis);<br>
     */
    public static final int CPU_TIME_PER_UID_FREQ = 10010;

    /**
     * WifiActivityInfo wifi_activity_info<br>
     * Usage: StatsLog.write(StatsLog.WIFI_ACTIVITY_INFO, long timestamp_millis, int stack_state, long controller_tx_time_millis, long controller_rx_time_millis, long controller_idle_time_millis, long controller_energy_used);<br>
     */
    public static final int WIFI_ACTIVITY_INFO = 10011;

    /**
     * ModemActivityInfo modem_activity_info<br>
     * Usage: StatsLog.write(StatsLog.MODEM_ACTIVITY_INFO, long timestamp_millis, long sleep_time_millis, long controller_idle_time_millis, long controller_tx_time_pl0_millis, long controller_tx_time_pl1_millis, long controller_tx_time_pl2_millis, long controller_tx_time_pl3_millis, long controller_tx_time_pl4_millis, long controller_rx_time_millis, long energy_used);<br>
     */
    public static final int MODEM_ACTIVITY_INFO = 10012;

    /**
     * ProcessMemoryState process_memory_state<br>
     * Usage: StatsLog.write(StatsLog.PROCESS_MEMORY_STATE, int uid, java.lang.String process_name, int oom_adj_score, long page_fault, long page_major_fault, long rss_in_bytes, long cache_in_bytes, long swap_in_bytes, long rss_high_watermark_in_bytes, long start_time_nanos, int anon_rss_and_swap_in_kilobytes);<br>
     */
    public static final int PROCESS_MEMORY_STATE = 10013;

    /**
     * SystemElapsedRealtime system_elapsed_realtime<br>
     * Usage: StatsLog.write(StatsLog.SYSTEM_ELAPSED_REALTIME, long time_millis);<br>
     */
    public static final int SYSTEM_ELAPSED_REALTIME = 10014;

    /**
     * SystemUptime system_uptime<br>
     * Usage: StatsLog.write(StatsLog.SYSTEM_UPTIME, long uptime_millis);<br>
     */
    public static final int SYSTEM_UPTIME = 10015;

    /**
     * CpuActiveTime cpu_active_time<br>
     * Usage: StatsLog.write(StatsLog.CPU_ACTIVE_TIME, int uid, long time_millis);<br>
     */
    public static final int CPU_ACTIVE_TIME = 10016;

    /**
     * CpuClusterTime cpu_cluster_time<br>
     * Usage: StatsLog.write(StatsLog.CPU_CLUSTER_TIME, int uid, int cluster_index, long time_millis);<br>
     */
    public static final int CPU_CLUSTER_TIME = 10017;

    /**
     * RemainingBatteryCapacity remaining_battery_capacity<br>
     * Usage: StatsLog.write(StatsLog.REMAINING_BATTERY_CAPACITY, int charge_micro_ampere_hour);<br>
     */
    public static final int REMAINING_BATTERY_CAPACITY = 10019;

    /**
     * FullBatteryCapacity full_battery_capacity<br>
     * Usage: StatsLog.write(StatsLog.FULL_BATTERY_CAPACITY, int capacity_micro_ampere_hour);<br>
     */
    public static final int FULL_BATTERY_CAPACITY = 10020;

    /**
     * Temperature temperature<br>
     * Usage: StatsLog.write(StatsLog.TEMPERATURE, int sensor_location, java.lang.String sensor_name, int temperature_deci_celsius, int severity);<br>
     */
    public static final int TEMPERATURE = 10021;

    /**
     * BinderCalls binder_calls<br>
     * Usage: StatsLog.write(StatsLog.BINDER_CALLS, int uid, java.lang.String service_class_name, java.lang.String service_method_name, long call_count, long recorded_exception_count, long recorded_total_latency_micros, long recorded_max_latency_micros, long recorded_total_cpu_micros, long recorded_max_cpu_micros, long recorded_max_reply_size_bytes, long recorded_max_request_size_bytes, long recorded_call_count, boolean screen_interactive, int direct_caller_uid);<br>
     */
    public static final int BINDER_CALLS = 10022;

    /**
     * BinderCallsExceptions binder_calls_exceptions<br>
     * Usage: StatsLog.write(StatsLog.BINDER_CALLS_EXCEPTIONS, java.lang.String exception_class_name, long exception_count);<br>
     */
    public static final int BINDER_CALLS_EXCEPTIONS = 10023;

    /**
     * LooperStats looper_stats<br>
     * Usage: StatsLog.write(StatsLog.LOOPER_STATS, int uid, java.lang.String handler_class_name, java.lang.String looper_thread_name, java.lang.String message_name, long message_count, long exception_count, long recorded_message_count, long recorded_total_latency_micros, long recorded_total_cpu_micros, boolean screen_interactive, long recorded_max_cpu_micros, long recorded_max_latency_micros, long recorded_delay_message_count, long recorded_total_delay_millis, long recorded_max_delay_millis);<br>
     */
    public static final int LOOPER_STATS = 10024;

    /**
     * DiskStats disk_stats<br>
     * Usage: StatsLog.write(StatsLog.DISK_STATS, long data_write_latency_millis, boolean file_based_encryption, int recent_disk_write_speed);<br>
     */
    public static final int DISK_STATS = 10025;

    /**
     * DirectoryUsage directory_usage<br>
     * Usage: StatsLog.write(StatsLog.DIRECTORY_USAGE, int directory, long free_bytes, long total_bytes);<br>
     */
    public static final int DIRECTORY_USAGE = 10026;

    /**
     * AppSize app_size<br>
     * Usage: StatsLog.write(StatsLog.APP_SIZE, java.lang.String package_name, long app_size_bytes, long app_data_size_bytes, long app_cache_size_bytes, long cache_time_millis);<br>
     */
    public static final int APP_SIZE = 10027;

    /**
     * CategorySize category_size<br>
     * Usage: StatsLog.write(StatsLog.CATEGORY_SIZE, int category, long size_bytes, long cache_time_millis);<br>
     */
    public static final int CATEGORY_SIZE = 10028;

    /**
     * ProcStats proc_stats<br>
     * Usage: StatsLog.write(StatsLog.PROC_STATS, byte[] proc_stats_section, int shard_id);<br>
     */
    public static final int PROC_STATS = 10029;

    /**
     * BatteryVoltage battery_voltage<br>
     * Usage: StatsLog.write(StatsLog.BATTERY_VOLTAGE, int voltage_millivolt);<br>
     */
    public static final int BATTERY_VOLTAGE = 10030;

    /**
     * NumFingerprintsEnrolled num_fingerprints_enrolled<br>
     * Usage: StatsLog.write(StatsLog.NUM_FINGERPRINTS_ENROLLED, int user, int num_fingerprints_enrolled);<br>
     */
    public static final int NUM_FINGERPRINTS_ENROLLED = 10031;

    /**
     * DiskIo disk_io<br>
     * Usage: StatsLog.write(StatsLog.DISK_IO, int uid, long fg_chars_read, long fg_chars_write, long fg_bytes_read, long fg_bytes_write, long bg_chars_read, long bg_chars_write, long bg_bytes_read, long bg_bytes_write, long fg_fsync, long bg_fsync);<br>
     */
    public static final int DISK_IO = 10032;

    /**
     * PowerProfile power_profile<br>
     * Usage: StatsLog.write(StatsLog.POWER_PROFILE, byte[] power_profile);<br>
     */
    public static final int POWER_PROFILE = 10033;

    /**
     * ProcStatsPkgProc proc_stats_pkg_proc<br>
     * Usage: StatsLog.write(StatsLog.PROC_STATS_PKG_PROC, byte[] proc_stats_section);<br>
     */
    public static final int PROC_STATS_PKG_PROC = 10034;

    /**
     * ProcessCpuTime process_cpu_time<br>
     * Usage: StatsLog.write(StatsLog.PROCESS_CPU_TIME, int uid, java.lang.String process_name, long user_time_millis, long system_time_millis);<br>
     */
    public static final int PROCESS_CPU_TIME = 10035;

    /**
     * CpuTimePerThreadFreq cpu_time_per_thread_freq<br>
     * Usage: StatsLog.write(StatsLog.CPU_TIME_PER_THREAD_FREQ, int uid, int process_id, int thread_id, java.lang.String process_name, java.lang.String thread_name, int frequency1_khz, int time1_millis, int frequency2_khz, int time2_millis, int frequency3_khz, int time3_millis, int frequency4_khz, int time4_millis, int frequency5_khz, int time5_millis, int frequency6_khz, int time6_millis, int frequency7_khz, int time7_millis, int frequency8_khz, int time8_millis);<br>
     */
    public static final int CPU_TIME_PER_THREAD_FREQ = 10037;

    /**
     * OnDevicePowerMeasurement on_device_power_measurement<br>
     * Usage: StatsLog.write(StatsLog.ON_DEVICE_POWER_MEASUREMENT, java.lang.String subsystem_name, java.lang.String rail_name, long measurement_timestamp_millis, long energy_microwatt_secs);<br>
     */
    public static final int ON_DEVICE_POWER_MEASUREMENT = 10038;

    /**
     * DeviceCalculatedPowerUse device_calculated_power_use<br>
     * Usage: StatsLog.write(StatsLog.DEVICE_CALCULATED_POWER_USE, long computed_power_nano_amp_secs);<br>
     */
    public static final int DEVICE_CALCULATED_POWER_USE = 10039;

    /**
     * ProcessMemoryHighWaterMark process_memory_high_water_mark<br>
     * Usage: StatsLog.write(StatsLog.PROCESS_MEMORY_HIGH_WATER_MARK, int uid, java.lang.String process_name, long rss_high_water_mark_in_bytes, int rss_high_water_mark_in_kilobytes);<br>
     */
    public static final int PROCESS_MEMORY_HIGH_WATER_MARK = 10042;

    /**
     * BatteryLevel battery_level<br>
     * Usage: StatsLog.write(StatsLog.BATTERY_LEVEL, int battery_level);<br>
     */
    public static final int BATTERY_LEVEL = 10043;

    /**
     * BuildInformation build_information<br>
     * Usage: StatsLog.write(StatsLog.BUILD_INFORMATION, java.lang.String fingerprint, java.lang.String brand, java.lang.String product, java.lang.String device, java.lang.String version_release, java.lang.String id, java.lang.String version_incremental, java.lang.String type, java.lang.String tags);<br>
     */
    public static final int BUILD_INFORMATION = 10044;

    /**
     * BatteryCycleCount battery_cycle_count<br>
     * Usage: StatsLog.write(StatsLog.BATTERY_CYCLE_COUNT, int cycle_count);<br>
     */
    public static final int BATTERY_CYCLE_COUNT = 10045;

    /**
     * DebugElapsedClock debug_elapsed_clock<br>
     * Usage: StatsLog.write(StatsLog.DEBUG_ELAPSED_CLOCK, long pull_count, long elapsed_clock_millis, long same_elapsed_clock_millis, long elapsed_clock_diff_millis, int type);<br>
     */
    public static final int DEBUG_ELAPSED_CLOCK = 10046;

    /**
     * DebugFailingElapsedClock debug_failing_elapsed_clock<br>
     * Usage: StatsLog.write(StatsLog.DEBUG_FAILING_ELAPSED_CLOCK, long pull_count, long elapsed_clock_millis, long same_elapsed_clock_millis, long elapsed_clock_diff_millis);<br>
     */
    public static final int DEBUG_FAILING_ELAPSED_CLOCK = 10047;

    /**
     * NumFacesEnrolled num_faces_enrolled<br>
     * Usage: StatsLog.write(StatsLog.NUM_FACES_ENROLLED, int user, int num_faces_enrolled);<br>
     */
    public static final int NUM_FACES_ENROLLED = 10048;

    /**
     * RoleHolder role_holder<br>
     * Usage: StatsLog.write(StatsLog.ROLE_HOLDER, int uid, java.lang.String package_name, java.lang.String role);<br>
     */
    public static final int ROLE_HOLDER = 10049;

    /**
     * DangerousPermissionState dangerous_permission_state<br>
     * Usage: StatsLog.write(StatsLog.DANGEROUS_PERMISSION_STATE, java.lang.String permission_name, int uid, java.lang.String package_name, boolean is_granted, int permission_flags, int protection_flags);<br>
     */
    public static final int DANGEROUS_PERMISSION_STATE = 10050;

    /**
     * TimeZoneDataInfo time_zone_data_info<br>
     * Usage: StatsLog.write(StatsLog.TIME_ZONE_DATA_INFO, java.lang.String tzdb_version);<br>
     */
    public static final int TIME_ZONE_DATA_INFO = 10052;

    /**
     * ExternalStorageInfo external_storage_info<br>
     * Usage: StatsLog.write(StatsLog.EXTERNAL_STORAGE_INFO, int storage_type, int volume_type, long size_bytes);<br>
     */
    public static final int EXTERNAL_STORAGE_INFO = 10053;

    /**
     * SystemIonHeapSize system_ion_heap_size<br>
     * Usage: StatsLog.write(StatsLog.SYSTEM_ION_HEAP_SIZE, long size_in_bytes);<br>
     */
    public static final int SYSTEM_ION_HEAP_SIZE = 10056;

    /**
     * AppsOnExternalStorageInfo apps_on_external_storage_info<br>
     * Usage: StatsLog.write(StatsLog.APPS_ON_EXTERNAL_STORAGE_INFO, int external_storage_type, java.lang.String package_name);<br>
     */
    public static final int APPS_ON_EXTERNAL_STORAGE_INFO = 10057;

    /**
     * FaceSettings face_settings<br>
     * Usage: StatsLog.write(StatsLog.FACE_SETTINGS, boolean unlock_keyguard_enabled, boolean unlock_dismisses_keyguard, boolean unlock_attention_required, boolean unlock_app_enabled, boolean unlock_always_require_confirmation, boolean unlock_diversity_required);<br>
     */
    public static final int FACE_SETTINGS = 10058;

    /**
     * CoolingDevice cooling_device<br>
     * Usage: StatsLog.write(StatsLog.COOLING_DEVICE, int device_location, java.lang.String device_name, int state);<br>
     */
    public static final int COOLING_DEVICE = 10059;

    /**
     * AppOps app_ops<br>
     * Usage: StatsLog.write(StatsLog.APP_OPS, int uid, java.lang.String package_name, int op_id, long trusted_foreground_granted_count, long trusted_background_granted_count, long trusted_foreground_rejected_count, long trusted_background_rejected_count, long trusted_foreground_duration_millis, long trusted_background_duration_millis, boolean is_runtime_permission);<br>
     */
    public static final int APP_OPS = 10060;

    /**
     * ProcessSystemIonHeapSize process_system_ion_heap_size<br>
     * Usage: StatsLog.write(StatsLog.PROCESS_SYSTEM_ION_HEAP_SIZE, int uid, java.lang.String process_name, int total_size_in_kilobytes, int allocation_count, int max_size_in_kilobytes);<br>
     */
    public static final int PROCESS_SYSTEM_ION_HEAP_SIZE = 10061;

    /**
     * ProcessMemorySnapshot process_memory_snapshot<br>
     * Usage: StatsLog.write(StatsLog.PROCESS_MEMORY_SNAPSHOT, int uid, java.lang.String process_name, int pid, int oom_score_adj, int rss_in_kilobytes, int anon_rss_in_kilobytes, int swap_in_kilobytes, int anon_rss_and_swap_in_kilobytes, int gpu_memory_kb, boolean has_foreground_services, int shmem_kb, int current_hosting_component_types, int historical_hosting_component_types);<br>
     */
    public static final int PROCESS_MEMORY_SNAPSHOT = 10064;

    /**
     * NotificationRemoteViews notification_remote_views<br>
     * Usage: StatsLog.write(StatsLog.NOTIFICATION_REMOTE_VIEWS, byte[] notification_remote_views);<br>
     */
    public static final int NOTIFICATION_REMOTE_VIEWS = 10066;

    /**
     * DangerousPermissionStateSampled dangerous_permission_state_sampled<br>
     * Usage: StatsLog.write(StatsLog.DANGEROUS_PERMISSION_STATE_SAMPLED, java.lang.String permission_name, int uid, boolean is_granted, int permission_flags, int protection_flags);<br>
     */
    public static final int DANGEROUS_PERMISSION_STATE_SAMPLED = 10067;

    /**
     * RuntimeAppOpAccess runtime_app_op_access<br>
     * Usage: StatsLog.write(StatsLog.RUNTIME_APP_OP_ACCESS, int uid, java.lang.String package_name, java.lang.String op_deprecated, java.lang.String attribution_tag, java.lang.String message, int sampling_strategy, int op);<br>
     */
    public static final int RUNTIME_APP_OP_ACCESS = 10069;

    /**
     * IonHeapSize ion_heap_size<br>
     * Usage: StatsLog.write(StatsLog.ION_HEAP_SIZE, int total_size_kb);<br>
     */
    public static final int ION_HEAP_SIZE = 10070;

    /**
     * PackageNotificationPreferences package_notification_preferences<br>
     * Usage: StatsLog.write(StatsLog.PACKAGE_NOTIFICATION_PREFERENCES, int uid, int importance, int visibility, int user_locked_fields, boolean user_set_importance);<br>
     */
    public static final int PACKAGE_NOTIFICATION_PREFERENCES = 10071;

    /**
     * PackageNotificationChannelPreferences package_notification_channel_preferences<br>
     * Usage: StatsLog.write(StatsLog.PACKAGE_NOTIFICATION_CHANNEL_PREFERENCES, int uid, java.lang.String channel_id, java.lang.String channel_name, java.lang.String description, int importance, int user_locked_fields, boolean is_deleted, boolean is_conversation, boolean is_demoted_conversation, boolean is_important_conversation);<br>
     */
    public static final int PACKAGE_NOTIFICATION_CHANNEL_PREFERENCES = 10072;

    /**
     * PackageNotificationChannelGroupPreferences package_notification_channel_group_preferences<br>
     * Usage: StatsLog.write(StatsLog.PACKAGE_NOTIFICATION_CHANNEL_GROUP_PREFERENCES, int uid, java.lang.String group_id, java.lang.String group_name, java.lang.String description, boolean is_blocked, int user_locked_fields);<br>
     */
    public static final int PACKAGE_NOTIFICATION_CHANNEL_GROUP_PREFERENCES = 10073;

    /**
     * GnssStats gnss_stats<br>
     * Usage: StatsLog.write(StatsLog.GNSS_STATS, long location_reports, long location_failure_reports, long time_to_first_fix_reports, long time_to_first_fix_millis, long position_accuracy_reports, long position_accuracy_meters, long top_four_average_cn0_reports, long top_four_average_cn0_db_mhz, long l5_top_four_average_cn0_reports, long l5_top_four_average_cn0_db_mhz, long sv_status_reports, long sv_status_reports_used_in_fix, long l5_sv_status_reports, long l5_sv_status_reports_used_in_fix);<br>
     */
    public static final int GNSS_STATS = 10074;

    /**
     * AttributedAppOps attributed_app_ops<br>
     * Usage: StatsLog.write(StatsLog.ATTRIBUTED_APP_OPS, int uid, java.lang.String package_name, java.lang.String tag, int op, long trusted_foreground_granted_count, long trusted_background_granted_count, long trusted_foreground_rejected_count, long trusted_background_rejected_count, long trusted_foreground_duration_millis, long trusted_background_duration_millis, boolean is_runtime_permission, int sampling_rate);<br>
     */
    public static final int ATTRIBUTED_APP_OPS = 10075;

    /**
     * SettingSnapshot setting_snapshot<br>
     * Usage: StatsLog.write(StatsLog.SETTING_SNAPSHOT, java.lang.String name, int type, boolean bool_value, int int_value, float float_value, java.lang.String str_value, int user_id);<br>
     */
    public static final int SETTING_SNAPSHOT = 10080;

    /**
     * BlobInfo blob_info<br>
     * Usage: StatsLog.write(StatsLog.BLOB_INFO, long blob_id, long size, long expiry_timestamp_millis, byte[] committers, byte[] leasees);<br>
     */
    public static final int BLOB_INFO = 10081;

    /**
     * DataUsageBytesTransfer data_usage_bytes_transfer<br>
     * Usage: StatsLog.write(StatsLog.DATA_USAGE_BYTES_TRANSFER, int state, long rx_bytes, long rx_packets, long tx_bytes, long tx_packets, int rat_type, java.lang.String sim_mcc, java.lang.String sim_mnc, int carrier_id, int opportunistic_data_sub, boolean is_nr_connected);<br>
     */
    public static final int DATA_USAGE_BYTES_TRANSFER = 10082;

    /**
     * BytesTransferByTagAndMetered bytes_transfer_by_tag_and_metered<br>
     * Usage: StatsLog.write(StatsLog.BYTES_TRANSFER_BY_TAG_AND_METERED, int uid, boolean is_metered, int tag, long rx_bytes, long rx_packets, long tx_bytes, long tx_packets);<br>
     */
    public static final int BYTES_TRANSFER_BY_TAG_AND_METERED = 10083;

    /**
     * DNDModeProto dnd_mode_rule<br>
     * Usage: StatsLog.write(StatsLog.DND_MODE_RULE, int user, boolean enabled, boolean channels_bypassing, int zen_mode, java.lang.String id, int uid, byte[] policy);<br>
     */
    public static final int DND_MODE_RULE = 10084;

    /**
     * SystemMemory system_memory<br>
     * Usage: StatsLog.write(StatsLog.SYSTEM_MEMORY, int unreclaimable_slab_kb, int vmalloc_used_kb, int page_tables_kb, int kernel_stack_kb, int total_ion_kb, int unaccounted_kb, int gpu_total_usage_kb, int gpu_private_usage_kb, int dmabuf_total_exported_kb, int shmem_kb, int total_kb, int free_kb, int available_kb, int active_kb, int inactive_kb, int active_anon_kb, int inactive_anon_kb, int active_file_kb, int inactive_file_kb, int swap_total_kb, int swap_free_kb, int cma_total_kb, int cma_free_kb);<br>
     */
    public static final int SYSTEM_MEMORY = 10092;

    /**
     * CpuTimePerClusterFreq cpu_time_per_cluster_freq<br>
     * Usage: StatsLog.write(StatsLog.CPU_TIME_PER_CLUSTER_FREQ, int cluster, int freq_khz, long time_millis);<br>
     */
    public static final int CPU_TIME_PER_CLUSTER_FREQ = 10095;

    /**
     * CpuCyclesPerUidCluster cpu_cycles_per_uid_cluster<br>
     * Usage: StatsLog.write(StatsLog.CPU_CYCLES_PER_UID_CLUSTER, int uid, int cluster, long mcycles, long time_millis, long power_profile_estimate);<br>
     */
    public static final int CPU_CYCLES_PER_UID_CLUSTER = 10096;

    /**
     * DeviceRotatedData device_rotated_data<br>
     * Usage: StatsLog.write(StatsLog.DEVICE_ROTATED_DATA, byte[] snapshot, int proposed_orientation);<br>
     */
    public static final int DEVICE_ROTATED_DATA = 10097;

    /**
     * CpuCyclesPerThreadGroupCluster cpu_cycles_per_thread_group_cluster<br>
     * Usage: StatsLog.write(StatsLog.CPU_CYCLES_PER_THREAD_GROUP_CLUSTER, int thread_group, int cluster, long mcycles, long time_millis);<br>
     */
    public static final int CPU_CYCLES_PER_THREAD_GROUP_CLUSTER = 10098;

    /**
     * OemManagedBytesTransfer oem_managed_bytes_transfer<br>
     * Usage: StatsLog.write(StatsLog.OEM_MANAGED_BYTES_TRANSFER, int uid, boolean is_foreground, int oem_managed_type, int transport_type, long rx_bytes, long rx_packets, long tx_bytes, long tx_packets);<br>
     */
    public static final int OEM_MANAGED_BYTES_TRANSFER = 10100;

    /**
     * GnssPowerStats gnss_power_stats<br>
     * Usage: StatsLog.write(StatsLog.GNSS_POWER_STATS, long elapsed_realtime_uncertainty_nanos, long total_energy_micro_joule, long singleband_tracking_mode_energy_micro_joule, long multiband_tracking_mode_energy_micro_joule, long singleband_acquisition_mode_energy_micro_joule, long multiband_acquisition_mode_energy_micro_joule, long vendor_specific_power_modes_energy_micro_joule_0, long vendor_specific_power_modes_energy_micro_joule_1, long vendor_specific_power_modes_energy_micro_joule_2, long vendor_specific_power_modes_energy_micro_joule_3, long vendor_specific_power_modes_energy_micro_joule_4, long vendor_specific_power_modes_energy_micro_joule_5, long vendor_specific_power_modes_energy_micro_joule_6, long vendor_specific_power_modes_energy_micro_joule_7, long vendor_specific_power_modes_energy_micro_joule_8, long vendor_specific_power_modes_energy_micro_joule_9);<br>
     */
    public static final int GNSS_POWER_STATS = 10101;

    /**
     * TimeZoneDetectorState time_zone_detector_state<br>
     * Usage: StatsLog.write(StatsLog.TIME_ZONE_DETECTOR_STATE, boolean telephony_supported, boolean geo_supported, boolean location_enabled, boolean auto_detection_setting, boolean geo_detection_setting, int detection_mode, int device_time_zone_ordinal, byte[] latest_manual_suggestion, byte[] latest_telephony_suggestion, byte[] latest_geo_suggestion, boolean telephony_time_zone_fallback_supported, java.lang.String device_time_zone_id, boolean enhanced_metrics_collection_enabled, boolean geo_detection_run_in_background_enabled);<br>
     */
    public static final int TIME_ZONE_DETECTOR_STATE = 10102;

    /**
     * Keystore2StorageStats keystore2_storage_stats<br>
     * Usage: StatsLog.write(StatsLog.KEYSTORE2_STORAGE_STATS, int storage_type, long size, long unused_size);<br>
     */
    public static final int KEYSTORE2_STORAGE_STATS = 10103;

    /**
     * ProcessDmabufMemory process_dmabuf_memory<br>
     * Usage: StatsLog.write(StatsLog.PROCESS_DMABUF_MEMORY, int uid, java.lang.String process_name, int oom_adj_score, int retained_dmabuf_kb, int retained_dmabuf_count, int mapped_dmabuf_kb, int mapped_dmabuf_count, int surfaceflinger_shared_dmabuf_kb, int surfaceflinger_shared_dmabuf_count);<br>
     */
    public static final int PROCESS_DMABUF_MEMORY = 10105;

    /**
     * PendingAlarmInfo pending_alarm_info<br>
     * Usage: StatsLog.write(StatsLog.PENDING_ALARM_INFO, int num_total, int num_exact, int num_wakeup, int num_allow_while_idle, int num_prioritized, int num_foreground_service, int num_activity, int num_service, int num_listener, int num_indefinite_future, int num_repeating, int num_alarm_clock, int num_rtc);<br>
     */
    public static final int PENDING_ALARM_INFO = 10106;

    /**
     * UserLevelHibernatedApps user_level_hibernated_apps<br>
     * Usage: StatsLog.write(StatsLog.USER_LEVEL_HIBERNATED_APPS, int hibernated_app_count, int user_id);<br>
     */
    public static final int USER_LEVEL_HIBERNATED_APPS = 10107;

    /**
     * GlobalHibernatedApps global_hibernated_apps<br>
     * Usage: StatsLog.write(StatsLog.GLOBAL_HIBERNATED_APPS, int hibernated_app_count, long storage_saved_mb);<br>
     */
    public static final int GLOBAL_HIBERNATED_APPS = 10109;

    /**
     * BatteryUsageStatsBeforeReset battery_usage_stats_before_reset<br>
     * Usage: StatsLog.write(StatsLog.BATTERY_USAGE_STATS_BEFORE_RESET, byte[] battery_usage_stats);<br>
     */
    public static final int BATTERY_USAGE_STATS_BEFORE_RESET = 10111;

    /**
     * BatteryUsageStatsSinceReset battery_usage_stats_since_reset<br>
     * Usage: StatsLog.write(StatsLog.BATTERY_USAGE_STATS_SINCE_RESET, byte[] battery_usage_stats);<br>
     */
    public static final int BATTERY_USAGE_STATS_SINCE_RESET = 10112;

    /**
     * BatteryUsageStatsSinceResetUsingPowerProfileModel battery_usage_stats_since_reset_using_power_profile_model<br>
     * Usage: StatsLog.write(StatsLog.BATTERY_USAGE_STATS_SINCE_RESET_USING_POWER_PROFILE_MODEL, byte[] battery_usage_stats);<br>
     */
    public static final int BATTERY_USAGE_STATS_SINCE_RESET_USING_POWER_PROFILE_MODEL = 10113;

    /**
     * InstalledIncrementalPackage installed_incremental_package<br>
     * Usage: StatsLog.write(StatsLog.INSTALLED_INCREMENTAL_PACKAGE, int uid, boolean is_loading, long loading_completed_timestamp);<br>
     */
    public static final int INSTALLED_INCREMENTAL_PACKAGE = 10114;

    /**
     * VmStat vmstat<br>
     * Usage: StatsLog.write(StatsLog.VMSTAT, int oom_kill_count);<br>
     */
    public static final int VMSTAT = 10117;

    /**
     * Keystore2KeyCreationWithGeneralInfo keystore2_key_creation_with_general_info<br>
     * Usage: StatsLog.write(StatsLog.KEYSTORE2_KEY_CREATION_WITH_GENERAL_INFO, int algorithm, int key_size, int ec_curve, int key_origin, int error_code, boolean attestation_requested, int count);<br>
     */
    public static final int KEYSTORE2_KEY_CREATION_WITH_GENERAL_INFO = 10118;

    /**
     * Keystore2KeyCreationWithAuthInfo keystore2_key_creation_with_auth_info<br>
     * Usage: StatsLog.write(StatsLog.KEYSTORE2_KEY_CREATION_WITH_AUTH_INFO, int user_auth_type, int log_auth_timeout_seconds, int security_level, int count);<br>
     */
    public static final int KEYSTORE2_KEY_CREATION_WITH_AUTH_INFO = 10119;

    /**
     * Keystore2KeyCreationWithPurposeAndModesInfo keystore2_key_creation_with_purpose_and_modes_info<br>
     * Usage: StatsLog.write(StatsLog.KEYSTORE2_KEY_CREATION_WITH_PURPOSE_AND_MODES_INFO, int algorithm, int purpose_bitmap, int padding_mode_bitmap, int digest_bitmap, int block_mode_bitmap, int count);<br>
     */
    public static final int KEYSTORE2_KEY_CREATION_WITH_PURPOSE_AND_MODES_INFO = 10120;

    /**
     * Keystore2AtomWithOverflow keystore2_atom_with_overflow<br>
     * Usage: StatsLog.write(StatsLog.KEYSTORE2_ATOM_WITH_OVERFLOW, int atom_id, int count);<br>
     */
    public static final int KEYSTORE2_ATOM_WITH_OVERFLOW = 10121;

    /**
     * Keystore2KeyOperationWithPurposeAndModesInfo keystore2_key_operation_with_purpose_and_modes_info<br>
     * Usage: StatsLog.write(StatsLog.KEYSTORE2_KEY_OPERATION_WITH_PURPOSE_AND_MODES_INFO, int purpose, int padding_mode_bitmap, int digest_bitmap, int block_mode_bitmap, int count);<br>
     */
    public static final int KEYSTORE2_KEY_OPERATION_WITH_PURPOSE_AND_MODES_INFO = 10122;

    /**
     * Keystore2KeyOperationWithGeneralInfo keystore2_key_operation_with_general_info<br>
     * Usage: StatsLog.write(StatsLog.KEYSTORE2_KEY_OPERATION_WITH_GENERAL_INFO, int outcome, int error_code, boolean key_upgraded, int security_level, int count);<br>
     */
    public static final int KEYSTORE2_KEY_OPERATION_WITH_GENERAL_INFO = 10123;

    /**
     * RkpErrorStats rkp_error_stats<br>
     * Usage: StatsLog.write(StatsLog.RKP_ERROR_STATS, int rkp_error, int count, int security_level);<br>
     */
    public static final int RKP_ERROR_STATS = 10124;

    /**
     * Keystore2CrashStats keystore2_crash_stats<br>
     * Usage: StatsLog.write(StatsLog.KEYSTORE2_CRASH_STATS, int count_of_crash_events);<br>
     */
    public static final int KEYSTORE2_CRASH_STATS = 10125;

    /**
     * VendorApexInfo vendor_apex_info<br>
     * Usage: StatsLog.write(StatsLog.VENDOR_APEX_INFO, java.lang.String package_name, java.lang.String version_code, java.lang.String version_name, java.lang.String source_dir, java.lang.String signing_certs_hash, java.lang.String file_hash);<br>
     */
    public static final int VENDOR_APEX_INFO = 10126;

    /**
     * AccessibilityShortcutStats accessibility_shortcut_stats<br>
     * Usage: StatsLog.write(StatsLog.ACCESSIBILITY_SHORTCUT_STATS, int software_shortcut_type, int software_shortcut_service_num, int hardware_shortcut_type, int hardware_shortcut_service_num, int gesture_shortcut_type, int gesture_shortcut_service_num);<br>
     */
    public static final int ACCESSIBILITY_SHORTCUT_STATS = 10127;

    /**
     * AccessibilityFloatingMenuStats accessibility_floating_menu_stats<br>
     * Usage: StatsLog.write(StatsLog.ACCESSIBILITY_FLOATING_MENU_STATS, int size, int icon_type, boolean fade_enabled, float opacity);<br>
     */
    public static final int ACCESSIBILITY_FLOATING_MENU_STATS = 10128;

    /**
     * DataUsageBytesTransferV2 data_usage_bytes_transfer_v2<br>
     * Usage: StatsLog.write(StatsLog.DATA_USAGE_BYTES_TRANSFER_V2, int state, long rx_bytes, long rx_packets, long tx_bytes, long tx_packets, int rat_type, java.lang.String sim_mcc, java.lang.String sim_mnc, int carrier_id, int opportunistic_data_sub, boolean is_nr_connected, int metered);<br>
     */
    public static final int DATA_USAGE_BYTES_TRANSFER_V2 = 10129;

    /**
     * MediaCapabilities media_capabilities<br>
     * Usage: StatsLog.write(StatsLog.MEDIA_CAPABILITIES, byte[] surround_encodings, byte[] sink_surround_encodings, byte[] user_disabled_surround_encodings, byte[] user_enabled_surround_encodings, int surround_output_mode, byte[] sink_hdr_formats, byte[] sink_display_modes, int hdcp_level, int match_content_refresh_rate_preference, byte[] user_disabled_hdr_formats, int user_preferred_resolution_height, int user_preferred_resolution_width, float user_preferred_refresh_rate, boolean has_user_disabled_allm);<br>
     */
    public static final int MEDIA_CAPABILITIES = 10130;

    /**
     * PersistentUriPermissionsAmountPerPackage persistent_uri_permissions_amount_per_package<br>
     * Usage: StatsLog.write(StatsLog.PERSISTENT_URI_PERMISSIONS_AMOUNT_PER_PACKAGE, int uid, int amount);<br>
     */
    public static final int PERSISTENT_URI_PERMISSIONS_AMOUNT_PER_PACKAGE = 10148;

    /**
     * SignedPartitionInfo signed_partition_info<br>
     * Usage: StatsLog.write(StatsLog.SIGNED_PARTITION_INFO, java.lang.String partition_name, java.lang.String sha256_digest);<br>
     */
    public static final int SIGNED_PARTITION_INFO = 10149;

    /**
     * PinnedFileSizesPerPackage pinned_file_sizes_per_package<br>
     * Usage: StatsLog.write(StatsLog.PINNED_FILE_SIZES_PER_PACKAGE, int uid, java.lang.String filename, int size_kb);<br>
     */
    public static final int PINNED_FILE_SIZES_PER_PACKAGE = 10150;

    /**
     * PendingIntentsPerPackage pending_intents_per_package<br>
     * Usage: StatsLog.write(StatsLog.PENDING_INTENTS_PER_PACKAGE, int uid, int pending_intent_count, int pending_intent_total_bundle_size_kb);<br>
     */
    public static final int PENDING_INTENTS_PER_PACKAGE = 10151;

    /**
     * UserInfo user_info<br>
     * Usage: StatsLog.write(StatsLog.USER_INFO, int user_id, int user_type, java.lang.String user_type_custom, int user_flags, long creation_time_millis, long last_logged_in_time_millis, boolean is_user_running_unlocked);<br>
     */
    public static final int USER_INFO = 10152;

    /**
     * MultiUserInfo multi_user_info<br>
     * Usage: StatsLog.write(StatsLog.MULTI_USER_INFO, int max_supported_users, boolean multi_user_setting_on, boolean supports_adding_full_users);<br>
     */
    public static final int MULTI_USER_INFO = 10160;

    /**
     * GameModeInfo game_mode_info<br>
     * Usage: StatsLog.write(StatsLog.GAME_MODE_INFO, int game_uid, int[] overridden_game_modes, int[] available_game_modes);<br>
     */
    public static final int GAME_MODE_INFO = 10165;

    /**
     * GameModeConfiguration game_mode_configuration<br>
     * Usage: StatsLog.write(StatsLog.GAME_MODE_CONFIGURATION, int game_uid, int game_mode, int fps_override, float scaling_factor);<br>
     */
    public static final int GAME_MODE_CONFIGURATION = 10166;

    /**
     * GameModeListener game_mode_listener<br>
     * Usage: StatsLog.write(StatsLog.GAME_MODE_LISTENER, int count);<br>
     */
    public static final int GAME_MODE_LISTENER = 10167;

    /**
     * ProcessState process_state<br>
     * Usage: StatsLog.write(StatsLog.PROCESS_STATE, int uid, java.lang.String process_name, int measurement_start_uptime_seconds, int measurement_end_uptime_seconds, int measurement_duration_uptime_seconds, int top_seconds, int fgs_seconds, int bound_top_seconds, int bound_fgs_seconds, int important_foreground_seconds, int cached_seconds, int frozen_seconds, int other_seconds);<br>
     */
    public static final int PROCESS_STATE = 10171;

    /**
     * ProcessAssociation process_association<br>
     * Usage: StatsLog.write(StatsLog.PROCESS_ASSOCIATION, int client_uid, java.lang.String client_process, int service_uid, java.lang.String service_name, int measurement_start_uptime_seconds, int measurement_end_uptime_seconds, int measurement_duration_uptime_seconds, int duration_seconds, int count, java.lang.String service_process);<br>
     */
    public static final int PROCESS_ASSOCIATION = 10172;

    /**
     * ADPFSystemComponentInfo adpf_system_component_info<br>
     * Usage: StatsLog.write(StatsLog.ADPF_SYSTEM_COMPONENT_INFO, boolean surfaceflinger_cpu_hint_enabled, boolean hwui_hint_enabled);<br>
     */
    public static final int ADPF_SYSTEM_COMPONENT_INFO = 10173;

    /**
     * HdrCapabilities hdr_capabilities<br>
     * Usage: StatsLog.write(StatsLog.HDR_CAPABILITIES, byte[] device_hdr_output_capabilities, boolean has_user_disabled_hdr_conversion, int force_hdr_format, boolean has_4k30_dolby_vision_issue, boolean device_supports_hdr_output_control);<br>
     */
    public static final int HDR_CAPABILITIES = 10175;

    /**
     * MteState mte_state<br>
     * Usage: StatsLog.write(StatsLog.MTE_STATE, int state);<br>
     */
    public static final int MTE_STATE = 10181;

    /**
     * UwbActivityInfo uwb_activity_info<br>
     * Usage: StatsLog.write(StatsLog.UWB_ACTIVITY_INFO, long tx_time_ms, long rx_time_ms, long idle_time_ms, long wake_count);<br>
     */
    public static final int UWB_ACTIVITY_INFO = 10188;

    /**
     * CachedAppsHighWaterMark cached_apps_high_watermark<br>
     * Usage: StatsLog.write(StatsLog.CACHED_APPS_HIGH_WATERMARK, int cached_app_high_watermark, int uptime_in_seconds, int binder_proxy_snapshot, int free_in_kb, int cached_in_kb, int zram_in_kb, int kernel_in_kb, int num_frozen_apps, int longest_frozen_time_in_seconds, int shortest_frozen_time_in_seconds, int mean_frozen_time_in_seconds, int average_frozen_time_in_seconds);<br>
     */
    public static final int CACHED_APPS_HIGH_WATERMARK = 10189;

    // Constants for enum values.

    // Values for ProcessStateChanged.state
    public static final int PROCESS_STATE_CHANGED__STATE__PROCESS_STATE_UNKNOWN_TO_PROTO = 998;
    public static final int PROCESS_STATE_CHANGED__STATE__PROCESS_STATE_UNKNOWN = 999;
    public static final int PROCESS_STATE_CHANGED__STATE__PROCESS_STATE_PERSISTENT = 1000;
    public static final int PROCESS_STATE_CHANGED__STATE__PROCESS_STATE_PERSISTENT_UI = 1001;
    public static final int PROCESS_STATE_CHANGED__STATE__PROCESS_STATE_TOP = 1002;
    public static final int PROCESS_STATE_CHANGED__STATE__PROCESS_STATE_FOREGROUND_SERVICE = 1003;
    public static final int PROCESS_STATE_CHANGED__STATE__PROCESS_STATE_BOUND_FOREGROUND_SERVICE = 1004;
    public static final int PROCESS_STATE_CHANGED__STATE__PROCESS_STATE_IMPORTANT_FOREGROUND = 1005;
    public static final int PROCESS_STATE_CHANGED__STATE__PROCESS_STATE_IMPORTANT_BACKGROUND = 1006;
    public static final int PROCESS_STATE_CHANGED__STATE__PROCESS_STATE_TRANSIENT_BACKGROUND = 1007;
    public static final int PROCESS_STATE_CHANGED__STATE__PROCESS_STATE_BACKUP = 1008;
    public static final int PROCESS_STATE_CHANGED__STATE__PROCESS_STATE_SERVICE = 1009;
    public static final int PROCESS_STATE_CHANGED__STATE__PROCESS_STATE_RECEIVER = 1010;
    public static final int PROCESS_STATE_CHANGED__STATE__PROCESS_STATE_TOP_SLEEPING = 1011;
    public static final int PROCESS_STATE_CHANGED__STATE__PROCESS_STATE_HEAVY_WEIGHT = 1012;
    public static final int PROCESS_STATE_CHANGED__STATE__PROCESS_STATE_HOME = 1013;
    public static final int PROCESS_STATE_CHANGED__STATE__PROCESS_STATE_LAST_ACTIVITY = 1014;
    public static final int PROCESS_STATE_CHANGED__STATE__PROCESS_STATE_CACHED_ACTIVITY = 1015;
    public static final int PROCESS_STATE_CHANGED__STATE__PROCESS_STATE_CACHED_ACTIVITY_CLIENT = 1016;
    public static final int PROCESS_STATE_CHANGED__STATE__PROCESS_STATE_CACHED_RECENT = 1017;
    public static final int PROCESS_STATE_CHANGED__STATE__PROCESS_STATE_CACHED_EMPTY = 1018;
    public static final int PROCESS_STATE_CHANGED__STATE__PROCESS_STATE_NONEXISTENT = 1019;
    public static final int PROCESS_STATE_CHANGED__STATE__PROCESS_STATE_BOUND_TOP = 1020;

    // Values for SensorStateChanged.state
    public static final int SENSOR_STATE_CHANGED__STATE__OFF = 0;
    public static final int SENSOR_STATE_CHANGED__STATE__ON = 1;

    // Values for GpsScanStateChanged.state
    public static final int GPS_SCAN_STATE_CHANGED__STATE__OFF = 0;
    public static final int GPS_SCAN_STATE_CHANGED__STATE__ON = 1;

    // Values for SyncStateChanged.state
    public static final int SYNC_STATE_CHANGED__STATE__OFF = 0;
    public static final int SYNC_STATE_CHANGED__STATE__ON = 1;

    // Values for ScheduledJobStateChanged.state
    public static final int SCHEDULED_JOB_STATE_CHANGED__STATE__FINISHED = 0;
    public static final int SCHEDULED_JOB_STATE_CHANGED__STATE__STARTED = 1;
    public static final int SCHEDULED_JOB_STATE_CHANGED__STATE__SCHEDULED = 2;
    public static final int SCHEDULED_JOB_STATE_CHANGED__STATE__CANCELLED = 3;

    // Values for ScheduledJobStateChanged.internal_stop_reason
    public static final int SCHEDULED_JOB_STATE_CHANGED__INTERNAL_STOP_REASON__INTERNAL_STOP_REASON_UNKNOWN = -1;
    public static final int SCHEDULED_JOB_STATE_CHANGED__INTERNAL_STOP_REASON__INTERNAL_STOP_REASON_CANCELLED = 0;
    public static final int SCHEDULED_JOB_STATE_CHANGED__INTERNAL_STOP_REASON__INTERNAL_STOP_REASON_CONSTRAINTS_NOT_SATISFIED = 1;
    public static final int SCHEDULED_JOB_STATE_CHANGED__INTERNAL_STOP_REASON__INTERNAL_STOP_REASON_PREEMPT = 2;
    public static final int SCHEDULED_JOB_STATE_CHANGED__INTERNAL_STOP_REASON__INTERNAL_STOP_REASON_TIMEOUT = 3;
    public static final int SCHEDULED_JOB_STATE_CHANGED__INTERNAL_STOP_REASON__INTERNAL_STOP_REASON_DEVICE_IDLE = 4;
    public static final int SCHEDULED_JOB_STATE_CHANGED__INTERNAL_STOP_REASON__INTERNAL_STOP_REASON_DEVICE_THERMAL = 5;
    public static final int SCHEDULED_JOB_STATE_CHANGED__INTERNAL_STOP_REASON__INTERNAL_STOP_REASON_RESTRICTED_BUCKET = 6;
    public static final int SCHEDULED_JOB_STATE_CHANGED__INTERNAL_STOP_REASON__INTERNAL_STOP_REASON_UNINSTALL = 7;
    public static final int SCHEDULED_JOB_STATE_CHANGED__INTERNAL_STOP_REASON__INTERNAL_STOP_REASON_DATA_CLEARED = 8;
    public static final int SCHEDULED_JOB_STATE_CHANGED__INTERNAL_STOP_REASON__INTERNAL_STOP_REASON_RTC_UPDATED = 9;
    public static final int SCHEDULED_JOB_STATE_CHANGED__INTERNAL_STOP_REASON__INTERNAL_STOP_REASON_SUCCESSFUL_FINISH = 10;
    public static final int SCHEDULED_JOB_STATE_CHANGED__INTERNAL_STOP_REASON__INTERNAL_STOP_REASON_USER_UI_STOP = 11;
    public static final int SCHEDULED_JOB_STATE_CHANGED__INTERNAL_STOP_REASON__INTERNAL_STOP_REASON_ANR = 12;

    // Values for ScheduledJobStateChanged.standby_bucket
    public static final int SCHEDULED_JOB_STATE_CHANGED__STANDBY_BUCKET__UNKNOWN = -1;
    public static final int SCHEDULED_JOB_STATE_CHANGED__STANDBY_BUCKET__ACTIVE = 0;
    public static final int SCHEDULED_JOB_STATE_CHANGED__STANDBY_BUCKET__WORKING_SET = 1;
    public static final int SCHEDULED_JOB_STATE_CHANGED__STANDBY_BUCKET__FREQUENT = 2;
    public static final int SCHEDULED_JOB_STATE_CHANGED__STANDBY_BUCKET__RARE = 3;
    public static final int SCHEDULED_JOB_STATE_CHANGED__STANDBY_BUCKET__NEVER = 4;
    public static final int SCHEDULED_JOB_STATE_CHANGED__STANDBY_BUCKET__RESTRICTED = 5;

    // Values for ScheduledJobStateChanged.public_stop_reason
    public static final int SCHEDULED_JOB_STATE_CHANGED__PUBLIC_STOP_REASON__STOP_REASON_UNDEFINED = 0;
    public static final int SCHEDULED_JOB_STATE_CHANGED__PUBLIC_STOP_REASON__STOP_REASON_CANCELLED_BY_APP = 1;
    public static final int SCHEDULED_JOB_STATE_CHANGED__PUBLIC_STOP_REASON__STOP_REASON_PREEMPT = 2;
    public static final int SCHEDULED_JOB_STATE_CHANGED__PUBLIC_STOP_REASON__STOP_REASON_TIMEOUT = 3;
    public static final int SCHEDULED_JOB_STATE_CHANGED__PUBLIC_STOP_REASON__STOP_REASON_DEVICE_STATE = 4;
    public static final int SCHEDULED_JOB_STATE_CHANGED__PUBLIC_STOP_REASON__STOP_REASON_CONSTRAINT_BATTERY_NOT_LOW = 5;
    public static final int SCHEDULED_JOB_STATE_CHANGED__PUBLIC_STOP_REASON__STOP_REASON_CONSTRAINT_CHARGING = 6;
    public static final int SCHEDULED_JOB_STATE_CHANGED__PUBLIC_STOP_REASON__STOP_REASON_CONSTRAINT_CONNECTIVITY = 7;
    public static final int SCHEDULED_JOB_STATE_CHANGED__PUBLIC_STOP_REASON__STOP_REASON_CONSTRAINT_DEVICE_IDLE = 8;
    public static final int SCHEDULED_JOB_STATE_CHANGED__PUBLIC_STOP_REASON__STOP_REASON_CONSTRAINT_STORAGE_NOT_LOW = 9;
    public static final int SCHEDULED_JOB_STATE_CHANGED__PUBLIC_STOP_REASON__STOP_REASON_QUOTA = 10;
    public static final int SCHEDULED_JOB_STATE_CHANGED__PUBLIC_STOP_REASON__STOP_REASON_BACKGROUND_RESTRICTION = 11;
    public static final int SCHEDULED_JOB_STATE_CHANGED__PUBLIC_STOP_REASON__STOP_REASON_APP_STANDBY = 12;
    public static final int SCHEDULED_JOB_STATE_CHANGED__PUBLIC_STOP_REASON__STOP_REASON_USER = 13;
    public static final int SCHEDULED_JOB_STATE_CHANGED__PUBLIC_STOP_REASON__STOP_REASON_SYSTEM_PROCESSING = 14;
    public static final int SCHEDULED_JOB_STATE_CHANGED__PUBLIC_STOP_REASON__STOP_REASON_ESTIMATED_APP_LAUNCH_TIME_CHANGED = 15;

    // Values for ScheduledJobStateChanged.proc_state
    public static final int SCHEDULED_JOB_STATE_CHANGED__PROC_STATE__PROCESS_STATE_UNKNOWN_TO_PROTO = 998;
    public static final int SCHEDULED_JOB_STATE_CHANGED__PROC_STATE__PROCESS_STATE_UNKNOWN = 999;
    public static final int SCHEDULED_JOB_STATE_CHANGED__PROC_STATE__PROCESS_STATE_PERSISTENT = 1000;
    public static final int SCHEDULED_JOB_STATE_CHANGED__PROC_STATE__PROCESS_STATE_PERSISTENT_UI = 1001;
    public static final int SCHEDULED_JOB_STATE_CHANGED__PROC_STATE__PROCESS_STATE_TOP = 1002;
    public static final int SCHEDULED_JOB_STATE_CHANGED__PROC_STATE__PROCESS_STATE_FOREGROUND_SERVICE = 1003;
    public static final int SCHEDULED_JOB_STATE_CHANGED__PROC_STATE__PROCESS_STATE_BOUND_FOREGROUND_SERVICE = 1004;
    public static final int SCHEDULED_JOB_STATE_CHANGED__PROC_STATE__PROCESS_STATE_IMPORTANT_FOREGROUND = 1005;
    public static final int SCHEDULED_JOB_STATE_CHANGED__PROC_STATE__PROCESS_STATE_IMPORTANT_BACKGROUND = 1006;
    public static final int SCHEDULED_JOB_STATE_CHANGED__PROC_STATE__PROCESS_STATE_TRANSIENT_BACKGROUND = 1007;
    public static final int SCHEDULED_JOB_STATE_CHANGED__PROC_STATE__PROCESS_STATE_BACKUP = 1008;
    public static final int SCHEDULED_JOB_STATE_CHANGED__PROC_STATE__PROCESS_STATE_SERVICE = 1009;
    public static final int SCHEDULED_JOB_STATE_CHANGED__PROC_STATE__PROCESS_STATE_RECEIVER = 1010;
    public static final int SCHEDULED_JOB_STATE_CHANGED__PROC_STATE__PROCESS_STATE_TOP_SLEEPING = 1011;
    public static final int SCHEDULED_JOB_STATE_CHANGED__PROC_STATE__PROCESS_STATE_HEAVY_WEIGHT = 1012;
    public static final int SCHEDULED_JOB_STATE_CHANGED__PROC_STATE__PROCESS_STATE_HOME = 1013;
    public static final int SCHEDULED_JOB_STATE_CHANGED__PROC_STATE__PROCESS_STATE_LAST_ACTIVITY = 1014;
    public static final int SCHEDULED_JOB_STATE_CHANGED__PROC_STATE__PROCESS_STATE_CACHED_ACTIVITY = 1015;
    public static final int SCHEDULED_JOB_STATE_CHANGED__PROC_STATE__PROCESS_STATE_CACHED_ACTIVITY_CLIENT = 1016;
    public static final int SCHEDULED_JOB_STATE_CHANGED__PROC_STATE__PROCESS_STATE_CACHED_RECENT = 1017;
    public static final int SCHEDULED_JOB_STATE_CHANGED__PROC_STATE__PROCESS_STATE_CACHED_EMPTY = 1018;
    public static final int SCHEDULED_JOB_STATE_CHANGED__PROC_STATE__PROCESS_STATE_NONEXISTENT = 1019;
    public static final int SCHEDULED_JOB_STATE_CHANGED__PROC_STATE__PROCESS_STATE_BOUND_TOP = 1020;

    // Values for WakelockStateChanged.type
    public static final int WAKELOCK_STATE_CHANGED__TYPE__PARTIAL_WAKE_LOCK = 1;
    public static final int WAKELOCK_STATE_CHANGED__TYPE__SCREEN_DIM_WAKE_LOCK = 6;
    public static final int WAKELOCK_STATE_CHANGED__TYPE__SCREEN_BRIGHT_WAKE_LOCK = 10;
    public static final int WAKELOCK_STATE_CHANGED__TYPE__FULL_WAKE_LOCK = 26;
    public static final int WAKELOCK_STATE_CHANGED__TYPE__PROXIMITY_SCREEN_OFF_WAKE_LOCK = 32;
    public static final int WAKELOCK_STATE_CHANGED__TYPE__DOZE_WAKE_LOCK = 64;
    public static final int WAKELOCK_STATE_CHANGED__TYPE__DRAW_WAKE_LOCK = 128;

    // Values for WakelockStateChanged.state
    public static final int WAKELOCK_STATE_CHANGED__STATE__RELEASE = 0;
    public static final int WAKELOCK_STATE_CHANGED__STATE__ACQUIRE = 1;
    public static final int WAKELOCK_STATE_CHANGED__STATE__CHANGE_RELEASE = 2;
    public static final int WAKELOCK_STATE_CHANGED__STATE__CHANGE_ACQUIRE = 3;

    // Values for WakelockStateChanged.process_state
    public static final int WAKELOCK_STATE_CHANGED__PROCESS_STATE__PROCESS_STATE_UNKNOWN_TO_PROTO = 998;
    public static final int WAKELOCK_STATE_CHANGED__PROCESS_STATE__PROCESS_STATE_UNKNOWN = 999;
    public static final int WAKELOCK_STATE_CHANGED__PROCESS_STATE__PROCESS_STATE_PERSISTENT = 1000;
    public static final int WAKELOCK_STATE_CHANGED__PROCESS_STATE__PROCESS_STATE_PERSISTENT_UI = 1001;
    public static final int WAKELOCK_STATE_CHANGED__PROCESS_STATE__PROCESS_STATE_TOP = 1002;
    public static final int WAKELOCK_STATE_CHANGED__PROCESS_STATE__PROCESS_STATE_FOREGROUND_SERVICE = 1003;
    public static final int WAKELOCK_STATE_CHANGED__PROCESS_STATE__PROCESS_STATE_BOUND_FOREGROUND_SERVICE = 1004;
    public static final int WAKELOCK_STATE_CHANGED__PROCESS_STATE__PROCESS_STATE_IMPORTANT_FOREGROUND = 1005;
    public static final int WAKELOCK_STATE_CHANGED__PROCESS_STATE__PROCESS_STATE_IMPORTANT_BACKGROUND = 1006;
    public static final int WAKELOCK_STATE_CHANGED__PROCESS_STATE__PROCESS_STATE_TRANSIENT_BACKGROUND = 1007;
    public static final int WAKELOCK_STATE_CHANGED__PROCESS_STATE__PROCESS_STATE_BACKUP = 1008;
    public static final int WAKELOCK_STATE_CHANGED__PROCESS_STATE__PROCESS_STATE_SERVICE = 1009;
    public static final int WAKELOCK_STATE_CHANGED__PROCESS_STATE__PROCESS_STATE_RECEIVER = 1010;
    public static final int WAKELOCK_STATE_CHANGED__PROCESS_STATE__PROCESS_STATE_TOP_SLEEPING = 1011;
    public static final int WAKELOCK_STATE_CHANGED__PROCESS_STATE__PROCESS_STATE_HEAVY_WEIGHT = 1012;
    public static final int WAKELOCK_STATE_CHANGED__PROCESS_STATE__PROCESS_STATE_HOME = 1013;
    public static final int WAKELOCK_STATE_CHANGED__PROCESS_STATE__PROCESS_STATE_LAST_ACTIVITY = 1014;
    public static final int WAKELOCK_STATE_CHANGED__PROCESS_STATE__PROCESS_STATE_CACHED_ACTIVITY = 1015;
    public static final int WAKELOCK_STATE_CHANGED__PROCESS_STATE__PROCESS_STATE_CACHED_ACTIVITY_CLIENT = 1016;
    public static final int WAKELOCK_STATE_CHANGED__PROCESS_STATE__PROCESS_STATE_CACHED_RECENT = 1017;
    public static final int WAKELOCK_STATE_CHANGED__PROCESS_STATE__PROCESS_STATE_CACHED_EMPTY = 1018;
    public static final int WAKELOCK_STATE_CHANGED__PROCESS_STATE__PROCESS_STATE_NONEXISTENT = 1019;
    public static final int WAKELOCK_STATE_CHANGED__PROCESS_STATE__PROCESS_STATE_BOUND_TOP = 1020;

    // Values for LongPartialWakelockStateChanged.state
    public static final int LONG_PARTIAL_WAKELOCK_STATE_CHANGED__STATE__OFF = 0;
    public static final int LONG_PARTIAL_WAKELOCK_STATE_CHANGED__STATE__ON = 1;

    // Values for MobileRadioPowerStateChanged.state
    public static final int MOBILE_RADIO_POWER_STATE_CHANGED__STATE__DATA_CONNECTION_POWER_STATE_LOW = 1;
    public static final int MOBILE_RADIO_POWER_STATE_CHANGED__STATE__DATA_CONNECTION_POWER_STATE_MEDIUM = 2;
    public static final int MOBILE_RADIO_POWER_STATE_CHANGED__STATE__DATA_CONNECTION_POWER_STATE_HIGH = 3;
    public static final int MOBILE_RADIO_POWER_STATE_CHANGED__STATE__DATA_CONNECTION_POWER_STATE_UNKNOWN = 2147483647;

    // Values for WifiRadioPowerStateChanged.state
    public static final int WIFI_RADIO_POWER_STATE_CHANGED__STATE__DATA_CONNECTION_POWER_STATE_LOW = 1;
    public static final int WIFI_RADIO_POWER_STATE_CHANGED__STATE__DATA_CONNECTION_POWER_STATE_MEDIUM = 2;
    public static final int WIFI_RADIO_POWER_STATE_CHANGED__STATE__DATA_CONNECTION_POWER_STATE_HIGH = 3;
    public static final int WIFI_RADIO_POWER_STATE_CHANGED__STATE__DATA_CONNECTION_POWER_STATE_UNKNOWN = 2147483647;

    // Values for ActivityManagerSleepStateChanged.state
    public static final int ACTIVITY_MANAGER_SLEEP_STATE_CHANGED__STATE__UNKNOWN = 0;
    public static final int ACTIVITY_MANAGER_SLEEP_STATE_CHANGED__STATE__ASLEEP = 1;
    public static final int ACTIVITY_MANAGER_SLEEP_STATE_CHANGED__STATE__AWAKE = 2;

    // Values for MemoryFactorStateChanged.factor
    public static final int MEMORY_FACTOR_STATE_CHANGED__FACTOR__MEMORY_UNKNOWN = 0;
    public static final int MEMORY_FACTOR_STATE_CHANGED__FACTOR__NORMAL = 1;
    public static final int MEMORY_FACTOR_STATE_CHANGED__FACTOR__MODERATE = 2;
    public static final int MEMORY_FACTOR_STATE_CHANGED__FACTOR__LOW = 3;
    public static final int MEMORY_FACTOR_STATE_CHANGED__FACTOR__CRITICAL = 4;

    // Values for ProcessMemoryStatReported.type
    public static final int PROCESS_MEMORY_STAT_REPORTED__TYPE__ADD_PSS_INTERNAL_SINGLE = 0;
    public static final int PROCESS_MEMORY_STAT_REPORTED__TYPE__ADD_PSS_INTERNAL_ALL_MEM = 1;
    public static final int PROCESS_MEMORY_STAT_REPORTED__TYPE__ADD_PSS_INTERNAL_ALL_POLL = 2;
    public static final int PROCESS_MEMORY_STAT_REPORTED__TYPE__ADD_PSS_EXTERNAL = 3;
    public static final int PROCESS_MEMORY_STAT_REPORTED__TYPE__ADD_PSS_EXTERNAL_SLOW = 4;

    // Values for BatterySaverModeStateChanged.state
    public static final int BATTERY_SAVER_MODE_STATE_CHANGED__STATE__OFF = 0;
    public static final int BATTERY_SAVER_MODE_STATE_CHANGED__STATE__ON = 1;

    // Values for DeviceIdleModeStateChanged.state
    public static final int DEVICE_IDLE_MODE_STATE_CHANGED__STATE__DEVICE_IDLE_MODE_OFF = 0;
    public static final int DEVICE_IDLE_MODE_STATE_CHANGED__STATE__DEVICE_IDLE_MODE_LIGHT = 1;
    public static final int DEVICE_IDLE_MODE_STATE_CHANGED__STATE__DEVICE_IDLE_MODE_DEEP = 2;

    // Values for DeviceIdlingModeStateChanged.state
    public static final int DEVICE_IDLING_MODE_STATE_CHANGED__STATE__DEVICE_IDLE_MODE_OFF = 0;
    public static final int DEVICE_IDLING_MODE_STATE_CHANGED__STATE__DEVICE_IDLE_MODE_LIGHT = 1;
    public static final int DEVICE_IDLING_MODE_STATE_CHANGED__STATE__DEVICE_IDLE_MODE_DEEP = 2;

    // Values for AudioStateChanged.state
    public static final int AUDIO_STATE_CHANGED__STATE__OFF = 0;
    public static final int AUDIO_STATE_CHANGED__STATE__ON = 1;
    public static final int AUDIO_STATE_CHANGED__STATE__RESET = 2;

    // Values for MediaCodecStateChanged.state
    public static final int MEDIA_CODEC_STATE_CHANGED__STATE__OFF = 0;
    public static final int MEDIA_CODEC_STATE_CHANGED__STATE__ON = 1;
    public static final int MEDIA_CODEC_STATE_CHANGED__STATE__RESET = 2;

    // Values for CameraStateChanged.state
    public static final int CAMERA_STATE_CHANGED__STATE__OFF = 0;
    public static final int CAMERA_STATE_CHANGED__STATE__ON = 1;
    public static final int CAMERA_STATE_CHANGED__STATE__RESET = 2;

    // Values for FlashlightStateChanged.state
    public static final int FLASHLIGHT_STATE_CHANGED__STATE__OFF = 0;
    public static final int FLASHLIGHT_STATE_CHANGED__STATE__ON = 1;
    public static final int FLASHLIGHT_STATE_CHANGED__STATE__RESET = 2;

    // Values for UidProcessStateChanged.state
    public static final int UID_PROCESS_STATE_CHANGED__STATE__PROCESS_STATE_UNKNOWN_TO_PROTO = 998;
    public static final int UID_PROCESS_STATE_CHANGED__STATE__PROCESS_STATE_UNKNOWN = 999;
    public static final int UID_PROCESS_STATE_CHANGED__STATE__PROCESS_STATE_PERSISTENT = 1000;
    public static final int UID_PROCESS_STATE_CHANGED__STATE__PROCESS_STATE_PERSISTENT_UI = 1001;
    public static final int UID_PROCESS_STATE_CHANGED__STATE__PROCESS_STATE_TOP = 1002;
    public static final int UID_PROCESS_STATE_CHANGED__STATE__PROCESS_STATE_FOREGROUND_SERVICE = 1003;
    public static final int UID_PROCESS_STATE_CHANGED__STATE__PROCESS_STATE_BOUND_FOREGROUND_SERVICE = 1004;
    public static final int UID_PROCESS_STATE_CHANGED__STATE__PROCESS_STATE_IMPORTANT_FOREGROUND = 1005;
    public static final int UID_PROCESS_STATE_CHANGED__STATE__PROCESS_STATE_IMPORTANT_BACKGROUND = 1006;
    public static final int UID_PROCESS_STATE_CHANGED__STATE__PROCESS_STATE_TRANSIENT_BACKGROUND = 1007;
    public static final int UID_PROCESS_STATE_CHANGED__STATE__PROCESS_STATE_BACKUP = 1008;
    public static final int UID_PROCESS_STATE_CHANGED__STATE__PROCESS_STATE_SERVICE = 1009;
    public static final int UID_PROCESS_STATE_CHANGED__STATE__PROCESS_STATE_RECEIVER = 1010;
    public static final int UID_PROCESS_STATE_CHANGED__STATE__PROCESS_STATE_TOP_SLEEPING = 1011;
    public static final int UID_PROCESS_STATE_CHANGED__STATE__PROCESS_STATE_HEAVY_WEIGHT = 1012;
    public static final int UID_PROCESS_STATE_CHANGED__STATE__PROCESS_STATE_HOME = 1013;
    public static final int UID_PROCESS_STATE_CHANGED__STATE__PROCESS_STATE_LAST_ACTIVITY = 1014;
    public static final int UID_PROCESS_STATE_CHANGED__STATE__PROCESS_STATE_CACHED_ACTIVITY = 1015;
    public static final int UID_PROCESS_STATE_CHANGED__STATE__PROCESS_STATE_CACHED_ACTIVITY_CLIENT = 1016;
    public static final int UID_PROCESS_STATE_CHANGED__STATE__PROCESS_STATE_CACHED_RECENT = 1017;
    public static final int UID_PROCESS_STATE_CHANGED__STATE__PROCESS_STATE_CACHED_EMPTY = 1018;
    public static final int UID_PROCESS_STATE_CHANGED__STATE__PROCESS_STATE_NONEXISTENT = 1019;
    public static final int UID_PROCESS_STATE_CHANGED__STATE__PROCESS_STATE_BOUND_TOP = 1020;

    // Values for ProcessLifeCycleStateChanged.state
    public static final int PROCESS_LIFE_CYCLE_STATE_CHANGED__STATE__FINISHED = 0;
    public static final int PROCESS_LIFE_CYCLE_STATE_CHANGED__STATE__STARTED = 1;
    public static final int PROCESS_LIFE_CYCLE_STATE_CHANGED__STATE__CRASHED = 2;

    // Values for ScreenStateChanged.state
    public static final int SCREEN_STATE_CHANGED__STATE__DISPLAY_STATE_UNKNOWN = 0;
    public static final int SCREEN_STATE_CHANGED__STATE__DISPLAY_STATE_OFF = 1;
    public static final int SCREEN_STATE_CHANGED__STATE__DISPLAY_STATE_ON = 2;
    public static final int SCREEN_STATE_CHANGED__STATE__DISPLAY_STATE_DOZE = 3;
    public static final int SCREEN_STATE_CHANGED__STATE__DISPLAY_STATE_DOZE_SUSPEND = 4;
    public static final int SCREEN_STATE_CHANGED__STATE__DISPLAY_STATE_VR = 5;
    public static final int SCREEN_STATE_CHANGED__STATE__DISPLAY_STATE_ON_SUSPEND = 6;

    // Values for ChargingStateChanged.state
    public static final int CHARGING_STATE_CHANGED__STATE__BATTERY_STATUS_INVALID = 0;
    public static final int CHARGING_STATE_CHANGED__STATE__BATTERY_STATUS_UNKNOWN = 1;
    public static final int CHARGING_STATE_CHANGED__STATE__BATTERY_STATUS_CHARGING = 2;
    public static final int CHARGING_STATE_CHANGED__STATE__BATTERY_STATUS_DISCHARGING = 3;
    public static final int CHARGING_STATE_CHANGED__STATE__BATTERY_STATUS_NOT_CHARGING = 4;
    public static final int CHARGING_STATE_CHANGED__STATE__BATTERY_STATUS_FULL = 5;

    // Values for PluggedStateChanged.state
    public static final int PLUGGED_STATE_CHANGED__STATE__BATTERY_PLUGGED_NONE = 0;
    public static final int PLUGGED_STATE_CHANGED__STATE__BATTERY_PLUGGED_AC = 1;
    public static final int PLUGGED_STATE_CHANGED__STATE__BATTERY_PLUGGED_USB = 2;
    public static final int PLUGGED_STATE_CHANGED__STATE__BATTERY_PLUGGED_WIRELESS = 4;
    public static final int PLUGGED_STATE_CHANGED__STATE__BATTERY_PLUGGED_DOCK = 8;

    // Values for InteractiveStateChanged.state
    public static final int INTERACTIVE_STATE_CHANGED__STATE__OFF = 0;
    public static final int INTERACTIVE_STATE_CHANGED__STATE__ON = 1;

    // Values for WakeupAlarmOccurred.app_standby_bucket
    public static final int WAKEUP_ALARM_OCCURRED__APP_STANDBY_BUCKET__BUCKET_UNKNOWN = 0;
    public static final int WAKEUP_ALARM_OCCURRED__APP_STANDBY_BUCKET__BUCKET_EXEMPTED = 5;
    public static final int WAKEUP_ALARM_OCCURRED__APP_STANDBY_BUCKET__BUCKET_ACTIVE = 10;
    public static final int WAKEUP_ALARM_OCCURRED__APP_STANDBY_BUCKET__BUCKET_WORKING_SET = 20;
    public static final int WAKEUP_ALARM_OCCURRED__APP_STANDBY_BUCKET__BUCKET_FREQUENT = 30;
    public static final int WAKEUP_ALARM_OCCURRED__APP_STANDBY_BUCKET__BUCKET_RARE = 40;
    public static final int WAKEUP_ALARM_OCCURRED__APP_STANDBY_BUCKET__BUCKET_RESTRICTED = 45;
    public static final int WAKEUP_ALARM_OCCURRED__APP_STANDBY_BUCKET__BUCKET_NEVER = 50;

    // Values for PhoneSignalStrengthChanged.signal_strength
    public static final int PHONE_SIGNAL_STRENGTH_CHANGED__SIGNAL_STRENGTH__SIGNAL_STRENGTH_NONE_OR_UNKNOWN = 0;
    public static final int PHONE_SIGNAL_STRENGTH_CHANGED__SIGNAL_STRENGTH__SIGNAL_STRENGTH_POOR = 1;
    public static final int PHONE_SIGNAL_STRENGTH_CHANGED__SIGNAL_STRENGTH__SIGNAL_STRENGTH_MODERATE = 2;
    public static final int PHONE_SIGNAL_STRENGTH_CHANGED__SIGNAL_STRENGTH__SIGNAL_STRENGTH_GOOD = 3;
    public static final int PHONE_SIGNAL_STRENGTH_CHANGED__SIGNAL_STRENGTH__SIGNAL_STRENGTH_GREAT = 4;

    // Values for SettingChanged.reason
    public static final int SETTING_CHANGED__REASON__UPDATED = 1;
    public static final int SETTING_CHANGED__REASON__DELETED = 2;

    // Values for ActivityForegroundStateChanged.state
    public static final int ACTIVITY_FOREGROUND_STATE_CHANGED__STATE__BACKGROUND = 0;
    public static final int ACTIVITY_FOREGROUND_STATE_CHANGED__STATE__FOREGROUND = 1;

    // Values for IsolatedUidChanged.event
    public static final int ISOLATED_UID_CHANGED__EVENT__REMOVED = 0;
    public static final int ISOLATED_UID_CHANGED__EVENT__CREATED = 1;

    // Values for AppStartOccurred.type
    public static final int APP_START_OCCURRED__TYPE__UNKNOWN = 0;
    public static final int APP_START_OCCURRED__TYPE__WARM = 1;
    public static final int APP_START_OCCURRED__TYPE__HOT = 2;
    public static final int APP_START_OCCURRED__TYPE__COLD = 3;
    public static final int APP_START_OCCURRED__TYPE__RELAUNCH = 4;

    // Values for AppStartOccurred.reason
    public static final int APP_START_OCCURRED__REASON__APP_TRANSITION_REASON_UNKNOWN = 0;
    public static final int APP_START_OCCURRED__REASON__APP_TRANSITION_SPLASH_SCREEN = 1;
    public static final int APP_START_OCCURRED__REASON__APP_TRANSITION_WINDOWS_DRAWN = 2;
    public static final int APP_START_OCCURRED__REASON__APP_TRANSITION_TIMEOUT = 3;
    public static final int APP_START_OCCURRED__REASON__APP_TRANSITION_SNAPSHOT = 4;
    public static final int APP_START_OCCURRED__REASON__APP_TRANSITION_RECENTS_ANIM = 5;

    // Values for AppStartOccurred.source_type
    public static final int APP_START_OCCURRED__SOURCE_TYPE__UNAVAILABLE = 0;
    public static final int APP_START_OCCURRED__SOURCE_TYPE__LAUNCHER = 1;
    public static final int APP_START_OCCURRED__SOURCE_TYPE__NOTIFICATION = 2;
    public static final int APP_START_OCCURRED__SOURCE_TYPE__LOCKSCREEN = 3;
    public static final int APP_START_OCCURRED__SOURCE_TYPE__RECENTS_ANIMATION = 4;

    // Values for AppStartOccurred.process_state
    public static final int APP_START_OCCURRED__PROCESS_STATE__PROCESS_STATE_UNKNOWN = -1;
    public static final int APP_START_OCCURRED__PROCESS_STATE__PROCESS_STATE_PERSISTENT = 0;
    public static final int APP_START_OCCURRED__PROCESS_STATE__PROCESS_STATE_PERSISTENT_UI = 1;
    public static final int APP_START_OCCURRED__PROCESS_STATE__PROCESS_STATE_TOP = 2;
    public static final int APP_START_OCCURRED__PROCESS_STATE__PROCESS_STATE_BOUND_TOP = 3;
    public static final int APP_START_OCCURRED__PROCESS_STATE__PROCESS_STATE_FOREGROUND_SERVICE = 4;
    public static final int APP_START_OCCURRED__PROCESS_STATE__PROCESS_STATE_BOUND_FOREGROUND_SERVICE = 5;
    public static final int APP_START_OCCURRED__PROCESS_STATE__PROCESS_STATE_IMPORTANT_FOREGROUND = 6;
    public static final int APP_START_OCCURRED__PROCESS_STATE__PROCESS_STATE_IMPORTANT_BACKGROUND = 7;
    public static final int APP_START_OCCURRED__PROCESS_STATE__PROCESS_STATE_TRANSIENT_BACKGROUND = 8;
    public static final int APP_START_OCCURRED__PROCESS_STATE__PROCESS_STATE_BACKUP = 9;
    public static final int APP_START_OCCURRED__PROCESS_STATE__PROCESS_STATE_SERVICE = 10;
    public static final int APP_START_OCCURRED__PROCESS_STATE__PROCESS_STATE_RECEIVER = 11;
    public static final int APP_START_OCCURRED__PROCESS_STATE__PROCESS_STATE_TOP_SLEEPING = 12;
    public static final int APP_START_OCCURRED__PROCESS_STATE__PROCESS_STATE_HEAVY_WEIGHT = 13;
    public static final int APP_START_OCCURRED__PROCESS_STATE__PROCESS_STATE_HOME = 14;
    public static final int APP_START_OCCURRED__PROCESS_STATE__PROCESS_STATE_LAST_ACTIVITY = 15;
    public static final int APP_START_OCCURRED__PROCESS_STATE__PROCESS_STATE_CACHED_ACTIVITY = 16;
    public static final int APP_START_OCCURRED__PROCESS_STATE__PROCESS_STATE_CACHED_ACTIVITY_CLIENT = 17;
    public static final int APP_START_OCCURRED__PROCESS_STATE__PROCESS_STATE_CACHED_RECENT = 18;
    public static final int APP_START_OCCURRED__PROCESS_STATE__PROCESS_STATE_CACHED_EMPTY = 19;
    public static final int APP_START_OCCURRED__PROCESS_STATE__PROCESS_STATE_NONEXISTENT = 20;

    // Values for AppStartOccurred.package_stopped_state
    public static final int APP_START_OCCURRED__PACKAGE_STOPPED_STATE__PACKAGE_STATE_UNKNOWN = 0;
    public static final int APP_START_OCCURRED__PACKAGE_STOPPED_STATE__PACKAGE_STATE_NORMAL = 1;
    public static final int APP_START_OCCURRED__PACKAGE_STOPPED_STATE__PACKAGE_STATE_STOPPED = 2;

    // Values for AppStartCanceled.type
    public static final int APP_START_CANCELED__TYPE__UNKNOWN = 0;
    public static final int APP_START_CANCELED__TYPE__WARM = 1;
    public static final int APP_START_CANCELED__TYPE__HOT = 2;
    public static final int APP_START_CANCELED__TYPE__COLD = 3;
    public static final int APP_START_CANCELED__TYPE__RELAUNCH = 4;

    // Values for AppStartFullyDrawn.type
    public static final int APP_START_FULLY_DRAWN__TYPE__UNKNOWN = 0;
    public static final int APP_START_FULLY_DRAWN__TYPE__WITH_BUNDLE = 1;
    public static final int APP_START_FULLY_DRAWN__TYPE__WITHOUT_BUNDLE = 2;

    // Values for AppStartFullyDrawn.source_type
    public static final int APP_START_FULLY_DRAWN__SOURCE_TYPE__UNAVAILABLE = 0;
    public static final int APP_START_FULLY_DRAWN__SOURCE_TYPE__LAUNCHER = 1;
    public static final int APP_START_FULLY_DRAWN__SOURCE_TYPE__NOTIFICATION = 2;
    public static final int APP_START_FULLY_DRAWN__SOURCE_TYPE__LOCKSCREEN = 3;

    // Values for LmkKillOccurred.reason
    public static final int LMK_KILL_OCCURRED__REASON__UNKNOWN = 0;
    public static final int LMK_KILL_OCCURRED__REASON__PRESSURE_AFTER_KILL = 1;
    public static final int LMK_KILL_OCCURRED__REASON__NOT_RESPONDING = 2;
    public static final int LMK_KILL_OCCURRED__REASON__LOW_SWAP_AND_THRASHING = 3;
    public static final int LMK_KILL_OCCURRED__REASON__LOW_MEM_AND_SWAP = 4;
    public static final int LMK_KILL_OCCURRED__REASON__LOW_MEM_AND_THRASHING = 5;
    public static final int LMK_KILL_OCCURRED__REASON__DIRECT_RECL_AND_THRASHING = 6;
    public static final int LMK_KILL_OCCURRED__REASON__LOW_MEM_AND_SWAP_UTIL = 7;
    public static final int LMK_KILL_OCCURRED__REASON__LOW_FILECACHE_AFTER_THRASHING = 8;

    // Values for PictureInPictureStateChanged.state
    public static final int PICTURE_IN_PICTURE_STATE_CHANGED__STATE__ENTERED = 1;
    public static final int PICTURE_IN_PICTURE_STATE_CHANGED__STATE__EXPANDED_TO_FULL_SCREEN = 2;
    public static final int PICTURE_IN_PICTURE_STATE_CHANGED__STATE__MINIMIZED = 3;
    public static final int PICTURE_IN_PICTURE_STATE_CHANGED__STATE__DISMISSED = 4;

    // Values for LmkStateChanged.state
    public static final int LMK_STATE_CHANGED__STATE__UNKNOWN = 0;
    public static final int LMK_STATE_CHANGED__STATE__START = 1;
    public static final int LMK_STATE_CHANGED__STATE__STOP = 2;

    // Values for OverlayStateChanged.state
    public static final int OVERLAY_STATE_CHANGED__STATE__ENTERED = 1;
    public static final int OVERLAY_STATE_CHANGED__STATE__EXITED = 2;

    // Values for ForegroundServiceStateChanged.state
    public static final int FOREGROUND_SERVICE_STATE_CHANGED__STATE__UNKNOWN_STATE = 0;
    public static final int FOREGROUND_SERVICE_STATE_CHANGED__STATE__ENTER = 1;
    public static final int FOREGROUND_SERVICE_STATE_CHANGED__STATE__EXIT = 2;
    public static final int FOREGROUND_SERVICE_STATE_CHANGED__STATE__DENIED = 3;
    public static final int FOREGROUND_SERVICE_STATE_CHANGED__STATE__API_CALL = 4;
    public static final int FOREGROUND_SERVICE_STATE_CHANGED__STATE__TIMED_OUT = 5;

    // Values for ForegroundServiceStateChanged.fgs_type_check_code
    public static final int FOREGROUND_SERVICE_STATE_CHANGED__FGS_TYPE_CHECK_CODE__FGS_TYPE_POLICY_CHECK_UNKNOWN = 0;
    public static final int FOREGROUND_SERVICE_STATE_CHANGED__FGS_TYPE_CHECK_CODE__FGS_TYPE_POLICY_CHECK_OK = 1;
    public static final int FOREGROUND_SERVICE_STATE_CHANGED__FGS_TYPE_CHECK_CODE__FGS_TYPE_POLICY_CHECK_DEPRECATED = 2;
    public static final int FOREGROUND_SERVICE_STATE_CHANGED__FGS_TYPE_CHECK_CODE__FGS_TYPE_POLICY_CHECK_DISABLED = 3;
    public static final int FOREGROUND_SERVICE_STATE_CHANGED__FGS_TYPE_CHECK_CODE__FGS_TYPE_POLICY_CHECK_PERMISSION_DENIED_PERMISSIVE = 4;
    public static final int FOREGROUND_SERVICE_STATE_CHANGED__FGS_TYPE_CHECK_CODE__FGS_TYPE_POLICY_CHECK_PERMISSION_DENIED_ENFORCED = 5;

    // Values for ForegroundServiceStateChanged.api_state
    public static final int FOREGROUND_SERVICE_STATE_CHANGED__API_STATE__UNKNOWN_JOURNEY_STATE = 0;
    public static final int FOREGROUND_SERVICE_STATE_CHANGED__API_STATE__ENTER_WITH_FGS = 1;
    public static final int FOREGROUND_SERVICE_STATE_CHANGED__API_STATE__EXIT_WITH_FGS = 2;
    public static final int FOREGROUND_SERVICE_STATE_CHANGED__API_STATE__EXIT_WITHOUT_FGS = 3;
    public static final int FOREGROUND_SERVICE_STATE_CHANGED__API_STATE__PAUSE = 4;
    public static final int FOREGROUND_SERVICE_STATE_CHANGED__API_STATE__RESUME = 5;

    // Values for ForegroundServiceStateChanged.api_type
    public static final int FOREGROUND_SERVICE_STATE_CHANGED__API_TYPE__UNKNOWN_API_TYPE = 0;
    public static final int FOREGROUND_SERVICE_STATE_CHANGED__API_TYPE__CAMERA = 1;
    public static final int FOREGROUND_SERVICE_STATE_CHANGED__API_TYPE__BLUETOOTH = 2;
    public static final int FOREGROUND_SERVICE_STATE_CHANGED__API_TYPE__LOCATION = 3;
    public static final int FOREGROUND_SERVICE_STATE_CHANGED__API_TYPE__MEDIA_PLAYBACK = 4;
    public static final int FOREGROUND_SERVICE_STATE_CHANGED__API_TYPE__AUDIO = 5;
    public static final int FOREGROUND_SERVICE_STATE_CHANGED__API_TYPE__MICROPHONE = 6;
    public static final int FOREGROUND_SERVICE_STATE_CHANGED__API_TYPE__PHONE_CALL = 7;
    public static final int FOREGROUND_SERVICE_STATE_CHANGED__API_TYPE__USB = 8;
    public static final int FOREGROUND_SERVICE_STATE_CHANGED__API_TYPE__CDM = 9;

    // Values for ForegroundServiceStateChanged.service_uid_state
    public static final int FOREGROUND_SERVICE_STATE_CHANGED__SERVICE_UID_STATE__PROCESS_STATE_UNKNOWN_TO_PROTO = 998;
    public static final int FOREGROUND_SERVICE_STATE_CHANGED__SERVICE_UID_STATE__PROCESS_STATE_UNKNOWN = 999;
    public static final int FOREGROUND_SERVICE_STATE_CHANGED__SERVICE_UID_STATE__PROCESS_STATE_PERSISTENT = 1000;
    public static final int FOREGROUND_SERVICE_STATE_CHANGED__SERVICE_UID_STATE__PROCESS_STATE_PERSISTENT_UI = 1001;
    public static final int FOREGROUND_SERVICE_STATE_CHANGED__SERVICE_UID_STATE__PROCESS_STATE_TOP = 1002;
    public static final int FOREGROUND_SERVICE_STATE_CHANGED__SERVICE_UID_STATE__PROCESS_STATE_FOREGROUND_SERVICE = 1003;
    public static final int FOREGROUND_SERVICE_STATE_CHANGED__SERVICE_UID_STATE__PROCESS_STATE_BOUND_FOREGROUND_SERVICE = 1004;
    public static final int FOREGROUND_SERVICE_STATE_CHANGED__SERVICE_UID_STATE__PROCESS_STATE_IMPORTANT_FOREGROUND = 1005;
    public static final int FOREGROUND_SERVICE_STATE_CHANGED__SERVICE_UID_STATE__PROCESS_STATE_IMPORTANT_BACKGROUND = 1006;
    public static final int FOREGROUND_SERVICE_STATE_CHANGED__SERVICE_UID_STATE__PROCESS_STATE_TRANSIENT_BACKGROUND = 1007;
    public static final int FOREGROUND_SERVICE_STATE_CHANGED__SERVICE_UID_STATE__PROCESS_STATE_BACKUP = 1008;
    public static final int FOREGROUND_SERVICE_STATE_CHANGED__SERVICE_UID_STATE__PROCESS_STATE_SERVICE = 1009;
    public static final int FOREGROUND_SERVICE_STATE_CHANGED__SERVICE_UID_STATE__PROCESS_STATE_RECEIVER = 1010;
    public static final int FOREGROUND_SERVICE_STATE_CHANGED__SERVICE_UID_STATE__PROCESS_STATE_TOP_SLEEPING = 1011;
    public static final int FOREGROUND_SERVICE_STATE_CHANGED__SERVICE_UID_STATE__PROCESS_STATE_HEAVY_WEIGHT = 1012;
    public static final int FOREGROUND_SERVICE_STATE_CHANGED__SERVICE_UID_STATE__PROCESS_STATE_HOME = 1013;
    public static final int FOREGROUND_SERVICE_STATE_CHANGED__SERVICE_UID_STATE__PROCESS_STATE_LAST_ACTIVITY = 1014;
    public static final int FOREGROUND_SERVICE_STATE_CHANGED__SERVICE_UID_STATE__PROCESS_STATE_CACHED_ACTIVITY = 1015;
    public static final int FOREGROUND_SERVICE_STATE_CHANGED__SERVICE_UID_STATE__PROCESS_STATE_CACHED_ACTIVITY_CLIENT = 1016;
    public static final int FOREGROUND_SERVICE_STATE_CHANGED__SERVICE_UID_STATE__PROCESS_STATE_CACHED_RECENT = 1017;
    public static final int FOREGROUND_SERVICE_STATE_CHANGED__SERVICE_UID_STATE__PROCESS_STATE_CACHED_EMPTY = 1018;
    public static final int FOREGROUND_SERVICE_STATE_CHANGED__SERVICE_UID_STATE__PROCESS_STATE_NONEXISTENT = 1019;
    public static final int FOREGROUND_SERVICE_STATE_CHANGED__SERVICE_UID_STATE__PROCESS_STATE_BOUND_TOP = 1020;

    // Values for ForegroundServiceStateChanged.service_uid_capabilities
    public static final int FOREGROUND_SERVICE_STATE_CHANGED__SERVICE_UID_CAPABILITIES__PROCESS_CAPABILITY_NONE = 0;
    public static final int FOREGROUND_SERVICE_STATE_CHANGED__SERVICE_UID_CAPABILITIES__PROCESS_CAPABILITY_FOREGROUND_LOCATION = 1;
    public static final int FOREGROUND_SERVICE_STATE_CHANGED__SERVICE_UID_CAPABILITIES__PROCESS_CAPABILITY_FOREGROUND_CAMERA = 2;
    public static final int FOREGROUND_SERVICE_STATE_CHANGED__SERVICE_UID_CAPABILITIES__PROCESS_CAPABILITY_FOREGROUND_MICROPHONE = 4;
    public static final int FOREGROUND_SERVICE_STATE_CHANGED__SERVICE_UID_CAPABILITIES__PROCESS_CAPABILITY_POWER_RESTRICTED_NETWORK = 8;
    public static final int FOREGROUND_SERVICE_STATE_CHANGED__SERVICE_UID_CAPABILITIES__PROCESS_CAPABILITY_BFSL = 16;
    public static final int FOREGROUND_SERVICE_STATE_CHANGED__SERVICE_UID_CAPABILITIES__PROCESS_CAPABILITY_USER_RESTRICTED_NETWORK = 32;

    // Values for ForegroundServiceStateChanged.calling_uid_state
    public static final int FOREGROUND_SERVICE_STATE_CHANGED__CALLING_UID_STATE__PROCESS_STATE_UNKNOWN_TO_PROTO = 998;
    public static final int FOREGROUND_SERVICE_STATE_CHANGED__CALLING_UID_STATE__PROCESS_STATE_UNKNOWN = 999;
    public static final int FOREGROUND_SERVICE_STATE_CHANGED__CALLING_UID_STATE__PROCESS_STATE_PERSISTENT = 1000;
    public static final int FOREGROUND_SERVICE_STATE_CHANGED__CALLING_UID_STATE__PROCESS_STATE_PERSISTENT_UI = 1001;
    public static final int FOREGROUND_SERVICE_STATE_CHANGED__CALLING_UID_STATE__PROCESS_STATE_TOP = 1002;
    public static final int FOREGROUND_SERVICE_STATE_CHANGED__CALLING_UID_STATE__PROCESS_STATE_FOREGROUND_SERVICE = 1003;
    public static final int FOREGROUND_SERVICE_STATE_CHANGED__CALLING_UID_STATE__PROCESS_STATE_BOUND_FOREGROUND_SERVICE = 1004;
    public static final int FOREGROUND_SERVICE_STATE_CHANGED__CALLING_UID_STATE__PROCESS_STATE_IMPORTANT_FOREGROUND = 1005;
    public static final int FOREGROUND_SERVICE_STATE_CHANGED__CALLING_UID_STATE__PROCESS_STATE_IMPORTANT_BACKGROUND = 1006;
    public static final int FOREGROUND_SERVICE_STATE_CHANGED__CALLING_UID_STATE__PROCESS_STATE_TRANSIENT_BACKGROUND = 1007;
    public static final int FOREGROUND_SERVICE_STATE_CHANGED__CALLING_UID_STATE__PROCESS_STATE_BACKUP = 1008;
    public static final int FOREGROUND_SERVICE_STATE_CHANGED__CALLING_UID_STATE__PROCESS_STATE_SERVICE = 1009;
    public static final int FOREGROUND_SERVICE_STATE_CHANGED__CALLING_UID_STATE__PROCESS_STATE_RECEIVER = 1010;
    public static final int FOREGROUND_SERVICE_STATE_CHANGED__CALLING_UID_STATE__PROCESS_STATE_TOP_SLEEPING = 1011;
    public static final int FOREGROUND_SERVICE_STATE_CHANGED__CALLING_UID_STATE__PROCESS_STATE_HEAVY_WEIGHT = 1012;
    public static final int FOREGROUND_SERVICE_STATE_CHANGED__CALLING_UID_STATE__PROCESS_STATE_HOME = 1013;
    public static final int FOREGROUND_SERVICE_STATE_CHANGED__CALLING_UID_STATE__PROCESS_STATE_LAST_ACTIVITY = 1014;
    public static final int FOREGROUND_SERVICE_STATE_CHANGED__CALLING_UID_STATE__PROCESS_STATE_CACHED_ACTIVITY = 1015;
    public static final int FOREGROUND_SERVICE_STATE_CHANGED__CALLING_UID_STATE__PROCESS_STATE_CACHED_ACTIVITY_CLIENT = 1016;
    public static final int FOREGROUND_SERVICE_STATE_CHANGED__CALLING_UID_STATE__PROCESS_STATE_CACHED_RECENT = 1017;
    public static final int FOREGROUND_SERVICE_STATE_CHANGED__CALLING_UID_STATE__PROCESS_STATE_CACHED_EMPTY = 1018;
    public static final int FOREGROUND_SERVICE_STATE_CHANGED__CALLING_UID_STATE__PROCESS_STATE_NONEXISTENT = 1019;
    public static final int FOREGROUND_SERVICE_STATE_CHANGED__CALLING_UID_STATE__PROCESS_STATE_BOUND_TOP = 1020;

    // Values for ForegroundServiceStateChanged.calling_uid_capabilities
    public static final int FOREGROUND_SERVICE_STATE_CHANGED__CALLING_UID_CAPABILITIES__PROCESS_CAPABILITY_NONE = 0;
    public static final int FOREGROUND_SERVICE_STATE_CHANGED__CALLING_UID_CAPABILITIES__PROCESS_CAPABILITY_FOREGROUND_LOCATION = 1;
    public static final int FOREGROUND_SERVICE_STATE_CHANGED__CALLING_UID_CAPABILITIES__PROCESS_CAPABILITY_FOREGROUND_CAMERA = 2;
    public static final int FOREGROUND_SERVICE_STATE_CHANGED__CALLING_UID_CAPABILITIES__PROCESS_CAPABILITY_FOREGROUND_MICROPHONE = 4;
    public static final int FOREGROUND_SERVICE_STATE_CHANGED__CALLING_UID_CAPABILITIES__PROCESS_CAPABILITY_POWER_RESTRICTED_NETWORK = 8;
    public static final int FOREGROUND_SERVICE_STATE_CHANGED__CALLING_UID_CAPABILITIES__PROCESS_CAPABILITY_BFSL = 16;
    public static final int FOREGROUND_SERVICE_STATE_CHANGED__CALLING_UID_CAPABILITIES__PROCESS_CAPABILITY_USER_RESTRICTED_NETWORK = 32;

    // Values for BluetoothEnabledStateChanged.state
    public static final int BLUETOOTH_ENABLED_STATE_CHANGED__STATE__UNKNOWN = 0;
    public static final int BLUETOOTH_ENABLED_STATE_CHANGED__STATE__ENABLED = 1;
    public static final int BLUETOOTH_ENABLED_STATE_CHANGED__STATE__DISABLED = 2;

    // Values for BluetoothEnabledStateChanged.reason
    public static final int BLUETOOTH_ENABLED_STATE_CHANGED__REASON__ENABLE_DISABLE_REASON_UNSPECIFIED = 0;
    public static final int BLUETOOTH_ENABLED_STATE_CHANGED__REASON__ENABLE_DISABLE_REASON_APPLICATION_REQUEST = 1;
    public static final int BLUETOOTH_ENABLED_STATE_CHANGED__REASON__ENABLE_DISABLE_REASON_AIRPLANE_MODE = 2;
    public static final int BLUETOOTH_ENABLED_STATE_CHANGED__REASON__ENABLE_DISABLE_REASON_DISALLOWED = 3;
    public static final int BLUETOOTH_ENABLED_STATE_CHANGED__REASON__ENABLE_DISABLE_REASON_RESTARTED = 4;
    public static final int BLUETOOTH_ENABLED_STATE_CHANGED__REASON__ENABLE_DISABLE_REASON_START_ERROR = 5;
    public static final int BLUETOOTH_ENABLED_STATE_CHANGED__REASON__ENABLE_DISABLE_REASON_SYSTEM_BOOT = 6;
    public static final int BLUETOOTH_ENABLED_STATE_CHANGED__REASON__ENABLE_DISABLE_REASON_CRASH = 7;
    public static final int BLUETOOTH_ENABLED_STATE_CHANGED__REASON__ENABLE_DISABLE_REASON_USER_SWITCH = 8;
    public static final int BLUETOOTH_ENABLED_STATE_CHANGED__REASON__ENABLE_DISABLE_REASON_RESTORE_USER_SETTING = 9;
    public static final int BLUETOOTH_ENABLED_STATE_CHANGED__REASON__ENABLE_DISABLE_REASON_FACTORY_RESET = 10;
    public static final int BLUETOOTH_ENABLED_STATE_CHANGED__REASON__ENABLE_DISABLE_REASON_INIT_FLAGS_CHANGED = 11;
    public static final int BLUETOOTH_ENABLED_STATE_CHANGED__REASON__ENABLE_DISABLE_REASON_SATELLITE_MODE = 12;

    // Values for GpsSignalQualityChanged.level
    public static final int GPS_SIGNAL_QUALITY_CHANGED__LEVEL__GPS_SIGNAL_QUALITY_UNKNOWN = -1;
    public static final int GPS_SIGNAL_QUALITY_CHANGED__LEVEL__GPS_SIGNAL_QUALITY_POOR = 0;
    public static final int GPS_SIGNAL_QUALITY_CHANGED__LEVEL__GPS_SIGNAL_QUALITY_GOOD = 1;

    // Values for UsbConnectorStateChanged.state
    public static final int USB_CONNECTOR_STATE_CHANGED__STATE__STATE_DISCONNECTED = 0;
    public static final int USB_CONNECTOR_STATE_CHANGED__STATE__STATE_CONNECTED = 1;

    // Values for UsbDeviceAttached.state
    public static final int USB_DEVICE_ATTACHED__STATE__STATE_DISCONNECTED = 0;
    public static final int USB_DEVICE_ATTACHED__STATE__STATE_CONNECTED = 1;

    // Values for AppCrashOccurred.is_instant_app
    public static final int APP_CRASH_OCCURRED__IS_INSTANT_APP__UNAVAILABLE = 0;
    public static final int APP_CRASH_OCCURRED__IS_INSTANT_APP__FALSE = 1;
    public static final int APP_CRASH_OCCURRED__IS_INSTANT_APP__TRUE = 2;

    // Values for AppCrashOccurred.foreground_state
    public static final int APP_CRASH_OCCURRED__FOREGROUND_STATE__UNKNOWN = 0;
    public static final int APP_CRASH_OCCURRED__FOREGROUND_STATE__BACKGROUND = 1;
    public static final int APP_CRASH_OCCURRED__FOREGROUND_STATE__FOREGROUND = 2;

    // Values for AppCrashOccurred.error_source
    public static final int APP_CRASH_OCCURRED__ERROR_SOURCE__ERROR_SOURCE_UNKNOWN = 0;
    public static final int APP_CRASH_OCCURRED__ERROR_SOURCE__DATA_APP = 1;
    public static final int APP_CRASH_OCCURRED__ERROR_SOURCE__SYSTEM_APP = 2;
    public static final int APP_CRASH_OCCURRED__ERROR_SOURCE__SYSTEM_SERVER = 3;

    // Values for ANROccurred.is_instant_app
    public static final int ANROCCURRED__IS_INSTANT_APP__UNAVAILABLE = 0;
    public static final int ANROCCURRED__IS_INSTANT_APP__FALSE = 1;
    public static final int ANROCCURRED__IS_INSTANT_APP__TRUE = 2;

    // Values for ANROccurred.foreground_state
    public static final int ANROCCURRED__FOREGROUND_STATE__UNKNOWN = 0;
    public static final int ANROCCURRED__FOREGROUND_STATE__BACKGROUND = 1;
    public static final int ANROCCURRED__FOREGROUND_STATE__FOREGROUND = 2;

    // Values for ANROccurred.error_source
    public static final int ANROCCURRED__ERROR_SOURCE__ERROR_SOURCE_UNKNOWN = 0;
    public static final int ANROCCURRED__ERROR_SOURCE__DATA_APP = 1;
    public static final int ANROCCURRED__ERROR_SOURCE__SYSTEM_APP = 2;
    public static final int ANROCCURRED__ERROR_SOURCE__SYSTEM_SERVER = 3;

    // Values for WTFOccurred.error_source
    public static final int WTFOCCURRED__ERROR_SOURCE__ERROR_SOURCE_UNKNOWN = 0;
    public static final int WTFOCCURRED__ERROR_SOURCE__DATA_APP = 1;
    public static final int WTFOCCURRED__ERROR_SOURCE__SYSTEM_APP = 2;
    public static final int WTFOCCURRED__ERROR_SOURCE__SYSTEM_SERVER = 3;

    // Values for VibratorStateChanged.state
    public static final int VIBRATOR_STATE_CHANGED__STATE__OFF = 0;
    public static final int VIBRATOR_STATE_CHANGED__STATE__ON = 1;

    // Values for BiometricAcquired.modality
    public static final int BIOMETRIC_ACQUIRED__MODALITY__MODALITY_UNKNOWN = 0;
    public static final int BIOMETRIC_ACQUIRED__MODALITY__MODALITY_FINGERPRINT = 1;
    public static final int BIOMETRIC_ACQUIRED__MODALITY__MODALITY_IRIS = 2;
    public static final int BIOMETRIC_ACQUIRED__MODALITY__MODALITY_FACE = 4;

    // Values for BiometricAcquired.action
    public static final int BIOMETRIC_ACQUIRED__ACTION__ACTION_UNKNOWN = 0;
    public static final int BIOMETRIC_ACQUIRED__ACTION__ACTION_ENROLL = 1;
    public static final int BIOMETRIC_ACQUIRED__ACTION__ACTION_AUTHENTICATE = 2;
    public static final int BIOMETRIC_ACQUIRED__ACTION__ACTION_ENUMERATE = 3;
    public static final int BIOMETRIC_ACQUIRED__ACTION__ACTION_REMOVE = 4;

    // Values for BiometricAcquired.client
    public static final int BIOMETRIC_ACQUIRED__CLIENT__CLIENT_UNKNOWN = 0;
    public static final int BIOMETRIC_ACQUIRED__CLIENT__CLIENT_KEYGUARD = 1;
    public static final int BIOMETRIC_ACQUIRED__CLIENT__CLIENT_BIOMETRIC_PROMPT = 2;
    public static final int BIOMETRIC_ACQUIRED__CLIENT__CLIENT_FINGERPRINT_MANAGER = 3;

    // Values for BiometricAcquired.session_type
    public static final int BIOMETRIC_ACQUIRED__SESSION_TYPE__SESSION_TYPE_UNKNOWN = 0;
    public static final int BIOMETRIC_ACQUIRED__SESSION_TYPE__SESSION_TYPE_KEYGUARD_ENTRY = 1;
    public static final int BIOMETRIC_ACQUIRED__SESSION_TYPE__SESSION_TYPE_BIOMETRIC_PROMPT = 2;

    // Values for BiometricAcquired.dock_state
    public static final int BIOMETRIC_ACQUIRED__DOCK_STATE__DOCK_STATE_UNDOCKED = 0;
    public static final int BIOMETRIC_ACQUIRED__DOCK_STATE__DOCK_STATE_DESK = 1;
    public static final int BIOMETRIC_ACQUIRED__DOCK_STATE__DOCK_STATE_CAR = 2;
    public static final int BIOMETRIC_ACQUIRED__DOCK_STATE__DOCK_STATE_LE_DESK = 3;
    public static final int BIOMETRIC_ACQUIRED__DOCK_STATE__DOCK_STATE_HE_DESK = 4;

    // Values for BiometricAcquired.orientation
    public static final int BIOMETRIC_ACQUIRED__ORIENTATION__ORIENTATION_UNKNOWN = 0;
    public static final int BIOMETRIC_ACQUIRED__ORIENTATION__ORIENTATION_0 = 1;
    public static final int BIOMETRIC_ACQUIRED__ORIENTATION__ORIENTATION_90 = 2;
    public static final int BIOMETRIC_ACQUIRED__ORIENTATION__ORIENTATION_180 = 3;
    public static final int BIOMETRIC_ACQUIRED__ORIENTATION__ORIENTATION_270 = 4;

    // Values for BiometricAcquired.fold_state
    public static final int BIOMETRIC_ACQUIRED__FOLD_STATE__FOLD_UNKNOWN = 0;
    public static final int BIOMETRIC_ACQUIRED__FOLD_STATE__FOLD_OPEN = 1;
    public static final int BIOMETRIC_ACQUIRED__FOLD_STATE__FOLD_CLOSED = 2;
    public static final int BIOMETRIC_ACQUIRED__FOLD_STATE__FOLD_HALF_OPEN = 3;

    // Values for BiometricAcquired.wake_reason
    public static final int BIOMETRIC_ACQUIRED__WAKE_REASON__WAKE_REASON_UNKNOWN = 0;
    public static final int BIOMETRIC_ACQUIRED__WAKE_REASON__WAKE_REASON_POWER_BUTTON = 1;
    public static final int BIOMETRIC_ACQUIRED__WAKE_REASON__WAKE_REASON_GESTURE = 2;
    public static final int BIOMETRIC_ACQUIRED__WAKE_REASON__WAKE_REASON_WAKE_KEY = 3;
    public static final int BIOMETRIC_ACQUIRED__WAKE_REASON__WAKE_REASON_WAKE_MOTION = 4;
    public static final int BIOMETRIC_ACQUIRED__WAKE_REASON__WAKE_REASON_LID = 5;
    public static final int BIOMETRIC_ACQUIRED__WAKE_REASON__WAKE_REASON_DISPLAY_GROUP_ADDED = 6;
    public static final int BIOMETRIC_ACQUIRED__WAKE_REASON__WAKE_REASON_TAP = 7;
    public static final int BIOMETRIC_ACQUIRED__WAKE_REASON__WAKE_REASON_LIFT = 8;
    public static final int BIOMETRIC_ACQUIRED__WAKE_REASON__WAKE_REASON_BIOMETRIC = 9;

    // Values for BiometricAuthenticated.modality
    public static final int BIOMETRIC_AUTHENTICATED__MODALITY__MODALITY_UNKNOWN = 0;
    public static final int BIOMETRIC_AUTHENTICATED__MODALITY__MODALITY_FINGERPRINT = 1;
    public static final int BIOMETRIC_AUTHENTICATED__MODALITY__MODALITY_IRIS = 2;
    public static final int BIOMETRIC_AUTHENTICATED__MODALITY__MODALITY_FACE = 4;

    // Values for BiometricAuthenticated.client
    public static final int BIOMETRIC_AUTHENTICATED__CLIENT__CLIENT_UNKNOWN = 0;
    public static final int BIOMETRIC_AUTHENTICATED__CLIENT__CLIENT_KEYGUARD = 1;
    public static final int BIOMETRIC_AUTHENTICATED__CLIENT__CLIENT_BIOMETRIC_PROMPT = 2;
    public static final int BIOMETRIC_AUTHENTICATED__CLIENT__CLIENT_FINGERPRINT_MANAGER = 3;

    // Values for BiometricAuthenticated.state
    public static final int BIOMETRIC_AUTHENTICATED__STATE__UNKNOWN = 0;
    public static final int BIOMETRIC_AUTHENTICATED__STATE__REJECTED = 1;
    public static final int BIOMETRIC_AUTHENTICATED__STATE__PENDING_CONFIRMATION = 2;
    public static final int BIOMETRIC_AUTHENTICATED__STATE__CONFIRMED = 3;

    // Values for BiometricAuthenticated.session_type
    public static final int BIOMETRIC_AUTHENTICATED__SESSION_TYPE__SESSION_TYPE_UNKNOWN = 0;
    public static final int BIOMETRIC_AUTHENTICATED__SESSION_TYPE__SESSION_TYPE_KEYGUARD_ENTRY = 1;
    public static final int BIOMETRIC_AUTHENTICATED__SESSION_TYPE__SESSION_TYPE_BIOMETRIC_PROMPT = 2;

    // Values for BiometricAuthenticated.dock_state
    public static final int BIOMETRIC_AUTHENTICATED__DOCK_STATE__DOCK_STATE_UNDOCKED = 0;
    public static final int BIOMETRIC_AUTHENTICATED__DOCK_STATE__DOCK_STATE_DESK = 1;
    public static final int BIOMETRIC_AUTHENTICATED__DOCK_STATE__DOCK_STATE_CAR = 2;
    public static final int BIOMETRIC_AUTHENTICATED__DOCK_STATE__DOCK_STATE_LE_DESK = 3;
    public static final int BIOMETRIC_AUTHENTICATED__DOCK_STATE__DOCK_STATE_HE_DESK = 4;

    // Values for BiometricAuthenticated.orientation
    public static final int BIOMETRIC_AUTHENTICATED__ORIENTATION__ORIENTATION_UNKNOWN = 0;
    public static final int BIOMETRIC_AUTHENTICATED__ORIENTATION__ORIENTATION_0 = 1;
    public static final int BIOMETRIC_AUTHENTICATED__ORIENTATION__ORIENTATION_90 = 2;
    public static final int BIOMETRIC_AUTHENTICATED__ORIENTATION__ORIENTATION_180 = 3;
    public static final int BIOMETRIC_AUTHENTICATED__ORIENTATION__ORIENTATION_270 = 4;

    // Values for BiometricAuthenticated.fold_state
    public static final int BIOMETRIC_AUTHENTICATED__FOLD_STATE__FOLD_UNKNOWN = 0;
    public static final int BIOMETRIC_AUTHENTICATED__FOLD_STATE__FOLD_OPEN = 1;
    public static final int BIOMETRIC_AUTHENTICATED__FOLD_STATE__FOLD_CLOSED = 2;
    public static final int BIOMETRIC_AUTHENTICATED__FOLD_STATE__FOLD_HALF_OPEN = 3;

    // Values for BiometricAuthenticated.wake_reason
    public static final int BIOMETRIC_AUTHENTICATED__WAKE_REASON__WAKE_REASON_UNKNOWN = 0;
    public static final int BIOMETRIC_AUTHENTICATED__WAKE_REASON__WAKE_REASON_POWER_BUTTON = 1;
    public static final int BIOMETRIC_AUTHENTICATED__WAKE_REASON__WAKE_REASON_GESTURE = 2;
    public static final int BIOMETRIC_AUTHENTICATED__WAKE_REASON__WAKE_REASON_WAKE_KEY = 3;
    public static final int BIOMETRIC_AUTHENTICATED__WAKE_REASON__WAKE_REASON_WAKE_MOTION = 4;
    public static final int BIOMETRIC_AUTHENTICATED__WAKE_REASON__WAKE_REASON_LID = 5;
    public static final int BIOMETRIC_AUTHENTICATED__WAKE_REASON__WAKE_REASON_DISPLAY_GROUP_ADDED = 6;
    public static final int BIOMETRIC_AUTHENTICATED__WAKE_REASON__WAKE_REASON_TAP = 7;
    public static final int BIOMETRIC_AUTHENTICATED__WAKE_REASON__WAKE_REASON_LIFT = 8;
    public static final int BIOMETRIC_AUTHENTICATED__WAKE_REASON__WAKE_REASON_BIOMETRIC = 9;

    // Values for BiometricAuthenticated.wake_reason_details
    public static final int BIOMETRIC_AUTHENTICATED__WAKE_REASON_DETAILS__DETAILS_UNKNOWN = 0;
    public static final int BIOMETRIC_AUTHENTICATED__WAKE_REASON_DETAILS__DETAILS_FACE_STARTED_WAKING_UP = 1;
    public static final int BIOMETRIC_AUTHENTICATED__WAKE_REASON_DETAILS__DETAILS_FACE_PRIMARY_BOUNCER_SHOWN = 2;
    public static final int BIOMETRIC_AUTHENTICATED__WAKE_REASON_DETAILS__DETAILS_FACE_ASSISTANT_VISIBLE = 3;
    public static final int BIOMETRIC_AUTHENTICATED__WAKE_REASON_DETAILS__DETAILS_FACE_ALTERNATE_BIOMETRIC_BOUNCER_SHOWN = 4;
    public static final int BIOMETRIC_AUTHENTICATED__WAKE_REASON_DETAILS__DETAILS_FACE_NOTIFICATION_PANEL_CLICKED = 5;
    public static final int BIOMETRIC_AUTHENTICATED__WAKE_REASON_DETAILS__DETAILS_FACE_OCCLUDING_APP_REQUESTED = 6;
    public static final int BIOMETRIC_AUTHENTICATED__WAKE_REASON_DETAILS__DETAILS_FACE_PICK_UP_GESTURE_TRIGGERED = 7;
    public static final int BIOMETRIC_AUTHENTICATED__WAKE_REASON_DETAILS__DETAILS_FACE_QS_EXPANDED = 8;
    public static final int BIOMETRIC_AUTHENTICATED__WAKE_REASON_DETAILS__DETAILS_FACE_SWIPE_UP_ON_BOUNCER = 9;
    public static final int BIOMETRIC_AUTHENTICATED__WAKE_REASON_DETAILS__DETAILS_FACE_UDFPS_POINTER_DOWN = 10;

    // Values for BiometricErrorOccurred.modality
    public static final int BIOMETRIC_ERROR_OCCURRED__MODALITY__MODALITY_UNKNOWN = 0;
    public static final int BIOMETRIC_ERROR_OCCURRED__MODALITY__MODALITY_FINGERPRINT = 1;
    public static final int BIOMETRIC_ERROR_OCCURRED__MODALITY__MODALITY_IRIS = 2;
    public static final int BIOMETRIC_ERROR_OCCURRED__MODALITY__MODALITY_FACE = 4;

    // Values for BiometricErrorOccurred.action
    public static final int BIOMETRIC_ERROR_OCCURRED__ACTION__ACTION_UNKNOWN = 0;
    public static final int BIOMETRIC_ERROR_OCCURRED__ACTION__ACTION_ENROLL = 1;
    public static final int BIOMETRIC_ERROR_OCCURRED__ACTION__ACTION_AUTHENTICATE = 2;
    public static final int BIOMETRIC_ERROR_OCCURRED__ACTION__ACTION_ENUMERATE = 3;
    public static final int BIOMETRIC_ERROR_OCCURRED__ACTION__ACTION_REMOVE = 4;

    // Values for BiometricErrorOccurred.client
    public static final int BIOMETRIC_ERROR_OCCURRED__CLIENT__CLIENT_UNKNOWN = 0;
    public static final int BIOMETRIC_ERROR_OCCURRED__CLIENT__CLIENT_KEYGUARD = 1;
    public static final int BIOMETRIC_ERROR_OCCURRED__CLIENT__CLIENT_BIOMETRIC_PROMPT = 2;
    public static final int BIOMETRIC_ERROR_OCCURRED__CLIENT__CLIENT_FINGERPRINT_MANAGER = 3;

    // Values for BiometricErrorOccurred.session_type
    public static final int BIOMETRIC_ERROR_OCCURRED__SESSION_TYPE__SESSION_TYPE_UNKNOWN = 0;
    public static final int BIOMETRIC_ERROR_OCCURRED__SESSION_TYPE__SESSION_TYPE_KEYGUARD_ENTRY = 1;
    public static final int BIOMETRIC_ERROR_OCCURRED__SESSION_TYPE__SESSION_TYPE_BIOMETRIC_PROMPT = 2;

    // Values for BiometricErrorOccurred.dock_state
    public static final int BIOMETRIC_ERROR_OCCURRED__DOCK_STATE__DOCK_STATE_UNDOCKED = 0;
    public static final int BIOMETRIC_ERROR_OCCURRED__DOCK_STATE__DOCK_STATE_DESK = 1;
    public static final int BIOMETRIC_ERROR_OCCURRED__DOCK_STATE__DOCK_STATE_CAR = 2;
    public static final int BIOMETRIC_ERROR_OCCURRED__DOCK_STATE__DOCK_STATE_LE_DESK = 3;
    public static final int BIOMETRIC_ERROR_OCCURRED__DOCK_STATE__DOCK_STATE_HE_DESK = 4;

    // Values for BiometricErrorOccurred.orientation
    public static final int BIOMETRIC_ERROR_OCCURRED__ORIENTATION__ORIENTATION_UNKNOWN = 0;
    public static final int BIOMETRIC_ERROR_OCCURRED__ORIENTATION__ORIENTATION_0 = 1;
    public static final int BIOMETRIC_ERROR_OCCURRED__ORIENTATION__ORIENTATION_90 = 2;
    public static final int BIOMETRIC_ERROR_OCCURRED__ORIENTATION__ORIENTATION_180 = 3;
    public static final int BIOMETRIC_ERROR_OCCURRED__ORIENTATION__ORIENTATION_270 = 4;

    // Values for BiometricErrorOccurred.fold_state
    public static final int BIOMETRIC_ERROR_OCCURRED__FOLD_STATE__FOLD_UNKNOWN = 0;
    public static final int BIOMETRIC_ERROR_OCCURRED__FOLD_STATE__FOLD_OPEN = 1;
    public static final int BIOMETRIC_ERROR_OCCURRED__FOLD_STATE__FOLD_CLOSED = 2;
    public static final int BIOMETRIC_ERROR_OCCURRED__FOLD_STATE__FOLD_HALF_OPEN = 3;

    // Values for BiometricErrorOccurred.wake_reason
    public static final int BIOMETRIC_ERROR_OCCURRED__WAKE_REASON__WAKE_REASON_UNKNOWN = 0;
    public static final int BIOMETRIC_ERROR_OCCURRED__WAKE_REASON__WAKE_REASON_POWER_BUTTON = 1;
    public static final int BIOMETRIC_ERROR_OCCURRED__WAKE_REASON__WAKE_REASON_GESTURE = 2;
    public static final int BIOMETRIC_ERROR_OCCURRED__WAKE_REASON__WAKE_REASON_WAKE_KEY = 3;
    public static final int BIOMETRIC_ERROR_OCCURRED__WAKE_REASON__WAKE_REASON_WAKE_MOTION = 4;
    public static final int BIOMETRIC_ERROR_OCCURRED__WAKE_REASON__WAKE_REASON_LID = 5;
    public static final int BIOMETRIC_ERROR_OCCURRED__WAKE_REASON__WAKE_REASON_DISPLAY_GROUP_ADDED = 6;
    public static final int BIOMETRIC_ERROR_OCCURRED__WAKE_REASON__WAKE_REASON_TAP = 7;
    public static final int BIOMETRIC_ERROR_OCCURRED__WAKE_REASON__WAKE_REASON_LIFT = 8;
    public static final int BIOMETRIC_ERROR_OCCURRED__WAKE_REASON__WAKE_REASON_BIOMETRIC = 9;

    // Values for BiometricErrorOccurred.wake_reason_details
    public static final int BIOMETRIC_ERROR_OCCURRED__WAKE_REASON_DETAILS__DETAILS_UNKNOWN = 0;
    public static final int BIOMETRIC_ERROR_OCCURRED__WAKE_REASON_DETAILS__DETAILS_FACE_STARTED_WAKING_UP = 1;
    public static final int BIOMETRIC_ERROR_OCCURRED__WAKE_REASON_DETAILS__DETAILS_FACE_PRIMARY_BOUNCER_SHOWN = 2;
    public static final int BIOMETRIC_ERROR_OCCURRED__WAKE_REASON_DETAILS__DETAILS_FACE_ASSISTANT_VISIBLE = 3;
    public static final int BIOMETRIC_ERROR_OCCURRED__WAKE_REASON_DETAILS__DETAILS_FACE_ALTERNATE_BIOMETRIC_BOUNCER_SHOWN = 4;
    public static final int BIOMETRIC_ERROR_OCCURRED__WAKE_REASON_DETAILS__DETAILS_FACE_NOTIFICATION_PANEL_CLICKED = 5;
    public static final int BIOMETRIC_ERROR_OCCURRED__WAKE_REASON_DETAILS__DETAILS_FACE_OCCLUDING_APP_REQUESTED = 6;
    public static final int BIOMETRIC_ERROR_OCCURRED__WAKE_REASON_DETAILS__DETAILS_FACE_PICK_UP_GESTURE_TRIGGERED = 7;
    public static final int BIOMETRIC_ERROR_OCCURRED__WAKE_REASON_DETAILS__DETAILS_FACE_QS_EXPANDED = 8;
    public static final int BIOMETRIC_ERROR_OCCURRED__WAKE_REASON_DETAILS__DETAILS_FACE_SWIPE_UP_ON_BOUNCER = 9;
    public static final int BIOMETRIC_ERROR_OCCURRED__WAKE_REASON_DETAILS__DETAILS_FACE_UDFPS_POINTER_DOWN = 10;

    // Values for PhoneServiceStateChanged.state
    public static final int PHONE_SERVICE_STATE_CHANGED__STATE__SERVICE_STATE_IN_SERVICE = 0;
    public static final int PHONE_SERVICE_STATE_CHANGED__STATE__SERVICE_STATE_OUT_OF_SERVICE = 1;
    public static final int PHONE_SERVICE_STATE_CHANGED__STATE__SERVICE_STATE_EMERGENCY_ONLY = 2;
    public static final int PHONE_SERVICE_STATE_CHANGED__STATE__SERVICE_STATE_POWER_OFF = 3;

    // Values for PhoneServiceStateChanged.sim_state
    public static final int PHONE_SERVICE_STATE_CHANGED__SIM_STATE__SIM_STATE_UNKNOWN = 0;
    public static final int PHONE_SERVICE_STATE_CHANGED__SIM_STATE__SIM_STATE_ABSENT = 1;
    public static final int PHONE_SERVICE_STATE_CHANGED__SIM_STATE__SIM_STATE_PIN_REQUIRED = 2;
    public static final int PHONE_SERVICE_STATE_CHANGED__SIM_STATE__SIM_STATE_PUK_REQUIRED = 3;
    public static final int PHONE_SERVICE_STATE_CHANGED__SIM_STATE__SIM_STATE_NETWORK_LOCKED = 4;
    public static final int PHONE_SERVICE_STATE_CHANGED__SIM_STATE__SIM_STATE_READY = 5;
    public static final int PHONE_SERVICE_STATE_CHANGED__SIM_STATE__SIM_STATE_NOT_READY = 6;
    public static final int PHONE_SERVICE_STATE_CHANGED__SIM_STATE__SIM_STATE_PERM_DISABLED = 7;
    public static final int PHONE_SERVICE_STATE_CHANGED__SIM_STATE__SIM_STATE_CARD_IO_ERROR = 8;
    public static final int PHONE_SERVICE_STATE_CHANGED__SIM_STATE__SIM_STATE_CARD_RESTRICTED = 9;
    public static final int PHONE_SERVICE_STATE_CHANGED__SIM_STATE__SIM_STATE_LOADED = 10;
    public static final int PHONE_SERVICE_STATE_CHANGED__SIM_STATE__SIM_STATE_PRESENT = 11;

    // Values for PhoneServiceStateChanged.signal_strength
    public static final int PHONE_SERVICE_STATE_CHANGED__SIGNAL_STRENGTH__SIGNAL_STRENGTH_NONE_OR_UNKNOWN = 0;
    public static final int PHONE_SERVICE_STATE_CHANGED__SIGNAL_STRENGTH__SIGNAL_STRENGTH_POOR = 1;
    public static final int PHONE_SERVICE_STATE_CHANGED__SIGNAL_STRENGTH__SIGNAL_STRENGTH_MODERATE = 2;
    public static final int PHONE_SERVICE_STATE_CHANGED__SIGNAL_STRENGTH__SIGNAL_STRENGTH_GOOD = 3;
    public static final int PHONE_SERVICE_STATE_CHANGED__SIGNAL_STRENGTH__SIGNAL_STRENGTH_GREAT = 4;

    // Values for PhoneStateChanged.state
    public static final int PHONE_STATE_CHANGED__STATE__OFF = 0;
    public static final int PHONE_STATE_CHANGED__STATE__ON = 1;

    // Values for ConnectivityStateChanged.state
    public static final int CONNECTIVITY_STATE_CHANGED__STATE__UNKNOWN = 0;
    public static final int CONNECTIVITY_STATE_CHANGED__STATE__CONNECTED = 1;
    public static final int CONNECTIVITY_STATE_CHANGED__STATE__DISCONNECTED = 2;

    // Values for ServiceStateChanged.state
    public static final int SERVICE_STATE_CHANGED__STATE__START = 1;
    public static final int SERVICE_STATE_CHANGED__STATE__STOP = 2;

    // Values for DevicePolicyEvent.event_id
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__SET_PASSWORD_QUALITY = 1;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__SET_PASSWORD_MINIMUM_LENGTH = 2;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__SET_PASSWORD_MINIMUM_NUMERIC = 3;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__SET_PASSWORD_MINIMUM_NON_LETTER = 4;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__SET_PASSWORD_MINIMUM_LETTERS = 5;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__SET_PASSWORD_MINIMUM_LOWER_CASE = 6;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__SET_PASSWORD_MINIMUM_UPPER_CASE = 7;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__SET_PASSWORD_MINIMUM_SYMBOLS = 8;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__SET_KEYGUARD_DISABLED_FEATURES = 9;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__LOCK_NOW = 10;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__WIPE_DATA_WITH_REASON = 11;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__ADD_USER_RESTRICTION = 12;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__REMOVE_USER_RESTRICTION = 13;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__SET_SECURE_SETTING = 14;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__SET_SECURITY_LOGGING_ENABLED = 15;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__RETRIEVE_SECURITY_LOGS = 16;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__RETRIEVE_PRE_REBOOT_SECURITY_LOGS = 17;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__SET_PERMISSION_POLICY = 18;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__SET_PERMISSION_GRANT_STATE = 19;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__INSTALL_KEY_PAIR = 20;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__INSTALL_CA_CERT = 21;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__CHOOSE_PRIVATE_KEY_ALIAS = 22;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__REMOVE_KEY_PAIR = 23;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__UNINSTALL_CA_CERTS = 24;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__SET_CERT_INSTALLER_PACKAGE = 25;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__SET_ALWAYS_ON_VPN_PACKAGE = 26;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__SET_PERMITTED_INPUT_METHODS = 27;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__SET_PERMITTED_ACCESSIBILITY_SERVICES = 28;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__SET_SCREEN_CAPTURE_DISABLED = 29;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__SET_CAMERA_DISABLED = 30;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__QUERY_SUMMARY_FOR_USER = 31;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__QUERY_SUMMARY = 32;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__QUERY_DETAILS = 33;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__REBOOT = 34;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__SET_MASTER_VOLUME_MUTED = 35;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__SET_AUTO_TIME_REQUIRED = 36;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__SET_KEYGUARD_DISABLED = 37;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__SET_STATUS_BAR_DISABLED = 38;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__SET_ORGANIZATION_COLOR = 39;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__SET_PROFILE_NAME = 40;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__SET_USER_ICON = 41;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__SET_DEVICE_OWNER_LOCK_SCREEN_INFO = 42;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__SET_SHORT_SUPPORT_MESSAGE = 43;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__SET_LONG_SUPPORT_MESSAGE = 44;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__SET_CROSS_PROFILE_CONTACTS_SEARCH_DISABLED = 45;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__SET_CROSS_PROFILE_CALLER_ID_DISABLED = 46;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__SET_BLUETOOTH_CONTACT_SHARING_DISABLED = 47;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__ADD_CROSS_PROFILE_INTENT_FILTER = 48;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__ADD_CROSS_PROFILE_WIDGET_PROVIDER = 49;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__SET_SYSTEM_UPDATE_POLICY = 50;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__SET_LOCKTASK_MODE_ENABLED = 51;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__ADD_PERSISTENT_PREFERRED_ACTIVITY = 52;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__REQUEST_BUGREPORT = 53;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__GET_WIFI_MAC_ADDRESS = 54;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__REQUEST_QUIET_MODE_ENABLED = 55;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__WORK_PROFILE_LOCATION_CHANGED = 56;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__DO_USER_INFO_CLICKED = 57;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__TRANSFER_OWNERSHIP = 58;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__GENERATE_KEY_PAIR = 59;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__SET_KEY_PAIR_CERTIFICATE = 60;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__SET_KEEP_UNINSTALLED_PACKAGES = 61;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__SET_APPLICATION_RESTRICTIONS = 62;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__SET_APPLICATION_HIDDEN = 63;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__ENABLE_SYSTEM_APP = 64;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__ENABLE_SYSTEM_APP_WITH_INTENT = 65;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__INSTALL_EXISTING_PACKAGE = 66;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__SET_UNINSTALL_BLOCKED = 67;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__SET_PACKAGES_SUSPENDED = 68;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__ON_LOCK_TASK_MODE_ENTERING = 69;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__SET_CROSS_PROFILE_CALENDAR_PACKAGES = 70;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__GET_USER_PASSWORD_COMPLEXITY_LEVEL = 72;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__INSTALL_SYSTEM_UPDATE = 73;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__INSTALL_SYSTEM_UPDATE_ERROR = 74;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__IS_MANAGED_KIOSK = 75;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__IS_UNATTENDED_MANAGED_KIOSK = 76;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__PROVISIONING_MANAGED_PROFILE_ON_FULLY_MANAGED_DEVICE = 77;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__PROVISIONING_PERSISTENT_DEVICE_OWNER = 78;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__PROVISIONING_ENTRY_POINT_NFC = 79;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__PROVISIONING_ENTRY_POINT_QR_CODE = 80;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__PROVISIONING_ENTRY_POINT_CLOUD_ENROLLMENT = 81;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__PROVISIONING_ENTRY_POINT_ADB = 82;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__PROVISIONING_ENTRY_POINT_TRUSTED_SOURCE = 83;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__PROVISIONING_DPC_PACKAGE_NAME = 84;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__PROVISIONING_DPC_INSTALLED_BY_PACKAGE = 85;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__PROVISIONING_PROVISIONING_ACTIVITY_TIME_MS = 86;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__PROVISIONING_PREPROVISIONING_ACTIVITY_TIME_MS = 87;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__PROVISIONING_ENCRYPT_DEVICE_ACTIVITY_TIME_MS = 88;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__PROVISIONING_WEB_ACTIVITY_TIME_MS = 89;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__PROVISIONING_TRAMPOLINE_ACTIVITY_TIME_MS = 90;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__PROVISIONING_POST_ENCRYPTION_ACTIVITY_TIME_MS = 91;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__PROVISIONING_FINALIZATION_ACTIVITY_TIME_MS = 92;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__PROVISIONING_NETWORK_TYPE = 93;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__PROVISIONING_ACTION = 94;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__PROVISIONING_EXTRAS = 95;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__PROVISIONING_COPY_ACCOUNT_TASK_MS = 96;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__PROVISIONING_CREATE_PROFILE_TASK_MS = 97;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__PROVISIONING_START_PROFILE_TASK_MS = 98;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__PROVISIONING_DOWNLOAD_PACKAGE_TASK_MS = 99;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__PROVISIONING_INSTALL_PACKAGE_TASK_MS = 100;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__PROVISIONING_CANCELLED = 101;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__PROVISIONING_ERROR = 102;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__PROVISIONING_COPY_ACCOUNT_STATUS = 103;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__PROVISIONING_TOTAL_TASK_TIME_MS = 104;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__PROVISIONING_SESSION_STARTED = 105;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__PROVISIONING_SESSION_COMPLETED = 106;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__PROVISIONING_TERMS_ACTIVITY_TIME_MS = 107;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__PROVISIONING_TERMS_COUNT = 108;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__PROVISIONING_TERMS_READ = 109;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__SEPARATE_PROFILE_CHALLENGE_CHANGED = 110;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__SET_GLOBAL_SETTING = 111;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__INSTALL_PACKAGE = 112;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__UNINSTALL_PACKAGE = 113;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__WIFI_SERVICE_ADD_NETWORK_SUGGESTIONS = 114;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__WIFI_SERVICE_ADD_OR_UPDATE_NETWORK = 115;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__QUERY_SUMMARY_FOR_DEVICE = 116;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__REMOVE_CROSS_PROFILE_WIDGET_PROVIDER = 117;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__ESTABLISH_VPN = 118;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__SET_NETWORK_LOGGING_ENABLED = 119;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__RETRIEVE_NETWORK_LOGS = 120;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__PROVISIONING_PREPARE_TOTAL_TIME_MS = 121;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__PROVISIONING_PREPARE_STARTED = 122;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__PROVISIONING_PREPARE_COMPLETED = 123;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__PROVISIONING_FLOW_TYPE = 124;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__CROSS_PROFILE_APPS_GET_TARGET_USER_PROFILES = 125;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__CROSS_PROFILE_APPS_START_ACTIVITY_AS_USER = 126;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__SET_AUTO_TIME = 127;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__SET_AUTO_TIME_ZONE = 128;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__SET_USER_CONTROL_DISABLED_PACKAGES = 129;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__SET_FACTORY_RESET_PROTECTION = 130;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__SET_COMMON_CRITERIA_MODE = 131;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__ALLOW_MODIFICATION_OF_ADMIN_CONFIGURED_NETWORKS = 132;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__SET_TIME = 133;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__SET_TIME_ZONE = 134;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__SET_PERSONAL_APPS_SUSPENDED = 135;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__SET_MANAGED_PROFILE_MAXIMUM_TIME_OFF = 136;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__COMP_TO_ORG_OWNED_PO_MIGRATED = 137;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__SET_CROSS_PROFILE_PACKAGES = 138;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__SET_INTERACT_ACROSS_PROFILES_APP_OP = 139;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__GET_CROSS_PROFILE_PACKAGES = 140;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__CAN_REQUEST_INTERACT_ACROSS_PROFILES_TRUE = 141;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__CAN_REQUEST_INTERACT_ACROSS_PROFILES_FALSE_NO_PROFILES = 142;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__CAN_REQUEST_INTERACT_ACROSS_PROFILES_FALSE_WHITELIST = 143;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__CAN_REQUEST_INTERACT_ACROSS_PROFILES_FALSE_PERMISSION = 144;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__CAN_INTERACT_ACROSS_PROFILES_TRUE = 145;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__CAN_INTERACT_ACROSS_PROFILES_FALSE_PERMISSION = 146;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__CAN_INTERACT_ACROSS_PROFILES_FALSE_NO_PROFILES = 147;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__CREATE_CROSS_PROFILE_INTENT = 148;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__IS_MANAGED_PROFILE = 149;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__START_ACTIVITY_BY_INTENT = 150;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__BIND_CROSS_PROFILE_SERVICE = 151;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__PROVISIONING_DPC_SETUP_STARTED = 152;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__PROVISIONING_DPC_SETUP_COMPLETED = 153;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__PROVISIONING_ORGANIZATION_OWNED_MANAGED_PROFILE = 154;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__RESOLVER_CROSS_PROFILE_TARGET_OPENED = 155;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__RESOLVER_SWITCH_TABS = 156;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__RESOLVER_EMPTY_STATE_WORK_APPS_DISABLED = 157;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__RESOLVER_EMPTY_STATE_NO_SHARING_TO_PERSONAL = 158;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__RESOLVER_EMPTY_STATE_NO_SHARING_TO_WORK = 159;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__RESOLVER_EMPTY_STATE_NO_APPS_RESOLVED = 160;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__RESOLVER_AUTOLAUNCH_CROSS_PROFILE_TARGET = 161;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__CROSS_PROFILE_SETTINGS_PAGE_LAUNCHED_FROM_APP = 162;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__CROSS_PROFILE_SETTINGS_PAGE_LAUNCHED_FROM_SETTINGS = 163;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__CROSS_PROFILE_SETTINGS_PAGE_ADMIN_RESTRICTED = 164;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__CROSS_PROFILE_SETTINGS_PAGE_MISSING_WORK_APP = 165;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__CROSS_PROFILE_SETTINGS_PAGE_MISSING_PERSONAL_APP = 166;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__CROSS_PROFILE_SETTINGS_PAGE_MISSING_INSTALL_BANNER_INTENT = 167;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__CROSS_PROFILE_SETTINGS_PAGE_INSTALL_BANNER_CLICKED = 168;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__CROSS_PROFILE_SETTINGS_PAGE_INSTALL_BANNER_NO_INTENT_CLICKED = 169;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__CROSS_PROFILE_SETTINGS_PAGE_USER_CONSENTED = 170;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__CROSS_PROFILE_SETTINGS_PAGE_USER_DECLINED_CONSENT = 171;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__CROSS_PROFILE_SETTINGS_PAGE_PERMISSION_REVOKED = 172;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__DOCSUI_EMPTY_STATE_NO_PERMISSION = 173;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__DOCSUI_EMPTY_STATE_QUIET_MODE = 174;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__DOCSUI_LAUNCH_OTHER_APP = 175;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__DOCSUI_PICK_RESULT = 176;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__SET_PASSWORD_COMPLEXITY = 177;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__CREDENTIAL_MANAGEMENT_APP_REQUEST_NAME = 178;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__CREDENTIAL_MANAGEMENT_APP_REQUEST_POLICY = 179;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__CREDENTIAL_MANAGEMENT_APP_REQUEST_ACCEPTED = 180;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__CREDENTIAL_MANAGEMENT_APP_REQUEST_DENIED = 181;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__CREDENTIAL_MANAGEMENT_APP_REQUEST_FAILED = 182;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__CREDENTIAL_MANAGEMENT_APP_CREDENTIAL_FOUND_IN_POLICY = 183;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__CREDENTIAL_MANAGEMENT_APP_INSTALL_KEY_PAIR_FAILED = 184;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__CREDENTIAL_MANAGEMENT_APP_GENERATE_KEY_PAIR_FAILED = 185;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__CREDENTIAL_MANAGEMENT_APP_POLICY_LOOKUP_FAILED = 186;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__CREDENTIAL_MANAGEMENT_APP_REMOVED = 187;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__SET_ORGANIZATION_ID = 188;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__IS_ACTIVE_PASSWORD_SUFFICIENT_FOR_DEVICE = 189;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__PLATFORM_PROVISIONING_COPY_ACCOUNT_MS = 190;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__PLATFORM_PROVISIONING_CREATE_PROFILE_MS = 191;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__PLATFORM_PROVISIONING_START_PROFILE_MS = 192;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__PLATFORM_PROVISIONING_COPY_ACCOUNT_STATUS = 193;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__PLATFORM_PROVISIONING_ERROR = 194;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__PROVISIONING_PROVISION_MANAGED_PROFILE_TASK_MS = 195;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__PROVISIONING_PROVISION_FULLY_MANAGED_DEVICE_TASK_MS = 196;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__PLATFORM_PROVISIONING_PARAM = 197;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__SET_USB_DATA_SIGNALING = 198;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__SET_PREFERENTIAL_NETWORK_SERVICE_ENABLED = 199;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__PROVISIONING_IS_LANDSCAPE = 200;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__PROVISIONING_IS_NIGHT_MODE = 201;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__ADD_ACCOUNT = 202;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__ADD_ACCOUNT_EXPLICITLY = 203;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__GET_ACCOUNT_AUTH_TOKEN = 204;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__RESET_PASSWORD = 205;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__RESET_PASSWORD_WITH_TOKEN = 206;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__ROLE_HOLDER_PROVISIONING_START = 207;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__ROLE_HOLDER_PROVISIONING_FINISH = 208;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__ROLE_HOLDER_UPDATER_UPDATE_START = 209;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__ROLE_HOLDER_UPDATER_UPDATE_FINISH = 210;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__ROLE_HOLDER_UPDATER_UPDATE_RETRY = 211;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__ROLE_HOLDER_UPDATER_UPDATE_FAILED = 212;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__PLATFORM_ROLE_HOLDER_UPDATE_START = 213;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__PLATFORM_ROLE_HOLDER_UPDATE_FINISHED = 214;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__PLATFORM_ROLE_HOLDER_UPDATE_FAILED = 215;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__SET_MTE_POLICY = 216;
    public static final int DEVICE_POLICY_EVENT__EVENT_ID__SET_APPLICATION_EXEMPTIONS = 217;

    // Values for WifiEnabledStateChanged.state
    public static final int WIFI_ENABLED_STATE_CHANGED__STATE__OFF = 0;
    public static final int WIFI_ENABLED_STATE_CHANGED__STATE__ON = 1;

    // Values for WifiRunningStateChanged.state
    public static final int WIFI_RUNNING_STATE_CHANGED__STATE__OFF = 0;
    public static final int WIFI_RUNNING_STATE_CHANGED__STATE__ON = 1;

    // Values for AppCompacted.action
    public static final int APP_COMPACTED__ACTION__UNKNOWN = 0;
    public static final int APP_COMPACTED__ACTION__SOME = 1;
    public static final int APP_COMPACTED__ACTION__FULL = 2;
    public static final int APP_COMPACTED__ACTION__PERSISTENT = 3;
    public static final int APP_COMPACTED__ACTION__BFGS = 4;

    // Values for AppCompacted.last_action
    public static final int APP_COMPACTED__LAST_ACTION__UNKNOWN = 0;
    public static final int APP_COMPACTED__LAST_ACTION__SOME = 1;
    public static final int APP_COMPACTED__LAST_ACTION__FULL = 2;
    public static final int APP_COMPACTED__LAST_ACTION__PERSISTENT = 3;
    public static final int APP_COMPACTED__LAST_ACTION__BFGS = 4;

    // Values for AppCompacted.process_state
    public static final int APP_COMPACTED__PROCESS_STATE__PROCESS_STATE_UNKNOWN_TO_PROTO = 998;
    public static final int APP_COMPACTED__PROCESS_STATE__PROCESS_STATE_UNKNOWN = 999;
    public static final int APP_COMPACTED__PROCESS_STATE__PROCESS_STATE_PERSISTENT = 1000;
    public static final int APP_COMPACTED__PROCESS_STATE__PROCESS_STATE_PERSISTENT_UI = 1001;
    public static final int APP_COMPACTED__PROCESS_STATE__PROCESS_STATE_TOP = 1002;
    public static final int APP_COMPACTED__PROCESS_STATE__PROCESS_STATE_FOREGROUND_SERVICE = 1003;
    public static final int APP_COMPACTED__PROCESS_STATE__PROCESS_STATE_BOUND_FOREGROUND_SERVICE = 1004;
    public static final int APP_COMPACTED__PROCESS_STATE__PROCESS_STATE_IMPORTANT_FOREGROUND = 1005;
    public static final int APP_COMPACTED__PROCESS_STATE__PROCESS_STATE_IMPORTANT_BACKGROUND = 1006;
    public static final int APP_COMPACTED__PROCESS_STATE__PROCESS_STATE_TRANSIENT_BACKGROUND = 1007;
    public static final int APP_COMPACTED__PROCESS_STATE__PROCESS_STATE_BACKUP = 1008;
    public static final int APP_COMPACTED__PROCESS_STATE__PROCESS_STATE_SERVICE = 1009;
    public static final int APP_COMPACTED__PROCESS_STATE__PROCESS_STATE_RECEIVER = 1010;
    public static final int APP_COMPACTED__PROCESS_STATE__PROCESS_STATE_TOP_SLEEPING = 1011;
    public static final int APP_COMPACTED__PROCESS_STATE__PROCESS_STATE_HEAVY_WEIGHT = 1012;
    public static final int APP_COMPACTED__PROCESS_STATE__PROCESS_STATE_HOME = 1013;
    public static final int APP_COMPACTED__PROCESS_STATE__PROCESS_STATE_LAST_ACTIVITY = 1014;
    public static final int APP_COMPACTED__PROCESS_STATE__PROCESS_STATE_CACHED_ACTIVITY = 1015;
    public static final int APP_COMPACTED__PROCESS_STATE__PROCESS_STATE_CACHED_ACTIVITY_CLIENT = 1016;
    public static final int APP_COMPACTED__PROCESS_STATE__PROCESS_STATE_CACHED_RECENT = 1017;
    public static final int APP_COMPACTED__PROCESS_STATE__PROCESS_STATE_CACHED_EMPTY = 1018;
    public static final int APP_COMPACTED__PROCESS_STATE__PROCESS_STATE_NONEXISTENT = 1019;
    public static final int APP_COMPACTED__PROCESS_STATE__PROCESS_STATE_BOUND_TOP = 1020;

    // Values for SignedConfigReported.type
    public static final int SIGNED_CONFIG_REPORTED__TYPE__UNKNOWN_TYPE = 0;
    public static final int SIGNED_CONFIG_REPORTED__TYPE__GLOBAL_SETTINGS = 1;

    // Values for SignedConfigReported.status
    public static final int SIGNED_CONFIG_REPORTED__STATUS__UNKNOWN_STATUS = 0;
    public static final int SIGNED_CONFIG_REPORTED__STATUS__APPLIED = 1;
    public static final int SIGNED_CONFIG_REPORTED__STATUS__BASE64_FAILURE_CONFIG = 2;
    public static final int SIGNED_CONFIG_REPORTED__STATUS__BASE64_FAILURE_SIGNATURE = 3;
    public static final int SIGNED_CONFIG_REPORTED__STATUS__SECURITY_EXCEPTION = 4;
    public static final int SIGNED_CONFIG_REPORTED__STATUS__INVALID_CONFIG = 5;
    public static final int SIGNED_CONFIG_REPORTED__STATUS__OLD_CONFIG = 6;
    public static final int SIGNED_CONFIG_REPORTED__STATUS__SIGNATURE_CHECK_FAILED = 7;
    public static final int SIGNED_CONFIG_REPORTED__STATUS__NOT_APPLICABLE = 8;
    public static final int SIGNED_CONFIG_REPORTED__STATUS__SIGNATURE_CHECK_FAILED_PROD_KEY_ABSENT = 9;

    // Values for SignedConfigReported.verified_with
    public static final int SIGNED_CONFIG_REPORTED__VERIFIED_WITH__NO_KEY = 0;
    public static final int SIGNED_CONFIG_REPORTED__VERIFIED_WITH__DEBUG = 1;
    public static final int SIGNED_CONFIG_REPORTED__VERIFIED_WITH__PRODUCTION = 2;

    // Values for GnssNiEventReported.event_type
    public static final int GNSS_NI_EVENT_REPORTED__EVENT_TYPE__UNKNOWN = 0;
    public static final int GNSS_NI_EVENT_REPORTED__EVENT_TYPE__NI_REQUEST = 1;
    public static final int GNSS_NI_EVENT_REPORTED__EVENT_TYPE__NI_RESPONSE = 2;

    // Values for GnssNiEventReported.ni_type
    public static final int GNSS_NI_EVENT_REPORTED__NI_TYPE__VOICE = 1;
    public static final int GNSS_NI_EVENT_REPORTED__NI_TYPE__UMTS_SUPL = 2;
    public static final int GNSS_NI_EVENT_REPORTED__NI_TYPE__UMTS_CTRL_PLANE = 3;
    public static final int GNSS_NI_EVENT_REPORTED__NI_TYPE__EMERGENCY_SUPL = 4;

    // Values for GnssNiEventReported.default_response
    public static final int GNSS_NI_EVENT_REPORTED__DEFAULT_RESPONSE__RESPONSE_ACCEPT = 1;
    public static final int GNSS_NI_EVENT_REPORTED__DEFAULT_RESPONSE__RESPONSE_DENY = 2;
    public static final int GNSS_NI_EVENT_REPORTED__DEFAULT_RESPONSE__RESPONSE_NORESP = 3;

    // Values for GnssNiEventReported.requestor_id_encoding
    public static final int GNSS_NI_EVENT_REPORTED__REQUESTOR_ID_ENCODING__ENC_UNKNOWN = -1;
    public static final int GNSS_NI_EVENT_REPORTED__REQUESTOR_ID_ENCODING__ENC_NONE = 0;
    public static final int GNSS_NI_EVENT_REPORTED__REQUESTOR_ID_ENCODING__ENC_SUPL_GSM_DEFAULT = 1;
    public static final int GNSS_NI_EVENT_REPORTED__REQUESTOR_ID_ENCODING__ENC_SUPL_UTF8 = 2;
    public static final int GNSS_NI_EVENT_REPORTED__REQUESTOR_ID_ENCODING__ENC_SUPL_UCS2 = 3;

    // Values for GnssNiEventReported.text_encoding
    public static final int GNSS_NI_EVENT_REPORTED__TEXT_ENCODING__ENC_UNKNOWN = -1;
    public static final int GNSS_NI_EVENT_REPORTED__TEXT_ENCODING__ENC_NONE = 0;
    public static final int GNSS_NI_EVENT_REPORTED__TEXT_ENCODING__ENC_SUPL_GSM_DEFAULT = 1;
    public static final int GNSS_NI_EVENT_REPORTED__TEXT_ENCODING__ENC_SUPL_UTF8 = 2;
    public static final int GNSS_NI_EVENT_REPORTED__TEXT_ENCODING__ENC_SUPL_UCS2 = 3;

    // Values for GnssNiEventReported.user_response
    public static final int GNSS_NI_EVENT_REPORTED__USER_RESPONSE__RESPONSE_ACCEPT = 1;
    public static final int GNSS_NI_EVENT_REPORTED__USER_RESPONSE__RESPONSE_DENY = 2;
    public static final int GNSS_NI_EVENT_REPORTED__USER_RESPONSE__RESPONSE_NORESP = 3;

    // Values for LowStorageStateChanged.state
    public static final int LOW_STORAGE_STATE_CHANGED__STATE__UNKNOWN = 0;
    public static final int LOW_STORAGE_STATE_CHANGED__STATE__OFF = 1;
    public static final int LOW_STORAGE_STATE_CHANGED__STATE__ON = 2;

    // Values for GnssNfwNotificationReported.protocol_stack
    public static final int GNSS_NFW_NOTIFICATION_REPORTED__PROTOCOL_STACK__CTRL_PLANE = 0;
    public static final int GNSS_NFW_NOTIFICATION_REPORTED__PROTOCOL_STACK__SUPL = 1;
    public static final int GNSS_NFW_NOTIFICATION_REPORTED__PROTOCOL_STACK__IMS = 10;
    public static final int GNSS_NFW_NOTIFICATION_REPORTED__PROTOCOL_STACK__SIM = 11;
    public static final int GNSS_NFW_NOTIFICATION_REPORTED__PROTOCOL_STACK__OTHER_PROTOCOL_STACK = 100;

    // Values for GnssNfwNotificationReported.requestor
    public static final int GNSS_NFW_NOTIFICATION_REPORTED__REQUESTOR__CARRIER = 0;
    public static final int GNSS_NFW_NOTIFICATION_REPORTED__REQUESTOR__OEM = 10;
    public static final int GNSS_NFW_NOTIFICATION_REPORTED__REQUESTOR__MODEM_CHIPSET_VENDOR = 11;
    public static final int GNSS_NFW_NOTIFICATION_REPORTED__REQUESTOR__GNSS_CHIPSET_VENDOR = 12;
    public static final int GNSS_NFW_NOTIFICATION_REPORTED__REQUESTOR__OTHER_CHIPSET_VENDOR = 13;
    public static final int GNSS_NFW_NOTIFICATION_REPORTED__REQUESTOR__AUTOMOBILE_CLIENT = 20;
    public static final int GNSS_NFW_NOTIFICATION_REPORTED__REQUESTOR__OTHER_REQUESTOR = 100;

    // Values for GnssNfwNotificationReported.response_type
    public static final int GNSS_NFW_NOTIFICATION_REPORTED__RESPONSE_TYPE__REJECTED = 0;
    public static final int GNSS_NFW_NOTIFICATION_REPORTED__RESPONSE_TYPE__ACCEPTED_NO_LOCATION_PROVIDED = 1;
    public static final int GNSS_NFW_NOTIFICATION_REPORTED__RESPONSE_TYPE__ACCEPTED_LOCATION_PROVIDED = 2;

    // Values for GnssConfigurationReported.supl_mode
    public static final int GNSS_CONFIGURATION_REPORTED__SUPL_MODE__MSB = 1;
    public static final int GNSS_CONFIGURATION_REPORTED__SUPL_MODE__MSA = 2;

    // Values for GnssConfigurationReported.lpp_profile
    public static final int GNSS_CONFIGURATION_REPORTED__LPP_PROFILE__USER_PLANE = 1;
    public static final int GNSS_CONFIGURATION_REPORTED__LPP_PROFILE__CONTROL_PLANE = 2;

    // Values for GnssConfigurationReported.a_glonass_pos_protocol_select
    public static final int GNSS_CONFIGURATION_REPORTED__A_GLONASS_POS_PROTOCOL_SELECT__RRC_CPLANE = 1;
    public static final int GNSS_CONFIGURATION_REPORTED__A_GLONASS_POS_PROTOCOL_SELECT__RRLP_CPLANE = 2;
    public static final int GNSS_CONFIGURATION_REPORTED__A_GLONASS_POS_PROTOCOL_SELECT__LPP_UPLANE = 4;

    // Values for GnssConfigurationReported.gps_lock
    public static final int GNSS_CONFIGURATION_REPORTED__GPS_LOCK__MO = 1;
    public static final int GNSS_CONFIGURATION_REPORTED__GPS_LOCK__NI = 2;

    // Values for AttentionManagerServiceResultReported.attention_check_result
    public static final int ATTENTION_MANAGER_SERVICE_RESULT_REPORTED__ATTENTION_CHECK_RESULT__ATTENTION_SUCCESS_ABSENT = 0;
    public static final int ATTENTION_MANAGER_SERVICE_RESULT_REPORTED__ATTENTION_CHECK_RESULT__ATTENTION_SUCCESS_PRESENT = 1;
    public static final int ATTENTION_MANAGER_SERVICE_RESULT_REPORTED__ATTENTION_CHECK_RESULT__ATTENTION_FAILURE_UNKNOWN = 2;
    public static final int ATTENTION_MANAGER_SERVICE_RESULT_REPORTED__ATTENTION_CHECK_RESULT__ATTENTION_FAILURE_CANCELLED = 3;
    public static final int ATTENTION_MANAGER_SERVICE_RESULT_REPORTED__ATTENTION_CHECK_RESULT__ATTENTION_FAILURE_PREEMPTED = 4;
    public static final int ATTENTION_MANAGER_SERVICE_RESULT_REPORTED__ATTENTION_CHECK_RESULT__ATTENTION_FAILURE_TIMED_OUT = 5;
    public static final int ATTENTION_MANAGER_SERVICE_RESULT_REPORTED__ATTENTION_CHECK_RESULT__ATTENTION_FAILURE_CAMERA_PERMISSION_ABSENT = 6;
    public static final int ATTENTION_MANAGER_SERVICE_RESULT_REPORTED__ATTENTION_CHECK_RESULT__UNKNOWN = 20;

    // Values for AdbConnectionChanged.state
    public static final int ADB_CONNECTION_CHANGED__STATE__UNKNOWN = 0;
    public static final int ADB_CONNECTION_CHANGED__STATE__AWAITING_USER_APPROVAL = 1;
    public static final int ADB_CONNECTION_CHANGED__STATE__USER_ALLOWED = 2;
    public static final int ADB_CONNECTION_CHANGED__STATE__USER_DENIED = 3;
    public static final int ADB_CONNECTION_CHANGED__STATE__AUTOMATICALLY_ALLOWED = 4;
    public static final int ADB_CONNECTION_CHANGED__STATE__DENIED_INVALID_KEY = 5;
    public static final int ADB_CONNECTION_CHANGED__STATE__DENIED_VOLD_DECRYPT = 6;
    public static final int ADB_CONNECTION_CHANGED__STATE__DISCONNECTED = 7;

    // Values for UsbContaminantReported.status
    public static final int USB_CONTAMINANT_REPORTED__STATUS__CONTAMINANT_STATUS_UNKNOWN = 0;
    public static final int USB_CONTAMINANT_REPORTED__STATUS__CONTAMINANT_STATUS_NOT_SUPPORTED = 1;
    public static final int USB_CONTAMINANT_REPORTED__STATUS__CONTAMINANT_STATUS_DISABLED = 2;
    public static final int USB_CONTAMINANT_REPORTED__STATUS__CONTAMINANT_STATUS_NOT_DETECTED = 3;
    public static final int USB_CONTAMINANT_REPORTED__STATUS__CONTAMINANT_STATUS_DETECTED = 4;

    // Values for WatchdogRollbackOccurred.rollback_type
    public static final int WATCHDOG_ROLLBACK_OCCURRED__ROLLBACK_TYPE__UNKNOWN = 0;
    public static final int WATCHDOG_ROLLBACK_OCCURRED__ROLLBACK_TYPE__ROLLBACK_INITIATE = 1;
    public static final int WATCHDOG_ROLLBACK_OCCURRED__ROLLBACK_TYPE__ROLLBACK_SUCCESS = 2;
    public static final int WATCHDOG_ROLLBACK_OCCURRED__ROLLBACK_TYPE__ROLLBACK_FAILURE = 3;
    public static final int WATCHDOG_ROLLBACK_OCCURRED__ROLLBACK_TYPE__ROLLBACK_BOOT_TRIGGERED = 4;

    // Values for WatchdogRollbackOccurred.rollback_reason
    public static final int WATCHDOG_ROLLBACK_OCCURRED__ROLLBACK_REASON__REASON_UNKNOWN = 0;
    public static final int WATCHDOG_ROLLBACK_OCCURRED__ROLLBACK_REASON__REASON_NATIVE_CRASH = 1;
    public static final int WATCHDOG_ROLLBACK_OCCURRED__ROLLBACK_REASON__REASON_EXPLICIT_HEALTH_CHECK = 2;
    public static final int WATCHDOG_ROLLBACK_OCCURRED__ROLLBACK_REASON__REASON_APP_CRASH = 3;
    public static final int WATCHDOG_ROLLBACK_OCCURRED__ROLLBACK_REASON__REASON_APP_NOT_RESPONDING = 4;
    public static final int WATCHDOG_ROLLBACK_OCCURRED__ROLLBACK_REASON__REASON_NATIVE_CRASH_DURING_BOOT = 5;

    // Values for BiometricSystemHealthIssueDetected.modality
    public static final int BIOMETRIC_SYSTEM_HEALTH_ISSUE_DETECTED__MODALITY__MODALITY_UNKNOWN = 0;
    public static final int BIOMETRIC_SYSTEM_HEALTH_ISSUE_DETECTED__MODALITY__MODALITY_FINGERPRINT = 1;
    public static final int BIOMETRIC_SYSTEM_HEALTH_ISSUE_DETECTED__MODALITY__MODALITY_IRIS = 2;
    public static final int BIOMETRIC_SYSTEM_HEALTH_ISSUE_DETECTED__MODALITY__MODALITY_FACE = 4;

    // Values for BiometricSystemHealthIssueDetected.issue
    public static final int BIOMETRIC_SYSTEM_HEALTH_ISSUE_DETECTED__ISSUE__ISSUE_UNKNOWN = 0;
    public static final int BIOMETRIC_SYSTEM_HEALTH_ISSUE_DETECTED__ISSUE__ISSUE_HAL_DEATH = 1;
    public static final int BIOMETRIC_SYSTEM_HEALTH_ISSUE_DETECTED__ISSUE__ISSUE_UNKNOWN_TEMPLATE_ENROLLED_FRAMEWORK = 2;
    public static final int BIOMETRIC_SYSTEM_HEALTH_ISSUE_DETECTED__ISSUE__ISSUE_UNKNOWN_TEMPLATE_ENROLLED_HAL = 3;
    public static final int BIOMETRIC_SYSTEM_HEALTH_ISSUE_DETECTED__ISSUE__ISSUE_CANCEL_TIMED_OUT = 4;

    // Values for BubbleUIChanged.action
    public static final int BUBBLE_UICHANGED__ACTION__UNKNOWN = 0;
    public static final int BUBBLE_UICHANGED__ACTION__POSTED = 1;
    public static final int BUBBLE_UICHANGED__ACTION__UPDATED = 2;
    public static final int BUBBLE_UICHANGED__ACTION__EXPANDED = 3;
    public static final int BUBBLE_UICHANGED__ACTION__COLLAPSED = 4;
    public static final int BUBBLE_UICHANGED__ACTION__DISMISSED = 5;
    public static final int BUBBLE_UICHANGED__ACTION__STACK_DISMISSED = 6;
    public static final int BUBBLE_UICHANGED__ACTION__STACK_MOVED = 7;
    public static final int BUBBLE_UICHANGED__ACTION__HEADER_GO_TO_APP = 8;
    public static final int BUBBLE_UICHANGED__ACTION__HEADER_GO_TO_SETTINGS = 9;
    public static final int BUBBLE_UICHANGED__ACTION__PERMISSION_OPT_IN = 10;
    public static final int BUBBLE_UICHANGED__ACTION__PERMISSION_OPT_OUT = 11;
    public static final int BUBBLE_UICHANGED__ACTION__PERMISSION_DIALOG_SHOWN = 12;
    public static final int BUBBLE_UICHANGED__ACTION__SWIPE_LEFT = 13;
    public static final int BUBBLE_UICHANGED__ACTION__SWIPE_RIGHT = 14;
    public static final int BUBBLE_UICHANGED__ACTION__STACK_EXPANDED = 15;
    public static final int BUBBLE_UICHANGED__ACTION__FLYOUT = 16;

    // Values for ScheduledJobConstraintChanged.constraint
    public static final int SCHEDULED_JOB_CONSTRAINT_CHANGED__CONSTRAINT__CONSTRAINT_UNKNOWN = 0;
    public static final int SCHEDULED_JOB_CONSTRAINT_CHANGED__CONSTRAINT__CONSTRAINT_CHARGING = 1;
    public static final int SCHEDULED_JOB_CONSTRAINT_CHANGED__CONSTRAINT__CONSTRAINT_BATTERY_NOT_LOW = 2;
    public static final int SCHEDULED_JOB_CONSTRAINT_CHANGED__CONSTRAINT__CONSTRAINT_STORAGE_NOT_LOW = 3;
    public static final int SCHEDULED_JOB_CONSTRAINT_CHANGED__CONSTRAINT__CONSTRAINT_TIMING_DELAY = 4;
    public static final int SCHEDULED_JOB_CONSTRAINT_CHANGED__CONSTRAINT__CONSTRAINT_DEADLINE = 5;
    public static final int SCHEDULED_JOB_CONSTRAINT_CHANGED__CONSTRAINT__CONSTRAINT_IDLE = 6;
    public static final int SCHEDULED_JOB_CONSTRAINT_CHANGED__CONSTRAINT__CONSTRAINT_CONNECTIVITY = 7;
    public static final int SCHEDULED_JOB_CONSTRAINT_CHANGED__CONSTRAINT__CONSTRAINT_CONTENT_TRIGGER = 8;
    public static final int SCHEDULED_JOB_CONSTRAINT_CHANGED__CONSTRAINT__CONSTRAINT_DEVICE_NOT_DOZING = 9;
    public static final int SCHEDULED_JOB_CONSTRAINT_CHANGED__CONSTRAINT__CONSTRAINT_WITHIN_QUOTA = 10;
    public static final int SCHEDULED_JOB_CONSTRAINT_CHANGED__CONSTRAINT__CONSTRAINT_BACKGROUND_NOT_RESTRICTED = 11;
    public static final int SCHEDULED_JOB_CONSTRAINT_CHANGED__CONSTRAINT__CONSTRAINT_WITHIN_EXPEDITED_JOB_QUOTA = 12;
    public static final int SCHEDULED_JOB_CONSTRAINT_CHANGED__CONSTRAINT__CONSTRAINT_TARE_WEALTH = 13;
    public static final int SCHEDULED_JOB_CONSTRAINT_CHANGED__CONSTRAINT__CONSTRAINT_PREFETCH = 14;
    public static final int SCHEDULED_JOB_CONSTRAINT_CHANGED__CONSTRAINT__CONSTRAINT_FLEXIBILITY = 15;

    // Values for ScheduledJobConstraintChanged.state
    public static final int SCHEDULED_JOB_CONSTRAINT_CHANGED__STATE__UNKNOWN = 0;
    public static final int SCHEDULED_JOB_CONSTRAINT_CHANGED__STATE__UNSATISFIED = 1;
    public static final int SCHEDULED_JOB_CONSTRAINT_CHANGED__STATE__SATISFIED = 2;

    // Values for ProcessStartTime.type
    public static final int PROCESS_START_TIME__TYPE__UNKNOWN = 0;
    public static final int PROCESS_START_TIME__TYPE__WARM = 1;
    public static final int PROCESS_START_TIME__TYPE__HOT = 2;
    public static final int PROCESS_START_TIME__TYPE__COLD = 3;

    // Values for ProcessStartTime.hosting_type_id
    public static final int PROCESS_START_TIME__HOSTING_TYPE_ID__HOSTING_TYPE_UNKNOWN = 0;
    public static final int PROCESS_START_TIME__HOSTING_TYPE_ID__HOSTING_TYPE_ACTIVITY = 1;
    public static final int PROCESS_START_TIME__HOSTING_TYPE_ID__HOSTING_TYPE_ADDED_APPLICATION = 2;
    public static final int PROCESS_START_TIME__HOSTING_TYPE_ID__HOSTING_TYPE_BACKUP = 3;
    public static final int PROCESS_START_TIME__HOSTING_TYPE_ID__HOSTING_TYPE_BROADCAST = 4;
    public static final int PROCESS_START_TIME__HOSTING_TYPE_ID__HOSTING_TYPE_CONTENT_PROVIDER = 5;
    public static final int PROCESS_START_TIME__HOSTING_TYPE_ID__HOSTING_TYPE_LINK_FAIL = 6;
    public static final int PROCESS_START_TIME__HOSTING_TYPE_ID__HOSTING_TYPE_ON_HOLD = 7;
    public static final int PROCESS_START_TIME__HOSTING_TYPE_ID__HOSTING_TYPE_NEXT_ACTIVITY = 8;
    public static final int PROCESS_START_TIME__HOSTING_TYPE_ID__HOSTING_TYPE_NEXT_TOP_ACTIVITY = 9;
    public static final int PROCESS_START_TIME__HOSTING_TYPE_ID__HOSTING_TYPE_RESTART = 10;
    public static final int PROCESS_START_TIME__HOSTING_TYPE_ID__HOSTING_TYPE_SERVICE = 11;
    public static final int PROCESS_START_TIME__HOSTING_TYPE_ID__HOSTING_TYPE_SYSTEM = 12;
    public static final int PROCESS_START_TIME__HOSTING_TYPE_ID__HOSTING_TYPE_TOP_ACTIVITY = 13;
    public static final int PROCESS_START_TIME__HOSTING_TYPE_ID__HOSTING_TYPE_EMPTY = 14;

    // Values for ProcessStartTime.trigger_type
    public static final int PROCESS_START_TIME__TRIGGER_TYPE__TRIGGER_TYPE_UNKNOWN = 0;
    public static final int PROCESS_START_TIME__TRIGGER_TYPE__TRIGGER_TYPE_ALARM = 1;
    public static final int PROCESS_START_TIME__TRIGGER_TYPE__TRIGGER_TYPE_PUSH_MESSAGE = 2;
    public static final int PROCESS_START_TIME__TRIGGER_TYPE__TRIGGER_TYPE_PUSH_MESSAGE_OVER_QUOTA = 3;
    public static final int PROCESS_START_TIME__TRIGGER_TYPE__TRIGGER_TYPE_JOB = 4;

    // Values for BubbleDeveloperErrorReported.error
    public static final int BUBBLE_DEVELOPER_ERROR_REPORTED__ERROR__UNKNOWN = 0;
    public static final int BUBBLE_DEVELOPER_ERROR_REPORTED__ERROR__ACTIVITY_INFO_MISSING = 1;
    public static final int BUBBLE_DEVELOPER_ERROR_REPORTED__ERROR__ACTIVITY_INFO_NOT_RESIZABLE = 2;
    public static final int BUBBLE_DEVELOPER_ERROR_REPORTED__ERROR__DOCUMENT_LAUNCH_NOT_ALWAYS = 3;

    // Values for TouchGestureClassified.classification
    public static final int TOUCH_GESTURE_CLASSIFIED__CLASSIFICATION__UNKNOWN_CLASSIFICATION = 0;
    public static final int TOUCH_GESTURE_CLASSIFIED__CLASSIFICATION__SINGLE_TAP = 1;
    public static final int TOUCH_GESTURE_CLASSIFIED__CLASSIFICATION__DOUBLE_TAP = 2;
    public static final int TOUCH_GESTURE_CLASSIFIED__CLASSIFICATION__LONG_PRESS = 3;
    public static final int TOUCH_GESTURE_CLASSIFIED__CLASSIFICATION__DEEP_PRESS = 4;
    public static final int TOUCH_GESTURE_CLASSIFIED__CLASSIFICATION__SCROLL = 5;

    // Values for HiddenApiUsed.access_method
    public static final int HIDDEN_API_USED__ACCESS_METHOD__NONE = 0;
    public static final int HIDDEN_API_USED__ACCESS_METHOD__REFLECTION = 1;
    public static final int HIDDEN_API_USED__ACCESS_METHOD__JNI = 2;
    public static final int HIDDEN_API_USED__ACCESS_METHOD__LINKING = 3;

    // Values for AppInstallOnExternalStorageReported.storage_type
    public static final int APP_INSTALL_ON_EXTERNAL_STORAGE_REPORTED__STORAGE_TYPE__UNKNOWN = 0;
    public static final int APP_INSTALL_ON_EXTERNAL_STORAGE_REPORTED__STORAGE_TYPE__SD_CARD = 1;
    public static final int APP_INSTALL_ON_EXTERNAL_STORAGE_REPORTED__STORAGE_TYPE__USB = 2;
    public static final int APP_INSTALL_ON_EXTERNAL_STORAGE_REPORTED__STORAGE_TYPE__OTHER = 3;

    // Values for AppMovedStorageReported.external_storage_type
    public static final int APP_MOVED_STORAGE_REPORTED__EXTERNAL_STORAGE_TYPE__UNKNOWN = 0;
    public static final int APP_MOVED_STORAGE_REPORTED__EXTERNAL_STORAGE_TYPE__SD_CARD = 1;
    public static final int APP_MOVED_STORAGE_REPORTED__EXTERNAL_STORAGE_TYPE__USB = 2;
    public static final int APP_MOVED_STORAGE_REPORTED__EXTERNAL_STORAGE_TYPE__OTHER = 3;

    // Values for AppMovedStorageReported.move_type
    public static final int APP_MOVED_STORAGE_REPORTED__MOVE_TYPE__UNKNOWN = 0;
    public static final int APP_MOVED_STORAGE_REPORTED__MOVE_TYPE__TO_EXTERNAL = 1;
    public static final int APP_MOVED_STORAGE_REPORTED__MOVE_TYPE__TO_INTERNAL = 2;

    // Values for BiometricEnrolled.modality
    public static final int BIOMETRIC_ENROLLED__MODALITY__MODALITY_UNKNOWN = 0;
    public static final int BIOMETRIC_ENROLLED__MODALITY__MODALITY_FINGERPRINT = 1;
    public static final int BIOMETRIC_ENROLLED__MODALITY__MODALITY_IRIS = 2;
    public static final int BIOMETRIC_ENROLLED__MODALITY__MODALITY_FACE = 4;

    // Values for ThermalThrottlingSeverityStateChanged.sensor_type
    public static final int THERMAL_THROTTLING_SEVERITY_STATE_CHANGED__SENSOR_TYPE__TEMPERATURE_TYPE_UNKNOWN = -1;
    public static final int THERMAL_THROTTLING_SEVERITY_STATE_CHANGED__SENSOR_TYPE__TEMPERATURE_TYPE_CPU = 0;
    public static final int THERMAL_THROTTLING_SEVERITY_STATE_CHANGED__SENSOR_TYPE__TEMPERATURE_TYPE_GPU = 1;
    public static final int THERMAL_THROTTLING_SEVERITY_STATE_CHANGED__SENSOR_TYPE__TEMPERATURE_TYPE_BATTERY = 2;
    public static final int THERMAL_THROTTLING_SEVERITY_STATE_CHANGED__SENSOR_TYPE__TEMPERATURE_TYPE_SKIN = 3;
    public static final int THERMAL_THROTTLING_SEVERITY_STATE_CHANGED__SENSOR_TYPE__TEMPERATURE_TYPE_USB_PORT = 4;
    public static final int THERMAL_THROTTLING_SEVERITY_STATE_CHANGED__SENSOR_TYPE__TEMPERATURE_TYPE_POWER_AMPLIFIER = 5;
    public static final int THERMAL_THROTTLING_SEVERITY_STATE_CHANGED__SENSOR_TYPE__TEMPERATURE_TYPE_BCL_VOLTAGE = 6;
    public static final int THERMAL_THROTTLING_SEVERITY_STATE_CHANGED__SENSOR_TYPE__TEMPERATURE_TYPE_BCL_CURRENT = 7;
    public static final int THERMAL_THROTTLING_SEVERITY_STATE_CHANGED__SENSOR_TYPE__TEMPERATURE_TYPE_BCL_PERCENTAGE = 8;
    public static final int THERMAL_THROTTLING_SEVERITY_STATE_CHANGED__SENSOR_TYPE__TEMPERATURE_TYPE_NPU = 9;

    // Values for ThermalThrottlingSeverityStateChanged.severity
    public static final int THERMAL_THROTTLING_SEVERITY_STATE_CHANGED__SEVERITY__NONE = 0;
    public static final int THERMAL_THROTTLING_SEVERITY_STATE_CHANGED__SEVERITY__LIGHT = 1;
    public static final int THERMAL_THROTTLING_SEVERITY_STATE_CHANGED__SEVERITY__MODERATE = 2;
    public static final int THERMAL_THROTTLING_SEVERITY_STATE_CHANGED__SEVERITY__SEVERE = 3;
    public static final int THERMAL_THROTTLING_SEVERITY_STATE_CHANGED__SEVERITY__CRITICAL = 4;
    public static final int THERMAL_THROTTLING_SEVERITY_STATE_CHANGED__SEVERITY__EMERGENCY = 5;
    public static final int THERMAL_THROTTLING_SEVERITY_STATE_CHANGED__SEVERITY__SHUTDOWN = 6;

    // Values for ContentCaptureServiceEvents.event
    public static final int CONTENT_CAPTURE_SERVICE_EVENTS__EVENT__UNKNOWN = 0;
    public static final int CONTENT_CAPTURE_SERVICE_EVENTS__EVENT__ON_CONNECTED = 1;
    public static final int CONTENT_CAPTURE_SERVICE_EVENTS__EVENT__ON_DISCONNECTED = 2;
    public static final int CONTENT_CAPTURE_SERVICE_EVENTS__EVENT__SET_WHITELIST = 3;
    public static final int CONTENT_CAPTURE_SERVICE_EVENTS__EVENT__SET_DISABLED = 4;
    public static final int CONTENT_CAPTURE_SERVICE_EVENTS__EVENT__ON_USER_DATA_REMOVED = 5;
    public static final int CONTENT_CAPTURE_SERVICE_EVENTS__EVENT__ON_DATA_SHARE_REQUEST = 6;
    public static final int CONTENT_CAPTURE_SERVICE_EVENTS__EVENT__ACCEPT_DATA_SHARE_REQUEST = 7;
    public static final int CONTENT_CAPTURE_SERVICE_EVENTS__EVENT__REJECT_DATA_SHARE_REQUEST = 8;
    public static final int CONTENT_CAPTURE_SERVICE_EVENTS__EVENT__DATA_SHARE_WRITE_FINISHED = 9;
    public static final int CONTENT_CAPTURE_SERVICE_EVENTS__EVENT__DATA_SHARE_ERROR_IOEXCEPTION = 10;
    public static final int CONTENT_CAPTURE_SERVICE_EVENTS__EVENT__DATA_SHARE_ERROR_EMPTY_DATA = 11;
    public static final int CONTENT_CAPTURE_SERVICE_EVENTS__EVENT__DATA_SHARE_ERROR_CLIENT_PIPE_FAIL = 12;
    public static final int CONTENT_CAPTURE_SERVICE_EVENTS__EVENT__DATA_SHARE_ERROR_SERVICE_PIPE_FAIL = 13;
    public static final int CONTENT_CAPTURE_SERVICE_EVENTS__EVENT__DATA_SHARE_ERROR_CONCURRENT_REQUEST = 14;
    public static final int CONTENT_CAPTURE_SERVICE_EVENTS__EVENT__DATA_SHARE_ERROR_TIMEOUT_INTERRUPTED = 15;
    public static final int CONTENT_CAPTURE_SERVICE_EVENTS__EVENT__ON_REMOTE_SERVICE_DIED = 16;

    // Values for ContentCaptureSessionEvents.event
    public static final int CONTENT_CAPTURE_SESSION_EVENTS__EVENT__UNKNOWN = 0;
    public static final int CONTENT_CAPTURE_SESSION_EVENTS__EVENT__ON_SESSION_STARTED = 1;
    public static final int CONTENT_CAPTURE_SESSION_EVENTS__EVENT__ON_SESSION_FINISHED = 2;
    public static final int CONTENT_CAPTURE_SESSION_EVENTS__EVENT__SESSION_NOT_CREATED = 3;

    // Values for LocationManagerApiUsageReported.state
    public static final int LOCATION_MANAGER_API_USAGE_REPORTED__STATE__USAGE_STARTED = 0;
    public static final int LOCATION_MANAGER_API_USAGE_REPORTED__STATE__USAGE_ENDED = 1;

    // Values for LocationManagerApiUsageReported.api_in_use
    public static final int LOCATION_MANAGER_API_USAGE_REPORTED__API_IN_USE__API_UNKNOWN = 0;
    public static final int LOCATION_MANAGER_API_USAGE_REPORTED__API_IN_USE__API_REQUEST_LOCATION_UPDATES = 1;
    public static final int LOCATION_MANAGER_API_USAGE_REPORTED__API_IN_USE__API_ADD_GNSS_MEASUREMENTS_LISTENER = 2;
    public static final int LOCATION_MANAGER_API_USAGE_REPORTED__API_IN_USE__API_REGISTER_GNSS_STATUS_CALLBACK = 3;
    public static final int LOCATION_MANAGER_API_USAGE_REPORTED__API_IN_USE__API_REQUEST_GEOFENCE = 4;
    public static final int LOCATION_MANAGER_API_USAGE_REPORTED__API_IN_USE__API_SEND_EXTRA_COMMAND = 5;

    // Values for LocationManagerApiUsageReported.provider
    public static final int LOCATION_MANAGER_API_USAGE_REPORTED__PROVIDER__PROVIDER_UNKNOWN = 0;
    public static final int LOCATION_MANAGER_API_USAGE_REPORTED__PROVIDER__PROVIDER_NETWORK = 1;
    public static final int LOCATION_MANAGER_API_USAGE_REPORTED__PROVIDER__PROVIDER_GPS = 2;
    public static final int LOCATION_MANAGER_API_USAGE_REPORTED__PROVIDER__PROVIDER_PASSIVE = 3;
    public static final int LOCATION_MANAGER_API_USAGE_REPORTED__PROVIDER__PROVIDER_FUSED = 4;

    // Values for LocationManagerApiUsageReported.quality
    public static final int LOCATION_MANAGER_API_USAGE_REPORTED__QUALITY__QUALITY_UNKNOWN = 0;
    public static final int LOCATION_MANAGER_API_USAGE_REPORTED__QUALITY__ACCURACY_FINE = 100;
    public static final int LOCATION_MANAGER_API_USAGE_REPORTED__QUALITY__ACCURACY_BLOCK = 102;
    public static final int LOCATION_MANAGER_API_USAGE_REPORTED__QUALITY__ACCURACY_CITY = 104;
    public static final int LOCATION_MANAGER_API_USAGE_REPORTED__QUALITY__POWER_NONE = 200;
    public static final int LOCATION_MANAGER_API_USAGE_REPORTED__QUALITY__POWER_LOW = 201;
    public static final int LOCATION_MANAGER_API_USAGE_REPORTED__QUALITY__POWER_HIGH = 203;

    // Values for LocationManagerApiUsageReported.bucketized_interval
    public static final int LOCATION_MANAGER_API_USAGE_REPORTED__BUCKETIZED_INTERVAL__INTERVAL_UNKNOWN = 0;
    public static final int LOCATION_MANAGER_API_USAGE_REPORTED__BUCKETIZED_INTERVAL__INTERVAL_BETWEEN_0_SEC_AND_1_SEC = 1;
    public static final int LOCATION_MANAGER_API_USAGE_REPORTED__BUCKETIZED_INTERVAL__INTERVAL_BETWEEN_1_SEC_AND_5_SEC = 2;
    public static final int LOCATION_MANAGER_API_USAGE_REPORTED__BUCKETIZED_INTERVAL__INTERVAL_BETWEEN_5_SEC_AND_1_MIN = 3;
    public static final int LOCATION_MANAGER_API_USAGE_REPORTED__BUCKETIZED_INTERVAL__INTERVAL_BETWEEN_1_MIN_AND_10_MIN = 4;
    public static final int LOCATION_MANAGER_API_USAGE_REPORTED__BUCKETIZED_INTERVAL__INTERVAL_BETWEEN_10_MIN_AND_1_HOUR = 5;
    public static final int LOCATION_MANAGER_API_USAGE_REPORTED__BUCKETIZED_INTERVAL__INTERVAL_LARGER_THAN_1_HOUR = 6;

    // Values for LocationManagerApiUsageReported.bucketized_smallest_displacement
    public static final int LOCATION_MANAGER_API_USAGE_REPORTED__BUCKETIZED_SMALLEST_DISPLACEMENT__DISTANCE_UNKNOWN = 0;
    public static final int LOCATION_MANAGER_API_USAGE_REPORTED__BUCKETIZED_SMALLEST_DISPLACEMENT__DISTANCE_ZERO = 1;
    public static final int LOCATION_MANAGER_API_USAGE_REPORTED__BUCKETIZED_SMALLEST_DISPLACEMENT__DISTANCE_BETWEEN_0_AND_100 = 2;
    public static final int LOCATION_MANAGER_API_USAGE_REPORTED__BUCKETIZED_SMALLEST_DISPLACEMENT__DISTANCE_LARGER_THAN_100 = 3;

    // Values for LocationManagerApiUsageReported.bucketized_expire_in
    public static final int LOCATION_MANAGER_API_USAGE_REPORTED__BUCKETIZED_EXPIRE_IN__EXPIRATION_UNKNOWN = 0;
    public static final int LOCATION_MANAGER_API_USAGE_REPORTED__BUCKETIZED_EXPIRE_IN__EXPIRATION_BETWEEN_0_AND_20_SEC = 1;
    public static final int LOCATION_MANAGER_API_USAGE_REPORTED__BUCKETIZED_EXPIRE_IN__EXPIRATION_BETWEEN_20_SEC_AND_1_MIN = 2;
    public static final int LOCATION_MANAGER_API_USAGE_REPORTED__BUCKETIZED_EXPIRE_IN__EXPIRATION_BETWEEN_1_MIN_AND_10_MIN = 3;
    public static final int LOCATION_MANAGER_API_USAGE_REPORTED__BUCKETIZED_EXPIRE_IN__EXPIRATION_BETWEEN_10_MIN_AND_1_HOUR = 4;
    public static final int LOCATION_MANAGER_API_USAGE_REPORTED__BUCKETIZED_EXPIRE_IN__EXPIRATION_LARGER_THAN_1_HOUR = 5;
    public static final int LOCATION_MANAGER_API_USAGE_REPORTED__BUCKETIZED_EXPIRE_IN__EXPIRATION_NO_EXPIRY = 6;

    // Values for LocationManagerApiUsageReported.callback_type
    public static final int LOCATION_MANAGER_API_USAGE_REPORTED__CALLBACK_TYPE__CALLBACK_UNKNOWN = 0;
    public static final int LOCATION_MANAGER_API_USAGE_REPORTED__CALLBACK_TYPE__CALLBACK_NOT_APPLICABLE = 1;
    public static final int LOCATION_MANAGER_API_USAGE_REPORTED__CALLBACK_TYPE__CALLBACK_LISTENER = 2;
    public static final int LOCATION_MANAGER_API_USAGE_REPORTED__CALLBACK_TYPE__CALLBACK_PENDING_INTENT = 3;

    // Values for LocationManagerApiUsageReported.bucketized_radius
    public static final int LOCATION_MANAGER_API_USAGE_REPORTED__BUCKETIZED_RADIUS__RADIUS_UNKNOWN = 0;
    public static final int LOCATION_MANAGER_API_USAGE_REPORTED__BUCKETIZED_RADIUS__RADIUS_BETWEEN_0_AND_100 = 1;
    public static final int LOCATION_MANAGER_API_USAGE_REPORTED__BUCKETIZED_RADIUS__RADIUS_BETWEEN_100_AND_200 = 2;
    public static final int LOCATION_MANAGER_API_USAGE_REPORTED__BUCKETIZED_RADIUS__RADIUS_BETWEEN_200_AND_300 = 3;
    public static final int LOCATION_MANAGER_API_USAGE_REPORTED__BUCKETIZED_RADIUS__RADIUS_BETWEEN_300_AND_1000 = 4;
    public static final int LOCATION_MANAGER_API_USAGE_REPORTED__BUCKETIZED_RADIUS__RADIUS_BETWEEN_1000_AND_10000 = 5;
    public static final int LOCATION_MANAGER_API_USAGE_REPORTED__BUCKETIZED_RADIUS__RADIUS_LARGER_THAN_100000 = 6;
    public static final int LOCATION_MANAGER_API_USAGE_REPORTED__BUCKETIZED_RADIUS__RADIUS_NEGATIVE = 7;

    // Values for LocationManagerApiUsageReported.activiy_importance
    public static final int LOCATION_MANAGER_API_USAGE_REPORTED__ACTIVIY_IMPORTANCE__IMPORTANCE_UNKNOWN = 0;
    public static final int LOCATION_MANAGER_API_USAGE_REPORTED__ACTIVIY_IMPORTANCE__IMPORTANCE_TOP = 1;
    public static final int LOCATION_MANAGER_API_USAGE_REPORTED__ACTIVIY_IMPORTANCE__IMPORTANCE_FORGROUND_SERVICE = 2;
    public static final int LOCATION_MANAGER_API_USAGE_REPORTED__ACTIVIY_IMPORTANCE__IMPORTANCE_BACKGROUND = 3;

    // Values for ExclusionRectStateChanged.x_location
    public static final int EXCLUSION_RECT_STATE_CHANGED__X_LOCATION__DEFAULT_LOCATION = 0;
    public static final int EXCLUSION_RECT_STATE_CHANGED__X_LOCATION__LEFT = 1;
    public static final int EXCLUSION_RECT_STATE_CHANGED__X_LOCATION__RIGHT = 2;

    // Values for CameraActionEvent.facing
    public static final int CAMERA_ACTION_EVENT__FACING__UNKNOWN = 0;
    public static final int CAMERA_ACTION_EVENT__FACING__BACK = 1;
    public static final int CAMERA_ACTION_EVENT__FACING__FRONT = 2;
    public static final int CAMERA_ACTION_EVENT__FACING__EXTERNAL = 3;

    // Values for CameraActionEvent.action
    public static final int CAMERA_ACTION_EVENT__ACTION__UNKNOWN_ACTION = 0;
    public static final int CAMERA_ACTION_EVENT__ACTION__OPEN = 1;
    public static final int CAMERA_ACTION_EVENT__ACTION__CLOSE = 2;
    public static final int CAMERA_ACTION_EVENT__ACTION__SESSION = 3;

    // Values for CameraActionEvent.ext_type
    public static final int CAMERA_ACTION_EVENT__EXT_TYPE__EXTENSION_NONE = -1;
    public static final int CAMERA_ACTION_EVENT__EXT_TYPE__EXTENSION_AUTOMATIC = 0;
    public static final int CAMERA_ACTION_EVENT__EXT_TYPE__EXTENSION_FACE_RETOUCH = 1;
    public static final int CAMERA_ACTION_EVENT__EXT_TYPE__EXTENSION_BOKEH = 2;
    public static final int CAMERA_ACTION_EVENT__EXT_TYPE__EXTENSION_HDR = 3;
    public static final int CAMERA_ACTION_EVENT__EXT_TYPE__EXTENSION_NIGHT = 4;

    // Values for AppCompatibilityChangeReported.state
    public static final int APP_COMPATIBILITY_CHANGE_REPORTED__STATE__UNKNOWN_STATE = 0;
    public static final int APP_COMPATIBILITY_CHANGE_REPORTED__STATE__ENABLED = 1;
    public static final int APP_COMPATIBILITY_CHANGE_REPORTED__STATE__DISABLED = 2;
    public static final int APP_COMPATIBILITY_CHANGE_REPORTED__STATE__LOGGED = 3;

    // Values for AppCompatibilityChangeReported.source
    public static final int APP_COMPATIBILITY_CHANGE_REPORTED__SOURCE__UNKNOWN_SOURCE = 0;
    public static final int APP_COMPATIBILITY_CHANGE_REPORTED__SOURCE__APP_PROCESS = 1;
    public static final int APP_COMPATIBILITY_CHANGE_REPORTED__SOURCE__SYSTEM_SERVER = 2;

    // Values for RebootEscrowRecoveryReported.type
    public static final int REBOOT_ESCROW_RECOVERY_REPORTED__TYPE__UNKNOWN = 0;
    public static final int REBOOT_ESCROW_RECOVERY_REPORTED__TYPE__HAL = 1;
    public static final int REBOOT_ESCROW_RECOVERY_REPORTED__TYPE__SERVER_BASED = 2;

    // Values for RebootEscrowRecoveryReported.vbmeta_digest_status
    public static final int REBOOT_ESCROW_RECOVERY_REPORTED__VBMETA_DIGEST_STATUS__MATCH_EXPECTED_SLOT = 0;
    public static final int REBOOT_ESCROW_RECOVERY_REPORTED__VBMETA_DIGEST_STATUS__MATCH_FALLBACK_SLOT = 1;
    public static final int REBOOT_ESCROW_RECOVERY_REPORTED__VBMETA_DIGEST_STATUS__MISMATCH = 2;

    // Values for BootTimeEventDuration.event
    public static final int BOOT_TIME_EVENT_DURATION__EVENT__UNKNOWN = 0;
    public static final int BOOT_TIME_EVENT_DURATION__EVENT__ABSOLUTE_BOOT_TIME = 1;
    public static final int BOOT_TIME_EVENT_DURATION__EVENT__BOOTLOADER_FIRST_STAGE_EXEC = 2;
    public static final int BOOT_TIME_EVENT_DURATION__EVENT__BOOTLOADER_FIRST_STAGE_LOAD = 3;
    public static final int BOOT_TIME_EVENT_DURATION__EVENT__BOOTLOADER_KERNEL_LOAD = 4;
    public static final int BOOT_TIME_EVENT_DURATION__EVENT__BOOTLOADER_SECOND_STAGE_EXEC = 5;
    public static final int BOOT_TIME_EVENT_DURATION__EVENT__BOOTLOADER_SECOND_STAGE_LOAD = 6;
    public static final int BOOT_TIME_EVENT_DURATION__EVENT__BOOTLOADER_UI_WAIT = 7;
    public static final int BOOT_TIME_EVENT_DURATION__EVENT__BOOTLOADER_TOTAL = 8;
    public static final int BOOT_TIME_EVENT_DURATION__EVENT__SHUTDOWN_DURATION = 9;
    public static final int BOOT_TIME_EVENT_DURATION__EVENT__MOUNT_DEFAULT_DURATION = 10;
    public static final int BOOT_TIME_EVENT_DURATION__EVENT__MOUNT_EARLY_DURATION = 11;
    public static final int BOOT_TIME_EVENT_DURATION__EVENT__MOUNT_LATE_DURATION = 12;
    public static final int BOOT_TIME_EVENT_DURATION__EVENT__OTA_PACKAGE_MANAGER_INIT_TIME = 13;
    public static final int BOOT_TIME_EVENT_DURATION__EVENT__OTA_PACKAGE_MANAGER_DATA_APP_AVG_SCAN_TIME = 14;
    public static final int BOOT_TIME_EVENT_DURATION__EVENT__OTA_PACKAGE_MANAGER_SYSTEM_APP_AVG_SCAN_TIME = 15;
    public static final int BOOT_TIME_EVENT_DURATION__EVENT__COLDBOOT_WAIT = 16;
    public static final int BOOT_TIME_EVENT_DURATION__EVENT__SELINUX_INIT = 17;
    public static final int BOOT_TIME_EVENT_DURATION__EVENT__FACTORY_RESET_TIME_SINCE_RESET = 18;
    public static final int BOOT_TIME_EVENT_DURATION__EVENT__ANDROID_INIT_STAGE_1 = 19;

    // Values for BootTimeEventElapsedTime.event
    public static final int BOOT_TIME_EVENT_ELAPSED_TIME__EVENT__UNKNOWN = 0;
    public static final int BOOT_TIME_EVENT_ELAPSED_TIME__EVENT__ANDROID_INIT_STAGE_1 = 1;
    public static final int BOOT_TIME_EVENT_ELAPSED_TIME__EVENT__BOOT_COMPLETE = 2;
    public static final int BOOT_TIME_EVENT_ELAPSED_TIME__EVENT__BOOT_COMPLETE_ENCRYPTION = 3;
    public static final int BOOT_TIME_EVENT_ELAPSED_TIME__EVENT__BOOT_COMPLETE_NO_ENCRYPTION = 4;
    public static final int BOOT_TIME_EVENT_ELAPSED_TIME__EVENT__BOOT_COMPLETE_POST_DECRYPT = 5;
    public static final int BOOT_TIME_EVENT_ELAPSED_TIME__EVENT__FACTORY_RESET_BOOT_COMPLETE = 6;
    public static final int BOOT_TIME_EVENT_ELAPSED_TIME__EVENT__FACTORY_RESET_BOOT_COMPLETE_NO_ENCRYPTION = 7;
    public static final int BOOT_TIME_EVENT_ELAPSED_TIME__EVENT__FACTORY_RESET_BOOT_COMPLETE_POST_DECRYPT = 8;
    public static final int BOOT_TIME_EVENT_ELAPSED_TIME__EVENT__OTA_BOOT_COMPLETE = 9;
    public static final int BOOT_TIME_EVENT_ELAPSED_TIME__EVENT__OTA_BOOT_COMPLETE_NO_ENCRYPTION = 10;
    public static final int BOOT_TIME_EVENT_ELAPSED_TIME__EVENT__OTA_BOOT_COMPLETE_POST_DECRYPT = 11;
    public static final int BOOT_TIME_EVENT_ELAPSED_TIME__EVENT__FRAMEWORK_LOCKED_BOOT_COMPLETED = 12;
    public static final int BOOT_TIME_EVENT_ELAPSED_TIME__EVENT__FRAMEWORK_BOOT_COMPLETED = 13;
    public static final int BOOT_TIME_EVENT_ELAPSED_TIME__EVENT__PACKAGE_MANAGER_INIT_START = 14;
    public static final int BOOT_TIME_EVENT_ELAPSED_TIME__EVENT__PACKAGE_MANAGER_INIT_READY = 15;
    public static final int BOOT_TIME_EVENT_ELAPSED_TIME__EVENT__POST_DECRYPT = 16;
    public static final int BOOT_TIME_EVENT_ELAPSED_TIME__EVENT__ZYGOTE_INIT_START = 17;
    public static final int BOOT_TIME_EVENT_ELAPSED_TIME__EVENT__SECONDARY_ZYGOTE_INIT_START = 18;
    public static final int BOOT_TIME_EVENT_ELAPSED_TIME__EVENT__SYSTEM_SERVER_INIT_START = 19;
    public static final int BOOT_TIME_EVENT_ELAPSED_TIME__EVENT__SYSTEM_SERVER_READY = 20;
    public static final int BOOT_TIME_EVENT_ELAPSED_TIME__EVENT__LAUNCHER_START = 21;
    public static final int BOOT_TIME_EVENT_ELAPSED_TIME__EVENT__LAUNCHER_SHOWN = 22;

    // Values for BootTimeEventErrorCode.event
    public static final int BOOT_TIME_EVENT_ERROR_CODE__EVENT__UNKNOWN = 0;
    public static final int BOOT_TIME_EVENT_ERROR_CODE__EVENT__FACTORY_RESET_CURRENT_TIME_FAILURE = 1;
    public static final int BOOT_TIME_EVENT_ERROR_CODE__EVENT__SHUTDOWN_UMOUNT_STAT = 2;
    public static final int BOOT_TIME_EVENT_ERROR_CODE__EVENT__FS_MGR_FS_STAT_DATA_PARTITION = 3;

    // Values for UserspaceRebootReported.outcome
    public static final int USERSPACE_REBOOT_REPORTED__OUTCOME__OUTCOME_UNKNOWN = 0;
    public static final int USERSPACE_REBOOT_REPORTED__OUTCOME__SUCCESS = 1;
    public static final int USERSPACE_REBOOT_REPORTED__OUTCOME__FAILED_SHUTDOWN_SEQUENCE_ABORTED = 2;
    public static final int USERSPACE_REBOOT_REPORTED__OUTCOME__FAILED_USERDATA_REMOUNT = 3;
    public static final int USERSPACE_REBOOT_REPORTED__OUTCOME__FAILED_USERSPACE_REBOOT_WATCHDOG_TRIGGERED = 4;

    // Values for UserspaceRebootReported.user_encryption_state
    public static final int USERSPACE_REBOOT_REPORTED__USER_ENCRYPTION_STATE__USER_ENCRYPTION_STATE_UNKNOWN = 0;
    public static final int USERSPACE_REBOOT_REPORTED__USER_ENCRYPTION_STATE__UNLOCKED = 1;
    public static final int USERSPACE_REBOOT_REPORTED__USER_ENCRYPTION_STATE__LOCKED = 2;

    // Values for NotificationReported.importance
    public static final int NOTIFICATION_REPORTED__IMPORTANCE__IMPORTANCE_UNSPECIFIED = -1000;
    public static final int NOTIFICATION_REPORTED__IMPORTANCE__IMPORTANCE_NONE = 0;
    public static final int NOTIFICATION_REPORTED__IMPORTANCE__IMPORTANCE_MIN = 1;
    public static final int NOTIFICATION_REPORTED__IMPORTANCE__IMPORTANCE_LOW = 2;
    public static final int NOTIFICATION_REPORTED__IMPORTANCE__IMPORTANCE_DEFAULT = 3;
    public static final int NOTIFICATION_REPORTED__IMPORTANCE__IMPORTANCE_HIGH = 4;
    public static final int NOTIFICATION_REPORTED__IMPORTANCE__IMPORTANCE_IMPORTANT_CONVERSATION = 5;

    // Values for NotificationReported.importance_source
    public static final int NOTIFICATION_REPORTED__IMPORTANCE_SOURCE__IMPORTANCE_EXPLANATION_UNKNOWN = 0;
    public static final int NOTIFICATION_REPORTED__IMPORTANCE_SOURCE__IMPORTANCE_EXPLANATION_APP = 1;
    public static final int NOTIFICATION_REPORTED__IMPORTANCE_SOURCE__IMPORTANCE_EXPLANATION_USER = 2;
    public static final int NOTIFICATION_REPORTED__IMPORTANCE_SOURCE__IMPORTANCE_EXPLANATION_ASST = 3;
    public static final int NOTIFICATION_REPORTED__IMPORTANCE_SOURCE__IMPORTANCE_EXPLANATION_SYSTEM = 4;
    public static final int NOTIFICATION_REPORTED__IMPORTANCE_SOURCE__IMPORTANCE_EXPLANATION_APP_PRE_CHANNELS = 5;

    // Values for NotificationReported.importance_initial
    public static final int NOTIFICATION_REPORTED__IMPORTANCE_INITIAL__IMPORTANCE_UNSPECIFIED = -1000;
    public static final int NOTIFICATION_REPORTED__IMPORTANCE_INITIAL__IMPORTANCE_NONE = 0;
    public static final int NOTIFICATION_REPORTED__IMPORTANCE_INITIAL__IMPORTANCE_MIN = 1;
    public static final int NOTIFICATION_REPORTED__IMPORTANCE_INITIAL__IMPORTANCE_LOW = 2;
    public static final int NOTIFICATION_REPORTED__IMPORTANCE_INITIAL__IMPORTANCE_DEFAULT = 3;
    public static final int NOTIFICATION_REPORTED__IMPORTANCE_INITIAL__IMPORTANCE_HIGH = 4;
    public static final int NOTIFICATION_REPORTED__IMPORTANCE_INITIAL__IMPORTANCE_IMPORTANT_CONVERSATION = 5;

    // Values for NotificationReported.importance_initial_source
    public static final int NOTIFICATION_REPORTED__IMPORTANCE_INITIAL_SOURCE__IMPORTANCE_EXPLANATION_UNKNOWN = 0;
    public static final int NOTIFICATION_REPORTED__IMPORTANCE_INITIAL_SOURCE__IMPORTANCE_EXPLANATION_APP = 1;
    public static final int NOTIFICATION_REPORTED__IMPORTANCE_INITIAL_SOURCE__IMPORTANCE_EXPLANATION_USER = 2;
    public static final int NOTIFICATION_REPORTED__IMPORTANCE_INITIAL_SOURCE__IMPORTANCE_EXPLANATION_ASST = 3;
    public static final int NOTIFICATION_REPORTED__IMPORTANCE_INITIAL_SOURCE__IMPORTANCE_EXPLANATION_SYSTEM = 4;
    public static final int NOTIFICATION_REPORTED__IMPORTANCE_INITIAL_SOURCE__IMPORTANCE_EXPLANATION_APP_PRE_CHANNELS = 5;

    // Values for NotificationReported.importance_asst
    public static final int NOTIFICATION_REPORTED__IMPORTANCE_ASST__IMPORTANCE_UNSPECIFIED = -1000;
    public static final int NOTIFICATION_REPORTED__IMPORTANCE_ASST__IMPORTANCE_NONE = 0;
    public static final int NOTIFICATION_REPORTED__IMPORTANCE_ASST__IMPORTANCE_MIN = 1;
    public static final int NOTIFICATION_REPORTED__IMPORTANCE_ASST__IMPORTANCE_LOW = 2;
    public static final int NOTIFICATION_REPORTED__IMPORTANCE_ASST__IMPORTANCE_DEFAULT = 3;
    public static final int NOTIFICATION_REPORTED__IMPORTANCE_ASST__IMPORTANCE_HIGH = 4;
    public static final int NOTIFICATION_REPORTED__IMPORTANCE_ASST__IMPORTANCE_IMPORTANT_CONVERSATION = 5;

    // Values for NotificationChannelModified.old_importance
    public static final int NOTIFICATION_CHANNEL_MODIFIED__OLD_IMPORTANCE__IMPORTANCE_UNSPECIFIED = -1000;
    public static final int NOTIFICATION_CHANNEL_MODIFIED__OLD_IMPORTANCE__IMPORTANCE_NONE = 0;
    public static final int NOTIFICATION_CHANNEL_MODIFIED__OLD_IMPORTANCE__IMPORTANCE_MIN = 1;
    public static final int NOTIFICATION_CHANNEL_MODIFIED__OLD_IMPORTANCE__IMPORTANCE_LOW = 2;
    public static final int NOTIFICATION_CHANNEL_MODIFIED__OLD_IMPORTANCE__IMPORTANCE_DEFAULT = 3;
    public static final int NOTIFICATION_CHANNEL_MODIFIED__OLD_IMPORTANCE__IMPORTANCE_HIGH = 4;
    public static final int NOTIFICATION_CHANNEL_MODIFIED__OLD_IMPORTANCE__IMPORTANCE_IMPORTANT_CONVERSATION = 5;

    // Values for NotificationChannelModified.importance
    public static final int NOTIFICATION_CHANNEL_MODIFIED__IMPORTANCE__IMPORTANCE_UNSPECIFIED = -1000;
    public static final int NOTIFICATION_CHANNEL_MODIFIED__IMPORTANCE__IMPORTANCE_NONE = 0;
    public static final int NOTIFICATION_CHANNEL_MODIFIED__IMPORTANCE__IMPORTANCE_MIN = 1;
    public static final int NOTIFICATION_CHANNEL_MODIFIED__IMPORTANCE__IMPORTANCE_LOW = 2;
    public static final int NOTIFICATION_CHANNEL_MODIFIED__IMPORTANCE__IMPORTANCE_DEFAULT = 3;
    public static final int NOTIFICATION_CHANNEL_MODIFIED__IMPORTANCE__IMPORTANCE_HIGH = 4;
    public static final int NOTIFICATION_CHANNEL_MODIFIED__IMPORTANCE__IMPORTANCE_IMPORTANT_CONVERSATION = 5;

    // Values for IntegrityCheckResultReported.response
    public static final int INTEGRITY_CHECK_RESULT_REPORTED__RESPONSE__UNKNOWN = 0;
    public static final int INTEGRITY_CHECK_RESULT_REPORTED__RESPONSE__ALLOWED = 1;
    public static final int INTEGRITY_CHECK_RESULT_REPORTED__RESPONSE__REJECTED = 2;
    public static final int INTEGRITY_CHECK_RESULT_REPORTED__RESPONSE__FORCE_ALLOWED = 3;

    // Values for AppFreezeChanged.action
    public static final int APP_FREEZE_CHANGED__ACTION__UNKNOWN = 0;
    public static final int APP_FREEZE_CHANGED__ACTION__FREEZE_APP = 1;
    public static final int APP_FREEZE_CHANGED__ACTION__UNFREEZE_APP = 2;

    // Values for AppFreezeChanged.unfreeze_reason
    public static final int APP_FREEZE_CHANGED__UNFREEZE_REASON__NONE = 0;
    public static final int APP_FREEZE_CHANGED__UNFREEZE_REASON__ACTIVITY = 1;
    public static final int APP_FREEZE_CHANGED__UNFREEZE_REASON__FINISH_RECEIVER = 2;
    public static final int APP_FREEZE_CHANGED__UNFREEZE_REASON__START_RECEIVER = 3;
    public static final int APP_FREEZE_CHANGED__UNFREEZE_REASON__BIND_SERVICE = 4;
    public static final int APP_FREEZE_CHANGED__UNFREEZE_REASON__UNBIND_SERVICE = 5;
    public static final int APP_FREEZE_CHANGED__UNFREEZE_REASON__START_SERVICE = 6;
    public static final int APP_FREEZE_CHANGED__UNFREEZE_REASON__GET_PROVIDER = 7;
    public static final int APP_FREEZE_CHANGED__UNFREEZE_REASON__REMOVE_PROVIDER = 8;
    public static final int APP_FREEZE_CHANGED__UNFREEZE_REASON__UI_VISIBILITY = 9;
    public static final int APP_FREEZE_CHANGED__UNFREEZE_REASON__ALLOWLIST = 10;
    public static final int APP_FREEZE_CHANGED__UNFREEZE_REASON__PROCESS_BEGIN = 11;
    public static final int APP_FREEZE_CHANGED__UNFREEZE_REASON__PROCESS_END = 12;

    // Values for AppFreezeChanged.unfreeze_reason_v2
    public static final int APP_FREEZE_CHANGED__UNFREEZE_REASON_V2__UFR_NONE = 0;
    public static final int APP_FREEZE_CHANGED__UNFREEZE_REASON_V2__UFR_ACTIVITY = 1;
    public static final int APP_FREEZE_CHANGED__UNFREEZE_REASON_V2__UFR_FINISH_RECEIVER = 2;
    public static final int APP_FREEZE_CHANGED__UNFREEZE_REASON_V2__UFR_START_RECEIVER = 3;
    public static final int APP_FREEZE_CHANGED__UNFREEZE_REASON_V2__UFR_BIND_SERVICE = 4;
    public static final int APP_FREEZE_CHANGED__UNFREEZE_REASON_V2__UFR_UNBIND_SERVICE = 5;
    public static final int APP_FREEZE_CHANGED__UNFREEZE_REASON_V2__UFR_START_SERVICE = 6;
    public static final int APP_FREEZE_CHANGED__UNFREEZE_REASON_V2__UFR_GET_PROVIDER = 7;
    public static final int APP_FREEZE_CHANGED__UNFREEZE_REASON_V2__UFR_REMOVE_PROVIDER = 8;
    public static final int APP_FREEZE_CHANGED__UNFREEZE_REASON_V2__UFR_UI_VISIBILITY = 9;
    public static final int APP_FREEZE_CHANGED__UNFREEZE_REASON_V2__UFR_ALLOWLIST = 10;
    public static final int APP_FREEZE_CHANGED__UNFREEZE_REASON_V2__UFR_PROCESS_BEGIN = 11;
    public static final int APP_FREEZE_CHANGED__UNFREEZE_REASON_V2__UFR_PROCESS_END = 12;
    public static final int APP_FREEZE_CHANGED__UNFREEZE_REASON_V2__UFR_TRIM_MEMORY = 13;
    public static final int APP_FREEZE_CHANGED__UNFREEZE_REASON_V2__UFR_PING = 15;
    public static final int APP_FREEZE_CHANGED__UNFREEZE_REASON_V2__UFR_FILE_LOCKS = 16;
    public static final int APP_FREEZE_CHANGED__UNFREEZE_REASON_V2__UFR_FILE_LOCK_CHECK_FAILURE = 17;
    public static final int APP_FREEZE_CHANGED__UNFREEZE_REASON_V2__UFR_BINDER_TXNS = 18;
    public static final int APP_FREEZE_CHANGED__UNFREEZE_REASON_V2__UFR_FEATURE_FLAGS = 19;
    public static final int APP_FREEZE_CHANGED__UNFREEZE_REASON_V2__UFR_SHORT_FGS_TIMEOUT = 20;
    public static final int APP_FREEZE_CHANGED__UNFREEZE_REASON_V2__UFR_SYSTEM_INIT = 21;
    public static final int APP_FREEZE_CHANGED__UNFREEZE_REASON_V2__UFR_BACKUP = 22;
    public static final int APP_FREEZE_CHANGED__UNFREEZE_REASON_V2__UFR_SHELL = 23;
    public static final int APP_FREEZE_CHANGED__UNFREEZE_REASON_V2__UFR_REMOVE_TASK = 24;
    public static final int APP_FREEZE_CHANGED__UNFREEZE_REASON_V2__UFR_UID_IDLE = 25;
    public static final int APP_FREEZE_CHANGED__UNFREEZE_REASON_V2__UFR_STOP_SERVICE = 26;
    public static final int APP_FREEZE_CHANGED__UNFREEZE_REASON_V2__UFR_EXECUTING_SERVICE = 27;
    public static final int APP_FREEZE_CHANGED__UNFREEZE_REASON_V2__UFR_RESTRICTION_CHANGE = 28;
    public static final int APP_FREEZE_CHANGED__UNFREEZE_REASON_V2__UFR_COMPONENT_DISABLED = 29;

    // Values for ForegroundServiceAppOpSessionEnded.app_op_name
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED__APP_OP_NAME__APP_OP_NONE = -1;
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED__APP_OP_NAME__APP_OP_COARSE_LOCATION = 0;
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED__APP_OP_NAME__APP_OP_FINE_LOCATION = 1;
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED__APP_OP_NAME__APP_OP_GPS = 2;
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED__APP_OP_NAME__APP_OP_VIBRATE = 3;
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED__APP_OP_NAME__APP_OP_READ_CONTACTS = 4;
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED__APP_OP_NAME__APP_OP_WRITE_CONTACTS = 5;
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED__APP_OP_NAME__APP_OP_READ_CALL_LOG = 6;
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED__APP_OP_NAME__APP_OP_WRITE_CALL_LOG = 7;
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED__APP_OP_NAME__APP_OP_READ_CALENDAR = 8;
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED__APP_OP_NAME__APP_OP_WRITE_CALENDAR = 9;
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED__APP_OP_NAME__APP_OP_WIFI_SCAN = 10;
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED__APP_OP_NAME__APP_OP_POST_NOTIFICATION = 11;
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED__APP_OP_NAME__APP_OP_NEIGHBORING_CELLS = 12;
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED__APP_OP_NAME__APP_OP_CALL_PHONE = 13;
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED__APP_OP_NAME__APP_OP_READ_SMS = 14;
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED__APP_OP_NAME__APP_OP_WRITE_SMS = 15;
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED__APP_OP_NAME__APP_OP_RECEIVE_SMS = 16;
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED__APP_OP_NAME__APP_OP_RECEIVE_EMERGENCY_SMS = 17;
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED__APP_OP_NAME__APP_OP_RECEIVE_MMS = 18;
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED__APP_OP_NAME__APP_OP_RECEIVE_WAP_PUSH = 19;
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED__APP_OP_NAME__APP_OP_SEND_SMS = 20;
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED__APP_OP_NAME__APP_OP_READ_ICC_SMS = 21;
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED__APP_OP_NAME__APP_OP_WRITE_ICC_SMS = 22;
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED__APP_OP_NAME__APP_OP_WRITE_SETTINGS = 23;
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED__APP_OP_NAME__APP_OP_SYSTEM_ALERT_WINDOW = 24;
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED__APP_OP_NAME__APP_OP_ACCESS_NOTIFICATIONS = 25;
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED__APP_OP_NAME__APP_OP_CAMERA = 26;
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED__APP_OP_NAME__APP_OP_RECORD_AUDIO = 27;
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED__APP_OP_NAME__APP_OP_PLAY_AUDIO = 28;
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED__APP_OP_NAME__APP_OP_READ_CLIPBOARD = 29;
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED__APP_OP_NAME__APP_OP_WRITE_CLIPBOARD = 30;
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED__APP_OP_NAME__APP_OP_TAKE_MEDIA_BUTTONS = 31;
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED__APP_OP_NAME__APP_OP_TAKE_AUDIO_FOCUS = 32;
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED__APP_OP_NAME__APP_OP_AUDIO_MASTER_VOLUME = 33;
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED__APP_OP_NAME__APP_OP_AUDIO_VOICE_VOLUME = 34;
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED__APP_OP_NAME__APP_OP_AUDIO_RING_VOLUME = 35;
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED__APP_OP_NAME__APP_OP_AUDIO_MEDIA_VOLUME = 36;
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED__APP_OP_NAME__APP_OP_AUDIO_ALARM_VOLUME = 37;
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED__APP_OP_NAME__APP_OP_AUDIO_NOTIFICATION_VOLUME = 38;
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED__APP_OP_NAME__APP_OP_AUDIO_BLUETOOTH_VOLUME = 39;
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED__APP_OP_NAME__APP_OP_WAKE_LOCK = 40;
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED__APP_OP_NAME__APP_OP_MONITOR_LOCATION = 41;
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED__APP_OP_NAME__APP_OP_MONITOR_HIGH_POWER_LOCATION = 42;
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED__APP_OP_NAME__APP_OP_GET_USAGE_STATS = 43;
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED__APP_OP_NAME__APP_OP_MUTE_MICROPHONE = 44;
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED__APP_OP_NAME__APP_OP_TOAST_WINDOW = 45;
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED__APP_OP_NAME__APP_OP_PROJECT_MEDIA = 46;
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED__APP_OP_NAME__APP_OP_ACTIVATE_VPN = 47;
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED__APP_OP_NAME__APP_OP_WRITE_WALLPAPER = 48;
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED__APP_OP_NAME__APP_OP_ASSIST_STRUCTURE = 49;
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED__APP_OP_NAME__APP_OP_ASSIST_SCREENSHOT = 50;
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED__APP_OP_NAME__APP_OP_READ_PHONE_STATE = 51;
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED__APP_OP_NAME__APP_OP_ADD_VOICEMAIL = 52;
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED__APP_OP_NAME__APP_OP_USE_SIP = 53;
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED__APP_OP_NAME__APP_OP_PROCESS_OUTGOING_CALLS = 54;
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED__APP_OP_NAME__APP_OP_USE_FINGERPRINT = 55;
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED__APP_OP_NAME__APP_OP_BODY_SENSORS = 56;
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED__APP_OP_NAME__APP_OP_READ_CELL_BROADCASTS = 57;
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED__APP_OP_NAME__APP_OP_MOCK_LOCATION = 58;
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED__APP_OP_NAME__APP_OP_READ_EXTERNAL_STORAGE = 59;
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED__APP_OP_NAME__APP_OP_WRITE_EXTERNAL_STORAGE = 60;
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED__APP_OP_NAME__APP_OP_TURN_SCREEN_ON = 61;
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED__APP_OP_NAME__APP_OP_GET_ACCOUNTS = 62;
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED__APP_OP_NAME__APP_OP_RUN_IN_BACKGROUND = 63;
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED__APP_OP_NAME__APP_OP_AUDIO_ACCESSIBILITY_VOLUME = 64;
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED__APP_OP_NAME__APP_OP_READ_PHONE_NUMBERS = 65;
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED__APP_OP_NAME__APP_OP_REQUEST_INSTALL_PACKAGES = 66;
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED__APP_OP_NAME__APP_OP_PICTURE_IN_PICTURE = 67;
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED__APP_OP_NAME__APP_OP_INSTANT_APP_START_FOREGROUND = 68;
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED__APP_OP_NAME__APP_OP_ANSWER_PHONE_CALLS = 69;
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED__APP_OP_NAME__APP_OP_RUN_ANY_IN_BACKGROUND = 70;
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED__APP_OP_NAME__APP_OP_CHANGE_WIFI_STATE = 71;
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED__APP_OP_NAME__APP_OP_REQUEST_DELETE_PACKAGES = 72;
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED__APP_OP_NAME__APP_OP_BIND_ACCESSIBILITY_SERVICE = 73;
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED__APP_OP_NAME__APP_OP_ACCEPT_HANDOVER = 74;
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED__APP_OP_NAME__APP_OP_MANAGE_IPSEC_TUNNELS = 75;
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED__APP_OP_NAME__APP_OP_START_FOREGROUND = 76;
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED__APP_OP_NAME__APP_OP_BLUETOOTH_SCAN = 77;
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED__APP_OP_NAME__APP_OP_USE_BIOMETRIC = 78;
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED__APP_OP_NAME__APP_OP_ACTIVITY_RECOGNITION = 79;
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED__APP_OP_NAME__APP_OP_SMS_FINANCIAL_TRANSACTIONS = 80;
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED__APP_OP_NAME__APP_OP_READ_MEDIA_AUDIO = 81;
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED__APP_OP_NAME__APP_OP_WRITE_MEDIA_AUDIO = 82;
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED__APP_OP_NAME__APP_OP_READ_MEDIA_VIDEO = 83;
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED__APP_OP_NAME__APP_OP_WRITE_MEDIA_VIDEO = 84;
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED__APP_OP_NAME__APP_OP_READ_MEDIA_IMAGES = 85;
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED__APP_OP_NAME__APP_OP_WRITE_MEDIA_IMAGES = 86;
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED__APP_OP_NAME__APP_OP_LEGACY_STORAGE = 87;
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED__APP_OP_NAME__APP_OP_ACCESS_ACCESSIBILITY = 88;
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED__APP_OP_NAME__APP_OP_READ_DEVICE_IDENTIFIERS = 89;
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED__APP_OP_NAME__APP_OP_ACCESS_MEDIA_LOCATION = 90;
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED__APP_OP_NAME__APP_OP_QUERY_ALL_PACKAGES = 91;
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED__APP_OP_NAME__APP_OP_MANAGE_EXTERNAL_STORAGE = 92;
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED__APP_OP_NAME__APP_OP_INTERACT_ACROSS_PROFILES = 93;
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED__APP_OP_NAME__APP_OP_ACTIVATE_PLATFORM_VPN = 94;
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED__APP_OP_NAME__APP_OP_LOADER_USAGE_STATS = 95;
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED__APP_OP_NAME__APP_OP_DEPRECATED_1 = 96;
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED__APP_OP_NAME__APP_OP_AUTO_REVOKE_PERMISSIONS_IF_UNUSED = 97;
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED__APP_OP_NAME__APP_OP_AUTO_REVOKE_MANAGED_BY_INSTALLER = 98;
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED__APP_OP_NAME__APP_OP_NO_ISOLATED_STORAGE = 99;
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED__APP_OP_NAME__APP_OP_PHONE_CALL_MICROPHONE = 100;
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED__APP_OP_NAME__APP_OP_PHONE_CALL_CAMERA = 101;
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED__APP_OP_NAME__APP_OP_RECORD_AUDIO_HOTWORD = 102;
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED__APP_OP_NAME__APP_OP_MANAGE_ONGOING_CALLS = 103;
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED__APP_OP_NAME__APP_OP_MANAGE_CREDENTIALS = 104;
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED__APP_OP_NAME__APP_OP_USE_ICC_AUTH_WITH_DEVICE_IDENTIFIER = 105;
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED__APP_OP_NAME__APP_OP_RECORD_AUDIO_OUTPUT = 106;
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED__APP_OP_NAME__APP_OP_SCHEDULE_EXACT_ALARM = 107;
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED__APP_OP_NAME__APP_OP_FINE_LOCATION_SOURCE = 108;
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED__APP_OP_NAME__APP_OP_COARSE_LOCATION_SOURCE = 109;
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED__APP_OP_NAME__APP_OP_MANAGE_MEDIA = 110;
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED__APP_OP_NAME__APP_OP_BLUETOOTH_CONNECT = 111;
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED__APP_OP_NAME__APP_OP_UWB_RANGING = 112;
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED__APP_OP_NAME__APP_OP_ACTIVITY_RECOGNITION_SOURCE = 113;
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED__APP_OP_NAME__APP_OP_BLUETOOTH_ADVERTISE = 114;
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED__APP_OP_NAME__APP_OP_RECORD_INCOMING_PHONE_AUDIO = 115;
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED__APP_OP_NAME__APP_OP_NEARBY_WIFI_DEVICES = 116;
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED__APP_OP_NAME__APP_OP_ESTABLISH_VPN_SERVICE = 117;
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED__APP_OP_NAME__APP_OP_ESTABLISH_VPN_MANAGER = 118;
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED__APP_OP_NAME__APP_OP_ACCESS_RESTRICTED_SETTINGS = 119;
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED__APP_OP_NAME__APP_OP_RECEIVE_AMBIENT_TRIGGER_AUDIO = 120;
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED__APP_OP_NAME__APP_OP_RECEIVE_EXPLICIT_USER_INTERACTION_AUDIO = 121;
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED__APP_OP_NAME__APP_OP_RUN_USER_INITIATED_JOBS = 122;
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED__APP_OP_NAME__APP_OP_READ_MEDIA_VISUAL_USER_SELECTED = 123;
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED__APP_OP_NAME__APP_OP_SYSTEM_EXEMPT_FROM_SUSPENSION = 124;
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED__APP_OP_NAME__APP_OP_SYSTEM_EXEMPT_FROM_DISMISSIBLE_NOTIFICATIONS = 125;
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED__APP_OP_NAME__APP_OP_READ_WRITE_HEALTH_DATA = 126;
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED__APP_OP_NAME__APP_OP_FOREGROUND_SERVICE_SPECIAL_USE = 127;
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED__APP_OP_NAME__APP_OP_SYSTEM_EXEMPT_FROM_POWER_RESTRICTIONS = 128;
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED__APP_OP_NAME__APP_OP_SYSTEM_EXEMPT_FROM_HIBERNATION = 129;
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED__APP_OP_NAME__APP_OP_SYSTEM_EXEMPT_FROM_ACTIVITY_BG_START_RESTRICTION = 130;
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED__APP_OP_NAME__APP_OP_CAPTURE_CONSENTLESS_BUGREPORT_ON_USERDEBUG_BUILD = 131;
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED__APP_OP_NAME__APP_OP_BODY_SENSORS_WRIST_TEMPERATURE = 132;
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED__APP_OP_NAME__APP_OP_USE_FULL_SCREEN_INTENT = 133;
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED__APP_OP_NAME__APP_OP_CAMERA_SANDBOXED = 134;
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED__APP_OP_NAME__APP_OP_RECORD_AUDIO_SANDBOXED = 135;

    // Values for ForegroundServiceAppOpSessionEnded.app_op_mode
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED__APP_OP_MODE__MODE_UNKNOWN = 0;
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED__APP_OP_MODE__MODE_ALLOWED = 1;
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED__APP_OP_MODE__MODE_IGNORED = 2;
    public static final int FOREGROUND_SERVICE_APP_OP_SESSION_ENDED__APP_OP_MODE__MODE_FOREGROUND = 3;

    // Values for AppStandbyBucketChanged.bucket
    public static final int APP_STANDBY_BUCKET_CHANGED__BUCKET__BUCKET_UNKNOWN = 0;
    public static final int APP_STANDBY_BUCKET_CHANGED__BUCKET__BUCKET_EXEMPTED = 5;
    public static final int APP_STANDBY_BUCKET_CHANGED__BUCKET__BUCKET_ACTIVE = 10;
    public static final int APP_STANDBY_BUCKET_CHANGED__BUCKET__BUCKET_WORKING_SET = 20;
    public static final int APP_STANDBY_BUCKET_CHANGED__BUCKET__BUCKET_FREQUENT = 30;
    public static final int APP_STANDBY_BUCKET_CHANGED__BUCKET__BUCKET_RARE = 40;
    public static final int APP_STANDBY_BUCKET_CHANGED__BUCKET__BUCKET_RESTRICTED = 45;
    public static final int APP_STANDBY_BUCKET_CHANGED__BUCKET__BUCKET_NEVER = 50;

    // Values for AppStandbyBucketChanged.main_reason
    public static final int APP_STANDBY_BUCKET_CHANGED__MAIN_REASON__MAIN_UNKNOWN = 0;
    public static final int APP_STANDBY_BUCKET_CHANGED__MAIN_REASON__MAIN_DEFAULT = 256;
    public static final int APP_STANDBY_BUCKET_CHANGED__MAIN_REASON__MAIN_TIMEOUT = 512;
    public static final int APP_STANDBY_BUCKET_CHANGED__MAIN_REASON__MAIN_USAGE = 768;
    public static final int APP_STANDBY_BUCKET_CHANGED__MAIN_REASON__MAIN_FORCED_BY_USER = 1024;
    public static final int APP_STANDBY_BUCKET_CHANGED__MAIN_REASON__MAIN_PREDICTED = 1280;
    public static final int APP_STANDBY_BUCKET_CHANGED__MAIN_REASON__MAIN_FORCED_BY_SYSTEM = 1536;

    // Values for SharesheetStarted.preview_type
    public static final int SHARESHEET_STARTED__PREVIEW_TYPE__CONTENT_PREVIEW_TYPE_UNKNOWN = 0;
    public static final int SHARESHEET_STARTED__PREVIEW_TYPE__CONTENT_PREVIEW_IMAGE = 1;
    public static final int SHARESHEET_STARTED__PREVIEW_TYPE__CONTENT_PREVIEW_FILE = 2;
    public static final int SHARESHEET_STARTED__PREVIEW_TYPE__CONTENT_PREVIEW_TEXT = 3;

    // Values for SharesheetStarted.intent_type
    public static final int SHARESHEET_STARTED__INTENT_TYPE__INTENT_DEFAULT = 0;
    public static final int SHARESHEET_STARTED__INTENT_TYPE__INTENT_ACTION_VIEW = 1;
    public static final int SHARESHEET_STARTED__INTENT_TYPE__INTENT_ACTION_EDIT = 2;
    public static final int SHARESHEET_STARTED__INTENT_TYPE__INTENT_ACTION_SEND = 3;
    public static final int SHARESHEET_STARTED__INTENT_TYPE__INTENT_ACTION_SENDTO = 4;
    public static final int SHARESHEET_STARTED__INTENT_TYPE__INTENT_ACTION_SEND_MULTIPLE = 5;
    public static final int SHARESHEET_STARTED__INTENT_TYPE__INTENT_ACTION_IMAGE_CAPTURE = 6;
    public static final int SHARESHEET_STARTED__INTENT_TYPE__INTENT_ACTION_MAIN = 7;

    // Values for UserLifecycleJourneyReported.journey
    public static final int USER_LIFECYCLE_JOURNEY_REPORTED__JOURNEY__UNKNOWN = 0;
    public static final int USER_LIFECYCLE_JOURNEY_REPORTED__JOURNEY__USER_SWITCH_UI = 1;
    public static final int USER_LIFECYCLE_JOURNEY_REPORTED__JOURNEY__USER_SWITCH_FG = 2;
    public static final int USER_LIFECYCLE_JOURNEY_REPORTED__JOURNEY__USER_START = 3;
    public static final int USER_LIFECYCLE_JOURNEY_REPORTED__JOURNEY__USER_CREATE = 4;
    public static final int USER_LIFECYCLE_JOURNEY_REPORTED__JOURNEY__USER_STOP = 5;
    public static final int USER_LIFECYCLE_JOURNEY_REPORTED__JOURNEY__USER_REMOVE = 6;
    public static final int USER_LIFECYCLE_JOURNEY_REPORTED__JOURNEY__GRANT_ADMIN = 7;
    public static final int USER_LIFECYCLE_JOURNEY_REPORTED__JOURNEY__REVOKE_ADMIN = 8;
    public static final int USER_LIFECYCLE_JOURNEY_REPORTED__JOURNEY__USER_LIFECYCLE = 9;

    // Values for UserLifecycleJourneyReported.user_type
    public static final int USER_LIFECYCLE_JOURNEY_REPORTED__USER_TYPE__TYPE_UNKNOWN = 0;
    public static final int USER_LIFECYCLE_JOURNEY_REPORTED__USER_TYPE__FULL_SYSTEM = 1;
    public static final int USER_LIFECYCLE_JOURNEY_REPORTED__USER_TYPE__FULL_SECONDARY = 2;
    public static final int USER_LIFECYCLE_JOURNEY_REPORTED__USER_TYPE__FULL_GUEST = 3;
    public static final int USER_LIFECYCLE_JOURNEY_REPORTED__USER_TYPE__FULL_DEMO = 4;
    public static final int USER_LIFECYCLE_JOURNEY_REPORTED__USER_TYPE__FULL_RESTRICTED = 5;
    public static final int USER_LIFECYCLE_JOURNEY_REPORTED__USER_TYPE__PROFILE_MANAGED = 6;
    public static final int USER_LIFECYCLE_JOURNEY_REPORTED__USER_TYPE__SYSTEM_HEADLESS = 7;
    public static final int USER_LIFECYCLE_JOURNEY_REPORTED__USER_TYPE__PROFILE_CLONE = 8;

    // Values for UserLifecycleEventOccurred.event
    public static final int USER_LIFECYCLE_EVENT_OCCURRED__EVENT__UNKNOWN = 0;
    public static final int USER_LIFECYCLE_EVENT_OCCURRED__EVENT__SWITCH_USER = 1;
    public static final int USER_LIFECYCLE_EVENT_OCCURRED__EVENT__START_USER = 2;
    public static final int USER_LIFECYCLE_EVENT_OCCURRED__EVENT__CREATE_USER = 3;
    public static final int USER_LIFECYCLE_EVENT_OCCURRED__EVENT__USER_RUNNING_LOCKED = 4;
    public static final int USER_LIFECYCLE_EVENT_OCCURRED__EVENT__UNLOCKING_USER = 5;
    public static final int USER_LIFECYCLE_EVENT_OCCURRED__EVENT__UNLOCKED_USER = 6;
    public static final int USER_LIFECYCLE_EVENT_OCCURRED__EVENT__STOP_USER = 7;
    public static final int USER_LIFECYCLE_EVENT_OCCURRED__EVENT__REMOVE_USER = 8;
    public static final int USER_LIFECYCLE_EVENT_OCCURRED__EVENT__GRANT_ADMIN = 9;
    public static final int USER_LIFECYCLE_EVENT_OCCURRED__EVENT__REVOKE_ADMIN = 10;

    // Values for UserLifecycleEventOccurred.state
    public static final int USER_LIFECYCLE_EVENT_OCCURRED__STATE__NONE = 0;
    public static final int USER_LIFECYCLE_EVENT_OCCURRED__STATE__BEGIN = 1;
    public static final int USER_LIFECYCLE_EVENT_OCCURRED__STATE__FINISH = 2;
    public static final int USER_LIFECYCLE_EVENT_OCCURRED__STATE__CANCEL = 3;
    public static final int USER_LIFECYCLE_EVENT_OCCURRED__STATE__ERROR = 4;

    // Values for AccessibilityShortcutReported.shortcut_type
    public static final int ACCESSIBILITY_SHORTCUT_REPORTED__SHORTCUT_TYPE__UNKNOWN_TYPE = 0;
    public static final int ACCESSIBILITY_SHORTCUT_REPORTED__SHORTCUT_TYPE__A11Y_BUTTON = 1;
    public static final int ACCESSIBILITY_SHORTCUT_REPORTED__SHORTCUT_TYPE__VOLUME_KEY = 2;
    public static final int ACCESSIBILITY_SHORTCUT_REPORTED__SHORTCUT_TYPE__TRIPLE_TAP = 3;
    public static final int ACCESSIBILITY_SHORTCUT_REPORTED__SHORTCUT_TYPE__A11Y_BUTTON_LONG_PRESS = 4;
    public static final int ACCESSIBILITY_SHORTCUT_REPORTED__SHORTCUT_TYPE__A11Y_FLOATING_MENU = 5;
    public static final int ACCESSIBILITY_SHORTCUT_REPORTED__SHORTCUT_TYPE__A11Y_GESTURE = 6;
    public static final int ACCESSIBILITY_SHORTCUT_REPORTED__SHORTCUT_TYPE__A11Y_WEAR_TRIPLE_PRESS_GESTURE = 7;

    // Values for AccessibilityShortcutReported.service_status
    public static final int ACCESSIBILITY_SHORTCUT_REPORTED__SERVICE_STATUS__UNKNOWN = 0;
    public static final int ACCESSIBILITY_SHORTCUT_REPORTED__SERVICE_STATUS__ENABLED = 1;
    public static final int ACCESSIBILITY_SHORTCUT_REPORTED__SERVICE_STATUS__DISABLED = 2;

    // Values for AppUsageEventOccurred.event_type
    public static final int APP_USAGE_EVENT_OCCURRED__EVENT_TYPE__NONE = 0;
    public static final int APP_USAGE_EVENT_OCCURRED__EVENT_TYPE__MOVE_TO_FOREGROUND = 1;
    public static final int APP_USAGE_EVENT_OCCURRED__EVENT_TYPE__MOVE_TO_BACKGROUND = 2;

    // Values for TvTunerStateChanged.state
    public static final int TV_TUNER_STATE_CHANGED__STATE__UNKNOWN = 0;
    public static final int TV_TUNER_STATE_CHANGED__STATE__TUNING = 1;
    public static final int TV_TUNER_STATE_CHANGED__STATE__LOCKED = 2;
    public static final int TV_TUNER_STATE_CHANGED__STATE__NOT_LOCKED = 3;
    public static final int TV_TUNER_STATE_CHANGED__STATE__SIGNAL_LOST = 4;
    public static final int TV_TUNER_STATE_CHANGED__STATE__SCANNING = 5;
    public static final int TV_TUNER_STATE_CHANGED__STATE__SCAN_STOPPED = 6;

    // Values for TvTunerDvrStatus.type
    public static final int TV_TUNER_DVR_STATUS__TYPE__UNKNOWN_TYPE = 0;
    public static final int TV_TUNER_DVR_STATUS__TYPE__PLAYBACK = 1;
    public static final int TV_TUNER_DVR_STATUS__TYPE__RECORD = 2;

    // Values for TvTunerDvrStatus.state
    public static final int TV_TUNER_DVR_STATUS__STATE__UNKNOWN_STATE = 0;
    public static final int TV_TUNER_DVR_STATUS__STATE__STARTED = 1;
    public static final int TV_TUNER_DVR_STATUS__STATE__STOPPED = 2;

    // Values for TvCasSessionOpenStatus.state
    public static final int TV_CAS_SESSION_OPEN_STATUS__STATE__UNKNOWN = 0;
    public static final int TV_CAS_SESSION_OPEN_STATUS__STATE__SUCCEEDED = 1;
    public static final int TV_CAS_SESSION_OPEN_STATUS__STATE__FAILED = 2;

    // Values for AssistantInvocationReported.device_state
    public static final int ASSISTANT_INVOCATION_REPORTED__DEVICE_STATE__UNKNOWN_DEVICE_STATE = 0;
    public static final int ASSISTANT_INVOCATION_REPORTED__DEVICE_STATE__AOD1 = 1;
    public static final int ASSISTANT_INVOCATION_REPORTED__DEVICE_STATE__AOD2 = 2;
    public static final int ASSISTANT_INVOCATION_REPORTED__DEVICE_STATE__BOUNCER = 3;
    public static final int ASSISTANT_INVOCATION_REPORTED__DEVICE_STATE__UNLOCKED_LOCKSCREEN = 4;
    public static final int ASSISTANT_INVOCATION_REPORTED__DEVICE_STATE__LAUNCHER_HOME = 5;
    public static final int ASSISTANT_INVOCATION_REPORTED__DEVICE_STATE__LAUNCHER_OVERVIEW = 6;
    public static final int ASSISTANT_INVOCATION_REPORTED__DEVICE_STATE__LAUNCHER_ALL_APPS = 7;
    public static final int ASSISTANT_INVOCATION_REPORTED__DEVICE_STATE__APP_DEFAULT = 8;
    public static final int ASSISTANT_INVOCATION_REPORTED__DEVICE_STATE__APP_IMMERSIVE = 9;
    public static final int ASSISTANT_INVOCATION_REPORTED__DEVICE_STATE__APP_FULLSCREEN = 10;

    // Values for BlobCommitted.result
    public static final int BLOB_COMMITTED__RESULT__UNKNOWN = 0;
    public static final int BLOB_COMMITTED__RESULT__SUCCESS = 1;
    public static final int BLOB_COMMITTED__RESULT__ERROR_DURING_COMMIT = 2;
    public static final int BLOB_COMMITTED__RESULT__DIGEST_MISMATCH = 3;
    public static final int BLOB_COMMITTED__RESULT__COUNT_LIMIT_EXCEEDED = 4;

    // Values for BlobLeased.result
    public static final int BLOB_LEASED__RESULT__UNKNOWN = 0;
    public static final int BLOB_LEASED__RESULT__SUCCESS = 1;
    public static final int BLOB_LEASED__RESULT__BLOB_DNE = 2;
    public static final int BLOB_LEASED__RESULT__ACCESS_NOT_ALLOWED = 3;
    public static final int BLOB_LEASED__RESULT__LEASE_EXPIRY_INVALID = 4;
    public static final int BLOB_LEASED__RESULT__DATA_SIZE_LIMIT_EXCEEDED = 5;
    public static final int BLOB_LEASED__RESULT__COUNT_LIMIT_EXCEEDED = 6;

    // Values for BlobOpened.result
    public static final int BLOB_OPENED__RESULT__UNKNOWN = 0;
    public static final int BLOB_OPENED__RESULT__SUCCESS = 1;
    public static final int BLOB_OPENED__RESULT__BLOB_DNE = 2;
    public static final int BLOB_OPENED__RESULT__ACCESS_NOT_ALLOWED = 3;

    // Values for UIInteractionFrameInfoReported.interaction_type
    public static final int UIINTERACTION_FRAME_INFO_REPORTED__INTERACTION_TYPE__UNKNOWN_INTERACTION = 0;
    public static final int UIINTERACTION_FRAME_INFO_REPORTED__INTERACTION_TYPE__NOTIFICATION_SHADE_SWIPE = 1;
    public static final int UIINTERACTION_FRAME_INFO_REPORTED__INTERACTION_TYPE__SHADE_SCROLL_FLING = 3;
    public static final int UIINTERACTION_FRAME_INFO_REPORTED__INTERACTION_TYPE__SHADE_ROW_EXPAND = 4;
    public static final int UIINTERACTION_FRAME_INFO_REPORTED__INTERACTION_TYPE__SHADE_ROW_SWIPE = 5;
    public static final int UIINTERACTION_FRAME_INFO_REPORTED__INTERACTION_TYPE__SHADE_QS_EXPAND_COLLAPSE = 6;
    public static final int UIINTERACTION_FRAME_INFO_REPORTED__INTERACTION_TYPE__SHADE_QS_SCROLL_SWIPE = 7;
    public static final int UIINTERACTION_FRAME_INFO_REPORTED__INTERACTION_TYPE__LAUNCHER_APP_LAUNCH_FROM_RECENTS = 8;
    public static final int UIINTERACTION_FRAME_INFO_REPORTED__INTERACTION_TYPE__LAUNCHER_APP_LAUNCH_FROM_ICON = 9;
    public static final int UIINTERACTION_FRAME_INFO_REPORTED__INTERACTION_TYPE__LAUNCHER_APP_CLOSE_TO_HOME = 10;
    public static final int UIINTERACTION_FRAME_INFO_REPORTED__INTERACTION_TYPE__LAUNCHER_APP_CLOSE_TO_PIP = 11;
    public static final int UIINTERACTION_FRAME_INFO_REPORTED__INTERACTION_TYPE__LAUNCHER_QUICK_SWITCH = 12;
    public static final int UIINTERACTION_FRAME_INFO_REPORTED__INTERACTION_TYPE__SHADE_HEADS_UP_APPEAR = 13;
    public static final int UIINTERACTION_FRAME_INFO_REPORTED__INTERACTION_TYPE__SHADE_HEADS_UP_DISAPPEAR = 14;
    public static final int UIINTERACTION_FRAME_INFO_REPORTED__INTERACTION_TYPE__SHADE_NOTIFICATION_ADD = 15;
    public static final int UIINTERACTION_FRAME_INFO_REPORTED__INTERACTION_TYPE__SHADE_NOTIFICATION_REMOVE = 16;
    public static final int UIINTERACTION_FRAME_INFO_REPORTED__INTERACTION_TYPE__SHADE_APP_LAUNCH = 17;
    public static final int UIINTERACTION_FRAME_INFO_REPORTED__INTERACTION_TYPE__LOCKSCREEN_PASSWORD_APPEAR = 18;
    public static final int UIINTERACTION_FRAME_INFO_REPORTED__INTERACTION_TYPE__LOCKSCREEN_PATTERN_APPEAR = 19;
    public static final int UIINTERACTION_FRAME_INFO_REPORTED__INTERACTION_TYPE__LOCKSCREEN_PIN_APPEAR = 20;
    public static final int UIINTERACTION_FRAME_INFO_REPORTED__INTERACTION_TYPE__LOCKSCREEN_PASSWORD_DISAPPEAR = 21;
    public static final int UIINTERACTION_FRAME_INFO_REPORTED__INTERACTION_TYPE__LOCKSCREEN_PATTERN_DISAPPEAR = 22;
    public static final int UIINTERACTION_FRAME_INFO_REPORTED__INTERACTION_TYPE__LOCKSCREEN_PIN_DISAPPEAR = 23;
    public static final int UIINTERACTION_FRAME_INFO_REPORTED__INTERACTION_TYPE__LOCKSCREEN_TRANSITION_FROM_AOD = 24;
    public static final int UIINTERACTION_FRAME_INFO_REPORTED__INTERACTION_TYPE__LOCKSCREEN_TRANSITION_TO_AOD = 25;
    public static final int UIINTERACTION_FRAME_INFO_REPORTED__INTERACTION_TYPE__LAUNCHER_OPEN_ALL_APPS = 26;
    public static final int UIINTERACTION_FRAME_INFO_REPORTED__INTERACTION_TYPE__LAUNCHER_ALL_APPS_SCROLL = 27;
    public static final int UIINTERACTION_FRAME_INFO_REPORTED__INTERACTION_TYPE__LAUNCHER_APP_LAUNCH_FROM_WIDGET = 28;
    public static final int UIINTERACTION_FRAME_INFO_REPORTED__INTERACTION_TYPE__SETTINGS_PAGE_SCROLL = 29;
    public static final int UIINTERACTION_FRAME_INFO_REPORTED__INTERACTION_TYPE__LOCKSCREEN_UNLOCK_ANIMATION = 30;
    public static final int UIINTERACTION_FRAME_INFO_REPORTED__INTERACTION_TYPE__SHADE_APP_LAUNCH_FROM_HISTORY_BUTTON = 31;
    public static final int UIINTERACTION_FRAME_INFO_REPORTED__INTERACTION_TYPE__SHADE_APP_LAUNCH_FROM_MEDIA_PLAYER = 32;
    public static final int UIINTERACTION_FRAME_INFO_REPORTED__INTERACTION_TYPE__SHADE_APP_LAUNCH_FROM_QS_TILE = 33;
    public static final int UIINTERACTION_FRAME_INFO_REPORTED__INTERACTION_TYPE__SHADE_APP_LAUNCH_FROM_SETTINGS_BUTTON = 34;
    public static final int UIINTERACTION_FRAME_INFO_REPORTED__INTERACTION_TYPE__STATUS_BAR_APP_LAUNCH_FROM_CALL_CHIP = 35;
    public static final int UIINTERACTION_FRAME_INFO_REPORTED__INTERACTION_TYPE__PIP_TRANSITION = 36;
    public static final int UIINTERACTION_FRAME_INFO_REPORTED__INTERACTION_TYPE__WALLPAPER_TRANSITION = 37;
    public static final int UIINTERACTION_FRAME_INFO_REPORTED__INTERACTION_TYPE__USER_SWITCH = 38;
    public static final int UIINTERACTION_FRAME_INFO_REPORTED__INTERACTION_TYPE__SPLASHSCREEN_AVD = 39;
    public static final int UIINTERACTION_FRAME_INFO_REPORTED__INTERACTION_TYPE__SPLASHSCREEN_EXIT_ANIM = 40;
    public static final int UIINTERACTION_FRAME_INFO_REPORTED__INTERACTION_TYPE__SCREEN_OFF = 41;
    public static final int UIINTERACTION_FRAME_INFO_REPORTED__INTERACTION_TYPE__SCREEN_OFF_SHOW_AOD = 42;
    public static final int UIINTERACTION_FRAME_INFO_REPORTED__INTERACTION_TYPE__ONE_HANDED_ENTER_TRANSITION = 43;
    public static final int UIINTERACTION_FRAME_INFO_REPORTED__INTERACTION_TYPE__ONE_HANDED_EXIT_TRANSITION = 44;
    public static final int UIINTERACTION_FRAME_INFO_REPORTED__INTERACTION_TYPE__UNFOLD_ANIM = 45;
    public static final int UIINTERACTION_FRAME_INFO_REPORTED__INTERACTION_TYPE__SUW_LOADING_TO_SHOW_INFO_WITH_ACTIONS = 46;
    public static final int UIINTERACTION_FRAME_INFO_REPORTED__INTERACTION_TYPE__SUW_SHOW_FUNCTION_SCREEN_WITH_ACTIONS = 47;
    public static final int UIINTERACTION_FRAME_INFO_REPORTED__INTERACTION_TYPE__SUW_LOADING_TO_NEXT_FLOW = 48;
    public static final int UIINTERACTION_FRAME_INFO_REPORTED__INTERACTION_TYPE__SUW_LOADING_SCREEN_FOR_STATUS = 49;
    public static final int UIINTERACTION_FRAME_INFO_REPORTED__INTERACTION_TYPE__SPLIT_SCREEN_ENTER = 50;
    public static final int UIINTERACTION_FRAME_INFO_REPORTED__INTERACTION_TYPE__SPLIT_SCREEN_EXIT = 51;
    public static final int UIINTERACTION_FRAME_INFO_REPORTED__INTERACTION_TYPE__LOCKSCREEN_LAUNCH_CAMERA = 52;
    public static final int UIINTERACTION_FRAME_INFO_REPORTED__INTERACTION_TYPE__SPLIT_SCREEN_RESIZE = 53;
    public static final int UIINTERACTION_FRAME_INFO_REPORTED__INTERACTION_TYPE__SETTINGS_SLIDER = 54;
    public static final int UIINTERACTION_FRAME_INFO_REPORTED__INTERACTION_TYPE__TAKE_SCREENSHOT = 55;
    public static final int UIINTERACTION_FRAME_INFO_REPORTED__INTERACTION_TYPE__VOLUME_CONTROL = 56;
    public static final int UIINTERACTION_FRAME_INFO_REPORTED__INTERACTION_TYPE__BIOMETRIC_PROMPT_TRANSITION = 57;
    public static final int UIINTERACTION_FRAME_INFO_REPORTED__INTERACTION_TYPE__SETTINGS_TOGGLE = 58;
    public static final int UIINTERACTION_FRAME_INFO_REPORTED__INTERACTION_TYPE__SHADE_DIALOG_OPEN = 59;
    public static final int UIINTERACTION_FRAME_INFO_REPORTED__INTERACTION_TYPE__USER_DIALOG_OPEN = 60;
    public static final int UIINTERACTION_FRAME_INFO_REPORTED__INTERACTION_TYPE__TASKBAR_EXPAND = 61;
    public static final int UIINTERACTION_FRAME_INFO_REPORTED__INTERACTION_TYPE__TASKBAR_COLLAPSE = 62;
    public static final int UIINTERACTION_FRAME_INFO_REPORTED__INTERACTION_TYPE__SHADE_CLEAR_ALL = 63;
    public static final int UIINTERACTION_FRAME_INFO_REPORTED__INTERACTION_TYPE__LAUNCHER_UNLOCK_ENTRANCE_ANIMATION = 64;
    public static final int UIINTERACTION_FRAME_INFO_REPORTED__INTERACTION_TYPE__LOCKSCREEN_OCCLUSION = 65;
    public static final int UIINTERACTION_FRAME_INFO_REPORTED__INTERACTION_TYPE__RECENTS_SCROLLING = 66;
    public static final int UIINTERACTION_FRAME_INFO_REPORTED__INTERACTION_TYPE__LAUNCHER_APP_SWIPE_TO_RECENTS = 67;
    public static final int UIINTERACTION_FRAME_INFO_REPORTED__INTERACTION_TYPE__LAUNCHER_CLOSE_ALL_APPS_SWIPE = 68;
    public static final int UIINTERACTION_FRAME_INFO_REPORTED__INTERACTION_TYPE__LAUNCHER_CLOSE_ALL_APPS_TO_HOME = 69;
    public static final int UIINTERACTION_FRAME_INFO_REPORTED__INTERACTION_TYPE__IME_INSETS_ANIMATION = 70;
    public static final int UIINTERACTION_FRAME_INFO_REPORTED__INTERACTION_TYPE__LOCKSCREEN_CLOCK_MOVE_ANIMATION = 71;
    public static final int UIINTERACTION_FRAME_INFO_REPORTED__INTERACTION_TYPE__LAUNCHER_OPEN_SEARCH_RESULT = 72;

    // Values for UIInteractionFrameInfoReported.display_resolution
    public static final int UIINTERACTION_FRAME_INFO_REPORTED__DISPLAY_RESOLUTION__UNKNOWN_RESOLUTION = 0;
    public static final int UIINTERACTION_FRAME_INFO_REPORTED__DISPLAY_RESOLUTION__SD = 1;
    public static final int UIINTERACTION_FRAME_INFO_REPORTED__DISPLAY_RESOLUTION__HD = 2;
    public static final int UIINTERACTION_FRAME_INFO_REPORTED__DISPLAY_RESOLUTION__FHD = 3;
    public static final int UIINTERACTION_FRAME_INFO_REPORTED__DISPLAY_RESOLUTION__QHD = 4;

    // Values for UIActionLatencyReported.action
    public static final int UIACTION_LATENCY_REPORTED__ACTION__UNKNOWN_ACTION = 0;
    public static final int UIACTION_LATENCY_REPORTED__ACTION__ACTION_EXPAND_PANEL = 1;
    public static final int UIACTION_LATENCY_REPORTED__ACTION__ACTION_TOGGLE_RECENTS = 2;
    public static final int UIACTION_LATENCY_REPORTED__ACTION__ACTION_FINGERPRINT_WAKE_AND_UNLOCK = 3;
    public static final int UIACTION_LATENCY_REPORTED__ACTION__ACTION_CHECK_CREDENTIAL = 4;
    public static final int UIACTION_LATENCY_REPORTED__ACTION__ACTION_CHECK_CREDENTIAL_UNLOCKED = 5;
    public static final int UIACTION_LATENCY_REPORTED__ACTION__ACTION_TURN_ON_SCREEN = 6;
    public static final int UIACTION_LATENCY_REPORTED__ACTION__ACTION_ROTATE_SCREEN = 7;
    public static final int UIACTION_LATENCY_REPORTED__ACTION__ACTION_FACE_WAKE_AND_UNLOCK = 8;
    public static final int UIACTION_LATENCY_REPORTED__ACTION__ACTION_START_RECENTS_ANIMATION = 9;
    public static final int UIACTION_LATENCY_REPORTED__ACTION__ACTION_ROTATE_SCREEN_CAMERA_CHECK = 10;
    public static final int UIACTION_LATENCY_REPORTED__ACTION__ACTION_ROTATE_SCREEN_SENSOR = 11;
    public static final int UIACTION_LATENCY_REPORTED__ACTION__ACTION_LOCKSCREEN_UNLOCK = 12;
    public static final int UIACTION_LATENCY_REPORTED__ACTION__ACTION_USER_SWITCH = 13;
    public static final int UIACTION_LATENCY_REPORTED__ACTION__ACTION_SWITCH_DISPLAY_UNFOLD = 14;
    public static final int UIACTION_LATENCY_REPORTED__ACTION__ACTION_UDFPS_ILLUMINATE = 15;
    public static final int UIACTION_LATENCY_REPORTED__ACTION__ACTION_SHOW_BACK_ARROW = 16;
    public static final int UIACTION_LATENCY_REPORTED__ACTION__ACTION_LOAD_SHARE_SHEET = 17;
    public static final int UIACTION_LATENCY_REPORTED__ACTION__ACTION_SHOW_SELECTION_TOOLBAR = 18;
    public static final int UIACTION_LATENCY_REPORTED__ACTION__ACTION_FOLD_TO_AOD = 19;
    public static final int UIACTION_LATENCY_REPORTED__ACTION__ACTION_SHOW_VOICE_INTERACTION = 20;
    public static final int UIACTION_LATENCY_REPORTED__ACTION__ACTION_REQUEST_IME_SHOWN = 21;
    public static final int UIACTION_LATENCY_REPORTED__ACTION__ACTION_REQUEST_IME_HIDDEN = 22;
    public static final int UIACTION_LATENCY_REPORTED__ACTION__ACTION_SMARTSPACE_DOORBELL = 23;

    // Values for HdmiCecActiveSourceChanged.active_source_logical_address
    public static final int HDMI_CEC_ACTIVE_SOURCE_CHANGED__ACTIVE_SOURCE_LOGICAL_ADDRESS__LOGICAL_ADDRESS_UNKNOWN = -1;
    public static final int HDMI_CEC_ACTIVE_SOURCE_CHANGED__ACTIVE_SOURCE_LOGICAL_ADDRESS__TV = 0;
    public static final int HDMI_CEC_ACTIVE_SOURCE_CHANGED__ACTIVE_SOURCE_LOGICAL_ADDRESS__RECORDING_DEVICE_1 = 1;
    public static final int HDMI_CEC_ACTIVE_SOURCE_CHANGED__ACTIVE_SOURCE_LOGICAL_ADDRESS__RECORDING_DEVICE_2 = 2;
    public static final int HDMI_CEC_ACTIVE_SOURCE_CHANGED__ACTIVE_SOURCE_LOGICAL_ADDRESS__TUNER_1 = 3;
    public static final int HDMI_CEC_ACTIVE_SOURCE_CHANGED__ACTIVE_SOURCE_LOGICAL_ADDRESS__PLAYBACK_DEVICE_1 = 4;
    public static final int HDMI_CEC_ACTIVE_SOURCE_CHANGED__ACTIVE_SOURCE_LOGICAL_ADDRESS__AUDIO_SYSTEM = 5;
    public static final int HDMI_CEC_ACTIVE_SOURCE_CHANGED__ACTIVE_SOURCE_LOGICAL_ADDRESS__TUNER_2 = 6;
    public static final int HDMI_CEC_ACTIVE_SOURCE_CHANGED__ACTIVE_SOURCE_LOGICAL_ADDRESS__TUNER_3 = 7;
    public static final int HDMI_CEC_ACTIVE_SOURCE_CHANGED__ACTIVE_SOURCE_LOGICAL_ADDRESS__PLAYBACK_DEVICE_2 = 8;
    public static final int HDMI_CEC_ACTIVE_SOURCE_CHANGED__ACTIVE_SOURCE_LOGICAL_ADDRESS__RECORDING_DEVICE_3 = 9;
    public static final int HDMI_CEC_ACTIVE_SOURCE_CHANGED__ACTIVE_SOURCE_LOGICAL_ADDRESS__TUNER_4 = 10;
    public static final int HDMI_CEC_ACTIVE_SOURCE_CHANGED__ACTIVE_SOURCE_LOGICAL_ADDRESS__PLAYBACK_DEVICE_3 = 11;
    public static final int HDMI_CEC_ACTIVE_SOURCE_CHANGED__ACTIVE_SOURCE_LOGICAL_ADDRESS__RESERVED_1 = 12;
    public static final int HDMI_CEC_ACTIVE_SOURCE_CHANGED__ACTIVE_SOURCE_LOGICAL_ADDRESS__RESERVED_2 = 13;
    public static final int HDMI_CEC_ACTIVE_SOURCE_CHANGED__ACTIVE_SOURCE_LOGICAL_ADDRESS__SPECIFIC_USE = 14;
    public static final int HDMI_CEC_ACTIVE_SOURCE_CHANGED__ACTIVE_SOURCE_LOGICAL_ADDRESS__UNREGISTERED_OR_BROADCAST = 15;

    // Values for HdmiCecActiveSourceChanged.local_relationship
    public static final int HDMI_CEC_ACTIVE_SOURCE_CHANGED__LOCAL_RELATIONSHIP__RELATIONSHIP_TO_ACTIVE_SOURCE_UNKNOWN = 0;
    public static final int HDMI_CEC_ACTIVE_SOURCE_CHANGED__LOCAL_RELATIONSHIP__DIFFERENT_BRANCH = 1;
    public static final int HDMI_CEC_ACTIVE_SOURCE_CHANGED__LOCAL_RELATIONSHIP__ANCESTOR = 2;
    public static final int HDMI_CEC_ACTIVE_SOURCE_CHANGED__LOCAL_RELATIONSHIP__DESCENDANT = 3;
    public static final int HDMI_CEC_ACTIVE_SOURCE_CHANGED__LOCAL_RELATIONSHIP__SIBLING = 4;
    public static final int HDMI_CEC_ACTIVE_SOURCE_CHANGED__LOCAL_RELATIONSHIP__SAME = 5;

    // Values for HdmiCecMessageReported.direction
    public static final int HDMI_CEC_MESSAGE_REPORTED__DIRECTION__MESSAGE_DIRECTION_UNKNOWN = 0;
    public static final int HDMI_CEC_MESSAGE_REPORTED__DIRECTION__MESSAGE_DIRECTION_OTHER = 1;
    public static final int HDMI_CEC_MESSAGE_REPORTED__DIRECTION__OUTGOING = 2;
    public static final int HDMI_CEC_MESSAGE_REPORTED__DIRECTION__INCOMING = 3;
    public static final int HDMI_CEC_MESSAGE_REPORTED__DIRECTION__TO_SELF = 4;

    // Values for HdmiCecMessageReported.initiator_logical_address
    public static final int HDMI_CEC_MESSAGE_REPORTED__INITIATOR_LOGICAL_ADDRESS__LOGICAL_ADDRESS_UNKNOWN = -1;
    public static final int HDMI_CEC_MESSAGE_REPORTED__INITIATOR_LOGICAL_ADDRESS__TV = 0;
    public static final int HDMI_CEC_MESSAGE_REPORTED__INITIATOR_LOGICAL_ADDRESS__RECORDING_DEVICE_1 = 1;
    public static final int HDMI_CEC_MESSAGE_REPORTED__INITIATOR_LOGICAL_ADDRESS__RECORDING_DEVICE_2 = 2;
    public static final int HDMI_CEC_MESSAGE_REPORTED__INITIATOR_LOGICAL_ADDRESS__TUNER_1 = 3;
    public static final int HDMI_CEC_MESSAGE_REPORTED__INITIATOR_LOGICAL_ADDRESS__PLAYBACK_DEVICE_1 = 4;
    public static final int HDMI_CEC_MESSAGE_REPORTED__INITIATOR_LOGICAL_ADDRESS__AUDIO_SYSTEM = 5;
    public static final int HDMI_CEC_MESSAGE_REPORTED__INITIATOR_LOGICAL_ADDRESS__TUNER_2 = 6;
    public static final int HDMI_CEC_MESSAGE_REPORTED__INITIATOR_LOGICAL_ADDRESS__TUNER_3 = 7;
    public static final int HDMI_CEC_MESSAGE_REPORTED__INITIATOR_LOGICAL_ADDRESS__PLAYBACK_DEVICE_2 = 8;
    public static final int HDMI_CEC_MESSAGE_REPORTED__INITIATOR_LOGICAL_ADDRESS__RECORDING_DEVICE_3 = 9;
    public static final int HDMI_CEC_MESSAGE_REPORTED__INITIATOR_LOGICAL_ADDRESS__TUNER_4 = 10;
    public static final int HDMI_CEC_MESSAGE_REPORTED__INITIATOR_LOGICAL_ADDRESS__PLAYBACK_DEVICE_3 = 11;
    public static final int HDMI_CEC_MESSAGE_REPORTED__INITIATOR_LOGICAL_ADDRESS__RESERVED_1 = 12;
    public static final int HDMI_CEC_MESSAGE_REPORTED__INITIATOR_LOGICAL_ADDRESS__RESERVED_2 = 13;
    public static final int HDMI_CEC_MESSAGE_REPORTED__INITIATOR_LOGICAL_ADDRESS__SPECIFIC_USE = 14;
    public static final int HDMI_CEC_MESSAGE_REPORTED__INITIATOR_LOGICAL_ADDRESS__UNREGISTERED_OR_BROADCAST = 15;

    // Values for HdmiCecMessageReported.destination_logical_address
    public static final int HDMI_CEC_MESSAGE_REPORTED__DESTINATION_LOGICAL_ADDRESS__LOGICAL_ADDRESS_UNKNOWN = -1;
    public static final int HDMI_CEC_MESSAGE_REPORTED__DESTINATION_LOGICAL_ADDRESS__TV = 0;
    public static final int HDMI_CEC_MESSAGE_REPORTED__DESTINATION_LOGICAL_ADDRESS__RECORDING_DEVICE_1 = 1;
    public static final int HDMI_CEC_MESSAGE_REPORTED__DESTINATION_LOGICAL_ADDRESS__RECORDING_DEVICE_2 = 2;
    public static final int HDMI_CEC_MESSAGE_REPORTED__DESTINATION_LOGICAL_ADDRESS__TUNER_1 = 3;
    public static final int HDMI_CEC_MESSAGE_REPORTED__DESTINATION_LOGICAL_ADDRESS__PLAYBACK_DEVICE_1 = 4;
    public static final int HDMI_CEC_MESSAGE_REPORTED__DESTINATION_LOGICAL_ADDRESS__AUDIO_SYSTEM = 5;
    public static final int HDMI_CEC_MESSAGE_REPORTED__DESTINATION_LOGICAL_ADDRESS__TUNER_2 = 6;
    public static final int HDMI_CEC_MESSAGE_REPORTED__DESTINATION_LOGICAL_ADDRESS__TUNER_3 = 7;
    public static final int HDMI_CEC_MESSAGE_REPORTED__DESTINATION_LOGICAL_ADDRESS__PLAYBACK_DEVICE_2 = 8;
    public static final int HDMI_CEC_MESSAGE_REPORTED__DESTINATION_LOGICAL_ADDRESS__RECORDING_DEVICE_3 = 9;
    public static final int HDMI_CEC_MESSAGE_REPORTED__DESTINATION_LOGICAL_ADDRESS__TUNER_4 = 10;
    public static final int HDMI_CEC_MESSAGE_REPORTED__DESTINATION_LOGICAL_ADDRESS__PLAYBACK_DEVICE_3 = 11;
    public static final int HDMI_CEC_MESSAGE_REPORTED__DESTINATION_LOGICAL_ADDRESS__RESERVED_1 = 12;
    public static final int HDMI_CEC_MESSAGE_REPORTED__DESTINATION_LOGICAL_ADDRESS__RESERVED_2 = 13;
    public static final int HDMI_CEC_MESSAGE_REPORTED__DESTINATION_LOGICAL_ADDRESS__SPECIFIC_USE = 14;
    public static final int HDMI_CEC_MESSAGE_REPORTED__DESTINATION_LOGICAL_ADDRESS__UNREGISTERED_OR_BROADCAST = 15;

    // Values for HdmiCecMessageReported.send_message_result
    public static final int HDMI_CEC_MESSAGE_REPORTED__SEND_MESSAGE_RESULT__SEND_MESSAGE_RESULT_UNKNOWN = 0;
    public static final int HDMI_CEC_MESSAGE_REPORTED__SEND_MESSAGE_RESULT__SUCCESS = 10;
    public static final int HDMI_CEC_MESSAGE_REPORTED__SEND_MESSAGE_RESULT__NACK = 11;
    public static final int HDMI_CEC_MESSAGE_REPORTED__SEND_MESSAGE_RESULT__BUSY = 12;
    public static final int HDMI_CEC_MESSAGE_REPORTED__SEND_MESSAGE_RESULT__FAIL = 13;

    // Values for HdmiCecMessageReported.user_control_pressed_command
    public static final int HDMI_CEC_MESSAGE_REPORTED__USER_CONTROL_PRESSED_COMMAND__USER_CONTROL_PRESSED_COMMAND_UNKNOWN = 0;
    public static final int HDMI_CEC_MESSAGE_REPORTED__USER_CONTROL_PRESSED_COMMAND__USER_CONTROL_PRESSED_COMMAND_OTHER = 1;
    public static final int HDMI_CEC_MESSAGE_REPORTED__USER_CONTROL_PRESSED_COMMAND__NUMBER = 2;
    public static final int HDMI_CEC_MESSAGE_REPORTED__USER_CONTROL_PRESSED_COMMAND__SELECT = 256;
    public static final int HDMI_CEC_MESSAGE_REPORTED__USER_CONTROL_PRESSED_COMMAND__UP = 257;
    public static final int HDMI_CEC_MESSAGE_REPORTED__USER_CONTROL_PRESSED_COMMAND__DOWN = 258;
    public static final int HDMI_CEC_MESSAGE_REPORTED__USER_CONTROL_PRESSED_COMMAND__LEFT = 259;
    public static final int HDMI_CEC_MESSAGE_REPORTED__USER_CONTROL_PRESSED_COMMAND__RIGHT = 260;
    public static final int HDMI_CEC_MESSAGE_REPORTED__USER_CONTROL_PRESSED_COMMAND__RIGHT_UP = 261;
    public static final int HDMI_CEC_MESSAGE_REPORTED__USER_CONTROL_PRESSED_COMMAND__RIGHT_DOWN = 262;
    public static final int HDMI_CEC_MESSAGE_REPORTED__USER_CONTROL_PRESSED_COMMAND__LEFT_UP = 263;
    public static final int HDMI_CEC_MESSAGE_REPORTED__USER_CONTROL_PRESSED_COMMAND__LEFT_DOWN = 264;
    public static final int HDMI_CEC_MESSAGE_REPORTED__USER_CONTROL_PRESSED_COMMAND__EXIT = 269;
    public static final int HDMI_CEC_MESSAGE_REPORTED__USER_CONTROL_PRESSED_COMMAND__INPUT_SELECT = 308;
    public static final int HDMI_CEC_MESSAGE_REPORTED__USER_CONTROL_PRESSED_COMMAND__POWER = 320;
    public static final int HDMI_CEC_MESSAGE_REPORTED__USER_CONTROL_PRESSED_COMMAND__VOLUME_UP = 321;
    public static final int HDMI_CEC_MESSAGE_REPORTED__USER_CONTROL_PRESSED_COMMAND__VOLUME_DOWN = 322;
    public static final int HDMI_CEC_MESSAGE_REPORTED__USER_CONTROL_PRESSED_COMMAND__VOLUME_MUTE = 323;
    public static final int HDMI_CEC_MESSAGE_REPORTED__USER_CONTROL_PRESSED_COMMAND__POWER_TOGGLE = 363;
    public static final int HDMI_CEC_MESSAGE_REPORTED__USER_CONTROL_PRESSED_COMMAND__POWER_OFF = 364;
    public static final int HDMI_CEC_MESSAGE_REPORTED__USER_CONTROL_PRESSED_COMMAND__POWER_ON = 365;

    // Values for HdmiCecMessageReported.feature_abort_reason
    public static final int HDMI_CEC_MESSAGE_REPORTED__FEATURE_ABORT_REASON__FEATURE_ABORT_REASON_UNKNOWN = 0;
    public static final int HDMI_CEC_MESSAGE_REPORTED__FEATURE_ABORT_REASON__UNRECOGNIZED_OPCODE = 10;
    public static final int HDMI_CEC_MESSAGE_REPORTED__FEATURE_ABORT_REASON__NOT_IN_CORRECT_MODE_TO_RESPOND = 11;
    public static final int HDMI_CEC_MESSAGE_REPORTED__FEATURE_ABORT_REASON__CANNOT_PROVIDE_SOURCE = 12;
    public static final int HDMI_CEC_MESSAGE_REPORTED__FEATURE_ABORT_REASON__INVALID_OPERAND = 13;
    public static final int HDMI_CEC_MESSAGE_REPORTED__FEATURE_ABORT_REASON__REFUSED = 14;
    public static final int HDMI_CEC_MESSAGE_REPORTED__FEATURE_ABORT_REASON__UNABLE_TO_DETERMINE = 15;

    // Values for TifTuneStateChanged.state
    public static final int TIF_TUNE_STATE_CHANGED__STATE__TIF_TUNE_STATE_UNKNOWN = 0;
    public static final int TIF_TUNE_STATE_CHANGED__STATE__CREATED = 1;
    public static final int TIF_TUNE_STATE_CHANGED__STATE__SURFACE_ATTACHED = 2;
    public static final int TIF_TUNE_STATE_CHANGED__STATE__SURFACE_DETACHED = 3;
    public static final int TIF_TUNE_STATE_CHANGED__STATE__RELEASED = 4;
    public static final int TIF_TUNE_STATE_CHANGED__STATE__TUNE_STARTED = 5;
    public static final int TIF_TUNE_STATE_CHANGED__STATE__VIDEO_AVAILABLE = 6;
    public static final int TIF_TUNE_STATE_CHANGED__STATE__VIDEO_UNAVAILABLE_REASON_UNKNOWN = 100;
    public static final int TIF_TUNE_STATE_CHANGED__STATE__VIDEO_UNAVAILABLE_REASON_TUNING = 101;
    public static final int TIF_TUNE_STATE_CHANGED__STATE__VIDEO_UNAVAILABLE_REASON_WEAK_SIGNAL = 102;
    public static final int TIF_TUNE_STATE_CHANGED__STATE__VIDEO_UNAVAILABLE_REASON_BUFFERING = 103;
    public static final int TIF_TUNE_STATE_CHANGED__STATE__VIDEO_UNAVAILABLE_REASON_AUDIO_ONLY = 104;
    public static final int TIF_TUNE_STATE_CHANGED__STATE__VIDEO_UNAVAILABLE_REASON_NOT_CONNECTED = 105;
    public static final int TIF_TUNE_STATE_CHANGED__STATE__VIDEO_UNAVAILABLE_REASON_INSUFFICIENT_RESOURCE = 106;
    public static final int TIF_TUNE_STATE_CHANGED__STATE__VIDEO_UNAVAILABLE_REASON_CAS_INSUFFICIENT_OUTPUT_PROTECTION = 107;
    public static final int TIF_TUNE_STATE_CHANGED__STATE__VIDEO_UNAVAILABLE_REASON_CAS_PVR_RECORDING_NOT_ALLOWED = 108;
    public static final int TIF_TUNE_STATE_CHANGED__STATE__VIDEO_UNAVAILABLE_REASON_CAS_NO_LICENSE = 109;
    public static final int TIF_TUNE_STATE_CHANGED__STATE__VIDEO_UNAVAILABLE_REASON_CAS_LICENSE_EXPIRED = 110;
    public static final int TIF_TUNE_STATE_CHANGED__STATE__VIDEO_UNAVAILABLE_REASON_CAS_NEED_ACTIVATION = 111;
    public static final int TIF_TUNE_STATE_CHANGED__STATE__VIDEO_UNAVAILABLE_REASON_CAS_NEED_PAIRING = 112;
    public static final int TIF_TUNE_STATE_CHANGED__STATE__VIDEO_UNAVAILABLE_REASON_CAS_NO_CARD = 113;
    public static final int TIF_TUNE_STATE_CHANGED__STATE__VIDEO_UNAVAILABLE_REASON_CAS_CARD_MUTE = 114;
    public static final int TIF_TUNE_STATE_CHANGED__STATE__VIDEO_UNAVAILABLE_REASON_CAS_CARD_INVALID = 115;
    public static final int TIF_TUNE_STATE_CHANGED__STATE__VIDEO_UNAVAILABLE_REASON_CAS_BLACKOUT = 116;
    public static final int TIF_TUNE_STATE_CHANGED__STATE__VIDEO_UNAVAILABLE_REASON_CAS_REBOOTING = 117;
    public static final int TIF_TUNE_STATE_CHANGED__STATE__VIDEO_UNAVAILABLE_REASON_CAS_UNKNOWN = 118;

    // Values for TifTuneStateChanged.type
    public static final int TIF_TUNE_STATE_CHANGED__TYPE__TIF_INPUT_TYPE_UNKNOWN = 0;
    public static final int TIF_TUNE_STATE_CHANGED__TYPE__TUNER = 1;
    public static final int TIF_TUNE_STATE_CHANGED__TYPE__OTHER = 1000;
    public static final int TIF_TUNE_STATE_CHANGED__TYPE__COMPOSITE = 1001;
    public static final int TIF_TUNE_STATE_CHANGED__TYPE__SVIDEO = 1002;
    public static final int TIF_TUNE_STATE_CHANGED__TYPE__SCART = 1003;
    public static final int TIF_TUNE_STATE_CHANGED__TYPE__COMPONENT = 1004;
    public static final int TIF_TUNE_STATE_CHANGED__TYPE__VGA = 1005;
    public static final int TIF_TUNE_STATE_CHANGED__TYPE__DVI = 1006;
    public static final int TIF_TUNE_STATE_CHANGED__TYPE__HDMI = 1007;
    public static final int TIF_TUNE_STATE_CHANGED__TYPE__DISPLAY_PORT = 1008;

    // Values for AutoRotateReported.current_orientation
    public static final int AUTO_ROTATE_REPORTED__CURRENT_ORIENTATION__UNKNOWN = 0;
    public static final int AUTO_ROTATE_REPORTED__CURRENT_ORIENTATION__DEPRECATED = 1;
    public static final int AUTO_ROTATE_REPORTED__CURRENT_ORIENTATION__ROTATION_0 = 2;
    public static final int AUTO_ROTATE_REPORTED__CURRENT_ORIENTATION__ROTATION_90 = 3;
    public static final int AUTO_ROTATE_REPORTED__CURRENT_ORIENTATION__ROTATION_180 = 4;
    public static final int AUTO_ROTATE_REPORTED__CURRENT_ORIENTATION__ROTATION_270 = 5;
    public static final int AUTO_ROTATE_REPORTED__CURRENT_ORIENTATION__DISABLED = 6;
    public static final int AUTO_ROTATE_REPORTED__CURRENT_ORIENTATION__UNAVAILABLE = 7;
    public static final int AUTO_ROTATE_REPORTED__CURRENT_ORIENTATION__FAILURE = 8;

    // Values for AutoRotateReported.proposed_orientation
    public static final int AUTO_ROTATE_REPORTED__PROPOSED_ORIENTATION__UNKNOWN = 0;
    public static final int AUTO_ROTATE_REPORTED__PROPOSED_ORIENTATION__DEPRECATED = 1;
    public static final int AUTO_ROTATE_REPORTED__PROPOSED_ORIENTATION__ROTATION_0 = 2;
    public static final int AUTO_ROTATE_REPORTED__PROPOSED_ORIENTATION__ROTATION_90 = 3;
    public static final int AUTO_ROTATE_REPORTED__PROPOSED_ORIENTATION__ROTATION_180 = 4;
    public static final int AUTO_ROTATE_REPORTED__PROPOSED_ORIENTATION__ROTATION_270 = 5;
    public static final int AUTO_ROTATE_REPORTED__PROPOSED_ORIENTATION__DISABLED = 6;
    public static final int AUTO_ROTATE_REPORTED__PROPOSED_ORIENTATION__UNAVAILABLE = 7;
    public static final int AUTO_ROTATE_REPORTED__PROPOSED_ORIENTATION__FAILURE = 8;

    // Values for AutoRotateReported.recommended_orientation
    public static final int AUTO_ROTATE_REPORTED__RECOMMENDED_ORIENTATION__UNKNOWN = 0;
    public static final int AUTO_ROTATE_REPORTED__RECOMMENDED_ORIENTATION__DEPRECATED = 1;
    public static final int AUTO_ROTATE_REPORTED__RECOMMENDED_ORIENTATION__ROTATION_0 = 2;
    public static final int AUTO_ROTATE_REPORTED__RECOMMENDED_ORIENTATION__ROTATION_90 = 3;
    public static final int AUTO_ROTATE_REPORTED__RECOMMENDED_ORIENTATION__ROTATION_180 = 4;
    public static final int AUTO_ROTATE_REPORTED__RECOMMENDED_ORIENTATION__ROTATION_270 = 5;
    public static final int AUTO_ROTATE_REPORTED__RECOMMENDED_ORIENTATION__DISABLED = 6;
    public static final int AUTO_ROTATE_REPORTED__RECOMMENDED_ORIENTATION__UNAVAILABLE = 7;
    public static final int AUTO_ROTATE_REPORTED__RECOMMENDED_ORIENTATION__FAILURE = 8;

    // Values for DeviceRotated.proposed_orientation
    public static final int DEVICE_ROTATED__PROPOSED_ORIENTATION__UNKNOWN = 0;
    public static final int DEVICE_ROTATED__PROPOSED_ORIENTATION__ROTATION_0 = 1;
    public static final int DEVICE_ROTATED__PROPOSED_ORIENTATION__ROTATION_90 = 2;
    public static final int DEVICE_ROTATED__PROPOSED_ORIENTATION__ROTATION_180 = 3;
    public static final int DEVICE_ROTATED__PROPOSED_ORIENTATION__ROTATION_270 = 4;

    // Values for DeviceRotated.rotation_event_type
    public static final int DEVICE_ROTATED__ROTATION_EVENT_TYPE__UNKNOWN = 0;
    public static final int DEVICE_ROTATED__ROTATION_EVENT_TYPE__PREINDICATION = 1;
    public static final int DEVICE_ROTATED__ROTATION_EVENT_TYPE__ACTUAL_EVENT = 2;
    public static final int DEVICE_ROTATED__ROTATION_EVENT_TYPE__DATA_READY = 3;

    // Values for FaceDownReported.face_down_response
    public static final int FACE_DOWN_REPORTED__FACE_DOWN_RESPONSE__UNKNOWN = 1;
    public static final int FACE_DOWN_REPORTED__FACE_DOWN_RESPONSE__UNFLIP = 2;
    public static final int FACE_DOWN_REPORTED__FACE_DOWN_RESPONSE__USER_INTERACTION = 3;
    public static final int FACE_DOWN_REPORTED__FACE_DOWN_RESPONSE__SCREEN_OFF = 4;

    // Values for RebootEscrowPreparationReported.result
    public static final int REBOOT_ESCROW_PREPARATION_REPORTED__RESULT__ROR_NEED_PREPARATION = 0;
    public static final int REBOOT_ESCROW_PREPARATION_REPORTED__RESULT__ROR_SKIP_PREPARATION_AND_NOTIFY = 1;
    public static final int REBOOT_ESCROW_PREPARATION_REPORTED__RESULT__ROR_SKIP_PREPARATION_NOT_NOTIFY = 2;

    // Values for MagnificationUsageReported.activated_mode
    public static final int MAGNIFICATION_USAGE_REPORTED__ACTIVATED_MODE__MAGNIFICATION_UNKNOWN_MODE = 0;
    public static final int MAGNIFICATION_USAGE_REPORTED__ACTIVATED_MODE__MAGNIFICATION_FULL_SCREEN = 1;
    public static final int MAGNIFICATION_USAGE_REPORTED__ACTIVATED_MODE__MAGNIFICATION_WINDOW = 2;
    public static final int MAGNIFICATION_USAGE_REPORTED__ACTIVATED_MODE__MAGNIFICATION_ALL = 3;

    // Values for MagnificationModeWithImeOnReported.activated_mode
    public static final int MAGNIFICATION_MODE_WITH_IME_ON_REPORTED__ACTIVATED_MODE__MAGNIFICATION_UNKNOWN_MODE = 0;
    public static final int MAGNIFICATION_MODE_WITH_IME_ON_REPORTED__ACTIVATED_MODE__MAGNIFICATION_FULL_SCREEN = 1;
    public static final int MAGNIFICATION_MODE_WITH_IME_ON_REPORTED__ACTIVATED_MODE__MAGNIFICATION_WINDOW = 2;
    public static final int MAGNIFICATION_MODE_WITH_IME_ON_REPORTED__ACTIVATED_MODE__MAGNIFICATION_ALL = 3;

    // Values for AuthDeprecatedAPIUsed.deprecated_api
    public static final int AUTH_DEPRECATED_APIUSED__DEPRECATED_API__API_UNKNOWN = 0;
    public static final int AUTH_DEPRECATED_APIUSED__DEPRECATED_API__API_FINGERPRINT_MANAGER_AUTHENTICATE = 1;
    public static final int AUTH_DEPRECATED_APIUSED__DEPRECATED_API__API_FINGERPRINT_MANAGER_HAS_ENROLLED_FINGERPRINTS = 2;
    public static final int AUTH_DEPRECATED_APIUSED__DEPRECATED_API__API_FINGERPRINT_MANAGER_IS_HARDWARE_DETECTED = 3;
    public static final int AUTH_DEPRECATED_APIUSED__DEPRECATED_API__API_BIOMETRIC_MANAGER_CAN_AUTHENTICATE = 4;

    // Values for LocationTimeZoneProviderStateChanged.state
    public static final int LOCATION_TIME_ZONE_PROVIDER_STATE_CHANGED__STATE__UNKNOWN = 0;
    public static final int LOCATION_TIME_ZONE_PROVIDER_STATE_CHANGED__STATE__INITIALIZING = 1;
    public static final int LOCATION_TIME_ZONE_PROVIDER_STATE_CHANGED__STATE__CERTAIN = 2;
    public static final int LOCATION_TIME_ZONE_PROVIDER_STATE_CHANGED__STATE__UNCERTAIN = 3;
    public static final int LOCATION_TIME_ZONE_PROVIDER_STATE_CHANGED__STATE__STOPPED = 4;
    public static final int LOCATION_TIME_ZONE_PROVIDER_STATE_CHANGED__STATE__PERM_FAILED = 5;
    public static final int LOCATION_TIME_ZONE_PROVIDER_STATE_CHANGED__STATE__DESTROYED = 6;

    // Values for FdtrackEventOccurred.event
    public static final int FDTRACK_EVENT_OCCURRED__EVENT__DISABLED = 1;
    public static final int FDTRACK_EVENT_OCCURRED__EVENT__ENABLED = 2;
    public static final int FDTRACK_EVENT_OCCURRED__EVENT__ABORTING = 3;

    // Values for TimeoutAutoExtendedReported.outcome
    public static final int TIMEOUT_AUTO_EXTENDED_REPORTED__OUTCOME__UNKNOWN = 0;
    public static final int TIMEOUT_AUTO_EXTENDED_REPORTED__OUTCOME__POWER_BUTTON = 1;
    public static final int TIMEOUT_AUTO_EXTENDED_REPORTED__OUTCOME__TIMEOUT = 2;

    // Values for AlarmScheduled.exact_alarm_allowed_reason
    public static final int ALARM_SCHEDULED__EXACT_ALARM_ALLOWED_REASON__NOT_APPLICABLE = 0;
    public static final int ALARM_SCHEDULED__EXACT_ALARM_ALLOWED_REASON__PERMISSION = 1;
    public static final int ALARM_SCHEDULED__EXACT_ALARM_ALLOWED_REASON__ALLOW_LIST = 2;
    public static final int ALARM_SCHEDULED__EXACT_ALARM_ALLOWED_REASON__CHANGE_DISABLED = 3;
    public static final int ALARM_SCHEDULED__EXACT_ALARM_ALLOWED_REASON__POLICY_PERMISSION = 4;
    public static final int ALARM_SCHEDULED__EXACT_ALARM_ALLOWED_REASON__LISTENER = 5;
    public static final int ALARM_SCHEDULED__EXACT_ALARM_ALLOWED_REASON__PRIORITIZED = 6;

    // Values for AlarmScheduled.calling_process_state
    public static final int ALARM_SCHEDULED__CALLING_PROCESS_STATE__PROCESS_STATE_UNKNOWN_TO_PROTO = 998;
    public static final int ALARM_SCHEDULED__CALLING_PROCESS_STATE__PROCESS_STATE_UNKNOWN = 999;
    public static final int ALARM_SCHEDULED__CALLING_PROCESS_STATE__PROCESS_STATE_PERSISTENT = 1000;
    public static final int ALARM_SCHEDULED__CALLING_PROCESS_STATE__PROCESS_STATE_PERSISTENT_UI = 1001;
    public static final int ALARM_SCHEDULED__CALLING_PROCESS_STATE__PROCESS_STATE_TOP = 1002;
    public static final int ALARM_SCHEDULED__CALLING_PROCESS_STATE__PROCESS_STATE_FOREGROUND_SERVICE = 1003;
    public static final int ALARM_SCHEDULED__CALLING_PROCESS_STATE__PROCESS_STATE_BOUND_FOREGROUND_SERVICE = 1004;
    public static final int ALARM_SCHEDULED__CALLING_PROCESS_STATE__PROCESS_STATE_IMPORTANT_FOREGROUND = 1005;
    public static final int ALARM_SCHEDULED__CALLING_PROCESS_STATE__PROCESS_STATE_IMPORTANT_BACKGROUND = 1006;
    public static final int ALARM_SCHEDULED__CALLING_PROCESS_STATE__PROCESS_STATE_TRANSIENT_BACKGROUND = 1007;
    public static final int ALARM_SCHEDULED__CALLING_PROCESS_STATE__PROCESS_STATE_BACKUP = 1008;
    public static final int ALARM_SCHEDULED__CALLING_PROCESS_STATE__PROCESS_STATE_SERVICE = 1009;
    public static final int ALARM_SCHEDULED__CALLING_PROCESS_STATE__PROCESS_STATE_RECEIVER = 1010;
    public static final int ALARM_SCHEDULED__CALLING_PROCESS_STATE__PROCESS_STATE_TOP_SLEEPING = 1011;
    public static final int ALARM_SCHEDULED__CALLING_PROCESS_STATE__PROCESS_STATE_HEAVY_WEIGHT = 1012;
    public static final int ALARM_SCHEDULED__CALLING_PROCESS_STATE__PROCESS_STATE_HOME = 1013;
    public static final int ALARM_SCHEDULED__CALLING_PROCESS_STATE__PROCESS_STATE_LAST_ACTIVITY = 1014;
    public static final int ALARM_SCHEDULED__CALLING_PROCESS_STATE__PROCESS_STATE_CACHED_ACTIVITY = 1015;
    public static final int ALARM_SCHEDULED__CALLING_PROCESS_STATE__PROCESS_STATE_CACHED_ACTIVITY_CLIENT = 1016;
    public static final int ALARM_SCHEDULED__CALLING_PROCESS_STATE__PROCESS_STATE_CACHED_RECENT = 1017;
    public static final int ALARM_SCHEDULED__CALLING_PROCESS_STATE__PROCESS_STATE_CACHED_EMPTY = 1018;
    public static final int ALARM_SCHEDULED__CALLING_PROCESS_STATE__PROCESS_STATE_NONEXISTENT = 1019;
    public static final int ALARM_SCHEDULED__CALLING_PROCESS_STATE__PROCESS_STATE_BOUND_TOP = 1020;

    // Values for AppProcessDied.reason
    public static final int APP_PROCESS_DIED__REASON__REASON_UNKNOWN = 0;
    public static final int APP_PROCESS_DIED__REASON__REASON_EXIT_SELF = 1;
    public static final int APP_PROCESS_DIED__REASON__REASON_SIGNALED = 2;
    public static final int APP_PROCESS_DIED__REASON__REASON_LOW_MEMORY = 3;
    public static final int APP_PROCESS_DIED__REASON__REASON_CRASH = 4;
    public static final int APP_PROCESS_DIED__REASON__REASON_CRASH_NATIVE = 5;
    public static final int APP_PROCESS_DIED__REASON__REASON_ANR = 6;
    public static final int APP_PROCESS_DIED__REASON__REASON_INITIALIZATION_FAILURE = 7;
    public static final int APP_PROCESS_DIED__REASON__REASON_PERMISSION_CHANGE = 8;
    public static final int APP_PROCESS_DIED__REASON__REASON_EXCESSIVE_RESOURCE_USAGE = 9;
    public static final int APP_PROCESS_DIED__REASON__REASON_USER_REQUESTED = 10;
    public static final int APP_PROCESS_DIED__REASON__REASON_USER_STOPPED = 11;
    public static final int APP_PROCESS_DIED__REASON__REASON_DEPENDENCY_DIED = 12;
    public static final int APP_PROCESS_DIED__REASON__REASON_OTHER = 13;
    public static final int APP_PROCESS_DIED__REASON__REASON_FREEZER = 14;
    public static final int APP_PROCESS_DIED__REASON__REASON_PACKAGE_STATE_CHANGE = 15;
    public static final int APP_PROCESS_DIED__REASON__REASON_PACKAGE_UPDATED = 16;

    // Values for AppProcessDied.sub_reason
    public static final int APP_PROCESS_DIED__SUB_REASON__SUBREASON_UNKNOWN = 0;
    public static final int APP_PROCESS_DIED__SUB_REASON__SUBREASON_WAIT_FOR_DEBUGGER = 1;
    public static final int APP_PROCESS_DIED__SUB_REASON__SUBREASON_TOO_MANY_CACHED = 2;
    public static final int APP_PROCESS_DIED__SUB_REASON__SUBREASON_TOO_MANY_EMPTY = 3;
    public static final int APP_PROCESS_DIED__SUB_REASON__SUBREASON_TRIM_EMPTY = 4;
    public static final int APP_PROCESS_DIED__SUB_REASON__SUBREASON_LARGE_CACHED = 5;
    public static final int APP_PROCESS_DIED__SUB_REASON__SUBREASON_MEMORY_PRESSURE = 6;
    public static final int APP_PROCESS_DIED__SUB_REASON__SUBREASON_EXCESSIVE_CPU = 7;
    public static final int APP_PROCESS_DIED__SUB_REASON__SUBREASON_SYSTEM_UPDATE_DONE = 8;
    public static final int APP_PROCESS_DIED__SUB_REASON__SUBREASON_KILL_ALL_FG = 9;
    public static final int APP_PROCESS_DIED__SUB_REASON__SUBREASON_KILL_ALL_BG_EXCEPT = 10;
    public static final int APP_PROCESS_DIED__SUB_REASON__SUBREASON_KILL_UID = 11;
    public static final int APP_PROCESS_DIED__SUB_REASON__SUBREASON_KILL_PID = 12;
    public static final int APP_PROCESS_DIED__SUB_REASON__SUBREASON_INVALID_START = 13;
    public static final int APP_PROCESS_DIED__SUB_REASON__SUBREASON_INVALID_STATE = 14;
    public static final int APP_PROCESS_DIED__SUB_REASON__SUBREASON_IMPERCEPTIBLE = 15;
    public static final int APP_PROCESS_DIED__SUB_REASON__SUBREASON_REMOVE_LRU = 16;
    public static final int APP_PROCESS_DIED__SUB_REASON__SUBREASON_ISOLATED_NOT_NEEDED = 17;
    public static final int APP_PROCESS_DIED__SUB_REASON__SUBREASON_CACHED_IDLE_FORCED_APP_STANDBY = 18;
    public static final int APP_PROCESS_DIED__SUB_REASON__SUBREASON_FREEZER_BINDER_IOCTL = 19;
    public static final int APP_PROCESS_DIED__SUB_REASON__SUBREASON_FREEZER_BINDER_TRANSACTION = 20;
    public static final int APP_PROCESS_DIED__SUB_REASON__SUBREASON_FORCE_STOP = 21;
    public static final int APP_PROCESS_DIED__SUB_REASON__SUBREASON_REMOVE_TASK = 22;
    public static final int APP_PROCESS_DIED__SUB_REASON__SUBREASON_STOP_APP = 23;
    public static final int APP_PROCESS_DIED__SUB_REASON__SUBREASON_KILL_BACKGROUND = 24;
    public static final int APP_PROCESS_DIED__SUB_REASON__SUBREASON_PACKAGE_UPDATE = 25;
    public static final int APP_PROCESS_DIED__SUB_REASON__SUBREASON_UNDELIVERED_BROADCAST = 26;
    public static final int APP_PROCESS_DIED__SUB_REASON__SUBREASON_SDK_SANDBOX_DIED = 27;
    public static final int APP_PROCESS_DIED__SUB_REASON__SUBREASON_SDK_SANDBOX_NOT_NEEDED = 28;

    // Values for AppProcessDied.importance
    public static final int APP_PROCESS_DIED__IMPORTANCE__IMPORTANCE_FOREGROUND = 100;
    public static final int APP_PROCESS_DIED__IMPORTANCE__IMPORTANCE_FOREGROUND_SERVICE = 125;
    public static final int APP_PROCESS_DIED__IMPORTANCE__IMPORTANCE_PERCEPTIBLE_PRE_26 = 130;
    public static final int APP_PROCESS_DIED__IMPORTANCE__IMPORTANCE_TOP_SLEEPING_PRE_28 = 150;
    public static final int APP_PROCESS_DIED__IMPORTANCE__IMPORTANCE_CANT_SAVE_STATE_PRE_26 = 170;
    public static final int APP_PROCESS_DIED__IMPORTANCE__IMPORTANCE_VISIBLE = 200;
    public static final int APP_PROCESS_DIED__IMPORTANCE__IMPORTANCE_PERCEPTIBLE = 230;
    public static final int APP_PROCESS_DIED__IMPORTANCE__IMPORTANCE_SERVICE = 300;
    public static final int APP_PROCESS_DIED__IMPORTANCE__IMPORTANCE_TOP_SLEEPING = 325;
    public static final int APP_PROCESS_DIED__IMPORTANCE__IMPORTANCE_CANT_SAVE_STATE = 350;
    public static final int APP_PROCESS_DIED__IMPORTANCE__IMPORTANCE_BACKGROUND = 400;
    public static final int APP_PROCESS_DIED__IMPORTANCE__IMPORTANCE_EMPTY = 500;
    public static final int APP_PROCESS_DIED__IMPORTANCE__IMPORTANCE_GONE = 1000;

    // Values for PrivacySensorToggleInteraction.sensor
    public static final int PRIVACY_SENSOR_TOGGLE_INTERACTION__SENSOR__SENSOR_UNKNOWN = 0;
    public static final int PRIVACY_SENSOR_TOGGLE_INTERACTION__SENSOR__MICROPHONE = 1;
    public static final int PRIVACY_SENSOR_TOGGLE_INTERACTION__SENSOR__CAMERA = 2;

    // Values for PrivacySensorToggleInteraction.action
    public static final int PRIVACY_SENSOR_TOGGLE_INTERACTION__ACTION__ACTION_UNKNOWN = 0;
    public static final int PRIVACY_SENSOR_TOGGLE_INTERACTION__ACTION__TOGGLE_ON = 1;
    public static final int PRIVACY_SENSOR_TOGGLE_INTERACTION__ACTION__TOGGLE_OFF = 2;

    // Values for PrivacySensorToggleInteraction.source
    public static final int PRIVACY_SENSOR_TOGGLE_INTERACTION__SOURCE__SOURCE_UNKNOWN = 0;
    public static final int PRIVACY_SENSOR_TOGGLE_INTERACTION__SOURCE__DIALOG = 1;
    public static final int PRIVACY_SENSOR_TOGGLE_INTERACTION__SOURCE__SETTINGS = 2;
    public static final int PRIVACY_SENSOR_TOGGLE_INTERACTION__SOURCE__QS_TILE = 3;

    // Values for PrivacyToggleDialogInteraction.action
    public static final int PRIVACY_TOGGLE_DIALOG_INTERACTION__ACTION__ACTION_UNKNOWN = 0;
    public static final int PRIVACY_TOGGLE_DIALOG_INTERACTION__ACTION__ENABLE = 1;
    public static final int PRIVACY_TOGGLE_DIALOG_INTERACTION__ACTION__CANCEL = 2;

    // Values for NonA11yToolServiceWarningReported.status
    public static final int NON_A11Y_TOOL_SERVICE_WARNING_REPORTED__STATUS__WARNING_UNKNOWN = 0;
    public static final int NON_A11Y_TOOL_SERVICE_WARNING_REPORTED__STATUS__WARNING_SHOWN = 1;
    public static final int NON_A11Y_TOOL_SERVICE_WARNING_REPORTED__STATUS__WARNING_CLICKED = 2;
    public static final int NON_A11Y_TOOL_SERVICE_WARNING_REPORTED__STATUS__WARNING_SERVICE_DISABLED = 3;

    // Values for AppCompatStateChanged.state
    public static final int APP_COMPAT_STATE_CHANGED__STATE__UNKNOWN = 0;
    public static final int APP_COMPAT_STATE_CHANGED__STATE__NOT_VISIBLE = 1;
    public static final int APP_COMPAT_STATE_CHANGED__STATE__NOT_LETTERBOXED = 2;
    public static final int APP_COMPAT_STATE_CHANGED__STATE__LETTERBOXED_FOR_SIZE_COMPAT_MODE = 3;
    public static final int APP_COMPAT_STATE_CHANGED__STATE__LETTERBOXED_FOR_FIXED_ORIENTATION = 4;
    public static final int APP_COMPAT_STATE_CHANGED__STATE__LETTERBOXED_FOR_ASPECT_RATIO = 5;

    // Values for AppCompatStateChanged.letterbox_position
    public static final int APP_COMPAT_STATE_CHANGED__LETTERBOX_POSITION__UNKNOWN_POSITION = 0;
    public static final int APP_COMPAT_STATE_CHANGED__LETTERBOX_POSITION__NOT_LETTERBOXED_POSITION = 1;
    public static final int APP_COMPAT_STATE_CHANGED__LETTERBOX_POSITION__CENTER = 2;
    public static final int APP_COMPAT_STATE_CHANGED__LETTERBOX_POSITION__LEFT = 3;
    public static final int APP_COMPAT_STATE_CHANGED__LETTERBOX_POSITION__RIGHT = 4;
    public static final int APP_COMPAT_STATE_CHANGED__LETTERBOX_POSITION__TOP = 5;
    public static final int APP_COMPAT_STATE_CHANGED__LETTERBOX_POSITION__BOTTOM = 6;

    // Values for SizeCompatRestartButtonEventReported.event
    public static final int SIZE_COMPAT_RESTART_BUTTON_EVENT_REPORTED__EVENT__UNKNOWN = 0;
    public static final int SIZE_COMPAT_RESTART_BUTTON_EVENT_REPORTED__EVENT__APPEARED = 1;
    public static final int SIZE_COMPAT_RESTART_BUTTON_EVENT_REPORTED__EVENT__CLICKED = 2;

    // Values for SplitscreenUIChanged.action
    public static final int SPLITSCREEN_UICHANGED__ACTION__UNKNOWN_ACTION = 0;
    public static final int SPLITSCREEN_UICHANGED__ACTION__ENTER = 1;
    public static final int SPLITSCREEN_UICHANGED__ACTION__EXIT = 2;
    public static final int SPLITSCREEN_UICHANGED__ACTION__APP_CHANGE = 3;
    public static final int SPLITSCREEN_UICHANGED__ACTION__RESIZE = 4;
    public static final int SPLITSCREEN_UICHANGED__ACTION__SWAP = 5;

    // Values for SplitscreenUIChanged.enter_reason
    public static final int SPLITSCREEN_UICHANGED__ENTER_REASON__UNKNOWN_ENTER = 0;
    public static final int SPLITSCREEN_UICHANGED__ENTER_REASON__OVERVIEW = 1;
    public static final int SPLITSCREEN_UICHANGED__ENTER_REASON__DRAG_LEFT = 2;
    public static final int SPLITSCREEN_UICHANGED__ENTER_REASON__DRAG_TOP = 3;
    public static final int SPLITSCREEN_UICHANGED__ENTER_REASON__DRAG_RIGHT = 4;
    public static final int SPLITSCREEN_UICHANGED__ENTER_REASON__DRAG_BOTTOM = 5;
    public static final int SPLITSCREEN_UICHANGED__ENTER_REASON__LAUNCHER = 6;
    public static final int SPLITSCREEN_UICHANGED__ENTER_REASON__MULTI_INSTANCE = 7;
    public static final int SPLITSCREEN_UICHANGED__ENTER_REASON__NOTIFICATIONS = 8;

    // Values for SplitscreenUIChanged.exit_reason
    public static final int SPLITSCREEN_UICHANGED__EXIT_REASON__UNKNOWN_EXIT = 0;
    public static final int SPLITSCREEN_UICHANGED__EXIT_REASON__DRAG_DIVIDER = 1;
    public static final int SPLITSCREEN_UICHANGED__EXIT_REASON__RETURN_HOME = 2;
    public static final int SPLITSCREEN_UICHANGED__EXIT_REASON__SCREEN_LOCKED = 3;
    public static final int SPLITSCREEN_UICHANGED__EXIT_REASON__SCREEN_LOCKED_SHOW_ON_TOP = 4;
    public static final int SPLITSCREEN_UICHANGED__EXIT_REASON__DEVICE_FOLDED = 5;
    public static final int SPLITSCREEN_UICHANGED__EXIT_REASON__ROOT_TASK_VANISHED = 6;
    public static final int SPLITSCREEN_UICHANGED__EXIT_REASON__APP_FINISHED = 7;
    public static final int SPLITSCREEN_UICHANGED__EXIT_REASON__APP_DOES_NOT_SUPPORT_MULTIWINDOW = 8;
    public static final int SPLITSCREEN_UICHANGED__EXIT_REASON__CHILD_TASK_ENTER_PIP = 9;
    public static final int SPLITSCREEN_UICHANGED__EXIT_REASON__RECREATE_SPLIT = 10;
    public static final int SPLITSCREEN_UICHANGED__EXIT_REASON__FULLSCREEN_SHORTCUT = 11;

    // Values for SplitscreenUIChanged.main_stage_position
    public static final int SPLITSCREEN_UICHANGED__MAIN_STAGE_POSITION__UNKNOWN_POSITION = 0;
    public static final int SPLITSCREEN_UICHANGED__MAIN_STAGE_POSITION__LEFT = 1;
    public static final int SPLITSCREEN_UICHANGED__MAIN_STAGE_POSITION__RIGHT = 2;
    public static final int SPLITSCREEN_UICHANGED__MAIN_STAGE_POSITION__TOP = 3;
    public static final int SPLITSCREEN_UICHANGED__MAIN_STAGE_POSITION__BOTTOM = 4;

    // Values for SplitscreenUIChanged.side_stage_position
    public static final int SPLITSCREEN_UICHANGED__SIDE_STAGE_POSITION__UNKNOWN_POSITION = 0;
    public static final int SPLITSCREEN_UICHANGED__SIDE_STAGE_POSITION__LEFT = 1;
    public static final int SPLITSCREEN_UICHANGED__SIDE_STAGE_POSITION__RIGHT = 2;
    public static final int SPLITSCREEN_UICHANGED__SIDE_STAGE_POSITION__TOP = 3;
    public static final int SPLITSCREEN_UICHANGED__SIDE_STAGE_POSITION__BOTTOM = 4;

    // Values for ClipboardCleared.source
    public static final int CLIPBOARD_CLEARED__SOURCE__SOURCE_UNKNOWN = 0;
    public static final int CLIPBOARD_CLEARED__SOURCE__AUTO_CLEAR = 1;

    // Values for CameraCompatControlEventReported.event
    public static final int CAMERA_COMPAT_CONTROL_EVENT_REPORTED__EVENT__UNKNOWN = 0;
    public static final int CAMERA_COMPAT_CONTROL_EVENT_REPORTED__EVENT__APPEARED_APPLY_TREATMENT = 1;
    public static final int CAMERA_COMPAT_CONTROL_EVENT_REPORTED__EVENT__APPEARED_REVERT_TREATMENT = 2;
    public static final int CAMERA_COMPAT_CONTROL_EVENT_REPORTED__EVENT__CLICKED_APPLY_TREATMENT = 3;
    public static final int CAMERA_COMPAT_CONTROL_EVENT_REPORTED__EVENT__CLICKED_REVERT_TREATMENT = 4;
    public static final int CAMERA_COMPAT_CONTROL_EVENT_REPORTED__EVENT__CLICKED_DISMISS = 5;

    // Values for ApplicationLocalesChanged.status
    public static final int APPLICATION_LOCALES_CHANGED__STATUS__STATUS_UNSPECIFIED = 0;
    public static final int APPLICATION_LOCALES_CHANGED__STATUS__CONFIG_COMMITTED = 1;
    public static final int APPLICATION_LOCALES_CHANGED__STATUS__CONFIG_UNCOMMITTED = 2;
    public static final int APPLICATION_LOCALES_CHANGED__STATUS__FAILURE_INVALID_TARGET_PACKAGE = 3;
    public static final int APPLICATION_LOCALES_CHANGED__STATUS__FAILURE_PERMISSION_ABSENT = 4;

    // Values for ApplicationLocalesChanged.caller
    public static final int APPLICATION_LOCALES_CHANGED__CALLER__CALLER_UNKNOWN = 0;
    public static final int APPLICATION_LOCALES_CHANGED__CALLER__CALLER_DELEGATE = 1;
    public static final int APPLICATION_LOCALES_CHANGED__CALLER__CALLER_APPS = 2;
    public static final int APPLICATION_LOCALES_CHANGED__CALLER__CALLER_BACKUP_RESTORE = 3;
    public static final int APPLICATION_LOCALES_CHANGED__CALLER__CALLER_APP_UPDATE_LOCALES_CHANGE = 4;
    public static final int APPLICATION_LOCALES_CHANGED__CALLER__CALLER_DYNAMIC_LOCALES_CHANGE = 5;

    // Values for FoldStateDurationReported.start_state
    public static final int FOLD_STATE_DURATION_REPORTED__START_STATE__UNKNOWN = 0;
    public static final int FOLD_STATE_DURATION_REPORTED__START_STATE__OPEN = 1;
    public static final int FOLD_STATE_DURATION_REPORTED__START_STATE__CLOSED = 2;
    public static final int FOLD_STATE_DURATION_REPORTED__START_STATE__HALF_OPEN = 3;

    // Values for FoldStateDurationReported.end_state
    public static final int FOLD_STATE_DURATION_REPORTED__END_STATE__UNKNOWN = 0;
    public static final int FOLD_STATE_DURATION_REPORTED__END_STATE__OPEN = 1;
    public static final int FOLD_STATE_DURATION_REPORTED__END_STATE__CLOSED = 2;
    public static final int FOLD_STATE_DURATION_REPORTED__END_STATE__HALF_OPEN = 3;

    // Values for LocationTimeZoneProviderControllerStateChanged.state
    public static final int LOCATION_TIME_ZONE_PROVIDER_CONTROLLER_STATE_CHANGED__STATE__UNKNOWN = 0;
    public static final int LOCATION_TIME_ZONE_PROVIDER_CONTROLLER_STATE_CHANGED__STATE__PROVIDERS_INITIALIZING = 1;
    public static final int LOCATION_TIME_ZONE_PROVIDER_CONTROLLER_STATE_CHANGED__STATE__STOPPED = 2;
    public static final int LOCATION_TIME_ZONE_PROVIDER_CONTROLLER_STATE_CHANGED__STATE__INITIALIZING = 3;
    public static final int LOCATION_TIME_ZONE_PROVIDER_CONTROLLER_STATE_CHANGED__STATE__CERTAIN = 4;
    public static final int LOCATION_TIME_ZONE_PROVIDER_CONTROLLER_STATE_CHANGED__STATE__UNCERTAIN = 5;
    public static final int LOCATION_TIME_ZONE_PROVIDER_CONTROLLER_STATE_CHANGED__STATE__DESTROYED = 6;
    public static final int LOCATION_TIME_ZONE_PROVIDER_CONTROLLER_STATE_CHANGED__STATE__FAILED = 7;

    // Values for DisplayHbmStateChanged.state
    public static final int DISPLAY_HBM_STATE_CHANGED__STATE__HBM_UNKNOWN = 0;
    public static final int DISPLAY_HBM_STATE_CHANGED__STATE__HBM_OFF = 1;
    public static final int DISPLAY_HBM_STATE_CHANGED__STATE__HBM_ON_HDR = 2;
    public static final int DISPLAY_HBM_STATE_CHANGED__STATE__HBM_ON_SUNLIGHT = 3;

    // Values for DisplayHbmStateChanged.reason
    public static final int DISPLAY_HBM_STATE_CHANGED__REASON__HBM_TRANSITION_REASON_UNKNOWN = 0;
    public static final int DISPLAY_HBM_STATE_CHANGED__REASON__HBM_SV_OFF_LUX_DROP = 1;
    public static final int DISPLAY_HBM_STATE_CHANGED__REASON__HBM_SV_OFF_TIME_LIMIT = 2;
    public static final int DISPLAY_HBM_STATE_CHANGED__REASON__HBM_SV_OFF_THERMAL_LIMIT = 3;
    public static final int DISPLAY_HBM_STATE_CHANGED__REASON__HBM_SV_OFF_HDR_PLAYING = 4;
    public static final int DISPLAY_HBM_STATE_CHANGED__REASON__HBM_SV_OFF_BATTERY_SAVE_ON = 5;
    public static final int DISPLAY_HBM_STATE_CHANGED__REASON__HBM_SV_OFF_DISPLAY_OFF = 6;
    public static final int DISPLAY_HBM_STATE_CHANGED__REASON__HBM_SV_OFF_AUTOBRIGHTNESS_OFF = 7;
    public static final int DISPLAY_HBM_STATE_CHANGED__REASON__HBM_HDR_OFF_THERMAL_LIMIT = 8;
    public static final int DISPLAY_HBM_STATE_CHANGED__REASON__HBM_SV_OFF_LOW_REQUESTED_BRIGHTNESS = 9;

    // Values for ApexInfoGathered.algo_type
    public static final int APEX_INFO_GATHERED__ALGO_TYPE__UNKNOWN = 0;
    public static final int APEX_INFO_GATHERED__ALGO_TYPE__CHUNKED_SHA256 = 1;
    public static final int APEX_INFO_GATHERED__ALGO_TYPE__CHUNKED_SHA512 = 2;
    public static final int APEX_INFO_GATHERED__ALGO_TYPE__VERITY_CHUNKED_SHA256 = 3;
    public static final int APEX_INFO_GATHERED__ALGO_TYPE__SHA256 = 4;

    // Values for TracingServiceReportEvent.event
    public static final int TRACING_SERVICE_REPORT_EVENT__EVENT__TRACING_SERVICE_REPORT_UNDEFINED = 0;
    public static final int TRACING_SERVICE_REPORT_EVENT__EVENT__TRACING_SERVICE_REPORT_BEGIN = 1;
    public static final int TRACING_SERVICE_REPORT_EVENT__EVENT__TRACING_SERVICE_REPORT_SVC_HANDOFF = 2;
    public static final int TRACING_SERVICE_REPORT_EVENT__EVENT__TRACING_SERVICE_REPORT_BIND_PERM_INCORRECT = 3;
    public static final int TRACING_SERVICE_REPORT_EVENT__EVENT__TRACING_SERVICE_REPORT_SVC_PERM_MISSING = 4;
    public static final int TRACING_SERVICE_REPORT_EVENT__EVENT__TRACING_SERVICE_REPORT_SVC_COMM_ERROR = 5;

    // Values for DropboxEntryDropped.drop_reason
    public static final int DROPBOX_ENTRY_DROPPED__DROP_REASON__UNKNOWN = 0;
    public static final int DROPBOX_ENTRY_DROPPED__DROP_REASON__CLEARING_DATA = 3;
    public static final int DROPBOX_ENTRY_DROPPED__DROP_REASON__AGED = 4;
    public static final int DROPBOX_ENTRY_DROPPED__DROP_REASON__WRITE_FAILURE = 5;
    public static final int DROPBOX_ENTRY_DROPPED__DROP_REASON__ENTRY_TOO_LARGE = 6;

    // Values for GameStateChanged.state
    public static final int GAME_STATE_CHANGED__STATE__MODE_UNKNOWN = 0;
    public static final int GAME_STATE_CHANGED__STATE__MODE_NONE = 1;
    public static final int GAME_STATE_CHANGED__STATE__MODE_GAMEPLAY_INTERRUPTIBLE = 2;
    public static final int GAME_STATE_CHANGED__STATE__MODE_GAMEPLAY_UNINTERRUPTIBLE = 3;
    public static final int GAME_STATE_CHANGED__STATE__MODE_CONTENT = 4;

    // Values for HotwordDetectorCreateRequested.detector_type
    public static final int HOTWORD_DETECTOR_CREATE_REQUESTED__DETECTOR_TYPE__NORMAL_DETECTOR = 0;
    public static final int HOTWORD_DETECTOR_CREATE_REQUESTED__DETECTOR_TYPE__TRUSTED_DETECTOR_DSP = 1;
    public static final int HOTWORD_DETECTOR_CREATE_REQUESTED__DETECTOR_TYPE__TRUSTED_DETECTOR_SOFTWARE = 2;

    // Values for HotwordDetectionServiceInitResultReported.detector_type
    public static final int HOTWORD_DETECTION_SERVICE_INIT_RESULT_REPORTED__DETECTOR_TYPE__NORMAL_DETECTOR = 0;
    public static final int HOTWORD_DETECTION_SERVICE_INIT_RESULT_REPORTED__DETECTOR_TYPE__TRUSTED_DETECTOR_DSP = 1;
    public static final int HOTWORD_DETECTION_SERVICE_INIT_RESULT_REPORTED__DETECTOR_TYPE__TRUSTED_DETECTOR_SOFTWARE = 2;

    // Values for HotwordDetectionServiceInitResultReported.result
    public static final int HOTWORD_DETECTION_SERVICE_INIT_RESULT_REPORTED__RESULT__CALLBACK_INIT_STATE_SUCCESS = 0;
    public static final int HOTWORD_DETECTION_SERVICE_INIT_RESULT_REPORTED__RESULT__CALLBACK_INIT_STATE_ERROR = 1;
    public static final int HOTWORD_DETECTION_SERVICE_INIT_RESULT_REPORTED__RESULT__CALLBACK_INIT_STATE_UNKNOWN_NO_VALUE = 2;
    public static final int HOTWORD_DETECTION_SERVICE_INIT_RESULT_REPORTED__RESULT__CALLBACK_INIT_STATE_UNKNOWN_OVER_MAX_CUSTOM_VALUE = 3;
    public static final int HOTWORD_DETECTION_SERVICE_INIT_RESULT_REPORTED__RESULT__CALLBACK_INIT_STATE_UNKNOWN_TIMEOUT = 4;

    // Values for HotwordDetectionServiceRestarted.detector_type
    public static final int HOTWORD_DETECTION_SERVICE_RESTARTED__DETECTOR_TYPE__NORMAL_DETECTOR = 0;
    public static final int HOTWORD_DETECTION_SERVICE_RESTARTED__DETECTOR_TYPE__TRUSTED_DETECTOR_DSP = 1;
    public static final int HOTWORD_DETECTION_SERVICE_RESTARTED__DETECTOR_TYPE__TRUSTED_DETECTOR_SOFTWARE = 2;

    // Values for HotwordDetectionServiceRestarted.reason
    public static final int HOTWORD_DETECTION_SERVICE_RESTARTED__REASON__UNKNOWN = 0;
    public static final int HOTWORD_DETECTION_SERVICE_RESTARTED__REASON__AUDIO_SERVICE_DIED = 1;
    public static final int HOTWORD_DETECTION_SERVICE_RESTARTED__REASON__SCHEDULE = 2;
    public static final int HOTWORD_DETECTION_SERVICE_RESTARTED__REASON__CRASH = 3;

    // Values for HotwordDetectorKeyphraseTriggered.detector_type
    public static final int HOTWORD_DETECTOR_KEYPHRASE_TRIGGERED__DETECTOR_TYPE__NORMAL_DETECTOR = 0;
    public static final int HOTWORD_DETECTOR_KEYPHRASE_TRIGGERED__DETECTOR_TYPE__TRUSTED_DETECTOR_DSP = 1;
    public static final int HOTWORD_DETECTOR_KEYPHRASE_TRIGGERED__DETECTOR_TYPE__TRUSTED_DETECTOR_SOFTWARE = 2;

    // Values for HotwordDetectorKeyphraseTriggered.result
    public static final int HOTWORD_DETECTOR_KEYPHRASE_TRIGGERED__RESULT__KEYPHRASE_TRIGGER = 0;
    public static final int HOTWORD_DETECTOR_KEYPHRASE_TRIGGERED__RESULT__FAILED_TO_INFORM_SERVICE = 1;
    public static final int HOTWORD_DETECTOR_KEYPHRASE_TRIGGERED__RESULT__DETECT_TIMEOUT = 2;
    public static final int HOTWORD_DETECTOR_KEYPHRASE_TRIGGERED__RESULT__DETECT_EXCEPTION = 3;
    public static final int HOTWORD_DETECTOR_KEYPHRASE_TRIGGERED__RESULT__SERVICE_CRASH = 4;
    public static final int HOTWORD_DETECTOR_KEYPHRASE_TRIGGERED__RESULT__DETECTED = 5;
    public static final int HOTWORD_DETECTOR_KEYPHRASE_TRIGGERED__RESULT__REJECTED = 6;
    public static final int HOTWORD_DETECTOR_KEYPHRASE_TRIGGERED__RESULT__DETECT_UNEXPECTED_CALLBACK = 7;
    public static final int HOTWORD_DETECTOR_KEYPHRASE_TRIGGERED__RESULT__DETECT_SECURITY_EXCEPTION = 8;
    public static final int HOTWORD_DETECTOR_KEYPHRASE_TRIGGERED__RESULT__REJECT_UNEXPECTED_CALLBACK = 9;
    public static final int HOTWORD_DETECTOR_KEYPHRASE_TRIGGERED__RESULT__REJECTED_FROM_RESTART = 10;

    // Values for HotwordDetectorEvents.detector_type
    public static final int HOTWORD_DETECTOR_EVENTS__DETECTOR_TYPE__NORMAL_DETECTOR = 0;
    public static final int HOTWORD_DETECTOR_EVENTS__DETECTOR_TYPE__TRUSTED_DETECTOR_DSP = 1;
    public static final int HOTWORD_DETECTOR_EVENTS__DETECTOR_TYPE__TRUSTED_DETECTOR_SOFTWARE = 2;

    // Values for HotwordDetectorEvents.event
    public static final int HOTWORD_DETECTOR_EVENTS__EVENT__UNKNOWN = 0;
    public static final int HOTWORD_DETECTOR_EVENTS__EVENT__REQUEST_BIND_SERVICE = 1;
    public static final int HOTWORD_DETECTOR_EVENTS__EVENT__ON_CONNECTED = 2;
    public static final int HOTWORD_DETECTOR_EVENTS__EVENT__REQUEST_BIND_SERVICE_FAIL = 3;
    public static final int HOTWORD_DETECTOR_EVENTS__EVENT__REQUEST_UPDATE_STATE = 4;
    public static final int HOTWORD_DETECTOR_EVENTS__EVENT__CALLBACK_UPDATE_STATE_AFTER_TIMEOUT = 5;
    public static final int HOTWORD_DETECTOR_EVENTS__EVENT__DID_NOT_CALL_START_RECOGNITION = 6;
    public static final int HOTWORD_DETECTOR_EVENTS__EVENT__ON_DISCONNECTED = 7;
    public static final int HOTWORD_DETECTOR_EVENTS__EVENT__APP_REQUEST_UPDATE_STATE = 8;
    public static final int HOTWORD_DETECTOR_EVENTS__EVENT__START_SOFTWARE_DETECTION = 9;
    public static final int HOTWORD_DETECTOR_EVENTS__EVENT__START_EXTERNAL_SOURCE_DETECTION = 10;
    public static final int HOTWORD_DETECTOR_EVENTS__EVENT__EXTERNAL_SOURCE_DETECTED = 11;
    public static final int HOTWORD_DETECTOR_EVENTS__EVENT__EXTERNAL_SOURCE_REJECTED = 12;
    public static final int HOTWORD_DETECTOR_EVENTS__EVENT__EXTERNAL_SOURCE_DETECT_SECURITY_EXCEPTION = 13;
    public static final int HOTWORD_DETECTOR_EVENTS__EVENT__CALLBACK_ON_STATUS_REPORTED_EXCEPTION = 14;
    public static final int HOTWORD_DETECTOR_EVENTS__EVENT__CALLBACK_ON_ERROR_EXCEPTION = 15;
    public static final int HOTWORD_DETECTOR_EVENTS__EVENT__CALLBACK_ON_REJECTED_EXCEPTION = 16;
    public static final int HOTWORD_DETECTOR_EVENTS__EVENT__CALLBACK_ON_DETECTED_EXCEPTION = 17;
    public static final int HOTWORD_DETECTOR_EVENTS__EVENT__CALLBACK_ON_PROCESS_RESTARTED_EXCEPTION = 18;
    public static final int HOTWORD_DETECTOR_EVENTS__EVENT__CALL_UPDATE_STATE_EXCEPTION = 19;
    public static final int HOTWORD_DETECTOR_EVENTS__EVENT__AUDIO_EGRESS_START = 20;
    public static final int HOTWORD_DETECTOR_EVENTS__EVENT__AUDIO_EGRESS_END = 21;
    public static final int HOTWORD_DETECTOR_EVENTS__EVENT__AUDIO_EGRESS_INTERRUPTED_EXCEPTION = 22;
    public static final int HOTWORD_DETECTOR_EVENTS__EVENT__AUDIO_EGRESS_NO_PERMISSION = 23;
    public static final int HOTWORD_DETECTOR_EVENTS__EVENT__AUDIO_EGRESS_INACTIVE_CLIENT = 24;
    public static final int HOTWORD_DETECTOR_EVENTS__EVENT__AUDIO_EGRESS_INACTIVE_HOTWORD_DETECTION_SERVICE = 25;
    public static final int HOTWORD_DETECTOR_EVENTS__EVENT__AUDIO_EGRESS_EMPTY_AUDIO_STREAM_LIST = 26;
    public static final int HOTWORD_DETECTOR_EVENTS__EVENT__AUDIO_EGRESS_SOURCE_IS_EMPTY = 27;
    public static final int HOTWORD_DETECTOR_EVENTS__EVENT__AUDIO_EGRESS_ILLEGAL_COPY_BUFFER_SIZE = 28;
    public static final int HOTWORD_DETECTOR_EVENTS__EVENT__AUDIO_EGRESS_CLOSE_ERROR_FROM_SYSTEM = 29;
    public static final int HOTWORD_DETECTOR_EVENTS__EVENT__AUDIO_EGRESS_CLOSE_ERROR_FROM_CLIENT = 30;
    public static final int HOTWORD_DETECTOR_EVENTS__EVENT__AUDIO_EGRESS_CLOSE_ERROR_FROM_HOTWORD_DETECTION_SERVICE = 31;

    // Values for BootCompletedBroadcastCompletionLatencyReported.event
    public static final int BOOT_COMPLETED_BROADCAST_COMPLETION_LATENCY_REPORTED__EVENT__UNKNOWN = 0;
    public static final int BOOT_COMPLETED_BROADCAST_COMPLETION_LATENCY_REPORTED__EVENT__LOCKED_BOOT_COMPLETED = 1;
    public static final int BOOT_COMPLETED_BROADCAST_COMPLETION_LATENCY_REPORTED__EVENT__BOOT_COMPLETED = 2;

    // Values for BootCompletedBroadcastCompletionLatencyReported.user_type
    public static final int BOOT_COMPLETED_BROADCAST_COMPLETION_LATENCY_REPORTED__USER_TYPE__TYPE_UNKNOWN = 0;
    public static final int BOOT_COMPLETED_BROADCAST_COMPLETION_LATENCY_REPORTED__USER_TYPE__FULL_SYSTEM = 1;
    public static final int BOOT_COMPLETED_BROADCAST_COMPLETION_LATENCY_REPORTED__USER_TYPE__FULL_SECONDARY = 2;
    public static final int BOOT_COMPLETED_BROADCAST_COMPLETION_LATENCY_REPORTED__USER_TYPE__FULL_GUEST = 3;
    public static final int BOOT_COMPLETED_BROADCAST_COMPLETION_LATENCY_REPORTED__USER_TYPE__FULL_DEMO = 4;
    public static final int BOOT_COMPLETED_BROADCAST_COMPLETION_LATENCY_REPORTED__USER_TYPE__FULL_RESTRICTED = 5;
    public static final int BOOT_COMPLETED_BROADCAST_COMPLETION_LATENCY_REPORTED__USER_TYPE__PROFILE_MANAGED = 6;
    public static final int BOOT_COMPLETED_BROADCAST_COMPLETION_LATENCY_REPORTED__USER_TYPE__SYSTEM_HEADLESS = 7;
    public static final int BOOT_COMPLETED_BROADCAST_COMPLETION_LATENCY_REPORTED__USER_TYPE__PROFILE_CLONE = 8;

    // Values for AppBackgroundRestrictionsInfo.restriction_level
    public static final int APP_BACKGROUND_RESTRICTIONS_INFO__RESTRICTION_LEVEL__LEVEL_UNKNOWN = 0;
    public static final int APP_BACKGROUND_RESTRICTIONS_INFO__RESTRICTION_LEVEL__LEVEL_UNRESTRICTED = 1;
    public static final int APP_BACKGROUND_RESTRICTIONS_INFO__RESTRICTION_LEVEL__LEVEL_EXEMPTED = 2;
    public static final int APP_BACKGROUND_RESTRICTIONS_INFO__RESTRICTION_LEVEL__LEVEL_ADAPTIVE_BUCKET = 3;
    public static final int APP_BACKGROUND_RESTRICTIONS_INFO__RESTRICTION_LEVEL__LEVEL_RESTRICTED_BUCKET = 4;
    public static final int APP_BACKGROUND_RESTRICTIONS_INFO__RESTRICTION_LEVEL__LEVEL_BACKGROUND_RESTRICTED = 5;
    public static final int APP_BACKGROUND_RESTRICTIONS_INFO__RESTRICTION_LEVEL__LEVEL_HIBERNATION = 6;

    // Values for AppBackgroundRestrictionsInfo.threshold
    public static final int APP_BACKGROUND_RESTRICTIONS_INFO__THRESHOLD__THRESHOLD_UNKNOWN = 0;
    public static final int APP_BACKGROUND_RESTRICTIONS_INFO__THRESHOLD__THRESHOLD_RESTRICTED = 1;
    public static final int APP_BACKGROUND_RESTRICTIONS_INFO__THRESHOLD__THRESHOLD_USER = 2;

    // Values for AppBackgroundRestrictionsInfo.tracker
    public static final int APP_BACKGROUND_RESTRICTIONS_INFO__TRACKER__UNKNOWN_TRACKER = 0;
    public static final int APP_BACKGROUND_RESTRICTIONS_INFO__TRACKER__BATTERY_TRACKER = 1;
    public static final int APP_BACKGROUND_RESTRICTIONS_INFO__TRACKER__BATTERY_EXEMPTION_TRACKER = 2;
    public static final int APP_BACKGROUND_RESTRICTIONS_INFO__TRACKER__FGS_TRACKER = 3;
    public static final int APP_BACKGROUND_RESTRICTIONS_INFO__TRACKER__MEDIA_SESSION_TRACKER = 4;
    public static final int APP_BACKGROUND_RESTRICTIONS_INFO__TRACKER__PERMISSION_TRACKER = 5;
    public static final int APP_BACKGROUND_RESTRICTIONS_INFO__TRACKER__BROADCAST_EVENTS_TRACKER = 6;
    public static final int APP_BACKGROUND_RESTRICTIONS_INFO__TRACKER__BIND_SERVICE_EVENTS_TRACKER = 7;

    // Values for AppBackgroundRestrictionsInfo.exemption_reason
    public static final int APP_BACKGROUND_RESTRICTIONS_INFO__EXEMPTION_REASON__REASON_UNKNOWN = 0;
    public static final int APP_BACKGROUND_RESTRICTIONS_INFO__EXEMPTION_REASON__REASON_DENIED = 1;
    public static final int APP_BACKGROUND_RESTRICTIONS_INFO__EXEMPTION_REASON__REASON_OTHER = 2;
    public static final int APP_BACKGROUND_RESTRICTIONS_INFO__EXEMPTION_REASON__REASON_PROC_STATE_PERSISTENT = 10;
    public static final int APP_BACKGROUND_RESTRICTIONS_INFO__EXEMPTION_REASON__REASON_PROC_STATE_PERSISTENT_UI = 11;
    public static final int APP_BACKGROUND_RESTRICTIONS_INFO__EXEMPTION_REASON__REASON_PROC_STATE_TOP = 12;
    public static final int APP_BACKGROUND_RESTRICTIONS_INFO__EXEMPTION_REASON__REASON_PROC_STATE_BTOP = 13;
    public static final int APP_BACKGROUND_RESTRICTIONS_INFO__EXEMPTION_REASON__REASON_PROC_STATE_FGS = 14;
    public static final int APP_BACKGROUND_RESTRICTIONS_INFO__EXEMPTION_REASON__REASON_PROC_STATE_BFGS = 15;
    public static final int APP_BACKGROUND_RESTRICTIONS_INFO__EXEMPTION_REASON__REASON_UID_VISIBLE = 50;
    public static final int APP_BACKGROUND_RESTRICTIONS_INFO__EXEMPTION_REASON__REASON_SYSTEM_UID = 51;
    public static final int APP_BACKGROUND_RESTRICTIONS_INFO__EXEMPTION_REASON__REASON_ACTIVITY_STARTER = 52;
    public static final int APP_BACKGROUND_RESTRICTIONS_INFO__EXEMPTION_REASON__REASON_START_ACTIVITY_FLAG = 53;
    public static final int APP_BACKGROUND_RESTRICTIONS_INFO__EXEMPTION_REASON__REASON_FGS_BINDING = 54;
    public static final int APP_BACKGROUND_RESTRICTIONS_INFO__EXEMPTION_REASON__REASON_DEVICE_OWNER = 55;
    public static final int APP_BACKGROUND_RESTRICTIONS_INFO__EXEMPTION_REASON__REASON_PROFILE_OWNER = 56;
    public static final int APP_BACKGROUND_RESTRICTIONS_INFO__EXEMPTION_REASON__REASON_COMPANION_DEVICE_MANAGER = 57;
    public static final int APP_BACKGROUND_RESTRICTIONS_INFO__EXEMPTION_REASON__REASON_BACKGROUND_ACTIVITY_PERMISSION = 58;
    public static final int APP_BACKGROUND_RESTRICTIONS_INFO__EXEMPTION_REASON__REASON_BACKGROUND_FGS_PERMISSION = 59;
    public static final int APP_BACKGROUND_RESTRICTIONS_INFO__EXEMPTION_REASON__REASON_INSTR_BACKGROUND_ACTIVITY_PERMISSION = 60;
    public static final int APP_BACKGROUND_RESTRICTIONS_INFO__EXEMPTION_REASON__REASON_INSTR_BACKGROUND_FGS_PERMISSION = 61;
    public static final int APP_BACKGROUND_RESTRICTIONS_INFO__EXEMPTION_REASON__REASON_SYSTEM_ALERT_WINDOW_PERMISSION = 62;
    public static final int APP_BACKGROUND_RESTRICTIONS_INFO__EXEMPTION_REASON__REASON_DEVICE_DEMO_MODE = 63;
    public static final int APP_BACKGROUND_RESTRICTIONS_INFO__EXEMPTION_REASON__REASON_ALLOWLISTED_PACKAGE = 65;
    public static final int APP_BACKGROUND_RESTRICTIONS_INFO__EXEMPTION_REASON__REASON_APPOP = 66;
    public static final int APP_BACKGROUND_RESTRICTIONS_INFO__EXEMPTION_REASON__REASON_ACTIVITY_VISIBILITY_GRACE_PERIOD = 67;
    public static final int APP_BACKGROUND_RESTRICTIONS_INFO__EXEMPTION_REASON__REASON_OP_ACTIVATE_VPN = 68;
    public static final int APP_BACKGROUND_RESTRICTIONS_INFO__EXEMPTION_REASON__REASON_OP_ACTIVATE_PLATFORM_VPN = 69;
    public static final int APP_BACKGROUND_RESTRICTIONS_INFO__EXEMPTION_REASON__REASON_TEMP_ALLOWED_WHILE_IN_USE = 70;
    public static final int APP_BACKGROUND_RESTRICTIONS_INFO__EXEMPTION_REASON__REASON_CURRENT_INPUT_METHOD = 71;
    public static final int APP_BACKGROUND_RESTRICTIONS_INFO__EXEMPTION_REASON__REASON_GEOFENCING = 100;
    public static final int APP_BACKGROUND_RESTRICTIONS_INFO__EXEMPTION_REASON__REASON_PUSH_MESSAGING = 101;
    public static final int APP_BACKGROUND_RESTRICTIONS_INFO__EXEMPTION_REASON__REASON_PUSH_MESSAGING_OVER_QUOTA = 102;
    public static final int APP_BACKGROUND_RESTRICTIONS_INFO__EXEMPTION_REASON__REASON_ACTIVITY_RECOGNITION = 103;
    public static final int APP_BACKGROUND_RESTRICTIONS_INFO__EXEMPTION_REASON__REASON_ACCOUNT_TRANSFER = 104;
    public static final int APP_BACKGROUND_RESTRICTIONS_INFO__EXEMPTION_REASON__REASON_BOOT_COMPLETED = 200;
    public static final int APP_BACKGROUND_RESTRICTIONS_INFO__EXEMPTION_REASON__REASON_PRE_BOOT_COMPLETED = 201;
    public static final int APP_BACKGROUND_RESTRICTIONS_INFO__EXEMPTION_REASON__REASON_LOCKED_BOOT_COMPLETED = 202;
    public static final int APP_BACKGROUND_RESTRICTIONS_INFO__EXEMPTION_REASON__REASON_BLUETOOTH_BROADCAST = 203;
    public static final int APP_BACKGROUND_RESTRICTIONS_INFO__EXEMPTION_REASON__REASON_TIMEZONE_CHANGED = 204;
    public static final int APP_BACKGROUND_RESTRICTIONS_INFO__EXEMPTION_REASON__REASON_TIME_CHANGED = 205;
    public static final int APP_BACKGROUND_RESTRICTIONS_INFO__EXEMPTION_REASON__REASON_LOCALE_CHANGED = 206;
    public static final int APP_BACKGROUND_RESTRICTIONS_INFO__EXEMPTION_REASON__REASON_SCHEDULE_EXACT_ALARM_PERMISSION_STATE_CHANGED = 207;
    public static final int APP_BACKGROUND_RESTRICTIONS_INFO__EXEMPTION_REASON__REASON_REFRESH_SAFETY_SOURCES = 208;
    public static final int APP_BACKGROUND_RESTRICTIONS_INFO__EXEMPTION_REASON__REASON_SYSTEM_ALLOW_LISTED = 300;
    public static final int APP_BACKGROUND_RESTRICTIONS_INFO__EXEMPTION_REASON__REASON_ALARM_MANAGER_ALARM_CLOCK = 301;
    public static final int APP_BACKGROUND_RESTRICTIONS_INFO__EXEMPTION_REASON__REASON_ALARM_MANAGER_WHILE_IDLE = 302;
    public static final int APP_BACKGROUND_RESTRICTIONS_INFO__EXEMPTION_REASON__REASON_SERVICE_LAUNCH = 303;
    public static final int APP_BACKGROUND_RESTRICTIONS_INFO__EXEMPTION_REASON__REASON_KEY_CHAIN = 304;
    public static final int APP_BACKGROUND_RESTRICTIONS_INFO__EXEMPTION_REASON__REASON_PACKAGE_VERIFIER = 305;
    public static final int APP_BACKGROUND_RESTRICTIONS_INFO__EXEMPTION_REASON__REASON_SYNC_MANAGER = 306;
    public static final int APP_BACKGROUND_RESTRICTIONS_INFO__EXEMPTION_REASON__REASON_DOMAIN_VERIFICATION_V1 = 307;
    public static final int APP_BACKGROUND_RESTRICTIONS_INFO__EXEMPTION_REASON__REASON_DOMAIN_VERIFICATION_V2 = 308;
    public static final int APP_BACKGROUND_RESTRICTIONS_INFO__EXEMPTION_REASON__REASON_VPN = 309;
    public static final int APP_BACKGROUND_RESTRICTIONS_INFO__EXEMPTION_REASON__REASON_NOTIFICATION_SERVICE = 310;
    public static final int APP_BACKGROUND_RESTRICTIONS_INFO__EXEMPTION_REASON__REASON_PACKAGE_REPLACED = 311;
    public static final int APP_BACKGROUND_RESTRICTIONS_INFO__EXEMPTION_REASON__REASON_LOCATION_PROVIDER = 312;
    public static final int APP_BACKGROUND_RESTRICTIONS_INFO__EXEMPTION_REASON__REASON_MEDIA_BUTTON = 313;
    public static final int APP_BACKGROUND_RESTRICTIONS_INFO__EXEMPTION_REASON__REASON_EVENT_SMS = 314;
    public static final int APP_BACKGROUND_RESTRICTIONS_INFO__EXEMPTION_REASON__REASON_EVENT_MMS = 315;
    public static final int APP_BACKGROUND_RESTRICTIONS_INFO__EXEMPTION_REASON__REASON_SHELL = 316;
    public static final int APP_BACKGROUND_RESTRICTIONS_INFO__EXEMPTION_REASON__REASON_MEDIA_SESSION_CALLBACK = 317;
    public static final int APP_BACKGROUND_RESTRICTIONS_INFO__EXEMPTION_REASON__REASON_ROLE_DIALER = 318;
    public static final int APP_BACKGROUND_RESTRICTIONS_INFO__EXEMPTION_REASON__REASON_ROLE_EMERGENCY = 319;
    public static final int APP_BACKGROUND_RESTRICTIONS_INFO__EXEMPTION_REASON__REASON_SYSTEM_MODULE = 320;
    public static final int APP_BACKGROUND_RESTRICTIONS_INFO__EXEMPTION_REASON__REASON_CARRIER_PRIVILEGED_APP = 321;
    public static final int APP_BACKGROUND_RESTRICTIONS_INFO__EXEMPTION_REASON__REASON_DPO_PROTECTED_APP = 322;
    public static final int APP_BACKGROUND_RESTRICTIONS_INFO__EXEMPTION_REASON__REASON_DISALLOW_APPS_CONTROL = 323;
    public static final int APP_BACKGROUND_RESTRICTIONS_INFO__EXEMPTION_REASON__REASON_ACTIVE_DEVICE_ADMIN = 324;
    public static final int APP_BACKGROUND_RESTRICTIONS_INFO__EXEMPTION_REASON__REASON_OPT_OUT_REQUESTED = 1000;

    // Values for AppBackgroundRestrictionsInfo.opt_level
    public static final int APP_BACKGROUND_RESTRICTIONS_INFO__OPT_LEVEL__UNKNOWN = 0;
    public static final int APP_BACKGROUND_RESTRICTIONS_INFO__OPT_LEVEL__OPTIMIZED = 1;
    public static final int APP_BACKGROUND_RESTRICTIONS_INFO__OPT_LEVEL__BACKGROUND_RESTRICTED = 2;
    public static final int APP_BACKGROUND_RESTRICTIONS_INFO__OPT_LEVEL__NOT_OPTIMIZED = 3;

    // Values for AppBackgroundRestrictionsInfo.target_sdk
    public static final int APP_BACKGROUND_RESTRICTIONS_INFO__TARGET_SDK__SDK_UNKNOWN = 0;
    public static final int APP_BACKGROUND_RESTRICTIONS_INFO__TARGET_SDK__SDK_PRE_S = 1;
    public static final int APP_BACKGROUND_RESTRICTIONS_INFO__TARGET_SDK__SDK_S = 2;
    public static final int APP_BACKGROUND_RESTRICTIONS_INFO__TARGET_SDK__SDK_T = 3;

    // Values for AppBackgroundRestrictionsInfo.previous_restriction_level
    public static final int APP_BACKGROUND_RESTRICTIONS_INFO__PREVIOUS_RESTRICTION_LEVEL__LEVEL_UNKNOWN = 0;
    public static final int APP_BACKGROUND_RESTRICTIONS_INFO__PREVIOUS_RESTRICTION_LEVEL__LEVEL_UNRESTRICTED = 1;
    public static final int APP_BACKGROUND_RESTRICTIONS_INFO__PREVIOUS_RESTRICTION_LEVEL__LEVEL_EXEMPTED = 2;
    public static final int APP_BACKGROUND_RESTRICTIONS_INFO__PREVIOUS_RESTRICTION_LEVEL__LEVEL_ADAPTIVE_BUCKET = 3;
    public static final int APP_BACKGROUND_RESTRICTIONS_INFO__PREVIOUS_RESTRICTION_LEVEL__LEVEL_RESTRICTED_BUCKET = 4;
    public static final int APP_BACKGROUND_RESTRICTIONS_INFO__PREVIOUS_RESTRICTION_LEVEL__LEVEL_BACKGROUND_RESTRICTED = 5;
    public static final int APP_BACKGROUND_RESTRICTIONS_INFO__PREVIOUS_RESTRICTION_LEVEL__LEVEL_HIBERNATION = 6;

    // Values for CdmAssociationAction.action
    public static final int CDM_ASSOCIATION_ACTION__ACTION__UNKNOWN = 0;
    public static final int CDM_ASSOCIATION_ACTION__ACTION__CREATED = 1;
    public static final int CDM_ASSOCIATION_ACTION__ACTION__REMOVED = 2;

    // Values for CdmAssociationAction.device_profile
    public static final int CDM_ASSOCIATION_ACTION__DEVICE_PROFILE__DEVICE_PROFILE_NULL = 0;
    public static final int CDM_ASSOCIATION_ACTION__DEVICE_PROFILE__DEVICE_PROFILE_WATCH = 1;
    public static final int CDM_ASSOCIATION_ACTION__DEVICE_PROFILE__DEVICE_PROFILE_APP_STREAMING = 2;
    public static final int CDM_ASSOCIATION_ACTION__DEVICE_PROFILE__DEVICE_PROFILE_AUTO_PROJECTION = 3;
    public static final int CDM_ASSOCIATION_ACTION__DEVICE_PROFILE__DEVICE_PROFILE_COMPUTER = 4;
    public static final int CDM_ASSOCIATION_ACTION__DEVICE_PROFILE__DEVICE_PROFILE_GLASSES = 5;
    public static final int CDM_ASSOCIATION_ACTION__DEVICE_PROFILE__DEVICE_PROFILE_NEARBY_DEVICE_STREAMING = 6;

    // Values for LetterboxPositionChanged.position_change
    public static final int LETTERBOX_POSITION_CHANGED__POSITION_CHANGE__UNKNOWN = 0;
    public static final int LETTERBOX_POSITION_CHANGED__POSITION_CHANGE__CENTER_TO_LEFT = 1;
    public static final int LETTERBOX_POSITION_CHANGED__POSITION_CHANGE__LEFT_TO_CENTER = 2;
    public static final int LETTERBOX_POSITION_CHANGED__POSITION_CHANGE__CENTER_TO_RIGHT = 3;
    public static final int LETTERBOX_POSITION_CHANGED__POSITION_CHANGE__RIGHT_TO_CENTER = 4;
    public static final int LETTERBOX_POSITION_CHANGED__POSITION_CHANGE__CENTER_TO_TOP = 5;
    public static final int LETTERBOX_POSITION_CHANGED__POSITION_CHANGE__TOP_TO_CENTER = 6;
    public static final int LETTERBOX_POSITION_CHANGED__POSITION_CHANGE__CENTER_TO_BOTTOM = 7;
    public static final int LETTERBOX_POSITION_CHANGED__POSITION_CHANGE__BOTTOM_TO_CENTER = 8;

    // Values for SyncExemptionOccurred.proc_state
    public static final int SYNC_EXEMPTION_OCCURRED__PROC_STATE__UNKNOWN = 0;
    public static final int SYNC_EXEMPTION_OCCURRED__PROC_STATE__PERSISTENT = 1;
    public static final int SYNC_EXEMPTION_OCCURRED__PROC_STATE__PERSISTENT_UI = 2;
    public static final int SYNC_EXEMPTION_OCCURRED__PROC_STATE__TOP = 3;
    public static final int SYNC_EXEMPTION_OCCURRED__PROC_STATE__BOUND_TOP = 4;
    public static final int SYNC_EXEMPTION_OCCURRED__PROC_STATE__FOREGROUND_SERVICE = 5;
    public static final int SYNC_EXEMPTION_OCCURRED__PROC_STATE__BOUND_FOREGROUND_SERVICE = 6;
    public static final int SYNC_EXEMPTION_OCCURRED__PROC_STATE__IMPORTANT_FOREGROUND = 7;
    public static final int SYNC_EXEMPTION_OCCURRED__PROC_STATE__IMPORTANT_BACKGROUND = 8;
    public static final int SYNC_EXEMPTION_OCCURRED__PROC_STATE__TRANSIENT_BACKGROUND = 9;
    public static final int SYNC_EXEMPTION_OCCURRED__PROC_STATE__BACKUP = 10;
    public static final int SYNC_EXEMPTION_OCCURRED__PROC_STATE__SERVICE = 11;
    public static final int SYNC_EXEMPTION_OCCURRED__PROC_STATE__RECEIVER = 12;
    public static final int SYNC_EXEMPTION_OCCURRED__PROC_STATE__TOP_SLEEPING = 13;
    public static final int SYNC_EXEMPTION_OCCURRED__PROC_STATE__HEAVY_WEIGHT = 14;
    public static final int SYNC_EXEMPTION_OCCURRED__PROC_STATE__HOME = 15;
    public static final int SYNC_EXEMPTION_OCCURRED__PROC_STATE__LAST_ACTIVITY = 16;
    public static final int SYNC_EXEMPTION_OCCURRED__PROC_STATE__CACHED_ACTIVITY = 17;
    public static final int SYNC_EXEMPTION_OCCURRED__PROC_STATE__CACHED_ACTIVITY_CLIENT = 18;
    public static final int SYNC_EXEMPTION_OCCURRED__PROC_STATE__CACHED_RECENT = 19;
    public static final int SYNC_EXEMPTION_OCCURRED__PROC_STATE__CACHED_EMPTY = 20;

    // Values for SyncExemptionOccurred.restriction_level
    public static final int SYNC_EXEMPTION_OCCURRED__RESTRICTION_LEVEL__LEVEL_UNKNOWN = 0;
    public static final int SYNC_EXEMPTION_OCCURRED__RESTRICTION_LEVEL__LEVEL_UNRESTRICTED = 1;
    public static final int SYNC_EXEMPTION_OCCURRED__RESTRICTION_LEVEL__LEVEL_EXEMPTED = 2;
    public static final int SYNC_EXEMPTION_OCCURRED__RESTRICTION_LEVEL__LEVEL_ADAPTIVE_BUCKET = 3;
    public static final int SYNC_EXEMPTION_OCCURRED__RESTRICTION_LEVEL__LEVEL_RESTRICTED_BUCKET = 4;
    public static final int SYNC_EXEMPTION_OCCURRED__RESTRICTION_LEVEL__LEVEL_BACKGROUND_RESTRICTED = 5;
    public static final int SYNC_EXEMPTION_OCCURRED__RESTRICTION_LEVEL__LEVEL_HIBERNATION = 6;

    // Values for AutofillPresentationEventReported.presentation_event_result
    public static final int AUTOFILL_PRESENTATION_EVENT_REPORTED__PRESENTATION_EVENT_RESULT__NONE_SHOWN_UNKNOWN_REASON = 0;
    public static final int AUTOFILL_PRESENTATION_EVENT_REPORTED__PRESENTATION_EVENT_RESULT__ANY_SHOWN = 1;
    public static final int AUTOFILL_PRESENTATION_EVENT_REPORTED__PRESENTATION_EVENT_RESULT__NONE_SHOWN_VIEW_FOCUS_CHANGED = 2;
    public static final int AUTOFILL_PRESENTATION_EVENT_REPORTED__PRESENTATION_EVENT_RESULT__NONE_SHOWN_VIEW_CHANGED = 3;
    public static final int AUTOFILL_PRESENTATION_EVENT_REPORTED__PRESENTATION_EVENT_RESULT__NONE_SHOWN_ACTIVITY_FINISHED = 4;
    public static final int AUTOFILL_PRESENTATION_EVENT_REPORTED__PRESENTATION_EVENT_RESULT__NONE_SHOWN_REQUEST_TIMEOUT = 5;
    public static final int AUTOFILL_PRESENTATION_EVENT_REPORTED__PRESENTATION_EVENT_RESULT__NONE_SHOWN_SESSION_COMMITTED_PREMATURELY = 6;
    public static final int AUTOFILL_PRESENTATION_EVENT_REPORTED__PRESENTATION_EVENT_RESULT__NONE_SHOWN_FILL_REQUEST_FAILED = 7;
    public static final int AUTOFILL_PRESENTATION_EVENT_REPORTED__PRESENTATION_EVENT_RESULT__NONE_SHOWN_NO_FOCUS = 8;
    public static final int AUTOFILL_PRESENTATION_EVENT_REPORTED__PRESENTATION_EVENT_RESULT__NONE_SHOWN_VIEW_FOCUSED_BEFORE_FILL_DIALOG_RESPONSE = 9;

    // Values for AutofillPresentationEventReported.display_presentation_type
    public static final int AUTOFILL_PRESENTATION_EVENT_REPORTED__DISPLAY_PRESENTATION_TYPE__UNKNOWN_AUTOFILL_DISPLAY_PRESENTATION_TYPE = 0;
    public static final int AUTOFILL_PRESENTATION_EVENT_REPORTED__DISPLAY_PRESENTATION_TYPE__MENU = 1;
    public static final int AUTOFILL_PRESENTATION_EVENT_REPORTED__DISPLAY_PRESENTATION_TYPE__INLINE = 2;
    public static final int AUTOFILL_PRESENTATION_EVENT_REPORTED__DISPLAY_PRESENTATION_TYPE__DIALOG = 3;

    // Values for AutofillPresentationEventReported.authentication_type
    public static final int AUTOFILL_PRESENTATION_EVENT_REPORTED__AUTHENTICATION_TYPE__AUTHENTICATION_TYPE_UNKNOWN = 0;
    public static final int AUTOFILL_PRESENTATION_EVENT_REPORTED__AUTHENTICATION_TYPE__DATASET_AUTHENTICATION = 1;
    public static final int AUTOFILL_PRESENTATION_EVENT_REPORTED__AUTHENTICATION_TYPE__FULL_AUTHENTICATION = 2;

    // Values for AutofillPresentationEventReported.authentication_result
    public static final int AUTOFILL_PRESENTATION_EVENT_REPORTED__AUTHENTICATION_RESULT__AUTHENTICATION_RESULT_UNKNOWN = 0;
    public static final int AUTOFILL_PRESENTATION_EVENT_REPORTED__AUTHENTICATION_RESULT__AUTHENTICATION_SUCCESS = 1;
    public static final int AUTOFILL_PRESENTATION_EVENT_REPORTED__AUTHENTICATION_RESULT__AUTHENTICATION_FAILURE = 2;

    // Values for AutofillPresentationEventReported.selected_dataset_picked_reason
    public static final int AUTOFILL_PRESENTATION_EVENT_REPORTED__SELECTED_DATASET_PICKED_REASON__PICK_REASON_UNKNOWN = 0;
    public static final int AUTOFILL_PRESENTATION_EVENT_REPORTED__SELECTED_DATASET_PICKED_REASON__PICK_REASON_NO_PCC = 1;
    public static final int AUTOFILL_PRESENTATION_EVENT_REPORTED__SELECTED_DATASET_PICKED_REASON__PICK_REASON_PROVIDER_DETECTION_ONLY = 2;
    public static final int AUTOFILL_PRESENTATION_EVENT_REPORTED__SELECTED_DATASET_PICKED_REASON__PICK_REASON_PROVIDER_DETECTION_PREFERRED_WITH_PCC = 3;
    public static final int AUTOFILL_PRESENTATION_EVENT_REPORTED__SELECTED_DATASET_PICKED_REASON__PICK_REASON_PCC_DETECTION_ONLY = 4;
    public static final int AUTOFILL_PRESENTATION_EVENT_REPORTED__SELECTED_DATASET_PICKED_REASON__PICK_REASON_PCC_DETECTION_PREFERRED_WITH_PROVIDER = 5;

    // Values for AutofillPresentationEventReported.detection_preference
    public static final int AUTOFILL_PRESENTATION_EVENT_REPORTED__DETECTION_PREFERENCE__DETECTION_PREFER_UNKONWN = 0;
    public static final int AUTOFILL_PRESENTATION_EVENT_REPORTED__DETECTION_PREFERENCE__DETECTION_PREFER_AUTOFILL_PROVIDER = 1;
    public static final int AUTOFILL_PRESENTATION_EVENT_REPORTED__DETECTION_PREFERENCE__DETECTION_PREFER_PCC = 2;

    // Values for DockStateChanged.state
    public static final int DOCK_STATE_CHANGED__STATE__DOCK_STATE_UNDOCKED = 0;
    public static final int DOCK_STATE_CHANGED__STATE__DOCK_STATE_DESK = 1;
    public static final int DOCK_STATE_CHANGED__STATE__DOCK_STATE_CAR = 2;
    public static final int DOCK_STATE_CHANGED__STATE__DOCK_STATE_LE_DESK = 3;
    public static final int DOCK_STATE_CHANGED__STATE__DOCK_STATE_HE_DESK = 4;

    // Values for BroadcastDeliveryEventReported.receiver_type
    public static final int BROADCAST_DELIVERY_EVENT_REPORTED__RECEIVER_TYPE__UNKNOWN = 0;
    public static final int BROADCAST_DELIVERY_EVENT_REPORTED__RECEIVER_TYPE__RUNTIME = 1;
    public static final int BROADCAST_DELIVERY_EVENT_REPORTED__RECEIVER_TYPE__MANIFEST = 2;

    // Values for BroadcastDeliveryEventReported.proc_start_type
    public static final int BROADCAST_DELIVERY_EVENT_REPORTED__PROC_START_TYPE__PROCESS_START_TYPE_UNKNOWN = 0;
    public static final int BROADCAST_DELIVERY_EVENT_REPORTED__PROC_START_TYPE__PROCESS_START_TYPE_WARM = 1;
    public static final int BROADCAST_DELIVERY_EVENT_REPORTED__PROC_START_TYPE__PROCESS_START_TYPE_HOT = 2;
    public static final int BROADCAST_DELIVERY_EVENT_REPORTED__PROC_START_TYPE__PROCESS_START_TYPE_COLD = 3;

    // Values for BroadcastDeliveryEventReported.package_stopped_state
    public static final int BROADCAST_DELIVERY_EVENT_REPORTED__PACKAGE_STOPPED_STATE__PACKAGE_STATE_UNKNOWN = 0;
    public static final int BROADCAST_DELIVERY_EVENT_REPORTED__PACKAGE_STOPPED_STATE__PACKAGE_STATE_NORMAL = 1;
    public static final int BROADCAST_DELIVERY_EVENT_REPORTED__PACKAGE_STOPPED_STATE__PACKAGE_STATE_STOPPED = 2;

    // Values for ServiceRequestEventReported.request_type
    public static final int SERVICE_REQUEST_EVENT_REPORTED__REQUEST_TYPE__UNKNOWN = 0;
    public static final int SERVICE_REQUEST_EVENT_REPORTED__REQUEST_TYPE__START = 1;
    public static final int SERVICE_REQUEST_EVENT_REPORTED__REQUEST_TYPE__BIND = 2;

    // Values for ServiceRequestEventReported.proc_start_type
    public static final int SERVICE_REQUEST_EVENT_REPORTED__PROC_START_TYPE__PROCESS_START_TYPE_UNKNOWN = 0;
    public static final int SERVICE_REQUEST_EVENT_REPORTED__PROC_START_TYPE__PROCESS_START_TYPE_WARM = 1;
    public static final int SERVICE_REQUEST_EVENT_REPORTED__PROC_START_TYPE__PROCESS_START_TYPE_HOT = 2;
    public static final int SERVICE_REQUEST_EVENT_REPORTED__PROC_START_TYPE__PROCESS_START_TYPE_COLD = 3;

    // Values for ServiceRequestEventReported.package_stopped_state
    public static final int SERVICE_REQUEST_EVENT_REPORTED__PACKAGE_STOPPED_STATE__PACKAGE_STATE_UNKNOWN = 0;
    public static final int SERVICE_REQUEST_EVENT_REPORTED__PACKAGE_STOPPED_STATE__PACKAGE_STATE_NORMAL = 1;
    public static final int SERVICE_REQUEST_EVENT_REPORTED__PACKAGE_STOPPED_STATE__PACKAGE_STATE_STOPPED = 2;

    // Values for ProviderAcquisitionEventReported.proc_start_type
    public static final int PROVIDER_ACQUISITION_EVENT_REPORTED__PROC_START_TYPE__PROCESS_START_TYPE_UNKNOWN = 0;
    public static final int PROVIDER_ACQUISITION_EVENT_REPORTED__PROC_START_TYPE__PROCESS_START_TYPE_WARM = 1;
    public static final int PROVIDER_ACQUISITION_EVENT_REPORTED__PROC_START_TYPE__PROCESS_START_TYPE_HOT = 2;
    public static final int PROVIDER_ACQUISITION_EVENT_REPORTED__PROC_START_TYPE__PROCESS_START_TYPE_COLD = 3;

    // Values for ProviderAcquisitionEventReported.package_stopped_state
    public static final int PROVIDER_ACQUISITION_EVENT_REPORTED__PACKAGE_STOPPED_STATE__PACKAGE_STATE_UNKNOWN = 0;
    public static final int PROVIDER_ACQUISITION_EVENT_REPORTED__PACKAGE_STOPPED_STATE__PACKAGE_STATE_NORMAL = 1;
    public static final int PROVIDER_ACQUISITION_EVENT_REPORTED__PACKAGE_STOPPED_STATE__PACKAGE_STATE_STOPPED = 2;

    // Values for VibrationReported.vibration_type
    public static final int VIBRATION_REPORTED__VIBRATION_TYPE__UNKNOWN = 0;
    public static final int VIBRATION_REPORTED__VIBRATION_TYPE__SINGLE = 1;
    public static final int VIBRATION_REPORTED__VIBRATION_TYPE__REPEATED = 2;
    public static final int VIBRATION_REPORTED__VIBRATION_TYPE__EXTERNAL = 3;

    // Values for AppCompactedV2.oom_change_reason
    public static final int APP_COMPACTED_V2__OOM_CHANGE_REASON__OOM_ADJ_REASON_UNKNOWN_TO_PROTO = -1;
    public static final int APP_COMPACTED_V2__OOM_CHANGE_REASON__OOM_ADJ_REASON_NONE = 0;
    public static final int APP_COMPACTED_V2__OOM_CHANGE_REASON__OOM_ADJ_REASON_ACTIVITY = 1;
    public static final int APP_COMPACTED_V2__OOM_CHANGE_REASON__OOM_ADJ_REASON_FINISH_RECEIVER = 2;
    public static final int APP_COMPACTED_V2__OOM_CHANGE_REASON__OOM_ADJ_REASON_START_RECEIVER = 3;
    public static final int APP_COMPACTED_V2__OOM_CHANGE_REASON__OOM_ADJ_REASON_BIND_SERVICE = 4;
    public static final int APP_COMPACTED_V2__OOM_CHANGE_REASON__OOM_ADJ_REASON_UNBIND_SERVICE = 5;
    public static final int APP_COMPACTED_V2__OOM_CHANGE_REASON__OOM_ADJ_REASON_START_SERVICE = 6;
    public static final int APP_COMPACTED_V2__OOM_CHANGE_REASON__OOM_ADJ_REASON_GET_PROVIDER = 7;
    public static final int APP_COMPACTED_V2__OOM_CHANGE_REASON__OOM_ADJ_REASON_REMOVE_PROVIDER = 8;
    public static final int APP_COMPACTED_V2__OOM_CHANGE_REASON__OOM_ADJ_REASON_UI_VISIBILITY = 9;
    public static final int APP_COMPACTED_V2__OOM_CHANGE_REASON__OOM_ADJ_REASON_ALLOWLIST = 10;
    public static final int APP_COMPACTED_V2__OOM_CHANGE_REASON__OOM_ADJ_REASON_PROCESS_BEGIN = 11;
    public static final int APP_COMPACTED_V2__OOM_CHANGE_REASON__OOM_ADJ_REASON_PROCESS_END = 12;
    public static final int APP_COMPACTED_V2__OOM_CHANGE_REASON__OOM_ADJ_REASON_SHORT_FGS_TIMEOUT = 13;
    public static final int APP_COMPACTED_V2__OOM_CHANGE_REASON__OOM_ADJ_REASON_SYSTEM_INIT = 14;
    public static final int APP_COMPACTED_V2__OOM_CHANGE_REASON__OOM_ADJ_REASON_BACKUP = 15;
    public static final int APP_COMPACTED_V2__OOM_CHANGE_REASON__OOM_ADJ_REASON_SHELL = 16;
    public static final int APP_COMPACTED_V2__OOM_CHANGE_REASON__OOM_ADJ_REASON_REMOVE_TASK = 17;
    public static final int APP_COMPACTED_V2__OOM_CHANGE_REASON__OOM_ADJ_REASON_UID_IDLE = 18;
    public static final int APP_COMPACTED_V2__OOM_CHANGE_REASON__OOM_ADJ_REASON_STOP_SERVICE = 19;
    public static final int APP_COMPACTED_V2__OOM_CHANGE_REASON__OOM_ADJ_REASON_EXECUTING_SERVICE = 20;
    public static final int APP_COMPACTED_V2__OOM_CHANGE_REASON__OOM_ADJ_REASON_RESTRICTION_CHANGE = 21;
    public static final int APP_COMPACTED_V2__OOM_CHANGE_REASON__OOM_ADJ_REASON_COMPONENT_DISABLED = 22;

    // Values for DisplayBrightnessChanged.reason
    public static final int DISPLAY_BRIGHTNESS_CHANGED__REASON__REASON_UNKNOWN = 0;
    public static final int DISPLAY_BRIGHTNESS_CHANGED__REASON__REASON_MANUAL = 1;

    // Values for DisplayBrightnessChanged.entire_reason
    public static final int DISPLAY_BRIGHTNESS_CHANGED__ENTIRE_REASON__REASON_UNKNOWN = 0;
    public static final int DISPLAY_BRIGHTNESS_CHANGED__ENTIRE_REASON__REASON_MANUAL = 1;
    public static final int DISPLAY_BRIGHTNESS_CHANGED__ENTIRE_REASON__REASON_DOZE = 2;
    public static final int DISPLAY_BRIGHTNESS_CHANGED__ENTIRE_REASON__REASON_DOZE_DEFAULT = 3;
    public static final int DISPLAY_BRIGHTNESS_CHANGED__ENTIRE_REASON__REASON_AUTOMATIC = 4;
    public static final int DISPLAY_BRIGHTNESS_CHANGED__ENTIRE_REASON__REASON_SCREEN_OFF = 5;
    public static final int DISPLAY_BRIGHTNESS_CHANGED__ENTIRE_REASON__REASON_OVERRIDE = 6;
    public static final int DISPLAY_BRIGHTNESS_CHANGED__ENTIRE_REASON__REASON_TEMPORARY = 7;
    public static final int DISPLAY_BRIGHTNESS_CHANGED__ENTIRE_REASON__REASON_BOOST = 8;
    public static final int DISPLAY_BRIGHTNESS_CHANGED__ENTIRE_REASON__REASON_SCREEN_OFF_BRIGHTNESS_SENSOR = 9;
    public static final int DISPLAY_BRIGHTNESS_CHANGED__ENTIRE_REASON__REASON_FOLLOWER = 10;

    // Values for DisplayBrightnessChanged.bucket_index
    public static final int DISPLAY_BRIGHTNESS_CHANGED__BUCKET_INDEX__RANGE_UNKNOWN = 0;
    public static final int DISPLAY_BRIGHTNESS_CHANGED__BUCKET_INDEX__RANGE_0_1 = 1;
    public static final int DISPLAY_BRIGHTNESS_CHANGED__BUCKET_INDEX__RANGE_1_2 = 2;
    public static final int DISPLAY_BRIGHTNESS_CHANGED__BUCKET_INDEX__RANGE_2_3 = 3;
    public static final int DISPLAY_BRIGHTNESS_CHANGED__BUCKET_INDEX__RANGE_3_4 = 4;
    public static final int DISPLAY_BRIGHTNESS_CHANGED__BUCKET_INDEX__RANGE_4_5 = 5;
    public static final int DISPLAY_BRIGHTNESS_CHANGED__BUCKET_INDEX__RANGE_5_6 = 6;
    public static final int DISPLAY_BRIGHTNESS_CHANGED__BUCKET_INDEX__RANGE_6_7 = 7;
    public static final int DISPLAY_BRIGHTNESS_CHANGED__BUCKET_INDEX__RANGE_7_8 = 8;
    public static final int DISPLAY_BRIGHTNESS_CHANGED__BUCKET_INDEX__RANGE_8_9 = 9;
    public static final int DISPLAY_BRIGHTNESS_CHANGED__BUCKET_INDEX__RANGE_9_10 = 10;
    public static final int DISPLAY_BRIGHTNESS_CHANGED__BUCKET_INDEX__RANGE_10_20 = 11;
    public static final int DISPLAY_BRIGHTNESS_CHANGED__BUCKET_INDEX__RANGE_20_30 = 12;
    public static final int DISPLAY_BRIGHTNESS_CHANGED__BUCKET_INDEX__RANGE_30_40 = 13;
    public static final int DISPLAY_BRIGHTNESS_CHANGED__BUCKET_INDEX__RANGE_40_50 = 14;
    public static final int DISPLAY_BRIGHTNESS_CHANGED__BUCKET_INDEX__RANGE_50_60 = 15;
    public static final int DISPLAY_BRIGHTNESS_CHANGED__BUCKET_INDEX__RANGE_60_70 = 16;
    public static final int DISPLAY_BRIGHTNESS_CHANGED__BUCKET_INDEX__RANGE_70_80 = 17;
    public static final int DISPLAY_BRIGHTNESS_CHANGED__BUCKET_INDEX__RANGE_80_90 = 18;
    public static final int DISPLAY_BRIGHTNESS_CHANGED__BUCKET_INDEX__RANGE_90_100 = 19;
    public static final int DISPLAY_BRIGHTNESS_CHANGED__BUCKET_INDEX__RANGE_100_200 = 20;
    public static final int DISPLAY_BRIGHTNESS_CHANGED__BUCKET_INDEX__RANGE_200_300 = 21;
    public static final int DISPLAY_BRIGHTNESS_CHANGED__BUCKET_INDEX__RANGE_300_400 = 22;
    public static final int DISPLAY_BRIGHTNESS_CHANGED__BUCKET_INDEX__RANGE_400_500 = 23;
    public static final int DISPLAY_BRIGHTNESS_CHANGED__BUCKET_INDEX__RANGE_500_600 = 24;
    public static final int DISPLAY_BRIGHTNESS_CHANGED__BUCKET_INDEX__RANGE_600_700 = 25;
    public static final int DISPLAY_BRIGHTNESS_CHANGED__BUCKET_INDEX__RANGE_700_800 = 26;
    public static final int DISPLAY_BRIGHTNESS_CHANGED__BUCKET_INDEX__RANGE_800_900 = 27;
    public static final int DISPLAY_BRIGHTNESS_CHANGED__BUCKET_INDEX__RANGE_900_1000 = 28;
    public static final int DISPLAY_BRIGHTNESS_CHANGED__BUCKET_INDEX__RANGE_1000_1200 = 29;
    public static final int DISPLAY_BRIGHTNESS_CHANGED__BUCKET_INDEX__RANGE_1200_1400 = 30;
    public static final int DISPLAY_BRIGHTNESS_CHANGED__BUCKET_INDEX__RANGE_1400_1600 = 31;
    public static final int DISPLAY_BRIGHTNESS_CHANGED__BUCKET_INDEX__RANGE_1600_1800 = 32;
    public static final int DISPLAY_BRIGHTNESS_CHANGED__BUCKET_INDEX__RANGE_1800_2000 = 33;
    public static final int DISPLAY_BRIGHTNESS_CHANGED__BUCKET_INDEX__RANGE_2000_2250 = 34;
    public static final int DISPLAY_BRIGHTNESS_CHANGED__BUCKET_INDEX__RANGE_2250_2500 = 35;
    public static final int DISPLAY_BRIGHTNESS_CHANGED__BUCKET_INDEX__RANGE_2500_2750 = 36;
    public static final int DISPLAY_BRIGHTNESS_CHANGED__BUCKET_INDEX__RANGE_2750_3000 = 37;
    public static final int DISPLAY_BRIGHTNESS_CHANGED__BUCKET_INDEX__RANGE_3000_INF = 38;

    // Values for ActivityActionBlocked.action
    public static final int ACTIVITY_ACTION_BLOCKED__ACTION__ACTION_UNSPECIFIED = 0;
    public static final int ACTIVITY_ACTION_BLOCKED__ACTION__ACTIVITY_START_SAME_TASK = 1;
    public static final int ACTIVITY_ACTION_BLOCKED__ACTION__ACTIVITY_START_DIFFERENT_TASK = 2;
    public static final int ACTIVITY_ACTION_BLOCKED__ACTION__ACTIVITY_START_NEW_TASK = 3;
    public static final int ACTIVITY_ACTION_BLOCKED__ACTION__FINISH_TASK = 4;

    // Values for HearingAidInfoReported.device_mode
    public static final int HEARING_AID_INFO_REPORTED__DEVICE_MODE__MODE_UNKNOWN = -1;
    public static final int HEARING_AID_INFO_REPORTED__DEVICE_MODE__MONAURAL = 0;
    public static final int HEARING_AID_INFO_REPORTED__DEVICE_MODE__BINAURAL = 1;
    public static final int HEARING_AID_INFO_REPORTED__DEVICE_MODE__BANDED = 2;

    // Values for HearingAidInfoReported.device_side
    public static final int HEARING_AID_INFO_REPORTED__DEVICE_SIDE__SIDE_UNKNOWN = -1;
    public static final int HEARING_AID_INFO_REPORTED__DEVICE_SIDE__LEFT = 0;
    public static final int HEARING_AID_INFO_REPORTED__DEVICE_SIDE__RIGHT = 1;
    public static final int HEARING_AID_INFO_REPORTED__DEVICE_SIDE__LEFT_AND_RIGHT = 2;

    // Values for HearingAidInfoReported.bond_entry
    public static final int HEARING_AID_INFO_REPORTED__BOND_ENTRY__PAGE_UNKNOWN = -1;
    public static final int HEARING_AID_INFO_REPORTED__BOND_ENTRY__CONNECTED_DEVICES = 0;
    public static final int HEARING_AID_INFO_REPORTED__BOND_ENTRY__ACCESSIBILITY_HEARING_AIDS = 1;
    public static final int HEARING_AID_INFO_REPORTED__BOND_ENTRY__ACCESSIBILITY_HEARING_AID_PAIR_ANOTHER = 2;
    public static final int HEARING_AID_INFO_REPORTED__BOND_ENTRY__BLUETOOTH = 3;

    // Values for DeviceWideJobConstraintChanged.constraint
    public static final int DEVICE_WIDE_JOB_CONSTRAINT_CHANGED__CONSTRAINT__CONSTRAINT_UNKNOWN = 0;
    public static final int DEVICE_WIDE_JOB_CONSTRAINT_CHANGED__CONSTRAINT__CONSTRAINT_CHARGING = 1;
    public static final int DEVICE_WIDE_JOB_CONSTRAINT_CHANGED__CONSTRAINT__CONSTRAINT_BATTERY_NOT_LOW = 2;
    public static final int DEVICE_WIDE_JOB_CONSTRAINT_CHANGED__CONSTRAINT__CONSTRAINT_STORAGE_NOT_LOW = 3;
    public static final int DEVICE_WIDE_JOB_CONSTRAINT_CHANGED__CONSTRAINT__CONSTRAINT_TIMING_DELAY = 4;
    public static final int DEVICE_WIDE_JOB_CONSTRAINT_CHANGED__CONSTRAINT__CONSTRAINT_DEADLINE = 5;
    public static final int DEVICE_WIDE_JOB_CONSTRAINT_CHANGED__CONSTRAINT__CONSTRAINT_IDLE = 6;
    public static final int DEVICE_WIDE_JOB_CONSTRAINT_CHANGED__CONSTRAINT__CONSTRAINT_CONNECTIVITY = 7;
    public static final int DEVICE_WIDE_JOB_CONSTRAINT_CHANGED__CONSTRAINT__CONSTRAINT_CONTENT_TRIGGER = 8;
    public static final int DEVICE_WIDE_JOB_CONSTRAINT_CHANGED__CONSTRAINT__CONSTRAINT_DEVICE_NOT_DOZING = 9;
    public static final int DEVICE_WIDE_JOB_CONSTRAINT_CHANGED__CONSTRAINT__CONSTRAINT_WITHIN_QUOTA = 10;
    public static final int DEVICE_WIDE_JOB_CONSTRAINT_CHANGED__CONSTRAINT__CONSTRAINT_BACKGROUND_NOT_RESTRICTED = 11;
    public static final int DEVICE_WIDE_JOB_CONSTRAINT_CHANGED__CONSTRAINT__CONSTRAINT_WITHIN_EXPEDITED_JOB_QUOTA = 12;
    public static final int DEVICE_WIDE_JOB_CONSTRAINT_CHANGED__CONSTRAINT__CONSTRAINT_TARE_WEALTH = 13;
    public static final int DEVICE_WIDE_JOB_CONSTRAINT_CHANGED__CONSTRAINT__CONSTRAINT_PREFETCH = 14;
    public static final int DEVICE_WIDE_JOB_CONSTRAINT_CHANGED__CONSTRAINT__CONSTRAINT_FLEXIBILITY = 15;

    // Values for DeviceWideJobConstraintChanged.state
    public static final int DEVICE_WIDE_JOB_CONSTRAINT_CHANGED__STATE__UNKNOWN = 0;
    public static final int DEVICE_WIDE_JOB_CONSTRAINT_CHANGED__STATE__UNSATISFIED = 1;
    public static final int DEVICE_WIDE_JOB_CONSTRAINT_CHANGED__STATE__SATISFIED = 2;

    // Values for AmbientModeChanged.state
    public static final int AMBIENT_MODE_CHANGED__STATE__AMBIENT_ENTER = 1;
    public static final int AMBIENT_MODE_CHANGED__STATE__AMBIENT_EXIT = 2;
    public static final int AMBIENT_MODE_CHANGED__STATE__AMBIENT_LITE_ENTER = 3;
    public static final int AMBIENT_MODE_CHANGED__STATE__AMBIENT_LITE_EXIT = 4;
    public static final int AMBIENT_MODE_CHANGED__STATE__OFFLOAD_ENTER = 5;
    public static final int AMBIENT_MODE_CHANGED__STATE__OFFLOAD_EXIT = 6;

    // Values for ANRLatencyReported.anr_type
    public static final int ANRLATENCY_REPORTED__ANR_TYPE__UNKNOWN_ANR_TYPE = 0;
    public static final int ANRLATENCY_REPORTED__ANR_TYPE__BROADCAST_OF_INTENT = 1;
    public static final int ANRLATENCY_REPORTED__ANR_TYPE__EXECUTING_SERVICE = 2;
    public static final int ANRLATENCY_REPORTED__ANR_TYPE__START_FOREGROUND_SERVICE = 3;
    public static final int ANRLATENCY_REPORTED__ANR_TYPE__INPUT_DISPATCHING_TIMEOUT_NO_FOCUSED_WINDOW = 4;
    public static final int ANRLATENCY_REPORTED__ANR_TYPE__INPUT_DISPATCHING_TIMEOUT = 5;
    public static final int ANRLATENCY_REPORTED__ANR_TYPE__CONTENT_PROVIDER_NOT_RESPONDING = 6;
    public static final int ANRLATENCY_REPORTED__ANR_TYPE__SHORT_FGS_TIMEOUT = 7;

    // Values for ResourceValueApiStatisticsReported.api
    public static final int RESOURCE_VALUE_API_STATISTICS_REPORTED__API__RESOURCE_API_NONE = 0;
    public static final int RESOURCE_VALUE_API_STATISTICS_REPORTED__API__RESOURCE_API_GET_VALUE = 1;
    public static final int RESOURCE_VALUE_API_STATISTICS_REPORTED__API__RESOURCE_API_RETRIEVE_ATTRIBUTES = 2;

    // Values for PackageManagerAppsFilterCacheBuildReported.event_type
    public static final int PACKAGE_MANAGER_APPS_FILTER_CACHE_BUILD_REPORTED__EVENT_TYPE__UNSPECIFIED = 0;
    public static final int PACKAGE_MANAGER_APPS_FILTER_CACHE_BUILD_REPORTED__EVENT_TYPE__BOOT = 1;
    public static final int PACKAGE_MANAGER_APPS_FILTER_CACHE_BUILD_REPORTED__EVENT_TYPE__USER_CREATED = 2;
    public static final int PACKAGE_MANAGER_APPS_FILTER_CACHE_BUILD_REPORTED__EVENT_TYPE__USER_DELETED = 3;

    // Values for PackageManagerAppsFilterCacheUpdateReported.event_type
    public static final int PACKAGE_MANAGER_APPS_FILTER_CACHE_UPDATE_REPORTED__EVENT_TYPE__UNSPECIFIED = 0;
    public static final int PACKAGE_MANAGER_APPS_FILTER_CACHE_UPDATE_REPORTED__EVENT_TYPE__PACKAGE_ADDED = 1;
    public static final int PACKAGE_MANAGER_APPS_FILTER_CACHE_UPDATE_REPORTED__EVENT_TYPE__PACKAGE_DELETED = 2;
    public static final int PACKAGE_MANAGER_APPS_FILTER_CACHE_UPDATE_REPORTED__EVENT_TYPE__PACKAGE_REPLACED = 3;
    public static final int PACKAGE_MANAGER_APPS_FILTER_CACHE_UPDATE_REPORTED__EVENT_TYPE__COMPAT_CHANGED = 4;

    // Values for GameModeChanged.game_mode_from
    public static final int GAME_MODE_CHANGED__GAME_MODE_FROM__GAME_MODE_UNSPECIFIED = 0;
    public static final int GAME_MODE_CHANGED__GAME_MODE_FROM__GAME_MODE_UNSUPPORTED = 1;
    public static final int GAME_MODE_CHANGED__GAME_MODE_FROM__GAME_MODE_STANDARD = 2;
    public static final int GAME_MODE_CHANGED__GAME_MODE_FROM__GAME_MODE_PERFORMANCE = 3;
    public static final int GAME_MODE_CHANGED__GAME_MODE_FROM__GAME_MODE_BATTERY = 4;
    public static final int GAME_MODE_CHANGED__GAME_MODE_FROM__GAME_MODE_CUSTOM = 5;

    // Values for GameModeChanged.game_mode_to
    public static final int GAME_MODE_CHANGED__GAME_MODE_TO__GAME_MODE_UNSPECIFIED = 0;
    public static final int GAME_MODE_CHANGED__GAME_MODE_TO__GAME_MODE_UNSUPPORTED = 1;
    public static final int GAME_MODE_CHANGED__GAME_MODE_TO__GAME_MODE_STANDARD = 2;
    public static final int GAME_MODE_CHANGED__GAME_MODE_TO__GAME_MODE_PERFORMANCE = 3;
    public static final int GAME_MODE_CHANGED__GAME_MODE_TO__GAME_MODE_BATTERY = 4;
    public static final int GAME_MODE_CHANGED__GAME_MODE_TO__GAME_MODE_CUSTOM = 5;

    // Values for GameModeConfigurationChanged.game_mode
    public static final int GAME_MODE_CONFIGURATION_CHANGED__GAME_MODE__GAME_MODE_UNSPECIFIED = 0;
    public static final int GAME_MODE_CONFIGURATION_CHANGED__GAME_MODE__GAME_MODE_UNSUPPORTED = 1;
    public static final int GAME_MODE_CONFIGURATION_CHANGED__GAME_MODE__GAME_MODE_STANDARD = 2;
    public static final int GAME_MODE_CONFIGURATION_CHANGED__GAME_MODE__GAME_MODE_PERFORMANCE = 3;
    public static final int GAME_MODE_CONFIGURATION_CHANGED__GAME_MODE__GAME_MODE_BATTERY = 4;
    public static final int GAME_MODE_CONFIGURATION_CHANGED__GAME_MODE__GAME_MODE_CUSTOM = 5;

    // Values for BedtimeModeStateChanged.bedtime_mode_state
    public static final int BEDTIME_MODE_STATE_CHANGED__BEDTIME_MODE_STATE__BEDTIME_OFF = 0;
    public static final int BEDTIME_MODE_STATE_CHANGED__BEDTIME_MODE_STATE__BEDTIME_ON = 1;

    // Values for BedtimeModeStateChanged.current_wifi_state
    public static final int BEDTIME_MODE_STATE_CHANGED__CURRENT_WIFI_STATE__OFF = 0;
    public static final int BEDTIME_MODE_STATE_CHANGED__CURRENT_WIFI_STATE__ON = 1;

    // Values for BedtimeModeStateChanged.current_cellular_state
    public static final int BEDTIME_MODE_STATE_CHANGED__CURRENT_CELLULAR_STATE__OFF = 0;
    public static final int BEDTIME_MODE_STATE_CHANGED__CURRENT_CELLULAR_STATE__ON = 1;

    // Values for BedtimeModeStateChanged.current_bluetooth_state
    public static final int BEDTIME_MODE_STATE_CHANGED__CURRENT_BLUETOOTH_STATE__OFF = 0;
    public static final int BEDTIME_MODE_STATE_CHANGED__CURRENT_BLUETOOTH_STATE__ON = 1;

    // Values for GetTypeAccessedWithoutPermission.location
    public static final int GET_TYPE_ACCESSED_WITHOUT_PERMISSION__LOCATION__UNSPECIFIED = 0;
    public static final int GET_TYPE_ACCESSED_WITHOUT_PERMISSION__LOCATION__AM_FRAMEWORK_PERMISSION = 1;
    public static final int GET_TYPE_ACCESSED_WITHOUT_PERMISSION__LOCATION__AM_CHECK_URI_PERMISSION = 2;
    public static final int GET_TYPE_ACCESSED_WITHOUT_PERMISSION__LOCATION__AM_ERROR = 3;
    public static final int GET_TYPE_ACCESSED_WITHOUT_PERMISSION__LOCATION__PROVIDER_FRAMEWORK_PERMISSION = 4;
    public static final int GET_TYPE_ACCESSED_WITHOUT_PERMISSION__LOCATION__PROVIDER_CHECK_URI_PERMISSION = 5;
    public static final int GET_TYPE_ACCESSED_WITHOUT_PERMISSION__LOCATION__PROVIDER_ERROR = 6;

    // Values for MobileBundledAppInfoGathered.algo_type
    public static final int MOBILE_BUNDLED_APP_INFO_GATHERED__ALGO_TYPE__UNKNOWN = 0;
    public static final int MOBILE_BUNDLED_APP_INFO_GATHERED__ALGO_TYPE__CHUNKED_SHA256 = 1;
    public static final int MOBILE_BUNDLED_APP_INFO_GATHERED__ALGO_TYPE__CHUNKED_SHA512 = 2;
    public static final int MOBILE_BUNDLED_APP_INFO_GATHERED__ALGO_TYPE__VERITY_CHUNKED_SHA256 = 3;
    public static final int MOBILE_BUNDLED_APP_INFO_GATHERED__ALGO_TYPE__SHA256 = 4;

    // Values for MobileBundledAppInfoGathered.mba_status
    public static final int MOBILE_BUNDLED_APP_INFO_GATHERED__MBA_STATUS__ERROR = 0;
    public static final int MOBILE_BUNDLED_APP_INFO_GATHERED__MBA_STATUS__PRELOADED = 1;
    public static final int MOBILE_BUNDLED_APP_INFO_GATHERED__MBA_STATUS__UPDATED_PRELOAD = 2;
    public static final int MOBILE_BUNDLED_APP_INFO_GATHERED__MBA_STATUS__NEW_MBA = 3;
    public static final int MOBILE_BUNDLED_APP_INFO_GATHERED__MBA_STATUS__UPDATED_NEW_MBA = 4;

    // Values for UnsafeIntentEventReported.event_type
    public static final int UNSAFE_INTENT_EVENT_REPORTED__EVENT_TYPE__UNKNOWN = 0;
    public static final int UNSAFE_INTENT_EVENT_REPORTED__EVENT_TYPE__NULL_ACTION_MATCH = 1;
    public static final int UNSAFE_INTENT_EVENT_REPORTED__EVENT_TYPE__INTERNAL_NON_EXPORTED_COMPONENT_MATCH = 2;
    public static final int UNSAFE_INTENT_EVENT_REPORTED__EVENT_TYPE__EXPLICIT_INTENT_FILTER_UNMATCH = 3;
    public static final int UNSAFE_INTENT_EVENT_REPORTED__EVENT_TYPE__NEW_MUTABLE_IMPLICIT_PENDING_INTENT_RETRIEVED = 4;

    // Values for HotwordAudioEgressEventReported.detector_type
    public static final int HOTWORD_AUDIO_EGRESS_EVENT_REPORTED__DETECTOR_TYPE__NORMAL_DETECTOR = 0;
    public static final int HOTWORD_AUDIO_EGRESS_EVENT_REPORTED__DETECTOR_TYPE__TRUSTED_DETECTOR_DSP = 1;
    public static final int HOTWORD_AUDIO_EGRESS_EVENT_REPORTED__DETECTOR_TYPE__TRUSTED_DETECTOR_SOFTWARE = 2;

    // Values for HotwordAudioEgressEventReported.event
    public static final int HOTWORD_AUDIO_EGRESS_EVENT_REPORTED__EVENT__UNKNOWN = 0;
    public static final int HOTWORD_AUDIO_EGRESS_EVENT_REPORTED__EVENT__STARTED = 1;
    public static final int HOTWORD_AUDIO_EGRESS_EVENT_REPORTED__EVENT__ENDED = 2;
    public static final int HOTWORD_AUDIO_EGRESS_EVENT_REPORTED__EVENT__INTERRUPTED_EXCEPTION = 3;
    public static final int HOTWORD_AUDIO_EGRESS_EVENT_REPORTED__EVENT__NO_PERMISSION = 4;
    public static final int HOTWORD_AUDIO_EGRESS_EVENT_REPORTED__EVENT__INACTIVE_CLIENT = 5;
    public static final int HOTWORD_AUDIO_EGRESS_EVENT_REPORTED__EVENT__INACTIVE_HOTWORD_DETECTION_SERVICE = 6;
    public static final int HOTWORD_AUDIO_EGRESS_EVENT_REPORTED__EVENT__EMPTY_AUDIO_STREAM_LIST = 7;
    public static final int HOTWORD_AUDIO_EGRESS_EVENT_REPORTED__EVENT__SOURCE_IS_EMPTY = 8;
    public static final int HOTWORD_AUDIO_EGRESS_EVENT_REPORTED__EVENT__ILLEGAL_COPY_BUFFER_SIZE = 9;
    public static final int HOTWORD_AUDIO_EGRESS_EVENT_REPORTED__EVENT__CLOSE_ERROR_FROM_SYSTEM = 10;
    public static final int HOTWORD_AUDIO_EGRESS_EVENT_REPORTED__EVENT__CLOSE_ERROR_FROM_CLIENT = 11;
    public static final int HOTWORD_AUDIO_EGRESS_EVENT_REPORTED__EVENT__CLOSE_ERROR_FROM_HOTWORD_DETECTION_SERVICE = 12;

    // Values for ImeRequestFinished.type
    public static final int IME_REQUEST_FINISHED__TYPE__TYPE_NOT_SET = 0;
    public static final int IME_REQUEST_FINISHED__TYPE__TYPE_SHOW = 1;
    public static final int IME_REQUEST_FINISHED__TYPE__TYPE_HIDE = 2;

    // Values for ImeRequestFinished.status
    public static final int IME_REQUEST_FINISHED__STATUS__STATUS_NOT_SET = 0;
    public static final int IME_REQUEST_FINISHED__STATUS__STATUS_RUN = 1;
    public static final int IME_REQUEST_FINISHED__STATUS__STATUS_CANCEL = 2;
    public static final int IME_REQUEST_FINISHED__STATUS__STATUS_FAIL = 3;
    public static final int IME_REQUEST_FINISHED__STATUS__STATUS_SUCCESS = 4;
    public static final int IME_REQUEST_FINISHED__STATUS__STATUS_TIMEOUT = 5;

    // Values for ImeRequestFinished.reason
    public static final int IME_REQUEST_FINISHED__REASON__REASON_NOT_SET = 0;
    public static final int IME_REQUEST_FINISHED__REASON__REASON_SHOW_SOFT_INPUT = 1;
    public static final int IME_REQUEST_FINISHED__REASON__REASON_ATTACH_NEW_INPUT = 2;
    public static final int IME_REQUEST_FINISHED__REASON__REASON_SHOW_SOFT_INPUT_FROM_IME = 3;
    public static final int IME_REQUEST_FINISHED__REASON__REASON_HIDE_SOFT_INPUT = 4;
    public static final int IME_REQUEST_FINISHED__REASON__REASON_HIDE_SOFT_INPUT_FROM_IME = 5;
    public static final int IME_REQUEST_FINISHED__REASON__REASON_SHOW_AUTO_EDITOR_FORWARD_NAV = 6;
    public static final int IME_REQUEST_FINISHED__REASON__REASON_SHOW_STATE_VISIBLE_FORWARD_NAV = 7;
    public static final int IME_REQUEST_FINISHED__REASON__REASON_SHOW_STATE_ALWAYS_VISIBLE = 8;
    public static final int IME_REQUEST_FINISHED__REASON__REASON_SHOW_SETTINGS_ON_CHANGE = 9;
    public static final int IME_REQUEST_FINISHED__REASON__REASON_HIDE_SWITCH_USER = 10;
    public static final int IME_REQUEST_FINISHED__REASON__REASON_HIDE_INVALID_USER = 11;
    public static final int IME_REQUEST_FINISHED__REASON__REASON_HIDE_UNSPECIFIED_WINDOW = 12;
    public static final int IME_REQUEST_FINISHED__REASON__REASON_HIDE_STATE_HIDDEN_FORWARD_NAV = 13;
    public static final int IME_REQUEST_FINISHED__REASON__REASON_HIDE_ALWAYS_HIDDEN_STATE = 14;
    public static final int IME_REQUEST_FINISHED__REASON__REASON_HIDE_RESET_SHELL_COMMAND = 15;
    public static final int IME_REQUEST_FINISHED__REASON__REASON_HIDE_SETTINGS_ON_CHANGE = 16;
    public static final int IME_REQUEST_FINISHED__REASON__REASON_HIDE_POWER_BUTTON_GO_HOME = 17;
    public static final int IME_REQUEST_FINISHED__REASON__REASON_HIDE_DOCKED_STACK_ATTACHED = 18;
    public static final int IME_REQUEST_FINISHED__REASON__REASON_HIDE_RECENTS_ANIMATION = 19;
    public static final int IME_REQUEST_FINISHED__REASON__REASON_HIDE_BUBBLES = 20;
    public static final int IME_REQUEST_FINISHED__REASON__REASON_HIDE_SAME_WINDOW_FOCUSED_WITHOUT_EDITOR = 21;
    public static final int IME_REQUEST_FINISHED__REASON__REASON_HIDE_REMOVE_CLIENT = 22;
    public static final int IME_REQUEST_FINISHED__REASON__REASON_SHOW_RESTORE_IME_VISIBILITY = 23;
    public static final int IME_REQUEST_FINISHED__REASON__REASON_SHOW_TOGGLE_SOFT_INPUT = 24;
    public static final int IME_REQUEST_FINISHED__REASON__REASON_HIDE_TOGGLE_SOFT_INPUT = 25;
    public static final int IME_REQUEST_FINISHED__REASON__REASON_SHOW_SOFT_INPUT_BY_INSETS_API = 26;
    public static final int IME_REQUEST_FINISHED__REASON__REASON_HIDE_DISPLAY_IME_POLICY_HIDE = 27;
    public static final int IME_REQUEST_FINISHED__REASON__REASON_HIDE_SOFT_INPUT_BY_INSETS_API = 28;
    public static final int IME_REQUEST_FINISHED__REASON__REASON_HIDE_SOFT_INPUT_BY_BACK_KEY = 29;
    public static final int IME_REQUEST_FINISHED__REASON__REASON_HIDE_SOFT_INPUT_IME_TOGGLE_SOFT_INPUT = 30;
    public static final int IME_REQUEST_FINISHED__REASON__REASON_HIDE_SOFT_INPUT_EXTRACT_INPUT_CHANGED = 31;
    public static final int IME_REQUEST_FINISHED__REASON__REASON_HIDE_SOFT_INPUT_IMM_DEPRECATION = 32;
    public static final int IME_REQUEST_FINISHED__REASON__REASON_HIDE_WINDOW_GAINED_FOCUS_WITHOUT_EDITOR = 33;
    public static final int IME_REQUEST_FINISHED__REASON__REASON_SHOW_IME_SCREENSHOT_FROM_IMMS = 34;
    public static final int IME_REQUEST_FINISHED__REASON__REASON_REMOVE_IME_SCREENSHOT_FROM_IMMS = 35;
    public static final int IME_REQUEST_FINISHED__REASON__REASON_UPDATE_IME_PARENT_FROM_IMMS = 36;
    public static final int IME_REQUEST_FINISHED__REASON__REASON_HIDE_WHEN_INPUT_TARGET_INVISIBLE = 37;

    // Values for ImeRequestFinished.origin
    public static final int IME_REQUEST_FINISHED__ORIGIN__ORIGIN_NOT_SET = 0;
    public static final int IME_REQUEST_FINISHED__ORIGIN__ORIGIN_CLIENT_SHOW_SOFT_INPUT = 1;
    public static final int IME_REQUEST_FINISHED__ORIGIN__ORIGIN_CLIENT_HIDE_SOFT_INPUT = 2;
    public static final int IME_REQUEST_FINISHED__ORIGIN__ORIGIN_SERVER_START_INPUT = 3;
    public static final int IME_REQUEST_FINISHED__ORIGIN__ORIGIN_SERVER_HIDE_INPUT = 4;

    // Values for ImeRequestFinished.phase
    public static final int IME_REQUEST_FINISHED__PHASE__PHASE_NOT_SET = 0;
    public static final int IME_REQUEST_FINISHED__PHASE__PHASE_CLIENT_VIEW_SERVED = 1;
    public static final int IME_REQUEST_FINISHED__PHASE__PHASE_SERVER_CLIENT_KNOWN = 2;
    public static final int IME_REQUEST_FINISHED__PHASE__PHASE_SERVER_CLIENT_FOCUSED = 3;
    public static final int IME_REQUEST_FINISHED__PHASE__PHASE_SERVER_ACCESSIBILITY = 4;
    public static final int IME_REQUEST_FINISHED__PHASE__PHASE_SERVER_SYSTEM_READY = 5;
    public static final int IME_REQUEST_FINISHED__PHASE__PHASE_SERVER_HIDE_IMPLICIT = 6;
    public static final int IME_REQUEST_FINISHED__PHASE__PHASE_SERVER_HIDE_NOT_ALWAYS = 7;
    public static final int IME_REQUEST_FINISHED__PHASE__PHASE_SERVER_WAIT_IME = 8;
    public static final int IME_REQUEST_FINISHED__PHASE__PHASE_SERVER_HAS_IME = 9;
    public static final int IME_REQUEST_FINISHED__PHASE__PHASE_SERVER_SHOULD_HIDE = 10;
    public static final int IME_REQUEST_FINISHED__PHASE__PHASE_IME_WRAPPER = 11;
    public static final int IME_REQUEST_FINISHED__PHASE__PHASE_IME_WRAPPER_DISPATCH = 12;
    public static final int IME_REQUEST_FINISHED__PHASE__PHASE_IME_SHOW_SOFT_INPUT = 13;
    public static final int IME_REQUEST_FINISHED__PHASE__PHASE_IME_HIDE_SOFT_INPUT = 14;
    public static final int IME_REQUEST_FINISHED__PHASE__PHASE_IME_ON_SHOW_SOFT_INPUT_TRUE = 15;
    public static final int IME_REQUEST_FINISHED__PHASE__PHASE_IME_APPLY_VISIBILITY_INSETS_CONSUMER = 16;
    public static final int IME_REQUEST_FINISHED__PHASE__PHASE_SERVER_APPLY_IME_VISIBILITY = 17;
    public static final int IME_REQUEST_FINISHED__PHASE__PHASE_WM_SHOW_IME_RUNNER = 18;
    public static final int IME_REQUEST_FINISHED__PHASE__PHASE_WM_SHOW_IME_READY = 19;
    public static final int IME_REQUEST_FINISHED__PHASE__PHASE_WM_HAS_IME_INSETS_CONTROL_TARGET = 20;
    public static final int IME_REQUEST_FINISHED__PHASE__PHASE_WM_WINDOW_INSETS_CONTROL_TARGET_SHOW_INSETS = 21;
    public static final int IME_REQUEST_FINISHED__PHASE__PHASE_WM_WINDOW_INSETS_CONTROL_TARGET_HIDE_INSETS = 22;
    public static final int IME_REQUEST_FINISHED__PHASE__PHASE_WM_REMOTE_INSETS_CONTROL_TARGET_SHOW_INSETS = 23;
    public static final int IME_REQUEST_FINISHED__PHASE__PHASE_WM_REMOTE_INSETS_CONTROL_TARGET_HIDE_INSETS = 24;
    public static final int IME_REQUEST_FINISHED__PHASE__PHASE_WM_REMOTE_INSETS_CONTROLLER = 25;
    public static final int IME_REQUEST_FINISHED__PHASE__PHASE_WM_ANIMATION_CREATE = 26;
    public static final int IME_REQUEST_FINISHED__PHASE__PHASE_WM_ANIMATION_RUNNING = 27;
    public static final int IME_REQUEST_FINISHED__PHASE__PHASE_CLIENT_SHOW_INSETS = 28;
    public static final int IME_REQUEST_FINISHED__PHASE__PHASE_CLIENT_HIDE_INSETS = 29;
    public static final int IME_REQUEST_FINISHED__PHASE__PHASE_CLIENT_HANDLE_SHOW_INSETS = 30;
    public static final int IME_REQUEST_FINISHED__PHASE__PHASE_CLIENT_HANDLE_HIDE_INSETS = 31;
    public static final int IME_REQUEST_FINISHED__PHASE__PHASE_CLIENT_APPLY_ANIMATION = 32;
    public static final int IME_REQUEST_FINISHED__PHASE__PHASE_CLIENT_CONTROL_ANIMATION = 33;
    public static final int IME_REQUEST_FINISHED__PHASE__PHASE_CLIENT_DISABLED_USER_ANIMATION = 34;
    public static final int IME_REQUEST_FINISHED__PHASE__PHASE_CLIENT_COLLECT_SOURCE_CONTROLS = 35;
    public static final int IME_REQUEST_FINISHED__PHASE__PHASE_CLIENT_INSETS_CONSUMER_REQUEST_SHOW = 36;
    public static final int IME_REQUEST_FINISHED__PHASE__PHASE_CLIENT_REQUEST_IME_SHOW = 37;
    public static final int IME_REQUEST_FINISHED__PHASE__PHASE_CLIENT_INSETS_CONSUMER_NOTIFY_HIDDEN = 38;
    public static final int IME_REQUEST_FINISHED__PHASE__PHASE_CLIENT_ANIMATION_RUNNING = 39;
    public static final int IME_REQUEST_FINISHED__PHASE__PHASE_CLIENT_ANIMATION_CANCEL = 40;
    public static final int IME_REQUEST_FINISHED__PHASE__PHASE_CLIENT_ANIMATION_FINISHED_SHOW = 41;
    public static final int IME_REQUEST_FINISHED__PHASE__PHASE_CLIENT_ANIMATION_FINISHED_HIDE = 42;

    // Values for UsbComplianceWarningsReported.compliance_warnings
    public static final int USB_COMPLIANCE_WARNINGS_REPORTED__COMPLIANCE_WARNINGS__COMPLIANCE_WARNING_UNSPECIFIED = 0;
    public static final int USB_COMPLIANCE_WARNINGS_REPORTED__COMPLIANCE_WARNINGS__COMPLIANCE_WARNING_DEBUG_ACCESSORY = 1;
    public static final int USB_COMPLIANCE_WARNINGS_REPORTED__COMPLIANCE_WARNINGS__COMPLIANCE_WARNING_BC_1_2 = 2;
    public static final int USB_COMPLIANCE_WARNINGS_REPORTED__COMPLIANCE_WARNINGS__COMPLIANCE_WARNING_MISSING_RP = 3;
    public static final int USB_COMPLIANCE_WARNINGS_REPORTED__COMPLIANCE_WARNINGS__COMPLIANCE_WARNING_OTHER = 4;

    // Values for AppSupportedLocalesChanged.status
    public static final int APP_SUPPORTED_LOCALES_CHANGED__STATUS__STATUS_UNSPECIFIED = 0;
    public static final int APP_SUPPORTED_LOCALES_CHANGED__STATUS__SUCCESS = 1;
    public static final int APP_SUPPORTED_LOCALES_CHANGED__STATUS__FAILURE_WRITE_TO_STORAGE = 2;
    public static final int APP_SUPPORTED_LOCALES_CHANGED__STATUS__FAILURE_INVALID_TARGET_PACKAGE = 3;
    public static final int APP_SUPPORTED_LOCALES_CHANGED__STATUS__FAILURE_PERMISSION_ABSENT = 4;

    // Values for ApplicationGrammaticalInflectionChanged.source_id
    public static final int APPLICATION_GRAMMATICAL_INFLECTION_CHANGED__SOURCE_ID__UNKNOWN = 0;
    public static final int APPLICATION_GRAMMATICAL_INFLECTION_CHANGED__SOURCE_ID__FRAMEWORKS = 1;
    public static final int APPLICATION_GRAMMATICAL_INFLECTION_CHANGED__SOURCE_ID__OTHERS = 2;

    // Values for CredentialManagerApiCalled.api_name
    public static final int CREDENTIAL_MANAGER_API_CALLED__API_NAME__API_NAME_UNKNOWN = 0;
    public static final int CREDENTIAL_MANAGER_API_CALLED__API_NAME__API_NAME_GET_CREDENTIAL = 1;
    public static final int CREDENTIAL_MANAGER_API_CALLED__API_NAME__API_NAME_CREATE_CREDENTIAL = 2;
    public static final int CREDENTIAL_MANAGER_API_CALLED__API_NAME__API_NAME_CLEAR_CREDENTIAL = 3;
    public static final int CREDENTIAL_MANAGER_API_CALLED__API_NAME__API_NAME_IS_ENABLED_CREDENTIAL_PROVIDER_SERVICE = 4;
    public static final int CREDENTIAL_MANAGER_API_CALLED__API_NAME__API_NAME_SET_ENABLED_PROVIDERS = 5;
    public static final int CREDENTIAL_MANAGER_API_CALLED__API_NAME__API_NAME_GET_CREDENTIAL_PROVIDER_SERVICES = 6;
    public static final int CREDENTIAL_MANAGER_API_CALLED__API_NAME__API_NAME_REGISTER_CREDENTIAL_DESCRIPTION = 7;
    public static final int CREDENTIAL_MANAGER_API_CALLED__API_NAME__API_NAME_UNREGISTER_CREDENTIAL_DESCRIPTION = 8;
    public static final int CREDENTIAL_MANAGER_API_CALLED__API_NAME__API_NAME_GET_CREDENTIAL_VIA_REGISTRY = 9;

    // Values for CredentialManagerApiCalled.api_status
    public static final int CREDENTIAL_MANAGER_API_CALLED__API_STATUS__API_STATUS_UNKNOWN = 0;
    public static final int CREDENTIAL_MANAGER_API_CALLED__API_STATUS__API_STATUS_SUCCESS = 1;
    public static final int CREDENTIAL_MANAGER_API_CALLED__API_STATUS__API_STATUS_FAILURE = 2;
    public static final int CREDENTIAL_MANAGER_API_CALLED__API_STATUS__API_STATUS_USER_CANCELED = 3;
    public static final int CREDENTIAL_MANAGER_API_CALLED__API_STATUS__API_STATUS_CLIENT_CANCELED = 4;

    // Values for CredentialManagerApiCalled.candidate_provider_status
    public static final int CREDENTIAL_MANAGER_API_CALLED__CANDIDATE_PROVIDER_STATUS__PROVIDER_UNKNOWN = 0;
    public static final int CREDENTIAL_MANAGER_API_CALLED__CANDIDATE_PROVIDER_STATUS__PROVIDER_QUERY_SUCCESS = 1;
    public static final int CREDENTIAL_MANAGER_API_CALLED__CANDIDATE_PROVIDER_STATUS__PROVIDER_FINAL_SUCCESS = 2;
    public static final int CREDENTIAL_MANAGER_API_CALLED__CANDIDATE_PROVIDER_STATUS__PROVIDER_QUERY_FAILURE = 3;
    public static final int CREDENTIAL_MANAGER_API_CALLED__CANDIDATE_PROVIDER_STATUS__PROVIDER_FINAL_FAILURE = 4;

    // Values for CredentialManagerApiCalled.chosen_provider_status
    public static final int CREDENTIAL_MANAGER_API_CALLED__CHOSEN_PROVIDER_STATUS__PROVIDER_UNKNOWN = 0;
    public static final int CREDENTIAL_MANAGER_API_CALLED__CHOSEN_PROVIDER_STATUS__PROVIDER_QUERY_SUCCESS = 1;
    public static final int CREDENTIAL_MANAGER_API_CALLED__CHOSEN_PROVIDER_STATUS__PROVIDER_FINAL_SUCCESS = 2;
    public static final int CREDENTIAL_MANAGER_API_CALLED__CHOSEN_PROVIDER_STATUS__PROVIDER_QUERY_FAILURE = 3;
    public static final int CREDENTIAL_MANAGER_API_CALLED__CHOSEN_PROVIDER_STATUS__PROVIDER_FINAL_FAILURE = 4;

    // Values for BiometricPropertiesCollected.modality
    public static final int BIOMETRIC_PROPERTIES_COLLECTED__MODALITY__MODALITY_UNKNOWN = 0;
    public static final int BIOMETRIC_PROPERTIES_COLLECTED__MODALITY__MODALITY_FINGERPRINT = 1;
    public static final int BIOMETRIC_PROPERTIES_COLLECTED__MODALITY__MODALITY_IRIS = 2;
    public static final int BIOMETRIC_PROPERTIES_COLLECTED__MODALITY__MODALITY_FACE = 4;

    // Values for BiometricPropertiesCollected.sensor_type
    public static final int BIOMETRIC_PROPERTIES_COLLECTED__SENSOR_TYPE__SENSOR_UNKNOWN = 0;
    public static final int BIOMETRIC_PROPERTIES_COLLECTED__SENSOR_TYPE__SENSOR_FP_REAR = 1;
    public static final int BIOMETRIC_PROPERTIES_COLLECTED__SENSOR_TYPE__SENSOR_FP_UDFPS_ULTRASONIC = 2;
    public static final int BIOMETRIC_PROPERTIES_COLLECTED__SENSOR_TYPE__SENSOR_FP_UDFPS_OPTICAL = 3;
    public static final int BIOMETRIC_PROPERTIES_COLLECTED__SENSOR_TYPE__SENSOR_FP_POWER_BUTTON = 4;
    public static final int BIOMETRIC_PROPERTIES_COLLECTED__SENSOR_TYPE__SENSOR_FP_HOME_BUTTON = 5;
    public static final int BIOMETRIC_PROPERTIES_COLLECTED__SENSOR_TYPE__SENSOR_FACE_RGB = 6;
    public static final int BIOMETRIC_PROPERTIES_COLLECTED__SENSOR_TYPE__SENSOR_FACE_IR = 7;

    // Values for BiometricPropertiesCollected.sensor_strength
    public static final int BIOMETRIC_PROPERTIES_COLLECTED__SENSOR_STRENGTH__STRENGTH_UNKNOWN = 0;
    public static final int BIOMETRIC_PROPERTIES_COLLECTED__SENSOR_STRENGTH__STRENGTH_CONVENIENCE = 1;
    public static final int BIOMETRIC_PROPERTIES_COLLECTED__SENSOR_STRENGTH__STRENGTH_WEAK = 2;
    public static final int BIOMETRIC_PROPERTIES_COLLECTED__SENSOR_STRENGTH__STRENGTH_STRONG = 3;

    // Values for KernelWakeupAttributed.type
    public static final int KERNEL_WAKEUP_ATTRIBUTED__TYPE__TYPE_UNKNOWN = 0;
    public static final int KERNEL_WAKEUP_ATTRIBUTED__TYPE__TYPE_IRQ = 1;
    public static final int KERNEL_WAKEUP_ATTRIBUTED__TYPE__TYPE_ABNORMAL = 2;

    // Values for KernelWakeupAttributed.reason
    public static final int KERNEL_WAKEUP_ATTRIBUTED__REASON__UNKNOWN = 0;
    public static final int KERNEL_WAKEUP_ATTRIBUTED__REASON__ALARM = 1;
    public static final int KERNEL_WAKEUP_ATTRIBUTED__REASON__WIFI = 2;
    public static final int KERNEL_WAKEUP_ATTRIBUTED__REASON__SOUND_TRIGGER = 3;
    public static final int KERNEL_WAKEUP_ATTRIBUTED__REASON__SENSOR = 4;
    public static final int KERNEL_WAKEUP_ATTRIBUTED__REASON__CELLULAR_DATA = 5;

    // Values for KernelWakeupAttributed.process_states
    public static final int KERNEL_WAKEUP_ATTRIBUTED__PROCESS_STATES__PROCESS_STATE_UNKNOWN_TO_PROTO = 998;
    public static final int KERNEL_WAKEUP_ATTRIBUTED__PROCESS_STATES__PROCESS_STATE_UNKNOWN = 999;
    public static final int KERNEL_WAKEUP_ATTRIBUTED__PROCESS_STATES__PROCESS_STATE_PERSISTENT = 1000;
    public static final int KERNEL_WAKEUP_ATTRIBUTED__PROCESS_STATES__PROCESS_STATE_PERSISTENT_UI = 1001;
    public static final int KERNEL_WAKEUP_ATTRIBUTED__PROCESS_STATES__PROCESS_STATE_TOP = 1002;
    public static final int KERNEL_WAKEUP_ATTRIBUTED__PROCESS_STATES__PROCESS_STATE_FOREGROUND_SERVICE = 1003;
    public static final int KERNEL_WAKEUP_ATTRIBUTED__PROCESS_STATES__PROCESS_STATE_BOUND_FOREGROUND_SERVICE = 1004;
    public static final int KERNEL_WAKEUP_ATTRIBUTED__PROCESS_STATES__PROCESS_STATE_IMPORTANT_FOREGROUND = 1005;
    public static final int KERNEL_WAKEUP_ATTRIBUTED__PROCESS_STATES__PROCESS_STATE_IMPORTANT_BACKGROUND = 1006;
    public static final int KERNEL_WAKEUP_ATTRIBUTED__PROCESS_STATES__PROCESS_STATE_TRANSIENT_BACKGROUND = 1007;
    public static final int KERNEL_WAKEUP_ATTRIBUTED__PROCESS_STATES__PROCESS_STATE_BACKUP = 1008;
    public static final int KERNEL_WAKEUP_ATTRIBUTED__PROCESS_STATES__PROCESS_STATE_SERVICE = 1009;
    public static final int KERNEL_WAKEUP_ATTRIBUTED__PROCESS_STATES__PROCESS_STATE_RECEIVER = 1010;
    public static final int KERNEL_WAKEUP_ATTRIBUTED__PROCESS_STATES__PROCESS_STATE_TOP_SLEEPING = 1011;
    public static final int KERNEL_WAKEUP_ATTRIBUTED__PROCESS_STATES__PROCESS_STATE_HEAVY_WEIGHT = 1012;
    public static final int KERNEL_WAKEUP_ATTRIBUTED__PROCESS_STATES__PROCESS_STATE_HOME = 1013;
    public static final int KERNEL_WAKEUP_ATTRIBUTED__PROCESS_STATES__PROCESS_STATE_LAST_ACTIVITY = 1014;
    public static final int KERNEL_WAKEUP_ATTRIBUTED__PROCESS_STATES__PROCESS_STATE_CACHED_ACTIVITY = 1015;
    public static final int KERNEL_WAKEUP_ATTRIBUTED__PROCESS_STATES__PROCESS_STATE_CACHED_ACTIVITY_CLIENT = 1016;
    public static final int KERNEL_WAKEUP_ATTRIBUTED__PROCESS_STATES__PROCESS_STATE_CACHED_RECENT = 1017;
    public static final int KERNEL_WAKEUP_ATTRIBUTED__PROCESS_STATES__PROCESS_STATE_CACHED_EMPTY = 1018;
    public static final int KERNEL_WAKEUP_ATTRIBUTED__PROCESS_STATES__PROCESS_STATE_NONEXISTENT = 1019;
    public static final int KERNEL_WAKEUP_ATTRIBUTED__PROCESS_STATES__PROCESS_STATE_BOUND_TOP = 1020;

    // Values for ScreenStateChangedV2.state
    public static final int SCREEN_STATE_CHANGED_V2__STATE__DISPLAY_STATE_UNKNOWN = 0;
    public static final int SCREEN_STATE_CHANGED_V2__STATE__DISPLAY_STATE_OFF = 1;
    public static final int SCREEN_STATE_CHANGED_V2__STATE__DISPLAY_STATE_ON = 2;
    public static final int SCREEN_STATE_CHANGED_V2__STATE__DISPLAY_STATE_DOZE = 3;
    public static final int SCREEN_STATE_CHANGED_V2__STATE__DISPLAY_STATE_DOZE_SUSPEND = 4;
    public static final int SCREEN_STATE_CHANGED_V2__STATE__DISPLAY_STATE_VR = 5;
    public static final int SCREEN_STATE_CHANGED_V2__STATE__DISPLAY_STATE_ON_SUSPEND = 6;

    // Values for WearOobeStateChanged.oobe_state
    public static final int WEAR_OOBE_STATE_CHANGED__OOBE_STATE__OOBE_STARTED = 0;
    public static final int WEAR_OOBE_STATE_CHANGED__OOBE_STATE__OOBE_COMPLETED = 1;

    // Values for MediaCodecReclaimRequestCompleted.reclaim_status
    public static final int MEDIA_CODEC_RECLAIM_REQUEST_COMPLETED__RECLAIM_STATUS__RECLAIM_STATUS_UNSPECIFIED = 0;
    public static final int MEDIA_CODEC_RECLAIM_REQUEST_COMPLETED__RECLAIM_STATUS__RECLAIM_SUCCESS = 1;
    public static final int MEDIA_CODEC_RECLAIM_REQUEST_COMPLETED__RECLAIM_STATUS__RECLAIM_FAILED_NO_CLIENTS = 2;
    public static final int MEDIA_CODEC_RECLAIM_REQUEST_COMPLETED__RECLAIM_STATUS__RECLAIM_FAILED_RECLAIM_RESOURCES = 3;

    // Values for AutofillUiEventReported.event_type
    public static final int AUTOFILL_UI_EVENT_REPORTED__EVENT_TYPE__TYPE_UNKNOWN = 0;
    public static final int AUTOFILL_UI_EVENT_REPORTED__EVENT_TYPE__DEFAULT_AUTOFILL_PICKER = 1;
    public static final int AUTOFILL_UI_EVENT_REPORTED__EVENT_TYPE__ACTION_SETTINGS_UPDATE_DEFAULT_APP = 2;
    public static final int AUTOFILL_UI_EVENT_REPORTED__EVENT_TYPE__AUTOFILL_SERVICE_DISABLED_SELF = 3;
    public static final int AUTOFILL_UI_EVENT_REPORTED__EVENT_TYPE__AUTOFILL_SERVICE_DISABLED_APP = 4;
    public static final int AUTOFILL_UI_EVENT_REPORTED__EVENT_TYPE__AUTOFILL_SERVICE_DISABLED_ACTIVITY = 5;
    public static final int AUTOFILL_UI_EVENT_REPORTED__EVENT_TYPE__AUTOFILL_ENABLED_FROM_DENYLIST = 6;
    public static final int AUTOFILL_UI_EVENT_REPORTED__EVENT_TYPE__AUTOFILL_FORGED_COMPONENT_ATTEMPT = 7;

    // Values for AutofillFillRequestReported.request_trigger_reason
    public static final int AUTOFILL_FILL_REQUEST_REPORTED__REQUEST_TRIGGER_REASON__TRIGGER_REASON_UNKNOWN = 0;
    public static final int AUTOFILL_FILL_REQUEST_REPORTED__REQUEST_TRIGGER_REASON__TRIGGER_REASON_EXPLICITLY_REQUESTED = 1;
    public static final int AUTOFILL_FILL_REQUEST_REPORTED__REQUEST_TRIGGER_REASON__TRIGGER_REASON_RETRIGGER = 2;
    public static final int AUTOFILL_FILL_REQUEST_REPORTED__REQUEST_TRIGGER_REASON__TRIGGER_REASON_PRE_TRIGGER = 3;
    public static final int AUTOFILL_FILL_REQUEST_REPORTED__REQUEST_TRIGGER_REASON__TRIGGER_REASON_NORMAL_TRIGGER = 4;
    public static final int AUTOFILL_FILL_REQUEST_REPORTED__REQUEST_TRIGGER_REASON__TRIGGER_REASON_SERVED_FROM_CACHED_RESPONSE = 5;

    // Values for AutofillFillResponseReported.display_presentation_type
    public static final int AUTOFILL_FILL_RESPONSE_REPORTED__DISPLAY_PRESENTATION_TYPE__UNKNOWN_AUTOFILL_DISPLAY_PRESENTATION_TYPE = 0;
    public static final int AUTOFILL_FILL_RESPONSE_REPORTED__DISPLAY_PRESENTATION_TYPE__MENU = 1;
    public static final int AUTOFILL_FILL_RESPONSE_REPORTED__DISPLAY_PRESENTATION_TYPE__INLINE = 2;
    public static final int AUTOFILL_FILL_RESPONSE_REPORTED__DISPLAY_PRESENTATION_TYPE__DIALOG = 3;

    // Values for AutofillFillResponseReported.authentication_type
    public static final int AUTOFILL_FILL_RESPONSE_REPORTED__AUTHENTICATION_TYPE__AUTHENTICATION_TYPE_UNKNOWN = 0;
    public static final int AUTOFILL_FILL_RESPONSE_REPORTED__AUTHENTICATION_TYPE__DATASET_AUTHENTICATION = 1;
    public static final int AUTOFILL_FILL_RESPONSE_REPORTED__AUTHENTICATION_TYPE__FULL_AUTHENTICATION = 2;

    // Values for AutofillFillResponseReported.authentication_result
    public static final int AUTOFILL_FILL_RESPONSE_REPORTED__AUTHENTICATION_RESULT__AUTHENTICATION_RESULT_UNKNOWN = 0;
    public static final int AUTOFILL_FILL_RESPONSE_REPORTED__AUTHENTICATION_RESULT__AUTHENTICATION_SUCCESS = 1;
    public static final int AUTOFILL_FILL_RESPONSE_REPORTED__AUTHENTICATION_RESULT__AUTHENTICATION_FAILURE = 2;

    // Values for AutofillFillResponseReported.response_status
    public static final int AUTOFILL_FILL_RESPONSE_REPORTED__RESPONSE_STATUS__RESPONSE_STATUS_UNKNOWN = 0;
    public static final int AUTOFILL_FILL_RESPONSE_REPORTED__RESPONSE_STATUS__RESPONSE_STATUS_FAILURE = 1;
    public static final int AUTOFILL_FILL_RESPONSE_REPORTED__RESPONSE_STATUS__RESPONSE_STATUS_SUCCESS = 2;
    public static final int AUTOFILL_FILL_RESPONSE_REPORTED__RESPONSE_STATUS__RESPONSE_STATUS_CANCELLED = 3;
    public static final int AUTOFILL_FILL_RESPONSE_REPORTED__RESPONSE_STATUS__RESPONSE_STATUS_TIMEOUT = 4;
    public static final int AUTOFILL_FILL_RESPONSE_REPORTED__RESPONSE_STATUS__RESPONSE_STATUS_SESSION_DESTROYED = 5;

    // Values for AutofillFillResponseReported.detection_preference
    public static final int AUTOFILL_FILL_RESPONSE_REPORTED__DETECTION_PREFERENCE__DETECTION_PREFER_UNKONWN = 0;
    public static final int AUTOFILL_FILL_RESPONSE_REPORTED__DETECTION_PREFERENCE__DETECTION_PREFER_AUTOFILL_PROVIDER = 1;
    public static final int AUTOFILL_FILL_RESPONSE_REPORTED__DETECTION_PREFERENCE__DETECTION_PREFER_PCC = 2;

    // Values for AutofillSaveEventReported.save_ui_shown_reason
    public static final int AUTOFILL_SAVE_EVENT_REPORTED__SAVE_UI_SHOWN_REASON__SAVE_UI_SHOWN_REASON_UNKNOWN = 0;
    public static final int AUTOFILL_SAVE_EVENT_REPORTED__SAVE_UI_SHOWN_REASON__SAVE_UI_SHOWN_REASON_REQUIRED_ID_CHANGE = 1;
    public static final int AUTOFILL_SAVE_EVENT_REPORTED__SAVE_UI_SHOWN_REASON__SAVE_UI_SHOWN_REASON_OPTIONAL_ID_CHANGE = 2;
    public static final int AUTOFILL_SAVE_EVENT_REPORTED__SAVE_UI_SHOWN_REASON__SAVE_UI_SHOWN_REASON_TRIGGER_ID_SET = 3;

    // Values for AutofillSaveEventReported.save_ui_not_shown_reason
    public static final int AUTOFILL_SAVE_EVENT_REPORTED__SAVE_UI_NOT_SHOWN_REASON__NO_SAVE_REASON_UNKNOWN = 0;
    public static final int AUTOFILL_SAVE_EVENT_REPORTED__SAVE_UI_NOT_SHOWN_REASON__NO_SAVE_REASON_NONE = 1;
    public static final int AUTOFILL_SAVE_EVENT_REPORTED__SAVE_UI_NOT_SHOWN_REASON__NO_SAVE_REASON_NO_SAVE_INFO = 2;
    public static final int AUTOFILL_SAVE_EVENT_REPORTED__SAVE_UI_NOT_SHOWN_REASON__NO_SAVE_REASON_WITH_DELAY_SAVE_FLAG = 3;
    public static final int AUTOFILL_SAVE_EVENT_REPORTED__SAVE_UI_NOT_SHOWN_REASON__NO_SAVE_REASON_HAS_EMPTY_REQUIRED = 4;
    public static final int AUTOFILL_SAVE_EVENT_REPORTED__SAVE_UI_NOT_SHOWN_REASON__NO_SAVE_REASON_NO_VALUE_CHANGED = 5;
    public static final int AUTOFILL_SAVE_EVENT_REPORTED__SAVE_UI_NOT_SHOWN_REASON__NO_SAVE_REASON_FIELD_VALIDATION_FAILED = 6;
    public static final int AUTOFILL_SAVE_EVENT_REPORTED__SAVE_UI_NOT_SHOWN_REASON__NO_SAVE_REASON_DATASET_MATCH = 7;
    public static final int AUTOFILL_SAVE_EVENT_REPORTED__SAVE_UI_NOT_SHOWN_REASON__NO_SAVE_REASON_WITH_DONT_SAVE_ON_FINISH_FLAG = 8;
    public static final int AUTOFILL_SAVE_EVENT_REPORTED__SAVE_UI_NOT_SHOWN_REASON__NO_SAVE_REASON_SESSION_DESTROYED = 9;

    // Values for AutofillSessionCommitted.commit_reason
    public static final int AUTOFILL_SESSION_COMMITTED__COMMIT_REASON__COMMIT_REASON_UNKNOWN = 0;
    public static final int AUTOFILL_SESSION_COMMITTED__COMMIT_REASON__COMMIT_REASON_ACTIVITY_FINISHED = 1;
    public static final int AUTOFILL_SESSION_COMMITTED__COMMIT_REASON__COMMIT_REASON_VIEW_COMMITTED = 2;
    public static final int AUTOFILL_SESSION_COMMITTED__COMMIT_REASON__COMMIT_REASON_VIEW_CLICKED = 3;
    public static final int AUTOFILL_SESSION_COMMITTED__COMMIT_REASON__COMMIT_REASON_VIEW_CHANGED = 4;
    public static final int AUTOFILL_SESSION_COMMITTED__COMMIT_REASON__COMMIT_REASON_SESSION_DESTROYED = 5;

    // Values for BalAllowed.allowed_reason
    public static final int BAL_ALLOWED__ALLOWED_REASON__BAL_STATUS_UNKNOWN = 0;
    public static final int BAL_ALLOWED__ALLOWED_REASON__BAL_ALLOW_DEFAULT = 1;
    public static final int BAL_ALLOWED__ALLOWED_REASON__BAL_ALLOW_ALLOWLISTED_UID = 2;
    public static final int BAL_ALLOWED__ALLOWED_REASON__BAL_ALLOW_ALLOWLISTED_COMPONENT = 3;
    public static final int BAL_ALLOWED__ALLOWED_REASON__BAL_ALLOW_VISIBLE_WINDOW = 4;
    public static final int BAL_ALLOWED__ALLOWED_REASON__BAL_ALLOW_PENDING_INTENT = 5;
    public static final int BAL_ALLOWED__ALLOWED_REASON__BAL_ALLOW_BAL_PERMISSION = 6;
    public static final int BAL_ALLOWED__ALLOWED_REASON__BAL_ALLOW_SAW_PERMISSION = 7;
    public static final int BAL_ALLOWED__ALLOWED_REASON__BAL_ALLOW_GRACE_PERIOD = 8;
    public static final int BAL_ALLOWED__ALLOWED_REASON__BAL_ALLOW_FOREGROUND = 9;
    public static final int BAL_ALLOWED__ALLOWED_REASON__BAL_ALLOW_SDK_SANDBOX = 10;

    // Values for MediaCodecStarted.codec_type
    public static final int MEDIA_CODEC_STARTED__CODEC_TYPE__CODEC_TYPE_UNSPECIFIED = 0;
    public static final int MEDIA_CODEC_STARTED__CODEC_TYPE__CODEC_TYPE_AUDIO = 1;
    public static final int MEDIA_CODEC_STARTED__CODEC_TYPE__CODEC_TYPE_VIDEO = 2;
    public static final int MEDIA_CODEC_STARTED__CODEC_TYPE__CODEC_TYPE_IMAGE = 3;

    // Values for MediaCodecStopped.codec_type
    public static final int MEDIA_CODEC_STOPPED__CODEC_TYPE__CODEC_TYPE_UNSPECIFIED = 0;
    public static final int MEDIA_CODEC_STOPPED__CODEC_TYPE__CODEC_TYPE_AUDIO = 1;
    public static final int MEDIA_CODEC_STOPPED__CODEC_TYPE__CODEC_TYPE_VIDEO = 2;
    public static final int MEDIA_CODEC_STOPPED__CODEC_TYPE__CODEC_TYPE_IMAGE = 3;

    // Values for CredentialManagerInitialPhaseReported.api_name
    public static final int CREDENTIAL_MANAGER_INITIAL_PHASE_REPORTED__API_NAME__API_NAME_UNKNOWN = 0;
    public static final int CREDENTIAL_MANAGER_INITIAL_PHASE_REPORTED__API_NAME__API_NAME_GET_CREDENTIAL = 1;
    public static final int CREDENTIAL_MANAGER_INITIAL_PHASE_REPORTED__API_NAME__API_NAME_CREATE_CREDENTIAL = 2;
    public static final int CREDENTIAL_MANAGER_INITIAL_PHASE_REPORTED__API_NAME__API_NAME_CLEAR_CREDENTIAL = 3;
    public static final int CREDENTIAL_MANAGER_INITIAL_PHASE_REPORTED__API_NAME__API_NAME_IS_ENABLED_CREDENTIAL_PROVIDER_SERVICE = 4;
    public static final int CREDENTIAL_MANAGER_INITIAL_PHASE_REPORTED__API_NAME__API_NAME_SET_ENABLED_PROVIDERS = 5;
    public static final int CREDENTIAL_MANAGER_INITIAL_PHASE_REPORTED__API_NAME__API_NAME_GET_CREDENTIAL_PROVIDER_SERVICES = 6;
    public static final int CREDENTIAL_MANAGER_INITIAL_PHASE_REPORTED__API_NAME__API_NAME_REGISTER_CREDENTIAL_DESCRIPTION = 7;
    public static final int CREDENTIAL_MANAGER_INITIAL_PHASE_REPORTED__API_NAME__API_NAME_UNREGISTER_CREDENTIAL_DESCRIPTION = 8;
    public static final int CREDENTIAL_MANAGER_INITIAL_PHASE_REPORTED__API_NAME__API_NAME_GET_CREDENTIAL_VIA_REGISTRY = 9;

    // Values for CredentialManagerCandidatePhaseReported.candidate_provider_status
    public static final int CREDENTIAL_MANAGER_CANDIDATE_PHASE_REPORTED__CANDIDATE_PROVIDER_STATUS__PROVIDER_UNKNOWN = 0;
    public static final int CREDENTIAL_MANAGER_CANDIDATE_PHASE_REPORTED__CANDIDATE_PROVIDER_STATUS__PROVIDER_QUERY_SUCCESS = 1;
    public static final int CREDENTIAL_MANAGER_CANDIDATE_PHASE_REPORTED__CANDIDATE_PROVIDER_STATUS__PROVIDER_FINAL_SUCCESS = 2;
    public static final int CREDENTIAL_MANAGER_CANDIDATE_PHASE_REPORTED__CANDIDATE_PROVIDER_STATUS__PROVIDER_QUERY_FAILURE = 3;
    public static final int CREDENTIAL_MANAGER_CANDIDATE_PHASE_REPORTED__CANDIDATE_PROVIDER_STATUS__PROVIDER_FINAL_FAILURE = 4;

    // Values for CredentialManagerCandidatePhaseReported.api_name
    public static final int CREDENTIAL_MANAGER_CANDIDATE_PHASE_REPORTED__API_NAME__API_NAME_UNKNOWN = 0;
    public static final int CREDENTIAL_MANAGER_CANDIDATE_PHASE_REPORTED__API_NAME__API_NAME_GET_CREDENTIAL = 1;
    public static final int CREDENTIAL_MANAGER_CANDIDATE_PHASE_REPORTED__API_NAME__API_NAME_CREATE_CREDENTIAL = 2;
    public static final int CREDENTIAL_MANAGER_CANDIDATE_PHASE_REPORTED__API_NAME__API_NAME_CLEAR_CREDENTIAL = 3;
    public static final int CREDENTIAL_MANAGER_CANDIDATE_PHASE_REPORTED__API_NAME__API_NAME_IS_ENABLED_CREDENTIAL_PROVIDER_SERVICE = 4;
    public static final int CREDENTIAL_MANAGER_CANDIDATE_PHASE_REPORTED__API_NAME__API_NAME_SET_ENABLED_PROVIDERS = 5;
    public static final int CREDENTIAL_MANAGER_CANDIDATE_PHASE_REPORTED__API_NAME__API_NAME_GET_CREDENTIAL_PROVIDER_SERVICES = 6;
    public static final int CREDENTIAL_MANAGER_CANDIDATE_PHASE_REPORTED__API_NAME__API_NAME_REGISTER_CREDENTIAL_DESCRIPTION = 7;
    public static final int CREDENTIAL_MANAGER_CANDIDATE_PHASE_REPORTED__API_NAME__API_NAME_UNREGISTER_CREDENTIAL_DESCRIPTION = 8;
    public static final int CREDENTIAL_MANAGER_CANDIDATE_PHASE_REPORTED__API_NAME__API_NAME_GET_CREDENTIAL_VIA_REGISTRY = 9;

    // Values for CredentialManagerFinalPhaseReported.chosen_provider_status
    public static final int CREDENTIAL_MANAGER_FINAL_PHASE_REPORTED__CHOSEN_PROVIDER_STATUS__PROVIDER_UNKNOWN = 0;
    public static final int CREDENTIAL_MANAGER_FINAL_PHASE_REPORTED__CHOSEN_PROVIDER_STATUS__PROVIDER_QUERY_SUCCESS = 1;
    public static final int CREDENTIAL_MANAGER_FINAL_PHASE_REPORTED__CHOSEN_PROVIDER_STATUS__PROVIDER_FINAL_SUCCESS = 2;
    public static final int CREDENTIAL_MANAGER_FINAL_PHASE_REPORTED__CHOSEN_PROVIDER_STATUS__PROVIDER_QUERY_FAILURE = 3;
    public static final int CREDENTIAL_MANAGER_FINAL_PHASE_REPORTED__CHOSEN_PROVIDER_STATUS__PROVIDER_FINAL_FAILURE = 4;

    // Values for CredentialManagerFinalPhaseReported.chosen_provider_available_entries
    public static final int CREDENTIAL_MANAGER_FINAL_PHASE_REPORTED__CHOSEN_PROVIDER_AVAILABLE_ENTRIES__UNKNOWN = 0;
    public static final int CREDENTIAL_MANAGER_FINAL_PHASE_REPORTED__CHOSEN_PROVIDER_AVAILABLE_ENTRIES__ACTION_ENTRY = 1;
    public static final int CREDENTIAL_MANAGER_FINAL_PHASE_REPORTED__CHOSEN_PROVIDER_AVAILABLE_ENTRIES__CREDENTIAL_ENTRY = 2;
    public static final int CREDENTIAL_MANAGER_FINAL_PHASE_REPORTED__CHOSEN_PROVIDER_AVAILABLE_ENTRIES__REMOTE_ENTRY = 3;
    public static final int CREDENTIAL_MANAGER_FINAL_PHASE_REPORTED__CHOSEN_PROVIDER_AVAILABLE_ENTRIES__AUTHENTICATION_ENTRY = 4;

    // Values for CredentialManagerFinalPhaseReported.clicked_entries
    public static final int CREDENTIAL_MANAGER_FINAL_PHASE_REPORTED__CLICKED_ENTRIES__UNKNOWN = 0;
    public static final int CREDENTIAL_MANAGER_FINAL_PHASE_REPORTED__CLICKED_ENTRIES__ACTION_ENTRY = 1;
    public static final int CREDENTIAL_MANAGER_FINAL_PHASE_REPORTED__CLICKED_ENTRIES__CREDENTIAL_ENTRY = 2;
    public static final int CREDENTIAL_MANAGER_FINAL_PHASE_REPORTED__CLICKED_ENTRIES__REMOTE_ENTRY = 3;
    public static final int CREDENTIAL_MANAGER_FINAL_PHASE_REPORTED__CLICKED_ENTRIES__AUTHENTICATION_ENTRY = 4;

    // Values for CredentialManagerFinalPhaseReported.api_status
    public static final int CREDENTIAL_MANAGER_FINAL_PHASE_REPORTED__API_STATUS__API_STATUS_UNKNOWN = 0;
    public static final int CREDENTIAL_MANAGER_FINAL_PHASE_REPORTED__API_STATUS__API_STATUS_SUCCESS = 1;
    public static final int CREDENTIAL_MANAGER_FINAL_PHASE_REPORTED__API_STATUS__API_STATUS_FAILURE = 2;
    public static final int CREDENTIAL_MANAGER_FINAL_PHASE_REPORTED__API_STATUS__API_STATUS_USER_CANCELED = 3;
    public static final int CREDENTIAL_MANAGER_FINAL_PHASE_REPORTED__API_STATUS__API_STATUS_CLIENT_CANCELED = 4;

    // Values for CredentialManagerFinalPhaseReported.unique_entries
    public static final int CREDENTIAL_MANAGER_FINAL_PHASE_REPORTED__UNIQUE_ENTRIES__UNKNOWN = 0;
    public static final int CREDENTIAL_MANAGER_FINAL_PHASE_REPORTED__UNIQUE_ENTRIES__ACTION_ENTRY = 1;
    public static final int CREDENTIAL_MANAGER_FINAL_PHASE_REPORTED__UNIQUE_ENTRIES__CREDENTIAL_ENTRY = 2;
    public static final int CREDENTIAL_MANAGER_FINAL_PHASE_REPORTED__UNIQUE_ENTRIES__REMOTE_ENTRY = 3;
    public static final int CREDENTIAL_MANAGER_FINAL_PHASE_REPORTED__UNIQUE_ENTRIES__AUTHENTICATION_ENTRY = 4;

    // Values for DNDStateChanged.new_mode
    public static final int DNDSTATE_CHANGED__NEW_MODE__ROOT_CONFIG = -1;
    public static final int DNDSTATE_CHANGED__NEW_MODE__ZEN_MODE_OFF = 0;
    public static final int DNDSTATE_CHANGED__NEW_MODE__ZEN_MODE_IMPORTANT_INTERRUPTIONS = 1;
    public static final int DNDSTATE_CHANGED__NEW_MODE__ZEN_MODE_NO_INTERRUPTIONS = 2;
    public static final int DNDSTATE_CHANGED__NEW_MODE__ZEN_MODE_ALARMS = 3;

    // Values for DNDStateChanged.previous_mode
    public static final int DNDSTATE_CHANGED__PREVIOUS_MODE__ROOT_CONFIG = -1;
    public static final int DNDSTATE_CHANGED__PREVIOUS_MODE__ZEN_MODE_OFF = 0;
    public static final int DNDSTATE_CHANGED__PREVIOUS_MODE__ZEN_MODE_IMPORTANT_INTERRUPTIONS = 1;
    public static final int DNDSTATE_CHANGED__PREVIOUS_MODE__ZEN_MODE_NO_INTERRUPTIONS = 2;
    public static final int DNDSTATE_CHANGED__PREVIOUS_MODE__ZEN_MODE_ALARMS = 3;

    // Values for DNDStateChanged.rule_type
    public static final int DNDSTATE_CHANGED__RULE_TYPE__UNKNOWN_RULE = 0;
    public static final int DNDSTATE_CHANGED__RULE_TYPE__MANUAL_RULE = 1;
    public static final int DNDSTATE_CHANGED__RULE_TYPE__AUTOMATIC_RULE = 2;

    // Values for CredentialManagerTotalCandidateReported.query_unique_entries
    public static final int CREDENTIAL_MANAGER_TOTAL_CANDIDATE_REPORTED__QUERY_UNIQUE_ENTRIES__UNKNOWN = 0;
    public static final int CREDENTIAL_MANAGER_TOTAL_CANDIDATE_REPORTED__QUERY_UNIQUE_ENTRIES__ACTION_ENTRY = 1;
    public static final int CREDENTIAL_MANAGER_TOTAL_CANDIDATE_REPORTED__QUERY_UNIQUE_ENTRIES__CREDENTIAL_ENTRY = 2;
    public static final int CREDENTIAL_MANAGER_TOTAL_CANDIDATE_REPORTED__QUERY_UNIQUE_ENTRIES__REMOTE_ENTRY = 3;
    public static final int CREDENTIAL_MANAGER_TOTAL_CANDIDATE_REPORTED__QUERY_UNIQUE_ENTRIES__AUTHENTICATION_ENTRY = 4;

    // Values for CredentialManagerTotalCandidateReported.auth_unique_entries
    public static final int CREDENTIAL_MANAGER_TOTAL_CANDIDATE_REPORTED__AUTH_UNIQUE_ENTRIES__UNKNOWN = 0;
    public static final int CREDENTIAL_MANAGER_TOTAL_CANDIDATE_REPORTED__AUTH_UNIQUE_ENTRIES__ACTION_ENTRY = 1;
    public static final int CREDENTIAL_MANAGER_TOTAL_CANDIDATE_REPORTED__AUTH_UNIQUE_ENTRIES__CREDENTIAL_ENTRY = 2;
    public static final int CREDENTIAL_MANAGER_TOTAL_CANDIDATE_REPORTED__AUTH_UNIQUE_ENTRIES__REMOTE_ENTRY = 3;
    public static final int CREDENTIAL_MANAGER_TOTAL_CANDIDATE_REPORTED__AUTH_UNIQUE_ENTRIES__AUTHENTICATION_ENTRY = 4;

    // Values for CredentialManagerFinalNoUidReported.final_status
    public static final int CREDENTIAL_MANAGER_FINAL_NO_UID_REPORTED__FINAL_STATUS__PROVIDER_UNKNOWN = 0;
    public static final int CREDENTIAL_MANAGER_FINAL_NO_UID_REPORTED__FINAL_STATUS__PROVIDER_QUERY_SUCCESS = 1;
    public static final int CREDENTIAL_MANAGER_FINAL_NO_UID_REPORTED__FINAL_STATUS__PROVIDER_FINAL_SUCCESS = 2;
    public static final int CREDENTIAL_MANAGER_FINAL_NO_UID_REPORTED__FINAL_STATUS__PROVIDER_QUERY_FAILURE = 3;
    public static final int CREDENTIAL_MANAGER_FINAL_NO_UID_REPORTED__FINAL_STATUS__PROVIDER_FINAL_FAILURE = 4;

    // Values for CredentialManagerFinalNoUidReported.unique_entries
    public static final int CREDENTIAL_MANAGER_FINAL_NO_UID_REPORTED__UNIQUE_ENTRIES__UNKNOWN = 0;
    public static final int CREDENTIAL_MANAGER_FINAL_NO_UID_REPORTED__UNIQUE_ENTRIES__ACTION_ENTRY = 1;
    public static final int CREDENTIAL_MANAGER_FINAL_NO_UID_REPORTED__UNIQUE_ENTRIES__CREDENTIAL_ENTRY = 2;
    public static final int CREDENTIAL_MANAGER_FINAL_NO_UID_REPORTED__UNIQUE_ENTRIES__REMOTE_ENTRY = 3;
    public static final int CREDENTIAL_MANAGER_FINAL_NO_UID_REPORTED__UNIQUE_ENTRIES__AUTHENTICATION_ENTRY = 4;

    // Values for CredentialManagerFinalNoUidReported.clicked_entries
    public static final int CREDENTIAL_MANAGER_FINAL_NO_UID_REPORTED__CLICKED_ENTRIES__UNKNOWN = 0;
    public static final int CREDENTIAL_MANAGER_FINAL_NO_UID_REPORTED__CLICKED_ENTRIES__ACTION_ENTRY = 1;
    public static final int CREDENTIAL_MANAGER_FINAL_NO_UID_REPORTED__CLICKED_ENTRIES__CREDENTIAL_ENTRY = 2;
    public static final int CREDENTIAL_MANAGER_FINAL_NO_UID_REPORTED__CLICKED_ENTRIES__REMOTE_ENTRY = 3;
    public static final int CREDENTIAL_MANAGER_FINAL_NO_UID_REPORTED__CLICKED_ENTRIES__AUTHENTICATION_ENTRY = 4;

    // Values for CredentialManagerFinalNoUidReported.api_status
    public static final int CREDENTIAL_MANAGER_FINAL_NO_UID_REPORTED__API_STATUS__API_STATUS_UNKNOWN = 0;
    public static final int CREDENTIAL_MANAGER_FINAL_NO_UID_REPORTED__API_STATUS__API_STATUS_SUCCESS = 1;
    public static final int CREDENTIAL_MANAGER_FINAL_NO_UID_REPORTED__API_STATUS__API_STATUS_FAILURE = 2;
    public static final int CREDENTIAL_MANAGER_FINAL_NO_UID_REPORTED__API_STATUS__API_STATUS_USER_CANCELED = 3;
    public static final int CREDENTIAL_MANAGER_FINAL_NO_UID_REPORTED__API_STATUS__API_STATUS_CLIENT_CANCELED = 4;

    // Values for CredentialManagerBrowsedAuthenticationClicked.unique_entries
    public static final int CREDENTIAL_MANAGER_BROWSED_AUTHENTICATION_CLICKED__UNIQUE_ENTRIES__UNKNOWN = 0;
    public static final int CREDENTIAL_MANAGER_BROWSED_AUTHENTICATION_CLICKED__UNIQUE_ENTRIES__ACTION_ENTRY = 1;
    public static final int CREDENTIAL_MANAGER_BROWSED_AUTHENTICATION_CLICKED__UNIQUE_ENTRIES__CREDENTIAL_ENTRY = 2;
    public static final int CREDENTIAL_MANAGER_BROWSED_AUTHENTICATION_CLICKED__UNIQUE_ENTRIES__REMOTE_ENTRY = 3;
    public static final int CREDENTIAL_MANAGER_BROWSED_AUTHENTICATION_CLICKED__UNIQUE_ENTRIES__AUTHENTICATION_ENTRY = 4;

    // Values for CredentialManagerBrowsedAuthenticationClicked.candidate_provider_status
    public static final int CREDENTIAL_MANAGER_BROWSED_AUTHENTICATION_CLICKED__CANDIDATE_PROVIDER_STATUS__PROVIDER_UNKNOWN = 0;
    public static final int CREDENTIAL_MANAGER_BROWSED_AUTHENTICATION_CLICKED__CANDIDATE_PROVIDER_STATUS__PROVIDER_QUERY_SUCCESS = 1;
    public static final int CREDENTIAL_MANAGER_BROWSED_AUTHENTICATION_CLICKED__CANDIDATE_PROVIDER_STATUS__PROVIDER_FINAL_SUCCESS = 2;
    public static final int CREDENTIAL_MANAGER_BROWSED_AUTHENTICATION_CLICKED__CANDIDATE_PROVIDER_STATUS__PROVIDER_QUERY_FAILURE = 3;
    public static final int CREDENTIAL_MANAGER_BROWSED_AUTHENTICATION_CLICKED__CANDIDATE_PROVIDER_STATUS__PROVIDER_FINAL_FAILURE = 4;

    // Values for CredentialManagerApiV2Called.api_name
    public static final int CREDENTIAL_MANAGER_API_V2CALLED__API_NAME__API_NAME_UNKNOWN = 0;
    public static final int CREDENTIAL_MANAGER_API_V2CALLED__API_NAME__API_NAME_GET_CREDENTIAL = 1;
    public static final int CREDENTIAL_MANAGER_API_V2CALLED__API_NAME__API_NAME_CREATE_CREDENTIAL = 2;
    public static final int CREDENTIAL_MANAGER_API_V2CALLED__API_NAME__API_NAME_CLEAR_CREDENTIAL = 3;
    public static final int CREDENTIAL_MANAGER_API_V2CALLED__API_NAME__API_NAME_IS_ENABLED_CREDENTIAL_PROVIDER_SERVICE = 4;
    public static final int CREDENTIAL_MANAGER_API_V2CALLED__API_NAME__API_NAME_SET_ENABLED_PROVIDERS = 5;
    public static final int CREDENTIAL_MANAGER_API_V2CALLED__API_NAME__API_NAME_GET_CREDENTIAL_PROVIDER_SERVICES = 6;
    public static final int CREDENTIAL_MANAGER_API_V2CALLED__API_NAME__API_NAME_REGISTER_CREDENTIAL_DESCRIPTION = 7;
    public static final int CREDENTIAL_MANAGER_API_V2CALLED__API_NAME__API_NAME_UNREGISTER_CREDENTIAL_DESCRIPTION = 8;
    public static final int CREDENTIAL_MANAGER_API_V2CALLED__API_NAME__API_NAME_GET_CREDENTIAL_VIA_REGISTRY = 9;

    // Values for CredentialManagerApiV2Called.api_status
    public static final int CREDENTIAL_MANAGER_API_V2CALLED__API_STATUS__API_STATUS_UNKNOWN = 0;
    public static final int CREDENTIAL_MANAGER_API_V2CALLED__API_STATUS__API_STATUS_SUCCESS = 1;
    public static final int CREDENTIAL_MANAGER_API_V2CALLED__API_STATUS__API_STATUS_FAILURE = 2;
    public static final int CREDENTIAL_MANAGER_API_V2CALLED__API_STATUS__API_STATUS_USER_CANCELED = 3;
    public static final int CREDENTIAL_MANAGER_API_V2CALLED__API_STATUS__API_STATUS_CLIENT_CANCELED = 4;

    // Values for MediaCodecRendered.codec
    public static final int MEDIA_CODEC_RENDERED__CODEC__CODEC_UNKNOWN = 0;
    public static final int MEDIA_CODEC_RENDERED__CODEC__CODEC_AVC = 1;
    public static final int MEDIA_CODEC_RENDERED__CODEC__CODEC_HEVC = 2;
    public static final int MEDIA_CODEC_RENDERED__CODEC__CODEC_VP8 = 3;
    public static final int MEDIA_CODEC_RENDERED__CODEC__CODEC_VP9 = 4;
    public static final int MEDIA_CODEC_RENDERED__CODEC__CODEC_AV1 = 5;

    // Values for MediaCodecRendered.resolution
    public static final int MEDIA_CODEC_RENDERED__RESOLUTION__RESOLUTION_INVALID = -2;
    public static final int MEDIA_CODEC_RENDERED__RESOLUTION__RESOLUTION_ZERO = -1;
    public static final int MEDIA_CODEC_RENDERED__RESOLUTION__RESOLUTION_UNKNOWN = 0;
    public static final int MEDIA_CODEC_RENDERED__RESOLUTION__RESOLUTION_SMALLEST = 11;
    public static final int MEDIA_CODEC_RENDERED__RESOLUTION__RESOLUTION_VERY_LOW = 41;
    public static final int MEDIA_CODEC_RENDERED__RESOLUTION__RESOLUTION_352X640 = 228;
    public static final int MEDIA_CODEC_RENDERED__RESOLUTION__RESOLUTION_360X640 = 233;
    public static final int MEDIA_CODEC_RENDERED__RESOLUTION__RESOLUTION_480X640 = 311;
    public static final int MEDIA_CODEC_RENDERED__RESOLUTION__RESOLUTION_480X854 = 414;
    public static final int MEDIA_CODEC_RENDERED__RESOLUTION__RESOLUTION_540X960 = 524;
    public static final int MEDIA_CODEC_RENDERED__RESOLUTION__RESOLUTION_576X1024 = 621;
    public static final int MEDIA_CODEC_RENDERED__RESOLUTION__RESOLUTION_720P_HD_ALMOST = 912;
    public static final int MEDIA_CODEC_RENDERED__RESOLUTION__RESOLUTION_720P_HD = 931;
    public static final int MEDIA_CODEC_RENDERED__RESOLUTION__RESOLUTION_1080P_FHD_ALMOST = 2053;
    public static final int MEDIA_CODEC_RENDERED__RESOLUTION__RESOLUTION_1080P_FHD = 2095;
    public static final int MEDIA_CODEC_RENDERED__RESOLUTION__RESOLUTION_1080X2340 = 2553;
    public static final int MEDIA_CODEC_RENDERED__RESOLUTION__RESOLUTION_1080X2400 = 2618;
    public static final int MEDIA_CODEC_RENDERED__RESOLUTION__RESOLUTION_1440X2560 = 3724;
    public static final int MEDIA_CODEC_RENDERED__RESOLUTION__RESOLUTION_4K_UHD_ALMOST = 8211;
    public static final int MEDIA_CODEC_RENDERED__RESOLUTION__RESOLUTION_4K_UHD = 8378;
    public static final int MEDIA_CODEC_RENDERED__RESOLUTION__RESOLUTION_8K_UHD_ALMOST = 32846;
    public static final int MEDIA_CODEC_RENDERED__RESOLUTION__RESOLUTION_8K_UHD = 33510;
    public static final int MEDIA_CODEC_RENDERED__RESOLUTION__RESOLUTION_16K = 134038;
    public static final int MEDIA_CODEC_RENDERED__RESOLUTION__RESOLUTION_32K = 536151;
    public static final int MEDIA_CODEC_RENDERED__RESOLUTION__RESOLUTION_MAX_SIZE = 2147483647;

    // Values for MediaCodecRendered.bitrate
    public static final int MEDIA_CODEC_RENDERED__BITRATE__BITRATE_UNKNOWN = 0;
    public static final int MEDIA_CODEC_RENDERED__BITRATE__BITRATE_LOW = 1;
    public static final int MEDIA_CODEC_RENDERED__BITRATE__BITRATE_MEDIUM = 2;
    public static final int MEDIA_CODEC_RENDERED__BITRATE__BITRATE_HIGH = 3;

    // Values for MediaCodecRendered.content_framerate
    public static final int MEDIA_CODEC_RENDERED__CONTENT_FRAMERATE__FRAMERATE_UNKNOWN = 0;
    public static final int MEDIA_CODEC_RENDERED__CONTENT_FRAMERATE__FRAMERATE_UNDETERMINED = 1;
    public static final int MEDIA_CODEC_RENDERED__CONTENT_FRAMERATE__FRAMERATE_24_3_2_PULLDOWN = 2;
    public static final int MEDIA_CODEC_RENDERED__CONTENT_FRAMERATE__FRAMERATE_24 = 2400;
    public static final int MEDIA_CODEC_RENDERED__CONTENT_FRAMERATE__FRAMERATE_25 = 2500;
    public static final int MEDIA_CODEC_RENDERED__CONTENT_FRAMERATE__FRAMERATE_30 = 3000;
    public static final int MEDIA_CODEC_RENDERED__CONTENT_FRAMERATE__FRAMERATE_50 = 5000;
    public static final int MEDIA_CODEC_RENDERED__CONTENT_FRAMERATE__FRAMERATE_60 = 6000;
    public static final int MEDIA_CODEC_RENDERED__CONTENT_FRAMERATE__FRAMERATE_120 = 12000;

    // Values for MediaCodecRendered.actual_framerate
    public static final int MEDIA_CODEC_RENDERED__ACTUAL_FRAMERATE__FRAMERATE_UNKNOWN = 0;
    public static final int MEDIA_CODEC_RENDERED__ACTUAL_FRAMERATE__FRAMERATE_UNDETERMINED = 1;
    public static final int MEDIA_CODEC_RENDERED__ACTUAL_FRAMERATE__FRAMERATE_24_3_2_PULLDOWN = 2;
    public static final int MEDIA_CODEC_RENDERED__ACTUAL_FRAMERATE__FRAMERATE_24 = 2400;
    public static final int MEDIA_CODEC_RENDERED__ACTUAL_FRAMERATE__FRAMERATE_25 = 2500;
    public static final int MEDIA_CODEC_RENDERED__ACTUAL_FRAMERATE__FRAMERATE_30 = 3000;
    public static final int MEDIA_CODEC_RENDERED__ACTUAL_FRAMERATE__FRAMERATE_50 = 5000;
    public static final int MEDIA_CODEC_RENDERED__ACTUAL_FRAMERATE__FRAMERATE_60 = 6000;
    public static final int MEDIA_CODEC_RENDERED__ACTUAL_FRAMERATE__FRAMERATE_120 = 12000;

    // Values for MediaCodecRendered.hdr_format
    public static final int MEDIA_CODEC_RENDERED__HDR_FORMAT__HDR_FORMAT_UNKNOWN = 0;
    public static final int MEDIA_CODEC_RENDERED__HDR_FORMAT__HDR_FORMAT_NONE = 1;
    public static final int MEDIA_CODEC_RENDERED__HDR_FORMAT__HDR_FORMAT_HLG = 2;
    public static final int MEDIA_CODEC_RENDERED__HDR_FORMAT__HDR_FORMAT_HDR10 = 3;
    public static final int MEDIA_CODEC_RENDERED__HDR_FORMAT__HDR_FORMAT_HDR10_PLUS = 4;
    public static final int MEDIA_CODEC_RENDERED__HDR_FORMAT__HDR_FORMAT_DOLBY_VISION = 5;

    // Values for InTaskActivityStarted.type
    public static final int IN_TASK_ACTIVITY_STARTED__TYPE__UNKNOWN = 0;
    public static final int IN_TASK_ACTIVITY_STARTED__TYPE__WARM = 1;
    public static final int IN_TASK_ACTIVITY_STARTED__TYPE__HOT = 2;
    public static final int IN_TASK_ACTIVITY_STARTED__TYPE__COLD = 3;
    public static final int IN_TASK_ACTIVITY_STARTED__TYPE__RELAUNCH = 4;

    // Values for Temperature.sensor_location
    public static final int TEMPERATURE__SENSOR_LOCATION__TEMPERATURE_TYPE_UNKNOWN = -1;
    public static final int TEMPERATURE__SENSOR_LOCATION__TEMPERATURE_TYPE_CPU = 0;
    public static final int TEMPERATURE__SENSOR_LOCATION__TEMPERATURE_TYPE_GPU = 1;
    public static final int TEMPERATURE__SENSOR_LOCATION__TEMPERATURE_TYPE_BATTERY = 2;
    public static final int TEMPERATURE__SENSOR_LOCATION__TEMPERATURE_TYPE_SKIN = 3;
    public static final int TEMPERATURE__SENSOR_LOCATION__TEMPERATURE_TYPE_USB_PORT = 4;
    public static final int TEMPERATURE__SENSOR_LOCATION__TEMPERATURE_TYPE_POWER_AMPLIFIER = 5;
    public static final int TEMPERATURE__SENSOR_LOCATION__TEMPERATURE_TYPE_BCL_VOLTAGE = 6;
    public static final int TEMPERATURE__SENSOR_LOCATION__TEMPERATURE_TYPE_BCL_CURRENT = 7;
    public static final int TEMPERATURE__SENSOR_LOCATION__TEMPERATURE_TYPE_BCL_PERCENTAGE = 8;
    public static final int TEMPERATURE__SENSOR_LOCATION__TEMPERATURE_TYPE_NPU = 9;

    // Values for Temperature.severity
    public static final int TEMPERATURE__SEVERITY__NONE = 0;
    public static final int TEMPERATURE__SEVERITY__LIGHT = 1;
    public static final int TEMPERATURE__SEVERITY__MODERATE = 2;
    public static final int TEMPERATURE__SEVERITY__SEVERE = 3;
    public static final int TEMPERATURE__SEVERITY__CRITICAL = 4;
    public static final int TEMPERATURE__SEVERITY__EMERGENCY = 5;
    public static final int TEMPERATURE__SEVERITY__SHUTDOWN = 6;

    // Values for DirectoryUsage.directory
    public static final int DIRECTORY_USAGE__DIRECTORY__UNKNOWN = 0;
    public static final int DIRECTORY_USAGE__DIRECTORY__DATA = 1;
    public static final int DIRECTORY_USAGE__DIRECTORY__CACHE = 2;
    public static final int DIRECTORY_USAGE__DIRECTORY__SYSTEM = 3;
    public static final int DIRECTORY_USAGE__DIRECTORY__METADATA = 4;

    // Values for CategorySize.category
    public static final int CATEGORY_SIZE__CATEGORY__UNKNOWN = 0;
    public static final int CATEGORY_SIZE__CATEGORY__APP_SIZE = 1;
    public static final int CATEGORY_SIZE__CATEGORY__APP_DATA_SIZE = 2;
    public static final int CATEGORY_SIZE__CATEGORY__APP_CACHE_SIZE = 3;
    public static final int CATEGORY_SIZE__CATEGORY__PHOTOS = 4;
    public static final int CATEGORY_SIZE__CATEGORY__VIDEOS = 5;
    public static final int CATEGORY_SIZE__CATEGORY__AUDIO = 6;
    public static final int CATEGORY_SIZE__CATEGORY__DOWNLOADS = 7;
    public static final int CATEGORY_SIZE__CATEGORY__SYSTEM = 8;
    public static final int CATEGORY_SIZE__CATEGORY__OTHER = 9;

    // Values for DebugElapsedClock.type
    public static final int DEBUG_ELAPSED_CLOCK__TYPE__TYPE_UNKNOWN = 0;
    public static final int DEBUG_ELAPSED_CLOCK__TYPE__ALWAYS_PRESENT = 1;
    public static final int DEBUG_ELAPSED_CLOCK__TYPE__PRESENT_ON_ODD_PULLS = 2;

    // Values for ExternalStorageInfo.storage_type
    public static final int EXTERNAL_STORAGE_INFO__STORAGE_TYPE__UNKNOWN = 0;
    public static final int EXTERNAL_STORAGE_INFO__STORAGE_TYPE__SD_CARD = 1;
    public static final int EXTERNAL_STORAGE_INFO__STORAGE_TYPE__USB = 2;
    public static final int EXTERNAL_STORAGE_INFO__STORAGE_TYPE__OTHER = 3;

    // Values for ExternalStorageInfo.volume_type
    public static final int EXTERNAL_STORAGE_INFO__VOLUME_TYPE__UNKNOWN = 0;
    public static final int EXTERNAL_STORAGE_INFO__VOLUME_TYPE__PUBLIC = 1;
    public static final int EXTERNAL_STORAGE_INFO__VOLUME_TYPE__PRIVATE = 2;
    public static final int EXTERNAL_STORAGE_INFO__VOLUME_TYPE__OTHER = 3;

    // Values for AppsOnExternalStorageInfo.external_storage_type
    public static final int APPS_ON_EXTERNAL_STORAGE_INFO__EXTERNAL_STORAGE_TYPE__UNKNOWN = 0;
    public static final int APPS_ON_EXTERNAL_STORAGE_INFO__EXTERNAL_STORAGE_TYPE__SD_CARD = 1;
    public static final int APPS_ON_EXTERNAL_STORAGE_INFO__EXTERNAL_STORAGE_TYPE__USB = 2;
    public static final int APPS_ON_EXTERNAL_STORAGE_INFO__EXTERNAL_STORAGE_TYPE__OTHER = 3;

    // Values for CoolingDevice.device_location
    public static final int COOLING_DEVICE__DEVICE_LOCATION__FAN = 0;
    public static final int COOLING_DEVICE__DEVICE_LOCATION__BATTERY = 1;
    public static final int COOLING_DEVICE__DEVICE_LOCATION__CPU = 2;
    public static final int COOLING_DEVICE__DEVICE_LOCATION__GPU = 3;
    public static final int COOLING_DEVICE__DEVICE_LOCATION__MODEM = 4;
    public static final int COOLING_DEVICE__DEVICE_LOCATION__NPU = 5;
    public static final int COOLING_DEVICE__DEVICE_LOCATION__COMPONENT = 6;

    // Values for AppOps.op_id
    public static final int APP_OPS__OP_ID__APP_OP_NONE = -1;
    public static final int APP_OPS__OP_ID__APP_OP_COARSE_LOCATION = 0;
    public static final int APP_OPS__OP_ID__APP_OP_FINE_LOCATION = 1;
    public static final int APP_OPS__OP_ID__APP_OP_GPS = 2;
    public static final int APP_OPS__OP_ID__APP_OP_VIBRATE = 3;
    public static final int APP_OPS__OP_ID__APP_OP_READ_CONTACTS = 4;
    public static final int APP_OPS__OP_ID__APP_OP_WRITE_CONTACTS = 5;
    public static final int APP_OPS__OP_ID__APP_OP_READ_CALL_LOG = 6;
    public static final int APP_OPS__OP_ID__APP_OP_WRITE_CALL_LOG = 7;
    public static final int APP_OPS__OP_ID__APP_OP_READ_CALENDAR = 8;
    public static final int APP_OPS__OP_ID__APP_OP_WRITE_CALENDAR = 9;
    public static final int APP_OPS__OP_ID__APP_OP_WIFI_SCAN = 10;
    public static final int APP_OPS__OP_ID__APP_OP_POST_NOTIFICATION = 11;
    public static final int APP_OPS__OP_ID__APP_OP_NEIGHBORING_CELLS = 12;
    public static final int APP_OPS__OP_ID__APP_OP_CALL_PHONE = 13;
    public static final int APP_OPS__OP_ID__APP_OP_READ_SMS = 14;
    public static final int APP_OPS__OP_ID__APP_OP_WRITE_SMS = 15;
    public static final int APP_OPS__OP_ID__APP_OP_RECEIVE_SMS = 16;
    public static final int APP_OPS__OP_ID__APP_OP_RECEIVE_EMERGENCY_SMS = 17;
    public static final int APP_OPS__OP_ID__APP_OP_RECEIVE_MMS = 18;
    public static final int APP_OPS__OP_ID__APP_OP_RECEIVE_WAP_PUSH = 19;
    public static final int APP_OPS__OP_ID__APP_OP_SEND_SMS = 20;
    public static final int APP_OPS__OP_ID__APP_OP_READ_ICC_SMS = 21;
    public static final int APP_OPS__OP_ID__APP_OP_WRITE_ICC_SMS = 22;
    public static final int APP_OPS__OP_ID__APP_OP_WRITE_SETTINGS = 23;
    public static final int APP_OPS__OP_ID__APP_OP_SYSTEM_ALERT_WINDOW = 24;
    public static final int APP_OPS__OP_ID__APP_OP_ACCESS_NOTIFICATIONS = 25;
    public static final int APP_OPS__OP_ID__APP_OP_CAMERA = 26;
    public static final int APP_OPS__OP_ID__APP_OP_RECORD_AUDIO = 27;
    public static final int APP_OPS__OP_ID__APP_OP_PLAY_AUDIO = 28;
    public static final int APP_OPS__OP_ID__APP_OP_READ_CLIPBOARD = 29;
    public static final int APP_OPS__OP_ID__APP_OP_WRITE_CLIPBOARD = 30;
    public static final int APP_OPS__OP_ID__APP_OP_TAKE_MEDIA_BUTTONS = 31;
    public static final int APP_OPS__OP_ID__APP_OP_TAKE_AUDIO_FOCUS = 32;
    public static final int APP_OPS__OP_ID__APP_OP_AUDIO_MASTER_VOLUME = 33;
    public static final int APP_OPS__OP_ID__APP_OP_AUDIO_VOICE_VOLUME = 34;
    public static final int APP_OPS__OP_ID__APP_OP_AUDIO_RING_VOLUME = 35;
    public static final int APP_OPS__OP_ID__APP_OP_AUDIO_MEDIA_VOLUME = 36;
    public static final int APP_OPS__OP_ID__APP_OP_AUDIO_ALARM_VOLUME = 37;
    public static final int APP_OPS__OP_ID__APP_OP_AUDIO_NOTIFICATION_VOLUME = 38;
    public static final int APP_OPS__OP_ID__APP_OP_AUDIO_BLUETOOTH_VOLUME = 39;
    public static final int APP_OPS__OP_ID__APP_OP_WAKE_LOCK = 40;
    public static final int APP_OPS__OP_ID__APP_OP_MONITOR_LOCATION = 41;
    public static final int APP_OPS__OP_ID__APP_OP_MONITOR_HIGH_POWER_LOCATION = 42;
    public static final int APP_OPS__OP_ID__APP_OP_GET_USAGE_STATS = 43;
    public static final int APP_OPS__OP_ID__APP_OP_MUTE_MICROPHONE = 44;
    public static final int APP_OPS__OP_ID__APP_OP_TOAST_WINDOW = 45;
    public static final int APP_OPS__OP_ID__APP_OP_PROJECT_MEDIA = 46;
    public static final int APP_OPS__OP_ID__APP_OP_ACTIVATE_VPN = 47;
    public static final int APP_OPS__OP_ID__APP_OP_WRITE_WALLPAPER = 48;
    public static final int APP_OPS__OP_ID__APP_OP_ASSIST_STRUCTURE = 49;
    public static final int APP_OPS__OP_ID__APP_OP_ASSIST_SCREENSHOT = 50;
    public static final int APP_OPS__OP_ID__APP_OP_READ_PHONE_STATE = 51;
    public static final int APP_OPS__OP_ID__APP_OP_ADD_VOICEMAIL = 52;
    public static final int APP_OPS__OP_ID__APP_OP_USE_SIP = 53;
    public static final int APP_OPS__OP_ID__APP_OP_PROCESS_OUTGOING_CALLS = 54;
    public static final int APP_OPS__OP_ID__APP_OP_USE_FINGERPRINT = 55;
    public static final int APP_OPS__OP_ID__APP_OP_BODY_SENSORS = 56;
    public static final int APP_OPS__OP_ID__APP_OP_READ_CELL_BROADCASTS = 57;
    public static final int APP_OPS__OP_ID__APP_OP_MOCK_LOCATION = 58;
    public static final int APP_OPS__OP_ID__APP_OP_READ_EXTERNAL_STORAGE = 59;
    public static final int APP_OPS__OP_ID__APP_OP_WRITE_EXTERNAL_STORAGE = 60;
    public static final int APP_OPS__OP_ID__APP_OP_TURN_SCREEN_ON = 61;
    public static final int APP_OPS__OP_ID__APP_OP_GET_ACCOUNTS = 62;
    public static final int APP_OPS__OP_ID__APP_OP_RUN_IN_BACKGROUND = 63;
    public static final int APP_OPS__OP_ID__APP_OP_AUDIO_ACCESSIBILITY_VOLUME = 64;
    public static final int APP_OPS__OP_ID__APP_OP_READ_PHONE_NUMBERS = 65;
    public static final int APP_OPS__OP_ID__APP_OP_REQUEST_INSTALL_PACKAGES = 66;
    public static final int APP_OPS__OP_ID__APP_OP_PICTURE_IN_PICTURE = 67;
    public static final int APP_OPS__OP_ID__APP_OP_INSTANT_APP_START_FOREGROUND = 68;
    public static final int APP_OPS__OP_ID__APP_OP_ANSWER_PHONE_CALLS = 69;
    public static final int APP_OPS__OP_ID__APP_OP_RUN_ANY_IN_BACKGROUND = 70;
    public static final int APP_OPS__OP_ID__APP_OP_CHANGE_WIFI_STATE = 71;
    public static final int APP_OPS__OP_ID__APP_OP_REQUEST_DELETE_PACKAGES = 72;
    public static final int APP_OPS__OP_ID__APP_OP_BIND_ACCESSIBILITY_SERVICE = 73;
    public static final int APP_OPS__OP_ID__APP_OP_ACCEPT_HANDOVER = 74;
    public static final int APP_OPS__OP_ID__APP_OP_MANAGE_IPSEC_TUNNELS = 75;
    public static final int APP_OPS__OP_ID__APP_OP_START_FOREGROUND = 76;
    public static final int APP_OPS__OP_ID__APP_OP_BLUETOOTH_SCAN = 77;
    public static final int APP_OPS__OP_ID__APP_OP_USE_BIOMETRIC = 78;
    public static final int APP_OPS__OP_ID__APP_OP_ACTIVITY_RECOGNITION = 79;
    public static final int APP_OPS__OP_ID__APP_OP_SMS_FINANCIAL_TRANSACTIONS = 80;
    public static final int APP_OPS__OP_ID__APP_OP_READ_MEDIA_AUDIO = 81;
    public static final int APP_OPS__OP_ID__APP_OP_WRITE_MEDIA_AUDIO = 82;
    public static final int APP_OPS__OP_ID__APP_OP_READ_MEDIA_VIDEO = 83;
    public static final int APP_OPS__OP_ID__APP_OP_WRITE_MEDIA_VIDEO = 84;
    public static final int APP_OPS__OP_ID__APP_OP_READ_MEDIA_IMAGES = 85;
    public static final int APP_OPS__OP_ID__APP_OP_WRITE_MEDIA_IMAGES = 86;
    public static final int APP_OPS__OP_ID__APP_OP_LEGACY_STORAGE = 87;
    public static final int APP_OPS__OP_ID__APP_OP_ACCESS_ACCESSIBILITY = 88;
    public static final int APP_OPS__OP_ID__APP_OP_READ_DEVICE_IDENTIFIERS = 89;
    public static final int APP_OPS__OP_ID__APP_OP_ACCESS_MEDIA_LOCATION = 90;
    public static final int APP_OPS__OP_ID__APP_OP_QUERY_ALL_PACKAGES = 91;
    public static final int APP_OPS__OP_ID__APP_OP_MANAGE_EXTERNAL_STORAGE = 92;
    public static final int APP_OPS__OP_ID__APP_OP_INTERACT_ACROSS_PROFILES = 93;
    public static final int APP_OPS__OP_ID__APP_OP_ACTIVATE_PLATFORM_VPN = 94;
    public static final int APP_OPS__OP_ID__APP_OP_LOADER_USAGE_STATS = 95;
    public static final int APP_OPS__OP_ID__APP_OP_DEPRECATED_1 = 96;
    public static final int APP_OPS__OP_ID__APP_OP_AUTO_REVOKE_PERMISSIONS_IF_UNUSED = 97;
    public static final int APP_OPS__OP_ID__APP_OP_AUTO_REVOKE_MANAGED_BY_INSTALLER = 98;
    public static final int APP_OPS__OP_ID__APP_OP_NO_ISOLATED_STORAGE = 99;
    public static final int APP_OPS__OP_ID__APP_OP_PHONE_CALL_MICROPHONE = 100;
    public static final int APP_OPS__OP_ID__APP_OP_PHONE_CALL_CAMERA = 101;
    public static final int APP_OPS__OP_ID__APP_OP_RECORD_AUDIO_HOTWORD = 102;
    public static final int APP_OPS__OP_ID__APP_OP_MANAGE_ONGOING_CALLS = 103;
    public static final int APP_OPS__OP_ID__APP_OP_MANAGE_CREDENTIALS = 104;
    public static final int APP_OPS__OP_ID__APP_OP_USE_ICC_AUTH_WITH_DEVICE_IDENTIFIER = 105;
    public static final int APP_OPS__OP_ID__APP_OP_RECORD_AUDIO_OUTPUT = 106;
    public static final int APP_OPS__OP_ID__APP_OP_SCHEDULE_EXACT_ALARM = 107;
    public static final int APP_OPS__OP_ID__APP_OP_FINE_LOCATION_SOURCE = 108;
    public static final int APP_OPS__OP_ID__APP_OP_COARSE_LOCATION_SOURCE = 109;
    public static final int APP_OPS__OP_ID__APP_OP_MANAGE_MEDIA = 110;
    public static final int APP_OPS__OP_ID__APP_OP_BLUETOOTH_CONNECT = 111;
    public static final int APP_OPS__OP_ID__APP_OP_UWB_RANGING = 112;
    public static final int APP_OPS__OP_ID__APP_OP_ACTIVITY_RECOGNITION_SOURCE = 113;
    public static final int APP_OPS__OP_ID__APP_OP_BLUETOOTH_ADVERTISE = 114;
    public static final int APP_OPS__OP_ID__APP_OP_RECORD_INCOMING_PHONE_AUDIO = 115;
    public static final int APP_OPS__OP_ID__APP_OP_NEARBY_WIFI_DEVICES = 116;
    public static final int APP_OPS__OP_ID__APP_OP_ESTABLISH_VPN_SERVICE = 117;
    public static final int APP_OPS__OP_ID__APP_OP_ESTABLISH_VPN_MANAGER = 118;
    public static final int APP_OPS__OP_ID__APP_OP_ACCESS_RESTRICTED_SETTINGS = 119;
    public static final int APP_OPS__OP_ID__APP_OP_RECEIVE_AMBIENT_TRIGGER_AUDIO = 120;
    public static final int APP_OPS__OP_ID__APP_OP_RECEIVE_EXPLICIT_USER_INTERACTION_AUDIO = 121;
    public static final int APP_OPS__OP_ID__APP_OP_RUN_USER_INITIATED_JOBS = 122;
    public static final int APP_OPS__OP_ID__APP_OP_READ_MEDIA_VISUAL_USER_SELECTED = 123;
    public static final int APP_OPS__OP_ID__APP_OP_SYSTEM_EXEMPT_FROM_SUSPENSION = 124;
    public static final int APP_OPS__OP_ID__APP_OP_SYSTEM_EXEMPT_FROM_DISMISSIBLE_NOTIFICATIONS = 125;
    public static final int APP_OPS__OP_ID__APP_OP_READ_WRITE_HEALTH_DATA = 126;
    public static final int APP_OPS__OP_ID__APP_OP_FOREGROUND_SERVICE_SPECIAL_USE = 127;
    public static final int APP_OPS__OP_ID__APP_OP_SYSTEM_EXEMPT_FROM_POWER_RESTRICTIONS = 128;
    public static final int APP_OPS__OP_ID__APP_OP_SYSTEM_EXEMPT_FROM_HIBERNATION = 129;
    public static final int APP_OPS__OP_ID__APP_OP_SYSTEM_EXEMPT_FROM_ACTIVITY_BG_START_RESTRICTION = 130;
    public static final int APP_OPS__OP_ID__APP_OP_CAPTURE_CONSENTLESS_BUGREPORT_ON_USERDEBUG_BUILD = 131;
    public static final int APP_OPS__OP_ID__APP_OP_BODY_SENSORS_WRIST_TEMPERATURE = 132;
    public static final int APP_OPS__OP_ID__APP_OP_USE_FULL_SCREEN_INTENT = 133;
    public static final int APP_OPS__OP_ID__APP_OP_CAMERA_SANDBOXED = 134;
    public static final int APP_OPS__OP_ID__APP_OP_RECORD_AUDIO_SANDBOXED = 135;

    // Values for RuntimeAppOpAccess.sampling_strategy
    public static final int RUNTIME_APP_OP_ACCESS__SAMPLING_STRATEGY__DEFAULT = 0;
    public static final int RUNTIME_APP_OP_ACCESS__SAMPLING_STRATEGY__UNIFORM = 1;
    public static final int RUNTIME_APP_OP_ACCESS__SAMPLING_STRATEGY__RARELY_USED = 2;
    public static final int RUNTIME_APP_OP_ACCESS__SAMPLING_STRATEGY__BOOT_TIME_SAMPLING = 3;
    public static final int RUNTIME_APP_OP_ACCESS__SAMPLING_STRATEGY__UNIFORM_OPS = 4;

    // Values for RuntimeAppOpAccess.op
    public static final int RUNTIME_APP_OP_ACCESS__OP__APP_OP_NONE = -1;
    public static final int RUNTIME_APP_OP_ACCESS__OP__APP_OP_COARSE_LOCATION = 0;
    public static final int RUNTIME_APP_OP_ACCESS__OP__APP_OP_FINE_LOCATION = 1;
    public static final int RUNTIME_APP_OP_ACCESS__OP__APP_OP_GPS = 2;
    public static final int RUNTIME_APP_OP_ACCESS__OP__APP_OP_VIBRATE = 3;
    public static final int RUNTIME_APP_OP_ACCESS__OP__APP_OP_READ_CONTACTS = 4;
    public static final int RUNTIME_APP_OP_ACCESS__OP__APP_OP_WRITE_CONTACTS = 5;
    public static final int RUNTIME_APP_OP_ACCESS__OP__APP_OP_READ_CALL_LOG = 6;
    public static final int RUNTIME_APP_OP_ACCESS__OP__APP_OP_WRITE_CALL_LOG = 7;
    public static final int RUNTIME_APP_OP_ACCESS__OP__APP_OP_READ_CALENDAR = 8;
    public static final int RUNTIME_APP_OP_ACCESS__OP__APP_OP_WRITE_CALENDAR = 9;
    public static final int RUNTIME_APP_OP_ACCESS__OP__APP_OP_WIFI_SCAN = 10;
    public static final int RUNTIME_APP_OP_ACCESS__OP__APP_OP_POST_NOTIFICATION = 11;
    public static final int RUNTIME_APP_OP_ACCESS__OP__APP_OP_NEIGHBORING_CELLS = 12;
    public static final int RUNTIME_APP_OP_ACCESS__OP__APP_OP_CALL_PHONE = 13;
    public static final int RUNTIME_APP_OP_ACCESS__OP__APP_OP_READ_SMS = 14;
    public static final int RUNTIME_APP_OP_ACCESS__OP__APP_OP_WRITE_SMS = 15;
    public static final int RUNTIME_APP_OP_ACCESS__OP__APP_OP_RECEIVE_SMS = 16;
    public static final int RUNTIME_APP_OP_ACCESS__OP__APP_OP_RECEIVE_EMERGENCY_SMS = 17;
    public static final int RUNTIME_APP_OP_ACCESS__OP__APP_OP_RECEIVE_MMS = 18;
    public static final int RUNTIME_APP_OP_ACCESS__OP__APP_OP_RECEIVE_WAP_PUSH = 19;
    public static final int RUNTIME_APP_OP_ACCESS__OP__APP_OP_SEND_SMS = 20;
    public static final int RUNTIME_APP_OP_ACCESS__OP__APP_OP_READ_ICC_SMS = 21;
    public static final int RUNTIME_APP_OP_ACCESS__OP__APP_OP_WRITE_ICC_SMS = 22;
    public static final int RUNTIME_APP_OP_ACCESS__OP__APP_OP_WRITE_SETTINGS = 23;
    public static final int RUNTIME_APP_OP_ACCESS__OP__APP_OP_SYSTEM_ALERT_WINDOW = 24;
    public static final int RUNTIME_APP_OP_ACCESS__OP__APP_OP_ACCESS_NOTIFICATIONS = 25;
    public static final int RUNTIME_APP_OP_ACCESS__OP__APP_OP_CAMERA = 26;
    public static final int RUNTIME_APP_OP_ACCESS__OP__APP_OP_RECORD_AUDIO = 27;
    public static final int RUNTIME_APP_OP_ACCESS__OP__APP_OP_PLAY_AUDIO = 28;
    public static final int RUNTIME_APP_OP_ACCESS__OP__APP_OP_READ_CLIPBOARD = 29;
    public static final int RUNTIME_APP_OP_ACCESS__OP__APP_OP_WRITE_CLIPBOARD = 30;
    public static final int RUNTIME_APP_OP_ACCESS__OP__APP_OP_TAKE_MEDIA_BUTTONS = 31;
    public static final int RUNTIME_APP_OP_ACCESS__OP__APP_OP_TAKE_AUDIO_FOCUS = 32;
    public static final int RUNTIME_APP_OP_ACCESS__OP__APP_OP_AUDIO_MASTER_VOLUME = 33;
    public static final int RUNTIME_APP_OP_ACCESS__OP__APP_OP_AUDIO_VOICE_VOLUME = 34;
    public static final int RUNTIME_APP_OP_ACCESS__OP__APP_OP_AUDIO_RING_VOLUME = 35;
    public static final int RUNTIME_APP_OP_ACCESS__OP__APP_OP_AUDIO_MEDIA_VOLUME = 36;
    public static final int RUNTIME_APP_OP_ACCESS__OP__APP_OP_AUDIO_ALARM_VOLUME = 37;
    public static final int RUNTIME_APP_OP_ACCESS__OP__APP_OP_AUDIO_NOTIFICATION_VOLUME = 38;
    public static final int RUNTIME_APP_OP_ACCESS__OP__APP_OP_AUDIO_BLUETOOTH_VOLUME = 39;
    public static final int RUNTIME_APP_OP_ACCESS__OP__APP_OP_WAKE_LOCK = 40;
    public static final int RUNTIME_APP_OP_ACCESS__OP__APP_OP_MONITOR_LOCATION = 41;
    public static final int RUNTIME_APP_OP_ACCESS__OP__APP_OP_MONITOR_HIGH_POWER_LOCATION = 42;
    public static final int RUNTIME_APP_OP_ACCESS__OP__APP_OP_GET_USAGE_STATS = 43;
    public static final int RUNTIME_APP_OP_ACCESS__OP__APP_OP_MUTE_MICROPHONE = 44;
    public static final int RUNTIME_APP_OP_ACCESS__OP__APP_OP_TOAST_WINDOW = 45;
    public static final int RUNTIME_APP_OP_ACCESS__OP__APP_OP_PROJECT_MEDIA = 46;
    public static final int RUNTIME_APP_OP_ACCESS__OP__APP_OP_ACTIVATE_VPN = 47;
    public static final int RUNTIME_APP_OP_ACCESS__OP__APP_OP_WRITE_WALLPAPER = 48;
    public static final int RUNTIME_APP_OP_ACCESS__OP__APP_OP_ASSIST_STRUCTURE = 49;
    public static final int RUNTIME_APP_OP_ACCESS__OP__APP_OP_ASSIST_SCREENSHOT = 50;
    public static final int RUNTIME_APP_OP_ACCESS__OP__APP_OP_READ_PHONE_STATE = 51;
    public static final int RUNTIME_APP_OP_ACCESS__OP__APP_OP_ADD_VOICEMAIL = 52;
    public static final int RUNTIME_APP_OP_ACCESS__OP__APP_OP_USE_SIP = 53;
    public static final int RUNTIME_APP_OP_ACCESS__OP__APP_OP_PROCESS_OUTGOING_CALLS = 54;
    public static final int RUNTIME_APP_OP_ACCESS__OP__APP_OP_USE_FINGERPRINT = 55;
    public static final int RUNTIME_APP_OP_ACCESS__OP__APP_OP_BODY_SENSORS = 56;
    public static final int RUNTIME_APP_OP_ACCESS__OP__APP_OP_READ_CELL_BROADCASTS = 57;
    public static final int RUNTIME_APP_OP_ACCESS__OP__APP_OP_MOCK_LOCATION = 58;
    public static final int RUNTIME_APP_OP_ACCESS__OP__APP_OP_READ_EXTERNAL_STORAGE = 59;
    public static final int RUNTIME_APP_OP_ACCESS__OP__APP_OP_WRITE_EXTERNAL_STORAGE = 60;
    public static final int RUNTIME_APP_OP_ACCESS__OP__APP_OP_TURN_SCREEN_ON = 61;
    public static final int RUNTIME_APP_OP_ACCESS__OP__APP_OP_GET_ACCOUNTS = 62;
    public static final int RUNTIME_APP_OP_ACCESS__OP__APP_OP_RUN_IN_BACKGROUND = 63;
    public static final int RUNTIME_APP_OP_ACCESS__OP__APP_OP_AUDIO_ACCESSIBILITY_VOLUME = 64;
    public static final int RUNTIME_APP_OP_ACCESS__OP__APP_OP_READ_PHONE_NUMBERS = 65;
    public static final int RUNTIME_APP_OP_ACCESS__OP__APP_OP_REQUEST_INSTALL_PACKAGES = 66;
    public static final int RUNTIME_APP_OP_ACCESS__OP__APP_OP_PICTURE_IN_PICTURE = 67;
    public static final int RUNTIME_APP_OP_ACCESS__OP__APP_OP_INSTANT_APP_START_FOREGROUND = 68;
    public static final int RUNTIME_APP_OP_ACCESS__OP__APP_OP_ANSWER_PHONE_CALLS = 69;
    public static final int RUNTIME_APP_OP_ACCESS__OP__APP_OP_RUN_ANY_IN_BACKGROUND = 70;
    public static final int RUNTIME_APP_OP_ACCESS__OP__APP_OP_CHANGE_WIFI_STATE = 71;
    public static final int RUNTIME_APP_OP_ACCESS__OP__APP_OP_REQUEST_DELETE_PACKAGES = 72;
    public static final int RUNTIME_APP_OP_ACCESS__OP__APP_OP_BIND_ACCESSIBILITY_SERVICE = 73;
    public static final int RUNTIME_APP_OP_ACCESS__OP__APP_OP_ACCEPT_HANDOVER = 74;
    public static final int RUNTIME_APP_OP_ACCESS__OP__APP_OP_MANAGE_IPSEC_TUNNELS = 75;
    public static final int RUNTIME_APP_OP_ACCESS__OP__APP_OP_START_FOREGROUND = 76;
    public static final int RUNTIME_APP_OP_ACCESS__OP__APP_OP_BLUETOOTH_SCAN = 77;
    public static final int RUNTIME_APP_OP_ACCESS__OP__APP_OP_USE_BIOMETRIC = 78;
    public static final int RUNTIME_APP_OP_ACCESS__OP__APP_OP_ACTIVITY_RECOGNITION = 79;
    public static final int RUNTIME_APP_OP_ACCESS__OP__APP_OP_SMS_FINANCIAL_TRANSACTIONS = 80;
    public static final int RUNTIME_APP_OP_ACCESS__OP__APP_OP_READ_MEDIA_AUDIO = 81;
    public static final int RUNTIME_APP_OP_ACCESS__OP__APP_OP_WRITE_MEDIA_AUDIO = 82;
    public static final int RUNTIME_APP_OP_ACCESS__OP__APP_OP_READ_MEDIA_VIDEO = 83;
    public static final int RUNTIME_APP_OP_ACCESS__OP__APP_OP_WRITE_MEDIA_VIDEO = 84;
    public static final int RUNTIME_APP_OP_ACCESS__OP__APP_OP_READ_MEDIA_IMAGES = 85;
    public static final int RUNTIME_APP_OP_ACCESS__OP__APP_OP_WRITE_MEDIA_IMAGES = 86;
    public static final int RUNTIME_APP_OP_ACCESS__OP__APP_OP_LEGACY_STORAGE = 87;
    public static final int RUNTIME_APP_OP_ACCESS__OP__APP_OP_ACCESS_ACCESSIBILITY = 88;
    public static final int RUNTIME_APP_OP_ACCESS__OP__APP_OP_READ_DEVICE_IDENTIFIERS = 89;
    public static final int RUNTIME_APP_OP_ACCESS__OP__APP_OP_ACCESS_MEDIA_LOCATION = 90;
    public static final int RUNTIME_APP_OP_ACCESS__OP__APP_OP_QUERY_ALL_PACKAGES = 91;
    public static final int RUNTIME_APP_OP_ACCESS__OP__APP_OP_MANAGE_EXTERNAL_STORAGE = 92;
    public static final int RUNTIME_APP_OP_ACCESS__OP__APP_OP_INTERACT_ACROSS_PROFILES = 93;
    public static final int RUNTIME_APP_OP_ACCESS__OP__APP_OP_ACTIVATE_PLATFORM_VPN = 94;
    public static final int RUNTIME_APP_OP_ACCESS__OP__APP_OP_LOADER_USAGE_STATS = 95;
    public static final int RUNTIME_APP_OP_ACCESS__OP__APP_OP_DEPRECATED_1 = 96;
    public static final int RUNTIME_APP_OP_ACCESS__OP__APP_OP_AUTO_REVOKE_PERMISSIONS_IF_UNUSED = 97;
    public static final int RUNTIME_APP_OP_ACCESS__OP__APP_OP_AUTO_REVOKE_MANAGED_BY_INSTALLER = 98;
    public static final int RUNTIME_APP_OP_ACCESS__OP__APP_OP_NO_ISOLATED_STORAGE = 99;
    public static final int RUNTIME_APP_OP_ACCESS__OP__APP_OP_PHONE_CALL_MICROPHONE = 100;
    public static final int RUNTIME_APP_OP_ACCESS__OP__APP_OP_PHONE_CALL_CAMERA = 101;
    public static final int RUNTIME_APP_OP_ACCESS__OP__APP_OP_RECORD_AUDIO_HOTWORD = 102;
    public static final int RUNTIME_APP_OP_ACCESS__OP__APP_OP_MANAGE_ONGOING_CALLS = 103;
    public static final int RUNTIME_APP_OP_ACCESS__OP__APP_OP_MANAGE_CREDENTIALS = 104;
    public static final int RUNTIME_APP_OP_ACCESS__OP__APP_OP_USE_ICC_AUTH_WITH_DEVICE_IDENTIFIER = 105;
    public static final int RUNTIME_APP_OP_ACCESS__OP__APP_OP_RECORD_AUDIO_OUTPUT = 106;
    public static final int RUNTIME_APP_OP_ACCESS__OP__APP_OP_SCHEDULE_EXACT_ALARM = 107;
    public static final int RUNTIME_APP_OP_ACCESS__OP__APP_OP_FINE_LOCATION_SOURCE = 108;
    public static final int RUNTIME_APP_OP_ACCESS__OP__APP_OP_COARSE_LOCATION_SOURCE = 109;
    public static final int RUNTIME_APP_OP_ACCESS__OP__APP_OP_MANAGE_MEDIA = 110;
    public static final int RUNTIME_APP_OP_ACCESS__OP__APP_OP_BLUETOOTH_CONNECT = 111;
    public static final int RUNTIME_APP_OP_ACCESS__OP__APP_OP_UWB_RANGING = 112;
    public static final int RUNTIME_APP_OP_ACCESS__OP__APP_OP_ACTIVITY_RECOGNITION_SOURCE = 113;
    public static final int RUNTIME_APP_OP_ACCESS__OP__APP_OP_BLUETOOTH_ADVERTISE = 114;
    public static final int RUNTIME_APP_OP_ACCESS__OP__APP_OP_RECORD_INCOMING_PHONE_AUDIO = 115;
    public static final int RUNTIME_APP_OP_ACCESS__OP__APP_OP_NEARBY_WIFI_DEVICES = 116;
    public static final int RUNTIME_APP_OP_ACCESS__OP__APP_OP_ESTABLISH_VPN_SERVICE = 117;
    public static final int RUNTIME_APP_OP_ACCESS__OP__APP_OP_ESTABLISH_VPN_MANAGER = 118;
    public static final int RUNTIME_APP_OP_ACCESS__OP__APP_OP_ACCESS_RESTRICTED_SETTINGS = 119;
    public static final int RUNTIME_APP_OP_ACCESS__OP__APP_OP_RECEIVE_AMBIENT_TRIGGER_AUDIO = 120;
    public static final int RUNTIME_APP_OP_ACCESS__OP__APP_OP_RECEIVE_EXPLICIT_USER_INTERACTION_AUDIO = 121;
    public static final int RUNTIME_APP_OP_ACCESS__OP__APP_OP_RUN_USER_INITIATED_JOBS = 122;
    public static final int RUNTIME_APP_OP_ACCESS__OP__APP_OP_READ_MEDIA_VISUAL_USER_SELECTED = 123;
    public static final int RUNTIME_APP_OP_ACCESS__OP__APP_OP_SYSTEM_EXEMPT_FROM_SUSPENSION = 124;
    public static final int RUNTIME_APP_OP_ACCESS__OP__APP_OP_SYSTEM_EXEMPT_FROM_DISMISSIBLE_NOTIFICATIONS = 125;
    public static final int RUNTIME_APP_OP_ACCESS__OP__APP_OP_READ_WRITE_HEALTH_DATA = 126;
    public static final int RUNTIME_APP_OP_ACCESS__OP__APP_OP_FOREGROUND_SERVICE_SPECIAL_USE = 127;
    public static final int RUNTIME_APP_OP_ACCESS__OP__APP_OP_SYSTEM_EXEMPT_FROM_POWER_RESTRICTIONS = 128;
    public static final int RUNTIME_APP_OP_ACCESS__OP__APP_OP_SYSTEM_EXEMPT_FROM_HIBERNATION = 129;
    public static final int RUNTIME_APP_OP_ACCESS__OP__APP_OP_SYSTEM_EXEMPT_FROM_ACTIVITY_BG_START_RESTRICTION = 130;
    public static final int RUNTIME_APP_OP_ACCESS__OP__APP_OP_CAPTURE_CONSENTLESS_BUGREPORT_ON_USERDEBUG_BUILD = 131;
    public static final int RUNTIME_APP_OP_ACCESS__OP__APP_OP_BODY_SENSORS_WRIST_TEMPERATURE = 132;
    public static final int RUNTIME_APP_OP_ACCESS__OP__APP_OP_USE_FULL_SCREEN_INTENT = 133;
    public static final int RUNTIME_APP_OP_ACCESS__OP__APP_OP_CAMERA_SANDBOXED = 134;
    public static final int RUNTIME_APP_OP_ACCESS__OP__APP_OP_RECORD_AUDIO_SANDBOXED = 135;

    // Values for AttributedAppOps.op
    public static final int ATTRIBUTED_APP_OPS__OP__APP_OP_NONE = -1;
    public static final int ATTRIBUTED_APP_OPS__OP__APP_OP_COARSE_LOCATION = 0;
    public static final int ATTRIBUTED_APP_OPS__OP__APP_OP_FINE_LOCATION = 1;
    public static final int ATTRIBUTED_APP_OPS__OP__APP_OP_GPS = 2;
    public static final int ATTRIBUTED_APP_OPS__OP__APP_OP_VIBRATE = 3;
    public static final int ATTRIBUTED_APP_OPS__OP__APP_OP_READ_CONTACTS = 4;
    public static final int ATTRIBUTED_APP_OPS__OP__APP_OP_WRITE_CONTACTS = 5;
    public static final int ATTRIBUTED_APP_OPS__OP__APP_OP_READ_CALL_LOG = 6;
    public static final int ATTRIBUTED_APP_OPS__OP__APP_OP_WRITE_CALL_LOG = 7;
    public static final int ATTRIBUTED_APP_OPS__OP__APP_OP_READ_CALENDAR = 8;
    public static final int ATTRIBUTED_APP_OPS__OP__APP_OP_WRITE_CALENDAR = 9;
    public static final int ATTRIBUTED_APP_OPS__OP__APP_OP_WIFI_SCAN = 10;
    public static final int ATTRIBUTED_APP_OPS__OP__APP_OP_POST_NOTIFICATION = 11;
    public static final int ATTRIBUTED_APP_OPS__OP__APP_OP_NEIGHBORING_CELLS = 12;
    public static final int ATTRIBUTED_APP_OPS__OP__APP_OP_CALL_PHONE = 13;
    public static final int ATTRIBUTED_APP_OPS__OP__APP_OP_READ_SMS = 14;
    public static final int ATTRIBUTED_APP_OPS__OP__APP_OP_WRITE_SMS = 15;
    public static final int ATTRIBUTED_APP_OPS__OP__APP_OP_RECEIVE_SMS = 16;
    public static final int ATTRIBUTED_APP_OPS__OP__APP_OP_RECEIVE_EMERGENCY_SMS = 17;
    public static final int ATTRIBUTED_APP_OPS__OP__APP_OP_RECEIVE_MMS = 18;
    public static final int ATTRIBUTED_APP_OPS__OP__APP_OP_RECEIVE_WAP_PUSH = 19;
    public static final int ATTRIBUTED_APP_OPS__OP__APP_OP_SEND_SMS = 20;
    public static final int ATTRIBUTED_APP_OPS__OP__APP_OP_READ_ICC_SMS = 21;
    public static final int ATTRIBUTED_APP_OPS__OP__APP_OP_WRITE_ICC_SMS = 22;
    public static final int ATTRIBUTED_APP_OPS__OP__APP_OP_WRITE_SETTINGS = 23;
    public static final int ATTRIBUTED_APP_OPS__OP__APP_OP_SYSTEM_ALERT_WINDOW = 24;
    public static final int ATTRIBUTED_APP_OPS__OP__APP_OP_ACCESS_NOTIFICATIONS = 25;
    public static final int ATTRIBUTED_APP_OPS__OP__APP_OP_CAMERA = 26;
    public static final int ATTRIBUTED_APP_OPS__OP__APP_OP_RECORD_AUDIO = 27;
    public static final int ATTRIBUTED_APP_OPS__OP__APP_OP_PLAY_AUDIO = 28;
    public static final int ATTRIBUTED_APP_OPS__OP__APP_OP_READ_CLIPBOARD = 29;
    public static final int ATTRIBUTED_APP_OPS__OP__APP_OP_WRITE_CLIPBOARD = 30;
    public static final int ATTRIBUTED_APP_OPS__OP__APP_OP_TAKE_MEDIA_BUTTONS = 31;
    public static final int ATTRIBUTED_APP_OPS__OP__APP_OP_TAKE_AUDIO_FOCUS = 32;
    public static final int ATTRIBUTED_APP_OPS__OP__APP_OP_AUDIO_MASTER_VOLUME = 33;
    public static final int ATTRIBUTED_APP_OPS__OP__APP_OP_AUDIO_VOICE_VOLUME = 34;
    public static final int ATTRIBUTED_APP_OPS__OP__APP_OP_AUDIO_RING_VOLUME = 35;
    public static final int ATTRIBUTED_APP_OPS__OP__APP_OP_AUDIO_MEDIA_VOLUME = 36;
    public static final int ATTRIBUTED_APP_OPS__OP__APP_OP_AUDIO_ALARM_VOLUME = 37;
    public static final int ATTRIBUTED_APP_OPS__OP__APP_OP_AUDIO_NOTIFICATION_VOLUME = 38;
    public static final int ATTRIBUTED_APP_OPS__OP__APP_OP_AUDIO_BLUETOOTH_VOLUME = 39;
    public static final int ATTRIBUTED_APP_OPS__OP__APP_OP_WAKE_LOCK = 40;
    public static final int ATTRIBUTED_APP_OPS__OP__APP_OP_MONITOR_LOCATION = 41;
    public static final int ATTRIBUTED_APP_OPS__OP__APP_OP_MONITOR_HIGH_POWER_LOCATION = 42;
    public static final int ATTRIBUTED_APP_OPS__OP__APP_OP_GET_USAGE_STATS = 43;
    public static final int ATTRIBUTED_APP_OPS__OP__APP_OP_MUTE_MICROPHONE = 44;
    public static final int ATTRIBUTED_APP_OPS__OP__APP_OP_TOAST_WINDOW = 45;
    public static final int ATTRIBUTED_APP_OPS__OP__APP_OP_PROJECT_MEDIA = 46;
    public static final int ATTRIBUTED_APP_OPS__OP__APP_OP_ACTIVATE_VPN = 47;
    public static final int ATTRIBUTED_APP_OPS__OP__APP_OP_WRITE_WALLPAPER = 48;
    public static final int ATTRIBUTED_APP_OPS__OP__APP_OP_ASSIST_STRUCTURE = 49;
    public static final int ATTRIBUTED_APP_OPS__OP__APP_OP_ASSIST_SCREENSHOT = 50;
    public static final int ATTRIBUTED_APP_OPS__OP__APP_OP_READ_PHONE_STATE = 51;
    public static final int ATTRIBUTED_APP_OPS__OP__APP_OP_ADD_VOICEMAIL = 52;
    public static final int ATTRIBUTED_APP_OPS__OP__APP_OP_USE_SIP = 53;
    public static final int ATTRIBUTED_APP_OPS__OP__APP_OP_PROCESS_OUTGOING_CALLS = 54;
    public static final int ATTRIBUTED_APP_OPS__OP__APP_OP_USE_FINGERPRINT = 55;
    public static final int ATTRIBUTED_APP_OPS__OP__APP_OP_BODY_SENSORS = 56;
    public static final int ATTRIBUTED_APP_OPS__OP__APP_OP_READ_CELL_BROADCASTS = 57;
    public static final int ATTRIBUTED_APP_OPS__OP__APP_OP_MOCK_LOCATION = 58;
    public static final int ATTRIBUTED_APP_OPS__OP__APP_OP_READ_EXTERNAL_STORAGE = 59;
    public static final int ATTRIBUTED_APP_OPS__OP__APP_OP_WRITE_EXTERNAL_STORAGE = 60;
    public static final int ATTRIBUTED_APP_OPS__OP__APP_OP_TURN_SCREEN_ON = 61;
    public static final int ATTRIBUTED_APP_OPS__OP__APP_OP_GET_ACCOUNTS = 62;
    public static final int ATTRIBUTED_APP_OPS__OP__APP_OP_RUN_IN_BACKGROUND = 63;
    public static final int ATTRIBUTED_APP_OPS__OP__APP_OP_AUDIO_ACCESSIBILITY_VOLUME = 64;
    public static final int ATTRIBUTED_APP_OPS__OP__APP_OP_READ_PHONE_NUMBERS = 65;
    public static final int ATTRIBUTED_APP_OPS__OP__APP_OP_REQUEST_INSTALL_PACKAGES = 66;
    public static final int ATTRIBUTED_APP_OPS__OP__APP_OP_PICTURE_IN_PICTURE = 67;
    public static final int ATTRIBUTED_APP_OPS__OP__APP_OP_INSTANT_APP_START_FOREGROUND = 68;
    public static final int ATTRIBUTED_APP_OPS__OP__APP_OP_ANSWER_PHONE_CALLS = 69;
    public static final int ATTRIBUTED_APP_OPS__OP__APP_OP_RUN_ANY_IN_BACKGROUND = 70;
    public static final int ATTRIBUTED_APP_OPS__OP__APP_OP_CHANGE_WIFI_STATE = 71;
    public static final int ATTRIBUTED_APP_OPS__OP__APP_OP_REQUEST_DELETE_PACKAGES = 72;
    public static final int ATTRIBUTED_APP_OPS__OP__APP_OP_BIND_ACCESSIBILITY_SERVICE = 73;
    public static final int ATTRIBUTED_APP_OPS__OP__APP_OP_ACCEPT_HANDOVER = 74;
    public static final int ATTRIBUTED_APP_OPS__OP__APP_OP_MANAGE_IPSEC_TUNNELS = 75;
    public static final int ATTRIBUTED_APP_OPS__OP__APP_OP_START_FOREGROUND = 76;
    public static final int ATTRIBUTED_APP_OPS__OP__APP_OP_BLUETOOTH_SCAN = 77;
    public static final int ATTRIBUTED_APP_OPS__OP__APP_OP_USE_BIOMETRIC = 78;
    public static final int ATTRIBUTED_APP_OPS__OP__APP_OP_ACTIVITY_RECOGNITION = 79;
    public static final int ATTRIBUTED_APP_OPS__OP__APP_OP_SMS_FINANCIAL_TRANSACTIONS = 80;
    public static final int ATTRIBUTED_APP_OPS__OP__APP_OP_READ_MEDIA_AUDIO = 81;
    public static final int ATTRIBUTED_APP_OPS__OP__APP_OP_WRITE_MEDIA_AUDIO = 82;
    public static final int ATTRIBUTED_APP_OPS__OP__APP_OP_READ_MEDIA_VIDEO = 83;
    public static final int ATTRIBUTED_APP_OPS__OP__APP_OP_WRITE_MEDIA_VIDEO = 84;
    public static final int ATTRIBUTED_APP_OPS__OP__APP_OP_READ_MEDIA_IMAGES = 85;
    public static final int ATTRIBUTED_APP_OPS__OP__APP_OP_WRITE_MEDIA_IMAGES = 86;
    public static final int ATTRIBUTED_APP_OPS__OP__APP_OP_LEGACY_STORAGE = 87;
    public static final int ATTRIBUTED_APP_OPS__OP__APP_OP_ACCESS_ACCESSIBILITY = 88;
    public static final int ATTRIBUTED_APP_OPS__OP__APP_OP_READ_DEVICE_IDENTIFIERS = 89;
    public static final int ATTRIBUTED_APP_OPS__OP__APP_OP_ACCESS_MEDIA_LOCATION = 90;
    public static final int ATTRIBUTED_APP_OPS__OP__APP_OP_QUERY_ALL_PACKAGES = 91;
    public static final int ATTRIBUTED_APP_OPS__OP__APP_OP_MANAGE_EXTERNAL_STORAGE = 92;
    public static final int ATTRIBUTED_APP_OPS__OP__APP_OP_INTERACT_ACROSS_PROFILES = 93;
    public static final int ATTRIBUTED_APP_OPS__OP__APP_OP_ACTIVATE_PLATFORM_VPN = 94;
    public static final int ATTRIBUTED_APP_OPS__OP__APP_OP_LOADER_USAGE_STATS = 95;
    public static final int ATTRIBUTED_APP_OPS__OP__APP_OP_DEPRECATED_1 = 96;
    public static final int ATTRIBUTED_APP_OPS__OP__APP_OP_AUTO_REVOKE_PERMISSIONS_IF_UNUSED = 97;
    public static final int ATTRIBUTED_APP_OPS__OP__APP_OP_AUTO_REVOKE_MANAGED_BY_INSTALLER = 98;
    public static final int ATTRIBUTED_APP_OPS__OP__APP_OP_NO_ISOLATED_STORAGE = 99;
    public static final int ATTRIBUTED_APP_OPS__OP__APP_OP_PHONE_CALL_MICROPHONE = 100;
    public static final int ATTRIBUTED_APP_OPS__OP__APP_OP_PHONE_CALL_CAMERA = 101;
    public static final int ATTRIBUTED_APP_OPS__OP__APP_OP_RECORD_AUDIO_HOTWORD = 102;
    public static final int ATTRIBUTED_APP_OPS__OP__APP_OP_MANAGE_ONGOING_CALLS = 103;
    public static final int ATTRIBUTED_APP_OPS__OP__APP_OP_MANAGE_CREDENTIALS = 104;
    public static final int ATTRIBUTED_APP_OPS__OP__APP_OP_USE_ICC_AUTH_WITH_DEVICE_IDENTIFIER = 105;
    public static final int ATTRIBUTED_APP_OPS__OP__APP_OP_RECORD_AUDIO_OUTPUT = 106;
    public static final int ATTRIBUTED_APP_OPS__OP__APP_OP_SCHEDULE_EXACT_ALARM = 107;
    public static final int ATTRIBUTED_APP_OPS__OP__APP_OP_FINE_LOCATION_SOURCE = 108;
    public static final int ATTRIBUTED_APP_OPS__OP__APP_OP_COARSE_LOCATION_SOURCE = 109;
    public static final int ATTRIBUTED_APP_OPS__OP__APP_OP_MANAGE_MEDIA = 110;
    public static final int ATTRIBUTED_APP_OPS__OP__APP_OP_BLUETOOTH_CONNECT = 111;
    public static final int ATTRIBUTED_APP_OPS__OP__APP_OP_UWB_RANGING = 112;
    public static final int ATTRIBUTED_APP_OPS__OP__APP_OP_ACTIVITY_RECOGNITION_SOURCE = 113;
    public static final int ATTRIBUTED_APP_OPS__OP__APP_OP_BLUETOOTH_ADVERTISE = 114;
    public static final int ATTRIBUTED_APP_OPS__OP__APP_OP_RECORD_INCOMING_PHONE_AUDIO = 115;
    public static final int ATTRIBUTED_APP_OPS__OP__APP_OP_NEARBY_WIFI_DEVICES = 116;
    public static final int ATTRIBUTED_APP_OPS__OP__APP_OP_ESTABLISH_VPN_SERVICE = 117;
    public static final int ATTRIBUTED_APP_OPS__OP__APP_OP_ESTABLISH_VPN_MANAGER = 118;
    public static final int ATTRIBUTED_APP_OPS__OP__APP_OP_ACCESS_RESTRICTED_SETTINGS = 119;
    public static final int ATTRIBUTED_APP_OPS__OP__APP_OP_RECEIVE_AMBIENT_TRIGGER_AUDIO = 120;
    public static final int ATTRIBUTED_APP_OPS__OP__APP_OP_RECEIVE_EXPLICIT_USER_INTERACTION_AUDIO = 121;
    public static final int ATTRIBUTED_APP_OPS__OP__APP_OP_RUN_USER_INITIATED_JOBS = 122;
    public static final int ATTRIBUTED_APP_OPS__OP__APP_OP_READ_MEDIA_VISUAL_USER_SELECTED = 123;
    public static final int ATTRIBUTED_APP_OPS__OP__APP_OP_SYSTEM_EXEMPT_FROM_SUSPENSION = 124;
    public static final int ATTRIBUTED_APP_OPS__OP__APP_OP_SYSTEM_EXEMPT_FROM_DISMISSIBLE_NOTIFICATIONS = 125;
    public static final int ATTRIBUTED_APP_OPS__OP__APP_OP_READ_WRITE_HEALTH_DATA = 126;
    public static final int ATTRIBUTED_APP_OPS__OP__APP_OP_FOREGROUND_SERVICE_SPECIAL_USE = 127;
    public static final int ATTRIBUTED_APP_OPS__OP__APP_OP_SYSTEM_EXEMPT_FROM_POWER_RESTRICTIONS = 128;
    public static final int ATTRIBUTED_APP_OPS__OP__APP_OP_SYSTEM_EXEMPT_FROM_HIBERNATION = 129;
    public static final int ATTRIBUTED_APP_OPS__OP__APP_OP_SYSTEM_EXEMPT_FROM_ACTIVITY_BG_START_RESTRICTION = 130;
    public static final int ATTRIBUTED_APP_OPS__OP__APP_OP_CAPTURE_CONSENTLESS_BUGREPORT_ON_USERDEBUG_BUILD = 131;
    public static final int ATTRIBUTED_APP_OPS__OP__APP_OP_BODY_SENSORS_WRIST_TEMPERATURE = 132;
    public static final int ATTRIBUTED_APP_OPS__OP__APP_OP_USE_FULL_SCREEN_INTENT = 133;
    public static final int ATTRIBUTED_APP_OPS__OP__APP_OP_CAMERA_SANDBOXED = 134;
    public static final int ATTRIBUTED_APP_OPS__OP__APP_OP_RECORD_AUDIO_SANDBOXED = 135;

    // Values for SettingSnapshot.type
    public static final int SETTING_SNAPSHOT__TYPE__NOTASSIGNED = 0;
    public static final int SETTING_SNAPSHOT__TYPE__ASSIGNED_BOOL_TYPE = 1;
    public static final int SETTING_SNAPSHOT__TYPE__ASSIGNED_INT_TYPE = 2;
    public static final int SETTING_SNAPSHOT__TYPE__ASSIGNED_FLOAT_TYPE = 3;
    public static final int SETTING_SNAPSHOT__TYPE__ASSIGNED_STRING_TYPE = 4;

    // Values for DataUsageBytesTransfer.opportunistic_data_sub
    public static final int DATA_USAGE_BYTES_TRANSFER__OPPORTUNISTIC_DATA_SUB__UNKNOWN = 0;
    public static final int DATA_USAGE_BYTES_TRANSFER__OPPORTUNISTIC_DATA_SUB__ALL = 1;
    public static final int DATA_USAGE_BYTES_TRANSFER__OPPORTUNISTIC_DATA_SUB__OPPORTUNISTIC = 2;
    public static final int DATA_USAGE_BYTES_TRANSFER__OPPORTUNISTIC_DATA_SUB__NOT_OPPORTUNISTIC = 3;

    // Values for DNDModeProto.zen_mode
    public static final int DNDMODE_PROTO__ZEN_MODE__ROOT_CONFIG = -1;
    public static final int DNDMODE_PROTO__ZEN_MODE__ZEN_MODE_OFF = 0;
    public static final int DNDMODE_PROTO__ZEN_MODE__ZEN_MODE_IMPORTANT_INTERRUPTIONS = 1;
    public static final int DNDMODE_PROTO__ZEN_MODE__ZEN_MODE_NO_INTERRUPTIONS = 2;
    public static final int DNDMODE_PROTO__ZEN_MODE__ZEN_MODE_ALARMS = 3;

    // Values for DeviceRotatedData.proposed_orientation
    public static final int DEVICE_ROTATED_DATA__PROPOSED_ORIENTATION__UNKNOWN = 0;
    public static final int DEVICE_ROTATED_DATA__PROPOSED_ORIENTATION__ROTATION_0 = 1;
    public static final int DEVICE_ROTATED_DATA__PROPOSED_ORIENTATION__ROTATION_90 = 2;
    public static final int DEVICE_ROTATED_DATA__PROPOSED_ORIENTATION__ROTATION_180 = 3;
    public static final int DEVICE_ROTATED_DATA__PROPOSED_ORIENTATION__ROTATION_270 = 4;

    // Values for CpuCyclesPerThreadGroupCluster.thread_group
    public static final int CPU_CYCLES_PER_THREAD_GROUP_CLUSTER__THREAD_GROUP__UNKNOWN_THREAD_GROUP = 0;
    public static final int CPU_CYCLES_PER_THREAD_GROUP_CLUSTER__THREAD_GROUP__SYSTEM_SERVER_BINDER = 1;
    public static final int CPU_CYCLES_PER_THREAD_GROUP_CLUSTER__THREAD_GROUP__SYSTEM_SERVER = 2;
    public static final int CPU_CYCLES_PER_THREAD_GROUP_CLUSTER__THREAD_GROUP__SURFACE_FLINGER = 3;

    // Values for TimeZoneDetectorState.detection_mode
    public static final int TIME_ZONE_DETECTOR_STATE__DETECTION_MODE__UNKNOWN = 0;
    public static final int TIME_ZONE_DETECTOR_STATE__DETECTION_MODE__MANUAL = 1;
    public static final int TIME_ZONE_DETECTOR_STATE__DETECTION_MODE__TELEPHONY = 2;
    public static final int TIME_ZONE_DETECTOR_STATE__DETECTION_MODE__GEO = 3;

    // Values for Keystore2StorageStats.storage_type
    public static final int KEYSTORE2_STORAGE_STATS__STORAGE_TYPE__STORAGE_UNSPECIFIED = 0;
    public static final int KEYSTORE2_STORAGE_STATS__STORAGE_TYPE__KEY_ENTRY = 1;
    public static final int KEYSTORE2_STORAGE_STATS__STORAGE_TYPE__KEY_ENTRY_ID_INDEX = 2;
    public static final int KEYSTORE2_STORAGE_STATS__STORAGE_TYPE__KEY_ENTRY_DOMAIN_NAMESPACE_INDEX = 3;
    public static final int KEYSTORE2_STORAGE_STATS__STORAGE_TYPE__BLOB_ENTRY = 4;
    public static final int KEYSTORE2_STORAGE_STATS__STORAGE_TYPE__BLOB_ENTRY_KEY_ENTRY_ID_INDEX = 5;
    public static final int KEYSTORE2_STORAGE_STATS__STORAGE_TYPE__KEY_PARAMETER = 6;
    public static final int KEYSTORE2_STORAGE_STATS__STORAGE_TYPE__KEY_PARAMETER_KEY_ENTRY_ID_INDEX = 7;
    public static final int KEYSTORE2_STORAGE_STATS__STORAGE_TYPE__KEY_METADATA = 8;
    public static final int KEYSTORE2_STORAGE_STATS__STORAGE_TYPE__KEY_METADATA_KEY_ENTRY_ID_INDEX = 9;
    public static final int KEYSTORE2_STORAGE_STATS__STORAGE_TYPE__GRANT = 10;
    public static final int KEYSTORE2_STORAGE_STATS__STORAGE_TYPE__AUTH_TOKEN = 11;
    public static final int KEYSTORE2_STORAGE_STATS__STORAGE_TYPE__BLOB_METADATA = 12;
    public static final int KEYSTORE2_STORAGE_STATS__STORAGE_TYPE__BLOB_METADATA_BLOB_ENTRY_ID_INDEX = 13;
    public static final int KEYSTORE2_STORAGE_STATS__STORAGE_TYPE__METADATA = 14;
    public static final int KEYSTORE2_STORAGE_STATS__STORAGE_TYPE__DATABASE = 15;
    public static final int KEYSTORE2_STORAGE_STATS__STORAGE_TYPE__LEGACY_STORAGE = 16;

    // Values for Keystore2KeyCreationWithGeneralInfo.algorithm
    public static final int KEYSTORE2_KEY_CREATION_WITH_GENERAL_INFO__ALGORITHM__ALGORITHM_UNSPECIFIED = 0;
    public static final int KEYSTORE2_KEY_CREATION_WITH_GENERAL_INFO__ALGORITHM__RSA = 1;
    public static final int KEYSTORE2_KEY_CREATION_WITH_GENERAL_INFO__ALGORITHM__EC = 3;
    public static final int KEYSTORE2_KEY_CREATION_WITH_GENERAL_INFO__ALGORITHM__AES = 32;
    public static final int KEYSTORE2_KEY_CREATION_WITH_GENERAL_INFO__ALGORITHM__TRIPLE_DES = 33;
    public static final int KEYSTORE2_KEY_CREATION_WITH_GENERAL_INFO__ALGORITHM__HMAC = 128;

    // Values for Keystore2KeyCreationWithGeneralInfo.ec_curve
    public static final int KEYSTORE2_KEY_CREATION_WITH_GENERAL_INFO__EC_CURVE__EC_CURVE_UNSPECIFIED = 0;
    public static final int KEYSTORE2_KEY_CREATION_WITH_GENERAL_INFO__EC_CURVE__P_224 = 1;
    public static final int KEYSTORE2_KEY_CREATION_WITH_GENERAL_INFO__EC_CURVE__P_256 = 2;
    public static final int KEYSTORE2_KEY_CREATION_WITH_GENERAL_INFO__EC_CURVE__P_384 = 3;
    public static final int KEYSTORE2_KEY_CREATION_WITH_GENERAL_INFO__EC_CURVE__P_521 = 4;
    public static final int KEYSTORE2_KEY_CREATION_WITH_GENERAL_INFO__EC_CURVE__CURVE_25519 = 5;

    // Values for Keystore2KeyCreationWithGeneralInfo.key_origin
    public static final int KEYSTORE2_KEY_CREATION_WITH_GENERAL_INFO__KEY_ORIGIN__ORIGIN_UNSPECIFIED = 0;
    public static final int KEYSTORE2_KEY_CREATION_WITH_GENERAL_INFO__KEY_ORIGIN__GENERATED = 1;
    public static final int KEYSTORE2_KEY_CREATION_WITH_GENERAL_INFO__KEY_ORIGIN__DERIVED = 2;
    public static final int KEYSTORE2_KEY_CREATION_WITH_GENERAL_INFO__KEY_ORIGIN__IMPORTED = 3;
    public static final int KEYSTORE2_KEY_CREATION_WITH_GENERAL_INFO__KEY_ORIGIN__RESERVED = 4;
    public static final int KEYSTORE2_KEY_CREATION_WITH_GENERAL_INFO__KEY_ORIGIN__SECURELY_IMPORTED = 5;

    // Values for Keystore2KeyCreationWithAuthInfo.user_auth_type
    public static final int KEYSTORE2_KEY_CREATION_WITH_AUTH_INFO__USER_AUTH_TYPE__AUTH_TYPE_UNSPECIFIED = 0;
    public static final int KEYSTORE2_KEY_CREATION_WITH_AUTH_INFO__USER_AUTH_TYPE__NONE = 1;
    public static final int KEYSTORE2_KEY_CREATION_WITH_AUTH_INFO__USER_AUTH_TYPE__PASSWORD = 2;
    public static final int KEYSTORE2_KEY_CREATION_WITH_AUTH_INFO__USER_AUTH_TYPE__FINGERPRINT = 3;
    public static final int KEYSTORE2_KEY_CREATION_WITH_AUTH_INFO__USER_AUTH_TYPE__ANY = 5;

    // Values for Keystore2KeyCreationWithAuthInfo.security_level
    public static final int KEYSTORE2_KEY_CREATION_WITH_AUTH_INFO__SECURITY_LEVEL__SECURITY_LEVEL_UNSPECIFIED = 0;
    public static final int KEYSTORE2_KEY_CREATION_WITH_AUTH_INFO__SECURITY_LEVEL__SECURITY_LEVEL_SOFTWARE = 1;
    public static final int KEYSTORE2_KEY_CREATION_WITH_AUTH_INFO__SECURITY_LEVEL__SECURITY_LEVEL_TRUSTED_ENVIRONMENT = 2;
    public static final int KEYSTORE2_KEY_CREATION_WITH_AUTH_INFO__SECURITY_LEVEL__SECURITY_LEVEL_STRONGBOX = 3;
    public static final int KEYSTORE2_KEY_CREATION_WITH_AUTH_INFO__SECURITY_LEVEL__SECURITY_LEVEL_KEYSTORE = 4;

    // Values for Keystore2KeyCreationWithPurposeAndModesInfo.algorithm
    public static final int KEYSTORE2_KEY_CREATION_WITH_PURPOSE_AND_MODES_INFO__ALGORITHM__ALGORITHM_UNSPECIFIED = 0;
    public static final int KEYSTORE2_KEY_CREATION_WITH_PURPOSE_AND_MODES_INFO__ALGORITHM__RSA = 1;
    public static final int KEYSTORE2_KEY_CREATION_WITH_PURPOSE_AND_MODES_INFO__ALGORITHM__EC = 3;
    public static final int KEYSTORE2_KEY_CREATION_WITH_PURPOSE_AND_MODES_INFO__ALGORITHM__AES = 32;
    public static final int KEYSTORE2_KEY_CREATION_WITH_PURPOSE_AND_MODES_INFO__ALGORITHM__TRIPLE_DES = 33;
    public static final int KEYSTORE2_KEY_CREATION_WITH_PURPOSE_AND_MODES_INFO__ALGORITHM__HMAC = 128;

    // Values for Keystore2KeyOperationWithPurposeAndModesInfo.purpose
    public static final int KEYSTORE2_KEY_OPERATION_WITH_PURPOSE_AND_MODES_INFO__PURPOSE__KEY_PURPOSE_UNSPECIFIED = 0;
    public static final int KEYSTORE2_KEY_OPERATION_WITH_PURPOSE_AND_MODES_INFO__PURPOSE__ENCRYPT = 1;
    public static final int KEYSTORE2_KEY_OPERATION_WITH_PURPOSE_AND_MODES_INFO__PURPOSE__DECRYPT = 2;
    public static final int KEYSTORE2_KEY_OPERATION_WITH_PURPOSE_AND_MODES_INFO__PURPOSE__SIGN = 3;
    public static final int KEYSTORE2_KEY_OPERATION_WITH_PURPOSE_AND_MODES_INFO__PURPOSE__VERIFY = 4;
    public static final int KEYSTORE2_KEY_OPERATION_WITH_PURPOSE_AND_MODES_INFO__PURPOSE__WRAP_KEY = 6;
    public static final int KEYSTORE2_KEY_OPERATION_WITH_PURPOSE_AND_MODES_INFO__PURPOSE__AGREE_KEY = 7;
    public static final int KEYSTORE2_KEY_OPERATION_WITH_PURPOSE_AND_MODES_INFO__PURPOSE__ATTEST_KEY = 8;

    // Values for Keystore2KeyOperationWithGeneralInfo.outcome
    public static final int KEYSTORE2_KEY_OPERATION_WITH_GENERAL_INFO__OUTCOME__OUTCOME_UNSPECIFIED = 0;
    public static final int KEYSTORE2_KEY_OPERATION_WITH_GENERAL_INFO__OUTCOME__DROPPED = 1;
    public static final int KEYSTORE2_KEY_OPERATION_WITH_GENERAL_INFO__OUTCOME__SUCCESS = 2;
    public static final int KEYSTORE2_KEY_OPERATION_WITH_GENERAL_INFO__OUTCOME__ABORT = 3;
    public static final int KEYSTORE2_KEY_OPERATION_WITH_GENERAL_INFO__OUTCOME__PRUNED = 4;
    public static final int KEYSTORE2_KEY_OPERATION_WITH_GENERAL_INFO__OUTCOME__ERROR = 5;

    // Values for Keystore2KeyOperationWithGeneralInfo.security_level
    public static final int KEYSTORE2_KEY_OPERATION_WITH_GENERAL_INFO__SECURITY_LEVEL__SECURITY_LEVEL_UNSPECIFIED = 0;
    public static final int KEYSTORE2_KEY_OPERATION_WITH_GENERAL_INFO__SECURITY_LEVEL__SECURITY_LEVEL_SOFTWARE = 1;
    public static final int KEYSTORE2_KEY_OPERATION_WITH_GENERAL_INFO__SECURITY_LEVEL__SECURITY_LEVEL_TRUSTED_ENVIRONMENT = 2;
    public static final int KEYSTORE2_KEY_OPERATION_WITH_GENERAL_INFO__SECURITY_LEVEL__SECURITY_LEVEL_STRONGBOX = 3;
    public static final int KEYSTORE2_KEY_OPERATION_WITH_GENERAL_INFO__SECURITY_LEVEL__SECURITY_LEVEL_KEYSTORE = 4;

    // Values for RkpErrorStats.rkp_error
    public static final int RKP_ERROR_STATS__RKP_ERROR__RKP_ERROR_UNSPECIFIED = 0;
    public static final int RKP_ERROR_STATS__RKP_ERROR__OUT_OF_KEYS = 1;
    public static final int RKP_ERROR_STATS__RKP_ERROR__FALL_BACK_DURING_HYBRID = 2;

    // Values for RkpErrorStats.security_level
    public static final int RKP_ERROR_STATS__SECURITY_LEVEL__SECURITY_LEVEL_UNSPECIFIED = 0;
    public static final int RKP_ERROR_STATS__SECURITY_LEVEL__SECURITY_LEVEL_SOFTWARE = 1;
    public static final int RKP_ERROR_STATS__SECURITY_LEVEL__SECURITY_LEVEL_TRUSTED_ENVIRONMENT = 2;
    public static final int RKP_ERROR_STATS__SECURITY_LEVEL__SECURITY_LEVEL_STRONGBOX = 3;
    public static final int RKP_ERROR_STATS__SECURITY_LEVEL__SECURITY_LEVEL_KEYSTORE = 4;

    // Values for AccessibilityShortcutStats.software_shortcut_type
    public static final int ACCESSIBILITY_SHORTCUT_STATS__SOFTWARE_SHORTCUT_TYPE__UNKNOWN_TYPE = 0;
    public static final int ACCESSIBILITY_SHORTCUT_STATS__SOFTWARE_SHORTCUT_TYPE__A11Y_BUTTON = 1;
    public static final int ACCESSIBILITY_SHORTCUT_STATS__SOFTWARE_SHORTCUT_TYPE__VOLUME_KEY = 2;
    public static final int ACCESSIBILITY_SHORTCUT_STATS__SOFTWARE_SHORTCUT_TYPE__TRIPLE_TAP = 3;
    public static final int ACCESSIBILITY_SHORTCUT_STATS__SOFTWARE_SHORTCUT_TYPE__A11Y_BUTTON_LONG_PRESS = 4;
    public static final int ACCESSIBILITY_SHORTCUT_STATS__SOFTWARE_SHORTCUT_TYPE__A11Y_FLOATING_MENU = 5;
    public static final int ACCESSIBILITY_SHORTCUT_STATS__SOFTWARE_SHORTCUT_TYPE__A11Y_GESTURE = 6;
    public static final int ACCESSIBILITY_SHORTCUT_STATS__SOFTWARE_SHORTCUT_TYPE__A11Y_WEAR_TRIPLE_PRESS_GESTURE = 7;

    // Values for AccessibilityShortcutStats.hardware_shortcut_type
    public static final int ACCESSIBILITY_SHORTCUT_STATS__HARDWARE_SHORTCUT_TYPE__UNKNOWN_TYPE = 0;
    public static final int ACCESSIBILITY_SHORTCUT_STATS__HARDWARE_SHORTCUT_TYPE__A11Y_BUTTON = 1;
    public static final int ACCESSIBILITY_SHORTCUT_STATS__HARDWARE_SHORTCUT_TYPE__VOLUME_KEY = 2;
    public static final int ACCESSIBILITY_SHORTCUT_STATS__HARDWARE_SHORTCUT_TYPE__TRIPLE_TAP = 3;
    public static final int ACCESSIBILITY_SHORTCUT_STATS__HARDWARE_SHORTCUT_TYPE__A11Y_BUTTON_LONG_PRESS = 4;
    public static final int ACCESSIBILITY_SHORTCUT_STATS__HARDWARE_SHORTCUT_TYPE__A11Y_FLOATING_MENU = 5;
    public static final int ACCESSIBILITY_SHORTCUT_STATS__HARDWARE_SHORTCUT_TYPE__A11Y_GESTURE = 6;
    public static final int ACCESSIBILITY_SHORTCUT_STATS__HARDWARE_SHORTCUT_TYPE__A11Y_WEAR_TRIPLE_PRESS_GESTURE = 7;

    // Values for AccessibilityShortcutStats.gesture_shortcut_type
    public static final int ACCESSIBILITY_SHORTCUT_STATS__GESTURE_SHORTCUT_TYPE__UNKNOWN_TYPE = 0;
    public static final int ACCESSIBILITY_SHORTCUT_STATS__GESTURE_SHORTCUT_TYPE__A11Y_BUTTON = 1;
    public static final int ACCESSIBILITY_SHORTCUT_STATS__GESTURE_SHORTCUT_TYPE__VOLUME_KEY = 2;
    public static final int ACCESSIBILITY_SHORTCUT_STATS__GESTURE_SHORTCUT_TYPE__TRIPLE_TAP = 3;
    public static final int ACCESSIBILITY_SHORTCUT_STATS__GESTURE_SHORTCUT_TYPE__A11Y_BUTTON_LONG_PRESS = 4;
    public static final int ACCESSIBILITY_SHORTCUT_STATS__GESTURE_SHORTCUT_TYPE__A11Y_FLOATING_MENU = 5;
    public static final int ACCESSIBILITY_SHORTCUT_STATS__GESTURE_SHORTCUT_TYPE__A11Y_GESTURE = 6;
    public static final int ACCESSIBILITY_SHORTCUT_STATS__GESTURE_SHORTCUT_TYPE__A11Y_WEAR_TRIPLE_PRESS_GESTURE = 7;

    // Values for DataUsageBytesTransferV2.opportunistic_data_sub
    public static final int DATA_USAGE_BYTES_TRANSFER_V2__OPPORTUNISTIC_DATA_SUB__DSS_UNKNOWN = 0;
    public static final int DATA_USAGE_BYTES_TRANSFER_V2__OPPORTUNISTIC_DATA_SUB__DSS_ALL = 1;
    public static final int DATA_USAGE_BYTES_TRANSFER_V2__OPPORTUNISTIC_DATA_SUB__DSS_OPPORTUNISTIC = 2;
    public static final int DATA_USAGE_BYTES_TRANSFER_V2__OPPORTUNISTIC_DATA_SUB__DSS_NOT_OPPORTUNISTIC = 3;

    // Values for DataUsageBytesTransferV2.metered
    public static final int DATA_USAGE_BYTES_TRANSFER_V2__METERED__METERED_UNKNOWN = 0;
    public static final int DATA_USAGE_BYTES_TRANSFER_V2__METERED__METERED_ALL = 1;
    public static final int DATA_USAGE_BYTES_TRANSFER_V2__METERED__METERED_NO = 2;
    public static final int DATA_USAGE_BYTES_TRANSFER_V2__METERED__METERED_YES = 3;

    // Values for MediaCapabilities.surround_output_mode
    public static final int MEDIA_CAPABILITIES__SURROUND_OUTPUT_MODE__ENCODED_SURROUND_OUTPUT_UNKNOWN = 0;
    public static final int MEDIA_CAPABILITIES__SURROUND_OUTPUT_MODE__ENCODED_SURROUND_OUTPUT_AUTO = 1;
    public static final int MEDIA_CAPABILITIES__SURROUND_OUTPUT_MODE__ENCODED_SURROUND_OUTPUT_NEVER = 2;
    public static final int MEDIA_CAPABILITIES__SURROUND_OUTPUT_MODE__ENCODED_SURROUND_OUTPUT_ALWAYS = 3;
    public static final int MEDIA_CAPABILITIES__SURROUND_OUTPUT_MODE__ENCODED_SURROUND_OUTPUT_MANUAL = 4;

    // Values for MediaCapabilities.match_content_refresh_rate_preference
    public static final int MEDIA_CAPABILITIES__MATCH_CONTENT_REFRESH_RATE_PREFERENCE__MATCH_CONTENT_FRAMERATE_UNKNOWN = 0;
    public static final int MEDIA_CAPABILITIES__MATCH_CONTENT_REFRESH_RATE_PREFERENCE__MATCH_CONTENT_FRAMERATE_NEVER = 1;
    public static final int MEDIA_CAPABILITIES__MATCH_CONTENT_REFRESH_RATE_PREFERENCE__MATCH_CONTENT_FRAMERATE_SEAMLESSS_ONLY = 2;
    public static final int MEDIA_CAPABILITIES__MATCH_CONTENT_REFRESH_RATE_PREFERENCE__MATCH_CONTENT_FRAMERATE_ALWAYS = 3;

    // Values for UserInfo.user_type
    public static final int USER_INFO__USER_TYPE__TYPE_UNKNOWN = 0;
    public static final int USER_INFO__USER_TYPE__FULL_SYSTEM = 1;
    public static final int USER_INFO__USER_TYPE__FULL_SECONDARY = 2;
    public static final int USER_INFO__USER_TYPE__FULL_GUEST = 3;
    public static final int USER_INFO__USER_TYPE__FULL_DEMO = 4;
    public static final int USER_INFO__USER_TYPE__FULL_RESTRICTED = 5;
    public static final int USER_INFO__USER_TYPE__PROFILE_MANAGED = 6;
    public static final int USER_INFO__USER_TYPE__SYSTEM_HEADLESS = 7;
    public static final int USER_INFO__USER_TYPE__PROFILE_CLONE = 8;

    // Values for GameModeInfo.overridden_game_modes
    public static final int GAME_MODE_INFO__OVERRIDDEN_GAME_MODES__GAME_MODE_UNSPECIFIED = 0;
    public static final int GAME_MODE_INFO__OVERRIDDEN_GAME_MODES__GAME_MODE_UNSUPPORTED = 1;
    public static final int GAME_MODE_INFO__OVERRIDDEN_GAME_MODES__GAME_MODE_STANDARD = 2;
    public static final int GAME_MODE_INFO__OVERRIDDEN_GAME_MODES__GAME_MODE_PERFORMANCE = 3;
    public static final int GAME_MODE_INFO__OVERRIDDEN_GAME_MODES__GAME_MODE_BATTERY = 4;
    public static final int GAME_MODE_INFO__OVERRIDDEN_GAME_MODES__GAME_MODE_CUSTOM = 5;

    // Values for GameModeInfo.available_game_modes
    public static final int GAME_MODE_INFO__AVAILABLE_GAME_MODES__GAME_MODE_UNSPECIFIED = 0;
    public static final int GAME_MODE_INFO__AVAILABLE_GAME_MODES__GAME_MODE_UNSUPPORTED = 1;
    public static final int GAME_MODE_INFO__AVAILABLE_GAME_MODES__GAME_MODE_STANDARD = 2;
    public static final int GAME_MODE_INFO__AVAILABLE_GAME_MODES__GAME_MODE_PERFORMANCE = 3;
    public static final int GAME_MODE_INFO__AVAILABLE_GAME_MODES__GAME_MODE_BATTERY = 4;
    public static final int GAME_MODE_INFO__AVAILABLE_GAME_MODES__GAME_MODE_CUSTOM = 5;

    // Values for GameModeConfiguration.game_mode
    public static final int GAME_MODE_CONFIGURATION__GAME_MODE__GAME_MODE_UNSPECIFIED = 0;
    public static final int GAME_MODE_CONFIGURATION__GAME_MODE__GAME_MODE_UNSUPPORTED = 1;
    public static final int GAME_MODE_CONFIGURATION__GAME_MODE__GAME_MODE_STANDARD = 2;
    public static final int GAME_MODE_CONFIGURATION__GAME_MODE__GAME_MODE_PERFORMANCE = 3;
    public static final int GAME_MODE_CONFIGURATION__GAME_MODE__GAME_MODE_BATTERY = 4;
    public static final int GAME_MODE_CONFIGURATION__GAME_MODE__GAME_MODE_CUSTOM = 5;

    // Values for HdrCapabilities.force_hdr_format
    public static final int HDR_CAPABILITIES__FORCE_HDR_FORMAT__HDR_TYPE_UNKNOWN = 0;
    public static final int HDR_CAPABILITIES__FORCE_HDR_FORMAT__HDR_TYPE_DOLBY_VISION = 1;
    public static final int HDR_CAPABILITIES__FORCE_HDR_FORMAT__HDR_TYPE_HDR10 = 2;
    public static final int HDR_CAPABILITIES__FORCE_HDR_FORMAT__HDR_TYPE_HLG = 3;
    public static final int HDR_CAPABILITIES__FORCE_HDR_FORMAT__HDR_TYPE_HDR10_PLUS = 4;

    // Values for MteState.state
    public static final int MTE_STATE__STATE__UNKNOWN = 0;
    public static final int MTE_STATE__STATE__OFF = 1;
    public static final int MTE_STATE__STATE__ON = 2;

    // Annotation constants.
    public static final byte ANNOTATION_ID_IS_UID = StatsLog.ANNOTATION_ID_IS_UID;
    public static final byte ANNOTATION_ID_TRUNCATE_TIMESTAMP = StatsLog.ANNOTATION_ID_TRUNCATE_TIMESTAMP;
    public static final byte ANNOTATION_ID_PRIMARY_FIELD = StatsLog.ANNOTATION_ID_PRIMARY_FIELD;
    public static final byte ANNOTATION_ID_EXCLUSIVE_STATE = StatsLog.ANNOTATION_ID_EXCLUSIVE_STATE;
    public static final byte ANNOTATION_ID_PRIMARY_FIELD_FIRST_UID = StatsLog.ANNOTATION_ID_PRIMARY_FIELD_FIRST_UID;
    public static final byte ANNOTATION_ID_DEFAULT_STATE = StatsLog.ANNOTATION_ID_DEFAULT_STATE;
    public static final byte ANNOTATION_ID_TRIGGER_STATE_RESET = StatsLog.ANNOTATION_ID_TRIGGER_STATE_RESET;
    public static final byte ANNOTATION_ID_STATE_NESTED = StatsLog.ANNOTATION_ID_STATE_NESTED;

    // Write methods
    public static void write(int code) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, byte[] arg1, float arg2, int arg3, int arg4, int arg5, float arg6) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeByteArray(null == arg1 ? new byte[0] : arg1);
        builder.writeFloat(arg2);
        builder.writeInt(arg3);
        builder.writeInt(arg4);
        builder.writeInt(arg5);
        builder.writeFloat(arg6);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int[] uid, java.lang.String[] tag, int arg2) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        if (MOBILE_RADIO_POWER_STATE_CHANGED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_TRUNCATE_TIMESTAMP, true);
        }
        if (AUDIO_STATE_CHANGED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_TRUNCATE_TIMESTAMP, true);
        }
        builder.writeAttributionChain(
                null == uid ? new int[0] : uid,
                null == tag ? new String[0] : tag);
        builder.writeInt(arg2);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int[] uid, java.lang.String[] tag, int arg2, int arg3) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeAttributionChain(
                null == uid ? new int[0] : uid,
                null == tag ? new String[0] : tag);
        builder.writeInt(arg2);
        builder.writeInt(arg3);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int[] uid, java.lang.String[] tag, int arg2, int arg3, int arg4, boolean arg5, int arg6, int arg7, int arg8, long arg9, long arg10, long arg11, long arg12, int arg13, int arg14, int arg15, int arg16, int arg17, int arg18, int arg19, int[] arg20, int[] arg21, int[] arg22, int[] arg23, int arg24, int arg25) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeAttributionChain(
                null == uid ? new int[0] : uid,
                null == tag ? new String[0] : tag);
        builder.writeInt(arg2);
        builder.writeInt(arg3);
        builder.writeInt(arg4);
        builder.writeBoolean(arg5);
        builder.writeInt(arg6);
        builder.writeInt(arg7);
        builder.writeInt(arg8);
        builder.writeLong(arg9);
        builder.writeLong(arg10);
        builder.writeLong(arg11);
        builder.writeLong(arg12);
        builder.writeInt(arg13);
        builder.writeInt(arg14);
        builder.writeInt(arg15);
        builder.writeInt(arg16);
        builder.writeInt(arg17);
        builder.writeInt(arg18);
        builder.writeInt(arg19);
        builder.writeIntArray(null == arg20 ? new int[0] : arg20);
        builder.writeIntArray(null == arg21 ? new int[0] : arg21);
        builder.writeIntArray(null == arg22 ? new int[0] : arg22);
        builder.writeIntArray(null == arg23 ? new int[0] : arg23);
        builder.writeInt(arg24);
        builder.writeInt(arg25);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int[] uid, java.lang.String[] tag, int arg2, int arg3, java.lang.String arg4) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeAttributionChain(
                null == uid ? new int[0] : uid,
                null == tag ? new String[0] : tag);
        builder.writeInt(arg2);
        builder.writeInt(arg3);
        builder.writeString(arg4);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int[] uid, java.lang.String[] tag, int arg2, long arg3) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeAttributionChain(
                null == uid ? new int[0] : uid,
                null == tag ? new String[0] : tag);
        builder.writeInt(arg2);
        builder.writeLong(arg3);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int[] uid, java.lang.String[] tag, int arg2, java.lang.String arg3, int arg4, int arg5) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeAttributionChain(
                null == uid ? new int[0] : uid,
                null == tag ? new String[0] : tag);
        if (WAKELOCK_STATE_CHANGED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_PRIMARY_FIELD_FIRST_UID, true);
        }
        builder.writeInt(arg2);
        if (WAKELOCK_STATE_CHANGED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_PRIMARY_FIELD, true);
        }
        builder.writeString(arg3);
        if (WAKELOCK_STATE_CHANGED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_PRIMARY_FIELD, true);
        }
        builder.writeInt(arg4);
        if (WAKELOCK_STATE_CHANGED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_EXCLUSIVE_STATE, true);
            builder.addBooleanAnnotation(ANNOTATION_ID_STATE_NESTED, true);
        }
        builder.writeInt(arg5);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int[] uid, java.lang.String[] tag, int arg2, java.lang.String arg3, int arg4, int arg5, int arg6) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeAttributionChain(
                null == uid ? new int[0] : uid,
                null == tag ? new String[0] : tag);
        if (TIF_TUNE_CHANGED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_PRIMARY_FIELD_FIRST_UID, true);
        }
        builder.writeInt(arg2);
        if (TIF_TUNE_CHANGED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_EXCLUSIVE_STATE, true);
            builder.addBooleanAnnotation(ANNOTATION_ID_STATE_NESTED, false);
        }
        builder.writeString(arg3);
        if (TIF_TUNE_CHANGED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_PRIMARY_FIELD, true);
        }
        builder.writeInt(arg4);
        builder.writeInt(arg5);
        if (TIF_TUNE_CHANGED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_PRIMARY_FIELD, true);
        }
        builder.writeInt(arg6);
        if (TIF_TUNE_CHANGED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_PRIMARY_FIELD, true);
        }

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int[] uid, java.lang.String[] tag, java.lang.String arg2, int arg3) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeAttributionChain(
                null == uid ? new int[0] : uid,
                null == tag ? new String[0] : tag);
        builder.writeString(arg2);
        builder.writeInt(arg3);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int[] uid, java.lang.String[] tag, java.lang.String arg2, int arg3, int arg4) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeAttributionChain(
                null == uid ? new int[0] : uid,
                null == tag ? new String[0] : tag);
        builder.writeString(arg2);
        builder.writeInt(arg3);
        builder.writeInt(arg4);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int[] uid, java.lang.String[] tag, java.lang.String arg2, int arg3, int arg4, int arg5, int arg6, boolean arg7, boolean arg8, boolean arg9, boolean arg10, boolean arg11, boolean arg12, boolean arg13, boolean arg14, boolean arg15, boolean arg16, int arg17, boolean arg18, int arg19, int arg20, int arg21, long arg22, boolean arg23, boolean arg24, boolean arg25, boolean arg26, boolean arg27, boolean arg28, boolean arg29, boolean arg30, long arg31, boolean arg32, boolean arg33, boolean arg34, long arg35, long arg36, long arg37, int arg38, int arg39) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeAttributionChain(
                null == uid ? new int[0] : uid,
                null == tag ? new String[0] : tag);
        builder.writeString(arg2);
        builder.writeInt(arg3);
        builder.writeInt(arg4);
        builder.writeInt(arg5);
        builder.writeInt(arg6);
        builder.writeBoolean(arg7);
        builder.writeBoolean(arg8);
        builder.writeBoolean(arg9);
        builder.writeBoolean(arg10);
        builder.writeBoolean(arg11);
        builder.writeBoolean(arg12);
        builder.writeBoolean(arg13);
        builder.writeBoolean(arg14);
        builder.writeBoolean(arg15);
        builder.writeBoolean(arg16);
        builder.writeInt(arg17);
        builder.writeBoolean(arg18);
        builder.writeInt(arg19);
        builder.writeInt(arg20);
        builder.writeInt(arg21);
        builder.writeLong(arg22);
        builder.writeBoolean(arg23);
        builder.writeBoolean(arg24);
        builder.writeBoolean(arg25);
        builder.writeBoolean(arg26);
        builder.writeBoolean(arg27);
        builder.writeBoolean(arg28);
        builder.writeBoolean(arg29);
        builder.writeBoolean(arg30);
        builder.writeLong(arg31);
        builder.writeBoolean(arg32);
        builder.writeBoolean(arg33);
        builder.writeBoolean(arg34);
        builder.writeLong(arg35);
        builder.writeLong(arg36);
        builder.writeLong(arg37);
        builder.writeInt(arg38);
        builder.writeInt(arg39);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int[] uid, java.lang.String[] tag, java.lang.String arg2, java.lang.String arg3, int arg4) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeAttributionChain(
                null == uid ? new int[0] : uid,
                null == tag ? new String[0] : tag);
        builder.writeString(arg2);
        builder.writeString(arg3);
        builder.writeInt(arg4);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, boolean arg1) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeBoolean(arg1);
        if (LOCATION_ENABLED_STATE_CHANGED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_EXCLUSIVE_STATE, true);
        }
        if (EMERGENCY_STATE_CHANGED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_EXCLUSIVE_STATE, true);
        }

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, boolean arg1, boolean arg2, boolean arg3, boolean arg4, int arg5) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeBoolean(arg1);
        builder.writeBoolean(arg2);
        builder.writeBoolean(arg3);
        builder.writeBoolean(arg4);
        builder.writeInt(arg5);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, boolean arg1, int arg2, int arg3) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeBoolean(arg1);
        builder.writeInt(arg2);
        builder.writeInt(arg3);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, boolean arg1, int arg2, int arg3, int arg4, int arg5, int arg6, int arg7) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeBoolean(arg1);
        builder.writeInt(arg2);
        builder.writeInt(arg3);
        builder.writeInt(arg4);
        builder.writeInt(arg5);
        builder.writeInt(arg6);
        builder.writeInt(arg7);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, boolean arg1, java.lang.String arg2, long arg3, int arg4, long arg5, int arg6) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeBoolean(arg1);
        builder.writeString(arg2);
        builder.writeLong(arg3);
        builder.writeInt(arg4);
        builder.writeLong(arg5);
        builder.writeInt(arg6);
        if (PACKAGE_INSTALLER_V2_REPORTED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, boolean arg1, java.lang.String arg2, long arg3, long arg4) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeBoolean(arg1);
        builder.writeString(arg2);
        builder.writeLong(arg3);
        builder.writeLong(arg4);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, boolean arg1, java.lang.String arg2, java.lang.String arg3) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeBoolean(arg1);
        builder.writeString(arg2);
        builder.writeString(arg3);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        if (PHONE_SIGNAL_STRENGTH_CHANGED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_TRUNCATE_TIMESTAMP, true);
        }
        builder.writeInt(arg1);
        if (ACTIVITY_MANAGER_SLEEP_STATE_CHANGED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_EXCLUSIVE_STATE, true);
            builder.addBooleanAnnotation(ANNOTATION_ID_STATE_NESTED, false);
        }
        if (MEMORY_FACTOR_STATE_CHANGED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_EXCLUSIVE_STATE, true);
        }
        if (BATTERY_SAVER_MODE_STATE_CHANGED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_EXCLUSIVE_STATE, true);
            builder.addBooleanAnnotation(ANNOTATION_ID_STATE_NESTED, false);
        }
        if (DEVICE_IDLE_MODE_STATE_CHANGED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_EXCLUSIVE_STATE, true);
            builder.addBooleanAnnotation(ANNOTATION_ID_STATE_NESTED, false);
        }
        if (DEVICE_IDLING_MODE_STATE_CHANGED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_EXCLUSIVE_STATE, true);
            builder.addBooleanAnnotation(ANNOTATION_ID_STATE_NESTED, false);
        }
        if (SCREEN_STATE_CHANGED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_EXCLUSIVE_STATE, true);
            builder.addBooleanAnnotation(ANNOTATION_ID_STATE_NESTED, false);
        }
        if (CHARGING_STATE_CHANGED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_EXCLUSIVE_STATE, true);
            builder.addBooleanAnnotation(ANNOTATION_ID_STATE_NESTED, false);
        }
        if (PLUGGED_STATE_CHANGED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_EXCLUSIVE_STATE, true);
            builder.addBooleanAnnotation(ANNOTATION_ID_STATE_NESTED, false);
        }
        if (DOCK_STATE_CHANGED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_EXCLUSIVE_STATE, true);
            builder.addBooleanAnnotation(ANNOTATION_ID_STATE_NESTED, false);
        }

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, boolean arg2) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        if (DEVICE_STATE_CHANGED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_EXCLUSIVE_STATE, true);
            builder.addBooleanAnnotation(ANNOTATION_ID_STATE_NESTED, false);
        }
        builder.writeBoolean(arg2);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, boolean arg2, boolean arg3, boolean arg4, boolean arg5, boolean arg6, int arg7, boolean arg8, int arg9) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        if (ALARM_SCHEDULED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeBoolean(arg2);
        builder.writeBoolean(arg3);
        builder.writeBoolean(arg4);
        builder.writeBoolean(arg5);
        builder.writeBoolean(arg6);
        builder.writeInt(arg7);
        builder.writeBoolean(arg8);
        builder.writeInt(arg9);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, boolean arg2, int arg3) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeBoolean(arg2);
        builder.writeInt(arg3);
        if (HOTWORD_DETECTOR_CREATE_REQUESTED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, int arg2) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        if (UID_PROCESS_STATE_CHANGED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
            builder.addBooleanAnnotation(ANNOTATION_ID_PRIMARY_FIELD, true);
        }
        if (TV_TUNER_STATE_CHANGED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        if (LOCATION_TIME_ZONE_PROVIDER_STATE_CHANGED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_PRIMARY_FIELD, true);
        }
        if (SIZE_COMPAT_RESTART_BUTTON_EVENT_REPORTED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        if (CAMERA_COMPAT_CONTROL_EVENT_REPORTED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        if (LETTERBOX_POSITION_CHANGED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        if (DEVICE_WIDE_JOB_CONSTRAINT_CHANGED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_PRIMARY_FIELD, true);
        }
        if (SCREEN_STATE_CHANGED_V2 == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_EXCLUSIVE_STATE, true);
            builder.addBooleanAnnotation(ANNOTATION_ID_STATE_NESTED, false);
        }
        builder.writeInt(arg2);
        if (UID_PROCESS_STATE_CHANGED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_EXCLUSIVE_STATE, true);
            builder.addBooleanAnnotation(ANNOTATION_ID_STATE_NESTED, false);
        }
        if (DISPLAY_WAKE_REPORTED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        if (LOCATION_TIME_ZONE_PROVIDER_STATE_CHANGED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_EXCLUSIVE_STATE, true);
        }
        if (DEVICE_WIDE_JOB_CONSTRAINT_CHANGED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_EXCLUSIVE_STATE, true);
            builder.addBooleanAnnotation(ANNOTATION_ID_STATE_NESTED, false);
        }
        if (SCREEN_STATE_CHANGED_V2 == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_PRIMARY_FIELD, true);
        }

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, int arg2, boolean arg3, boolean arg4) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeInt(arg2);
        if (GRAMMATICAL_INFLECTION_CHANGED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeBoolean(arg3);
        builder.writeBoolean(arg4);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, int arg2, boolean arg3, boolean arg4, boolean arg5, int arg6, long arg7) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeInt(arg2);
        builder.writeBoolean(arg3);
        builder.writeBoolean(arg4);
        builder.writeBoolean(arg5);
        builder.writeInt(arg6);
        builder.writeLong(arg7);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, int arg2, boolean arg3, int arg4) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        if (SYNC_EXEMPTION_OCCURRED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeInt(arg2);
        builder.writeBoolean(arg3);
        builder.writeInt(arg4);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, int arg2, boolean arg3, int arg4, boolean arg5, int arg6, long arg7, boolean arg8, int arg9, float arg10, int arg11, int arg12, boolean arg13, boolean arg14, int arg15, int arg16, int arg17, int arg18, int arg19, int[] arg20) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeInt(arg2);
        builder.writeBoolean(arg3);
        builder.writeInt(arg4);
        builder.writeBoolean(arg5);
        builder.writeInt(arg6);
        builder.writeLong(arg7);
        builder.writeBoolean(arg8);
        builder.writeInt(arg9);
        builder.writeFloat(arg10);
        builder.writeInt(arg11);
        builder.writeInt(arg12);
        builder.writeBoolean(arg13);
        builder.writeBoolean(arg14);
        builder.writeInt(arg15);
        builder.writeInt(arg16);
        builder.writeInt(arg17);
        builder.writeInt(arg18);
        builder.writeInt(arg19);
        builder.writeIntArray(null == arg20 ? new int[0] : arg20);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, int arg2, boolean arg3, int arg4, int arg5, int arg6, int arg7, boolean arg8, int arg9, int arg10, int arg11, boolean arg12, boolean arg13, int arg14, int arg15, int arg16, int arg17, int arg18) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeInt(arg2);
        builder.writeBoolean(arg3);
        builder.writeInt(arg4);
        builder.writeInt(arg5);
        builder.writeInt(arg6);
        builder.writeInt(arg7);
        builder.writeBoolean(arg8);
        builder.writeInt(arg9);
        builder.writeInt(arg10);
        builder.writeInt(arg11);
        builder.writeBoolean(arg12);
        builder.writeBoolean(arg13);
        builder.writeInt(arg14);
        builder.writeInt(arg15);
        builder.writeInt(arg16);
        builder.writeInt(arg17);
        builder.writeInt(arg18);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, int arg2, boolean arg3, int arg4, int arg5, int arg6, int arg7, boolean arg8, long arg9, int arg10, int arg11, int arg12, boolean arg13, boolean arg14, int arg15, int arg16, int arg17, int arg18, int arg19, int[] arg20) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeInt(arg2);
        builder.writeBoolean(arg3);
        builder.writeInt(arg4);
        builder.writeInt(arg5);
        builder.writeInt(arg6);
        builder.writeInt(arg7);
        builder.writeBoolean(arg8);
        builder.writeLong(arg9);
        builder.writeInt(arg10);
        builder.writeInt(arg11);
        builder.writeInt(arg12);
        builder.writeBoolean(arg13);
        builder.writeBoolean(arg14);
        builder.writeInt(arg15);
        builder.writeInt(arg16);
        builder.writeInt(arg17);
        builder.writeInt(arg18);
        builder.writeInt(arg19);
        builder.writeIntArray(null == arg20 ? new int[0] : arg20);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, int arg2, boolean arg3, int arg4, int arg5, int arg6, int arg7, int arg8, int arg9, boolean arg10, int[] arg11, int[] arg12, java.lang.String[] arg13, int[] arg14, java.lang.String arg15, int[] arg16, int[] arg17, int arg18, boolean arg19) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeInt(arg2);
        builder.writeBoolean(arg3);
        builder.writeInt(arg4);
        builder.writeInt(arg5);
        builder.writeInt(arg6);
        builder.writeInt(arg7);
        builder.writeInt(arg8);
        builder.writeInt(arg9);
        builder.writeBoolean(arg10);
        builder.writeIntArray(null == arg11 ? new int[0] : arg11);
        builder.writeIntArray(null == arg12 ? new int[0] : arg12);
        builder.writeStringArray(null == arg13 ? new String[0] : arg13);
        builder.writeIntArray(null == arg14 ? new int[0] : arg14);
        builder.writeString(arg15);
        builder.writeIntArray(null == arg16 ? new int[0] : arg16);
        builder.writeIntArray(null == arg17 ? new int[0] : arg17);
        builder.writeInt(arg18);
        builder.writeBoolean(arg19);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, int arg2, boolean arg3, int arg4, int arg5, int arg6, int arg7, int arg8, int arg9, int arg10, boolean arg11, int[] arg12, int arg13, int arg14, int arg15, int arg16, int arg17, int[] arg18, int[] arg19, int arg20, int[] arg21, int[] arg22, java.lang.String[] arg23, int[] arg24, java.lang.String arg25, boolean arg26) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeInt(arg2);
        builder.writeBoolean(arg3);
        builder.writeInt(arg4);
        if (CREDENTIAL_MANAGER_FINAL_PHASE_REPORTED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeInt(arg5);
        builder.writeInt(arg6);
        builder.writeInt(arg7);
        builder.writeInt(arg8);
        builder.writeInt(arg9);
        builder.writeInt(arg10);
        builder.writeBoolean(arg11);
        builder.writeIntArray(null == arg12 ? new int[0] : arg12);
        builder.writeInt(arg13);
        builder.writeInt(arg14);
        builder.writeInt(arg15);
        builder.writeInt(arg16);
        builder.writeInt(arg17);
        builder.writeIntArray(null == arg18 ? new int[0] : arg18);
        builder.writeIntArray(null == arg19 ? new int[0] : arg19);
        builder.writeInt(arg20);
        builder.writeIntArray(null == arg21 ? new int[0] : arg21);
        builder.writeIntArray(null == arg22 ? new int[0] : arg22);
        builder.writeStringArray(null == arg23 ? new String[0] : arg23);
        builder.writeIntArray(null == arg24 ? new int[0] : arg24);
        builder.writeString(arg25);
        builder.writeBoolean(arg26);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, int arg2, boolean arg3, int arg4, int arg5, int arg6, java.lang.String[] arg7, int[] arg8, int[] arg9, int[] arg10, int arg11, java.lang.String[] arg12, int[] arg13, java.lang.String[] arg14, int[] arg15, int[] arg16, int[] arg17, int arg18, java.lang.String[] arg19, int[] arg20, int arg21, boolean arg22) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeInt(arg2);
        builder.writeBoolean(arg3);
        builder.writeInt(arg4);
        builder.writeInt(arg5);
        builder.writeInt(arg6);
        builder.writeStringArray(null == arg7 ? new String[0] : arg7);
        builder.writeIntArray(null == arg8 ? new int[0] : arg8);
        builder.writeIntArray(null == arg9 ? new int[0] : arg9);
        builder.writeIntArray(null == arg10 ? new int[0] : arg10);
        builder.writeInt(arg11);
        builder.writeStringArray(null == arg12 ? new String[0] : arg12);
        builder.writeIntArray(null == arg13 ? new int[0] : arg13);
        builder.writeStringArray(null == arg14 ? new String[0] : arg14);
        builder.writeIntArray(null == arg15 ? new int[0] : arg15);
        builder.writeIntArray(null == arg16 ? new int[0] : arg16);
        builder.writeIntArray(null == arg17 ? new int[0] : arg17);
        builder.writeInt(arg18);
        builder.writeStringArray(null == arg19 ? new String[0] : arg19);
        builder.writeIntArray(null == arg20 ? new int[0] : arg20);
        builder.writeInt(arg21);
        builder.writeBoolean(arg22);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, int arg2, boolean arg3, int arg4, int arg5, long arg6) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        if (IN_TASK_ACTIVITY_STARTED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeInt(arg2);
        builder.writeBoolean(arg3);
        builder.writeInt(arg4);
        builder.writeInt(arg5);
        builder.writeLong(arg6);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, int arg2, boolean arg3, int[] arg4, int[] arg5, int[] arg6, int[] arg7, boolean[] arg8, int[] arg9, int[] arg10, int[] arg11, int[] arg12, int[] arg13, int[] arg14, java.lang.String[] arg15, boolean arg16, java.lang.String[] arg17, int[] arg18, int arg19, boolean[] arg20) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeInt(arg2);
        builder.writeBoolean(arg3);
        builder.writeIntArray(null == arg4 ? new int[0] : arg4);
        if (CREDENTIAL_MANAGER_CANDIDATE_PHASE_REPORTED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeIntArray(null == arg5 ? new int[0] : arg5);
        builder.writeIntArray(null == arg6 ? new int[0] : arg6);
        builder.writeIntArray(null == arg7 ? new int[0] : arg7);
        builder.writeBooleanArray(null == arg8 ? new boolean[0] : arg8);
        builder.writeIntArray(null == arg9 ? new int[0] : arg9);
        builder.writeIntArray(null == arg10 ? new int[0] : arg10);
        builder.writeIntArray(null == arg11 ? new int[0] : arg11);
        builder.writeIntArray(null == arg12 ? new int[0] : arg12);
        builder.writeIntArray(null == arg13 ? new int[0] : arg13);
        builder.writeIntArray(null == arg14 ? new int[0] : arg14);
        builder.writeStringArray(null == arg15 ? new String[0] : arg15);
        builder.writeBoolean(arg16);
        builder.writeStringArray(null == arg17 ? new String[0] : arg17);
        builder.writeIntArray(null == arg18 ? new int[0] : arg18);
        builder.writeInt(arg19);
        builder.writeBooleanArray(null == arg20 ? new boolean[0] : arg20);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, int arg2, int arg3) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        if (TV_CAS_SESSION_OPEN_STATUS == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        if (REBOOT_ESCROW_PREPARATION_REPORTED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        if (REBOOT_ESCROW_LSKF_CAPTURE_REPORTED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        if (APP_COMPAT_STATE_CHANGED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
            builder.addBooleanAnnotation(ANNOTATION_ID_PRIMARY_FIELD, true);
        }
        builder.writeInt(arg2);
        if (APP_COMPAT_STATE_CHANGED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_EXCLUSIVE_STATE, true);
            builder.addBooleanAnnotation(ANNOTATION_ID_STATE_NESTED, false);
        }
        if (AUTOFILL_UI_EVENT_REPORTED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        if (CREDENTIAL_MANAGER_APIV2_CALLED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeInt(arg3);
        if (HOTWORD_DETECTION_SERVICE_INIT_RESULT_REPORTED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        if (HOTWORD_DETECTION_SERVICE_RESTARTED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        if (HOTWORD_DETECTOR_KEYPHRASE_TRIGGERED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        if (HOTWORD_DETECTOR_EVENTS == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        if (AUTOFILL_UI_EVENT_REPORTED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, int arg2, int arg3, boolean arg4, boolean arg5, boolean arg6, int arg7) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        if (APP_SUPPORTED_LOCALES_CHANGED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeInt(arg2);
        if (APP_SUPPORTED_LOCALES_CHANGED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeInt(arg3);
        builder.writeBoolean(arg4);
        builder.writeBoolean(arg5);
        builder.writeBoolean(arg6);
        builder.writeInt(arg7);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, int arg2, int arg3, boolean arg4, boolean arg5, boolean arg6, int arg7, int arg8, java.lang.String arg9, java.lang.String arg10, int arg11, int arg12, boolean arg13, boolean arg14, int arg15) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeInt(arg2);
        builder.writeInt(arg3);
        builder.writeBoolean(arg4);
        builder.writeBoolean(arg5);
        builder.writeBoolean(arg6);
        builder.writeInt(arg7);
        builder.writeInt(arg8);
        builder.writeString(arg9);
        builder.writeString(arg10);
        builder.writeInt(arg11);
        builder.writeInt(arg12);
        builder.writeBoolean(arg13);
        builder.writeBoolean(arg14);
        builder.writeInt(arg15);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, int arg2, int arg3, int arg4) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        if (GAME_MODE_CHANGED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeInt(arg2);
        if (GAME_MODE_CHANGED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeInt(arg3);
        builder.writeInt(arg4);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, int arg2, int arg3, int arg4, byte[] arg5, byte[] arg6, byte[] arg7, byte[] arg8, int arg9, int arg10, int arg11, boolean arg12, int arg13) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        if (APP_BACKGROUND_RESTRICTIONS_INFO == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeInt(arg2);
        builder.writeInt(arg3);
        builder.writeInt(arg4);
        builder.writeByteArray(null == arg5 ? new byte[0] : arg5);
        builder.writeByteArray(null == arg6 ? new byte[0] : arg6);
        builder.writeByteArray(null == arg7 ? new byte[0] : arg7);
        builder.writeByteArray(null == arg8 ? new byte[0] : arg8);
        builder.writeInt(arg9);
        builder.writeInt(arg10);
        builder.writeInt(arg11);
        builder.writeBoolean(arg12);
        builder.writeInt(arg13);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, int arg2, int arg3, int arg4, boolean arg5, boolean arg6, boolean arg7, int arg8, long arg9, int arg10, int arg11) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeInt(arg2);
        builder.writeInt(arg3);
        if (AUTOFILL_FILL_REQUEST_REPORTED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeInt(arg4);
        if (AUTOFILL_FILL_REQUEST_REPORTED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeBoolean(arg5);
        builder.writeBoolean(arg6);
        builder.writeBoolean(arg7);
        builder.writeInt(arg8);
        builder.writeLong(arg9);
        builder.writeInt(arg10);
        builder.writeInt(arg11);
        if (AUTOFILL_FILL_REQUEST_REPORTED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, int arg2, int arg3, int arg4, boolean arg5, boolean arg6, int arg7, int arg8) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeInt(arg2);
        if (REBOOT_ESCROW_REBOOT_REPORTED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeInt(arg3);
        builder.writeInt(arg4);
        builder.writeBoolean(arg5);
        builder.writeBoolean(arg6);
        builder.writeInt(arg7);
        builder.writeInt(arg8);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, int arg2, int arg3, int arg4, int arg5) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        if (FOREGROUND_SERVICE_APP_OP_SESSION_ENDED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        if (TV_TUNER_DVR_STATUS == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeInt(arg2);
        builder.writeInt(arg3);
        builder.writeInt(arg4);
        builder.writeInt(arg5);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, int arg2, int arg3, int arg4, int arg5, boolean arg6, int arg7, byte[] arg8, boolean arg9) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeInt(arg2);
        builder.writeInt(arg3);
        builder.writeInt(arg4);
        builder.writeInt(arg5);
        builder.writeBoolean(arg6);
        builder.writeInt(arg7);
        if (DND_STATE_CHANGED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeByteArray(null == arg8 ? new byte[0] : arg8);
        builder.writeBoolean(arg9);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, int arg2, int arg3, int arg4, int arg5, int arg6) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeInt(arg2);
        builder.writeInt(arg3);
        if (HOTWORD_AUDIO_EGRESS_EVENT_REPORTED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeInt(arg4);
        builder.writeInt(arg5);
        builder.writeInt(arg6);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, int arg2, int arg3, int arg4, int arg5, int arg6, int arg7) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeInt(arg2);
        builder.writeInt(arg3);
        builder.writeInt(arg4);
        builder.writeInt(arg5);
        builder.writeInt(arg6);
        builder.writeInt(arg7);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, int arg2, int arg3, int arg4, int arg5, int arg6, int arg7, int arg8, int arg9) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        if (HDMI_CEC_MESSAGE_REPORTED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeInt(arg2);
        builder.writeInt(arg3);
        builder.writeInt(arg4);
        builder.writeInt(arg5);
        builder.writeInt(arg6);
        builder.writeInt(arg7);
        builder.writeInt(arg8);
        builder.writeInt(arg9);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, int arg2, int arg3, int arg4, int arg5, int arg6, int arg7, int arg8, int arg9, int arg10, int arg11, boolean arg12, int arg13, int arg14, int arg15, int arg16, int arg17, boolean arg18, boolean arg19, boolean arg20, int arg21, int arg22, long arg23, long arg24, int arg25, int arg26, int arg27, int arg28) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeInt(arg2);
        builder.writeInt(arg3);
        builder.writeInt(arg4);
        builder.writeInt(arg5);
        builder.writeInt(arg6);
        builder.writeInt(arg7);
        builder.writeInt(arg8);
        builder.writeInt(arg9);
        builder.writeInt(arg10);
        if (AUTOFILL_PRESENTATION_EVENT_REPORTED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeInt(arg11);
        if (AUTOFILL_PRESENTATION_EVENT_REPORTED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeBoolean(arg12);
        builder.writeInt(arg13);
        builder.writeInt(arg14);
        builder.writeInt(arg15);
        builder.writeInt(arg16);
        builder.writeInt(arg17);
        builder.writeBoolean(arg18);
        builder.writeBoolean(arg19);
        builder.writeBoolean(arg20);
        builder.writeInt(arg21);
        builder.writeInt(arg22);
        builder.writeLong(arg23);
        builder.writeLong(arg24);
        builder.writeInt(arg25);
        builder.writeInt(arg26);
        builder.writeInt(arg27);
        builder.writeInt(arg28);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, int arg2, int arg3, int arg4, int arg5, long arg6, int arg7, int arg8, int arg9, long arg10, long arg11, long arg12, int arg13, long arg14, int arg15, int arg16, int arg17, int arg18) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeInt(arg2);
        builder.writeInt(arg3);
        if (AUTOFILL_FILL_RESPONSE_REPORTED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeInt(arg4);
        builder.writeInt(arg5);
        builder.writeLong(arg6);
        builder.writeInt(arg7);
        builder.writeInt(arg8);
        builder.writeInt(arg9);
        builder.writeLong(arg10);
        builder.writeLong(arg11);
        builder.writeLong(arg12);
        builder.writeInt(arg13);
        builder.writeLong(arg14);
        builder.writeInt(arg15);
        builder.writeInt(arg16);
        builder.writeInt(arg17);
        builder.writeInt(arg18);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, int arg2, int arg3, int arg4, long arg5, int arg6, java.lang.String[] arg7, int[] arg8, boolean arg9) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeInt(arg2);
        if (CREDENTIAL_MANAGER_INIT_PHASE_REPORTED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeInt(arg3);
        builder.writeInt(arg4);
        builder.writeLong(arg5);
        builder.writeInt(arg6);
        builder.writeStringArray(null == arg7 ? new String[0] : arg7);
        builder.writeIntArray(null == arg8 ? new int[0] : arg8);
        builder.writeBoolean(arg9);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, int arg2, int arg3, int arg4, java.lang.String arg5, java.lang.String arg6) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        if (PROVIDER_ACQUISITION_EVENT_REPORTED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeInt(arg2);
        if (PROVIDER_ACQUISITION_EVENT_REPORTED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeInt(arg3);
        builder.writeInt(arg4);
        builder.writeString(arg5);
        builder.writeString(arg6);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, int arg2, int arg3, int arg4, java.lang.String arg5, java.lang.String arg6, java.lang.String arg7, java.lang.String arg8, java.lang.String arg9) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeInt(arg2);
        builder.writeInt(arg3);
        builder.writeInt(arg4);
        builder.writeString(arg5);
        builder.writeString(arg6);
        builder.writeString(arg7);
        builder.writeString(arg8);
        builder.writeString(arg9);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, int arg2, int arg3, long arg4) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeInt(arg2);
        builder.writeInt(arg3);
        builder.writeLong(arg4);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, int arg2, int arg3, long arg4, long arg5, boolean arg6, int arg7, int arg8, boolean arg9, boolean arg10, boolean arg11, boolean arg12, long arg13, long arg14, long arg15, boolean arg16) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeInt(arg2);
        builder.writeInt(arg3);
        if (AUTOFILL_SAVE_EVENT_REPORTED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeLong(arg4);
        builder.writeLong(arg5);
        builder.writeBoolean(arg6);
        builder.writeInt(arg7);
        builder.writeInt(arg8);
        builder.writeBoolean(arg9);
        builder.writeBoolean(arg10);
        builder.writeBoolean(arg11);
        builder.writeBoolean(arg12);
        builder.writeLong(arg13);
        builder.writeLong(arg14);
        builder.writeLong(arg15);
        builder.writeBoolean(arg16);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, int arg2, int arg3, long arg4, long arg5, float arg6, long arg7, int arg8) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        if (APP_COMPACTED_V2 == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeInt(arg2);
        builder.writeInt(arg3);
        builder.writeLong(arg4);
        builder.writeLong(arg5);
        builder.writeFloat(arg6);
        builder.writeLong(arg7);
        builder.writeInt(arg8);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, int arg2, int arg3, float arg4, int arg5, int arg6, int arg7, int arg8, int arg9, int arg10) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeInt(arg2);
        builder.writeInt(arg3);
        builder.writeFloat(arg4);
        builder.writeInt(arg5);
        builder.writeInt(arg6);
        if (SPLITSCREEN_UI_CHANGED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeInt(arg7);
        builder.writeInt(arg8);
        if (SPLITSCREEN_UI_CHANGED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeInt(arg9);
        builder.writeInt(arg10);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, int arg2, int arg3, float arg4, float arg5, int arg6, int arg7) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        if (GAME_MODE_CONFIGURATION_CHANGED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeInt(arg2);
        if (GAME_MODE_CONFIGURATION_CHANGED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeInt(arg3);
        builder.writeFloat(arg4);
        builder.writeFloat(arg5);
        builder.writeInt(arg6);
        builder.writeInt(arg7);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, int arg2, int arg3, java.lang.String arg4) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        if (DREAM_UI_EVENT_REPORTED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeInt(arg2);
        builder.writeInt(arg3);
        builder.writeString(arg4);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, int arg2, int arg3, java.lang.String arg4, int arg5) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeInt(arg2);
        builder.writeInt(arg3);
        builder.writeString(arg4);
        builder.writeInt(arg5);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, int arg2, int arg3, java.lang.String arg4, java.lang.String arg5, boolean arg6) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeInt(arg2);
        builder.writeInt(arg3);
        builder.writeString(arg4);
        builder.writeString(arg5);
        builder.writeBoolean(arg6);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, int arg2, int arg3, int[] arg4, int[] arg5, int[] arg6, int arg7, int arg8, int arg9, int arg10) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeInt(arg2);
        if (CREDENTIAL_MANAGER_API_CALLED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeInt(arg3);
        builder.writeIntArray(null == arg4 ? new int[0] : arg4);
        if (CREDENTIAL_MANAGER_API_CALLED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeIntArray(null == arg5 ? new int[0] : arg5);
        builder.writeIntArray(null == arg6 ? new int[0] : arg6);
        builder.writeInt(arg7);
        if (CREDENTIAL_MANAGER_API_CALLED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeInt(arg8);
        builder.writeInt(arg9);
        builder.writeInt(arg10);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, int arg2, int arg3, java.lang.String[] arg4, int[] arg5) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeInt(arg2);
        builder.writeInt(arg3);
        if (CREDENTIAL_MANAGER_GET_REPORTED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeStringArray(null == arg4 ? new String[0] : arg4);
        builder.writeIntArray(null == arg5 ? new int[0] : arg5);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, int arg2, int arg3, java.lang.String[] arg4, int[] arg5, int[] arg6, int[] arg7, java.lang.String arg8, boolean arg9, int arg10, boolean arg11) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeInt(arg2);
        builder.writeInt(arg3);
        if (CREDENTIAL_MANAGER_AUTH_CLICK_REPORTED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeStringArray(null == arg4 ? new String[0] : arg4);
        builder.writeIntArray(null == arg5 ? new int[0] : arg5);
        builder.writeIntArray(null == arg6 ? new int[0] : arg6);
        builder.writeIntArray(null == arg7 ? new int[0] : arg7);
        builder.writeString(arg8);
        builder.writeBoolean(arg9);
        builder.writeInt(arg10);
        builder.writeBoolean(arg11);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, int arg2, long arg3) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeInt(arg2);
        builder.writeLong(arg3);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, int arg2, long arg3, boolean arg4, int arg5, float arg6) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeInt(arg2);
        builder.writeLong(arg3);
        builder.writeBoolean(arg4);
        builder.writeInt(arg5);
        builder.writeFloat(arg6);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, int arg2, long arg3, int arg4, int arg5, int arg6) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeInt(arg2);
        if (PACKAGE_MANAGER_APPS_FILTER_CACHE_UPDATE_REPORTED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeLong(arg3);
        builder.writeInt(arg4);
        builder.writeInt(arg5);
        builder.writeInt(arg6);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, int arg2, long arg3, int arg4, int arg5, int arg6, int arg7, int arg8, int arg9, int arg10, int arg11, int arg12) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeInt(arg2);
        builder.writeLong(arg3);
        builder.writeInt(arg4);
        builder.writeInt(arg5);
        builder.writeInt(arg6);
        builder.writeInt(arg7);
        builder.writeInt(arg8);
        builder.writeInt(arg9);
        builder.writeInt(arg10);
        builder.writeInt(arg11);
        builder.writeInt(arg12);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, int arg2, long arg3, int arg4, long arg5) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeInt(arg2);
        builder.writeLong(arg3);
        builder.writeInt(arg4);
        builder.writeLong(arg5);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, int arg2, float arg3, int arg4, int arg5, int arg6, int arg7, int arg8, int arg9, int arg10, int arg11, int arg12, int arg13, int arg14, int arg15, int arg16, int arg17) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeInt(arg2);
        builder.writeFloat(arg3);
        builder.writeInt(arg4);
        builder.writeInt(arg5);
        builder.writeInt(arg6);
        builder.writeInt(arg7);
        builder.writeInt(arg8);
        builder.writeInt(arg9);
        builder.writeInt(arg10);
        builder.writeInt(arg11);
        builder.writeInt(arg12);
        builder.writeInt(arg13);
        builder.writeInt(arg14);
        builder.writeInt(arg15);
        builder.writeInt(arg16);
        builder.writeInt(arg17);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, int arg2, java.lang.String arg3) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeInt(arg2);
        builder.writeString(arg3);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, int arg2, java.lang.String arg3, int arg4) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeInt(arg2);
        if (UI_EVENT_REPORTED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeString(arg3);
        builder.writeInt(arg4);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, int arg2, java.lang.String arg3, int arg4, boolean arg5, int arg6, java.lang.String arg7, java.lang.String arg8, int arg9, java.lang.String arg10, java.lang.String arg11) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        if (SERVICE_REQUEST_EVENT_REPORTED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeInt(arg2);
        if (SERVICE_REQUEST_EVENT_REPORTED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeString(arg3);
        builder.writeInt(arg4);
        builder.writeBoolean(arg5);
        builder.writeInt(arg6);
        builder.writeString(arg7);
        builder.writeString(arg8);
        builder.writeInt(arg9);
        builder.writeString(arg10);
        builder.writeString(arg11);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, int arg2, java.lang.String arg3, int arg4, int arg5, boolean arg6) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeInt(arg2);
        if (ASSISTANT_INVOCATION_REPORTED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeString(arg3);
        builder.writeInt(arg4);
        builder.writeInt(arg5);
        builder.writeBoolean(arg6);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, int arg2, java.lang.String arg3, int arg4, int arg5, int arg6, boolean arg7, int arg8, boolean arg9, boolean arg10) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeInt(arg2);
        if (NOTIFICATION_CHANNEL_MODIFIED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeString(arg3);
        builder.writeInt(arg4);
        builder.writeInt(arg5);
        builder.writeInt(arg6);
        builder.writeBoolean(arg7);
        builder.writeInt(arg8);
        builder.writeBoolean(arg9);
        builder.writeBoolean(arg10);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, int arg2, java.lang.String arg3, int arg4, int arg5, int arg6, int arg7, int arg8, boolean arg9, java.lang.String arg10, int arg11, int arg12, int arg13, int arg14, int arg15, int arg16, int arg17, int arg18, int arg19, int arg20, float arg21, boolean arg22, boolean arg23, long arg24, boolean arg25, long arg26) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeInt(arg2);
        if (NOTIFICATION_REPORTED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeString(arg3);
        builder.writeInt(arg4);
        builder.writeInt(arg5);
        builder.writeInt(arg6);
        builder.writeInt(arg7);
        builder.writeInt(arg8);
        builder.writeBoolean(arg9);
        builder.writeString(arg10);
        builder.writeInt(arg11);
        builder.writeInt(arg12);
        builder.writeInt(arg13);
        builder.writeInt(arg14);
        builder.writeInt(arg15);
        builder.writeInt(arg16);
        builder.writeInt(arg17);
        builder.writeInt(arg18);
        builder.writeInt(arg19);
        builder.writeInt(arg20);
        builder.writeFloat(arg21);
        builder.writeBoolean(arg22);
        builder.writeBoolean(arg23);
        builder.writeLong(arg24);
        builder.writeBoolean(arg25);
        builder.writeLong(arg26);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, int arg2, java.lang.String arg3, int arg4, int arg5, int arg6, int arg7, int arg8, int arg9) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        if (MEDIA_CODEC_RECLAIM_REQUEST_COMPLETED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeInt(arg2);
        builder.writeString(arg3);
        builder.writeInt(arg4);
        builder.writeInt(arg5);
        builder.writeInt(arg6);
        builder.writeInt(arg7);
        builder.writeInt(arg8);
        if (MEDIA_CODEC_RECLAIM_REQUEST_COMPLETED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeInt(arg9);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, int arg2, java.lang.String arg3, int arg4, int arg5, int arg6, int arg7, long arg8, int arg9, int arg10, int arg11, int arg12, java.lang.String arg13) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeInt(arg2);
        builder.writeString(arg3);
        builder.writeInt(arg4);
        builder.writeInt(arg5);
        builder.writeInt(arg6);
        builder.writeInt(arg7);
        builder.writeLong(arg8);
        builder.writeInt(arg9);
        builder.writeInt(arg10);
        builder.writeInt(arg11);
        builder.writeInt(arg12);
        builder.writeString(arg13);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, int arg2, java.lang.String arg3, int arg4, int arg5, long arg6, long arg7, long arg8, int arg9, java.lang.String arg10, java.lang.String arg11) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        if (BROADCAST_DELIVERY_EVENT_REPORTED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeInt(arg2);
        if (BROADCAST_DELIVERY_EVENT_REPORTED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeString(arg3);
        builder.writeInt(arg4);
        builder.writeInt(arg5);
        builder.writeLong(arg6);
        builder.writeLong(arg7);
        builder.writeLong(arg8);
        builder.writeInt(arg9);
        builder.writeString(arg10);
        builder.writeString(arg11);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, int arg2, java.lang.String arg3, int arg4, long arg5, int arg6, int arg7, java.lang.String arg8, java.lang.String arg9, java.lang.String arg10, int arg11, int arg12) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        if (PROCESS_START_TIME == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeInt(arg2);
        builder.writeString(arg3);
        builder.writeInt(arg4);
        builder.writeLong(arg5);
        builder.writeInt(arg6);
        builder.writeInt(arg7);
        builder.writeString(arg8);
        builder.writeString(arg9);
        builder.writeString(arg10);
        builder.writeInt(arg11);
        builder.writeInt(arg12);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, int arg2, java.lang.String arg3, long arg4, int arg5, int arg6) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeInt(arg2);
        builder.writeString(arg3);
        builder.writeLong(arg4);
        builder.writeInt(arg5);
        builder.writeInt(arg6);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, int arg2, java.lang.String arg3, java.lang.String arg4) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeInt(arg2);
        if (GET_TYPE_ACCESSED_WITHOUT_PERMISSION == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeString(arg3);
        builder.writeString(arg4);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, int arg2, java.lang.String arg3, java.lang.String arg4, int arg5, int arg6) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        if (APPLICATION_LOCALES_CHANGED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeInt(arg2);
        if (APPLICATION_LOCALES_CHANGED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeString(arg3);
        builder.writeString(arg4);
        builder.writeInt(arg5);
        builder.writeInt(arg6);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, int arg2, java.lang.String arg3, java.lang.String arg4, java.lang.String arg5, java.lang.String[] arg6, java.lang.String arg7, java.lang.String arg8, boolean arg9) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeInt(arg2);
        builder.writeString(arg3);
        builder.writeString(arg4);
        builder.writeString(arg5);
        builder.writeStringArray(null == arg6 ? new String[0] : arg6);
        builder.writeString(arg7);
        builder.writeString(arg8);
        builder.writeBoolean(arg9);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, int arg2, int[] arg3, long arg4, int[] arg5) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeInt(arg2);
        builder.writeIntArray(null == arg3 ? new int[0] : arg3);
        if (KERNEL_WAKEUP_ATTRIBUTED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeLong(arg4);
        builder.writeIntArray(null == arg5 ? new int[0] : arg5);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, int arg2, int[] arg3, int[] arg4, int[] arg5) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeInt(arg2);
        builder.writeIntArray(null == arg3 ? new int[0] : arg3);
        if (ALARM_BATCH_DELIVERED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeIntArray(null == arg4 ? new int[0] : arg4);
        builder.writeIntArray(null == arg5 ? new int[0] : arg5);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, long arg2) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeLong(arg2);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, long arg2, int arg3) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeLong(arg2);
        builder.writeInt(arg3);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, long arg2, int arg3, int arg4) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        if (APP_COMPATIBILITY_CHANGE_REPORTED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeLong(arg2);
        builder.writeInt(arg3);
        builder.writeInt(arg4);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, long arg2, int arg3, int arg4, int arg5) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeLong(arg2);
        builder.writeInt(arg3);
        builder.writeInt(arg4);
        builder.writeInt(arg5);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, long arg2, int arg3, int arg4, int arg5, int arg6, int arg7) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        if (IME_REQUEST_FINISHED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeLong(arg2);
        builder.writeInt(arg3);
        builder.writeInt(arg4);
        builder.writeInt(arg5);
        builder.writeInt(arg6);
        builder.writeInt(arg7);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, long arg2, long arg3) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeLong(arg2);
        builder.writeLong(arg3);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, long arg2, long arg3, int arg4) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        if (BLOB_COMMITTED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        if (BLOB_LEASED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        if (BLOB_OPENED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        if (PERFORMANCE_HINT_SESSION_REPORTED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeLong(arg2);
        builder.writeLong(arg3);
        builder.writeInt(arg4);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, long arg2, long arg3, long arg4) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeLong(arg2);
        builder.writeLong(arg3);
        builder.writeLong(arg4);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, long arg2, long arg3, long arg4, long arg5, long arg6, long arg7, int arg8) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeLong(arg2);
        builder.writeLong(arg3);
        builder.writeLong(arg4);
        builder.writeLong(arg5);
        builder.writeLong(arg6);
        builder.writeLong(arg7);
        builder.writeInt(arg8);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, long arg2, java.lang.String arg3, int arg4, boolean arg5, boolean arg6, int arg7, int arg8, int arg9, int arg10, long arg11, int arg12, int arg13, int arg14, int arg15, int arg16) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        if (MEDIA_CODEC_STARTED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeLong(arg2);
        builder.writeString(arg3);
        builder.writeInt(arg4);
        builder.writeBoolean(arg5);
        builder.writeBoolean(arg6);
        builder.writeInt(arg7);
        builder.writeInt(arg8);
        builder.writeInt(arg9);
        builder.writeInt(arg10);
        builder.writeLong(arg11);
        builder.writeInt(arg12);
        builder.writeInt(arg13);
        builder.writeInt(arg14);
        builder.writeInt(arg15);
        builder.writeInt(arg16);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, long arg2, java.lang.String arg3, int arg4, boolean arg5, boolean arg6, int arg7, int arg8, int arg9, int arg10, long arg11, long arg12) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        if (MEDIA_CODEC_STOPPED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeLong(arg2);
        builder.writeString(arg3);
        builder.writeInt(arg4);
        builder.writeBoolean(arg5);
        builder.writeBoolean(arg6);
        builder.writeInt(arg7);
        builder.writeInt(arg8);
        builder.writeInt(arg9);
        builder.writeInt(arg10);
        builder.writeLong(arg11);
        builder.writeLong(arg12);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, long arg2, java.lang.String arg3, int arg4, int arg5, int arg6, int arg7, int arg8, int arg9, int arg10, int arg11, int arg12, long arg13, long arg14, long arg15, long arg16, long arg17, long arg18, long arg19, float arg20, float arg21, float arg22, long arg23, float arg24, int[] arg25, int[] arg26, int[] arg27, int[] arg28, long arg29, float arg30, int[] arg31, int[] arg32) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        if (MEDIA_CODEC_RENDERED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeLong(arg2);
        builder.writeString(arg3);
        builder.writeInt(arg4);
        builder.writeInt(arg5);
        builder.writeInt(arg6);
        builder.writeInt(arg7);
        builder.writeInt(arg8);
        builder.writeInt(arg9);
        builder.writeInt(arg10);
        builder.writeInt(arg11);
        builder.writeInt(arg12);
        builder.writeLong(arg13);
        builder.writeLong(arg14);
        builder.writeLong(arg15);
        builder.writeLong(arg16);
        builder.writeLong(arg17);
        builder.writeLong(arg18);
        builder.writeLong(arg19);
        builder.writeFloat(arg20);
        builder.writeFloat(arg21);
        builder.writeFloat(arg22);
        builder.writeLong(arg23);
        builder.writeFloat(arg24);
        builder.writeIntArray(null == arg25 ? new int[0] : arg25);
        builder.writeIntArray(null == arg26 ? new int[0] : arg26);
        builder.writeIntArray(null == arg27 ? new int[0] : arg27);
        builder.writeIntArray(null == arg28 ? new int[0] : arg28);
        builder.writeLong(arg29);
        builder.writeFloat(arg30);
        builder.writeIntArray(null == arg31 ? new int[0] : arg31);
        builder.writeIntArray(null == arg32 ? new int[0] : arg32);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, float arg2) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeFloat(arg2);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, java.lang.String arg2) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        if (FULL_SCREEN_INTENT_LAUNCHED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeString(arg2);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, java.lang.String arg2, boolean arg3, int arg4) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        if (OVERLAY_STATE_CHANGED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
            builder.addBooleanAnnotation(ANNOTATION_ID_PRIMARY_FIELD, true);
        }
        builder.writeString(arg2);
        if (OVERLAY_STATE_CHANGED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_PRIMARY_FIELD, true);
        }
        builder.writeBoolean(arg3);
        builder.writeInt(arg4);
        if (OVERLAY_STATE_CHANGED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_EXCLUSIVE_STATE, true);
            builder.addBooleanAnnotation(ANNOTATION_ID_STATE_NESTED, false);
        }

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, java.lang.String arg2, int arg3) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        if (PROCESS_LIFE_CYCLE_STATE_CHANGED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        if (PICTURE_IN_PICTURE_STATE_CHANGED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeString(arg2);
        builder.writeInt(arg3);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, java.lang.String arg2, int arg3, boolean arg4) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        if (HIDDEN_API_USED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeString(arg2);
        builder.writeInt(arg3);
        builder.writeBoolean(arg4);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, java.lang.String arg2, int arg3, boolean arg4, int arg5, int arg6, int arg7, int arg8, int arg9, boolean arg10, boolean arg11, int arg12, int arg13, int arg14, boolean arg15, int arg16, int arg17, boolean arg18, int arg19, int arg20, int arg21, int arg22, long arg23, int arg24, int arg25, int arg26, int arg27, long arg28, long arg29) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        if (FOREGROUND_SERVICE_STATE_CHANGED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeString(arg2);
        builder.writeInt(arg3);
        builder.writeBoolean(arg4);
        builder.writeInt(arg5);
        builder.writeInt(arg6);
        builder.writeInt(arg7);
        builder.writeInt(arg8);
        builder.writeInt(arg9);
        builder.writeBoolean(arg10);
        builder.writeBoolean(arg11);
        builder.writeInt(arg12);
        builder.writeInt(arg13);
        builder.writeInt(arg14);
        builder.writeBoolean(arg15);
        builder.writeInt(arg16);
        builder.writeInt(arg17);
        builder.writeBoolean(arg18);
        builder.writeInt(arg19);
        if (FOREGROUND_SERVICE_STATE_CHANGED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeInt(arg20);
        builder.writeInt(arg21);
        builder.writeInt(arg22);
        builder.writeLong(arg23);
        builder.writeInt(arg24);
        builder.writeInt(arg25);
        builder.writeInt(arg26);
        builder.writeInt(arg27);
        builder.writeLong(arg28);
        builder.writeLong(arg29);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, java.lang.String arg2, int arg3, boolean arg4, long arg5, byte[] arg6) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeString(arg2);
        builder.writeInt(arg3);
        builder.writeBoolean(arg4);
        builder.writeLong(arg5);
        builder.writeByteArray(null == arg6 ? new byte[0] : arg6);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, java.lang.String arg2, int arg3, int arg4) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeString(arg2);
        builder.writeInt(arg3);
        builder.writeInt(arg4);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, java.lang.String arg2, int arg3, int arg4, boolean arg5) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeString(arg2);
        builder.writeInt(arg3);
        builder.writeInt(arg4);
        builder.writeBoolean(arg5);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, java.lang.String arg2, int arg3, int arg4, int arg5, int arg6, int arg7, boolean arg8) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        if (APP_PROCESS_DIED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeString(arg2);
        builder.writeInt(arg3);
        builder.writeInt(arg4);
        builder.writeInt(arg5);
        builder.writeInt(arg6);
        builder.writeInt(arg7);
        builder.writeBoolean(arg8);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, java.lang.String arg2, int arg3, int arg4, java.lang.String arg5, byte[] arg6) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeString(arg2);
        builder.writeInt(arg3);
        builder.writeInt(arg4);
        builder.writeString(arg5);
        builder.writeByteArray(null == arg6 ? new byte[0] : arg6);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, java.lang.String arg2, int arg3, long arg4, long arg5, long arg6, long arg7, long arg8, long arg9, int arg10, int arg11, int arg12, int arg13, int arg14, int arg15, int arg16, int arg17) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        if (LMK_KILL_OCCURRED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeString(arg2);
        builder.writeInt(arg3);
        builder.writeLong(arg4);
        builder.writeLong(arg5);
        builder.writeLong(arg6);
        builder.writeLong(arg7);
        builder.writeLong(arg8);
        builder.writeLong(arg9);
        builder.writeInt(arg10);
        builder.writeInt(arg11);
        builder.writeInt(arg12);
        builder.writeInt(arg13);
        builder.writeInt(arg14);
        builder.writeInt(arg15);
        builder.writeInt(arg16);
        builder.writeInt(arg17);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, java.lang.String arg2, int arg3, long arg4, long arg5, long arg6, long arg7, long arg8, long arg9, long arg10, long arg11, long arg12, int arg13, long arg14, int arg15, int arg16, long arg17, long arg18) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeString(arg2);
        builder.writeInt(arg3);
        builder.writeLong(arg4);
        builder.writeLong(arg5);
        builder.writeLong(arg6);
        builder.writeLong(arg7);
        builder.writeLong(arg8);
        builder.writeLong(arg9);
        builder.writeLong(arg10);
        builder.writeLong(arg11);
        builder.writeLong(arg12);
        builder.writeInt(arg13);
        builder.writeLong(arg14);
        builder.writeInt(arg15);
        builder.writeInt(arg16);
        builder.writeLong(arg17);
        builder.writeLong(arg18);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, java.lang.String arg2, int arg3, java.lang.String arg4) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        if (APP_START_CANCELED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeString(arg2);
        builder.writeInt(arg3);
        builder.writeString(arg4);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, java.lang.String arg2, int arg3, java.lang.String arg4, boolean arg5, int arg6, java.lang.String arg7, java.lang.String arg8, int arg9, int arg10, int arg11, boolean arg12, int arg13) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        if (ACTIVITY_ACTION_BLOCKED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeString(arg2);
        builder.writeInt(arg3);
        if (ACTIVITY_ACTION_BLOCKED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeString(arg4);
        builder.writeBoolean(arg5);
        builder.writeInt(arg6);
        if (ACTIVITY_ACTION_BLOCKED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeString(arg7);
        builder.writeString(arg8);
        builder.writeInt(arg9);
        builder.writeInt(arg10);
        builder.writeInt(arg11);
        builder.writeBoolean(arg12);
        builder.writeInt(arg13);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, java.lang.String arg2, int arg3, java.lang.String arg4, boolean arg5, long arg6, int arg7, int arg8, int arg9, int arg10, boolean arg11, boolean arg12, int arg13, long arg14) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        if (APP_START_FULLY_DRAWN == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeString(arg2);
        builder.writeInt(arg3);
        builder.writeString(arg4);
        builder.writeBoolean(arg5);
        builder.writeLong(arg6);
        builder.writeInt(arg7);
        builder.writeInt(arg8);
        builder.writeInt(arg9);
        builder.writeInt(arg10);
        builder.writeBoolean(arg11);
        builder.writeBoolean(arg12);
        builder.writeInt(arg13);
        builder.writeLong(arg14);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, java.lang.String arg2, int arg3, java.lang.String arg4, int arg5, int arg6, boolean arg7, int arg8, int arg9, int arg10, boolean arg11) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeString(arg2);
        builder.writeInt(arg3);
        builder.writeString(arg4);
        builder.writeInt(arg5);
        builder.writeInt(arg6);
        builder.writeBoolean(arg7);
        builder.writeInt(arg8);
        builder.writeInt(arg9);
        builder.writeInt(arg10);
        builder.writeBoolean(arg11);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, java.lang.String arg2, int arg3, java.lang.String arg4, java.lang.String arg5, boolean arg6, long arg7, int arg8, int arg9, int arg10, int arg11, int arg12, java.lang.String arg13, int arg14, int arg15, int arg16, int arg17, boolean arg18, boolean arg19, boolean arg20, int arg21, long arg22, int arg23, int arg24, int arg25) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        if (APP_START_OCCURRED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeString(arg2);
        builder.writeInt(arg3);
        builder.writeString(arg4);
        builder.writeString(arg5);
        builder.writeBoolean(arg6);
        builder.writeLong(arg7);
        builder.writeInt(arg8);
        builder.writeInt(arg9);
        builder.writeInt(arg10);
        builder.writeInt(arg11);
        builder.writeInt(arg12);
        builder.writeString(arg13);
        builder.writeInt(arg14);
        builder.writeInt(arg15);
        builder.writeInt(arg16);
        builder.writeInt(arg17);
        builder.writeBoolean(arg18);
        builder.writeBoolean(arg19);
        builder.writeBoolean(arg20);
        builder.writeInt(arg21);
        builder.writeLong(arg22);
        builder.writeInt(arg23);
        builder.writeInt(arg24);
        builder.writeInt(arg25);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, java.lang.String arg2, int arg3, java.lang.String arg4, java.lang.String arg5, java.lang.String arg6, int arg7, int arg8, int arg9) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        if (PACKET_WAKEUP_OCCURRED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeString(arg2);
        builder.writeInt(arg3);
        builder.writeString(arg4);
        builder.writeString(arg5);
        builder.writeString(arg6);
        builder.writeInt(arg7);
        builder.writeInt(arg8);
        builder.writeInt(arg9);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, java.lang.String arg2, int arg3, int[] arg4, int[] arg5, int[] arg6, int[] arg7, int arg8, int arg9, long arg10, long arg11, int[] arg12, long[] arg13, long arg14, int arg15, int arg16, int arg17, int arg18, int arg19, boolean arg20, boolean arg21, boolean arg22, boolean arg23, boolean arg24, boolean arg25, boolean arg26) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeString(arg2);
        builder.writeInt(arg3);
        if (PACKAGE_INSTALLATION_SESSION_REPORTED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeIntArray(null == arg4 ? new int[0] : arg4);
        builder.writeIntArray(null == arg5 ? new int[0] : arg5);
        builder.writeIntArray(null == arg6 ? new int[0] : arg6);
        builder.writeIntArray(null == arg7 ? new int[0] : arg7);
        builder.writeInt(arg8);
        builder.writeInt(arg9);
        builder.writeLong(arg10);
        builder.writeLong(arg11);
        builder.writeIntArray(null == arg12 ? new int[0] : arg12);
        builder.writeLongArray(null == arg13 ? new long[0] : arg13);
        builder.writeLong(arg14);
        builder.writeInt(arg15);
        builder.writeInt(arg16);
        if (PACKAGE_INSTALLATION_SESSION_REPORTED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeInt(arg17);
        if (PACKAGE_INSTALLATION_SESSION_REPORTED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeInt(arg18);
        builder.writeInt(arg19);
        builder.writeBoolean(arg20);
        builder.writeBoolean(arg21);
        builder.writeBoolean(arg22);
        builder.writeBoolean(arg23);
        builder.writeBoolean(arg24);
        builder.writeBoolean(arg25);
        builder.writeBoolean(arg26);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, java.lang.String arg2, long arg3) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        if (USB_CONNECTOR_STATE_CHANGED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_EXCLUSIVE_STATE, true);
            builder.addBooleanAnnotation(ANNOTATION_ID_STATE_NESTED, false);
        }
        builder.writeString(arg2);
        if (USB_CONNECTOR_STATE_CHANGED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_PRIMARY_FIELD, true);
        }
        builder.writeLong(arg3);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, java.lang.String arg2, java.lang.String arg3) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        if (SERVICE_LAUNCH_REPORTED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeString(arg2);
        builder.writeString(arg3);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, java.lang.String arg2, java.lang.String arg3, int arg4) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        if (ACTIVITY_FOREGROUND_STATE_CHANGED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        if (SERVICE_STATE_CHANGED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        if (APP_USAGE_EVENT_OCCURRED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeString(arg2);
        builder.writeString(arg3);
        builder.writeInt(arg4);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, java.lang.String arg2, java.lang.String arg3, int arg4, int arg5) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        if (WTF_OCCURRED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeString(arg2);
        builder.writeString(arg3);
        builder.writeInt(arg4);
        builder.writeInt(arg5);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, java.lang.String arg2, java.lang.String arg3, int arg4, int arg5, int arg6, int arg7, int arg8, int arg9, int arg10, int arg11, int arg12) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeString(arg2);
        builder.writeString(arg3);
        builder.writeInt(arg4);
        builder.writeInt(arg5);
        builder.writeInt(arg6);
        builder.writeInt(arg7);
        builder.writeInt(arg8);
        builder.writeInt(arg9);
        builder.writeInt(arg10);
        builder.writeInt(arg11);
        builder.writeInt(arg12);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, java.lang.String arg2, java.lang.String arg3, int arg4, long arg5) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeString(arg2);
        builder.writeString(arg3);
        builder.writeInt(arg4);
        builder.writeLong(arg5);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, java.lang.String arg2, java.lang.String arg3, int arg4, java.lang.String arg5, int arg6, int arg7, int arg8, boolean arg9, float arg10, long arg11, int arg12, int arg13, boolean arg14, long arg15, long arg16, int arg17, int arg18, int arg19, long arg20, int arg21, long arg22) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        if (APP_CRASH_OCCURRED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeString(arg2);
        builder.writeString(arg3);
        builder.writeInt(arg4);
        builder.writeString(arg5);
        builder.writeInt(arg6);
        builder.writeInt(arg7);
        builder.writeInt(arg8);
        builder.writeBoolean(arg9);
        builder.writeFloat(arg10);
        builder.writeLong(arg11);
        builder.writeInt(arg12);
        builder.writeInt(arg13);
        builder.writeBoolean(arg14);
        builder.writeLong(arg15);
        builder.writeLong(arg16);
        builder.writeInt(arg17);
        builder.writeInt(arg18);
        builder.writeInt(arg19);
        builder.writeLong(arg20);
        builder.writeInt(arg21);
        builder.writeLong(arg22);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, java.lang.String arg2, java.lang.String arg3, long arg4) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeString(arg2);
        builder.writeString(arg3);
        builder.writeLong(arg4);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, java.lang.String arg2, java.lang.String arg3, long arg4, long arg5) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeString(arg2);
        builder.writeString(arg3);
        builder.writeLong(arg4);
        builder.writeLong(arg5);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, java.lang.String arg2, java.lang.String arg3, long arg4, long arg5, long arg6, int arg7, long arg8, long arg9, int arg10, int arg11) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeString(arg2);
        builder.writeString(arg3);
        builder.writeLong(arg4);
        builder.writeLong(arg5);
        builder.writeLong(arg6);
        builder.writeInt(arg7);
        builder.writeLong(arg8);
        builder.writeLong(arg9);
        builder.writeInt(arg10);
        builder.writeInt(arg11);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, java.lang.String arg2, java.lang.String arg3, long arg4, long arg5, long arg6, long arg7, long arg8) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        if (APP_START_MEMORY_STATE_CAPTURED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeString(arg2);
        builder.writeString(arg3);
        builder.writeLong(arg4);
        builder.writeLong(arg5);
        builder.writeLong(arg6);
        builder.writeLong(arg7);
        builder.writeLong(arg8);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, java.lang.String arg2, java.lang.String arg3, java.lang.String arg4, int arg5, int arg6, int arg7, java.lang.String arg8, boolean arg9, float arg10, long arg11, int arg12, int arg13, boolean arg14, long arg15, long arg16, int arg17, int arg18, int arg19, long arg20, int arg21, long arg22) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        if (ANR_OCCURRED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeString(arg2);
        builder.writeString(arg3);
        builder.writeString(arg4);
        builder.writeInt(arg5);
        builder.writeInt(arg6);
        builder.writeInt(arg7);
        builder.writeString(arg8);
        builder.writeBoolean(arg9);
        builder.writeFloat(arg10);
        builder.writeLong(arg11);
        builder.writeInt(arg12);
        builder.writeInt(arg13);
        builder.writeBoolean(arg14);
        builder.writeLong(arg15);
        builder.writeLong(arg16);
        builder.writeInt(arg17);
        builder.writeInt(arg18);
        builder.writeInt(arg19);
        builder.writeLong(arg20);
        builder.writeInt(arg21);
        builder.writeLong(arg22);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int arg1, int[] arg2, int[] arg3, int[] arg4, int[] arg5, int arg6, int arg7, boolean arg8, boolean arg9) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        if (PACKAGE_UNINSTALLATION_REPORTED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeIntArray(null == arg2 ? new int[0] : arg2);
        builder.writeIntArray(null == arg3 ? new int[0] : arg3);
        builder.writeIntArray(null == arg4 ? new int[0] : arg4);
        builder.writeIntArray(null == arg5 ? new int[0] : arg5);
        builder.writeInt(arg6);
        builder.writeInt(arg7);
        builder.writeBoolean(arg8);
        builder.writeBoolean(arg9);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, long arg1) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeLong(arg1);
        if (APP_DIED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_EXCLUSIVE_STATE, true);
        }

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, long arg1, int arg2) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeLong(arg1);
        builder.writeInt(arg2);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, long arg1, int arg2, int arg3) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeLong(arg1);
        builder.writeInt(arg2);
        builder.writeInt(arg3);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, long arg1, int arg2, int arg3, int arg4, int arg5) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeLong(arg1);
        builder.writeInt(arg2);
        builder.writeInt(arg3);
        builder.writeInt(arg4);
        builder.writeInt(arg5);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, long arg1, int arg2, int arg3, int arg4, int arg5, int arg6, int arg7, long arg8) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeLong(arg1);
        builder.writeInt(arg2);
        builder.writeInt(arg3);
        builder.writeInt(arg4);
        builder.writeInt(arg5);
        builder.writeInt(arg6);
        builder.writeInt(arg7);
        builder.writeLong(arg8);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, long arg1, int arg2, java.lang.String arg3, int arg4, java.lang.String arg5, int arg6, boolean arg7, int arg8, int arg9, int arg10, long arg11, long arg12, boolean arg13, int arg14, byte[] arg15, byte[] arg16, byte[] arg17, byte[] arg18, byte[] arg19, java.lang.String arg20, int arg21, long arg22, int arg23, int arg24, boolean arg25) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeLong(arg1);
        builder.writeInt(arg2);
        builder.writeString(arg3);
        builder.writeInt(arg4);
        builder.writeString(arg5);
        builder.writeInt(arg6);
        builder.writeBoolean(arg7);
        builder.writeInt(arg8);
        builder.writeInt(arg9);
        builder.writeInt(arg10);
        builder.writeLong(arg11);
        builder.writeLong(arg12);
        builder.writeBoolean(arg13);
        builder.writeInt(arg14);
        builder.writeByteArray(null == arg15 ? new byte[0] : arg15);
        builder.writeByteArray(null == arg16 ? new byte[0] : arg16);
        builder.writeByteArray(null == arg17 ? new byte[0] : arg17);
        builder.writeByteArray(null == arg18 ? new byte[0] : arg18);
        builder.writeByteArray(null == arg19 ? new byte[0] : arg19);
        builder.writeString(arg20);
        builder.writeInt(arg21);
        builder.writeLong(arg22);
        builder.writeInt(arg23);
        builder.writeInt(arg24);
        builder.writeBoolean(arg25);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, long arg1, long arg2) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeLong(arg1);
        builder.writeLong(arg2);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, long arg1, long arg2, int arg3) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeLong(arg1);
        builder.writeLong(arg2);
        builder.writeInt(arg3);
        if (EXPRESS_UID_EVENT_REPORTED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, long arg1, long arg2, int arg3, boolean arg4) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeLong(arg1);
        builder.writeLong(arg2);
        builder.writeInt(arg3);
        builder.writeBoolean(arg4);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, long arg1, long arg2, int arg3, int arg4) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeLong(arg1);
        builder.writeLong(arg2);
        builder.writeInt(arg3);
        builder.writeInt(arg4);
        if (EXPRESS_UID_HISTOGRAM_SAMPLE_REPORTED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, long arg1, long arg2, long arg3, long arg4, long arg5, long arg6, long arg7, long arg8, long arg9, long arg10, long arg11, long arg12, long arg13, long arg14, long arg15, long arg16, int arg17, int arg18, int arg19) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeLong(arg1);
        builder.writeLong(arg2);
        builder.writeLong(arg3);
        builder.writeLong(arg4);
        builder.writeLong(arg5);
        builder.writeLong(arg6);
        builder.writeLong(arg7);
        builder.writeLong(arg8);
        builder.writeLong(arg9);
        builder.writeLong(arg10);
        builder.writeLong(arg11);
        builder.writeLong(arg12);
        builder.writeLong(arg13);
        builder.writeLong(arg14);
        builder.writeLong(arg15);
        builder.writeLong(arg16);
        builder.writeInt(arg17);
        builder.writeInt(arg18);
        builder.writeInt(arg19);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, long arg1, java.lang.String arg2, long arg3, long arg4, java.lang.String arg5, java.lang.String arg6, java.lang.String arg7, int arg8, int arg9, int arg10, int arg11, int arg12, int arg13, int arg14, int arg15, int arg16, int arg17, int arg18, java.lang.String arg19, long arg20, long arg21, long arg22, long arg23, long arg24, int arg25, int arg26, java.lang.String arg27, int arg28, long arg29, long arg30, java.lang.String arg31, int arg32, int arg33, long arg34, long arg35, long arg36, long arg37, long arg38, int arg39, float arg40, float arg41, float arg42, int arg43, int arg44, int arg45, int arg46, int arg47, int arg48, int arg49, int arg50, int arg51, int arg52, int arg53, int arg54, int arg55, int arg56, int arg57, int arg58, int arg59, int arg60, int arg61, int arg62, int arg63, int arg64, int arg65, int arg66, long arg67, int arg68, int arg69, int arg70, int arg71, int arg72, int arg73, int arg74, int arg75, int arg76, int arg77) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeLong(arg1);
        builder.writeString(arg2);
        builder.writeLong(arg3);
        builder.writeLong(arg4);
        builder.writeString(arg5);
        builder.writeString(arg6);
        builder.writeString(arg7);
        builder.writeInt(arg8);
        builder.writeInt(arg9);
        builder.writeInt(arg10);
        builder.writeInt(arg11);
        builder.writeInt(arg12);
        builder.writeInt(arg13);
        builder.writeInt(arg14);
        builder.writeInt(arg15);
        builder.writeInt(arg16);
        builder.writeInt(arg17);
        builder.writeInt(arg18);
        builder.writeString(arg19);
        builder.writeLong(arg20);
        builder.writeLong(arg21);
        builder.writeLong(arg22);
        builder.writeLong(arg23);
        builder.writeLong(arg24);
        builder.writeInt(arg25);
        builder.writeInt(arg26);
        builder.writeString(arg27);
        builder.writeInt(arg28);
        builder.writeLong(arg29);
        builder.writeLong(arg30);
        builder.writeString(arg31);
        builder.writeInt(arg32);
        builder.writeInt(arg33);
        builder.writeLong(arg34);
        builder.writeLong(arg35);
        builder.writeLong(arg36);
        builder.writeLong(arg37);
        builder.writeLong(arg38);
        builder.writeInt(arg39);
        builder.writeFloat(arg40);
        builder.writeFloat(arg41);
        builder.writeFloat(arg42);
        builder.writeInt(arg43);
        builder.writeInt(arg44);
        builder.writeInt(arg45);
        builder.writeInt(arg46);
        builder.writeInt(arg47);
        builder.writeInt(arg48);
        builder.writeInt(arg49);
        builder.writeInt(arg50);
        builder.writeInt(arg51);
        builder.writeInt(arg52);
        builder.writeInt(arg53);
        builder.writeInt(arg54);
        builder.writeInt(arg55);
        builder.writeInt(arg56);
        builder.writeInt(arg57);
        builder.writeInt(arg58);
        builder.writeInt(arg59);
        builder.writeInt(arg60);
        builder.writeInt(arg61);
        builder.writeInt(arg62);
        builder.writeInt(arg63);
        builder.writeInt(arg64);
        builder.writeInt(arg65);
        builder.writeInt(arg66);
        builder.writeLong(arg67);
        builder.writeInt(arg68);
        builder.writeInt(arg69);
        builder.writeInt(arg70);
        builder.writeInt(arg71);
        builder.writeInt(arg72);
        builder.writeInt(arg73);
        builder.writeInt(arg74);
        builder.writeInt(arg75);
        builder.writeInt(arg76);
        builder.writeInt(arg77);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, float arg1, float arg2, float arg3, java.lang.String arg4, boolean arg5, float arg6, int arg7, float arg8, float arg9, boolean arg10, int arg11, int arg12, int arg13, boolean arg14, boolean arg15, boolean arg16, boolean arg17, int arg18, boolean arg19, boolean arg20, boolean arg21, boolean arg22, boolean arg23, boolean arg24, boolean arg25) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeFloat(arg1);
        builder.writeFloat(arg2);
        builder.writeFloat(arg3);
        builder.writeString(arg4);
        builder.writeBoolean(arg5);
        builder.writeFloat(arg6);
        builder.writeInt(arg7);
        builder.writeFloat(arg8);
        builder.writeFloat(arg9);
        builder.writeBoolean(arg10);
        builder.writeInt(arg11);
        builder.writeInt(arg12);
        builder.writeInt(arg13);
        builder.writeBoolean(arg14);
        builder.writeBoolean(arg15);
        builder.writeBoolean(arg16);
        builder.writeBoolean(arg17);
        builder.writeInt(arg18);
        builder.writeBoolean(arg19);
        builder.writeBoolean(arg20);
        builder.writeBoolean(arg21);
        builder.writeBoolean(arg22);
        builder.writeBoolean(arg23);
        builder.writeBoolean(arg24);
        builder.writeBoolean(arg25);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, java.lang.String arg1) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeString(arg1);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, java.lang.String arg1, int arg2) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeString(arg1);
        builder.writeInt(arg2);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, java.lang.String arg1, int arg2, boolean arg3) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeString(arg1);
        builder.writeInt(arg2);
        builder.writeBoolean(arg3);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, java.lang.String arg1, int arg2, boolean arg3, int arg4, boolean arg5, int arg6, int arg7) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeString(arg1);
        builder.writeInt(arg2);
        if (GAME_STATE_CHANGED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeBoolean(arg3);
        builder.writeInt(arg4);
        builder.writeBoolean(arg5);
        builder.writeInt(arg6);
        builder.writeInt(arg7);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, java.lang.String arg1, int arg2, int arg3) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeString(arg1);
        builder.writeInt(arg2);
        builder.writeInt(arg3);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, java.lang.String arg1, int arg2, int arg3, int arg4) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeString(arg1);
        builder.writeInt(arg2);
        builder.writeInt(arg3);
        if (BAL_ALLOWED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeInt(arg4);
        if (BAL_ALLOWED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, java.lang.String arg1, int arg2, int arg3, int arg4, boolean arg5, boolean arg6, int arg7) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeString(arg1);
        builder.writeInt(arg2);
        builder.writeInt(arg3);
        builder.writeInt(arg4);
        builder.writeBoolean(arg5);
        builder.writeBoolean(arg6);
        builder.writeInt(arg7);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, java.lang.String arg1, int arg2, int arg3, int arg4, int arg5) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeString(arg1);
        builder.writeInt(arg2);
        builder.writeInt(arg3);
        builder.writeInt(arg4);
        builder.writeInt(arg5);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, java.lang.String arg1, int arg2, int arg3, int arg4, int arg5, java.lang.String arg6, int arg7) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeString(arg1);
        builder.writeInt(arg2);
        builder.writeInt(arg3);
        builder.writeInt(arg4);
        builder.writeInt(arg5);
        builder.writeString(arg6);
        builder.writeInt(arg7);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, java.lang.String arg1, int arg2, int arg3, float arg4) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeString(arg1);
        builder.writeInt(arg2);
        builder.writeInt(arg3);
        builder.writeFloat(arg4);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, java.lang.String arg1, int arg2, long arg3) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeString(arg1);
        builder.writeInt(arg2);
        builder.writeLong(arg3);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, java.lang.String arg1, int arg2, java.lang.String arg3, int arg4, int arg5, int arg6, boolean arg7, int arg8, int arg9, boolean arg10, int arg11, int arg12, java.lang.String arg13) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeString(arg1);
        builder.writeInt(arg2);
        builder.writeString(arg3);
        builder.writeInt(arg4);
        builder.writeInt(arg5);
        builder.writeInt(arg6);
        builder.writeBoolean(arg7);
        builder.writeInt(arg8);
        builder.writeInt(arg9);
        builder.writeBoolean(arg10);
        builder.writeInt(arg11);
        builder.writeInt(arg12);
        builder.writeString(arg13);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, java.lang.String arg1, int arg2, java.lang.String arg3, int arg4, java.lang.String arg5, int arg6, boolean arg7, boolean arg8, boolean arg9) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeString(arg1);
        builder.writeInt(arg2);
        builder.writeString(arg3);
        builder.writeInt(arg4);
        builder.writeString(arg5);
        builder.writeInt(arg6);
        builder.writeBoolean(arg7);
        builder.writeBoolean(arg8);
        builder.writeBoolean(arg9);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, java.lang.String arg1, long arg2) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeString(arg1);
        builder.writeLong(arg2);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, java.lang.String arg1, long arg2, long arg3) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeString(arg1);
        builder.writeLong(arg2);
        builder.writeLong(arg3);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, java.lang.String arg1, long arg2, long arg3, boolean arg4) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeString(arg1);
        builder.writeLong(arg2);
        builder.writeLong(arg3);
        builder.writeBoolean(arg4);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, java.lang.String arg1, long arg2, java.lang.String arg3) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeString(arg1);
        builder.writeLong(arg2);
        builder.writeString(arg3);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, java.lang.String arg1, long arg2, java.lang.String arg3, int arg4, java.lang.String[] arg5) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeString(arg1);
        builder.writeLong(arg2);
        builder.writeString(arg3);
        builder.writeInt(arg4);
        builder.writeStringArray(null == arg5 ? new String[0] : arg5);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, java.lang.String arg1, long arg2, java.lang.String arg3, int arg4, java.lang.String[] arg5, int arg6, java.lang.String arg7, java.lang.String[] arg8, java.lang.String arg9, java.lang.String arg10, java.lang.String arg11) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeString(arg1);
        builder.writeLong(arg2);
        builder.writeString(arg3);
        builder.writeInt(arg4);
        builder.writeStringArray(null == arg5 ? new String[0] : arg5);
        builder.writeInt(arg6);
        builder.writeString(arg7);
        builder.writeStringArray(null == arg8 ? new String[0] : arg8);
        builder.writeString(arg9);
        builder.writeString(arg10);
        builder.writeString(arg11);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, java.lang.String arg1, java.lang.String arg2) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeString(arg1);
        builder.writeString(arg2);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, java.lang.String arg1, java.lang.String arg2, int arg3, int arg4, int arg5, int arg6, float arg7, float arg8, boolean arg9, boolean arg10, boolean arg11) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeString(arg1);
        builder.writeString(arg2);
        builder.writeInt(arg3);
        builder.writeInt(arg4);
        builder.writeInt(arg5);
        builder.writeInt(arg6);
        builder.writeFloat(arg7);
        builder.writeFloat(arg8);
        builder.writeBoolean(arg9);
        builder.writeBoolean(arg10);
        builder.writeBoolean(arg11);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, java.lang.String arg1, java.lang.String arg2, long arg3, java.lang.String arg4, int arg5, boolean arg6, boolean arg7) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeString(arg1);
        builder.writeString(arg2);
        builder.writeLong(arg3);
        builder.writeString(arg4);
        builder.writeInt(arg5);
        builder.writeBoolean(arg6);
        builder.writeBoolean(arg7);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, java.lang.String arg1, java.lang.String arg2, java.lang.String arg3, java.lang.String arg4, java.lang.String arg5, boolean arg6, int arg7, int arg8) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeString(arg1);
        builder.writeString(arg2);
        builder.writeString(arg3);
        builder.writeString(arg4);
        builder.writeString(arg5);
        builder.writeBoolean(arg6);
        builder.writeInt(arg7);
        builder.writeInt(arg8);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, java.lang.String arg1, int[] arg2) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeString(arg1);
        builder.writeIntArray(null == arg2 ? new int[0] : arg2);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, int[] arg1, int[] arg2, long arg3, int arg4, long arg5, int arg6, int arg7) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeIntArray(null == arg1 ? new int[0] : arg1);
        builder.writeIntArray(null == arg2 ? new int[0] : arg2);
        builder.writeLong(arg3);
        builder.writeInt(arg4);
        builder.writeLong(arg5);
        builder.writeInt(arg6);
        builder.writeInt(arg7);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, float[] arg1, float[] arg2) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeFloatArray(null == arg1 ? new float[0] : arg1);
        builder.writeFloatArray(null == arg2 ? new float[0] : arg2);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, float[] arg1, float[] arg2, java.lang.String arg3) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeFloatArray(null == arg1 ? new float[0] : arg1);
        builder.writeFloatArray(null == arg2 ? new float[0] : arg2);
        builder.writeString(arg3);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write_non_chained(int code, int arg1, java.lang.String arg2, int arg3) {
        write(code, new int[] {arg1}, new java.lang.String[] {arg2}, arg3);
    }

    public static void write_non_chained(int code, int arg1, java.lang.String arg2, int arg3, int arg4) {
        write(code, new int[] {arg1}, new java.lang.String[] {arg2}, arg3, arg4);
    }

    public static void write_non_chained(int code, int arg1, java.lang.String arg2, int arg3, int arg4, int arg5, boolean arg6, int arg7, int arg8, int arg9, long arg10, long arg11, long arg12, long arg13, int arg14, int arg15, int arg16, int arg17, int arg18, int arg19, int arg20, int[] arg21, int[] arg22, int[] arg23, int[] arg24, int arg25, int arg26) {
        write(code, new int[] {arg1}, new java.lang.String[] {arg2}, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15, arg16, arg17, arg18, arg19, arg20, arg21, arg22, arg23, arg24, arg25, arg26);
    }

    public static void write_non_chained(int code, int arg1, java.lang.String arg2, int arg3, int arg4, java.lang.String arg5) {
        write(code, new int[] {arg1}, new java.lang.String[] {arg2}, arg3, arg4, arg5);
    }

    public static void write_non_chained(int code, int arg1, java.lang.String arg2, int arg3, long arg4) {
        write(code, new int[] {arg1}, new java.lang.String[] {arg2}, arg3, arg4);
    }

    public static void write_non_chained(int code, int arg1, java.lang.String arg2, int arg3, java.lang.String arg4, int arg5, int arg6) {
        write(code, new int[] {arg1}, new java.lang.String[] {arg2}, arg3, arg4, arg5, arg6);
    }

    public static void write_non_chained(int code, int arg1, java.lang.String arg2, int arg3, java.lang.String arg4, int arg5, int arg6, int arg7) {
        write(code, new int[] {arg1}, new java.lang.String[] {arg2}, arg3, arg4, arg5, arg6, arg7);
    }

    public static void write_non_chained(int code, int arg1, java.lang.String arg2, java.lang.String arg3, int arg4) {
        write(code, new int[] {arg1}, new java.lang.String[] {arg2}, arg3, arg4);
    }

    public static void write_non_chained(int code, int arg1, java.lang.String arg2, java.lang.String arg3, int arg4, int arg5) {
        write(code, new int[] {arg1}, new java.lang.String[] {arg2}, arg3, arg4, arg5);
    }

    public static void write_non_chained(int code, int arg1, java.lang.String arg2, java.lang.String arg3, int arg4, int arg5, int arg6, int arg7, boolean arg8, boolean arg9, boolean arg10, boolean arg11, boolean arg12, boolean arg13, boolean arg14, boolean arg15, boolean arg16, boolean arg17, int arg18, boolean arg19, int arg20, int arg21, int arg22, long arg23, boolean arg24, boolean arg25, boolean arg26, boolean arg27, boolean arg28, boolean arg29, boolean arg30, boolean arg31, long arg32, boolean arg33, boolean arg34, boolean arg35, long arg36, long arg37, long arg38, int arg39, int arg40) {
        write(code, new int[] {arg1}, new java.lang.String[] {arg2}, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15, arg16, arg17, arg18, arg19, arg20, arg21, arg22, arg23, arg24, arg25, arg26, arg27, arg28, arg29, arg30, arg31, arg32, arg33, arg34, arg35, arg36, arg37, arg38, arg39, arg40);
    }

    public static void write_non_chained(int code, int arg1, java.lang.String arg2, java.lang.String arg3, java.lang.String arg4, int arg5) {
        write(code, new int[] {arg1}, new java.lang.String[] {arg2}, arg3, arg4, arg5);
    }

    public static StatsEvent buildStatsEvent(int code, byte[] arg1) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeByteArray(null == arg1 ? new byte[0] : arg1);

        return builder.build();
    }

    public static StatsEvent buildStatsEvent(int code, byte[] arg1, byte[] arg2, byte[] arg3, byte[] arg4, int arg5, byte[] arg6, byte[] arg7, int arg8, int arg9, byte[] arg10, int arg11, int arg12, float arg13, boolean arg14) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeByteArray(null == arg1 ? new byte[0] : arg1);
        builder.writeByteArray(null == arg2 ? new byte[0] : arg2);
        builder.writeByteArray(null == arg3 ? new byte[0] : arg3);
        builder.writeByteArray(null == arg4 ? new byte[0] : arg4);
        builder.writeInt(arg5);
        builder.writeByteArray(null == arg6 ? new byte[0] : arg6);
        builder.writeByteArray(null == arg7 ? new byte[0] : arg7);
        builder.writeInt(arg8);
        builder.writeInt(arg9);
        builder.writeByteArray(null == arg10 ? new byte[0] : arg10);
        builder.writeInt(arg11);
        builder.writeInt(arg12);
        builder.writeFloat(arg13);
        builder.writeBoolean(arg14);

        return builder.build();
    }

    public static StatsEvent buildStatsEvent(int code, byte[] arg1, boolean arg2, int arg3, boolean arg4, boolean arg5) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeByteArray(null == arg1 ? new byte[0] : arg1);
        builder.writeBoolean(arg2);
        builder.writeInt(arg3);
        builder.writeBoolean(arg4);
        builder.writeBoolean(arg5);

        return builder.build();
    }

    public static StatsEvent buildStatsEvent(int code, byte[] arg1, int arg2) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeByteArray(null == arg1 ? new byte[0] : arg1);
        builder.writeInt(arg2);

        return builder.build();
    }

    public static StatsEvent buildStatsEvent(int code, boolean arg1, boolean arg2) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeBoolean(arg1);
        builder.writeBoolean(arg2);

        return builder.build();
    }

    public static StatsEvent buildStatsEvent(int code, boolean arg1, boolean arg2, boolean arg3, boolean arg4, boolean arg5, boolean arg6) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeBoolean(arg1);
        builder.writeBoolean(arg2);
        builder.writeBoolean(arg3);
        builder.writeBoolean(arg4);
        builder.writeBoolean(arg5);
        builder.writeBoolean(arg6);

        return builder.build();
    }

    public static StatsEvent buildStatsEvent(int code, boolean arg1, boolean arg2, boolean arg3, boolean arg4, boolean arg5, int arg6, int arg7, byte[] arg8, byte[] arg9, byte[] arg10, boolean arg11, java.lang.String arg12, boolean arg13, boolean arg14) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeBoolean(arg1);
        builder.writeBoolean(arg2);
        builder.writeBoolean(arg3);
        builder.writeBoolean(arg4);
        builder.writeBoolean(arg5);
        builder.writeInt(arg6);
        builder.writeInt(arg7);
        builder.writeByteArray(null == arg8 ? new byte[0] : arg8);
        builder.writeByteArray(null == arg9 ? new byte[0] : arg9);
        builder.writeByteArray(null == arg10 ? new byte[0] : arg10);
        builder.writeBoolean(arg11);
        builder.writeString(arg12);
        builder.writeBoolean(arg13);
        builder.writeBoolean(arg14);

        return builder.build();
    }

    public static StatsEvent buildStatsEvent(int code, int arg1) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);

        return builder.build();
    }

    public static StatsEvent buildStatsEvent(int code, int arg1, boolean arg2, boolean arg3) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeBoolean(arg2);
        builder.writeBoolean(arg3);

        return builder.build();
    }

    public static StatsEvent buildStatsEvent(int code, int arg1, boolean arg2, boolean arg3, int arg4, java.lang.String arg5, int arg6, byte[] arg7) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeBoolean(arg2);
        builder.writeBoolean(arg3);
        builder.writeInt(arg4);
        builder.writeString(arg5);
        builder.writeInt(arg6);
        if (DND_MODE_RULE == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeByteArray(null == arg7 ? new byte[0] : arg7);

        return builder.build();
    }

    public static StatsEvent buildStatsEvent(int code, int arg1, boolean arg2, int arg3, int arg4, long arg5, long arg6, long arg7, long arg8) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        if (OEM_MANAGED_BYTES_TRANSFER == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeBoolean(arg2);
        builder.writeInt(arg3);
        builder.writeInt(arg4);
        builder.writeLong(arg5);
        builder.writeLong(arg6);
        builder.writeLong(arg7);
        builder.writeLong(arg8);

        return builder.build();
    }

    public static StatsEvent buildStatsEvent(int code, int arg1, boolean arg2, int arg3, long arg4, long arg5, long arg6, long arg7) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        if (BYTES_TRANSFER_BY_TAG_AND_METERED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_TRUNCATE_TIMESTAMP, true);
        }
        builder.writeInt(arg1);
        if (BYTES_TRANSFER_BY_TAG_AND_METERED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeBoolean(arg2);
        builder.writeInt(arg3);
        builder.writeLong(arg4);
        builder.writeLong(arg5);
        builder.writeLong(arg6);
        builder.writeLong(arg7);

        return builder.build();
    }

    public static StatsEvent buildStatsEvent(int code, int arg1, boolean arg2, long arg3) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        if (INSTALLED_INCREMENTAL_PACKAGE == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeBoolean(arg2);
        builder.writeLong(arg3);

        return builder.build();
    }

    public static StatsEvent buildStatsEvent(int code, int arg1, boolean arg2, long arg3, long arg4, long arg5, long arg6) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        if (MOBILE_BYTES_TRANSFER_BY_FG_BG == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_TRUNCATE_TIMESTAMP, true);
        }
        builder.writeInt(arg1);
        if (WIFI_BYTES_TRANSFER_BY_FG_BG == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        if (MOBILE_BYTES_TRANSFER_BY_FG_BG == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeBoolean(arg2);
        builder.writeLong(arg3);
        builder.writeLong(arg4);
        builder.writeLong(arg5);
        builder.writeLong(arg6);

        return builder.build();
    }

    public static StatsEvent buildStatsEvent(int code, int arg1, int arg2) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        if (PERSISTENT_URI_PERMISSIONS_AMOUNT_PER_PACKAGE == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeInt(arg2);

        return builder.build();
    }

    public static StatsEvent buildStatsEvent(int code, int arg1, int arg2, boolean arg3, int arg4, int arg5) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeInt(arg2);
        builder.writeBoolean(arg3);
        builder.writeInt(arg4);
        builder.writeInt(arg5);

        return builder.build();
    }

    public static StatsEvent buildStatsEvent(int code, int arg1, int arg2, boolean arg3, float arg4) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeInt(arg2);
        builder.writeBoolean(arg3);
        builder.writeFloat(arg4);

        return builder.build();
    }

    public static StatsEvent buildStatsEvent(int code, int arg1, int arg2, int arg3) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        if (PENDING_INTENTS_PER_PACKAGE == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeInt(arg2);
        builder.writeInt(arg3);

        return builder.build();
    }

    public static StatsEvent buildStatsEvent(int code, int arg1, int arg2, int arg3, int arg4) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeInt(arg2);
        builder.writeInt(arg3);
        builder.writeInt(arg4);

        return builder.build();
    }

    public static StatsEvent buildStatsEvent(int code, int arg1, int arg2, int arg3, int arg4, boolean arg5) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        if (PACKAGE_NOTIFICATION_PREFERENCES == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeInt(arg2);
        builder.writeInt(arg3);
        builder.writeInt(arg4);
        builder.writeBoolean(arg5);

        return builder.build();
    }

    public static StatsEvent buildStatsEvent(int code, int arg1, int arg2, int arg3, int arg4, int arg5) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeInt(arg2);
        builder.writeInt(arg3);
        builder.writeInt(arg4);
        builder.writeInt(arg5);

        return builder.build();
    }

    public static StatsEvent buildStatsEvent(int code, int arg1, int arg2, int arg3, int arg4, int arg5, boolean arg6, int arg7) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeInt(arg2);
        builder.writeInt(arg3);
        builder.writeInt(arg4);
        builder.writeInt(arg5);
        builder.writeBoolean(arg6);
        builder.writeInt(arg7);

        return builder.build();
    }

    public static StatsEvent buildStatsEvent(int code, int arg1, int arg2, int arg3, int arg4, int arg5, int arg6) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeInt(arg2);
        builder.writeInt(arg3);
        builder.writeInt(arg4);
        builder.writeInt(arg5);
        builder.writeInt(arg6);

        return builder.build();
    }

    public static StatsEvent buildStatsEvent(int code, int arg1, int arg2, int arg3, int arg4, int arg5, int arg6, int arg7, int arg8, int arg9, int arg10, int arg11, int arg12) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeInt(arg2);
        builder.writeInt(arg3);
        builder.writeInt(arg4);
        builder.writeInt(arg5);
        builder.writeInt(arg6);
        builder.writeInt(arg7);
        builder.writeInt(arg8);
        builder.writeInt(arg9);
        builder.writeInt(arg10);
        builder.writeInt(arg11);
        builder.writeInt(arg12);

        return builder.build();
    }

    public static StatsEvent buildStatsEvent(int code, int arg1, int arg2, int arg3, int arg4, int arg5, int arg6, int arg7, int arg8, int arg9, int arg10, int arg11, int arg12, int arg13) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeInt(arg2);
        builder.writeInt(arg3);
        builder.writeInt(arg4);
        builder.writeInt(arg5);
        builder.writeInt(arg6);
        builder.writeInt(arg7);
        builder.writeInt(arg8);
        builder.writeInt(arg9);
        builder.writeInt(arg10);
        builder.writeInt(arg11);
        builder.writeInt(arg12);
        builder.writeInt(arg13);

        return builder.build();
    }

    public static StatsEvent buildStatsEvent(int code, int arg1, int arg2, int arg3, int arg4, int arg5, int arg6, int arg7, int arg8, int arg9, int arg10, int arg11, int arg12, int arg13, int arg14, int arg15, int arg16, int arg17, int arg18, int arg19, int arg20, int arg21, int arg22, int arg23) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeInt(arg2);
        builder.writeInt(arg3);
        builder.writeInt(arg4);
        builder.writeInt(arg5);
        builder.writeInt(arg6);
        builder.writeInt(arg7);
        builder.writeInt(arg8);
        builder.writeInt(arg9);
        builder.writeInt(arg10);
        builder.writeInt(arg11);
        builder.writeInt(arg12);
        builder.writeInt(arg13);
        builder.writeInt(arg14);
        builder.writeInt(arg15);
        builder.writeInt(arg16);
        builder.writeInt(arg17);
        builder.writeInt(arg18);
        builder.writeInt(arg19);
        builder.writeInt(arg20);
        builder.writeInt(arg21);
        builder.writeInt(arg22);
        builder.writeInt(arg23);

        return builder.build();
    }

    public static StatsEvent buildStatsEvent(int code, int arg1, int arg2, int arg3, float arg4) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        if (GAME_MODE_CONFIGURATION == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeInt(arg2);
        builder.writeInt(arg3);
        builder.writeFloat(arg4);

        return builder.build();
    }

    public static StatsEvent buildStatsEvent(int code, int arg1, int arg2, int arg3, java.lang.String arg4, java.lang.String arg5, int arg6, int arg7, int arg8, int arg9, int arg10, int arg11, int arg12, int arg13, int arg14, int arg15, int arg16, int arg17, int arg18, int arg19, int arg20, int arg21) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        if (CPU_TIME_PER_THREAD_FREQ == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeInt(arg2);
        builder.writeInt(arg3);
        builder.writeString(arg4);
        builder.writeString(arg5);
        builder.writeInt(arg6);
        builder.writeInt(arg7);
        builder.writeInt(arg8);
        builder.writeInt(arg9);
        builder.writeInt(arg10);
        builder.writeInt(arg11);
        builder.writeInt(arg12);
        builder.writeInt(arg13);
        builder.writeInt(arg14);
        builder.writeInt(arg15);
        builder.writeInt(arg16);
        builder.writeInt(arg17);
        builder.writeInt(arg18);
        builder.writeInt(arg19);
        builder.writeInt(arg20);
        builder.writeInt(arg21);

        return builder.build();
    }

    public static StatsEvent buildStatsEvent(int code, int arg1, int arg2, long arg3) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        if (CPU_TIME_PER_UID_FREQ == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        if (CPU_CLUSTER_TIME == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeInt(arg2);
        builder.writeLong(arg3);

        return builder.build();
    }

    public static StatsEvent buildStatsEvent(int code, int arg1, int arg2, long arg3, long arg4) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeInt(arg2);
        builder.writeLong(arg3);
        builder.writeLong(arg4);

        return builder.build();
    }

    public static StatsEvent buildStatsEvent(int code, int arg1, int arg2, long arg3, long arg4, long arg5) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        if (CPU_CYCLES_PER_UID_CLUSTER == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeInt(arg2);
        builder.writeLong(arg3);
        builder.writeLong(arg4);
        builder.writeLong(arg5);

        return builder.build();
    }

    public static StatsEvent buildStatsEvent(int code, int arg1, int arg2, java.lang.String arg3, int arg4, long arg5, long arg6, boolean arg7) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeInt(arg2);
        builder.writeString(arg3);
        builder.writeInt(arg4);
        builder.writeLong(arg5);
        builder.writeLong(arg6);
        builder.writeBoolean(arg7);

        return builder.build();
    }

    public static StatsEvent buildStatsEvent(int code, int arg1, long arg2) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        if (CPU_ACTIVE_TIME == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeLong(arg2);

        return builder.build();
    }

    public static StatsEvent buildStatsEvent(int code, int arg1, long arg2, long arg3) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        if (BLUETOOTH_BYTES_TRANSFER == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        if (CPU_TIME_PER_UID == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeLong(arg2);
        builder.writeLong(arg3);

        return builder.build();
    }

    public static StatsEvent buildStatsEvent(int code, int arg1, long arg2, long arg3, long arg4, long arg5) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        if (MOBILE_BYTES_TRANSFER == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_TRUNCATE_TIMESTAMP, true);
        }
        builder.writeInt(arg1);
        if (WIFI_BYTES_TRANSFER == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        if (MOBILE_BYTES_TRANSFER == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeLong(arg2);
        builder.writeLong(arg3);
        builder.writeLong(arg4);
        builder.writeLong(arg5);

        return builder.build();
    }

    public static StatsEvent buildStatsEvent(int code, int arg1, long arg2, long arg3, long arg4, long arg5, int arg6, java.lang.String arg7, java.lang.String arg8, int arg9, int arg10, boolean arg11) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        if (DATA_USAGE_BYTES_TRANSFER == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_TRUNCATE_TIMESTAMP, true);
        }
        builder.writeInt(arg1);
        builder.writeLong(arg2);
        builder.writeLong(arg3);
        builder.writeLong(arg4);
        builder.writeLong(arg5);
        builder.writeInt(arg6);
        builder.writeString(arg7);
        builder.writeString(arg8);
        builder.writeInt(arg9);
        builder.writeInt(arg10);
        builder.writeBoolean(arg11);

        return builder.build();
    }

    public static StatsEvent buildStatsEvent(int code, int arg1, long arg2, long arg3, long arg4, long arg5, int arg6, java.lang.String arg7, java.lang.String arg8, int arg9, int arg10, boolean arg11, int arg12) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        if (DATA_USAGE_BYTES_TRANSFER_V2 == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_TRUNCATE_TIMESTAMP, true);
        }
        builder.writeInt(arg1);
        builder.writeLong(arg2);
        builder.writeLong(arg3);
        builder.writeLong(arg4);
        builder.writeLong(arg5);
        builder.writeInt(arg6);
        builder.writeString(arg7);
        builder.writeString(arg8);
        builder.writeInt(arg9);
        builder.writeInt(arg10);
        builder.writeBoolean(arg11);
        builder.writeInt(arg12);

        return builder.build();
    }

    public static StatsEvent buildStatsEvent(int code, int arg1, long arg2, long arg3, long arg4, long arg5, long arg6, long arg7, long arg8, long arg9, long arg10, long arg11) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        if (DISK_IO == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeLong(arg2);
        builder.writeLong(arg3);
        builder.writeLong(arg4);
        builder.writeLong(arg5);
        builder.writeLong(arg6);
        builder.writeLong(arg7);
        builder.writeLong(arg8);
        builder.writeLong(arg9);
        builder.writeLong(arg10);
        builder.writeLong(arg11);

        return builder.build();
    }

    public static StatsEvent buildStatsEvent(int code, int arg1, java.lang.String arg2) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeString(arg2);

        return builder.build();
    }

    public static StatsEvent buildStatsEvent(int code, int arg1, java.lang.String arg2, int arg3) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        if (PINNED_FILE_SIZES_PER_PACKAGE == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeString(arg2);
        builder.writeInt(arg3);

        return builder.build();
    }

    public static StatsEvent buildStatsEvent(int code, int arg1, java.lang.String arg2, int arg3, int arg4) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        builder.writeString(arg2);
        builder.writeInt(arg3);
        builder.writeInt(arg4);

        return builder.build();
    }

    public static StatsEvent buildStatsEvent(int code, int arg1, java.lang.String arg2, int arg3, int arg4, int arg5) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        if (PROCESS_SYSTEM_ION_HEAP_SIZE == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeString(arg2);
        builder.writeInt(arg3);
        builder.writeInt(arg4);
        builder.writeInt(arg5);

        return builder.build();
    }

    public static StatsEvent buildStatsEvent(int code, int arg1, java.lang.String arg2, int arg3, int arg4, int arg5, int arg6, int arg7, int arg8, int arg9) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        if (PROCESS_DMABUF_MEMORY == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeString(arg2);
        builder.writeInt(arg3);
        builder.writeInt(arg4);
        builder.writeInt(arg5);
        builder.writeInt(arg6);
        builder.writeInt(arg7);
        builder.writeInt(arg8);
        builder.writeInt(arg9);

        return builder.build();
    }

    public static StatsEvent buildStatsEvent(int code, int arg1, java.lang.String arg2, int arg3, int arg4, int arg5, int arg6, int arg7, int arg8, int arg9, boolean arg10, int arg11, int arg12, int arg13) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        if (PROCESS_MEMORY_SNAPSHOT == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeString(arg2);
        builder.writeInt(arg3);
        builder.writeInt(arg4);
        builder.writeInt(arg5);
        builder.writeInt(arg6);
        builder.writeInt(arg7);
        builder.writeInt(arg8);
        builder.writeInt(arg9);
        builder.writeBoolean(arg10);
        builder.writeInt(arg11);
        builder.writeInt(arg12);
        builder.writeInt(arg13);

        return builder.build();
    }

    public static StatsEvent buildStatsEvent(int code, int arg1, java.lang.String arg2, int arg3, int arg4, int arg5, int arg6, int arg7, int arg8, int arg9, int arg10, int arg11, int arg12, int arg13) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        if (PROCESS_STATE == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeString(arg2);
        builder.writeInt(arg3);
        builder.writeInt(arg4);
        builder.writeInt(arg5);
        builder.writeInt(arg6);
        builder.writeInt(arg7);
        builder.writeInt(arg8);
        builder.writeInt(arg9);
        builder.writeInt(arg10);
        builder.writeInt(arg11);
        builder.writeInt(arg12);
        builder.writeInt(arg13);

        return builder.build();
    }

    public static StatsEvent buildStatsEvent(int code, int arg1, java.lang.String arg2, int arg3, long arg4, long arg5, long arg6, long arg7, long arg8, long arg9, boolean arg10) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        if (APP_OPS == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeString(arg2);
        builder.writeInt(arg3);
        builder.writeLong(arg4);
        builder.writeLong(arg5);
        builder.writeLong(arg6);
        builder.writeLong(arg7);
        builder.writeLong(arg8);
        builder.writeLong(arg9);
        builder.writeBoolean(arg10);

        return builder.build();
    }

    public static StatsEvent buildStatsEvent(int code, int arg1, java.lang.String arg2, int arg3, long arg4, long arg5, long arg6, long arg7, long arg8, long arg9, long arg10, int arg11) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        if (PROCESS_MEMORY_STATE == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeString(arg2);
        builder.writeInt(arg3);
        builder.writeLong(arg4);
        builder.writeLong(arg5);
        builder.writeLong(arg6);
        builder.writeLong(arg7);
        builder.writeLong(arg8);
        builder.writeLong(arg9);
        builder.writeLong(arg10);
        builder.writeInt(arg11);

        return builder.build();
    }

    public static StatsEvent buildStatsEvent(int code, int arg1, java.lang.String arg2, int arg3, java.lang.String arg4, int arg5, int arg6, int arg7, int arg8, int arg9, java.lang.String arg10) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        if (PROCESS_ASSOCIATION == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeString(arg2);
        builder.writeInt(arg3);
        if (PROCESS_ASSOCIATION == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeString(arg4);
        builder.writeInt(arg5);
        builder.writeInt(arg6);
        builder.writeInt(arg7);
        builder.writeInt(arg8);
        builder.writeInt(arg9);
        builder.writeString(arg10);

        return builder.build();
    }

    public static StatsEvent buildStatsEvent(int code, int arg1, java.lang.String arg2, long arg3, int arg4) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        if (PROCESS_MEMORY_HIGH_WATER_MARK == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeString(arg2);
        builder.writeLong(arg3);
        builder.writeInt(arg4);

        return builder.build();
    }

    public static StatsEvent buildStatsEvent(int code, int arg1, java.lang.String arg2, long arg3, long arg4) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        if (PROCESS_CPU_TIME == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeString(arg2);
        builder.writeLong(arg3);
        builder.writeLong(arg4);

        return builder.build();
    }

    public static StatsEvent buildStatsEvent(int code, int arg1, java.lang.String arg2, java.lang.String arg3) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        if (ROLE_HOLDER == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeString(arg2);
        builder.writeString(arg3);

        return builder.build();
    }

    public static StatsEvent buildStatsEvent(int code, int arg1, java.lang.String arg2, java.lang.String arg3, int arg4, long arg5, long arg6, long arg7, long arg8, long arg9, long arg10, boolean arg11, int arg12) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        if (ATTRIBUTED_APP_OPS == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeString(arg2);
        builder.writeString(arg3);
        builder.writeInt(arg4);
        builder.writeLong(arg5);
        builder.writeLong(arg6);
        builder.writeLong(arg7);
        builder.writeLong(arg8);
        builder.writeLong(arg9);
        builder.writeLong(arg10);
        builder.writeBoolean(arg11);
        builder.writeInt(arg12);

        return builder.build();
    }

    public static StatsEvent buildStatsEvent(int code, int arg1, java.lang.String arg2, java.lang.String arg3, long arg4, long arg5, long arg6, long arg7, long arg8, long arg9, long arg10, long arg11, long arg12, boolean arg13, int arg14) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        if (BINDER_CALLS == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeString(arg2);
        builder.writeString(arg3);
        builder.writeLong(arg4);
        builder.writeLong(arg5);
        builder.writeLong(arg6);
        builder.writeLong(arg7);
        builder.writeLong(arg8);
        builder.writeLong(arg9);
        builder.writeLong(arg10);
        builder.writeLong(arg11);
        builder.writeLong(arg12);
        builder.writeBoolean(arg13);
        builder.writeInt(arg14);

        return builder.build();
    }

    public static StatsEvent buildStatsEvent(int code, int arg1, java.lang.String arg2, java.lang.String arg3, java.lang.String arg4, boolean arg5, int arg6) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        if (PACKAGE_NOTIFICATION_CHANNEL_GROUP_PREFERENCES == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeString(arg2);
        builder.writeString(arg3);
        builder.writeString(arg4);
        builder.writeBoolean(arg5);
        builder.writeInt(arg6);

        return builder.build();
    }

    public static StatsEvent buildStatsEvent(int code, int arg1, java.lang.String arg2, java.lang.String arg3, java.lang.String arg4, int arg5, int arg6, boolean arg7, boolean arg8, boolean arg9, boolean arg10) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        if (PACKAGE_NOTIFICATION_CHANNEL_PREFERENCES == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeString(arg2);
        builder.writeString(arg3);
        builder.writeString(arg4);
        builder.writeInt(arg5);
        builder.writeInt(arg6);
        builder.writeBoolean(arg7);
        builder.writeBoolean(arg8);
        builder.writeBoolean(arg9);
        builder.writeBoolean(arg10);

        return builder.build();
    }

    public static StatsEvent buildStatsEvent(int code, int arg1, java.lang.String arg2, java.lang.String arg3, java.lang.String arg4, long arg5, long arg6, long arg7, long arg8, long arg9, boolean arg10, long arg11, long arg12, long arg13, long arg14, long arg15) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        if (LOOPER_STATS == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeString(arg2);
        builder.writeString(arg3);
        builder.writeString(arg4);
        builder.writeLong(arg5);
        builder.writeLong(arg6);
        builder.writeLong(arg7);
        builder.writeLong(arg8);
        builder.writeLong(arg9);
        builder.writeBoolean(arg10);
        builder.writeLong(arg11);
        builder.writeLong(arg12);
        builder.writeLong(arg13);
        builder.writeLong(arg14);
        builder.writeLong(arg15);

        return builder.build();
    }

    public static StatsEvent buildStatsEvent(int code, int arg1, java.lang.String arg2, java.lang.String arg3, java.lang.String arg4, java.lang.String arg5, int arg6, int arg7) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        if (RUNTIME_APP_OP_ACCESS == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeString(arg2);
        builder.writeString(arg3);
        builder.writeString(arg4);
        builder.writeString(arg5);
        builder.writeInt(arg6);
        builder.writeInt(arg7);

        return builder.build();
    }

    public static StatsEvent buildStatsEvent(int code, int arg1, int[] arg2, int[] arg3) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeInt(arg1);
        if (GAME_MODE_INFO == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeIntArray(null == arg2 ? new int[0] : arg2);
        builder.writeIntArray(null == arg3 ? new int[0] : arg3);

        return builder.build();
    }

    public static StatsEvent buildStatsEvent(int code, long arg1) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeLong(arg1);

        return builder.build();
    }

    public static StatsEvent buildStatsEvent(int code, long arg1, boolean arg2, int arg3) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeLong(arg1);
        builder.writeBoolean(arg2);
        builder.writeInt(arg3);

        return builder.build();
    }

    public static StatsEvent buildStatsEvent(int code, long arg1, int arg2, long arg3, long arg4, long arg5, long arg6) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeLong(arg1);
        builder.writeInt(arg2);
        builder.writeLong(arg3);
        builder.writeLong(arg4);
        builder.writeLong(arg5);
        builder.writeLong(arg6);

        return builder.build();
    }

    public static StatsEvent buildStatsEvent(int code, long arg1, long arg2, long arg3, byte[] arg4, byte[] arg5) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeLong(arg1);
        builder.writeLong(arg2);
        builder.writeLong(arg3);
        builder.writeByteArray(null == arg4 ? new byte[0] : arg4);
        builder.writeByteArray(null == arg5 ? new byte[0] : arg5);

        return builder.build();
    }

    public static StatsEvent buildStatsEvent(int code, long arg1, long arg2, long arg3, long arg4) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeLong(arg1);
        builder.writeLong(arg2);
        builder.writeLong(arg3);
        builder.writeLong(arg4);

        return builder.build();
    }

    public static StatsEvent buildStatsEvent(int code, long arg1, long arg2, long arg3, long arg4, int arg5) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeLong(arg1);
        builder.writeLong(arg2);
        builder.writeLong(arg3);
        builder.writeLong(arg4);
        builder.writeInt(arg5);

        return builder.build();
    }

    public static StatsEvent buildStatsEvent(int code, long arg1, long arg2, long arg3, long arg4, long arg5, long arg6, long arg7, long arg8, long arg9, long arg10) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeLong(arg1);
        builder.writeLong(arg2);
        builder.writeLong(arg3);
        builder.writeLong(arg4);
        builder.writeLong(arg5);
        builder.writeLong(arg6);
        builder.writeLong(arg7);
        builder.writeLong(arg8);
        builder.writeLong(arg9);
        builder.writeLong(arg10);

        return builder.build();
    }

    public static StatsEvent buildStatsEvent(int code, long arg1, long arg2, long arg3, long arg4, long arg5, long arg6, long arg7, long arg8, long arg9, long arg10, long arg11, long arg12, long arg13, long arg14) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeLong(arg1);
        builder.writeLong(arg2);
        builder.writeLong(arg3);
        builder.writeLong(arg4);
        builder.writeLong(arg5);
        builder.writeLong(arg6);
        builder.writeLong(arg7);
        builder.writeLong(arg8);
        builder.writeLong(arg9);
        builder.writeLong(arg10);
        builder.writeLong(arg11);
        builder.writeLong(arg12);
        builder.writeLong(arg13);
        builder.writeLong(arg14);

        return builder.build();
    }

    public static StatsEvent buildStatsEvent(int code, long arg1, long arg2, long arg3, long arg4, long arg5, long arg6, long arg7, long arg8, long arg9, long arg10, long arg11, long arg12, long arg13, long arg14, long arg15, long arg16) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeLong(arg1);
        builder.writeLong(arg2);
        builder.writeLong(arg3);
        builder.writeLong(arg4);
        builder.writeLong(arg5);
        builder.writeLong(arg6);
        builder.writeLong(arg7);
        builder.writeLong(arg8);
        builder.writeLong(arg9);
        builder.writeLong(arg10);
        builder.writeLong(arg11);
        builder.writeLong(arg12);
        builder.writeLong(arg13);
        builder.writeLong(arg14);
        builder.writeLong(arg15);
        builder.writeLong(arg16);

        return builder.build();
    }

    public static StatsEvent buildStatsEvent(int code, java.lang.String arg1) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeString(arg1);

        return builder.build();
    }

    public static StatsEvent buildStatsEvent(int code, java.lang.String arg1, int arg2, boolean arg3, int arg4, int arg5) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeString(arg1);
        builder.writeInt(arg2);
        if (DANGEROUS_PERMISSION_STATE_SAMPLED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeBoolean(arg3);
        builder.writeInt(arg4);
        builder.writeInt(arg5);

        return builder.build();
    }

    public static StatsEvent buildStatsEvent(int code, java.lang.String arg1, int arg2, boolean arg3, int arg4, float arg5, java.lang.String arg6, int arg7) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeString(arg1);
        builder.writeInt(arg2);
        builder.writeBoolean(arg3);
        builder.writeInt(arg4);
        builder.writeFloat(arg5);
        builder.writeString(arg6);
        builder.writeInt(arg7);

        return builder.build();
    }

    public static StatsEvent buildStatsEvent(int code, java.lang.String arg1, int arg2, int arg3, long arg4) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeString(arg1);
        builder.writeInt(arg2);
        builder.writeInt(arg3);
        builder.writeLong(arg4);

        return builder.build();
    }

    public static StatsEvent buildStatsEvent(int code, java.lang.String arg1, int arg2, java.lang.String arg3, boolean arg4, int arg5, int arg6) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeString(arg1);
        builder.writeInt(arg2);
        if (DANGEROUS_PERMISSION_STATE == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }
        builder.writeString(arg3);
        builder.writeBoolean(arg4);
        builder.writeInt(arg5);
        builder.writeInt(arg6);

        return builder.build();
    }

    public static StatsEvent buildStatsEvent(int code, java.lang.String arg1, long arg2) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeString(arg1);
        builder.writeLong(arg2);

        return builder.build();
    }

    public static StatsEvent buildStatsEvent(int code, java.lang.String arg1, long arg2, long arg3, long arg4, long arg5) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeString(arg1);
        builder.writeLong(arg2);
        builder.writeLong(arg3);
        builder.writeLong(arg4);
        builder.writeLong(arg5);

        return builder.build();
    }

    public static StatsEvent buildStatsEvent(int code, java.lang.String arg1, java.lang.String arg2) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeString(arg1);
        builder.writeString(arg2);

        return builder.build();
    }

    public static StatsEvent buildStatsEvent(int code, java.lang.String arg1, java.lang.String arg2, long arg3, long arg4) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeString(arg1);
        builder.writeString(arg2);
        builder.writeLong(arg3);
        builder.writeLong(arg4);

        return builder.build();
    }

    public static StatsEvent buildStatsEvent(int code, java.lang.String arg1, java.lang.String arg2, java.lang.String arg3, java.lang.String arg4, java.lang.String arg5, java.lang.String arg6) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeString(arg1);
        builder.writeString(arg2);
        builder.writeString(arg3);
        builder.writeString(arg4);
        builder.writeString(arg5);
        builder.writeString(arg6);

        return builder.build();
    }

    public static StatsEvent buildStatsEvent(int code, java.lang.String arg1, java.lang.String arg2, java.lang.String arg3, java.lang.String arg4, java.lang.String arg5, java.lang.String arg6, java.lang.String arg7, java.lang.String arg8, java.lang.String arg9) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeString(arg1);
        builder.writeString(arg2);
        builder.writeString(arg3);
        builder.writeString(arg4);
        builder.writeString(arg5);
        builder.writeString(arg6);
        builder.writeString(arg7);
        builder.writeString(arg8);
        builder.writeString(arg9);

        return builder.build();
    }

    // WorkSource methods.

    public static void write(int code, android.os.WorkSource ws, int arg2) {
        for (int i = 0; i < ws.size(); ++i) {
            write_non_chained(code, ws.getUid(i), ws.getPackageName(i), arg2);
        }
        java.util.List<android.os.WorkSource.WorkChain> workChains = ws.getWorkChains();
        if (workChains != null) {
            for (android.os.WorkSource.WorkChain wc : workChains) {
                write(code, wc.getUids(), wc.getTags(), arg2);
            }
        }
    }

    public static void write(int code, android.os.WorkSource ws, int arg2, int arg3) {
        for (int i = 0; i < ws.size(); ++i) {
            write_non_chained(code, ws.getUid(i), ws.getPackageName(i), arg2, arg3);
        }
        java.util.List<android.os.WorkSource.WorkChain> workChains = ws.getWorkChains();
        if (workChains != null) {
            for (android.os.WorkSource.WorkChain wc : workChains) {
                write(code, wc.getUids(), wc.getTags(), arg2, arg3);
            }
        }
    }

    public static void write(int code, android.os.WorkSource ws, int arg2, int arg3, int arg4, boolean arg5, int arg6, int arg7, int arg8, long arg9, long arg10, long arg11, long arg12, int arg13, int arg14, int arg15, int arg16, int arg17, int arg18, int arg19, int[] arg20, int[] arg21, int[] arg22, int[] arg23, int arg24, int arg25) {
        for (int i = 0; i < ws.size(); ++i) {
            write_non_chained(code, ws.getUid(i), ws.getPackageName(i), arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15, arg16, arg17, arg18, arg19, arg20, arg21, arg22, arg23, arg24, arg25);
        }
        java.util.List<android.os.WorkSource.WorkChain> workChains = ws.getWorkChains();
        if (workChains != null) {
            for (android.os.WorkSource.WorkChain wc : workChains) {
                write(code, wc.getUids(), wc.getTags(), arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15, arg16, arg17, arg18, arg19, arg20, arg21, arg22, arg23, arg24, arg25);
            }
        }
    }

    public static void write(int code, android.os.WorkSource ws, int arg2, int arg3, java.lang.String arg4) {
        for (int i = 0; i < ws.size(); ++i) {
            write_non_chained(code, ws.getUid(i), ws.getPackageName(i), arg2, arg3, arg4);
        }
        java.util.List<android.os.WorkSource.WorkChain> workChains = ws.getWorkChains();
        if (workChains != null) {
            for (android.os.WorkSource.WorkChain wc : workChains) {
                write(code, wc.getUids(), wc.getTags(), arg2, arg3, arg4);
            }
        }
    }

    public static void write(int code, android.os.WorkSource ws, int arg2, long arg3) {
        for (int i = 0; i < ws.size(); ++i) {
            write_non_chained(code, ws.getUid(i), ws.getPackageName(i), arg2, arg3);
        }
        java.util.List<android.os.WorkSource.WorkChain> workChains = ws.getWorkChains();
        if (workChains != null) {
            for (android.os.WorkSource.WorkChain wc : workChains) {
                write(code, wc.getUids(), wc.getTags(), arg2, arg3);
            }
        }
    }

    public static void write(int code, android.os.WorkSource ws, int arg2, java.lang.String arg3, int arg4, int arg5) {
        for (int i = 0; i < ws.size(); ++i) {
            write_non_chained(code, ws.getUid(i), ws.getPackageName(i), arg2, arg3, arg4, arg5);
        }
        java.util.List<android.os.WorkSource.WorkChain> workChains = ws.getWorkChains();
        if (workChains != null) {
            for (android.os.WorkSource.WorkChain wc : workChains) {
                write(code, wc.getUids(), wc.getTags(), arg2, arg3, arg4, arg5);
            }
        }
    }

    public static void write(int code, android.os.WorkSource ws, int arg2, java.lang.String arg3, int arg4, int arg5, int arg6) {
        for (int i = 0; i < ws.size(); ++i) {
            write_non_chained(code, ws.getUid(i), ws.getPackageName(i), arg2, arg3, arg4, arg5, arg6);
        }
        java.util.List<android.os.WorkSource.WorkChain> workChains = ws.getWorkChains();
        if (workChains != null) {
            for (android.os.WorkSource.WorkChain wc : workChains) {
                write(code, wc.getUids(), wc.getTags(), arg2, arg3, arg4, arg5, arg6);
            }
        }
    }

    public static void write(int code, android.os.WorkSource ws, java.lang.String arg2, int arg3) {
        for (int i = 0; i < ws.size(); ++i) {
            write_non_chained(code, ws.getUid(i), ws.getPackageName(i), arg2, arg3);
        }
        java.util.List<android.os.WorkSource.WorkChain> workChains = ws.getWorkChains();
        if (workChains != null) {
            for (android.os.WorkSource.WorkChain wc : workChains) {
                write(code, wc.getUids(), wc.getTags(), arg2, arg3);
            }
        }
    }

    public static void write(int code, android.os.WorkSource ws, java.lang.String arg2, int arg3, int arg4) {
        for (int i = 0; i < ws.size(); ++i) {
            write_non_chained(code, ws.getUid(i), ws.getPackageName(i), arg2, arg3, arg4);
        }
        java.util.List<android.os.WorkSource.WorkChain> workChains = ws.getWorkChains();
        if (workChains != null) {
            for (android.os.WorkSource.WorkChain wc : workChains) {
                write(code, wc.getUids(), wc.getTags(), arg2, arg3, arg4);
            }
        }
    }

    public static void write(int code, android.os.WorkSource ws, java.lang.String arg2, int arg3, int arg4, int arg5, int arg6, boolean arg7, boolean arg8, boolean arg9, boolean arg10, boolean arg11, boolean arg12, boolean arg13, boolean arg14, boolean arg15, boolean arg16, int arg17, boolean arg18, int arg19, int arg20, int arg21, long arg22, boolean arg23, boolean arg24, boolean arg25, boolean arg26, boolean arg27, boolean arg28, boolean arg29, boolean arg30, long arg31, boolean arg32, boolean arg33, boolean arg34, long arg35, long arg36, long arg37, int arg38, int arg39) {
        for (int i = 0; i < ws.size(); ++i) {
            write_non_chained(code, ws.getUid(i), ws.getPackageName(i), arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15, arg16, arg17, arg18, arg19, arg20, arg21, arg22, arg23, arg24, arg25, arg26, arg27, arg28, arg29, arg30, arg31, arg32, arg33, arg34, arg35, arg36, arg37, arg38, arg39);
        }
        java.util.List<android.os.WorkSource.WorkChain> workChains = ws.getWorkChains();
        if (workChains != null) {
            for (android.os.WorkSource.WorkChain wc : workChains) {
                write(code, wc.getUids(), wc.getTags(), arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15, arg16, arg17, arg18, arg19, arg20, arg21, arg22, arg23, arg24, arg25, arg26, arg27, arg28, arg29, arg30, arg31, arg32, arg33, arg34, arg35, arg36, arg37, arg38, arg39);
            }
        }
    }

    public static void write(int code, android.os.WorkSource ws, java.lang.String arg2, java.lang.String arg3, int arg4) {
        for (int i = 0; i < ws.size(); ++i) {
            write_non_chained(code, ws.getUid(i), ws.getPackageName(i), arg2, arg3, arg4);
        }
        java.util.List<android.os.WorkSource.WorkChain> workChains = ws.getWorkChains();
        if (workChains != null) {
            for (android.os.WorkSource.WorkChain wc : workChains) {
                write(code, wc.getUids(), wc.getTags(), arg2, arg3, arg4);
            }
        }
    }
}
