// This file is autogenerated

package com.android.modules.expresslog;


import android.os.Build;
import android.util.StatsEvent;
import android.util.StatsLog;


/**
 * Utility class for logging statistics events.
 */
public final class StatsExpressLog {
    // Constants for atom codes.

    /**
     * ExpressEventReported express_event_reported<br>
     * Usage: StatsLog.write(StatsLog.EXPRESS_EVENT_REPORTED, long metric_id, long value);<br>
     */
    public static final int EXPRESS_EVENT_REPORTED = 528;

    /**
     * ExpressHistogramSampleReported express_histogram_sample_reported<br>
     * Usage: StatsLog.write(StatsLog.EXPRESS_HISTOGRAM_SAMPLE_REPORTED, long metric_id, long count, int bin_index);<br>
     */
    public static final int EXPRESS_HISTOGRAM_SAMPLE_REPORTED = 593;

    /**
     * ExpressUidEventReported express_uid_event_reported<br>
     * Usage: StatsLog.write(StatsLog.EXPRESS_UID_EVENT_REPORTED, long metric_id, long value, int uid);<br>
     */
    public static final int EXPRESS_UID_EVENT_REPORTED = 644;

    /**
     * ExpressUidHistogramSampleReported express_uid_histogram_sample_reported<br>
     * Usage: StatsLog.write(StatsLog.EXPRESS_UID_HISTOGRAM_SAMPLE_REPORTED, long metric_id, long count, int bin_index, int uid);<br>
     */
    public static final int EXPRESS_UID_HISTOGRAM_SAMPLE_REPORTED = 658;

    // Constants for enum values.

    // Annotation constants.
    public static final byte ANNOTATION_ID_IS_UID = StatsLog.ANNOTATION_ID_IS_UID;
    public static final byte ANNOTATION_ID_TRUNCATE_TIMESTAMP = StatsLog.ANNOTATION_ID_TRUNCATE_TIMESTAMP;
    public static final byte ANNOTATION_ID_PRIMARY_FIELD = StatsLog.ANNOTATION_ID_PRIMARY_FIELD;
    public static final byte ANNOTATION_ID_EXCLUSIVE_STATE = StatsLog.ANNOTATION_ID_EXCLUSIVE_STATE;
    public static final byte ANNOTATION_ID_PRIMARY_FIELD_FIRST_UID = StatsLog.ANNOTATION_ID_PRIMARY_FIELD_FIRST_UID;
    public static final byte ANNOTATION_ID_DEFAULT_STATE = StatsLog.ANNOTATION_ID_DEFAULT_STATE;
    public static final byte ANNOTATION_ID_TRIGGER_STATE_RESET = StatsLog.ANNOTATION_ID_TRIGGER_STATE_RESET;
    public static final byte ANNOTATION_ID_STATE_NESTED = StatsLog.ANNOTATION_ID_STATE_NESTED;

    // Write methods
    public static void write(int code, long arg1, long arg2) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeLong(arg1);
        builder.writeLong(arg2);

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, long arg1, long arg2, int arg3) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeLong(arg1);
        builder.writeLong(arg2);
        builder.writeInt(arg3);
        if (EXPRESS_UID_EVENT_REPORTED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

    public static void write(int code, long arg1, long arg2, int arg3, int arg4) {
        final StatsEvent.Builder builder = StatsEvent.newBuilder();
        builder.setAtomId(code);
        builder.writeLong(arg1);
        builder.writeLong(arg2);
        builder.writeInt(arg3);
        builder.writeInt(arg4);
        if (EXPRESS_UID_HISTOGRAM_SAMPLE_REPORTED == code) {
            builder.addBooleanAnnotation(ANNOTATION_ID_IS_UID, true);
        }

        builder.usePooledBuffer();
        StatsLog.write(builder.build());
    }

}
