/* GENERATED SOURCE. DO NOT MODIFY. */
/*
 * Copyright (C) 2020 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.android.org.conscrypt.metrics;

import com.android.org.conscrypt.Internal;

/**
 * Reflection wrapper around android.util.StatsLog.
 * @hide This class is not part of the Android public SDK API
 */
@Internal
public class ReflexiveStatsLog {
    private static final Class<?> c_statsLog;
    private static final Class<?> c_statsEvent;
    private static final OptionalMethod write;

    static {
        c_statsLog = initStatsLogClass();
        c_statsEvent = initStatsEventClass();
        write = new OptionalMethod(c_statsLog, "write", c_statsEvent);
    }

    private static Class<?> initStatsLogClass() {
        try {
            return Class.forName("android.util.StatsLog");
        } catch (ClassNotFoundException ignored) {
            return null;
        }
    }

    private static Class<?> initStatsEventClass() {
        try {
            return Class.forName("android.util.StatsEvent");
        } catch (ClassNotFoundException ignored) {
            return null;
        }
    }

    private ReflexiveStatsLog() {}

    public static void write(ReflexiveStatsEvent event) {
        Object statsEvent = event.getStatsEvent();
        if (statsEvent != null) {
            write.invokeStatic(statsEvent);
        }
    }
}
