#ifndef ANDROID_AUDIO_POLICY_CONFIGURATION_V7_0_ENUMS_H
#define ANDROID_AUDIO_POLICY_CONFIGURATION_V7_0_ENUMS_H

#include <array>
#include <string>

#include <xsdc/XsdcSupport.h>

namespace android {
    namespace audio {
        namespace policy {
            namespace configuration {
                namespace V7_0 {
                    enum class Version {
                        UNKNOWN = -1,
                        _7_0,
                    };
                    Version stringToVersion(const std::string& value);
                    std::string toString(Version o);

                    enum class HalVersion {
                        UNKNOWN = -1,
                        _2_0,
                        _3_0,
                    };
                    HalVersion stringToHalVersion(const std::string& value);
                    std::string toString(HalVersion o);

                    enum class AudioInOutFlag {
                        UNKNOWN = -1,
                        AUDIO_OUTPUT_FLAG_DIRECT,
                        AUDIO_OUTPUT_FLAG_PRIMARY,
                        AUDIO_OUTPUT_FLAG_FAST,
                        AUDIO_OUTPUT_FLAG_DEEP_BUFFER,
                        AUDIO_OUTPUT_FLAG_COMPRESS_OFFLOAD,
                        AUDIO_OUTPUT_FLAG_NON_BLOCKING,
                        AUDIO_OUTPUT_FLAG_HW_AV_SYNC,
                        AUDIO_OUTPUT_FLAG_TTS,
                        AUDIO_OUTPUT_FLAG_RAW,
                        AUDIO_OUTPUT_FLAG_SYNC,
                        AUDIO_OUTPUT_FLAG_IEC958_NONAUDIO,
                        AUDIO_OUTPUT_FLAG_DIRECT_PCM,
                        AUDIO_OUTPUT_FLAG_MMAP_NOIRQ,
                        AUDIO_OUTPUT_FLAG_VOIP_RX,
                        AUDIO_OUTPUT_FLAG_INCALL_MUSIC,
                        AUDIO_OUTPUT_FLAG_GAPLESS_OFFLOAD,
                        AUDIO_INPUT_FLAG_FAST,
                        AUDIO_INPUT_FLAG_HW_HOTWORD,
                        AUDIO_INPUT_FLAG_RAW,
                        AUDIO_INPUT_FLAG_SYNC,
                        AUDIO_INPUT_FLAG_MMAP_NOIRQ,
                        AUDIO_INPUT_FLAG_VOIP_TX,
                        AUDIO_INPUT_FLAG_HW_AV_SYNC,
                        AUDIO_INPUT_FLAG_DIRECT,
                    };
                    AudioInOutFlag stringToAudioInOutFlag(const std::string& value);
                    std::string toString(AudioInOutFlag o);

                    enum class Role {
                        UNKNOWN = -1,
                        sink,
                        source,
                    };
                    Role stringToRole(const std::string& value);
                    std::string toString(Role o);

                    enum class AudioDevice {
                        UNKNOWN = -1,
                        AUDIO_DEVICE_NONE,
                        AUDIO_DEVICE_OUT_EARPIECE,
                        AUDIO_DEVICE_OUT_SPEAKER,
                        AUDIO_DEVICE_OUT_WIRED_HEADSET,
                        AUDIO_DEVICE_OUT_WIRED_HEADPHONE,
                        AUDIO_DEVICE_OUT_BLUETOOTH_SCO,
                        AUDIO_DEVICE_OUT_BLUETOOTH_SCO_HEADSET,
                        AUDIO_DEVICE_OUT_BLUETOOTH_SCO_CARKIT,
                        AUDIO_DEVICE_OUT_BLUETOOTH_A2DP,
                        AUDIO_DEVICE_OUT_BLUETOOTH_A2DP_HEADPHONES,
                        AUDIO_DEVICE_OUT_BLUETOOTH_A2DP_SPEAKER,
                        AUDIO_DEVICE_OUT_HDMI,
                        AUDIO_DEVICE_OUT_HDMI_EARC,
                        AUDIO_DEVICE_OUT_AUX_DIGITAL,
                        AUDIO_DEVICE_OUT_ANLG_DOCK_HEADSET,
                        AUDIO_DEVICE_OUT_DGTL_DOCK_HEADSET,
                        AUDIO_DEVICE_OUT_USB_ACCESSORY,
                        AUDIO_DEVICE_OUT_USB_DEVICE,
                        AUDIO_DEVICE_OUT_REMOTE_SUBMIX,
                        AUDIO_DEVICE_OUT_TELEPHONY_TX,
                        AUDIO_DEVICE_OUT_LINE,
                        AUDIO_DEVICE_OUT_HDMI_ARC,
                        AUDIO_DEVICE_OUT_SPDIF,
                        AUDIO_DEVICE_OUT_FM,
                        AUDIO_DEVICE_OUT_AUX_LINE,
                        AUDIO_DEVICE_OUT_SPEAKER_SAFE,
                        AUDIO_DEVICE_OUT_IP,
                        AUDIO_DEVICE_OUT_BUS,
                        AUDIO_DEVICE_OUT_PROXY,
                        AUDIO_DEVICE_OUT_USB_HEADSET,
                        AUDIO_DEVICE_OUT_HEARING_AID,
                        AUDIO_DEVICE_OUT_ECHO_CANCELLER,
                        AUDIO_DEVICE_OUT_BLE_HEADSET,
                        AUDIO_DEVICE_OUT_BLE_SPEAKER,
                        AUDIO_DEVICE_OUT_DEFAULT,
                        AUDIO_DEVICE_OUT_STUB,
                        AUDIO_DEVICE_IN_COMMUNICATION,
                        AUDIO_DEVICE_IN_AMBIENT,
                        AUDIO_DEVICE_IN_BUILTIN_MIC,
                        AUDIO_DEVICE_IN_BLUETOOTH_SCO_HEADSET,
                        AUDIO_DEVICE_IN_WIRED_HEADSET,
                        AUDIO_DEVICE_IN_HDMI,
                        AUDIO_DEVICE_IN_AUX_DIGITAL,
                        AUDIO_DEVICE_IN_VOICE_CALL,
                        AUDIO_DEVICE_IN_TELEPHONY_RX,
                        AUDIO_DEVICE_IN_BACK_MIC,
                        AUDIO_DEVICE_IN_REMOTE_SUBMIX,
                        AUDIO_DEVICE_IN_ANLG_DOCK_HEADSET,
                        AUDIO_DEVICE_IN_DGTL_DOCK_HEADSET,
                        AUDIO_DEVICE_IN_USB_ACCESSORY,
                        AUDIO_DEVICE_IN_USB_DEVICE,
                        AUDIO_DEVICE_IN_FM_TUNER,
                        AUDIO_DEVICE_IN_TV_TUNER,
                        AUDIO_DEVICE_IN_LINE,
                        AUDIO_DEVICE_IN_SPDIF,
                        AUDIO_DEVICE_IN_BLUETOOTH_A2DP,
                        AUDIO_DEVICE_IN_LOOPBACK,
                        AUDIO_DEVICE_IN_IP,
                        AUDIO_DEVICE_IN_BUS,
                        AUDIO_DEVICE_IN_PROXY,
                        AUDIO_DEVICE_IN_USB_HEADSET,
                        AUDIO_DEVICE_IN_BLUETOOTH_BLE,
                        AUDIO_DEVICE_IN_HDMI_ARC,
                        AUDIO_DEVICE_IN_HDMI_EARC,
                        AUDIO_DEVICE_IN_ECHO_REFERENCE,
                        AUDIO_DEVICE_IN_BLE_HEADSET,
                        AUDIO_DEVICE_IN_DEFAULT,
                        AUDIO_DEVICE_IN_STUB,
                    };
                    AudioDevice stringToAudioDevice(const std::string& value);
                    std::string toString(AudioDevice o);

                    enum class AudioFormat {
                        UNKNOWN = -1,
                        AUDIO_FORMAT_DEFAULT,
                        AUDIO_FORMAT_PCM_16_BIT,
                        AUDIO_FORMAT_PCM_8_BIT,
                        AUDIO_FORMAT_PCM_32_BIT,
                        AUDIO_FORMAT_PCM_8_24_BIT,
                        AUDIO_FORMAT_PCM_FLOAT,
                        AUDIO_FORMAT_PCM_24_BIT_PACKED,
                        AUDIO_FORMAT_MP3,
                        AUDIO_FORMAT_AMR_NB,
                        AUDIO_FORMAT_AMR_WB,
                        AUDIO_FORMAT_AAC,
                        AUDIO_FORMAT_AAC_MAIN,
                        AUDIO_FORMAT_AAC_LC,
                        AUDIO_FORMAT_AAC_SSR,
                        AUDIO_FORMAT_AAC_LTP,
                        AUDIO_FORMAT_AAC_HE_V1,
                        AUDIO_FORMAT_AAC_SCALABLE,
                        AUDIO_FORMAT_AAC_ERLC,
                        AUDIO_FORMAT_AAC_LD,
                        AUDIO_FORMAT_AAC_HE_V2,
                        AUDIO_FORMAT_AAC_ELD,
                        AUDIO_FORMAT_AAC_XHE,
                        AUDIO_FORMAT_HE_AAC_V1,
                        AUDIO_FORMAT_HE_AAC_V2,
                        AUDIO_FORMAT_VORBIS,
                        AUDIO_FORMAT_OPUS,
                        AUDIO_FORMAT_AC3,
                        AUDIO_FORMAT_E_AC3,
                        AUDIO_FORMAT_E_AC3_JOC,
                        AUDIO_FORMAT_DTS,
                        AUDIO_FORMAT_DTS_HD,
                        AUDIO_FORMAT_IEC61937,
                        AUDIO_FORMAT_DOLBY_TRUEHD,
                        AUDIO_FORMAT_EVRC,
                        AUDIO_FORMAT_EVRCB,
                        AUDIO_FORMAT_EVRCWB,
                        AUDIO_FORMAT_EVRCNW,
                        AUDIO_FORMAT_AAC_ADIF,
                        AUDIO_FORMAT_WMA,
                        AUDIO_FORMAT_WMA_PRO,
                        AUDIO_FORMAT_AMR_WB_PLUS,
                        AUDIO_FORMAT_MP2,
                        AUDIO_FORMAT_QCELP,
                        AUDIO_FORMAT_DSD,
                        AUDIO_FORMAT_FLAC,
                        AUDIO_FORMAT_ALAC,
                        AUDIO_FORMAT_APE,
                        AUDIO_FORMAT_AAC_ADTS,
                        AUDIO_FORMAT_AAC_ADTS_MAIN,
                        AUDIO_FORMAT_AAC_ADTS_LC,
                        AUDIO_FORMAT_AAC_ADTS_SSR,
                        AUDIO_FORMAT_AAC_ADTS_LTP,
                        AUDIO_FORMAT_AAC_ADTS_HE_V1,
                        AUDIO_FORMAT_AAC_ADTS_SCALABLE,
                        AUDIO_FORMAT_AAC_ADTS_ERLC,
                        AUDIO_FORMAT_AAC_ADTS_LD,
                        AUDIO_FORMAT_AAC_ADTS_HE_V2,
                        AUDIO_FORMAT_AAC_ADTS_ELD,
                        AUDIO_FORMAT_AAC_ADTS_XHE,
                        AUDIO_FORMAT_SBC,
                        AUDIO_FORMAT_APTX,
                        AUDIO_FORMAT_APTX_HD,
                        AUDIO_FORMAT_AC4,
                        AUDIO_FORMAT_LDAC,
                        AUDIO_FORMAT_MAT,
                        AUDIO_FORMAT_MAT_1_0,
                        AUDIO_FORMAT_MAT_2_0,
                        AUDIO_FORMAT_MAT_2_1,
                        AUDIO_FORMAT_AAC_LATM,
                        AUDIO_FORMAT_AAC_LATM_LC,
                        AUDIO_FORMAT_AAC_LATM_HE_V1,
                        AUDIO_FORMAT_AAC_LATM_HE_V2,
                        AUDIO_FORMAT_CELT,
                        AUDIO_FORMAT_APTX_ADAPTIVE,
                        AUDIO_FORMAT_LHDC,
                        AUDIO_FORMAT_LHDC_LL,
                        AUDIO_FORMAT_APTX_TWSP,
                        AUDIO_FORMAT_LC3,
                        AUDIO_FORMAT_MPEGH_BL_L3,
                        AUDIO_FORMAT_MPEGH_BL_L4,
                        AUDIO_FORMAT_MPEGH_LC_L3,
                        AUDIO_FORMAT_MPEGH_LC_L4,
                        AUDIO_FORMAT_IEC60958,
                        AUDIO_FORMAT_DTS_UHD,
                        AUDIO_FORMAT_DRA,
                    };
                    AudioFormat stringToAudioFormat(const std::string& value);
                    std::string toString(AudioFormat o);

                    enum class AudioUsage {
                        UNKNOWN = -1,
                        AUDIO_USAGE_UNKNOWN,
                        AUDIO_USAGE_MEDIA,
                        AUDIO_USAGE_VOICE_COMMUNICATION,
                        AUDIO_USAGE_VOICE_COMMUNICATION_SIGNALLING,
                        AUDIO_USAGE_ALARM,
                        AUDIO_USAGE_NOTIFICATION,
                        AUDIO_USAGE_NOTIFICATION_TELEPHONY_RINGTONE,
                        AUDIO_USAGE_ASSISTANCE_ACCESSIBILITY,
                        AUDIO_USAGE_ASSISTANCE_NAVIGATION_GUIDANCE,
                        AUDIO_USAGE_ASSISTANCE_SONIFICATION,
                        AUDIO_USAGE_GAME,
                        AUDIO_USAGE_VIRTUAL_SOURCE,
                        AUDIO_USAGE_ASSISTANT,
                        AUDIO_USAGE_CALL_ASSISTANT,
                        AUDIO_USAGE_EMERGENCY,
                        AUDIO_USAGE_SAFETY,
                        AUDIO_USAGE_VEHICLE_STATUS,
                        AUDIO_USAGE_ANNOUNCEMENT,
                    };
                    AudioUsage stringToAudioUsage(const std::string& value);
                    std::string toString(AudioUsage o);

                    enum class AudioContentType {
                        UNKNOWN = -1,
                        AUDIO_CONTENT_TYPE_UNKNOWN,
                        AUDIO_CONTENT_TYPE_SPEECH,
                        AUDIO_CONTENT_TYPE_MUSIC,
                        AUDIO_CONTENT_TYPE_MOVIE,
                        AUDIO_CONTENT_TYPE_SONIFICATION,
                    };
                    AudioContentType stringToAudioContentType(const std::string& value);
                    std::string toString(AudioContentType o);

                    enum class AudioChannelMask {
                        UNKNOWN = -1,
                        AUDIO_CHANNEL_NONE,
                        AUDIO_CHANNEL_OUT_MONO,
                        AUDIO_CHANNEL_OUT_STEREO,
                        AUDIO_CHANNEL_OUT_2POINT1,
                        AUDIO_CHANNEL_OUT_TRI,
                        AUDIO_CHANNEL_OUT_TRI_BACK,
                        AUDIO_CHANNEL_OUT_3POINT1,
                        AUDIO_CHANNEL_OUT_2POINT0POINT2,
                        AUDIO_CHANNEL_OUT_2POINT1POINT2,
                        AUDIO_CHANNEL_OUT_3POINT0POINT2,
                        AUDIO_CHANNEL_OUT_3POINT1POINT2,
                        AUDIO_CHANNEL_OUT_QUAD,
                        AUDIO_CHANNEL_OUT_QUAD_BACK,
                        AUDIO_CHANNEL_OUT_QUAD_SIDE,
                        AUDIO_CHANNEL_OUT_SURROUND,
                        AUDIO_CHANNEL_OUT_PENTA,
                        AUDIO_CHANNEL_OUT_5POINT1,
                        AUDIO_CHANNEL_OUT_5POINT1_BACK,
                        AUDIO_CHANNEL_OUT_5POINT1_SIDE,
                        AUDIO_CHANNEL_OUT_5POINT1POINT2,
                        AUDIO_CHANNEL_OUT_5POINT1POINT4,
                        AUDIO_CHANNEL_OUT_6POINT1,
                        AUDIO_CHANNEL_OUT_7POINT1,
                        AUDIO_CHANNEL_OUT_7POINT1POINT2,
                        AUDIO_CHANNEL_OUT_7POINT1POINT4,
                        AUDIO_CHANNEL_OUT_13POINT_360RA,
                        AUDIO_CHANNEL_OUT_22POINT2,
                        AUDIO_CHANNEL_OUT_MONO_HAPTIC_A,
                        AUDIO_CHANNEL_OUT_STEREO_HAPTIC_A,
                        AUDIO_CHANNEL_OUT_HAPTIC_AB,
                        AUDIO_CHANNEL_OUT_MONO_HAPTIC_AB,
                        AUDIO_CHANNEL_OUT_STEREO_HAPTIC_AB,
                        AUDIO_CHANNEL_IN_MONO,
                        AUDIO_CHANNEL_IN_STEREO,
                        AUDIO_CHANNEL_IN_FRONT_BACK,
                        AUDIO_CHANNEL_IN_6,
                        AUDIO_CHANNEL_IN_2POINT0POINT2,
                        AUDIO_CHANNEL_IN_2POINT1POINT2,
                        AUDIO_CHANNEL_IN_3POINT0POINT2,
                        AUDIO_CHANNEL_IN_3POINT1POINT2,
                        AUDIO_CHANNEL_IN_5POINT1,
                        AUDIO_CHANNEL_IN_VOICE_UPLINK_MONO,
                        AUDIO_CHANNEL_IN_VOICE_DNLINK_MONO,
                        AUDIO_CHANNEL_IN_VOICE_CALL_MONO,
                        AUDIO_CHANNEL_INDEX_MASK_1,
                        AUDIO_CHANNEL_INDEX_MASK_2,
                        AUDIO_CHANNEL_INDEX_MASK_3,
                        AUDIO_CHANNEL_INDEX_MASK_4,
                        AUDIO_CHANNEL_INDEX_MASK_5,
                        AUDIO_CHANNEL_INDEX_MASK_6,
                        AUDIO_CHANNEL_INDEX_MASK_7,
                        AUDIO_CHANNEL_INDEX_MASK_8,
                        AUDIO_CHANNEL_INDEX_MASK_9,
                        AUDIO_CHANNEL_INDEX_MASK_10,
                        AUDIO_CHANNEL_INDEX_MASK_11,
                        AUDIO_CHANNEL_INDEX_MASK_12,
                        AUDIO_CHANNEL_INDEX_MASK_13,
                        AUDIO_CHANNEL_INDEX_MASK_14,
                        AUDIO_CHANNEL_INDEX_MASK_15,
                        AUDIO_CHANNEL_INDEX_MASK_16,
                        AUDIO_CHANNEL_INDEX_MASK_17,
                        AUDIO_CHANNEL_INDEX_MASK_18,
                        AUDIO_CHANNEL_INDEX_MASK_19,
                        AUDIO_CHANNEL_INDEX_MASK_20,
                        AUDIO_CHANNEL_INDEX_MASK_21,
                        AUDIO_CHANNEL_INDEX_MASK_22,
                        AUDIO_CHANNEL_INDEX_MASK_23,
                        AUDIO_CHANNEL_INDEX_MASK_24,
                    };
                    AudioChannelMask stringToAudioChannelMask(const std::string& value);
                    std::string toString(AudioChannelMask o);

                    enum class AudioEncapsulationType {
                        UNKNOWN = -1,
                        AUDIO_ENCAPSULATION_TYPE_NONE,
                        AUDIO_ENCAPSULATION_TYPE_IEC61937,
                    };
                    AudioEncapsulationType stringToAudioEncapsulationType(const std::string& value);
                    std::string toString(AudioEncapsulationType o);

                    enum class AudioGainMode {
                        UNKNOWN = -1,
                        AUDIO_GAIN_MODE_JOINT,
                        AUDIO_GAIN_MODE_CHANNELS,
                        AUDIO_GAIN_MODE_RAMP,
                    };
                    AudioGainMode stringToAudioGainMode(const std::string& value);
                    std::string toString(AudioGainMode o);

                    enum class MixType {
                        UNKNOWN = -1,
                        mix,
                        mux,
                    };
                    MixType stringToMixType(const std::string& value);
                    std::string toString(MixType o);

                    enum class AudioStreamType {
                        UNKNOWN = -1,
                        AUDIO_STREAM_VOICE_CALL,
                        AUDIO_STREAM_SYSTEM,
                        AUDIO_STREAM_RING,
                        AUDIO_STREAM_MUSIC,
                        AUDIO_STREAM_ALARM,
                        AUDIO_STREAM_NOTIFICATION,
                        AUDIO_STREAM_BLUETOOTH_SCO,
                        AUDIO_STREAM_ENFORCED_AUDIBLE,
                        AUDIO_STREAM_DTMF,
                        AUDIO_STREAM_TTS,
                        AUDIO_STREAM_ACCESSIBILITY,
                        AUDIO_STREAM_ASSISTANT,
                        AUDIO_STREAM_REROUTING,
                        AUDIO_STREAM_PATCH,
                        AUDIO_STREAM_CALL_ASSISTANT,
                    };
                    AudioStreamType stringToAudioStreamType(const std::string& value);
                    std::string toString(AudioStreamType o);

                    enum class AudioSource {
                        UNKNOWN = -1,
                        AUDIO_SOURCE_DEFAULT,
                        AUDIO_SOURCE_MIC,
                        AUDIO_SOURCE_VOICE_UPLINK,
                        AUDIO_SOURCE_VOICE_DOWNLINK,
                        AUDIO_SOURCE_VOICE_CALL,
                        AUDIO_SOURCE_CAMCORDER,
                        AUDIO_SOURCE_VOICE_RECOGNITION,
                        AUDIO_SOURCE_VOICE_COMMUNICATION,
                        AUDIO_SOURCE_REMOTE_SUBMIX,
                        AUDIO_SOURCE_UNPROCESSED,
                        AUDIO_SOURCE_VOICE_PERFORMANCE,
                        AUDIO_SOURCE_ECHO_REFERENCE,
                        AUDIO_SOURCE_FM_TUNER,
                        AUDIO_SOURCE_HOTWORD,
                    };
                    AudioSource stringToAudioSource(const std::string& value);
                    std::string toString(AudioSource o);

                    enum class DeviceCategory {
                        UNKNOWN = -1,
                        DEVICE_CATEGORY_HEADSET,
                        DEVICE_CATEGORY_SPEAKER,
                        DEVICE_CATEGORY_EARPIECE,
                        DEVICE_CATEGORY_EXT_MEDIA,
                        DEVICE_CATEGORY_HEARING_AID,
                    };
                    DeviceCategory stringToDeviceCategory(const std::string& value);
                    std::string toString(DeviceCategory o);

                    enum class EngineSuffix {
                        UNKNOWN = -1,
                        _default,
                        configurable,
                    };
                    EngineSuffix stringToEngineSuffix(const std::string& value);
                    std::string toString(EngineSuffix o);

                } // V7_0
            } // configuration
        } // policy
    } // audio
} // android

//
// global type declarations for package
//

namespace android {
    namespace details {
        template<> inline constexpr std::array<::android::audio::policy::configuration::V7_0::Version, 1> xsdc_enum_values<::android::audio::policy::configuration::V7_0::Version> = {
            ::android::audio::policy::configuration::V7_0::Version::_7_0,
        };
        template<> inline constexpr std::array<::android::audio::policy::configuration::V7_0::HalVersion, 2> xsdc_enum_values<::android::audio::policy::configuration::V7_0::HalVersion> = {
            ::android::audio::policy::configuration::V7_0::HalVersion::_2_0,
            ::android::audio::policy::configuration::V7_0::HalVersion::_3_0,
        };
        template<> inline constexpr std::array<::android::audio::policy::configuration::V7_0::AudioInOutFlag, 24> xsdc_enum_values<::android::audio::policy::configuration::V7_0::AudioInOutFlag> = {
            ::android::audio::policy::configuration::V7_0::AudioInOutFlag::AUDIO_OUTPUT_FLAG_DIRECT,
            ::android::audio::policy::configuration::V7_0::AudioInOutFlag::AUDIO_OUTPUT_FLAG_PRIMARY,
            ::android::audio::policy::configuration::V7_0::AudioInOutFlag::AUDIO_OUTPUT_FLAG_FAST,
            ::android::audio::policy::configuration::V7_0::AudioInOutFlag::AUDIO_OUTPUT_FLAG_DEEP_BUFFER,
            ::android::audio::policy::configuration::V7_0::AudioInOutFlag::AUDIO_OUTPUT_FLAG_COMPRESS_OFFLOAD,
            ::android::audio::policy::configuration::V7_0::AudioInOutFlag::AUDIO_OUTPUT_FLAG_NON_BLOCKING,
            ::android::audio::policy::configuration::V7_0::AudioInOutFlag::AUDIO_OUTPUT_FLAG_HW_AV_SYNC,
            ::android::audio::policy::configuration::V7_0::AudioInOutFlag::AUDIO_OUTPUT_FLAG_TTS,
            ::android::audio::policy::configuration::V7_0::AudioInOutFlag::AUDIO_OUTPUT_FLAG_RAW,
            ::android::audio::policy::configuration::V7_0::AudioInOutFlag::AUDIO_OUTPUT_FLAG_SYNC,
            ::android::audio::policy::configuration::V7_0::AudioInOutFlag::AUDIO_OUTPUT_FLAG_IEC958_NONAUDIO,
            ::android::audio::policy::configuration::V7_0::AudioInOutFlag::AUDIO_OUTPUT_FLAG_DIRECT_PCM,
            ::android::audio::policy::configuration::V7_0::AudioInOutFlag::AUDIO_OUTPUT_FLAG_MMAP_NOIRQ,
            ::android::audio::policy::configuration::V7_0::AudioInOutFlag::AUDIO_OUTPUT_FLAG_VOIP_RX,
            ::android::audio::policy::configuration::V7_0::AudioInOutFlag::AUDIO_OUTPUT_FLAG_INCALL_MUSIC,
            ::android::audio::policy::configuration::V7_0::AudioInOutFlag::AUDIO_OUTPUT_FLAG_GAPLESS_OFFLOAD,
            ::android::audio::policy::configuration::V7_0::AudioInOutFlag::AUDIO_INPUT_FLAG_FAST,
            ::android::audio::policy::configuration::V7_0::AudioInOutFlag::AUDIO_INPUT_FLAG_HW_HOTWORD,
            ::android::audio::policy::configuration::V7_0::AudioInOutFlag::AUDIO_INPUT_FLAG_RAW,
            ::android::audio::policy::configuration::V7_0::AudioInOutFlag::AUDIO_INPUT_FLAG_SYNC,
            ::android::audio::policy::configuration::V7_0::AudioInOutFlag::AUDIO_INPUT_FLAG_MMAP_NOIRQ,
            ::android::audio::policy::configuration::V7_0::AudioInOutFlag::AUDIO_INPUT_FLAG_VOIP_TX,
            ::android::audio::policy::configuration::V7_0::AudioInOutFlag::AUDIO_INPUT_FLAG_HW_AV_SYNC,
            ::android::audio::policy::configuration::V7_0::AudioInOutFlag::AUDIO_INPUT_FLAG_DIRECT,
        };
        template<> inline constexpr std::array<::android::audio::policy::configuration::V7_0::Role, 2> xsdc_enum_values<::android::audio::policy::configuration::V7_0::Role> = {
            ::android::audio::policy::configuration::V7_0::Role::sink,
            ::android::audio::policy::configuration::V7_0::Role::source,
        };
        template<> inline constexpr std::array<::android::audio::policy::configuration::V7_0::AudioDevice, 68> xsdc_enum_values<::android::audio::policy::configuration::V7_0::AudioDevice> = {
            ::android::audio::policy::configuration::V7_0::AudioDevice::AUDIO_DEVICE_NONE,
            ::android::audio::policy::configuration::V7_0::AudioDevice::AUDIO_DEVICE_OUT_EARPIECE,
            ::android::audio::policy::configuration::V7_0::AudioDevice::AUDIO_DEVICE_OUT_SPEAKER,
            ::android::audio::policy::configuration::V7_0::AudioDevice::AUDIO_DEVICE_OUT_WIRED_HEADSET,
            ::android::audio::policy::configuration::V7_0::AudioDevice::AUDIO_DEVICE_OUT_WIRED_HEADPHONE,
            ::android::audio::policy::configuration::V7_0::AudioDevice::AUDIO_DEVICE_OUT_BLUETOOTH_SCO,
            ::android::audio::policy::configuration::V7_0::AudioDevice::AUDIO_DEVICE_OUT_BLUETOOTH_SCO_HEADSET,
            ::android::audio::policy::configuration::V7_0::AudioDevice::AUDIO_DEVICE_OUT_BLUETOOTH_SCO_CARKIT,
            ::android::audio::policy::configuration::V7_0::AudioDevice::AUDIO_DEVICE_OUT_BLUETOOTH_A2DP,
            ::android::audio::policy::configuration::V7_0::AudioDevice::AUDIO_DEVICE_OUT_BLUETOOTH_A2DP_HEADPHONES,
            ::android::audio::policy::configuration::V7_0::AudioDevice::AUDIO_DEVICE_OUT_BLUETOOTH_A2DP_SPEAKER,
            ::android::audio::policy::configuration::V7_0::AudioDevice::AUDIO_DEVICE_OUT_HDMI,
            ::android::audio::policy::configuration::V7_0::AudioDevice::AUDIO_DEVICE_OUT_HDMI_EARC,
            ::android::audio::policy::configuration::V7_0::AudioDevice::AUDIO_DEVICE_OUT_AUX_DIGITAL,
            ::android::audio::policy::configuration::V7_0::AudioDevice::AUDIO_DEVICE_OUT_ANLG_DOCK_HEADSET,
            ::android::audio::policy::configuration::V7_0::AudioDevice::AUDIO_DEVICE_OUT_DGTL_DOCK_HEADSET,
            ::android::audio::policy::configuration::V7_0::AudioDevice::AUDIO_DEVICE_OUT_USB_ACCESSORY,
            ::android::audio::policy::configuration::V7_0::AudioDevice::AUDIO_DEVICE_OUT_USB_DEVICE,
            ::android::audio::policy::configuration::V7_0::AudioDevice::AUDIO_DEVICE_OUT_REMOTE_SUBMIX,
            ::android::audio::policy::configuration::V7_0::AudioDevice::AUDIO_DEVICE_OUT_TELEPHONY_TX,
            ::android::audio::policy::configuration::V7_0::AudioDevice::AUDIO_DEVICE_OUT_LINE,
            ::android::audio::policy::configuration::V7_0::AudioDevice::AUDIO_DEVICE_OUT_HDMI_ARC,
            ::android::audio::policy::configuration::V7_0::AudioDevice::AUDIO_DEVICE_OUT_SPDIF,
            ::android::audio::policy::configuration::V7_0::AudioDevice::AUDIO_DEVICE_OUT_FM,
            ::android::audio::policy::configuration::V7_0::AudioDevice::AUDIO_DEVICE_OUT_AUX_LINE,
            ::android::audio::policy::configuration::V7_0::AudioDevice::AUDIO_DEVICE_OUT_SPEAKER_SAFE,
            ::android::audio::policy::configuration::V7_0::AudioDevice::AUDIO_DEVICE_OUT_IP,
            ::android::audio::policy::configuration::V7_0::AudioDevice::AUDIO_DEVICE_OUT_BUS,
            ::android::audio::policy::configuration::V7_0::AudioDevice::AUDIO_DEVICE_OUT_PROXY,
            ::android::audio::policy::configuration::V7_0::AudioDevice::AUDIO_DEVICE_OUT_USB_HEADSET,
            ::android::audio::policy::configuration::V7_0::AudioDevice::AUDIO_DEVICE_OUT_HEARING_AID,
            ::android::audio::policy::configuration::V7_0::AudioDevice::AUDIO_DEVICE_OUT_ECHO_CANCELLER,
            ::android::audio::policy::configuration::V7_0::AudioDevice::AUDIO_DEVICE_OUT_BLE_HEADSET,
            ::android::audio::policy::configuration::V7_0::AudioDevice::AUDIO_DEVICE_OUT_BLE_SPEAKER,
            ::android::audio::policy::configuration::V7_0::AudioDevice::AUDIO_DEVICE_OUT_DEFAULT,
            ::android::audio::policy::configuration::V7_0::AudioDevice::AUDIO_DEVICE_OUT_STUB,
            ::android::audio::policy::configuration::V7_0::AudioDevice::AUDIO_DEVICE_IN_COMMUNICATION,
            ::android::audio::policy::configuration::V7_0::AudioDevice::AUDIO_DEVICE_IN_AMBIENT,
            ::android::audio::policy::configuration::V7_0::AudioDevice::AUDIO_DEVICE_IN_BUILTIN_MIC,
            ::android::audio::policy::configuration::V7_0::AudioDevice::AUDIO_DEVICE_IN_BLUETOOTH_SCO_HEADSET,
            ::android::audio::policy::configuration::V7_0::AudioDevice::AUDIO_DEVICE_IN_WIRED_HEADSET,
            ::android::audio::policy::configuration::V7_0::AudioDevice::AUDIO_DEVICE_IN_HDMI,
            ::android::audio::policy::configuration::V7_0::AudioDevice::AUDIO_DEVICE_IN_AUX_DIGITAL,
            ::android::audio::policy::configuration::V7_0::AudioDevice::AUDIO_DEVICE_IN_VOICE_CALL,
            ::android::audio::policy::configuration::V7_0::AudioDevice::AUDIO_DEVICE_IN_TELEPHONY_RX,
            ::android::audio::policy::configuration::V7_0::AudioDevice::AUDIO_DEVICE_IN_BACK_MIC,
            ::android::audio::policy::configuration::V7_0::AudioDevice::AUDIO_DEVICE_IN_REMOTE_SUBMIX,
            ::android::audio::policy::configuration::V7_0::AudioDevice::AUDIO_DEVICE_IN_ANLG_DOCK_HEADSET,
            ::android::audio::policy::configuration::V7_0::AudioDevice::AUDIO_DEVICE_IN_DGTL_DOCK_HEADSET,
            ::android::audio::policy::configuration::V7_0::AudioDevice::AUDIO_DEVICE_IN_USB_ACCESSORY,
            ::android::audio::policy::configuration::V7_0::AudioDevice::AUDIO_DEVICE_IN_USB_DEVICE,
            ::android::audio::policy::configuration::V7_0::AudioDevice::AUDIO_DEVICE_IN_FM_TUNER,
            ::android::audio::policy::configuration::V7_0::AudioDevice::AUDIO_DEVICE_IN_TV_TUNER,
            ::android::audio::policy::configuration::V7_0::AudioDevice::AUDIO_DEVICE_IN_LINE,
            ::android::audio::policy::configuration::V7_0::AudioDevice::AUDIO_DEVICE_IN_SPDIF,
            ::android::audio::policy::configuration::V7_0::AudioDevice::AUDIO_DEVICE_IN_BLUETOOTH_A2DP,
            ::android::audio::policy::configuration::V7_0::AudioDevice::AUDIO_DEVICE_IN_LOOPBACK,
            ::android::audio::policy::configuration::V7_0::AudioDevice::AUDIO_DEVICE_IN_IP,
            ::android::audio::policy::configuration::V7_0::AudioDevice::AUDIO_DEVICE_IN_BUS,
            ::android::audio::policy::configuration::V7_0::AudioDevice::AUDIO_DEVICE_IN_PROXY,
            ::android::audio::policy::configuration::V7_0::AudioDevice::AUDIO_DEVICE_IN_USB_HEADSET,
            ::android::audio::policy::configuration::V7_0::AudioDevice::AUDIO_DEVICE_IN_BLUETOOTH_BLE,
            ::android::audio::policy::configuration::V7_0::AudioDevice::AUDIO_DEVICE_IN_HDMI_ARC,
            ::android::audio::policy::configuration::V7_0::AudioDevice::AUDIO_DEVICE_IN_HDMI_EARC,
            ::android::audio::policy::configuration::V7_0::AudioDevice::AUDIO_DEVICE_IN_ECHO_REFERENCE,
            ::android::audio::policy::configuration::V7_0::AudioDevice::AUDIO_DEVICE_IN_BLE_HEADSET,
            ::android::audio::policy::configuration::V7_0::AudioDevice::AUDIO_DEVICE_IN_DEFAULT,
            ::android::audio::policy::configuration::V7_0::AudioDevice::AUDIO_DEVICE_IN_STUB,
        };
        template<> inline constexpr std::array<::android::audio::policy::configuration::V7_0::AudioFormat, 85> xsdc_enum_values<::android::audio::policy::configuration::V7_0::AudioFormat> = {
            ::android::audio::policy::configuration::V7_0::AudioFormat::AUDIO_FORMAT_DEFAULT,
            ::android::audio::policy::configuration::V7_0::AudioFormat::AUDIO_FORMAT_PCM_16_BIT,
            ::android::audio::policy::configuration::V7_0::AudioFormat::AUDIO_FORMAT_PCM_8_BIT,
            ::android::audio::policy::configuration::V7_0::AudioFormat::AUDIO_FORMAT_PCM_32_BIT,
            ::android::audio::policy::configuration::V7_0::AudioFormat::AUDIO_FORMAT_PCM_8_24_BIT,
            ::android::audio::policy::configuration::V7_0::AudioFormat::AUDIO_FORMAT_PCM_FLOAT,
            ::android::audio::policy::configuration::V7_0::AudioFormat::AUDIO_FORMAT_PCM_24_BIT_PACKED,
            ::android::audio::policy::configuration::V7_0::AudioFormat::AUDIO_FORMAT_MP3,
            ::android::audio::policy::configuration::V7_0::AudioFormat::AUDIO_FORMAT_AMR_NB,
            ::android::audio::policy::configuration::V7_0::AudioFormat::AUDIO_FORMAT_AMR_WB,
            ::android::audio::policy::configuration::V7_0::AudioFormat::AUDIO_FORMAT_AAC,
            ::android::audio::policy::configuration::V7_0::AudioFormat::AUDIO_FORMAT_AAC_MAIN,
            ::android::audio::policy::configuration::V7_0::AudioFormat::AUDIO_FORMAT_AAC_LC,
            ::android::audio::policy::configuration::V7_0::AudioFormat::AUDIO_FORMAT_AAC_SSR,
            ::android::audio::policy::configuration::V7_0::AudioFormat::AUDIO_FORMAT_AAC_LTP,
            ::android::audio::policy::configuration::V7_0::AudioFormat::AUDIO_FORMAT_AAC_HE_V1,
            ::android::audio::policy::configuration::V7_0::AudioFormat::AUDIO_FORMAT_AAC_SCALABLE,
            ::android::audio::policy::configuration::V7_0::AudioFormat::AUDIO_FORMAT_AAC_ERLC,
            ::android::audio::policy::configuration::V7_0::AudioFormat::AUDIO_FORMAT_AAC_LD,
            ::android::audio::policy::configuration::V7_0::AudioFormat::AUDIO_FORMAT_AAC_HE_V2,
            ::android::audio::policy::configuration::V7_0::AudioFormat::AUDIO_FORMAT_AAC_ELD,
            ::android::audio::policy::configuration::V7_0::AudioFormat::AUDIO_FORMAT_AAC_XHE,
            ::android::audio::policy::configuration::V7_0::AudioFormat::AUDIO_FORMAT_HE_AAC_V1,
            ::android::audio::policy::configuration::V7_0::AudioFormat::AUDIO_FORMAT_HE_AAC_V2,
            ::android::audio::policy::configuration::V7_0::AudioFormat::AUDIO_FORMAT_VORBIS,
            ::android::audio::policy::configuration::V7_0::AudioFormat::AUDIO_FORMAT_OPUS,
            ::android::audio::policy::configuration::V7_0::AudioFormat::AUDIO_FORMAT_AC3,
            ::android::audio::policy::configuration::V7_0::AudioFormat::AUDIO_FORMAT_E_AC3,
            ::android::audio::policy::configuration::V7_0::AudioFormat::AUDIO_FORMAT_E_AC3_JOC,
            ::android::audio::policy::configuration::V7_0::AudioFormat::AUDIO_FORMAT_DTS,
            ::android::audio::policy::configuration::V7_0::AudioFormat::AUDIO_FORMAT_DTS_HD,
            ::android::audio::policy::configuration::V7_0::AudioFormat::AUDIO_FORMAT_IEC61937,
            ::android::audio::policy::configuration::V7_0::AudioFormat::AUDIO_FORMAT_DOLBY_TRUEHD,
            ::android::audio::policy::configuration::V7_0::AudioFormat::AUDIO_FORMAT_EVRC,
            ::android::audio::policy::configuration::V7_0::AudioFormat::AUDIO_FORMAT_EVRCB,
            ::android::audio::policy::configuration::V7_0::AudioFormat::AUDIO_FORMAT_EVRCWB,
            ::android::audio::policy::configuration::V7_0::AudioFormat::AUDIO_FORMAT_EVRCNW,
            ::android::audio::policy::configuration::V7_0::AudioFormat::AUDIO_FORMAT_AAC_ADIF,
            ::android::audio::policy::configuration::V7_0::AudioFormat::AUDIO_FORMAT_WMA,
            ::android::audio::policy::configuration::V7_0::AudioFormat::AUDIO_FORMAT_WMA_PRO,
            ::android::audio::policy::configuration::V7_0::AudioFormat::AUDIO_FORMAT_AMR_WB_PLUS,
            ::android::audio::policy::configuration::V7_0::AudioFormat::AUDIO_FORMAT_MP2,
            ::android::audio::policy::configuration::V7_0::AudioFormat::AUDIO_FORMAT_QCELP,
            ::android::audio::policy::configuration::V7_0::AudioFormat::AUDIO_FORMAT_DSD,
            ::android::audio::policy::configuration::V7_0::AudioFormat::AUDIO_FORMAT_FLAC,
            ::android::audio::policy::configuration::V7_0::AudioFormat::AUDIO_FORMAT_ALAC,
            ::android::audio::policy::configuration::V7_0::AudioFormat::AUDIO_FORMAT_APE,
            ::android::audio::policy::configuration::V7_0::AudioFormat::AUDIO_FORMAT_AAC_ADTS,
            ::android::audio::policy::configuration::V7_0::AudioFormat::AUDIO_FORMAT_AAC_ADTS_MAIN,
            ::android::audio::policy::configuration::V7_0::AudioFormat::AUDIO_FORMAT_AAC_ADTS_LC,
            ::android::audio::policy::configuration::V7_0::AudioFormat::AUDIO_FORMAT_AAC_ADTS_SSR,
            ::android::audio::policy::configuration::V7_0::AudioFormat::AUDIO_FORMAT_AAC_ADTS_LTP,
            ::android::audio::policy::configuration::V7_0::AudioFormat::AUDIO_FORMAT_AAC_ADTS_HE_V1,
            ::android::audio::policy::configuration::V7_0::AudioFormat::AUDIO_FORMAT_AAC_ADTS_SCALABLE,
            ::android::audio::policy::configuration::V7_0::AudioFormat::AUDIO_FORMAT_AAC_ADTS_ERLC,
            ::android::audio::policy::configuration::V7_0::AudioFormat::AUDIO_FORMAT_AAC_ADTS_LD,
            ::android::audio::policy::configuration::V7_0::AudioFormat::AUDIO_FORMAT_AAC_ADTS_HE_V2,
            ::android::audio::policy::configuration::V7_0::AudioFormat::AUDIO_FORMAT_AAC_ADTS_ELD,
            ::android::audio::policy::configuration::V7_0::AudioFormat::AUDIO_FORMAT_AAC_ADTS_XHE,
            ::android::audio::policy::configuration::V7_0::AudioFormat::AUDIO_FORMAT_SBC,
            ::android::audio::policy::configuration::V7_0::AudioFormat::AUDIO_FORMAT_APTX,
            ::android::audio::policy::configuration::V7_0::AudioFormat::AUDIO_FORMAT_APTX_HD,
            ::android::audio::policy::configuration::V7_0::AudioFormat::AUDIO_FORMAT_AC4,
            ::android::audio::policy::configuration::V7_0::AudioFormat::AUDIO_FORMAT_LDAC,
            ::android::audio::policy::configuration::V7_0::AudioFormat::AUDIO_FORMAT_MAT,
            ::android::audio::policy::configuration::V7_0::AudioFormat::AUDIO_FORMAT_MAT_1_0,
            ::android::audio::policy::configuration::V7_0::AudioFormat::AUDIO_FORMAT_MAT_2_0,
            ::android::audio::policy::configuration::V7_0::AudioFormat::AUDIO_FORMAT_MAT_2_1,
            ::android::audio::policy::configuration::V7_0::AudioFormat::AUDIO_FORMAT_AAC_LATM,
            ::android::audio::policy::configuration::V7_0::AudioFormat::AUDIO_FORMAT_AAC_LATM_LC,
            ::android::audio::policy::configuration::V7_0::AudioFormat::AUDIO_FORMAT_AAC_LATM_HE_V1,
            ::android::audio::policy::configuration::V7_0::AudioFormat::AUDIO_FORMAT_AAC_LATM_HE_V2,
            ::android::audio::policy::configuration::V7_0::AudioFormat::AUDIO_FORMAT_CELT,
            ::android::audio::policy::configuration::V7_0::AudioFormat::AUDIO_FORMAT_APTX_ADAPTIVE,
            ::android::audio::policy::configuration::V7_0::AudioFormat::AUDIO_FORMAT_LHDC,
            ::android::audio::policy::configuration::V7_0::AudioFormat::AUDIO_FORMAT_LHDC_LL,
            ::android::audio::policy::configuration::V7_0::AudioFormat::AUDIO_FORMAT_APTX_TWSP,
            ::android::audio::policy::configuration::V7_0::AudioFormat::AUDIO_FORMAT_LC3,
            ::android::audio::policy::configuration::V7_0::AudioFormat::AUDIO_FORMAT_MPEGH_BL_L3,
            ::android::audio::policy::configuration::V7_0::AudioFormat::AUDIO_FORMAT_MPEGH_BL_L4,
            ::android::audio::policy::configuration::V7_0::AudioFormat::AUDIO_FORMAT_MPEGH_LC_L3,
            ::android::audio::policy::configuration::V7_0::AudioFormat::AUDIO_FORMAT_MPEGH_LC_L4,
            ::android::audio::policy::configuration::V7_0::AudioFormat::AUDIO_FORMAT_IEC60958,
            ::android::audio::policy::configuration::V7_0::AudioFormat::AUDIO_FORMAT_DTS_UHD,
            ::android::audio::policy::configuration::V7_0::AudioFormat::AUDIO_FORMAT_DRA,
        };
        template<> inline constexpr std::array<::android::audio::policy::configuration::V7_0::AudioUsage, 18> xsdc_enum_values<::android::audio::policy::configuration::V7_0::AudioUsage> = {
            ::android::audio::policy::configuration::V7_0::AudioUsage::AUDIO_USAGE_UNKNOWN,
            ::android::audio::policy::configuration::V7_0::AudioUsage::AUDIO_USAGE_MEDIA,
            ::android::audio::policy::configuration::V7_0::AudioUsage::AUDIO_USAGE_VOICE_COMMUNICATION,
            ::android::audio::policy::configuration::V7_0::AudioUsage::AUDIO_USAGE_VOICE_COMMUNICATION_SIGNALLING,
            ::android::audio::policy::configuration::V7_0::AudioUsage::AUDIO_USAGE_ALARM,
            ::android::audio::policy::configuration::V7_0::AudioUsage::AUDIO_USAGE_NOTIFICATION,
            ::android::audio::policy::configuration::V7_0::AudioUsage::AUDIO_USAGE_NOTIFICATION_TELEPHONY_RINGTONE,
            ::android::audio::policy::configuration::V7_0::AudioUsage::AUDIO_USAGE_ASSISTANCE_ACCESSIBILITY,
            ::android::audio::policy::configuration::V7_0::AudioUsage::AUDIO_USAGE_ASSISTANCE_NAVIGATION_GUIDANCE,
            ::android::audio::policy::configuration::V7_0::AudioUsage::AUDIO_USAGE_ASSISTANCE_SONIFICATION,
            ::android::audio::policy::configuration::V7_0::AudioUsage::AUDIO_USAGE_GAME,
            ::android::audio::policy::configuration::V7_0::AudioUsage::AUDIO_USAGE_VIRTUAL_SOURCE,
            ::android::audio::policy::configuration::V7_0::AudioUsage::AUDIO_USAGE_ASSISTANT,
            ::android::audio::policy::configuration::V7_0::AudioUsage::AUDIO_USAGE_CALL_ASSISTANT,
            ::android::audio::policy::configuration::V7_0::AudioUsage::AUDIO_USAGE_EMERGENCY,
            ::android::audio::policy::configuration::V7_0::AudioUsage::AUDIO_USAGE_SAFETY,
            ::android::audio::policy::configuration::V7_0::AudioUsage::AUDIO_USAGE_VEHICLE_STATUS,
            ::android::audio::policy::configuration::V7_0::AudioUsage::AUDIO_USAGE_ANNOUNCEMENT,
        };
        template<> inline constexpr std::array<::android::audio::policy::configuration::V7_0::AudioContentType, 5> xsdc_enum_values<::android::audio::policy::configuration::V7_0::AudioContentType> = {
            ::android::audio::policy::configuration::V7_0::AudioContentType::AUDIO_CONTENT_TYPE_UNKNOWN,
            ::android::audio::policy::configuration::V7_0::AudioContentType::AUDIO_CONTENT_TYPE_SPEECH,
            ::android::audio::policy::configuration::V7_0::AudioContentType::AUDIO_CONTENT_TYPE_MUSIC,
            ::android::audio::policy::configuration::V7_0::AudioContentType::AUDIO_CONTENT_TYPE_MOVIE,
            ::android::audio::policy::configuration::V7_0::AudioContentType::AUDIO_CONTENT_TYPE_SONIFICATION,
        };
        template<> inline constexpr std::array<::android::audio::policy::configuration::V7_0::AudioChannelMask, 68> xsdc_enum_values<::android::audio::policy::configuration::V7_0::AudioChannelMask> = {
            ::android::audio::policy::configuration::V7_0::AudioChannelMask::AUDIO_CHANNEL_NONE,
            ::android::audio::policy::configuration::V7_0::AudioChannelMask::AUDIO_CHANNEL_OUT_MONO,
            ::android::audio::policy::configuration::V7_0::AudioChannelMask::AUDIO_CHANNEL_OUT_STEREO,
            ::android::audio::policy::configuration::V7_0::AudioChannelMask::AUDIO_CHANNEL_OUT_2POINT1,
            ::android::audio::policy::configuration::V7_0::AudioChannelMask::AUDIO_CHANNEL_OUT_TRI,
            ::android::audio::policy::configuration::V7_0::AudioChannelMask::AUDIO_CHANNEL_OUT_TRI_BACK,
            ::android::audio::policy::configuration::V7_0::AudioChannelMask::AUDIO_CHANNEL_OUT_3POINT1,
            ::android::audio::policy::configuration::V7_0::AudioChannelMask::AUDIO_CHANNEL_OUT_2POINT0POINT2,
            ::android::audio::policy::configuration::V7_0::AudioChannelMask::AUDIO_CHANNEL_OUT_2POINT1POINT2,
            ::android::audio::policy::configuration::V7_0::AudioChannelMask::AUDIO_CHANNEL_OUT_3POINT0POINT2,
            ::android::audio::policy::configuration::V7_0::AudioChannelMask::AUDIO_CHANNEL_OUT_3POINT1POINT2,
            ::android::audio::policy::configuration::V7_0::AudioChannelMask::AUDIO_CHANNEL_OUT_QUAD,
            ::android::audio::policy::configuration::V7_0::AudioChannelMask::AUDIO_CHANNEL_OUT_QUAD_BACK,
            ::android::audio::policy::configuration::V7_0::AudioChannelMask::AUDIO_CHANNEL_OUT_QUAD_SIDE,
            ::android::audio::policy::configuration::V7_0::AudioChannelMask::AUDIO_CHANNEL_OUT_SURROUND,
            ::android::audio::policy::configuration::V7_0::AudioChannelMask::AUDIO_CHANNEL_OUT_PENTA,
            ::android::audio::policy::configuration::V7_0::AudioChannelMask::AUDIO_CHANNEL_OUT_5POINT1,
            ::android::audio::policy::configuration::V7_0::AudioChannelMask::AUDIO_CHANNEL_OUT_5POINT1_BACK,
            ::android::audio::policy::configuration::V7_0::AudioChannelMask::AUDIO_CHANNEL_OUT_5POINT1_SIDE,
            ::android::audio::policy::configuration::V7_0::AudioChannelMask::AUDIO_CHANNEL_OUT_5POINT1POINT2,
            ::android::audio::policy::configuration::V7_0::AudioChannelMask::AUDIO_CHANNEL_OUT_5POINT1POINT4,
            ::android::audio::policy::configuration::V7_0::AudioChannelMask::AUDIO_CHANNEL_OUT_6POINT1,
            ::android::audio::policy::configuration::V7_0::AudioChannelMask::AUDIO_CHANNEL_OUT_7POINT1,
            ::android::audio::policy::configuration::V7_0::AudioChannelMask::AUDIO_CHANNEL_OUT_7POINT1POINT2,
            ::android::audio::policy::configuration::V7_0::AudioChannelMask::AUDIO_CHANNEL_OUT_7POINT1POINT4,
            ::android::audio::policy::configuration::V7_0::AudioChannelMask::AUDIO_CHANNEL_OUT_13POINT_360RA,
            ::android::audio::policy::configuration::V7_0::AudioChannelMask::AUDIO_CHANNEL_OUT_22POINT2,
            ::android::audio::policy::configuration::V7_0::AudioChannelMask::AUDIO_CHANNEL_OUT_MONO_HAPTIC_A,
            ::android::audio::policy::configuration::V7_0::AudioChannelMask::AUDIO_CHANNEL_OUT_STEREO_HAPTIC_A,
            ::android::audio::policy::configuration::V7_0::AudioChannelMask::AUDIO_CHANNEL_OUT_HAPTIC_AB,
            ::android::audio::policy::configuration::V7_0::AudioChannelMask::AUDIO_CHANNEL_OUT_MONO_HAPTIC_AB,
            ::android::audio::policy::configuration::V7_0::AudioChannelMask::AUDIO_CHANNEL_OUT_STEREO_HAPTIC_AB,
            ::android::audio::policy::configuration::V7_0::AudioChannelMask::AUDIO_CHANNEL_IN_MONO,
            ::android::audio::policy::configuration::V7_0::AudioChannelMask::AUDIO_CHANNEL_IN_STEREO,
            ::android::audio::policy::configuration::V7_0::AudioChannelMask::AUDIO_CHANNEL_IN_FRONT_BACK,
            ::android::audio::policy::configuration::V7_0::AudioChannelMask::AUDIO_CHANNEL_IN_6,
            ::android::audio::policy::configuration::V7_0::AudioChannelMask::AUDIO_CHANNEL_IN_2POINT0POINT2,
            ::android::audio::policy::configuration::V7_0::AudioChannelMask::AUDIO_CHANNEL_IN_2POINT1POINT2,
            ::android::audio::policy::configuration::V7_0::AudioChannelMask::AUDIO_CHANNEL_IN_3POINT0POINT2,
            ::android::audio::policy::configuration::V7_0::AudioChannelMask::AUDIO_CHANNEL_IN_3POINT1POINT2,
            ::android::audio::policy::configuration::V7_0::AudioChannelMask::AUDIO_CHANNEL_IN_5POINT1,
            ::android::audio::policy::configuration::V7_0::AudioChannelMask::AUDIO_CHANNEL_IN_VOICE_UPLINK_MONO,
            ::android::audio::policy::configuration::V7_0::AudioChannelMask::AUDIO_CHANNEL_IN_VOICE_DNLINK_MONO,
            ::android::audio::policy::configuration::V7_0::AudioChannelMask::AUDIO_CHANNEL_IN_VOICE_CALL_MONO,
            ::android::audio::policy::configuration::V7_0::AudioChannelMask::AUDIO_CHANNEL_INDEX_MASK_1,
            ::android::audio::policy::configuration::V7_0::AudioChannelMask::AUDIO_CHANNEL_INDEX_MASK_2,
            ::android::audio::policy::configuration::V7_0::AudioChannelMask::AUDIO_CHANNEL_INDEX_MASK_3,
            ::android::audio::policy::configuration::V7_0::AudioChannelMask::AUDIO_CHANNEL_INDEX_MASK_4,
            ::android::audio::policy::configuration::V7_0::AudioChannelMask::AUDIO_CHANNEL_INDEX_MASK_5,
            ::android::audio::policy::configuration::V7_0::AudioChannelMask::AUDIO_CHANNEL_INDEX_MASK_6,
            ::android::audio::policy::configuration::V7_0::AudioChannelMask::AUDIO_CHANNEL_INDEX_MASK_7,
            ::android::audio::policy::configuration::V7_0::AudioChannelMask::AUDIO_CHANNEL_INDEX_MASK_8,
            ::android::audio::policy::configuration::V7_0::AudioChannelMask::AUDIO_CHANNEL_INDEX_MASK_9,
            ::android::audio::policy::configuration::V7_0::AudioChannelMask::AUDIO_CHANNEL_INDEX_MASK_10,
            ::android::audio::policy::configuration::V7_0::AudioChannelMask::AUDIO_CHANNEL_INDEX_MASK_11,
            ::android::audio::policy::configuration::V7_0::AudioChannelMask::AUDIO_CHANNEL_INDEX_MASK_12,
            ::android::audio::policy::configuration::V7_0::AudioChannelMask::AUDIO_CHANNEL_INDEX_MASK_13,
            ::android::audio::policy::configuration::V7_0::AudioChannelMask::AUDIO_CHANNEL_INDEX_MASK_14,
            ::android::audio::policy::configuration::V7_0::AudioChannelMask::AUDIO_CHANNEL_INDEX_MASK_15,
            ::android::audio::policy::configuration::V7_0::AudioChannelMask::AUDIO_CHANNEL_INDEX_MASK_16,
            ::android::audio::policy::configuration::V7_0::AudioChannelMask::AUDIO_CHANNEL_INDEX_MASK_17,
            ::android::audio::policy::configuration::V7_0::AudioChannelMask::AUDIO_CHANNEL_INDEX_MASK_18,
            ::android::audio::policy::configuration::V7_0::AudioChannelMask::AUDIO_CHANNEL_INDEX_MASK_19,
            ::android::audio::policy::configuration::V7_0::AudioChannelMask::AUDIO_CHANNEL_INDEX_MASK_20,
            ::android::audio::policy::configuration::V7_0::AudioChannelMask::AUDIO_CHANNEL_INDEX_MASK_21,
            ::android::audio::policy::configuration::V7_0::AudioChannelMask::AUDIO_CHANNEL_INDEX_MASK_22,
            ::android::audio::policy::configuration::V7_0::AudioChannelMask::AUDIO_CHANNEL_INDEX_MASK_23,
            ::android::audio::policy::configuration::V7_0::AudioChannelMask::AUDIO_CHANNEL_INDEX_MASK_24,
        };
        template<> inline constexpr std::array<::android::audio::policy::configuration::V7_0::AudioEncapsulationType, 2> xsdc_enum_values<::android::audio::policy::configuration::V7_0::AudioEncapsulationType> = {
            ::android::audio::policy::configuration::V7_0::AudioEncapsulationType::AUDIO_ENCAPSULATION_TYPE_NONE,
            ::android::audio::policy::configuration::V7_0::AudioEncapsulationType::AUDIO_ENCAPSULATION_TYPE_IEC61937,
        };
        template<> inline constexpr std::array<::android::audio::policy::configuration::V7_0::AudioGainMode, 3> xsdc_enum_values<::android::audio::policy::configuration::V7_0::AudioGainMode> = {
            ::android::audio::policy::configuration::V7_0::AudioGainMode::AUDIO_GAIN_MODE_JOINT,
            ::android::audio::policy::configuration::V7_0::AudioGainMode::AUDIO_GAIN_MODE_CHANNELS,
            ::android::audio::policy::configuration::V7_0::AudioGainMode::AUDIO_GAIN_MODE_RAMP,
        };
        template<> inline constexpr std::array<::android::audio::policy::configuration::V7_0::MixType, 2> xsdc_enum_values<::android::audio::policy::configuration::V7_0::MixType> = {
            ::android::audio::policy::configuration::V7_0::MixType::mix,
            ::android::audio::policy::configuration::V7_0::MixType::mux,
        };
        template<> inline constexpr std::array<::android::audio::policy::configuration::V7_0::AudioStreamType, 15> xsdc_enum_values<::android::audio::policy::configuration::V7_0::AudioStreamType> = {
            ::android::audio::policy::configuration::V7_0::AudioStreamType::AUDIO_STREAM_VOICE_CALL,
            ::android::audio::policy::configuration::V7_0::AudioStreamType::AUDIO_STREAM_SYSTEM,
            ::android::audio::policy::configuration::V7_0::AudioStreamType::AUDIO_STREAM_RING,
            ::android::audio::policy::configuration::V7_0::AudioStreamType::AUDIO_STREAM_MUSIC,
            ::android::audio::policy::configuration::V7_0::AudioStreamType::AUDIO_STREAM_ALARM,
            ::android::audio::policy::configuration::V7_0::AudioStreamType::AUDIO_STREAM_NOTIFICATION,
            ::android::audio::policy::configuration::V7_0::AudioStreamType::AUDIO_STREAM_BLUETOOTH_SCO,
            ::android::audio::policy::configuration::V7_0::AudioStreamType::AUDIO_STREAM_ENFORCED_AUDIBLE,
            ::android::audio::policy::configuration::V7_0::AudioStreamType::AUDIO_STREAM_DTMF,
            ::android::audio::policy::configuration::V7_0::AudioStreamType::AUDIO_STREAM_TTS,
            ::android::audio::policy::configuration::V7_0::AudioStreamType::AUDIO_STREAM_ACCESSIBILITY,
            ::android::audio::policy::configuration::V7_0::AudioStreamType::AUDIO_STREAM_ASSISTANT,
            ::android::audio::policy::configuration::V7_0::AudioStreamType::AUDIO_STREAM_REROUTING,
            ::android::audio::policy::configuration::V7_0::AudioStreamType::AUDIO_STREAM_PATCH,
            ::android::audio::policy::configuration::V7_0::AudioStreamType::AUDIO_STREAM_CALL_ASSISTANT,
        };
        template<> inline constexpr std::array<::android::audio::policy::configuration::V7_0::AudioSource, 14> xsdc_enum_values<::android::audio::policy::configuration::V7_0::AudioSource> = {
            ::android::audio::policy::configuration::V7_0::AudioSource::AUDIO_SOURCE_DEFAULT,
            ::android::audio::policy::configuration::V7_0::AudioSource::AUDIO_SOURCE_MIC,
            ::android::audio::policy::configuration::V7_0::AudioSource::AUDIO_SOURCE_VOICE_UPLINK,
            ::android::audio::policy::configuration::V7_0::AudioSource::AUDIO_SOURCE_VOICE_DOWNLINK,
            ::android::audio::policy::configuration::V7_0::AudioSource::AUDIO_SOURCE_VOICE_CALL,
            ::android::audio::policy::configuration::V7_0::AudioSource::AUDIO_SOURCE_CAMCORDER,
            ::android::audio::policy::configuration::V7_0::AudioSource::AUDIO_SOURCE_VOICE_RECOGNITION,
            ::android::audio::policy::configuration::V7_0::AudioSource::AUDIO_SOURCE_VOICE_COMMUNICATION,
            ::android::audio::policy::configuration::V7_0::AudioSource::AUDIO_SOURCE_REMOTE_SUBMIX,
            ::android::audio::policy::configuration::V7_0::AudioSource::AUDIO_SOURCE_UNPROCESSED,
            ::android::audio::policy::configuration::V7_0::AudioSource::AUDIO_SOURCE_VOICE_PERFORMANCE,
            ::android::audio::policy::configuration::V7_0::AudioSource::AUDIO_SOURCE_ECHO_REFERENCE,
            ::android::audio::policy::configuration::V7_0::AudioSource::AUDIO_SOURCE_FM_TUNER,
            ::android::audio::policy::configuration::V7_0::AudioSource::AUDIO_SOURCE_HOTWORD,
        };
        template<> inline constexpr std::array<::android::audio::policy::configuration::V7_0::DeviceCategory, 5> xsdc_enum_values<::android::audio::policy::configuration::V7_0::DeviceCategory> = {
            ::android::audio::policy::configuration::V7_0::DeviceCategory::DEVICE_CATEGORY_HEADSET,
            ::android::audio::policy::configuration::V7_0::DeviceCategory::DEVICE_CATEGORY_SPEAKER,
            ::android::audio::policy::configuration::V7_0::DeviceCategory::DEVICE_CATEGORY_EARPIECE,
            ::android::audio::policy::configuration::V7_0::DeviceCategory::DEVICE_CATEGORY_EXT_MEDIA,
            ::android::audio::policy::configuration::V7_0::DeviceCategory::DEVICE_CATEGORY_HEARING_AID,
        };
        template<> inline constexpr std::array<::android::audio::policy::configuration::V7_0::EngineSuffix, 2> xsdc_enum_values<::android::audio::policy::configuration::V7_0::EngineSuffix> = {
            ::android::audio::policy::configuration::V7_0::EngineSuffix::_default,
            ::android::audio::policy::configuration::V7_0::EngineSuffix::configurable,
        };
    }  // namespace details
}  // namespace android

#endif // ANDROID_AUDIO_POLICY_CONFIGURATION_V7_0_ENUMS_H
