/*
 * Copyright (C) 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.adservices.adselection;

import android.content.Context;
import java.util.concurrent.Executor;

/**
 * AdSelection Manager provides APIs for app and ad-SDKs to run ad selection processes as well as
 * report impressions.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public class AdSelectionManager {

AdSelectionManager() { throw new RuntimeException("Stub!"); }

/**
 * Factory method for creating an instance of AdSelectionManager.
 *
 * @param context The {@link android.content.Context Context} to use
 * This value cannot be {@code null}.
 * @return A {@link android.adservices.adselection.AdSelectionManager AdSelectionManager} instance
 
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public static android.adservices.adselection.AdSelectionManager get(@android.annotation.NonNull android.content.Context context) { throw new RuntimeException("Stub!"); }

/**
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.adselection.TestAdSelectionManager getTestAdSelectionManager() { throw new RuntimeException("Stub!"); }

/**
 * Runs the ad selection process on device to select a remarketing ad for the caller
 * application.
 *
 * <p>The input {@code adSelectionConfig} is provided by the Ads SDK and the {@link android.adservices.adselection.AdSelectionConfig AdSelectionConfig} object is transferred via a Binder call. For this reason, the total size
 * of these objects is bound to the Android IPC limitations. Failures to transfer the {@link android.adservices.adselection.AdSelectionConfig AdSelectionConfig} will throws an {@link android.os.TransactionTooLargeException TransactionTooLargeException}.
 *
 * <p>The output is passed by the receiver, which either returns an {@link android.adservices.adselection.AdSelectionOutcome AdSelectionOutcome}
 * for a successful run, or an {@link java.lang.Exception Exception} includes the type of the exception thrown and
 * the corresponding error message.
 *
 * <p>If the {@link java.lang.IllegalArgumentException IllegalArgumentException} is thrown, it is caused by invalid input argument
 * the API received to run the ad selection.
 *
 * <p>If the {@link java.lang.IllegalStateException IllegalStateException} is thrown with error message "Failure of AdSelection
 * services.", it is caused by an internal failure of the ad selection service.
 *
 * <p>If the {@link java.util.concurrent.TimeoutException TimeoutException} is thrown, it is caused when a timeout is encountered
 * during bidding, scoring, or overall selection process to find winning Ad.
 *
 * <p>If the {@link android.os.LimitExceededException LimitExceededException} is thrown, it is caused when the calling package
 * exceeds the allowed rate limits and is throttled.
 *
 * <p>If the {@link java.lang.SecurityException SecurityException} is thrown, it is caused when the caller is not authorized
 * or permission is not requested.

 * <br>
 * Requires {@link android.adservices.common.AdServicesPermissions#ACCESS_ADSERVICES_CUSTOM_AUDIENCE}
 
 * @param adSelectionConfig This value cannot be {@code null}.

 * @param executor This value cannot be {@code null}.
 
 * Callback and listener events are dispatched through this
 * {@link java.util.concurrent.Executor Executor}, providing an easy way to control which thread is
 * used. To dispatch events through the main thread of your
 * application, you can use
 * {@link android.content.Context#getMainExecutor() Context.getMainExecutor()}.
 * Otherwise, provide an {@link java.util.concurrent.Executor Executor} that dispatches to an appropriate thread.

 * @param receiver This value cannot be {@code null}.
 */

public void selectAds(@android.annotation.NonNull android.adservices.adselection.AdSelectionConfig adSelectionConfig, @android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.os.OutcomeReceiver<android.adservices.adselection.AdSelectionOutcome,java.lang.Exception> receiver) { throw new RuntimeException("Stub!"); }

/**
 * Notifies the service that there is a new impression to report for the ad selected by the
 * ad-selection run identified by {@code adSelectionId}. There is no guarantee about when the
 * impression will be reported. The impression reporting could be delayed and reports could be
 * batched.
 *
 * <p>To calculate the winning seller reporting URL, the service fetches the seller's JavaScript
 * logic from the {@link android.adservices.adselection.AdSelectionConfig#getDecisionLogicUri() AdSelectionConfig#getDecisionLogicUri()} found at {@link android.adservices.adselection.ReportImpressionRequest#getAdSelectionConfig()  }. Then, the service executes one of the
 * functions found in the seller JS called {@code reportResult}, providing on-device signals as
 * well as {@link android.adservices.adselection.ReportImpressionRequest#getAdSelectionConfig() ReportImpressionRequest#getAdSelectionConfig()} as input parameters.
 *
 * <p>The function definition of {@code reportResult} is:
 *
 * <p>{@code function reportResult(ad_selection_config, render_url, bid, contextual_signals) {
 * return { 'status': status, 'results': {'signals_for_buyer': signals_for_buyer,
 * 'reporting_url': reporting_url } }; } }
 *
 * <p>To calculate the winning buyer reporting URL, the service fetches the winning buyer's
 * JavaScript logic which is fetched via the buyer's {@link
 * android.adservices.customaudience.CustomAudience#getBiddingLogicUri()}. Then, the service
 * executes one of the functions found in the buyer JS called {@code reportWin}, providing
 * on-device signals, {@code signals_for_buyer} calculated by {@code reportResult}, and specific
 * fields from {@link android.adservices.adselection.ReportImpressionRequest#getAdSelectionConfig() ReportImpressionRequest#getAdSelectionConfig()} as input parameters.
 *
 * <p>The function definition of {@code reportWin} is:
 *
 * <p>{@code function reportWin(ad_selection_signals, per_buyer_signals, signals_for_buyer,
 * contextual_signals, custom_audience_reporting_signals) { return {'status': 0, 'results':
 * {'reporting_url': reporting_url } }; } }
 *
 * <p>The output is passed by the {@code receiver}, which either returns an empty {@link java.lang.Object Object}
 * for a successful run, or an {@link java.lang.Exception Exception} includes the type of the exception thrown and
 * the corresponding error message.
 *
 * <p>If the {@link java.lang.IllegalArgumentException IllegalArgumentException} is thrown, it is caused by invalid input argument
 * the API received to report the impression.
 *
 * <p>If the {@link java.lang.IllegalStateException IllegalStateException} is thrown with error message "Failure of AdSelection
 * services.", it is caused by an internal failure of the ad selection service.
 *
 * <p>If the {@link android.os.LimitExceededException LimitExceededException} is thrown, it is caused when the calling package
 * exceeds the allowed rate limits and is throttled.
 *
 * <p>If the {@link java.lang.SecurityException SecurityException} is thrown, it is caused when the caller is not authorized
 * or permission is not requested.
 *
 * <p>Impressions will be reported at most once as a best-effort attempt.
 
 * <br>
 * Requires {@link android.adservices.common.AdServicesPermissions#ACCESS_ADSERVICES_CUSTOM_AUDIENCE}

 * @param request This value cannot be {@code null}.
 
 * @param executor This value cannot be {@code null}.

 * @param receiver This value cannot be {@code null}.
 */

public void reportImpression(@android.annotation.NonNull android.adservices.adselection.ReportImpressionRequest request, @android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.os.OutcomeReceiver<java.lang.Object,java.lang.Exception> receiver) { throw new RuntimeException("Stub!"); }
}

