/*
 * Copyright (C) 2014 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.bluetooth.le;


/**
 * Wrapper for Transport Discovery Data AD Type.
 * This class contains the Transport Discovery Data AD Type Code as well as
 * a list of potential Transport Blocks.
 *
 * @see android.bluetooth.le.AdvertiseData
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class TransportDiscoveryData implements android.os.Parcelable {

/**
 * Creates a TransportDiscoveryData instance.
 *
 * @param transportDataType the Transport Discovery Data AD Type
 * @param transportBlocks the list of Transport Blocks

 * This value cannot be {@code null}.
 */

public TransportDiscoveryData(int transportDataType, @android.annotation.NonNull java.util.List<android.bluetooth.le.TransportBlock> transportBlocks) { throw new RuntimeException("Stub!"); }

/**
 * Creates a TransportDiscoveryData instance from byte arrays.
 *
 * Uses the transport discovery data bytes and parses them into an usable class.
 *
 * @param transportDiscoveryData the raw discovery data

 * This value cannot be {@code null}.
 */

public TransportDiscoveryData(@android.annotation.NonNull byte[] transportDiscoveryData) { throw new RuntimeException("Stub!"); }

/**
 * @hide
 */

public int describeContents() { throw new RuntimeException("Stub!"); }

/**
 * @hide
 */

public boolean equals(@android.annotation.Nullable java.lang.Object obj) { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param dest This value cannot be {@code null}.
 */

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

/**
 * Gets the transport data type.
 */

public int getTransportDataType() { throw new RuntimeException("Stub!"); }

/**
 * @return the list of {@link android.bluetooth.le.TransportBlock TransportBlock} in this TransportDiscoveryData
 *         or an empty list if there are no Transport Blocks

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.List<android.bluetooth.le.TransportBlock> getTransportBlocks() { throw new RuntimeException("Stub!"); }

/**
 * Converts this TransportDiscoveryData to byte array
 *
 * @return byte array representation of this Transport Discovery Data or null if the
 *         conversion failed
 */

@android.annotation.Nullable
public byte[] toByteArray() { throw new RuntimeException("Stub!"); }

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

/**
 * @return total byte count of this TransportDataDiscovery
 */

public int totalBytes() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.bluetooth.le.TransportDiscoveryData> CREATOR;
static { CREATOR = null; }
}

