/*
 * Copyright (C) 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.health.connect.changelog;

import android.health.connect.HealthConnectManager;

/**
 * Response class for {@link android.health.connect.HealthConnectManager#getChangeLogToken HealthConnectManager#getChangeLogToken}}
 *
 * @see android.health.connect.HealthConnectManager#getChangeLogToken
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class ChangeLogTokenResponse implements android.os.Parcelable {

ChangeLogTokenResponse() { throw new RuntimeException("Stub!"); }

/**
 * Returns the token for the change logs request
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.lang.String getToken() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param dest This value cannot be {@code null}.
 */

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.health.connect.changelog.ChangeLogTokenResponse> CREATOR;
static { CREATOR = null; }
}

