/*
 * Copyright (C) 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.media;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class AudioPresentation implements android.os.Parcelable {

AudioPresentation() { throw new RuntimeException("Stub!"); }

public int getPresentationId() { throw new RuntimeException("Stub!"); }

public int getProgramId() { throw new RuntimeException("Stub!"); }

public java.util.Map<java.util.Locale,java.lang.String> getLabels() { throw new RuntimeException("Stub!"); }

public java.util.Locale getLocale() { throw new RuntimeException("Stub!"); }

public int getMasteringIndication() { throw new RuntimeException("Stub!"); }

public boolean hasAudioDescription() { throw new RuntimeException("Stub!"); }

public boolean hasSpokenSubtitles() { throw new RuntimeException("Stub!"); }

public boolean hasDialogueEnhancement() { throw new RuntimeException("Stub!"); }

public boolean equals(java.lang.Object o) { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

public static final int CONTENT_COMMENTARY = 5; // 0x5

public static final int CONTENT_DIALOG = 4; // 0x4

public static final int CONTENT_EMERGENCY = 6; // 0x6

public static final int CONTENT_HEARING_IMPAIRED = 3; // 0x3

public static final int CONTENT_MAIN = 0; // 0x0

public static final int CONTENT_MUSIC_AND_EFFECTS = 1; // 0x1

public static final int CONTENT_UNKNOWN = -1; // 0xffffffff

public static final int CONTENT_VISUALLY_IMPAIRED = 2; // 0x2

public static final int CONTENT_VOICEOVER = 7; // 0x7

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.media.AudioPresentation> CREATOR;
static { CREATOR = null; }

public static final int MASTERED_FOR_3D = 3; // 0x3

public static final int MASTERED_FOR_HEADPHONE = 4; // 0x4

public static final int MASTERED_FOR_STEREO = 1; // 0x1

public static final int MASTERED_FOR_SURROUND = 2; // 0x2

public static final int MASTERING_NOT_INDICATED = 0; // 0x0

public static final int PRESENTATION_ID_UNKNOWN = -1; // 0xffffffff

public static final int PROGRAM_ID_UNKNOWN = -1; // 0xffffffff
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

public Builder(int presentationId) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.AudioPresentation.Builder setProgramId(int programId) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.AudioPresentation.Builder setLocale(@android.annotation.NonNull android.icu.util.ULocale language) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.AudioPresentation.Builder setMasteringIndication(int masteringIndication) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.AudioPresentation.Builder setLabels(@android.annotation.NonNull java.util.Map<android.icu.util.ULocale,java.lang.CharSequence> labels) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.AudioPresentation.Builder setHasAudioDescription(boolean audioDescriptionAvailable) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.AudioPresentation.Builder setHasSpokenSubtitles(boolean spokenSubtitlesAvailable) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.AudioPresentation.Builder setHasDialogueEnhancement(boolean dialogueEnhancementAvailable) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.AudioPresentation build() { throw new RuntimeException("Stub!"); }
}

}

