/*
 * Copyright (C) 2019 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.os.ext;

import android.os.Build.VERSION_CODES;

/**
 * Methods for interacting with the extension SDK.
 *
 * This class provides information about the extension SDK versions present
 * on this device. Use the {@link #getExtensionVersion(int) getExtension} method
 * to lookup the version of a given extension.
 *
 * The extension version advances as the platform evolves and new APIs are added,
 * so is suitable to use for determining API availability at runtime.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public class SdkExtensions {

SdkExtensions() { throw new RuntimeException("Stub!"); }

/**
 * Return the version of the specified extensions.
 *
 * This method is suitable to use in conditional statements to determine whether an API is
 * available and is safe to use. For example:
 * <pre>
 * if (getExtensionVersion(VERSION_CODES.R) >= 3) {
 *   // Safely use API available since R extensions version 3
 * }
 * </pre>
 *
 * @param extension the extension to get the version of.
 * Value is {@link android.os.Build.VERSION_CODES#R}, {@link android.os.Build.VERSION_CODES#S}, {@link android.os.Build.VERSION_CODES#TIRAMISU}, {@link android.os.Build.VERSION_CODES#UPSIDE_DOWN_CAKE}, or {@link android.os.ext.SdkExtensions#AD_SERVICES}
 * @throws java.lang.IllegalArgumentException if extension is not a valid extension
 */

public static int getExtensionVersion(int extension) { throw new RuntimeException("Stub!"); }

/**
 * Return all extension versions that exist on this device.
 *
 * @return a map from extension to extension version.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public static java.util.Map<java.lang.Integer,java.lang.Integer> getAllExtensionVersions() { throw new RuntimeException("Stub!"); }

public static final int AD_SERVICES = 1000000; // 0xf4240
}

