/*
 * Copyright (C) 2016 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.view;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class PixelCopy {

PixelCopy() { throw new RuntimeException("Stub!"); }

public static void request(@android.annotation.NonNull android.view.SurfaceView source, @android.annotation.NonNull android.graphics.Bitmap dest, @android.annotation.NonNull android.view.PixelCopy.OnPixelCopyFinishedListener listener, @android.annotation.NonNull android.os.Handler listenerThread) { throw new RuntimeException("Stub!"); }

public static void request(@android.annotation.NonNull android.view.SurfaceView source, @android.annotation.Nullable android.graphics.Rect srcRect, @android.annotation.NonNull android.graphics.Bitmap dest, @android.annotation.NonNull android.view.PixelCopy.OnPixelCopyFinishedListener listener, @android.annotation.NonNull android.os.Handler listenerThread) { throw new RuntimeException("Stub!"); }

public static void request(@android.annotation.NonNull android.view.Surface source, @android.annotation.NonNull android.graphics.Bitmap dest, @android.annotation.NonNull android.view.PixelCopy.OnPixelCopyFinishedListener listener, @android.annotation.NonNull android.os.Handler listenerThread) { throw new RuntimeException("Stub!"); }

public static void request(@android.annotation.NonNull android.view.Surface source, @android.annotation.Nullable android.graphics.Rect srcRect, @android.annotation.NonNull android.graphics.Bitmap dest, @android.annotation.NonNull android.view.PixelCopy.OnPixelCopyFinishedListener listener, @android.annotation.NonNull android.os.Handler listenerThread) { throw new RuntimeException("Stub!"); }

public static void request(@android.annotation.NonNull android.view.Window source, @android.annotation.NonNull android.graphics.Bitmap dest, @android.annotation.NonNull android.view.PixelCopy.OnPixelCopyFinishedListener listener, @android.annotation.NonNull android.os.Handler listenerThread) { throw new RuntimeException("Stub!"); }

public static void request(@android.annotation.NonNull android.view.Window source, @android.annotation.Nullable android.graphics.Rect srcRect, @android.annotation.NonNull android.graphics.Bitmap dest, @android.annotation.NonNull android.view.PixelCopy.OnPixelCopyFinishedListener listener, @android.annotation.NonNull android.os.Handler listenerThread) { throw new RuntimeException("Stub!"); }

public static void request(@android.annotation.NonNull android.view.PixelCopy.Request request, @android.annotation.NonNull java.util.concurrent.Executor callbackExecutor, @android.annotation.NonNull java.util.function.Consumer<android.view.PixelCopy.Result> listener) { throw new RuntimeException("Stub!"); }

public static final int ERROR_DESTINATION_INVALID = 5; // 0x5

public static final int ERROR_SOURCE_INVALID = 4; // 0x4

public static final int ERROR_SOURCE_NO_DATA = 3; // 0x3

public static final int ERROR_TIMEOUT = 2; // 0x2

public static final int ERROR_UNKNOWN = 1; // 0x1

public static final int SUCCESS = 0; // 0x0
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface OnPixelCopyFinishedListener {

public void onPixelCopyFinished(int copyResult);
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Request {

Request() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.graphics.Bitmap getDestinationBitmap() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.graphics.Rect getSourceRect() { throw new RuntimeException("Stub!"); }
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

Builder() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public static android.view.PixelCopy.Request.Builder ofWindow(@android.annotation.NonNull android.view.Window source) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public static android.view.PixelCopy.Request.Builder ofWindow(@android.annotation.NonNull android.view.View source) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public static android.view.PixelCopy.Request.Builder ofSurface(@android.annotation.NonNull android.view.Surface source) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public static android.view.PixelCopy.Request.Builder ofSurface(@android.annotation.NonNull android.view.SurfaceView source) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.view.PixelCopy.Request.Builder setSourceRect(@android.annotation.Nullable android.graphics.Rect srcRect) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.view.PixelCopy.Request.Builder setDestinationBitmap(@android.annotation.Nullable android.graphics.Bitmap destination) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.view.PixelCopy.Request build() { throw new RuntimeException("Stub!"); }
}

}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Result {

Result() { throw new RuntimeException("Stub!"); }

public int getStatus() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.graphics.Bitmap getBitmap() { throw new RuntimeException("Stub!"); }
}

}

